/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.HashAlgorithmTags;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.util.Strings;

class PGPUtil
implements HashAlgorithmTags {
    PGPUtil() {
    }

    static byte[] makeKeyFromPassPhrase(PGPDigestCalculator pGPDigestCalculator, int n, S2K s2K, char[] cArray) throws PGPException {
        String string = null;
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = 192;
                string = "DES_EDE";
                break;
            }
            case 1: {
                n2 = 128;
                string = "IDEA";
                break;
            }
            case 3: {
                n2 = 128;
                string = "CAST5";
                break;
            }
            case 4: {
                n2 = 128;
                string = "Blowfish";
                break;
            }
            case 5: {
                n2 = 128;
                string = "SAFER";
                break;
            }
            case 6: {
                n2 = 64;
                string = "DES";
                break;
            }
            case 7: {
                n2 = 128;
                string = "AES";
                break;
            }
            case 8: {
                n2 = 192;
                string = "AES";
                break;
            }
            case 9: {
                n2 = 256;
                string = "AES";
                break;
            }
            case 10: {
                n2 = 256;
                string = "Twofish";
                break;
            }
            case 11: {
                n2 = 128;
                string = "Camellia";
                break;
            }
            case 12: {
                n2 = 192;
                string = "Camellia";
                break;
            }
            case 13: {
                n2 = 256;
                string = "Camellia";
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + n);
            }
        }
        byte[] byArray = Strings.toUTF8ByteArray((char[])cArray);
        byte[] byArray2 = new byte[(n2 + 7) / 8];
        int n3 = 0;
        int n4 = 0;
        if (s2K != null) {
            if (s2K.getType() == 4) {
                throw new UnsupportedOperationException("Argon 2 not supported");
            }
            if (s2K.getHashAlgorithm() != pGPDigestCalculator.getAlgorithm()) {
                throw new PGPException("s2k/digestCalculator mismatch");
            }
        } else if (pGPDigestCalculator.getAlgorithm() != 1) {
            throw new PGPException("digestCalculator not for MD5");
        }
        OutputStream outputStream = pGPDigestCalculator.getOutputStream();
        try {
            while (n3 < byArray2.length) {
                block37: {
                    block36: {
                        if (s2K == null) break block36;
                        for (int i = 0; i != n4; ++i) {
                            outputStream.write(0);
                        }
                        byte[] byArray3 = s2K.getIV();
                        block16 : switch (s2K.getType()) {
                            case 0: {
                                outputStream.write(byArray);
                                break;
                            }
                            case 1: {
                                outputStream.write(byArray3);
                                outputStream.write(byArray);
                                break;
                            }
                            case 3: {
                                long l = s2K.getIterationCount();
                                outputStream.write(byArray3);
                                outputStream.write(byArray);
                                l -= (long)(byArray3.length + byArray.length);
                                while (l > 0L) {
                                    if (l < (long)byArray3.length) {
                                        outputStream.write(byArray3, 0, (int)l);
                                        break block16;
                                    }
                                    outputStream.write(byArray3);
                                    if ((l -= (long)byArray3.length) < (long)byArray.length) {
                                        outputStream.write(byArray, 0, (int)l);
                                        l = 0L;
                                        continue;
                                    }
                                    outputStream.write(byArray);
                                    l -= (long)byArray.length;
                                }
                                break block37;
                            }
                            default: {
                                throw new PGPException("unknown S2K type: " + s2K.getType());
                            }
                        }
                        break block37;
                    }
                    for (int i = 0; i != n4; ++i) {
                        outputStream.write(0);
                    }
                    outputStream.write(byArray);
                }
                outputStream.close();
                byte[] byArray4 = pGPDigestCalculator.getDigest();
                if (byArray4.length > byArray2.length - n3) {
                    System.arraycopy(byArray4, 0, byArray2, n3, byArray2.length - n3);
                } else {
                    System.arraycopy(byArray4, 0, byArray2, n3, byArray4.length);
                }
                n3 += byArray4.length;
                ++n4;
            }
        }
        catch (IOException iOException) {
            throw new PGPException("exception calculating digest: " + iOException.getMessage(), iOException);
        }
        for (int i = 0; i != byArray.length; ++i) {
            byArray[i] = 0;
        }
        return byArray2;
    }

    public static byte[] makeKeyFromPassPhrase(PGPDigestCalculatorProvider pGPDigestCalculatorProvider, int n, S2K s2K, char[] cArray) throws PGPException {
        PGPDigestCalculator pGPDigestCalculator = s2K != null && s2K.getType() != 4 ? pGPDigestCalculatorProvider.get(s2K.getHashAlgorithm()) : pGPDigestCalculatorProvider.get(1);
        return PGPUtil.makeKeyFromPassPhrase(pGPDigestCalculator, n, s2K, cArray);
    }
}

