/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.sandbox.search.TermAutomatonScorer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafSimScorer;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.Transition;

public class TermAutomatonQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(TermAutomatonQuery.class);
    private final String field;
    private final Automaton.Builder builder;
    Automaton det;
    private final Map<BytesRef, Integer> termToID = new HashMap<BytesRef, Integer>();
    private final Map<Integer, BytesRef> idToTerm = new HashMap<Integer, BytesRef>();
    private int anyTermID = -1;

    public TermAutomatonQuery(String field) {
        this.field = field;
        this.builder = new Automaton.Builder();
    }

    public int createState() {
        return this.builder.createState();
    }

    public void setAccept(int state, boolean accept) {
        this.builder.setAccept(state, accept);
    }

    public void addTransition(int source, int dest, String term) {
        this.addTransition(source, dest, new BytesRef((CharSequence)term));
    }

    public void addTransition(int source, int dest, BytesRef term) {
        if (term == null) {
            throw new NullPointerException("term should not be null");
        }
        this.builder.addTransition(source, dest, this.getTermID(term));
    }

    public void addAnyTransition(int source, int dest) {
        this.builder.addTransition(source, dest, this.getTermID(null));
    }

    public void finish() {
        this.finish(10000);
    }

    public void finish(int determinizeWorkLimit) {
        Automaton automaton = this.builder.finish();
        Transition t = new Transition();
        if (this.anyTermID != -1) {
            int i;
            int count = automaton.initTransition(0, t);
            for (int i2 = 0; i2 < count; ++i2) {
                automaton.getNextTransition(t);
                if (this.anyTermID < t.min || this.anyTermID > t.max) continue;
                throw new IllegalStateException("automaton cannot lead with an ANY transition");
            }
            int numStates = automaton.getNumStates();
            for (int i3 = 0; i3 < numStates; ++i3) {
                count = automaton.initTransition(i3, t);
                for (int j = 0; j < count; ++j) {
                    automaton.getNextTransition(t);
                    if (!automaton.isAccept(t.dest) || this.anyTermID < t.min || this.anyTermID > t.max) continue;
                    throw new IllegalStateException("automaton cannot end with an ANY transition");
                }
            }
            int termCount = this.termToID.size();
            Automaton newAutomaton = new Automaton();
            for (i = 0; i < numStates; ++i) {
                newAutomaton.createState();
                newAutomaton.setAccept(i, automaton.isAccept(i));
            }
            for (i = 0; i < numStates; ++i) {
                count = automaton.initTransition(i, t);
                for (int j = 0; j < count; ++j) {
                    int max;
                    int min;
                    automaton.getNextTransition(t);
                    if (t.min <= this.anyTermID && this.anyTermID <= t.max) {
                        min = 0;
                        max = termCount - 1;
                    } else {
                        min = t.min;
                        max = t.max;
                    }
                    newAutomaton.addTransition(t.source, t.dest, min, max);
                }
            }
            newAutomaton.finishState();
            automaton = newAutomaton;
        }
        this.det = Operations.removeDeadStates((Automaton)Operations.determinize((Automaton)automaton, (int)determinizeWorkLimit));
        if (this.det.isAccept(0)) {
            throw new IllegalStateException("cannot accept the empty string");
        }
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        HashMap<Integer, TermStates> termStates = new HashMap<Integer, TermStates>();
        for (Map.Entry<BytesRef, Integer> ent : this.termToID.entrySet()) {
            if (ent.getKey() == null) continue;
            termStates.put(ent.getValue(), TermStates.build((IndexSearcher)searcher, (Term)new Term(this.field, ent.getKey()), (boolean)scoreMode.needsScores()));
        }
        return new TermAutomatonWeight(this.det, searcher, termStates, boost);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("TermAutomatonQuery(field=");
        sb.append(this.field);
        if (this.det != null) {
            sb.append(" numStates=");
            sb.append(this.det.getNumStates());
        }
        sb.append(')');
        return sb.toString();
    }

    private int getTermID(BytesRef term) {
        Integer id = this.termToID.get(term);
        if (id == null) {
            id = this.termToID.size();
            if (term != null) {
                term = BytesRef.deepCopyOf((BytesRef)term);
            }
            this.termToID.put(term, id);
            this.idToTerm.put(id, term);
            if (term == null) {
                this.anyTermID = id;
            }
        }
        return id;
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((TermAutomatonQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private static boolean checkFinished(TermAutomatonQuery q) {
        if (q.det == null) {
            throw new IllegalStateException("Call finish first on: " + q);
        }
        return true;
    }

    private boolean equalsTo(TermAutomatonQuery other) {
        return TermAutomatonQuery.checkFinished(this) && TermAutomatonQuery.checkFinished(other) && other == this;
    }

    public int hashCode() {
        TermAutomatonQuery.checkFinished(this);
        return System.identityHashCode((Object)this);
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject((Object)this.builder) + RamUsageEstimator.sizeOfObject((Object)this.det) + RamUsageEstimator.sizeOfObject((Object)this.field) + RamUsageEstimator.sizeOfObject(this.idToTerm) + RamUsageEstimator.sizeOfObject(this.termToID);
    }

    public String toDot() {
        StringBuilder b = new StringBuilder();
        b.append("digraph Automaton {\n");
        b.append("  rankdir = LR\n");
        int numStates = this.det.getNumStates();
        if (numStates > 0) {
            b.append("  initial [shape=plaintext,label=\"0\"]\n");
            b.append("  initial -> 0\n");
        }
        Transition t = new Transition();
        for (int state = 0; state < numStates; ++state) {
            b.append("  ");
            b.append(state);
            if (this.det.isAccept(state)) {
                b.append(" [shape=doublecircle,label=\"").append(state).append("\"]\n");
            } else {
                b.append(" [shape=circle,label=\"").append(state).append("\"]\n");
            }
            int numTransitions = this.det.initTransition(state, t);
            for (int i = 0; i < numTransitions; ++i) {
                this.det.getNextTransition(t);
                assert (t.max >= t.min);
                for (int j = t.min; j <= t.max; ++j) {
                    b.append("  ");
                    b.append(state);
                    b.append(" -> ");
                    b.append(t.dest);
                    b.append(" [label=\"");
                    if (j == this.anyTermID) {
                        b.append('*');
                    } else {
                        b.append(this.idToTerm.get(j).utf8ToString());
                    }
                    b.append("\"]\n");
                }
            }
        }
        b.append('}');
        return b.toString();
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (Operations.isEmpty((Automaton)this.det)) {
            return new MatchNoDocsQuery();
        }
        IntsRef single = Operations.getSingleton((Automaton)this.det);
        if (single != null && single.length == 1) {
            return new TermQuery(new Term(this.field, this.idToTerm.get(single.ints[single.offset])));
        }
        MultiPhraseQuery.Builder mpq = new MultiPhraseQuery.Builder();
        PhraseQuery.Builder pq = new PhraseQuery.Builder();
        Transition t = new Transition();
        int state = 0;
        int pos = 0;
        block0: while (true) {
            int count;
            if ((count = this.det.initTransition(state, t)) == 0) {
                if (this.det.isAccept(state)) break;
                mpq = null;
                pq = null;
                break;
            }
            if (this.det.isAccept(state)) {
                mpq = null;
                pq = null;
                break;
            }
            int dest = -1;
            ArrayList<Term> terms = new ArrayList<Term>();
            boolean matchesAny = false;
            for (int i = 0; i < count; ++i) {
                this.det.getNextTransition(t);
                if (i == 0) {
                    dest = t.dest;
                } else if (dest != t.dest) {
                    mpq = null;
                    pq = null;
                    break block0;
                }
                if (matchesAny |= this.anyTermID >= t.min && this.anyTermID <= t.max) continue;
                for (int termID = t.min; termID <= t.max; ++termID) {
                    terms.add(new Term(this.field, this.idToTerm.get(termID)));
                }
            }
            if (!matchesAny) {
                mpq.add(terms.toArray(new Term[terms.size()]), pos);
                if (pq != null) {
                    if (terms.size() == 1) {
                        pq.add((Term)terms.get(0), pos);
                    } else {
                        pq = null;
                    }
                }
            }
            state = dest;
            ++pos;
        }
        if (pq != null) {
            return pq.build();
        }
        if (mpq != null) {
            return mpq.build();
        }
        return this;
    }

    public void visit(QueryVisitor visitor) {
        if (!visitor.acceptField(this.field)) {
            return;
        }
        QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.SHOULD, (Query)this);
        for (BytesRef term : this.termToID.keySet()) {
            v.consumeTerms((Query)this, new Term[]{new Term(this.field, term)});
        }
    }

    final class TermAutomatonWeight
    extends Weight {
        final Automaton automaton;
        private final Map<Integer, TermStates> termStates;
        private final Similarity.SimScorer stats;
        private final Similarity similarity;

        public TermAutomatonWeight(Automaton automaton, IndexSearcher searcher, Map<Integer, TermStates> termStates, float boost) throws IOException {
            super((Query)TermAutomatonQuery.this);
            this.automaton = automaton;
            this.termStates = termStates;
            this.similarity = searcher.getSimilarity();
            ArrayList<TermStatistics> allTermStats = new ArrayList<TermStatistics>();
            for (Map.Entry<Integer, BytesRef> ent : TermAutomatonQuery.this.idToTerm.entrySet()) {
                TermStates ts;
                Integer termID = ent.getKey();
                if (ent.getValue() == null || (ts = termStates.get(termID)).docFreq() <= 0) continue;
                allTermStats.add(searcher.termStatistics(new Term(TermAutomatonQuery.this.field, ent.getValue()), ts.docFreq(), ts.totalTermFreq()));
            }
            this.stats = allTermStats.isEmpty() ? null : this.similarity.scorer(boost, searcher.collectionStatistics(TermAutomatonQuery.this.field), allTermStats.toArray(new TermStatistics[allTermStats.size()]));
        }

        public String toString() {
            return "weight(" + TermAutomatonQuery.this + ")";
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            EnumAndScorer[] enums = new EnumAndScorer[TermAutomatonQuery.this.idToTerm.size()];
            boolean any = false;
            for (Map.Entry<Integer, TermStates> ent : this.termStates.entrySet()) {
                TermStates termStates = ent.getValue();
                assert (termStates.wasBuiltFor(ReaderUtil.getTopLevelContext((IndexReaderContext)context))) : "The top-reader used to create Weight is not the same as the current reader's top-reader (" + ReaderUtil.getTopLevelContext((IndexReaderContext)context);
                BytesRef term = TermAutomatonQuery.this.idToTerm.get(ent.getKey());
                TermState state = termStates.get(context);
                if (state == null) continue;
                TermsEnum termsEnum = context.reader().terms(TermAutomatonQuery.this.field).iterator();
                termsEnum.seekExact(term, state);
                enums[ent.getKey().intValue()] = new EnumAndScorer(ent.getKey(), termsEnum.postings(null, 24));
                any = true;
            }
            if (any) {
                return new TermAutomatonScorer(this, enums, TermAutomatonQuery.this.anyTermID, new LeafSimScorer(this.stats, context.reader(), TermAutomatonQuery.this.field, true));
            }
            return null;
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Scorer scorer = this.scorer(context);
            if (scorer == null) {
                return Explanation.noMatch((String)"No matching terms in the document", (Explanation[])new Explanation[0]);
            }
            int advancedDoc = scorer.iterator().advance(doc);
            if (advancedDoc != doc) {
                return Explanation.noMatch((String)"No matching terms in the document", (Explanation[])new Explanation[0]);
            }
            float score = scorer.score();
            LeafSimScorer leafSimScorer = ((TermAutomatonScorer)scorer).getLeafSimScorer();
            EnumAndScorer[] originalSubsOnDoc = ((TermAutomatonScorer)scorer).getOriginalSubsOnDoc();
            ArrayList<Explanation> termExplanations = new ArrayList<Explanation>();
            for (EnumAndScorer enumAndScorer : originalSubsOnDoc) {
                PostingsEnum postingsEnum;
                if (enumAndScorer == null || (postingsEnum = enumAndScorer.posEnum).docID() != doc) continue;
                float termScore = leafSimScorer.score(doc, (float)postingsEnum.freq());
                termExplanations.add(Explanation.match((Number)postingsEnum.freq(), (String)"term frequency in the document", (Explanation[])new Explanation[]{Explanation.match((Number)Float.valueOf(termScore), (String)("score for term: " + TermAutomatonQuery.this.idToTerm.get(enumAndScorer.termID).utf8ToString()), (Explanation[])new Explanation[0])}));
            }
            if (termExplanations.isEmpty()) {
                return Explanation.noMatch((String)"No matching terms in the document", (Explanation[])new Explanation[0]);
            }
            Explanation freqExplanation = Explanation.match((Number)Float.valueOf(score), (String)"TermAutomatonQuery, sum of:", termExplanations);
            return leafSimScorer.explain(doc, freqExplanation);
        }
    }

    static class EnumAndScorer {
        public final int termID;
        public final PostingsEnum posEnum;
        public int posLeft;
        public int pos;

        public EnumAndScorer(int termID, PostingsEnum posEnum) {
            this.termID = termID;
            this.posEnum = posEnum;
        }
    }
}

