complete -c pixi -n "__fish_use_subcommand" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_use_subcommand" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_use_subcommand" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_use_subcommand" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_use_subcommand" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_use_subcommand" -s V -l version -d 'Print version'
complete -c pixi -n "__fish_use_subcommand" -f -a "init" -d 'Creates a new project'
complete -c pixi -n "__fish_use_subcommand" -f -a "add" -d 'Adds dependencies to the project'
complete -c pixi -n "__fish_use_subcommand" -f -a "remove" -d 'Removes dependencies from the project'
complete -c pixi -n "__fish_use_subcommand" -f -a "install" -d 'Install all dependencies'
complete -c pixi -n "__fish_use_subcommand" -f -a "update" -d 'Update dependencies as recorded in the local lock file'
complete -c pixi -n "__fish_use_subcommand" -f -a "run" -d 'Runs task in project'
complete -c pixi -n "__fish_use_subcommand" -f -a "exec" -d 'Run a command in a temporary environment'
complete -c pixi -n "__fish_use_subcommand" -f -a "shell" -d 'Start a shell in the pixi environment of the project'
complete -c pixi -n "__fish_use_subcommand" -f -a "shell-hook" -d 'Print the pixi environment activation script'
complete -c pixi -n "__fish_use_subcommand" -f -a "project" -d 'Modify the project configuration file through the command line'
complete -c pixi -n "__fish_use_subcommand" -f -a "task" -d 'Interact with tasks in the project'
complete -c pixi -n "__fish_use_subcommand" -f -a "list" -d 'List project\'s packages'
complete -c pixi -n "__fish_use_subcommand" -f -a "tree" -d 'Show a tree of project dependencies'
complete -c pixi -n "__fish_use_subcommand" -f -a "global" -d 'Subcommand for global package management actions'
complete -c pixi -n "__fish_use_subcommand" -f -a "auth" -d 'Login to prefix.dev or anaconda.org servers to access private channels'
complete -c pixi -n "__fish_use_subcommand" -f -a "config" -d 'Configuration management'
complete -c pixi -n "__fish_use_subcommand" -f -a "info" -d 'Information about the system, project and environments for the current machine'
complete -c pixi -n "__fish_use_subcommand" -f -a "upload" -d 'Upload a conda package'
complete -c pixi -n "__fish_use_subcommand" -f -a "search" -d 'Search a conda package'
complete -c pixi -n "__fish_use_subcommand" -f -a "self-update" -d 'Update pixi to the latest version or a specific version'
complete -c pixi -n "__fish_use_subcommand" -f -a "clean" -d 'Clean the parts of your system which are touched by pixi. Defaults to cleaning the environments and task cache. Use the `cache` subcommand to clean the cache'
complete -c pixi -n "__fish_use_subcommand" -f -a "completion" -d 'Generates a completion script for a shell'
complete -c pixi -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from init" -s c -l channel -d 'Channels to use in the project' -r
complete -c pixi -n "__fish_seen_subcommand_from init" -s p -l platform -d 'Platforms that the project supports' -r
complete -c pixi -n "__fish_seen_subcommand_from init" -s i -l import -d 'Environment.yml file to bootstrap the project' -r -F
complete -c pixi -n "__fish_seen_subcommand_from init" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from init" -l pyproject -d 'Create a pyproject.toml manifest instead of a pixi.toml manifest'
complete -c pixi -n "__fish_seen_subcommand_from init" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from init" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from init" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from init" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from add" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from add" -s p -l platform -d 'The platform(s) for which the dependency should be modified' -r
complete -c pixi -n "__fish_seen_subcommand_from add" -s f -l feature -d 'The feature for which the dependency should be modified' -r
complete -c pixi -n "__fish_seen_subcommand_from add" -l auth-file -d 'Path to the file containing the authentication token' -r -F
complete -c pixi -n "__fish_seen_subcommand_from add" -l pypi-keyring-provider -d 'Specifies if we want to use uv keyring provider' -r -f -a "{disabled	'',subprocess	''}"
complete -c pixi -n "__fish_seen_subcommand_from add" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from add" -l host -d 'The specified dependencies are host dependencies. Conflicts with `build` and `pypi`'
complete -c pixi -n "__fish_seen_subcommand_from add" -l build -d 'The specified dependencies are build dependencies. Conflicts with `host` and `pypi`'
complete -c pixi -n "__fish_seen_subcommand_from add" -l pypi -d 'The specified dependencies are pypi dependencies. Conflicts with `host` and `build`'
complete -c pixi -n "__fish_seen_subcommand_from add" -l no-lockfile-update -d 'Don\'t update lockfile, implies the no-install as well'
complete -c pixi -n "__fish_seen_subcommand_from add" -l no-install -d 'Don\'t modify the environment, only modify the lock-file'
complete -c pixi -n "__fish_seen_subcommand_from add" -l tls-no-verify -d 'Do not verify the TLS certificate of the server'
complete -c pixi -n "__fish_seen_subcommand_from add" -l editable -d 'Whether the pypi requirement should be editable'
complete -c pixi -n "__fish_seen_subcommand_from add" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from add" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from add" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from remove" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from remove" -s p -l platform -d 'The platform(s) for which the dependency should be modified' -r
complete -c pixi -n "__fish_seen_subcommand_from remove" -s f -l feature -d 'The feature for which the dependency should be modified' -r
complete -c pixi -n "__fish_seen_subcommand_from remove" -l auth-file -d 'Path to the file containing the authentication token' -r -F
complete -c pixi -n "__fish_seen_subcommand_from remove" -l pypi-keyring-provider -d 'Specifies if we want to use uv keyring provider' -r -f -a "{disabled	'',subprocess	''}"
complete -c pixi -n "__fish_seen_subcommand_from remove" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from remove" -l host -d 'The specified dependencies are host dependencies. Conflicts with `build` and `pypi`'
complete -c pixi -n "__fish_seen_subcommand_from remove" -l build -d 'The specified dependencies are build dependencies. Conflicts with `host` and `pypi`'
complete -c pixi -n "__fish_seen_subcommand_from remove" -l pypi -d 'The specified dependencies are pypi dependencies. Conflicts with `host` and `build`'
complete -c pixi -n "__fish_seen_subcommand_from remove" -l no-lockfile-update -d 'Don\'t update lockfile, implies the no-install as well'
complete -c pixi -n "__fish_seen_subcommand_from remove" -l no-install -d 'Don\'t modify the environment, only modify the lock-file'
complete -c pixi -n "__fish_seen_subcommand_from remove" -l tls-no-verify -d 'Do not verify the TLS certificate of the server'
complete -c pixi -n "__fish_seen_subcommand_from remove" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from remove" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from remove" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from remove" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from install" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from install" -s e -l environment -d 'The environment to install' -r
complete -c pixi -n "__fish_seen_subcommand_from install" -l auth-file -d 'Path to the file containing the authentication token' -r -F
complete -c pixi -n "__fish_seen_subcommand_from install" -l pypi-keyring-provider -d 'Specifies if we want to use uv keyring provider' -r -f -a "{disabled	'',subprocess	''}"
complete -c pixi -n "__fish_seen_subcommand_from install" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from install" -l frozen -d 'Install the environment as defined in the lockfile, doesn\'t update lockfile if it isn\'t up-to-date with the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from install" -l locked -d 'Check if lockfile is up-to-date before installing the environment, aborts when lockfile isn\'t up-to-date with the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from install" -l tls-no-verify -d 'Do not verify the TLS certificate of the server'
complete -c pixi -n "__fish_seen_subcommand_from install" -s a -l all
complete -c pixi -n "__fish_seen_subcommand_from install" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from install" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from install" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from install" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from update" -l auth-file -d 'Path to the file containing the authentication token' -r -F
complete -c pixi -n "__fish_seen_subcommand_from update" -l pypi-keyring-provider -d 'Specifies if we want to use uv keyring provider' -r -f -a "{disabled	'',subprocess	''}"
complete -c pixi -n "__fish_seen_subcommand_from update" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from update" -s e -l environment -d 'The environments to update. If none is specified, all environments are updated' -r
complete -c pixi -n "__fish_seen_subcommand_from update" -s p -l platform -d 'The platforms to update. If none is specified, all platforms are updated' -r
complete -c pixi -n "__fish_seen_subcommand_from update" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from update" -l tls-no-verify -d 'Do not verify the TLS certificate of the server'
complete -c pixi -n "__fish_seen_subcommand_from update" -l no-install -d 'Don\'t install the (solve) environments needed for pypi-dependencies solving'
complete -c pixi -n "__fish_seen_subcommand_from update" -s n -l dry-run -d 'Don\'t actually write the lockfile or update any environment'
complete -c pixi -n "__fish_seen_subcommand_from update" -l json
complete -c pixi -n "__fish_seen_subcommand_from update" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from update" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from update" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from update" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from run" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from run" -s e -l environment -d 'The environment to run the task in' -r
complete -c pixi -n "__fish_seen_subcommand_from run" -l auth-file -d 'Path to the file containing the authentication token' -r -F
complete -c pixi -n "__fish_seen_subcommand_from run" -l pypi-keyring-provider -d 'Specifies if we want to use uv keyring provider' -r -f -a "{disabled	'',subprocess	''}"
complete -c pixi -n "__fish_seen_subcommand_from run" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from run" -l frozen -d 'Install the environment as defined in the lockfile, doesn\'t update lockfile if it isn\'t up-to-date with the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from run" -l locked -d 'Check if lockfile is up-to-date before installing the environment, aborts when lockfile isn\'t up-to-date with the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from run" -l tls-no-verify -d 'Do not verify the TLS certificate of the server'
complete -c pixi -n "__fish_seen_subcommand_from run" -l clean-env -d 'Use a clean environment to run the task'
complete -c pixi -n "__fish_seen_subcommand_from run" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from run" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from run" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from run" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from exec" -s s -l spec -d 'Matchspecs of packages to install. If this is not provided, the package is guessed from the command' -r
complete -c pixi -n "__fish_seen_subcommand_from exec" -s c -l channel -d 'The channel to install the packages from' -r
complete -c pixi -n "__fish_seen_subcommand_from exec" -l auth-file -d 'Path to the file containing the authentication token' -r -F
complete -c pixi -n "__fish_seen_subcommand_from exec" -l pypi-keyring-provider -d 'Specifies if we want to use uv keyring provider' -r -f -a "{disabled	'',subprocess	''}"
complete -c pixi -n "__fish_seen_subcommand_from exec" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from exec" -l force-reinstall -d 'If specified a new environment is always created even if one already exists'
complete -c pixi -n "__fish_seen_subcommand_from exec" -l tls-no-verify -d 'Do not verify the TLS certificate of the server'
complete -c pixi -n "__fish_seen_subcommand_from exec" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from exec" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from exec" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from exec" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from shell" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from shell" -s e -l environment -d 'The environment to activate in the shell' -r
complete -c pixi -n "__fish_seen_subcommand_from shell" -l auth-file -d 'Path to the file containing the authentication token' -r -F
complete -c pixi -n "__fish_seen_subcommand_from shell" -l pypi-keyring-provider -d 'Specifies if we want to use uv keyring provider' -r -f -a "{disabled	'',subprocess	''}"
complete -c pixi -n "__fish_seen_subcommand_from shell" -l change-ps1 -d 'Do not change the PS1 variable when starting a prompt' -r -f -a "{true	'',false	''}"
complete -c pixi -n "__fish_seen_subcommand_from shell" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from shell" -l frozen -d 'Install the environment as defined in the lockfile, doesn\'t update lockfile if it isn\'t up-to-date with the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from shell" -l locked -d 'Check if lockfile is up-to-date before installing the environment, aborts when lockfile isn\'t up-to-date with the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from shell" -l tls-no-verify -d 'Do not verify the TLS certificate of the server'
complete -c pixi -n "__fish_seen_subcommand_from shell" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from shell" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from shell" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from shell" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from shell-hook" -s s -l shell -d 'Sets the shell, options: [`bash`,  `zsh`,  `xonsh`,  `cmd`, `powershell`,  `fish`,  `nushell`]' -r
complete -c pixi -n "__fish_seen_subcommand_from shell-hook" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from shell-hook" -s e -l environment -d 'The environment to activate in the script' -r
complete -c pixi -n "__fish_seen_subcommand_from shell-hook" -l auth-file -d 'Path to the file containing the authentication token' -r -F
complete -c pixi -n "__fish_seen_subcommand_from shell-hook" -l pypi-keyring-provider -d 'Specifies if we want to use uv keyring provider' -r -f -a "{disabled	'',subprocess	''}"
complete -c pixi -n "__fish_seen_subcommand_from shell-hook" -l change-ps1 -d 'Do not change the PS1 variable when starting a prompt' -r -f -a "{true	'',false	''}"
complete -c pixi -n "__fish_seen_subcommand_from shell-hook" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from shell-hook" -l frozen -d 'Install the environment as defined in the lockfile, doesn\'t update lockfile if it isn\'t up-to-date with the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from shell-hook" -l locked -d 'Check if lockfile is up-to-date before installing the environment, aborts when lockfile isn\'t up-to-date with the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from shell-hook" -l json -d 'Emit the environment variables set by running the activation as JSON'
complete -c pixi -n "__fish_seen_subcommand_from shell-hook" -l tls-no-verify -d 'Do not verify the TLS certificate of the server'
complete -c pixi -n "__fish_seen_subcommand_from shell-hook" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from shell-hook" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from shell-hook" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from shell-hook" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -f -a "channel" -d 'Commands to manage project channels'
complete -c pixi -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -f -a "description" -d 'Commands to manage project description'
complete -c pixi -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -f -a "platform" -d 'Commands to manage project platforms'
complete -c pixi -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -f -a "version" -d 'Commands to manage project version'
complete -c pixi -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -f -a "environment" -d 'Commands to manage project environments'
complete -c pixi -n "__fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Adds a channel to the project file and updates the lockfile'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List the channels in the project file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove channel(s) from the project file and updates the lockfile'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from add" -s f -l feature -d 'The name of the feature to add the channel to' -r
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from add" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from add" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from add" -l no-install -d 'Don\'t update the environment, only add changed packages to the lock-file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from add" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from add" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from add" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from list" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from list" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from list" -l urls -d 'Whether to display the channel\'s names or urls'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from list" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from list" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from list" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from remove" -s f -l feature -d 'The name of the feature to remove the channel from' -r
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from remove" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from remove" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from remove" -l no-install -d 'Don\'t update the environment, only remove the channel(s) from the lock-file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from remove" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from remove" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from remove" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Adds a channel to the project file and updates the lockfile'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List the channels in the project file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove channel(s) from the project file and updates the lockfile'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from help" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from help" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from help" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from help" -f -a "get" -d 'Get the project description'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from help" -f -a "set" -d 'Set the project description'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and __fish_seen_subcommand_from get" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and __fish_seen_subcommand_from get" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and __fish_seen_subcommand_from get" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and __fish_seen_subcommand_from get" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and __fish_seen_subcommand_from get" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and __fish_seen_subcommand_from get" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and __fish_seen_subcommand_from set" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and __fish_seen_subcommand_from set" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and __fish_seen_subcommand_from set" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and __fish_seen_subcommand_from set" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and __fish_seen_subcommand_from set" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and __fish_seen_subcommand_from set" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from help" -f -a "get" -d 'Get the project description'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from help" -f -a "set" -d 'Set the project description'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Adds a platform(s) to the project file and updates the lockfile'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List the platforms in the project file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove platform(s) from the project file and updates the lockfile'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from add" -s f -l feature -d 'The name of the feature to add the platform to' -r
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from add" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from add" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from add" -l no-install -d 'Don\'t update the environment, only add changed packages to the lock-file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from add" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from add" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from add" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from list" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from list" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from list" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from list" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from list" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from remove" -s f -l feature -d 'The name of the feature to remove the platform from' -r
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from remove" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from remove" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from remove" -l no-install -d 'Don\'t update the environment, only remove the platform(s) from the lock-file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from remove" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from remove" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from remove" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Adds a platform(s) to the project file and updates the lockfile'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List the platforms in the project file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove platform(s) from the project file and updates the lockfile'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -f -a "get" -d 'Get the project version'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -f -a "set" -d 'Set the project version'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -f -a "major" -d 'Bump the project version to MAJOR'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -f -a "minor" -d 'Bump the project version to MINOR'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -f -a "patch" -d 'Bump the project version to PATCH'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from get" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from get" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from get" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from get" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from get" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from get" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from set" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from set" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from set" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from set" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from set" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from set" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from major" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from major" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from major" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from major" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from major" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from major" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from minor" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from minor" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from minor" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from minor" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from minor" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from minor" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from patch" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from patch" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from patch" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from patch" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from patch" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from patch" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -f -a "get" -d 'Get the project version'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -f -a "set" -d 'Set the project version'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -f -a "major" -d 'Bump the project version to MAJOR'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -f -a "minor" -d 'Bump the project version to MINOR'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -f -a "patch" -d 'Bump the project version to PATCH'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Adds an environment to the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List the environments in the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove an environment from the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from add" -s f -l feature -d 'Features to add to the environment' -r
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from add" -l solve-group -d 'The solve-group to add the environment to' -r
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from add" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from add" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from add" -l no-default-feature -d 'Don\'t include the default feature in the environment'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from add" -l force -d 'Update the manifest even if the environment already exists'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from add" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from add" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from add" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from list" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from list" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from list" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from list" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from list" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from remove" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from remove" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from remove" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from remove" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from remove" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Adds an environment to the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List the environments in the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove an environment from the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -f -a "channel" -d 'Commands to manage project channels'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -f -a "description" -d 'Commands to manage project description'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -f -a "platform" -d 'Commands to manage project platforms'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -f -a "version" -d 'Commands to manage project version'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -f -a "environment" -d 'Commands to manage project environments'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "add" -d 'Adds a channel to the project file and updates the lockfile'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "list" -d 'List the channels in the project file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "remove" -d 'Remove channel(s) from the project file and updates the lockfile'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set" -f -a "get" -d 'Get the project description'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set" -f -a "set" -d 'Set the project description'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "add" -d 'Adds a platform(s) to the project file and updates the lockfile'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "list" -d 'List the platforms in the project file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "remove" -d 'Remove platform(s) from the project file and updates the lockfile'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch" -f -a "get" -d 'Get the project version'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch" -f -a "set" -d 'Set the project version'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch" -f -a "major" -d 'Bump the project version to MAJOR'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch" -f -a "minor" -d 'Bump the project version to MINOR'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch" -f -a "patch" -d 'Bump the project version to PATCH'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "add" -d 'Adds an environment to the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "list" -d 'List the environments in the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from project; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "remove" -d 'Remove an environment from the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from task; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from task; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from task; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from task; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from task; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from task; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from task; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Add a command to the project'
complete -c pixi -n "__fish_seen_subcommand_from task; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove a command from the project'
complete -c pixi -n "__fish_seen_subcommand_from task; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "alias" -d 'Alias another specific command'
complete -c pixi -n "__fish_seen_subcommand_from task; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all tasks in the project'
complete -c pixi -n "__fish_seen_subcommand_from task; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from add" -l depends-on -d 'Depends on these other commands' -r
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from add" -s p -l platform -d 'The platform for which the task should be added' -r
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from add" -s f -l feature -d 'The feature for which the task should be added' -r
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from add" -l cwd -d 'The working directory relative to the root of the project' -r -F
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from add" -l env -d 'The environment variable to set, use --env key=value multiple times for more than one variable' -r
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from add" -l description -d 'A description of the task to be added' -r
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from add" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from add" -l clean-env -d 'Isolate the task from the shell environment, and only use the pixi environment to run the task'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from add" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from add" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from add" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from remove" -s p -l platform -d 'The platform for which the task should be removed' -r
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from remove" -s f -l feature -d 'The feature for which the task should be removed' -r
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from remove" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from remove" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from remove" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from remove" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from alias" -s p -l platform -d 'The platform for which the alias should be added' -r
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from alias" -l description -d 'The description of the alias task' -r
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from alias" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from alias" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from alias" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from alias" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from alias" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from list" -s e -l environment -d 'The environment the list should be generated for. If not specified, the default environment is used' -r
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from list" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from list" -s s -l summary -d 'Tasks available for this machine per environment'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from list" -l machine-readable -d 'Output the list of tasks from all environments in machine readable format (space delimited) this output is used for autocomplete by `pixi run`'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from list" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from list" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from list" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Add a command to the project'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove a command from the project'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "alias" -d 'Alias another specific command'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all tasks in the project'
complete -c pixi -n "__fish_seen_subcommand_from task; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from list" -l platform -d 'The platform to list packages for. Defaults to the current platform' -r
complete -c pixi -n "__fish_seen_subcommand_from list" -l sort-by -d 'Sorting strategy' -r -f -a "{size	'',name	'',kind	''}"
complete -c pixi -n "__fish_seen_subcommand_from list" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from list" -s e -l environment -d 'The environment to list packages for. Defaults to the default environment' -r
complete -c pixi -n "__fish_seen_subcommand_from list" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from list" -l json -d 'Whether to output in json format'
complete -c pixi -n "__fish_seen_subcommand_from list" -l json-pretty -d 'Whether to output in pretty json format'
complete -c pixi -n "__fish_seen_subcommand_from list" -l frozen -d 'Install the environment as defined in the lockfile, doesn\'t update lockfile if it isn\'t up-to-date with the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from list" -l locked -d 'Check if lockfile is up-to-date before installing the environment, aborts when lockfile isn\'t up-to-date with the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from list" -l no-install -d 'Don\'t install the environment for pypi solving, only update the lock-file if it can solve without installing'
complete -c pixi -n "__fish_seen_subcommand_from list" -s x -l explicit -d 'Only list packages that are explicitly defined in the project'
complete -c pixi -n "__fish_seen_subcommand_from list" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from list" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from list" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from tree" -s p -l platform -d 'The platform to list packages for. Defaults to the current platform' -r
complete -c pixi -n "__fish_seen_subcommand_from tree" -l manifest-path -d 'The path to \'pixi.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from tree" -s e -l environment -d 'The environment to list packages for. Defaults to the default environment' -r
complete -c pixi -n "__fish_seen_subcommand_from tree" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from tree" -l frozen -d 'Install the environment as defined in the lockfile, doesn\'t update lockfile if it isn\'t up-to-date with the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from tree" -l locked -d 'Check if lockfile is up-to-date before installing the environment, aborts when lockfile isn\'t up-to-date with the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from tree" -l no-install -d 'Don\'t install the environment for pypi solving, only update the lock-file if it can solve without installing'
complete -c pixi -n "__fish_seen_subcommand_from tree" -s i -l invert -d 'Invert tree and show what depends on given package in the regex argument'
complete -c pixi -n "__fish_seen_subcommand_from tree" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from tree" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from tree" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from tree" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from global; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from global; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from global; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from global; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from global; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from global; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -f -a "install" -d 'Installs the defined package in a global accessible location'
complete -c pixi -n "__fish_seen_subcommand_from global; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -f -a "remove" -d 'Removes a package previously installed into a globally accessible location via `pixi global install`'
complete -c pixi -n "__fish_seen_subcommand_from global; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -f -a "list" -d 'Lists all packages previously installed into a globally accessible location via `pixi global install`'
complete -c pixi -n "__fish_seen_subcommand_from global; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -f -a "upgrade" -d 'Upgrade specific package which is installed globally'
complete -c pixi -n "__fish_seen_subcommand_from global; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -f -a "upgrade-all" -d 'Upgrade all globally installed packages'
complete -c pixi -n "__fish_seen_subcommand_from global; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from install" -s c -l channel -d 'Represents the channels from which the package will be installed. Multiple channels can be specified by using this field multiple times' -r
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from install" -s p -l platform -r
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from install" -l auth-file -d 'Path to the file containing the authentication token' -r -F
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from install" -l pypi-keyring-provider -d 'Specifies if we want to use uv keyring provider' -r -f -a "{disabled	'',subprocess	''}"
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from install" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from install" -l tls-no-verify -d 'Do not verify the TLS certificate of the server'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from install" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from install" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from install" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from install" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from remove" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from remove" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from remove" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from remove" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from list" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from list" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from list" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from list" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade" -s c -l channel -d 'Represents the channels from which to upgrade specified package. Multiple channels can be specified by using this field multiple times' -r
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade" -l platform -d 'The platform to install the package for' -r
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade-all" -s c -l channel -d 'Represents the channels from which to upgrade packages. Multiple channels can be specified by using this field multiple times' -r
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade-all" -l auth-file -d 'Path to the file containing the authentication token' -r -F
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade-all" -l pypi-keyring-provider -d 'Specifies if we want to use uv keyring provider' -r -f -a "{disabled	'',subprocess	''}"
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade-all" -l platform -d 'The platform to install the package for' -r
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade-all" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade-all" -l tls-no-verify -d 'Do not verify the TLS certificate of the server'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade-all" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade-all" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade-all" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from upgrade-all" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -f -a "install" -d 'Installs the defined package in a global accessible location'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -f -a "remove" -d 'Removes a package previously installed into a globally accessible location via `pixi global install`'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -f -a "list" -d 'Lists all packages previously installed into a globally accessible location via `pixi global install`'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -f -a "upgrade" -d 'Upgrade specific package which is installed globally'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -f -a "upgrade-all" -d 'Upgrade all globally installed packages'
complete -c pixi -n "__fish_seen_subcommand_from global; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from help" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from help" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from help" -f -a "login" -d 'Store authentication information for a given host'
complete -c pixi -n "__fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from help" -f -a "logout" -d 'Remove authentication information for a given host'
complete -c pixi -n "__fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from login" -l token -d 'The token to use (for authentication with prefix.dev)' -r
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from login" -l username -d 'The username to use (for basic HTTP authentication)' -r
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from login" -l password -d 'The password to use (for basic HTTP authentication)' -r
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from login" -l conda-token -d 'The token to use on anaconda.org / quetz authentication' -r
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from login" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from login" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from login" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from login" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from login" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from logout" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from logout" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from logout" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from logout" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from logout" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from help" -f -a "login" -d 'Store authentication information for a given host'
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from help" -f -a "logout" -d 'Remove authentication information for a given host'
complete -c pixi -n "__fish_seen_subcommand_from auth; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -f -a "edit" -d 'Edit the configuration file'
complete -c pixi -n "__fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List configuration values'
complete -c pixi -n "__fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -f -a "prepend" -d 'Prepend a value to a list configuration key'
complete -c pixi -n "__fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -f -a "append" -d 'Append a value to a list configuration key'
complete -c pixi -n "__fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -f -a "set" -d 'Set a configuration value'
complete -c pixi -n "__fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -f -a "unset" -d 'Unset a configuration value'
complete -c pixi -n "__fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from edit" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from edit" -s l -l local -d 'Operation on project-local configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from edit" -s g -l global -d 'Operation on global configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from edit" -s s -l system -d 'Operation on system configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from edit" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from edit" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from edit" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from edit" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from list" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from list" -l json -d 'Output in JSON format'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from list" -s l -l local -d 'Operation on project-local configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from list" -s g -l global -d 'Operation on global configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from list" -s s -l system -d 'Operation on system configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from list" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from list" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from list" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from prepend" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from prepend" -s l -l local -d 'Operation on project-local configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from prepend" -s g -l global -d 'Operation on global configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from prepend" -s s -l system -d 'Operation on system configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from prepend" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from prepend" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from prepend" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from prepend" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from append" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from append" -s l -l local -d 'Operation on project-local configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from append" -s g -l global -d 'Operation on global configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from append" -s s -l system -d 'Operation on system configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from append" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from append" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from append" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from append" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from set" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from set" -s l -l local -d 'Operation on project-local configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from set" -s g -l global -d 'Operation on global configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from set" -s s -l system -d 'Operation on system configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from set" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from set" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from set" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from set" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from unset" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from unset" -s l -l local -d 'Operation on project-local configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from unset" -s g -l global -d 'Operation on global configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from unset" -s s -l system -d 'Operation on system configuration'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from unset" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from unset" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from unset" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from unset" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -f -a "edit" -d 'Edit the configuration file'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List configuration values'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -f -a "prepend" -d 'Prepend a value to a list configuration key'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -f -a "append" -d 'Append a value to a list configuration key'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -f -a "set" -d 'Set a configuration value'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -f -a "unset" -d 'Unset a configuration value'
complete -c pixi -n "__fish_seen_subcommand_from config; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from info" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from info" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from info" -l extended -d 'Show cache and environment size'
complete -c pixi -n "__fish_seen_subcommand_from info" -l json -d 'Whether to show the output as JSON or not'
complete -c pixi -n "__fish_seen_subcommand_from info" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from info" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from info" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from info" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from upload" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from upload" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from upload" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from upload" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from upload" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from search" -s c -l channel -d 'Channel to specifically search package, defaults to project channels or conda-forge' -r
complete -c pixi -n "__fish_seen_subcommand_from search" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from search" -s p -l platform -d 'The platform to search for, defaults to current platform' -r
complete -c pixi -n "__fish_seen_subcommand_from search" -s l -l limit -d 'Limit the number of search results' -r
complete -c pixi -n "__fish_seen_subcommand_from search" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from search" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from search" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from search" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from search" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from self-update" -l version -d 'The desired version (to downgrade or upgrade to). Update to the latest version if not specified' -r
complete -c pixi -n "__fish_seen_subcommand_from self-update" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from self-update" -l force -d 'Force the update even if the pixi binary is not found in the default location'
complete -c pixi -n "__fish_seen_subcommand_from self-update" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from self-update" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from self-update" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from self-update" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from cache; and not __fish_seen_subcommand_from help" -l manifest-path -d 'The path to \'pixi.toml\' or \'pyproject.toml\'' -r -F
complete -c pixi -n "__fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from cache; and not __fish_seen_subcommand_from help" -s e -l environment -d 'The environment directory to remove' -r
complete -c pixi -n "__fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from cache; and not __fish_seen_subcommand_from help" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from cache; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from cache; and not __fish_seen_subcommand_from help" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from cache; and not __fish_seen_subcommand_from help" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from cache; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from cache; and not __fish_seen_subcommand_from help" -f -a "cache" -d 'Clean the cache of your system which are touched by pixi'
complete -c pixi -n "__fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from cache; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from clean; and __fish_seen_subcommand_from cache" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from clean; and __fish_seen_subcommand_from cache" -l pypi -d 'Clean only the pypi related cache'
complete -c pixi -n "__fish_seen_subcommand_from clean; and __fish_seen_subcommand_from cache" -l conda -d 'Clean only the conda related cache'
complete -c pixi -n "__fish_seen_subcommand_from clean; and __fish_seen_subcommand_from cache" -l yes -d 'Answer yes to all questions'
complete -c pixi -n "__fish_seen_subcommand_from clean; and __fish_seen_subcommand_from cache" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from clean; and __fish_seen_subcommand_from cache" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from clean; and __fish_seen_subcommand_from cache" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from clean; and __fish_seen_subcommand_from cache" -s h -l help -d 'Print help'
complete -c pixi -n "__fish_seen_subcommand_from clean; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from cache; and not __fish_seen_subcommand_from help" -f -a "cache" -d 'Clean the cache of your system which are touched by pixi'
complete -c pixi -n "__fish_seen_subcommand_from clean; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from cache; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from completion" -s s -l shell -d 'The shell to generate a completion script for' -r -f -a "{bash	'Bourne Again SHell (bash)',elvish	'Elvish shell',fish	'Friendly Interactive SHell (fish)',nushell	'Nushell',powershell	'PowerShell',zsh	'Z SHell (zsh)'}"
complete -c pixi -n "__fish_seen_subcommand_from completion" -l color -d 'Whether the log needs to be colored' -r -f -a "{always	'',never	'',auto	''}"
complete -c pixi -n "__fish_seen_subcommand_from completion" -s v -l verbose -d 'Increase logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from completion" -s q -l quiet -d 'Decrease logging verbosity'
complete -c pixi -n "__fish_seen_subcommand_from completion" -l no-progress -d 'Hide all progress bars'
complete -c pixi -n "__fish_seen_subcommand_from completion" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "init" -d 'Creates a new project'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Adds dependencies to the project'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "remove" -d 'Removes dependencies from the project'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "install" -d 'Install all dependencies'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "update" -d 'Update dependencies as recorded in the local lock file'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "run" -d 'Runs task in project'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "exec" -d 'Run a command in a temporary environment'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "shell" -d 'Start a shell in the pixi environment of the project'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "shell-hook" -d 'Print the pixi environment activation script'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "project" -d 'Modify the project configuration file through the command line'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "task" -d 'Interact with tasks in the project'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List project\'s packages'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "tree" -d 'Show a tree of project dependencies'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "global" -d 'Subcommand for global package management actions'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "auth" -d 'Login to prefix.dev or anaconda.org servers to access private channels'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "config" -d 'Configuration management'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "info" -d 'Information about the system, project and environments for the current machine'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "upload" -d 'Upload a conda package'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "search" -d 'Search a conda package'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "self-update" -d 'Update pixi to the latest version or a specific version'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "clean" -d 'Clean the parts of your system which are touched by pixi. Defaults to cleaning the environments and task cache. Use the `cache` subcommand to clean the cache'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "completion" -d 'Generates a completion script for a shell'
complete -c pixi -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from init; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from update; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from exec; and not __fish_seen_subcommand_from shell; and not __fish_seen_subcommand_from shell-hook; and not __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from upload; and not __fish_seen_subcommand_from search; and not __fish_seen_subcommand_from self-update; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from completion; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment" -f -a "channel" -d 'Commands to manage project channels'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment" -f -a "description" -d 'Commands to manage project description'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment" -f -a "platform" -d 'Commands to manage project platforms'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment" -f -a "version" -d 'Commands to manage project version'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and not __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from environment" -f -a "environment" -d 'Commands to manage project environments'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "add" -d 'Adds a channel to the project file and updates the lockfile'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "list" -d 'List the channels in the project file'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and __fish_seen_subcommand_from channel; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "remove" -d 'Remove channel(s) from the project file and updates the lockfile'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set" -f -a "get" -d 'Get the project description'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and __fish_seen_subcommand_from description; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set" -f -a "set" -d 'Set the project description'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "add" -d 'Adds a platform(s) to the project file and updates the lockfile'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "list" -d 'List the platforms in the project file'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and __fish_seen_subcommand_from platform; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "remove" -d 'Remove platform(s) from the project file and updates the lockfile'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch" -f -a "get" -d 'Get the project version'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch" -f -a "set" -d 'Set the project version'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch" -f -a "major" -d 'Bump the project version to MAJOR'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch" -f -a "minor" -d 'Bump the project version to MINOR'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from get; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from major; and not __fish_seen_subcommand_from minor; and not __fish_seen_subcommand_from patch" -f -a "patch" -d 'Bump the project version to PATCH'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "add" -d 'Adds an environment to the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "list" -d 'List the environments in the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from project; and __fish_seen_subcommand_from environment; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from remove" -f -a "remove" -d 'Remove an environment from the manifest file'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list" -f -a "add" -d 'Add a command to the project'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list" -f -a "remove" -d 'Remove a command from the project'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list" -f -a "alias" -d 'Alias another specific command'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from task; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from alias; and not __fish_seen_subcommand_from list" -f -a "list" -d 'List all tasks in the project'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all" -f -a "install" -d 'Installs the defined package in a global accessible location'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all" -f -a "remove" -d 'Removes a package previously installed into a globally accessible location via `pixi global install`'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all" -f -a "list" -d 'Lists all packages previously installed into a globally accessible location via `pixi global install`'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all" -f -a "upgrade" -d 'Upgrade specific package which is installed globally'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from global; and not __fish_seen_subcommand_from install; and not __fish_seen_subcommand_from remove; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from upgrade; and not __fish_seen_subcommand_from upgrade-all" -f -a "upgrade-all" -d 'Upgrade all globally installed packages'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout" -f -a "login" -d 'Store authentication information for a given host'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from auth; and not __fish_seen_subcommand_from login; and not __fish_seen_subcommand_from logout" -f -a "logout" -d 'Remove authentication information for a given host'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset" -f -a "edit" -d 'Edit the configuration file'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset" -f -a "list" -d 'List configuration values'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset" -f -a "prepend" -d 'Prepend a value to a list configuration key'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset" -f -a "append" -d 'Append a value to a list configuration key'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset" -f -a "set" -d 'Set a configuration value'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from edit; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from prepend; and not __fish_seen_subcommand_from append; and not __fish_seen_subcommand_from set; and not __fish_seen_subcommand_from unset" -f -a "unset" -d 'Unset a configuration value'
complete -c pixi -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from cache" -f -a "cache" -d 'Clean the cache of your system which are touched by pixi'
