// This file is automatically generated.
// See tools/generate_linux_syscalls.zig for more info.

pub const X86 = enum(usize) {
    restart_syscall = 0,
    exit = 1,
    fork = 2,
    read = 3,
    write = 4,
    open = 5,
    close = 6,
    waitpid = 7,
    creat = 8,
    link = 9,
    unlink = 10,
    execve = 11,
    chdir = 12,
    time = 13,
    mknod = 14,
    chmod = 15,
    lchown = 16,
    @"break" = 17,
    oldstat = 18,
    lseek = 19,
    getpid = 20,
    mount = 21,
    umount = 22,
    setuid = 23,
    getuid = 24,
    stime = 25,
    ptrace = 26,
    alarm = 27,
    oldfstat = 28,
    pause = 29,
    utime = 30,
    stty = 31,
    gtty = 32,
    access = 33,
    nice = 34,
    ftime = 35,
    sync = 36,
    kill = 37,
    rename = 38,
    mkdir = 39,
    rmdir = 40,
    dup = 41,
    pipe = 42,
    times = 43,
    prof = 44,
    brk = 45,
    setgid = 46,
    getgid = 47,
    signal = 48,
    geteuid = 49,
    getegid = 50,
    acct = 51,
    umount2 = 52,
    lock = 53,
    ioctl = 54,
    fcntl = 55,
    mpx = 56,
    setpgid = 57,
    ulimit = 58,
    oldolduname = 59,
    umask = 60,
    chroot = 61,
    ustat = 62,
    dup2 = 63,
    getppid = 64,
    getpgrp = 65,
    setsid = 66,
    sigaction = 67,
    sgetmask = 68,
    ssetmask = 69,
    setreuid = 70,
    setregid = 71,
    sigsuspend = 72,
    sigpending = 73,
    sethostname = 74,
    setrlimit = 75,
    getrlimit = 76,
    getrusage = 77,
    gettimeofday = 78,
    settimeofday = 79,
    getgroups = 80,
    setgroups = 81,
    select = 82,
    symlink = 83,
    oldlstat = 84,
    readlink = 85,
    uselib = 86,
    swapon = 87,
    reboot = 88,
    readdir = 89,
    mmap = 90,
    munmap = 91,
    truncate = 92,
    ftruncate = 93,
    fchmod = 94,
    fchown = 95,
    getpriority = 96,
    setpriority = 97,
    profil = 98,
    statfs = 99,
    fstatfs = 100,
    ioperm = 101,
    socketcall = 102,
    syslog = 103,
    setitimer = 104,
    getitimer = 105,
    stat = 106,
    lstat = 107,
    fstat = 108,
    olduname = 109,
    iopl = 110,
    vhangup = 111,
    idle = 112,
    vm86old = 113,
    wait4 = 114,
    swapoff = 115,
    sysinfo = 116,
    ipc = 117,
    fsync = 118,
    sigreturn = 119,
    clone = 120,
    setdomainname = 121,
    uname = 122,
    modify_ldt = 123,
    adjtimex = 124,
    mprotect = 125,
    sigprocmask = 126,
    create_module = 127,
    init_module = 128,
    delete_module = 129,
    get_kernel_syms = 130,
    quotactl = 131,
    getpgid = 132,
    fchdir = 133,
    bdflush = 134,
    sysfs = 135,
    personality = 136,
    afs_syscall = 137,
    setfsuid = 138,
    setfsgid = 139,
    _llseek = 140,
    getdents = 141,
    _newselect = 142,
    flock = 143,
    msync = 144,
    readv = 145,
    writev = 146,
    getsid = 147,
    fdatasync = 148,
    _sysctl = 149,
    mlock = 150,
    munlock = 151,
    mlockall = 152,
    munlockall = 153,
    sched_setparam = 154,
    sched_getparam = 155,
    sched_setscheduler = 156,
    sched_getscheduler = 157,
    sched_yield = 158,
    sched_get_priority_max = 159,
    sched_get_priority_min = 160,
    sched_rr_get_interval = 161,
    nanosleep = 162,
    mremap = 163,
    setresuid = 164,
    getresuid = 165,
    vm86 = 166,
    query_module = 167,
    poll = 168,
    nfsservctl = 169,
    setresgid = 170,
    getresgid = 171,
    prctl = 172,
    rt_sigreturn = 173,
    rt_sigaction = 174,
    rt_sigprocmask = 175,
    rt_sigpending = 176,
    rt_sigtimedwait = 177,
    rt_sigqueueinfo = 178,
    rt_sigsuspend = 179,
    pread64 = 180,
    pwrite64 = 181,
    chown = 182,
    getcwd = 183,
    capget = 184,
    capset = 185,
    sigaltstack = 186,
    sendfile = 187,
    getpmsg = 188,
    putpmsg = 189,
    vfork = 190,
    ugetrlimit = 191,
    mmap2 = 192,
    truncate64 = 193,
    ftruncate64 = 194,
    stat64 = 195,
    lstat64 = 196,
    fstat64 = 197,
    lchown32 = 198,
    getuid32 = 199,
    getgid32 = 200,
    geteuid32 = 201,
    getegid32 = 202,
    setreuid32 = 203,
    setregid32 = 204,
    getgroups32 = 205,
    setgroups32 = 206,
    fchown32 = 207,
    setresuid32 = 208,
    getresuid32 = 209,
    setresgid32 = 210,
    getresgid32 = 211,
    chown32 = 212,
    setuid32 = 213,
    setgid32 = 214,
    setfsuid32 = 215,
    setfsgid32 = 216,
    pivot_root = 217,
    mincore = 218,
    madvise = 219,
    getdents64 = 220,
    fcntl64 = 221,
    gettid = 224,
    readahead = 225,
    setxattr = 226,
    lsetxattr = 227,
    fsetxattr = 228,
    getxattr = 229,
    lgetxattr = 230,
    fgetxattr = 231,
    listxattr = 232,
    llistxattr = 233,
    flistxattr = 234,
    removexattr = 235,
    lremovexattr = 236,
    fremovexattr = 237,
    tkill = 238,
    sendfile64 = 239,
    futex = 240,
    sched_setaffinity = 241,
    sched_getaffinity = 242,
    set_thread_area = 243,
    get_thread_area = 244,
    io_setup = 245,
    io_destroy = 246,
    io_getevents = 247,
    io_submit = 248,
    io_cancel = 249,
    fadvise64 = 250,
    exit_group = 252,
    lookup_dcookie = 253,
    epoll_create = 254,
    epoll_ctl = 255,
    epoll_wait = 256,
    remap_file_pages = 257,
    set_tid_address = 258,
    timer_create = 259,
    timer_settime = 260,
    timer_gettime = 261,
    timer_getoverrun = 262,
    timer_delete = 263,
    clock_settime = 264,
    clock_gettime = 265,
    clock_getres = 266,
    clock_nanosleep = 267,
    statfs64 = 268,
    fstatfs64 = 269,
    tgkill = 270,
    utimes = 271,
    fadvise64_64 = 272,
    vserver = 273,
    mbind = 274,
    get_mempolicy = 275,
    set_mempolicy = 276,
    mq_open = 277,
    mq_unlink = 278,
    mq_timedsend = 279,
    mq_timedreceive = 280,
    mq_notify = 281,
    mq_getsetattr = 282,
    kexec_load = 283,
    waitid = 284,
    add_key = 286,
    request_key = 287,
    keyctl = 288,
    ioprio_set = 289,
    ioprio_get = 290,
    inotify_init = 291,
    inotify_add_watch = 292,
    inotify_rm_watch = 293,
    migrate_pages = 294,
    openat = 295,
    mkdirat = 296,
    mknodat = 297,
    fchownat = 298,
    futimesat = 299,
    fstatat64 = 300,
    unlinkat = 301,
    renameat = 302,
    linkat = 303,
    symlinkat = 304,
    readlinkat = 305,
    fchmodat = 306,
    faccessat = 307,
    pselect6 = 308,
    ppoll = 309,
    unshare = 310,
    set_robust_list = 311,
    get_robust_list = 312,
    splice = 313,
    sync_file_range = 314,
    tee = 315,
    vmsplice = 316,
    move_pages = 317,
    getcpu = 318,
    epoll_pwait = 319,
    utimensat = 320,
    signalfd = 321,
    timerfd_create = 322,
    eventfd = 323,
    fallocate = 324,
    timerfd_settime = 325,
    timerfd_gettime = 326,
    signalfd4 = 327,
    eventfd2 = 328,
    epoll_create1 = 329,
    dup3 = 330,
    pipe2 = 331,
    inotify_init1 = 332,
    preadv = 333,
    pwritev = 334,
    rt_tgsigqueueinfo = 335,
    perf_event_open = 336,
    recvmmsg = 337,
    fanotify_init = 338,
    fanotify_mark = 339,
    prlimit64 = 340,
    name_to_handle_at = 341,
    open_by_handle_at = 342,
    clock_adjtime = 343,
    syncfs = 344,
    sendmmsg = 345,
    setns = 346,
    process_vm_readv = 347,
    process_vm_writev = 348,
    kcmp = 349,
    finit_module = 350,
    sched_setattr = 351,
    sched_getattr = 352,
    renameat2 = 353,
    seccomp = 354,
    getrandom = 355,
    memfd_create = 356,
    bpf = 357,
    execveat = 358,
    socket = 359,
    socketpair = 360,
    bind = 361,
    connect = 362,
    listen = 363,
    accept4 = 364,
    getsockopt = 365,
    setsockopt = 366,
    getsockname = 367,
    getpeername = 368,
    sendto = 369,
    sendmsg = 370,
    recvfrom = 371,
    recvmsg = 372,
    shutdown = 373,
    userfaultfd = 374,
    membarrier = 375,
    mlock2 = 376,
    copy_file_range = 377,
    preadv2 = 378,
    pwritev2 = 379,
    pkey_mprotect = 380,
    pkey_alloc = 381,
    pkey_free = 382,
    statx = 383,
    arch_prctl = 384,
    io_pgetevents = 385,
    rseq = 386,
    semget = 393,
    semctl = 394,
    shmget = 395,
    shmctl = 396,
    shmat = 397,
    shmdt = 398,
    msgget = 399,
    msgsnd = 400,
    msgrcv = 401,
    msgctl = 402,
    clock_gettime64 = 403,
    clock_settime64 = 404,
    clock_adjtime64 = 405,
    clock_getres_time64 = 406,
    clock_nanosleep_time64 = 407,
    timer_gettime64 = 408,
    timer_settime64 = 409,
    timerfd_gettime64 = 410,
    timerfd_settime64 = 411,
    utimensat_time64 = 412,
    pselect6_time64 = 413,
    ppoll_time64 = 414,
    io_pgetevents_time64 = 416,
    recvmmsg_time64 = 417,
    mq_timedsend_time64 = 418,
    mq_timedreceive_time64 = 419,
    semtimedop_time64 = 420,
    rt_sigtimedwait_time64 = 421,
    futex_time64 = 422,
    sched_rr_get_interval_time64 = 423,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    memfd_secret = 447,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const X64 = enum(usize) {
    read = 0,
    write = 1,
    open = 2,
    close = 3,
    stat = 4,
    fstat = 5,
    lstat = 6,
    poll = 7,
    lseek = 8,
    mmap = 9,
    mprotect = 10,
    munmap = 11,
    brk = 12,
    rt_sigaction = 13,
    rt_sigprocmask = 14,
    rt_sigreturn = 15,
    ioctl = 16,
    pread64 = 17,
    pwrite64 = 18,
    readv = 19,
    writev = 20,
    access = 21,
    pipe = 22,
    select = 23,
    sched_yield = 24,
    mremap = 25,
    msync = 26,
    mincore = 27,
    madvise = 28,
    shmget = 29,
    shmat = 30,
    shmctl = 31,
    dup = 32,
    dup2 = 33,
    pause = 34,
    nanosleep = 35,
    getitimer = 36,
    alarm = 37,
    setitimer = 38,
    getpid = 39,
    sendfile = 40,
    socket = 41,
    connect = 42,
    accept = 43,
    sendto = 44,
    recvfrom = 45,
    sendmsg = 46,
    recvmsg = 47,
    shutdown = 48,
    bind = 49,
    listen = 50,
    getsockname = 51,
    getpeername = 52,
    socketpair = 53,
    setsockopt = 54,
    getsockopt = 55,
    clone = 56,
    fork = 57,
    vfork = 58,
    execve = 59,
    exit = 60,
    wait4 = 61,
    kill = 62,
    uname = 63,
    semget = 64,
    semop = 65,
    semctl = 66,
    shmdt = 67,
    msgget = 68,
    msgsnd = 69,
    msgrcv = 70,
    msgctl = 71,
    fcntl = 72,
    flock = 73,
    fsync = 74,
    fdatasync = 75,
    truncate = 76,
    ftruncate = 77,
    getdents = 78,
    getcwd = 79,
    chdir = 80,
    fchdir = 81,
    rename = 82,
    mkdir = 83,
    rmdir = 84,
    creat = 85,
    link = 86,
    unlink = 87,
    symlink = 88,
    readlink = 89,
    chmod = 90,
    fchmod = 91,
    chown = 92,
    fchown = 93,
    lchown = 94,
    umask = 95,
    gettimeofday = 96,
    getrlimit = 97,
    getrusage = 98,
    sysinfo = 99,
    times = 100,
    ptrace = 101,
    getuid = 102,
    syslog = 103,
    getgid = 104,
    setuid = 105,
    setgid = 106,
    geteuid = 107,
    getegid = 108,
    setpgid = 109,
    getppid = 110,
    getpgrp = 111,
    setsid = 112,
    setreuid = 113,
    setregid = 114,
    getgroups = 115,
    setgroups = 116,
    setresuid = 117,
    getresuid = 118,
    setresgid = 119,
    getresgid = 120,
    getpgid = 121,
    setfsuid = 122,
    setfsgid = 123,
    getsid = 124,
    capget = 125,
    capset = 126,
    rt_sigpending = 127,
    rt_sigtimedwait = 128,
    rt_sigqueueinfo = 129,
    rt_sigsuspend = 130,
    sigaltstack = 131,
    utime = 132,
    mknod = 133,
    uselib = 134,
    personality = 135,
    ustat = 136,
    statfs = 137,
    fstatfs = 138,
    sysfs = 139,
    getpriority = 140,
    setpriority = 141,
    sched_setparam = 142,
    sched_getparam = 143,
    sched_setscheduler = 144,
    sched_getscheduler = 145,
    sched_get_priority_max = 146,
    sched_get_priority_min = 147,
    sched_rr_get_interval = 148,
    mlock = 149,
    munlock = 150,
    mlockall = 151,
    munlockall = 152,
    vhangup = 153,
    modify_ldt = 154,
    pivot_root = 155,
    _sysctl = 156,
    prctl = 157,
    arch_prctl = 158,
    adjtimex = 159,
    setrlimit = 160,
    chroot = 161,
    sync = 162,
    acct = 163,
    settimeofday = 164,
    mount = 165,
    umount2 = 166,
    swapon = 167,
    swapoff = 168,
    reboot = 169,
    sethostname = 170,
    setdomainname = 171,
    iopl = 172,
    ioperm = 173,
    create_module = 174,
    init_module = 175,
    delete_module = 176,
    get_kernel_syms = 177,
    query_module = 178,
    quotactl = 179,
    nfsservctl = 180,
    getpmsg = 181,
    putpmsg = 182,
    afs_syscall = 183,
    tuxcall = 184,
    security = 185,
    gettid = 186,
    readahead = 187,
    setxattr = 188,
    lsetxattr = 189,
    fsetxattr = 190,
    getxattr = 191,
    lgetxattr = 192,
    fgetxattr = 193,
    listxattr = 194,
    llistxattr = 195,
    flistxattr = 196,
    removexattr = 197,
    lremovexattr = 198,
    fremovexattr = 199,
    tkill = 200,
    time = 201,
    futex = 202,
    sched_setaffinity = 203,
    sched_getaffinity = 204,
    set_thread_area = 205,
    io_setup = 206,
    io_destroy = 207,
    io_getevents = 208,
    io_submit = 209,
    io_cancel = 210,
    get_thread_area = 211,
    lookup_dcookie = 212,
    epoll_create = 213,
    epoll_ctl_old = 214,
    epoll_wait_old = 215,
    remap_file_pages = 216,
    getdents64 = 217,
    set_tid_address = 218,
    restart_syscall = 219,
    semtimedop = 220,
    fadvise64 = 221,
    timer_create = 222,
    timer_settime = 223,
    timer_gettime = 224,
    timer_getoverrun = 225,
    timer_delete = 226,
    clock_settime = 227,
    clock_gettime = 228,
    clock_getres = 229,
    clock_nanosleep = 230,
    exit_group = 231,
    epoll_wait = 232,
    epoll_ctl = 233,
    tgkill = 234,
    utimes = 235,
    vserver = 236,
    mbind = 237,
    set_mempolicy = 238,
    get_mempolicy = 239,
    mq_open = 240,
    mq_unlink = 241,
    mq_timedsend = 242,
    mq_timedreceive = 243,
    mq_notify = 244,
    mq_getsetattr = 245,
    kexec_load = 246,
    waitid = 247,
    add_key = 248,
    request_key = 249,
    keyctl = 250,
    ioprio_set = 251,
    ioprio_get = 252,
    inotify_init = 253,
    inotify_add_watch = 254,
    inotify_rm_watch = 255,
    migrate_pages = 256,
    openat = 257,
    mkdirat = 258,
    mknodat = 259,
    fchownat = 260,
    futimesat = 261,
    fstatat64 = 262,
    unlinkat = 263,
    renameat = 264,
    linkat = 265,
    symlinkat = 266,
    readlinkat = 267,
    fchmodat = 268,
    faccessat = 269,
    pselect6 = 270,
    ppoll = 271,
    unshare = 272,
    set_robust_list = 273,
    get_robust_list = 274,
    splice = 275,
    tee = 276,
    sync_file_range = 277,
    vmsplice = 278,
    move_pages = 279,
    utimensat = 280,
    epoll_pwait = 281,
    signalfd = 282,
    timerfd_create = 283,
    eventfd = 284,
    fallocate = 285,
    timerfd_settime = 286,
    timerfd_gettime = 287,
    accept4 = 288,
    signalfd4 = 289,
    eventfd2 = 290,
    epoll_create1 = 291,
    dup3 = 292,
    pipe2 = 293,
    inotify_init1 = 294,
    preadv = 295,
    pwritev = 296,
    rt_tgsigqueueinfo = 297,
    perf_event_open = 298,
    recvmmsg = 299,
    fanotify_init = 300,
    fanotify_mark = 301,
    prlimit64 = 302,
    name_to_handle_at = 303,
    open_by_handle_at = 304,
    clock_adjtime = 305,
    syncfs = 306,
    sendmmsg = 307,
    setns = 308,
    getcpu = 309,
    process_vm_readv = 310,
    process_vm_writev = 311,
    kcmp = 312,
    finit_module = 313,
    sched_setattr = 314,
    sched_getattr = 315,
    renameat2 = 316,
    seccomp = 317,
    getrandom = 318,
    memfd_create = 319,
    kexec_file_load = 320,
    bpf = 321,
    execveat = 322,
    userfaultfd = 323,
    membarrier = 324,
    mlock2 = 325,
    copy_file_range = 326,
    preadv2 = 327,
    pwritev2 = 328,
    pkey_mprotect = 329,
    pkey_alloc = 330,
    pkey_free = 331,
    statx = 332,
    io_pgetevents = 333,
    rseq = 334,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    memfd_secret = 447,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const Arm = enum(usize) {
    const arm_base = 0x0f0000;

    restart_syscall = 0,
    exit = 1,
    fork = 2,
    read = 3,
    write = 4,
    open = 5,
    close = 6,
    creat = 8,
    link = 9,
    unlink = 10,
    execve = 11,
    chdir = 12,
    mknod = 14,
    chmod = 15,
    lchown = 16,
    lseek = 19,
    getpid = 20,
    mount = 21,
    setuid = 23,
    getuid = 24,
    ptrace = 26,
    pause = 29,
    access = 33,
    nice = 34,
    sync = 36,
    kill = 37,
    rename = 38,
    mkdir = 39,
    rmdir = 40,
    dup = 41,
    pipe = 42,
    times = 43,
    brk = 45,
    setgid = 46,
    getgid = 47,
    geteuid = 49,
    getegid = 50,
    acct = 51,
    umount2 = 52,
    ioctl = 54,
    fcntl = 55,
    setpgid = 57,
    umask = 60,
    chroot = 61,
    ustat = 62,
    dup2 = 63,
    getppid = 64,
    getpgrp = 65,
    setsid = 66,
    sigaction = 67,
    setreuid = 70,
    setregid = 71,
    sigsuspend = 72,
    sigpending = 73,
    sethostname = 74,
    setrlimit = 75,
    getrusage = 77,
    gettimeofday = 78,
    settimeofday = 79,
    getgroups = 80,
    setgroups = 81,
    symlink = 83,
    readlink = 85,
    uselib = 86,
    swapon = 87,
    reboot = 88,
    munmap = 91,
    truncate = 92,
    ftruncate = 93,
    fchmod = 94,
    fchown = 95,
    getpriority = 96,
    setpriority = 97,
    statfs = 99,
    fstatfs = 100,
    syslog = 103,
    setitimer = 104,
    getitimer = 105,
    stat = 106,
    lstat = 107,
    fstat = 108,
    vhangup = 111,
    wait4 = 114,
    swapoff = 115,
    sysinfo = 116,
    fsync = 118,
    sigreturn = 119,
    clone = 120,
    setdomainname = 121,
    uname = 122,
    adjtimex = 124,
    mprotect = 125,
    sigprocmask = 126,
    init_module = 128,
    delete_module = 129,
    quotactl = 131,
    getpgid = 132,
    fchdir = 133,
    bdflush = 134,
    sysfs = 135,
    personality = 136,
    setfsuid = 138,
    setfsgid = 139,
    _llseek = 140,
    getdents = 141,
    _newselect = 142,
    flock = 143,
    msync = 144,
    readv = 145,
    writev = 146,
    getsid = 147,
    fdatasync = 148,
    _sysctl = 149,
    mlock = 150,
    munlock = 151,
    mlockall = 152,
    munlockall = 153,
    sched_setparam = 154,
    sched_getparam = 155,
    sched_setscheduler = 156,
    sched_getscheduler = 157,
    sched_yield = 158,
    sched_get_priority_max = 159,
    sched_get_priority_min = 160,
    sched_rr_get_interval = 161,
    nanosleep = 162,
    mremap = 163,
    setresuid = 164,
    getresuid = 165,
    poll = 168,
    nfsservctl = 169,
    setresgid = 170,
    getresgid = 171,
    prctl = 172,
    rt_sigreturn = 173,
    rt_sigaction = 174,
    rt_sigprocmask = 175,
    rt_sigpending = 176,
    rt_sigtimedwait = 177,
    rt_sigqueueinfo = 178,
    rt_sigsuspend = 179,
    pread64 = 180,
    pwrite64 = 181,
    chown = 182,
    getcwd = 183,
    capget = 184,
    capset = 185,
    sigaltstack = 186,
    sendfile = 187,
    vfork = 190,
    ugetrlimit = 191,
    mmap2 = 192,
    truncate64 = 193,
    ftruncate64 = 194,
    stat64 = 195,
    lstat64 = 196,
    fstat64 = 197,
    lchown32 = 198,
    getuid32 = 199,
    getgid32 = 200,
    geteuid32 = 201,
    getegid32 = 202,
    setreuid32 = 203,
    setregid32 = 204,
    getgroups32 = 205,
    setgroups32 = 206,
    fchown32 = 207,
    setresuid32 = 208,
    getresuid32 = 209,
    setresgid32 = 210,
    getresgid32 = 211,
    chown32 = 212,
    setuid32 = 213,
    setgid32 = 214,
    setfsuid32 = 215,
    setfsgid32 = 216,
    getdents64 = 217,
    pivot_root = 218,
    mincore = 219,
    madvise = 220,
    fcntl64 = 221,
    gettid = 224,
    readahead = 225,
    setxattr = 226,
    lsetxattr = 227,
    fsetxattr = 228,
    getxattr = 229,
    lgetxattr = 230,
    fgetxattr = 231,
    listxattr = 232,
    llistxattr = 233,
    flistxattr = 234,
    removexattr = 235,
    lremovexattr = 236,
    fremovexattr = 237,
    tkill = 238,
    sendfile64 = 239,
    futex = 240,
    sched_setaffinity = 241,
    sched_getaffinity = 242,
    io_setup = 243,
    io_destroy = 244,
    io_getevents = 245,
    io_submit = 246,
    io_cancel = 247,
    exit_group = 248,
    lookup_dcookie = 249,
    epoll_create = 250,
    epoll_ctl = 251,
    epoll_wait = 252,
    remap_file_pages = 253,
    set_tid_address = 256,
    timer_create = 257,
    timer_settime = 258,
    timer_gettime = 259,
    timer_getoverrun = 260,
    timer_delete = 261,
    clock_settime = 262,
    clock_gettime = 263,
    clock_getres = 264,
    clock_nanosleep = 265,
    statfs64 = 266,
    fstatfs64 = 267,
    tgkill = 268,
    utimes = 269,
    fadvise64_64 = 270,
    pciconfig_iobase = 271,
    pciconfig_read = 272,
    pciconfig_write = 273,
    mq_open = 274,
    mq_unlink = 275,
    mq_timedsend = 276,
    mq_timedreceive = 277,
    mq_notify = 278,
    mq_getsetattr = 279,
    waitid = 280,
    socket = 281,
    bind = 282,
    connect = 283,
    listen = 284,
    accept = 285,
    getsockname = 286,
    getpeername = 287,
    socketpair = 288,
    send = 289,
    sendto = 290,
    recv = 291,
    recvfrom = 292,
    shutdown = 293,
    setsockopt = 294,
    getsockopt = 295,
    sendmsg = 296,
    recvmsg = 297,
    semop = 298,
    semget = 299,
    semctl = 300,
    msgsnd = 301,
    msgrcv = 302,
    msgget = 303,
    msgctl = 304,
    shmat = 305,
    shmdt = 306,
    shmget = 307,
    shmctl = 308,
    add_key = 309,
    request_key = 310,
    keyctl = 311,
    semtimedop = 312,
    vserver = 313,
    ioprio_set = 314,
    ioprio_get = 315,
    inotify_init = 316,
    inotify_add_watch = 317,
    inotify_rm_watch = 318,
    mbind = 319,
    get_mempolicy = 320,
    set_mempolicy = 321,
    openat = 322,
    mkdirat = 323,
    mknodat = 324,
    fchownat = 325,
    futimesat = 326,
    fstatat64 = 327,
    unlinkat = 328,
    renameat = 329,
    linkat = 330,
    symlinkat = 331,
    readlinkat = 332,
    fchmodat = 333,
    faccessat = 334,
    pselect6 = 335,
    ppoll = 336,
    unshare = 337,
    set_robust_list = 338,
    get_robust_list = 339,
    splice = 340,
    sync_file_range = 341,
    tee = 342,
    vmsplice = 343,
    move_pages = 344,
    getcpu = 345,
    epoll_pwait = 346,
    kexec_load = 347,
    utimensat = 348,
    signalfd = 349,
    timerfd_create = 350,
    eventfd = 351,
    fallocate = 352,
    timerfd_settime = 353,
    timerfd_gettime = 354,
    signalfd4 = 355,
    eventfd2 = 356,
    epoll_create1 = 357,
    dup3 = 358,
    pipe2 = 359,
    inotify_init1 = 360,
    preadv = 361,
    pwritev = 362,
    rt_tgsigqueueinfo = 363,
    perf_event_open = 364,
    recvmmsg = 365,
    accept4 = 366,
    fanotify_init = 367,
    fanotify_mark = 368,
    prlimit64 = 369,
    name_to_handle_at = 370,
    open_by_handle_at = 371,
    clock_adjtime = 372,
    syncfs = 373,
    sendmmsg = 374,
    setns = 375,
    process_vm_readv = 376,
    process_vm_writev = 377,
    kcmp = 378,
    finit_module = 379,
    sched_setattr = 380,
    sched_getattr = 381,
    renameat2 = 382,
    seccomp = 383,
    getrandom = 384,
    memfd_create = 385,
    bpf = 386,
    execveat = 387,
    userfaultfd = 388,
    membarrier = 389,
    mlock2 = 390,
    copy_file_range = 391,
    preadv2 = 392,
    pwritev2 = 393,
    pkey_mprotect = 394,
    pkey_alloc = 395,
    pkey_free = 396,
    statx = 397,
    rseq = 398,
    io_pgetevents = 399,
    migrate_pages = 400,
    kexec_file_load = 401,
    clock_gettime64 = 403,
    clock_settime64 = 404,
    clock_adjtime64 = 405,
    clock_getres_time64 = 406,
    clock_nanosleep_time64 = 407,
    timer_gettime64 = 408,
    timer_settime64 = 409,
    timerfd_gettime64 = 410,
    timerfd_settime64 = 411,
    utimensat_time64 = 412,
    pselect6_time64 = 413,
    ppoll_time64 = 414,
    io_pgetevents_time64 = 416,
    recvmmsg_time64 = 417,
    mq_timedsend_time64 = 418,
    mq_timedreceive_time64 = 419,
    semtimedop_time64 = 420,
    rt_sigtimedwait_time64 = 421,
    futex_time64 = 422,
    sched_rr_get_interval_time64 = 423,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,

    breakpoint = arm_base + 1,
    cacheflush = arm_base + 2,
    usr26 = arm_base + 3,
    usr32 = arm_base + 4,
    set_tls = arm_base + 5,
    get_tls = arm_base + 6,
};

pub const Sparc64 = enum(usize) {
    restart_syscall = 0,
    exit = 1,
    fork = 2,
    read = 3,
    write = 4,
    open = 5,
    close = 6,
    wait4 = 7,
    creat = 8,
    link = 9,
    unlink = 10,
    execv = 11,
    chdir = 12,
    chown = 13,
    mknod = 14,
    chmod = 15,
    lchown = 16,
    brk = 17,
    perfctr = 18,
    lseek = 19,
    getpid = 20,
    capget = 21,
    capset = 22,
    setuid = 23,
    getuid = 24,
    vmsplice = 25,
    ptrace = 26,
    alarm = 27,
    sigaltstack = 28,
    pause = 29,
    utime = 30,
    access = 33,
    nice = 34,
    sync = 36,
    kill = 37,
    stat = 38,
    sendfile = 39,
    lstat = 40,
    dup = 41,
    pipe = 42,
    times = 43,
    umount2 = 45,
    setgid = 46,
    getgid = 47,
    signal = 48,
    geteuid = 49,
    getegid = 50,
    acct = 51,
    memory_ordering = 52,
    ioctl = 54,
    reboot = 55,
    symlink = 57,
    readlink = 58,
    execve = 59,
    umask = 60,
    chroot = 61,
    fstat = 62,
    fstat64 = 63,
    getpagesize = 64,
    msync = 65,
    vfork = 66,
    pread64 = 67,
    pwrite64 = 68,
    mmap = 71,
    munmap = 73,
    mprotect = 74,
    madvise = 75,
    vhangup = 76,
    mincore = 78,
    getgroups = 79,
    setgroups = 80,
    getpgrp = 81,
    setitimer = 83,
    swapon = 85,
    getitimer = 86,
    sethostname = 88,
    dup2 = 90,
    fcntl = 92,
    select = 93,
    fsync = 95,
    setpriority = 96,
    socket = 97,
    connect = 98,
    accept = 99,
    getpriority = 100,
    rt_sigreturn = 101,
    rt_sigaction = 102,
    rt_sigprocmask = 103,
    rt_sigpending = 104,
    rt_sigtimedwait = 105,
    rt_sigqueueinfo = 106,
    rt_sigsuspend = 107,
    setresuid = 108,
    getresuid = 109,
    setresgid = 110,
    getresgid = 111,
    recvmsg = 113,
    sendmsg = 114,
    gettimeofday = 116,
    getrusage = 117,
    getsockopt = 118,
    getcwd = 119,
    readv = 120,
    writev = 121,
    settimeofday = 122,
    fchown = 123,
    fchmod = 124,
    recvfrom = 125,
    setreuid = 126,
    setregid = 127,
    rename = 128,
    truncate = 129,
    ftruncate = 130,
    flock = 131,
    lstat64 = 132,
    sendto = 133,
    shutdown = 134,
    socketpair = 135,
    mkdir = 136,
    rmdir = 137,
    utimes = 138,
    stat64 = 139,
    sendfile64 = 140,
    getpeername = 141,
    futex = 142,
    gettid = 143,
    getrlimit = 144,
    setrlimit = 145,
    pivot_root = 146,
    prctl = 147,
    pciconfig_read = 148,
    pciconfig_write = 149,
    getsockname = 150,
    inotify_init = 151,
    inotify_add_watch = 152,
    poll = 153,
    getdents64 = 154,
    inotify_rm_watch = 156,
    statfs = 157,
    fstatfs = 158,
    umount = 159,
    sched_set_affinity = 160,
    sched_get_affinity = 161,
    getdomainname = 162,
    setdomainname = 163,
    utrap_install = 164,
    quotactl = 165,
    set_tid_address = 166,
    mount = 167,
    ustat = 168,
    setxattr = 169,
    lsetxattr = 170,
    fsetxattr = 171,
    getxattr = 172,
    lgetxattr = 173,
    getdents = 174,
    setsid = 175,
    fchdir = 176,
    fgetxattr = 177,
    listxattr = 178,
    llistxattr = 179,
    flistxattr = 180,
    removexattr = 181,
    lremovexattr = 182,
    sigpending = 183,
    query_module = 184,
    setpgid = 185,
    fremovexattr = 186,
    tkill = 187,
    exit_group = 188,
    uname = 189,
    init_module = 190,
    personality = 191,
    remap_file_pages = 192,
    epoll_create = 193,
    epoll_ctl = 194,
    epoll_wait = 195,
    ioprio_set = 196,
    getppid = 197,
    sigaction = 198,
    sgetmask = 199,
    ssetmask = 200,
    sigsuspend = 201,
    oldlstat = 202,
    uselib = 203,
    readdir = 204,
    readahead = 205,
    socketcall = 206,
    syslog = 207,
    lookup_dcookie = 208,
    fadvise64 = 209,
    fadvise64_64 = 210,
    tgkill = 211,
    waitpid = 212,
    swapoff = 213,
    sysinfo = 214,
    ipc = 215,
    sigreturn = 216,
    clone = 217,
    ioprio_get = 218,
    adjtimex = 219,
    sigprocmask = 220,
    create_module = 221,
    delete_module = 222,
    get_kernel_syms = 223,
    getpgid = 224,
    bdflush = 225,
    sysfs = 226,
    afs_syscall = 227,
    setfsuid = 228,
    setfsgid = 229,
    _newselect = 230,
    splice = 232,
    stime = 233,
    statfs64 = 234,
    fstatfs64 = 235,
    _llseek = 236,
    mlock = 237,
    munlock = 238,
    mlockall = 239,
    munlockall = 240,
    sched_setparam = 241,
    sched_getparam = 242,
    sched_setscheduler = 243,
    sched_getscheduler = 244,
    sched_yield = 245,
    sched_get_priority_max = 246,
    sched_get_priority_min = 247,
    sched_rr_get_interval = 248,
    nanosleep = 249,
    mremap = 250,
    _sysctl = 251,
    getsid = 252,
    fdatasync = 253,
    nfsservctl = 254,
    sync_file_range = 255,
    clock_settime = 256,
    clock_gettime = 257,
    clock_getres = 258,
    clock_nanosleep = 259,
    sched_getaffinity = 260,
    sched_setaffinity = 261,
    timer_settime = 262,
    timer_gettime = 263,
    timer_getoverrun = 264,
    timer_delete = 265,
    timer_create = 266,
    vserver = 267,
    io_setup = 268,
    io_destroy = 269,
    io_submit = 270,
    io_cancel = 271,
    io_getevents = 272,
    mq_open = 273,
    mq_unlink = 274,
    mq_timedsend = 275,
    mq_timedreceive = 276,
    mq_notify = 277,
    mq_getsetattr = 278,
    waitid = 279,
    tee = 280,
    add_key = 281,
    request_key = 282,
    keyctl = 283,
    openat = 284,
    mkdirat = 285,
    mknodat = 286,
    fchownat = 287,
    futimesat = 288,
    fstatat64 = 289,
    unlinkat = 290,
    renameat = 291,
    linkat = 292,
    symlinkat = 293,
    readlinkat = 294,
    fchmodat = 295,
    faccessat = 296,
    pselect6 = 297,
    ppoll = 298,
    unshare = 299,
    set_robust_list = 300,
    get_robust_list = 301,
    migrate_pages = 302,
    mbind = 303,
    get_mempolicy = 304,
    set_mempolicy = 305,
    kexec_load = 306,
    move_pages = 307,
    getcpu = 308,
    epoll_pwait = 309,
    utimensat = 310,
    signalfd = 311,
    timerfd_create = 312,
    eventfd = 313,
    fallocate = 314,
    timerfd_settime = 315,
    timerfd_gettime = 316,
    signalfd4 = 317,
    eventfd2 = 318,
    epoll_create1 = 319,
    dup3 = 320,
    pipe2 = 321,
    inotify_init1 = 322,
    accept4 = 323,
    preadv = 324,
    pwritev = 325,
    rt_tgsigqueueinfo = 326,
    perf_event_open = 327,
    recvmmsg = 328,
    fanotify_init = 329,
    fanotify_mark = 330,
    prlimit64 = 331,
    name_to_handle_at = 332,
    open_by_handle_at = 333,
    clock_adjtime = 334,
    syncfs = 335,
    sendmmsg = 336,
    setns = 337,
    process_vm_readv = 338,
    process_vm_writev = 339,
    kern_features = 340,
    kcmp = 341,
    finit_module = 342,
    sched_setattr = 343,
    sched_getattr = 344,
    renameat2 = 345,
    seccomp = 346,
    getrandom = 347,
    memfd_create = 348,
    bpf = 349,
    execveat = 350,
    membarrier = 351,
    userfaultfd = 352,
    bind = 353,
    listen = 354,
    setsockopt = 355,
    mlock2 = 356,
    copy_file_range = 357,
    preadv2 = 358,
    pwritev2 = 359,
    statx = 360,
    io_pgetevents = 361,
    pkey_mprotect = 362,
    pkey_alloc = 363,
    pkey_free = 364,
    rseq = 365,
    semtimedop = 392,
    semget = 393,
    semctl = 394,
    shmget = 395,
    shmctl = 396,
    shmat = 397,
    shmdt = 398,
    msgget = 399,
    msgsnd = 400,
    msgrcv = 401,
    msgctl = 402,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const Mips = enum(usize) {
    pub const Linux = 4000;

    syscall = Linux + 0,
    exit = Linux + 1,
    fork = Linux + 2,
    read = Linux + 3,
    write = Linux + 4,
    open = Linux + 5,
    close = Linux + 6,
    waitpid = Linux + 7,
    creat = Linux + 8,
    link = Linux + 9,
    unlink = Linux + 10,
    execve = Linux + 11,
    chdir = Linux + 12,
    time = Linux + 13,
    mknod = Linux + 14,
    chmod = Linux + 15,
    lchown = Linux + 16,
    @"break" = Linux + 17,
    lseek = Linux + 19,
    getpid = Linux + 20,
    mount = Linux + 21,
    umount = Linux + 22,
    setuid = Linux + 23,
    getuid = Linux + 24,
    stime = Linux + 25,
    ptrace = Linux + 26,
    alarm = Linux + 27,
    pause = Linux + 29,
    utime = Linux + 30,
    stty = Linux + 31,
    gtty = Linux + 32,
    access = Linux + 33,
    nice = Linux + 34,
    ftime = Linux + 35,
    sync = Linux + 36,
    kill = Linux + 37,
    rename = Linux + 38,
    mkdir = Linux + 39,
    rmdir = Linux + 40,
    dup = Linux + 41,
    pipe = Linux + 42,
    times = Linux + 43,
    prof = Linux + 44,
    brk = Linux + 45,
    setgid = Linux + 46,
    getgid = Linux + 47,
    signal = Linux + 48,
    geteuid = Linux + 49,
    getegid = Linux + 50,
    acct = Linux + 51,
    umount2 = Linux + 52,
    lock = Linux + 53,
    ioctl = Linux + 54,
    fcntl = Linux + 55,
    mpx = Linux + 56,
    setpgid = Linux + 57,
    ulimit = Linux + 58,
    umask = Linux + 60,
    chroot = Linux + 61,
    ustat = Linux + 62,
    dup2 = Linux + 63,
    getppid = Linux + 64,
    getpgrp = Linux + 65,
    setsid = Linux + 66,
    sigaction = Linux + 67,
    sgetmask = Linux + 68,
    ssetmask = Linux + 69,
    setreuid = Linux + 70,
    setregid = Linux + 71,
    sigsuspend = Linux + 72,
    sigpending = Linux + 73,
    sethostname = Linux + 74,
    setrlimit = Linux + 75,
    getrlimit = Linux + 76,
    getrusage = Linux + 77,
    gettimeofday = Linux + 78,
    settimeofday = Linux + 79,
    getgroups = Linux + 80,
    setgroups = Linux + 81,
    reserved82 = Linux + 82,
    symlink = Linux + 83,
    readlink = Linux + 85,
    uselib = Linux + 86,
    swapon = Linux + 87,
    reboot = Linux + 88,
    readdir = Linux + 89,
    mmap = Linux + 90,
    munmap = Linux + 91,
    truncate = Linux + 92,
    ftruncate = Linux + 93,
    fchmod = Linux + 94,
    fchown = Linux + 95,
    getpriority = Linux + 96,
    setpriority = Linux + 97,
    profil = Linux + 98,
    statfs = Linux + 99,
    fstatfs = Linux + 100,
    ioperm = Linux + 101,
    socketcall = Linux + 102,
    syslog = Linux + 103,
    setitimer = Linux + 104,
    getitimer = Linux + 105,
    stat = Linux + 106,
    lstat = Linux + 107,
    fstat = Linux + 108,
    iopl = Linux + 110,
    vhangup = Linux + 111,
    idle = Linux + 112,
    vm86 = Linux + 113,
    wait4 = Linux + 114,
    swapoff = Linux + 115,
    sysinfo = Linux + 116,
    ipc = Linux + 117,
    fsync = Linux + 118,
    sigreturn = Linux + 119,
    clone = Linux + 120,
    setdomainname = Linux + 121,
    uname = Linux + 122,
    modify_ldt = Linux + 123,
    adjtimex = Linux + 124,
    mprotect = Linux + 125,
    sigprocmask = Linux + 126,
    create_module = Linux + 127,
    init_module = Linux + 128,
    delete_module = Linux + 129,
    get_kernel_syms = Linux + 130,
    quotactl = Linux + 131,
    getpgid = Linux + 132,
    fchdir = Linux + 133,
    bdflush = Linux + 134,
    sysfs = Linux + 135,
    personality = Linux + 136,
    afs_syscall = Linux + 137,
    setfsuid = Linux + 138,
    setfsgid = Linux + 139,
    _llseek = Linux + 140,
    getdents = Linux + 141,
    _newselect = Linux + 142,
    flock = Linux + 143,
    msync = Linux + 144,
    readv = Linux + 145,
    writev = Linux + 146,
    cacheflush = Linux + 147,
    cachectl = Linux + 148,
    sysmips = Linux + 149,
    getsid = Linux + 151,
    fdatasync = Linux + 152,
    _sysctl = Linux + 153,
    mlock = Linux + 154,
    munlock = Linux + 155,
    mlockall = Linux + 156,
    munlockall = Linux + 157,
    sched_setparam = Linux + 158,
    sched_getparam = Linux + 159,
    sched_setscheduler = Linux + 160,
    sched_getscheduler = Linux + 161,
    sched_yield = Linux + 162,
    sched_get_priority_max = Linux + 163,
    sched_get_priority_min = Linux + 164,
    sched_rr_get_interval = Linux + 165,
    nanosleep = Linux + 166,
    mremap = Linux + 167,
    accept = Linux + 168,
    bind = Linux + 169,
    connect = Linux + 170,
    getpeername = Linux + 171,
    getsockname = Linux + 172,
    getsockopt = Linux + 173,
    listen = Linux + 174,
    recv = Linux + 175,
    recvfrom = Linux + 176,
    recvmsg = Linux + 177,
    send = Linux + 178,
    sendmsg = Linux + 179,
    sendto = Linux + 180,
    setsockopt = Linux + 181,
    shutdown = Linux + 182,
    socket = Linux + 183,
    socketpair = Linux + 184,
    setresuid = Linux + 185,
    getresuid = Linux + 186,
    query_module = Linux + 187,
    poll = Linux + 188,
    nfsservctl = Linux + 189,
    setresgid = Linux + 190,
    getresgid = Linux + 191,
    prctl = Linux + 192,
    rt_sigreturn = Linux + 193,
    rt_sigaction = Linux + 194,
    rt_sigprocmask = Linux + 195,
    rt_sigpending = Linux + 196,
    rt_sigtimedwait = Linux + 197,
    rt_sigqueueinfo = Linux + 198,
    rt_sigsuspend = Linux + 199,
    pread64 = Linux + 200,
    pwrite64 = Linux + 201,
    chown = Linux + 202,
    getcwd = Linux + 203,
    capget = Linux + 204,
    capset = Linux + 205,
    sigaltstack = Linux + 206,
    sendfile = Linux + 207,
    getpmsg = Linux + 208,
    putpmsg = Linux + 209,
    mmap2 = Linux + 210,
    truncate64 = Linux + 211,
    ftruncate64 = Linux + 212,
    stat64 = Linux + 213,
    lstat64 = Linux + 214,
    fstat64 = Linux + 215,
    pivot_root = Linux + 216,
    mincore = Linux + 217,
    madvise = Linux + 218,
    getdents64 = Linux + 219,
    fcntl64 = Linux + 220,
    reserved221 = Linux + 221,
    gettid = Linux + 222,
    readahead = Linux + 223,
    setxattr = Linux + 224,
    lsetxattr = Linux + 225,
    fsetxattr = Linux + 226,
    getxattr = Linux + 227,
    lgetxattr = Linux + 228,
    fgetxattr = Linux + 229,
    listxattr = Linux + 230,
    llistxattr = Linux + 231,
    flistxattr = Linux + 232,
    removexattr = Linux + 233,
    lremovexattr = Linux + 234,
    fremovexattr = Linux + 235,
    tkill = Linux + 236,
    sendfile64 = Linux + 237,
    futex = Linux + 238,
    sched_setaffinity = Linux + 239,
    sched_getaffinity = Linux + 240,
    io_setup = Linux + 241,
    io_destroy = Linux + 242,
    io_getevents = Linux + 243,
    io_submit = Linux + 244,
    io_cancel = Linux + 245,
    exit_group = Linux + 246,
    lookup_dcookie = Linux + 247,
    epoll_create = Linux + 248,
    epoll_ctl = Linux + 249,
    epoll_wait = Linux + 250,
    remap_file_pages = Linux + 251,
    set_tid_address = Linux + 252,
    restart_syscall = Linux + 253,
    fadvise64 = Linux + 254,
    statfs64 = Linux + 255,
    fstatfs64 = Linux + 256,
    timer_create = Linux + 257,
    timer_settime = Linux + 258,
    timer_gettime = Linux + 259,
    timer_getoverrun = Linux + 260,
    timer_delete = Linux + 261,
    clock_settime = Linux + 262,
    clock_gettime = Linux + 263,
    clock_getres = Linux + 264,
    clock_nanosleep = Linux + 265,
    tgkill = Linux + 266,
    utimes = Linux + 267,
    mbind = Linux + 268,
    get_mempolicy = Linux + 269,
    set_mempolicy = Linux + 270,
    mq_open = Linux + 271,
    mq_unlink = Linux + 272,
    mq_timedsend = Linux + 273,
    mq_timedreceive = Linux + 274,
    mq_notify = Linux + 275,
    mq_getsetattr = Linux + 276,
    vserver = Linux + 277,
    waitid = Linux + 278,
    add_key = Linux + 280,
    request_key = Linux + 281,
    keyctl = Linux + 282,
    set_thread_area = Linux + 283,
    inotify_init = Linux + 284,
    inotify_add_watch = Linux + 285,
    inotify_rm_watch = Linux + 286,
    migrate_pages = Linux + 287,
    openat = Linux + 288,
    mkdirat = Linux + 289,
    mknodat = Linux + 290,
    fchownat = Linux + 291,
    futimesat = Linux + 292,
    fstatat64 = Linux + 293,
    unlinkat = Linux + 294,
    renameat = Linux + 295,
    linkat = Linux + 296,
    symlinkat = Linux + 297,
    readlinkat = Linux + 298,
    fchmodat = Linux + 299,
    faccessat = Linux + 300,
    pselect6 = Linux + 301,
    ppoll = Linux + 302,
    unshare = Linux + 303,
    splice = Linux + 304,
    sync_file_range = Linux + 305,
    tee = Linux + 306,
    vmsplice = Linux + 307,
    move_pages = Linux + 308,
    set_robust_list = Linux + 309,
    get_robust_list = Linux + 310,
    kexec_load = Linux + 311,
    getcpu = Linux + 312,
    epoll_pwait = Linux + 313,
    ioprio_set = Linux + 314,
    ioprio_get = Linux + 315,
    utimensat = Linux + 316,
    signalfd = Linux + 317,
    timerfd = Linux + 318,
    eventfd = Linux + 319,
    fallocate = Linux + 320,
    timerfd_create = Linux + 321,
    timerfd_gettime = Linux + 322,
    timerfd_settime = Linux + 323,
    signalfd4 = Linux + 324,
    eventfd2 = Linux + 325,
    epoll_create1 = Linux + 326,
    dup3 = Linux + 327,
    pipe2 = Linux + 328,
    inotify_init1 = Linux + 329,
    preadv = Linux + 330,
    pwritev = Linux + 331,
    rt_tgsigqueueinfo = Linux + 332,
    perf_event_open = Linux + 333,
    accept4 = Linux + 334,
    recvmmsg = Linux + 335,
    fanotify_init = Linux + 336,
    fanotify_mark = Linux + 337,
    prlimit64 = Linux + 338,
    name_to_handle_at = Linux + 339,
    open_by_handle_at = Linux + 340,
    clock_adjtime = Linux + 341,
    syncfs = Linux + 342,
    sendmmsg = Linux + 343,
    setns = Linux + 344,
    process_vm_readv = Linux + 345,
    process_vm_writev = Linux + 346,
    kcmp = Linux + 347,
    finit_module = Linux + 348,
    sched_setattr = Linux + 349,
    sched_getattr = Linux + 350,
    renameat2 = Linux + 351,
    seccomp = Linux + 352,
    getrandom = Linux + 353,
    memfd_create = Linux + 354,
    bpf = Linux + 355,
    execveat = Linux + 356,
    userfaultfd = Linux + 357,
    membarrier = Linux + 358,
    mlock2 = Linux + 359,
    copy_file_range = Linux + 360,
    preadv2 = Linux + 361,
    pwritev2 = Linux + 362,
    pkey_mprotect = Linux + 363,
    pkey_alloc = Linux + 364,
    pkey_free = Linux + 365,
    statx = Linux + 366,
    rseq = Linux + 367,
    io_pgetevents = Linux + 368,
    semget = Linux + 393,
    semctl = Linux + 394,
    shmget = Linux + 395,
    shmctl = Linux + 396,
    shmat = Linux + 397,
    shmdt = Linux + 398,
    msgget = Linux + 399,
    msgsnd = Linux + 400,
    msgrcv = Linux + 401,
    msgctl = Linux + 402,
    clock_gettime64 = Linux + 403,
    clock_settime64 = Linux + 404,
    clock_adjtime64 = Linux + 405,
    clock_getres_time64 = Linux + 406,
    clock_nanosleep_time64 = Linux + 407,
    timer_gettime64 = Linux + 408,
    timer_settime64 = Linux + 409,
    timerfd_gettime64 = Linux + 410,
    timerfd_settime64 = Linux + 411,
    utimensat_time64 = Linux + 412,
    pselect6_time64 = Linux + 413,
    ppoll_time64 = Linux + 414,
    io_pgetevents_time64 = Linux + 416,
    recvmmsg_time64 = Linux + 417,
    mq_timedsend_time64 = Linux + 418,
    mq_timedreceive_time64 = Linux + 419,
    semtimedop_time64 = Linux + 420,
    rt_sigtimedwait_time64 = Linux + 421,
    futex_time64 = Linux + 422,
    sched_rr_get_interval_time64 = Linux + 423,
    pidfd_send_signal = Linux + 424,
    io_uring_setup = Linux + 425,
    io_uring_enter = Linux + 426,
    io_uring_register = Linux + 427,
    open_tree = Linux + 428,
    move_mount = Linux + 429,
    fsopen = Linux + 430,
    fsconfig = Linux + 431,
    fsmount = Linux + 432,
    fspick = Linux + 433,
    pidfd_open = Linux + 434,
    clone3 = Linux + 435,
    close_range = Linux + 436,
    openat2 = Linux + 437,
    pidfd_getfd = Linux + 438,
    faccessat2 = Linux + 439,
    process_madvise = Linux + 440,
    epoll_pwait2 = Linux + 441,
    mount_setattr = Linux + 442,
    quotactl_fd = Linux + 443,
    landlock_create_ruleset = Linux + 444,
    landlock_add_rule = Linux + 445,
    landlock_restrict_self = Linux + 446,
    process_mrelease = Linux + 448,
    futex_waitv = Linux + 449,
    set_mempolicy_home_node = Linux + 450,
    cachestat = Linux + 451,
    fchmodat2 = Linux + 452,
    map_shadow_stack = Linux + 453,
    futex_wake = Linux + 454,
    futex_wait = Linux + 455,
    futex_requeue = Linux + 456,
};

pub const Mips64 = enum(usize) {
    pub const Linux = 5000;

    read = Linux + 0,
    write = Linux + 1,
    open = Linux + 2,
    close = Linux + 3,
    stat = Linux + 4,
    fstat = Linux + 5,
    lstat = Linux + 6,
    poll = Linux + 7,
    lseek = Linux + 8,
    mmap = Linux + 9,
    mprotect = Linux + 10,
    munmap = Linux + 11,
    brk = Linux + 12,
    rt_sigaction = Linux + 13,
    rt_sigprocmask = Linux + 14,
    ioctl = Linux + 15,
    pread64 = Linux + 16,
    pwrite64 = Linux + 17,
    readv = Linux + 18,
    writev = Linux + 19,
    access = Linux + 20,
    pipe = Linux + 21,
    _newselect = Linux + 22,
    sched_yield = Linux + 23,
    mremap = Linux + 24,
    msync = Linux + 25,
    mincore = Linux + 26,
    madvise = Linux + 27,
    shmget = Linux + 28,
    shmat = Linux + 29,
    shmctl = Linux + 30,
    dup = Linux + 31,
    dup2 = Linux + 32,
    pause = Linux + 33,
    nanosleep = Linux + 34,
    getitimer = Linux + 35,
    setitimer = Linux + 36,
    alarm = Linux + 37,
    getpid = Linux + 38,
    sendfile = Linux + 39,
    socket = Linux + 40,
    connect = Linux + 41,
    accept = Linux + 42,
    sendto = Linux + 43,
    recvfrom = Linux + 44,
    sendmsg = Linux + 45,
    recvmsg = Linux + 46,
    shutdown = Linux + 47,
    bind = Linux + 48,
    listen = Linux + 49,
    getsockname = Linux + 50,
    getpeername = Linux + 51,
    socketpair = Linux + 52,
    setsockopt = Linux + 53,
    getsockopt = Linux + 54,
    clone = Linux + 55,
    fork = Linux + 56,
    execve = Linux + 57,
    exit = Linux + 58,
    wait4 = Linux + 59,
    kill = Linux + 60,
    uname = Linux + 61,
    semget = Linux + 62,
    semop = Linux + 63,
    semctl = Linux + 64,
    shmdt = Linux + 65,
    msgget = Linux + 66,
    msgsnd = Linux + 67,
    msgrcv = Linux + 68,
    msgctl = Linux + 69,
    fcntl = Linux + 70,
    flock = Linux + 71,
    fsync = Linux + 72,
    fdatasync = Linux + 73,
    truncate = Linux + 74,
    ftruncate = Linux + 75,
    getdents = Linux + 76,
    getcwd = Linux + 77,
    chdir = Linux + 78,
    fchdir = Linux + 79,
    rename = Linux + 80,
    mkdir = Linux + 81,
    rmdir = Linux + 82,
    creat = Linux + 83,
    link = Linux + 84,
    unlink = Linux + 85,
    symlink = Linux + 86,
    readlink = Linux + 87,
    chmod = Linux + 88,
    fchmod = Linux + 89,
    chown = Linux + 90,
    fchown = Linux + 91,
    lchown = Linux + 92,
    umask = Linux + 93,
    gettimeofday = Linux + 94,
    getrlimit = Linux + 95,
    getrusage = Linux + 96,
    sysinfo = Linux + 97,
    times = Linux + 98,
    ptrace = Linux + 99,
    getuid = Linux + 100,
    syslog = Linux + 101,
    getgid = Linux + 102,
    setuid = Linux + 103,
    setgid = Linux + 104,
    geteuid = Linux + 105,
    getegid = Linux + 106,
    setpgid = Linux + 107,
    getppid = Linux + 108,
    getpgrp = Linux + 109,
    setsid = Linux + 110,
    setreuid = Linux + 111,
    setregid = Linux + 112,
    getgroups = Linux + 113,
    setgroups = Linux + 114,
    setresuid = Linux + 115,
    getresuid = Linux + 116,
    setresgid = Linux + 117,
    getresgid = Linux + 118,
    getpgid = Linux + 119,
    setfsuid = Linux + 120,
    setfsgid = Linux + 121,
    getsid = Linux + 122,
    capget = Linux + 123,
    capset = Linux + 124,
    rt_sigpending = Linux + 125,
    rt_sigtimedwait = Linux + 126,
    rt_sigqueueinfo = Linux + 127,
    rt_sigsuspend = Linux + 128,
    sigaltstack = Linux + 129,
    utime = Linux + 130,
    mknod = Linux + 131,
    personality = Linux + 132,
    ustat = Linux + 133,
    statfs = Linux + 134,
    fstatfs = Linux + 135,
    sysfs = Linux + 136,
    getpriority = Linux + 137,
    setpriority = Linux + 138,
    sched_setparam = Linux + 139,
    sched_getparam = Linux + 140,
    sched_setscheduler = Linux + 141,
    sched_getscheduler = Linux + 142,
    sched_get_priority_max = Linux + 143,
    sched_get_priority_min = Linux + 144,
    sched_rr_get_interval = Linux + 145,
    mlock = Linux + 146,
    munlock = Linux + 147,
    mlockall = Linux + 148,
    munlockall = Linux + 149,
    vhangup = Linux + 150,
    pivot_root = Linux + 151,
    _sysctl = Linux + 152,
    prctl = Linux + 153,
    adjtimex = Linux + 154,
    setrlimit = Linux + 155,
    chroot = Linux + 156,
    sync = Linux + 157,
    acct = Linux + 158,
    settimeofday = Linux + 159,
    mount = Linux + 160,
    umount2 = Linux + 161,
    swapon = Linux + 162,
    swapoff = Linux + 163,
    reboot = Linux + 164,
    sethostname = Linux + 165,
    setdomainname = Linux + 166,
    create_module = Linux + 167,
    init_module = Linux + 168,
    delete_module = Linux + 169,
    get_kernel_syms = Linux + 170,
    query_module = Linux + 171,
    quotactl = Linux + 172,
    nfsservctl = Linux + 173,
    getpmsg = Linux + 174,
    putpmsg = Linux + 175,
    afs_syscall = Linux + 176,
    reserved177 = Linux + 177,
    gettid = Linux + 178,
    readahead = Linux + 179,
    setxattr = Linux + 180,
    lsetxattr = Linux + 181,
    fsetxattr = Linux + 182,
    getxattr = Linux + 183,
    lgetxattr = Linux + 184,
    fgetxattr = Linux + 185,
    listxattr = Linux + 186,
    llistxattr = Linux + 187,
    flistxattr = Linux + 188,
    removexattr = Linux + 189,
    lremovexattr = Linux + 190,
    fremovexattr = Linux + 191,
    tkill = Linux + 192,
    reserved193 = Linux + 193,
    futex = Linux + 194,
    sched_setaffinity = Linux + 195,
    sched_getaffinity = Linux + 196,
    cacheflush = Linux + 197,
    cachectl = Linux + 198,
    sysmips = Linux + 199,
    io_setup = Linux + 200,
    io_destroy = Linux + 201,
    io_getevents = Linux + 202,
    io_submit = Linux + 203,
    io_cancel = Linux + 204,
    exit_group = Linux + 205,
    lookup_dcookie = Linux + 206,
    epoll_create = Linux + 207,
    epoll_ctl = Linux + 208,
    epoll_wait = Linux + 209,
    remap_file_pages = Linux + 210,
    rt_sigreturn = Linux + 211,
    set_tid_address = Linux + 212,
    restart_syscall = Linux + 213,
    semtimedop = Linux + 214,
    fadvise64 = Linux + 215,
    timer_create = Linux + 216,
    timer_settime = Linux + 217,
    timer_gettime = Linux + 218,
    timer_getoverrun = Linux + 219,
    timer_delete = Linux + 220,
    clock_settime = Linux + 221,
    clock_gettime = Linux + 222,
    clock_getres = Linux + 223,
    clock_nanosleep = Linux + 224,
    tgkill = Linux + 225,
    utimes = Linux + 226,
    mbind = Linux + 227,
    get_mempolicy = Linux + 228,
    set_mempolicy = Linux + 229,
    mq_open = Linux + 230,
    mq_unlink = Linux + 231,
    mq_timedsend = Linux + 232,
    mq_timedreceive = Linux + 233,
    mq_notify = Linux + 234,
    mq_getsetattr = Linux + 235,
    vserver = Linux + 236,
    waitid = Linux + 237,
    add_key = Linux + 239,
    request_key = Linux + 240,
    keyctl = Linux + 241,
    set_thread_area = Linux + 242,
    inotify_init = Linux + 243,
    inotify_add_watch = Linux + 244,
    inotify_rm_watch = Linux + 245,
    migrate_pages = Linux + 246,
    openat = Linux + 247,
    mkdirat = Linux + 248,
    mknodat = Linux + 249,
    fchownat = Linux + 250,
    futimesat = Linux + 251,
    fstatat64 = Linux + 252,
    unlinkat = Linux + 253,
    renameat = Linux + 254,
    linkat = Linux + 255,
    symlinkat = Linux + 256,
    readlinkat = Linux + 257,
    fchmodat = Linux + 258,
    faccessat = Linux + 259,
    pselect6 = Linux + 260,
    ppoll = Linux + 261,
    unshare = Linux + 262,
    splice = Linux + 263,
    sync_file_range = Linux + 264,
    tee = Linux + 265,
    vmsplice = Linux + 266,
    move_pages = Linux + 267,
    set_robust_list = Linux + 268,
    get_robust_list = Linux + 269,
    kexec_load = Linux + 270,
    getcpu = Linux + 271,
    epoll_pwait = Linux + 272,
    ioprio_set = Linux + 273,
    ioprio_get = Linux + 274,
    utimensat = Linux + 275,
    signalfd = Linux + 276,
    timerfd = Linux + 277,
    eventfd = Linux + 278,
    fallocate = Linux + 279,
    timerfd_create = Linux + 280,
    timerfd_gettime = Linux + 281,
    timerfd_settime = Linux + 282,
    signalfd4 = Linux + 283,
    eventfd2 = Linux + 284,
    epoll_create1 = Linux + 285,
    dup3 = Linux + 286,
    pipe2 = Linux + 287,
    inotify_init1 = Linux + 288,
    preadv = Linux + 289,
    pwritev = Linux + 290,
    rt_tgsigqueueinfo = Linux + 291,
    perf_event_open = Linux + 292,
    accept4 = Linux + 293,
    recvmmsg = Linux + 294,
    fanotify_init = Linux + 295,
    fanotify_mark = Linux + 296,
    prlimit64 = Linux + 297,
    name_to_handle_at = Linux + 298,
    open_by_handle_at = Linux + 299,
    clock_adjtime = Linux + 300,
    syncfs = Linux + 301,
    sendmmsg = Linux + 302,
    setns = Linux + 303,
    process_vm_readv = Linux + 304,
    process_vm_writev = Linux + 305,
    kcmp = Linux + 306,
    finit_module = Linux + 307,
    getdents64 = Linux + 308,
    sched_setattr = Linux + 309,
    sched_getattr = Linux + 310,
    renameat2 = Linux + 311,
    seccomp = Linux + 312,
    getrandom = Linux + 313,
    memfd_create = Linux + 314,
    bpf = Linux + 315,
    execveat = Linux + 316,
    userfaultfd = Linux + 317,
    membarrier = Linux + 318,
    mlock2 = Linux + 319,
    copy_file_range = Linux + 320,
    preadv2 = Linux + 321,
    pwritev2 = Linux + 322,
    pkey_mprotect = Linux + 323,
    pkey_alloc = Linux + 324,
    pkey_free = Linux + 325,
    statx = Linux + 326,
    rseq = Linux + 327,
    io_pgetevents = Linux + 328,
    pidfd_send_signal = Linux + 424,
    io_uring_setup = Linux + 425,
    io_uring_enter = Linux + 426,
    io_uring_register = Linux + 427,
    open_tree = Linux + 428,
    move_mount = Linux + 429,
    fsopen = Linux + 430,
    fsconfig = Linux + 431,
    fsmount = Linux + 432,
    fspick = Linux + 433,
    pidfd_open = Linux + 434,
    clone3 = Linux + 435,
    close_range = Linux + 436,
    openat2 = Linux + 437,
    pidfd_getfd = Linux + 438,
    faccessat2 = Linux + 439,
    process_madvise = Linux + 440,
    epoll_pwait2 = Linux + 441,
    mount_setattr = Linux + 442,
    quotactl_fd = Linux + 443,
    landlock_create_ruleset = Linux + 444,
    landlock_add_rule = Linux + 445,
    landlock_restrict_self = Linux + 446,
    process_mrelease = Linux + 448,
    futex_waitv = Linux + 449,
    set_mempolicy_home_node = Linux + 450,
    cachestat = Linux + 451,
    fchmodat2 = Linux + 452,
    map_shadow_stack = Linux + 453,
    futex_wake = Linux + 454,
    futex_wait = Linux + 455,
    futex_requeue = Linux + 456,
};

pub const PowerPC = enum(usize) {
    restart_syscall = 0,
    exit = 1,
    fork = 2,
    read = 3,
    write = 4,
    open = 5,
    close = 6,
    waitpid = 7,
    creat = 8,
    link = 9,
    unlink = 10,
    execve = 11,
    chdir = 12,
    time = 13,
    mknod = 14,
    chmod = 15,
    lchown = 16,
    @"break" = 17,
    oldstat = 18,
    lseek = 19,
    getpid = 20,
    mount = 21,
    umount = 22,
    setuid = 23,
    getuid = 24,
    stime = 25,
    ptrace = 26,
    alarm = 27,
    oldfstat = 28,
    pause = 29,
    utime = 30,
    stty = 31,
    gtty = 32,
    access = 33,
    nice = 34,
    ftime = 35,
    sync = 36,
    kill = 37,
    rename = 38,
    mkdir = 39,
    rmdir = 40,
    dup = 41,
    pipe = 42,
    times = 43,
    prof = 44,
    brk = 45,
    setgid = 46,
    getgid = 47,
    signal = 48,
    geteuid = 49,
    getegid = 50,
    acct = 51,
    umount2 = 52,
    lock = 53,
    ioctl = 54,
    fcntl = 55,
    mpx = 56,
    setpgid = 57,
    ulimit = 58,
    oldolduname = 59,
    umask = 60,
    chroot = 61,
    ustat = 62,
    dup2 = 63,
    getppid = 64,
    getpgrp = 65,
    setsid = 66,
    sigaction = 67,
    sgetmask = 68,
    ssetmask = 69,
    setreuid = 70,
    setregid = 71,
    sigsuspend = 72,
    sigpending = 73,
    sethostname = 74,
    setrlimit = 75,
    getrlimit = 76,
    getrusage = 77,
    gettimeofday = 78,
    settimeofday = 79,
    getgroups = 80,
    setgroups = 81,
    select = 82,
    symlink = 83,
    oldlstat = 84,
    readlink = 85,
    uselib = 86,
    swapon = 87,
    reboot = 88,
    readdir = 89,
    mmap = 90,
    munmap = 91,
    truncate = 92,
    ftruncate = 93,
    fchmod = 94,
    fchown = 95,
    getpriority = 96,
    setpriority = 97,
    profil = 98,
    statfs = 99,
    fstatfs = 100,
    ioperm = 101,
    socketcall = 102,
    syslog = 103,
    setitimer = 104,
    getitimer = 105,
    stat = 106,
    lstat = 107,
    fstat = 108,
    olduname = 109,
    iopl = 110,
    vhangup = 111,
    idle = 112,
    vm86 = 113,
    wait4 = 114,
    swapoff = 115,
    sysinfo = 116,
    ipc = 117,
    fsync = 118,
    sigreturn = 119,
    clone = 120,
    setdomainname = 121,
    uname = 122,
    modify_ldt = 123,
    adjtimex = 124,
    mprotect = 125,
    sigprocmask = 126,
    create_module = 127,
    init_module = 128,
    delete_module = 129,
    get_kernel_syms = 130,
    quotactl = 131,
    getpgid = 132,
    fchdir = 133,
    bdflush = 134,
    sysfs = 135,
    personality = 136,
    afs_syscall = 137,
    setfsuid = 138,
    setfsgid = 139,
    _llseek = 140,
    getdents = 141,
    _newselect = 142,
    flock = 143,
    msync = 144,
    readv = 145,
    writev = 146,
    getsid = 147,
    fdatasync = 148,
    _sysctl = 149,
    mlock = 150,
    munlock = 151,
    mlockall = 152,
    munlockall = 153,
    sched_setparam = 154,
    sched_getparam = 155,
    sched_setscheduler = 156,
    sched_getscheduler = 157,
    sched_yield = 158,
    sched_get_priority_max = 159,
    sched_get_priority_min = 160,
    sched_rr_get_interval = 161,
    nanosleep = 162,
    mremap = 163,
    setresuid = 164,
    getresuid = 165,
    query_module = 166,
    poll = 167,
    nfsservctl = 168,
    setresgid = 169,
    getresgid = 170,
    prctl = 171,
    rt_sigreturn = 172,
    rt_sigaction = 173,
    rt_sigprocmask = 174,
    rt_sigpending = 175,
    rt_sigtimedwait = 176,
    rt_sigqueueinfo = 177,
    rt_sigsuspend = 178,
    pread64 = 179,
    pwrite64 = 180,
    chown = 181,
    getcwd = 182,
    capget = 183,
    capset = 184,
    sigaltstack = 185,
    sendfile = 186,
    getpmsg = 187,
    putpmsg = 188,
    vfork = 189,
    ugetrlimit = 190,
    readahead = 191,
    mmap2 = 192,
    truncate64 = 193,
    ftruncate64 = 194,
    stat64 = 195,
    lstat64 = 196,
    fstat64 = 197,
    pciconfig_read = 198,
    pciconfig_write = 199,
    pciconfig_iobase = 200,
    multiplexer = 201,
    getdents64 = 202,
    pivot_root = 203,
    fcntl64 = 204,
    madvise = 205,
    mincore = 206,
    gettid = 207,
    tkill = 208,
    setxattr = 209,
    lsetxattr = 210,
    fsetxattr = 211,
    getxattr = 212,
    lgetxattr = 213,
    fgetxattr = 214,
    listxattr = 215,
    llistxattr = 216,
    flistxattr = 217,
    removexattr = 218,
    lremovexattr = 219,
    fremovexattr = 220,
    futex = 221,
    sched_setaffinity = 222,
    sched_getaffinity = 223,
    tuxcall = 225,
    sendfile64 = 226,
    io_setup = 227,
    io_destroy = 228,
    io_getevents = 229,
    io_submit = 230,
    io_cancel = 231,
    set_tid_address = 232,
    fadvise64 = 233,
    exit_group = 234,
    lookup_dcookie = 235,
    epoll_create = 236,
    epoll_ctl = 237,
    epoll_wait = 238,
    remap_file_pages = 239,
    timer_create = 240,
    timer_settime = 241,
    timer_gettime = 242,
    timer_getoverrun = 243,
    timer_delete = 244,
    clock_settime = 245,
    clock_gettime = 246,
    clock_getres = 247,
    clock_nanosleep = 248,
    swapcontext = 249,
    tgkill = 250,
    utimes = 251,
    statfs64 = 252,
    fstatfs64 = 253,
    fadvise64_64 = 254,
    rtas = 255,
    sys_debug_setcontext = 256,
    migrate_pages = 258,
    mbind = 259,
    get_mempolicy = 260,
    set_mempolicy = 261,
    mq_open = 262,
    mq_unlink = 263,
    mq_timedsend = 264,
    mq_timedreceive = 265,
    mq_notify = 266,
    mq_getsetattr = 267,
    kexec_load = 268,
    add_key = 269,
    request_key = 270,
    keyctl = 271,
    waitid = 272,
    ioprio_set = 273,
    ioprio_get = 274,
    inotify_init = 275,
    inotify_add_watch = 276,
    inotify_rm_watch = 277,
    spu_run = 278,
    spu_create = 279,
    pselect6 = 280,
    ppoll = 281,
    unshare = 282,
    splice = 283,
    tee = 284,
    vmsplice = 285,
    openat = 286,
    mkdirat = 287,
    mknodat = 288,
    fchownat = 289,
    futimesat = 290,
    fstatat64 = 291,
    unlinkat = 292,
    renameat = 293,
    linkat = 294,
    symlinkat = 295,
    readlinkat = 296,
    fchmodat = 297,
    faccessat = 298,
    get_robust_list = 299,
    set_robust_list = 300,
    move_pages = 301,
    getcpu = 302,
    epoll_pwait = 303,
    utimensat = 304,
    signalfd = 305,
    timerfd_create = 306,
    eventfd = 307,
    sync_file_range = 308,
    fallocate = 309,
    subpage_prot = 310,
    timerfd_settime = 311,
    timerfd_gettime = 312,
    signalfd4 = 313,
    eventfd2 = 314,
    epoll_create1 = 315,
    dup3 = 316,
    pipe2 = 317,
    inotify_init1 = 318,
    perf_event_open = 319,
    preadv = 320,
    pwritev = 321,
    rt_tgsigqueueinfo = 322,
    fanotify_init = 323,
    fanotify_mark = 324,
    prlimit64 = 325,
    socket = 326,
    bind = 327,
    connect = 328,
    listen = 329,
    accept = 330,
    getsockname = 331,
    getpeername = 332,
    socketpair = 333,
    send = 334,
    sendto = 335,
    recv = 336,
    recvfrom = 337,
    shutdown = 338,
    setsockopt = 339,
    getsockopt = 340,
    sendmsg = 341,
    recvmsg = 342,
    recvmmsg = 343,
    accept4 = 344,
    name_to_handle_at = 345,
    open_by_handle_at = 346,
    clock_adjtime = 347,
    syncfs = 348,
    sendmmsg = 349,
    setns = 350,
    process_vm_readv = 351,
    process_vm_writev = 352,
    finit_module = 353,
    kcmp = 354,
    sched_setattr = 355,
    sched_getattr = 356,
    renameat2 = 357,
    seccomp = 358,
    getrandom = 359,
    memfd_create = 360,
    bpf = 361,
    execveat = 362,
    switch_endian = 363,
    userfaultfd = 364,
    membarrier = 365,
    mlock2 = 378,
    copy_file_range = 379,
    preadv2 = 380,
    pwritev2 = 381,
    kexec_file_load = 382,
    statx = 383,
    pkey_alloc = 384,
    pkey_free = 385,
    pkey_mprotect = 386,
    rseq = 387,
    io_pgetevents = 388,
    semget = 393,
    semctl = 394,
    shmget = 395,
    shmctl = 396,
    shmat = 397,
    shmdt = 398,
    msgget = 399,
    msgsnd = 400,
    msgrcv = 401,
    msgctl = 402,
    clock_gettime64 = 403,
    clock_settime64 = 404,
    clock_adjtime64 = 405,
    clock_getres_time64 = 406,
    clock_nanosleep_time64 = 407,
    timer_gettime64 = 408,
    timer_settime64 = 409,
    timerfd_gettime64 = 410,
    timerfd_settime64 = 411,
    utimensat_time64 = 412,
    pselect6_time64 = 413,
    ppoll_time64 = 414,
    io_pgetevents_time64 = 416,
    recvmmsg_time64 = 417,
    mq_timedsend_time64 = 418,
    mq_timedreceive_time64 = 419,
    semtimedop_time64 = 420,
    rt_sigtimedwait_time64 = 421,
    futex_time64 = 422,
    sched_rr_get_interval_time64 = 423,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const PowerPC64 = enum(usize) {
    restart_syscall = 0,
    exit = 1,
    fork = 2,
    read = 3,
    write = 4,
    open = 5,
    close = 6,
    waitpid = 7,
    creat = 8,
    link = 9,
    unlink = 10,
    execve = 11,
    chdir = 12,
    time = 13,
    mknod = 14,
    chmod = 15,
    lchown = 16,
    @"break" = 17,
    oldstat = 18,
    lseek = 19,
    getpid = 20,
    mount = 21,
    umount = 22,
    setuid = 23,
    getuid = 24,
    stime = 25,
    ptrace = 26,
    alarm = 27,
    oldfstat = 28,
    pause = 29,
    utime = 30,
    stty = 31,
    gtty = 32,
    access = 33,
    nice = 34,
    ftime = 35,
    sync = 36,
    kill = 37,
    rename = 38,
    mkdir = 39,
    rmdir = 40,
    dup = 41,
    pipe = 42,
    times = 43,
    prof = 44,
    brk = 45,
    setgid = 46,
    getgid = 47,
    signal = 48,
    geteuid = 49,
    getegid = 50,
    acct = 51,
    umount2 = 52,
    lock = 53,
    ioctl = 54,
    fcntl = 55,
    mpx = 56,
    setpgid = 57,
    ulimit = 58,
    oldolduname = 59,
    umask = 60,
    chroot = 61,
    ustat = 62,
    dup2 = 63,
    getppid = 64,
    getpgrp = 65,
    setsid = 66,
    sigaction = 67,
    sgetmask = 68,
    ssetmask = 69,
    setreuid = 70,
    setregid = 71,
    sigsuspend = 72,
    sigpending = 73,
    sethostname = 74,
    setrlimit = 75,
    getrlimit = 76,
    getrusage = 77,
    gettimeofday = 78,
    settimeofday = 79,
    getgroups = 80,
    setgroups = 81,
    select = 82,
    symlink = 83,
    oldlstat = 84,
    readlink = 85,
    uselib = 86,
    swapon = 87,
    reboot = 88,
    readdir = 89,
    mmap = 90,
    munmap = 91,
    truncate = 92,
    ftruncate = 93,
    fchmod = 94,
    fchown = 95,
    getpriority = 96,
    setpriority = 97,
    profil = 98,
    statfs = 99,
    fstatfs = 100,
    ioperm = 101,
    socketcall = 102,
    syslog = 103,
    setitimer = 104,
    getitimer = 105,
    stat = 106,
    lstat = 107,
    fstat = 108,
    olduname = 109,
    iopl = 110,
    vhangup = 111,
    idle = 112,
    vm86 = 113,
    wait4 = 114,
    swapoff = 115,
    sysinfo = 116,
    ipc = 117,
    fsync = 118,
    sigreturn = 119,
    clone = 120,
    setdomainname = 121,
    uname = 122,
    modify_ldt = 123,
    adjtimex = 124,
    mprotect = 125,
    sigprocmask = 126,
    create_module = 127,
    init_module = 128,
    delete_module = 129,
    get_kernel_syms = 130,
    quotactl = 131,
    getpgid = 132,
    fchdir = 133,
    bdflush = 134,
    sysfs = 135,
    personality = 136,
    afs_syscall = 137,
    setfsuid = 138,
    setfsgid = 139,
    _llseek = 140,
    getdents = 141,
    _newselect = 142,
    flock = 143,
    msync = 144,
    readv = 145,
    writev = 146,
    getsid = 147,
    fdatasync = 148,
    _sysctl = 149,
    mlock = 150,
    munlock = 151,
    mlockall = 152,
    munlockall = 153,
    sched_setparam = 154,
    sched_getparam = 155,
    sched_setscheduler = 156,
    sched_getscheduler = 157,
    sched_yield = 158,
    sched_get_priority_max = 159,
    sched_get_priority_min = 160,
    sched_rr_get_interval = 161,
    nanosleep = 162,
    mremap = 163,
    setresuid = 164,
    getresuid = 165,
    query_module = 166,
    poll = 167,
    nfsservctl = 168,
    setresgid = 169,
    getresgid = 170,
    prctl = 171,
    rt_sigreturn = 172,
    rt_sigaction = 173,
    rt_sigprocmask = 174,
    rt_sigpending = 175,
    rt_sigtimedwait = 176,
    rt_sigqueueinfo = 177,
    rt_sigsuspend = 178,
    pread64 = 179,
    pwrite64 = 180,
    chown = 181,
    getcwd = 182,
    capget = 183,
    capset = 184,
    sigaltstack = 185,
    sendfile = 186,
    getpmsg = 187,
    putpmsg = 188,
    vfork = 189,
    ugetrlimit = 190,
    readahead = 191,
    pciconfig_read = 198,
    pciconfig_write = 199,
    pciconfig_iobase = 200,
    multiplexer = 201,
    getdents64 = 202,
    pivot_root = 203,
    madvise = 205,
    mincore = 206,
    gettid = 207,
    tkill = 208,
    setxattr = 209,
    lsetxattr = 210,
    fsetxattr = 211,
    getxattr = 212,
    lgetxattr = 213,
    fgetxattr = 214,
    listxattr = 215,
    llistxattr = 216,
    flistxattr = 217,
    removexattr = 218,
    lremovexattr = 219,
    fremovexattr = 220,
    futex = 221,
    sched_setaffinity = 222,
    sched_getaffinity = 223,
    tuxcall = 225,
    io_setup = 227,
    io_destroy = 228,
    io_getevents = 229,
    io_submit = 230,
    io_cancel = 231,
    set_tid_address = 232,
    fadvise64 = 233,
    exit_group = 234,
    lookup_dcookie = 235,
    epoll_create = 236,
    epoll_ctl = 237,
    epoll_wait = 238,
    remap_file_pages = 239,
    timer_create = 240,
    timer_settime = 241,
    timer_gettime = 242,
    timer_getoverrun = 243,
    timer_delete = 244,
    clock_settime = 245,
    clock_gettime = 246,
    clock_getres = 247,
    clock_nanosleep = 248,
    swapcontext = 249,
    tgkill = 250,
    utimes = 251,
    statfs64 = 252,
    fstatfs64 = 253,
    rtas = 255,
    sys_debug_setcontext = 256,
    migrate_pages = 258,
    mbind = 259,
    get_mempolicy = 260,
    set_mempolicy = 261,
    mq_open = 262,
    mq_unlink = 263,
    mq_timedsend = 264,
    mq_timedreceive = 265,
    mq_notify = 266,
    mq_getsetattr = 267,
    kexec_load = 268,
    add_key = 269,
    request_key = 270,
    keyctl = 271,
    waitid = 272,
    ioprio_set = 273,
    ioprio_get = 274,
    inotify_init = 275,
    inotify_add_watch = 276,
    inotify_rm_watch = 277,
    spu_run = 278,
    spu_create = 279,
    pselect6 = 280,
    ppoll = 281,
    unshare = 282,
    splice = 283,
    tee = 284,
    vmsplice = 285,
    openat = 286,
    mkdirat = 287,
    mknodat = 288,
    fchownat = 289,
    futimesat = 290,
    fstatat64 = 291,
    unlinkat = 292,
    renameat = 293,
    linkat = 294,
    symlinkat = 295,
    readlinkat = 296,
    fchmodat = 297,
    faccessat = 298,
    get_robust_list = 299,
    set_robust_list = 300,
    move_pages = 301,
    getcpu = 302,
    epoll_pwait = 303,
    utimensat = 304,
    signalfd = 305,
    timerfd_create = 306,
    eventfd = 307,
    sync_file_range = 308,
    fallocate = 309,
    subpage_prot = 310,
    timerfd_settime = 311,
    timerfd_gettime = 312,
    signalfd4 = 313,
    eventfd2 = 314,
    epoll_create1 = 315,
    dup3 = 316,
    pipe2 = 317,
    inotify_init1 = 318,
    perf_event_open = 319,
    preadv = 320,
    pwritev = 321,
    rt_tgsigqueueinfo = 322,
    fanotify_init = 323,
    fanotify_mark = 324,
    prlimit64 = 325,
    socket = 326,
    bind = 327,
    connect = 328,
    listen = 329,
    accept = 330,
    getsockname = 331,
    getpeername = 332,
    socketpair = 333,
    send = 334,
    sendto = 335,
    recv = 336,
    recvfrom = 337,
    shutdown = 338,
    setsockopt = 339,
    getsockopt = 340,
    sendmsg = 341,
    recvmsg = 342,
    recvmmsg = 343,
    accept4 = 344,
    name_to_handle_at = 345,
    open_by_handle_at = 346,
    clock_adjtime = 347,
    syncfs = 348,
    sendmmsg = 349,
    setns = 350,
    process_vm_readv = 351,
    process_vm_writev = 352,
    finit_module = 353,
    kcmp = 354,
    sched_setattr = 355,
    sched_getattr = 356,
    renameat2 = 357,
    seccomp = 358,
    getrandom = 359,
    memfd_create = 360,
    bpf = 361,
    execveat = 362,
    switch_endian = 363,
    userfaultfd = 364,
    membarrier = 365,
    mlock2 = 378,
    copy_file_range = 379,
    preadv2 = 380,
    pwritev2 = 381,
    kexec_file_load = 382,
    statx = 383,
    pkey_alloc = 384,
    pkey_free = 385,
    pkey_mprotect = 386,
    rseq = 387,
    io_pgetevents = 388,
    semtimedop = 392,
    semget = 393,
    semctl = 394,
    shmget = 395,
    shmctl = 396,
    shmat = 397,
    shmdt = 398,
    msgget = 399,
    msgsnd = 400,
    msgrcv = 401,
    msgctl = 402,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const Arm64 = enum(usize) {
    io_setup = 0,
    io_destroy = 1,
    io_submit = 2,
    io_cancel = 3,
    io_getevents = 4,
    setxattr = 5,
    lsetxattr = 6,
    fsetxattr = 7,
    getxattr = 8,
    lgetxattr = 9,
    fgetxattr = 10,
    listxattr = 11,
    llistxattr = 12,
    flistxattr = 13,
    removexattr = 14,
    lremovexattr = 15,
    fremovexattr = 16,
    getcwd = 17,
    lookup_dcookie = 18,
    eventfd2 = 19,
    epoll_create1 = 20,
    epoll_ctl = 21,
    epoll_pwait = 22,
    dup = 23,
    dup3 = 24,
    fcntl = 25,
    inotify_init1 = 26,
    inotify_add_watch = 27,
    inotify_rm_watch = 28,
    ioctl = 29,
    ioprio_set = 30,
    ioprio_get = 31,
    flock = 32,
    mknodat = 33,
    mkdirat = 34,
    unlinkat = 35,
    symlinkat = 36,
    linkat = 37,
    renameat = 38,
    umount2 = 39,
    mount = 40,
    pivot_root = 41,
    nfsservctl = 42,
    statfs = 43,
    fstatfs = 44,
    truncate = 45,
    ftruncate = 46,
    fallocate = 47,
    faccessat = 48,
    chdir = 49,
    fchdir = 50,
    chroot = 51,
    fchmod = 52,
    fchmodat = 53,
    fchownat = 54,
    fchown = 55,
    openat = 56,
    close = 57,
    vhangup = 58,
    pipe2 = 59,
    quotactl = 60,
    getdents64 = 61,
    lseek = 62,
    read = 63,
    write = 64,
    readv = 65,
    writev = 66,
    pread64 = 67,
    pwrite64 = 68,
    preadv = 69,
    pwritev = 70,
    sendfile = 71,
    pselect6 = 72,
    ppoll = 73,
    signalfd4 = 74,
    vmsplice = 75,
    splice = 76,
    tee = 77,
    readlinkat = 78,
    fstatat = 79,
    fstat = 80,
    sync = 81,
    fsync = 82,
    fdatasync = 83,
    sync_file_range = 84,
    timerfd_create = 85,
    timerfd_settime = 86,
    timerfd_gettime = 87,
    utimensat = 88,
    acct = 89,
    capget = 90,
    capset = 91,
    personality = 92,
    exit = 93,
    exit_group = 94,
    waitid = 95,
    set_tid_address = 96,
    unshare = 97,
    futex = 98,
    set_robust_list = 99,
    get_robust_list = 100,
    nanosleep = 101,
    getitimer = 102,
    setitimer = 103,
    kexec_load = 104,
    init_module = 105,
    delete_module = 106,
    timer_create = 107,
    timer_gettime = 108,
    timer_getoverrun = 109,
    timer_settime = 110,
    timer_delete = 111,
    clock_settime = 112,
    clock_gettime = 113,
    clock_getres = 114,
    clock_nanosleep = 115,
    syslog = 116,
    ptrace = 117,
    sched_setparam = 118,
    sched_setscheduler = 119,
    sched_getscheduler = 120,
    sched_getparam = 121,
    sched_setaffinity = 122,
    sched_getaffinity = 123,
    sched_yield = 124,
    sched_get_priority_max = 125,
    sched_get_priority_min = 126,
    sched_rr_get_interval = 127,
    restart_syscall = 128,
    kill = 129,
    tkill = 130,
    tgkill = 131,
    sigaltstack = 132,
    rt_sigsuspend = 133,
    rt_sigaction = 134,
    rt_sigprocmask = 135,
    rt_sigpending = 136,
    rt_sigtimedwait = 137,
    rt_sigqueueinfo = 138,
    rt_sigreturn = 139,
    setpriority = 140,
    getpriority = 141,
    reboot = 142,
    setregid = 143,
    setgid = 144,
    setreuid = 145,
    setuid = 146,
    setresuid = 147,
    getresuid = 148,
    setresgid = 149,
    getresgid = 150,
    setfsuid = 151,
    setfsgid = 152,
    times = 153,
    setpgid = 154,
    getpgid = 155,
    getsid = 156,
    setsid = 157,
    getgroups = 158,
    setgroups = 159,
    uname = 160,
    sethostname = 161,
    setdomainname = 162,
    getrlimit = 163,
    setrlimit = 164,
    getrusage = 165,
    umask = 166,
    prctl = 167,
    getcpu = 168,
    gettimeofday = 169,
    settimeofday = 170,
    adjtimex = 171,
    getpid = 172,
    getppid = 173,
    getuid = 174,
    geteuid = 175,
    getgid = 176,
    getegid = 177,
    gettid = 178,
    sysinfo = 179,
    mq_open = 180,
    mq_unlink = 181,
    mq_timedsend = 182,
    mq_timedreceive = 183,
    mq_notify = 184,
    mq_getsetattr = 185,
    msgget = 186,
    msgctl = 187,
    msgrcv = 188,
    msgsnd = 189,
    semget = 190,
    semctl = 191,
    semtimedop = 192,
    semop = 193,
    shmget = 194,
    shmctl = 195,
    shmat = 196,
    shmdt = 197,
    socket = 198,
    socketpair = 199,
    bind = 200,
    listen = 201,
    accept = 202,
    connect = 203,
    getsockname = 204,
    getpeername = 205,
    sendto = 206,
    recvfrom = 207,
    setsockopt = 208,
    getsockopt = 209,
    shutdown = 210,
    sendmsg = 211,
    recvmsg = 212,
    readahead = 213,
    brk = 214,
    munmap = 215,
    mremap = 216,
    add_key = 217,
    request_key = 218,
    keyctl = 219,
    clone = 220,
    execve = 221,
    mmap = 222,
    fadvise64 = 223,
    swapon = 224,
    swapoff = 225,
    mprotect = 226,
    msync = 227,
    mlock = 228,
    munlock = 229,
    mlockall = 230,
    munlockall = 231,
    mincore = 232,
    madvise = 233,
    remap_file_pages = 234,
    mbind = 235,
    get_mempolicy = 236,
    set_mempolicy = 237,
    migrate_pages = 238,
    move_pages = 239,
    rt_tgsigqueueinfo = 240,
    perf_event_open = 241,
    accept4 = 242,
    recvmmsg = 243,
    wait4 = 260,
    prlimit64 = 261,
    fanotify_init = 262,
    fanotify_mark = 263,
    name_to_handle_at = 264,
    open_by_handle_at = 265,
    clock_adjtime = 266,
    syncfs = 267,
    setns = 268,
    sendmmsg = 269,
    process_vm_readv = 270,
    process_vm_writev = 271,
    kcmp = 272,
    finit_module = 273,
    sched_setattr = 274,
    sched_getattr = 275,
    renameat2 = 276,
    seccomp = 277,
    getrandom = 278,
    memfd_create = 279,
    bpf = 280,
    execveat = 281,
    userfaultfd = 282,
    membarrier = 283,
    mlock2 = 284,
    copy_file_range = 285,
    preadv2 = 286,
    pwritev2 = 287,
    pkey_mprotect = 288,
    pkey_alloc = 289,
    pkey_free = 290,
    statx = 291,
    io_pgetevents = 292,
    rseq = 293,
    kexec_file_load = 294,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    memfd_secret = 447,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};

pub const RiscV64 = enum(usize) {
    pub const arch_specific_syscall = 244;

    io_setup = 0,
    io_destroy = 1,
    io_submit = 2,
    io_cancel = 3,
    io_getevents = 4,
    setxattr = 5,
    lsetxattr = 6,
    fsetxattr = 7,
    getxattr = 8,
    lgetxattr = 9,
    fgetxattr = 10,
    listxattr = 11,
    llistxattr = 12,
    flistxattr = 13,
    removexattr = 14,
    lremovexattr = 15,
    fremovexattr = 16,
    getcwd = 17,
    lookup_dcookie = 18,
    eventfd2 = 19,
    epoll_create1 = 20,
    epoll_ctl = 21,
    epoll_pwait = 22,
    dup = 23,
    dup3 = 24,
    fcntl = 25,
    inotify_init1 = 26,
    inotify_add_watch = 27,
    inotify_rm_watch = 28,
    ioctl = 29,
    ioprio_set = 30,
    ioprio_get = 31,
    flock = 32,
    mknodat = 33,
    mkdirat = 34,
    unlinkat = 35,
    symlinkat = 36,
    linkat = 37,
    umount2 = 39,
    mount = 40,
    pivot_root = 41,
    nfsservctl = 42,
    statfs = 43,
    fstatfs = 44,
    truncate = 45,
    ftruncate = 46,
    fallocate = 47,
    faccessat = 48,
    chdir = 49,
    fchdir = 50,
    chroot = 51,
    fchmod = 52,
    fchmodat = 53,
    fchownat = 54,
    fchown = 55,
    openat = 56,
    close = 57,
    vhangup = 58,
    pipe2 = 59,
    quotactl = 60,
    getdents64 = 61,
    lseek = 62,
    read = 63,
    write = 64,
    readv = 65,
    writev = 66,
    pread64 = 67,
    pwrite64 = 68,
    preadv = 69,
    pwritev = 70,
    sendfile = 71,
    pselect6 = 72,
    ppoll = 73,
    signalfd4 = 74,
    vmsplice = 75,
    splice = 76,
    tee = 77,
    readlinkat = 78,
    fstatat = 79,
    fstat = 80,
    sync = 81,
    fsync = 82,
    fdatasync = 83,
    sync_file_range = 84,
    timerfd_create = 85,
    timerfd_settime = 86,
    timerfd_gettime = 87,
    utimensat = 88,
    acct = 89,
    capget = 90,
    capset = 91,
    personality = 92,
    exit = 93,
    exit_group = 94,
    waitid = 95,
    set_tid_address = 96,
    unshare = 97,
    futex = 98,
    set_robust_list = 99,
    get_robust_list = 100,
    nanosleep = 101,
    getitimer = 102,
    setitimer = 103,
    kexec_load = 104,
    init_module = 105,
    delete_module = 106,
    timer_create = 107,
    timer_gettime = 108,
    timer_getoverrun = 109,
    timer_settime = 110,
    timer_delete = 111,
    clock_settime = 112,
    clock_gettime = 113,
    clock_getres = 114,
    clock_nanosleep = 115,
    syslog = 116,
    ptrace = 117,
    sched_setparam = 118,
    sched_setscheduler = 119,
    sched_getscheduler = 120,
    sched_getparam = 121,
    sched_setaffinity = 122,
    sched_getaffinity = 123,
    sched_yield = 124,
    sched_get_priority_max = 125,
    sched_get_priority_min = 126,
    sched_rr_get_interval = 127,
    restart_syscall = 128,
    kill = 129,
    tkill = 130,
    tgkill = 131,
    sigaltstack = 132,
    rt_sigsuspend = 133,
    rt_sigaction = 134,
    rt_sigprocmask = 135,
    rt_sigpending = 136,
    rt_sigtimedwait = 137,
    rt_sigqueueinfo = 138,
    rt_sigreturn = 139,
    setpriority = 140,
    getpriority = 141,
    reboot = 142,
    setregid = 143,
    setgid = 144,
    setreuid = 145,
    setuid = 146,
    setresuid = 147,
    getresuid = 148,
    setresgid = 149,
    getresgid = 150,
    setfsuid = 151,
    setfsgid = 152,
    times = 153,
    setpgid = 154,
    getpgid = 155,
    getsid = 156,
    setsid = 157,
    getgroups = 158,
    setgroups = 159,
    uname = 160,
    sethostname = 161,
    setdomainname = 162,
    getrlimit = 163,
    setrlimit = 164,
    getrusage = 165,
    umask = 166,
    prctl = 167,
    getcpu = 168,
    gettimeofday = 169,
    settimeofday = 170,
    adjtimex = 171,
    getpid = 172,
    getppid = 173,
    getuid = 174,
    geteuid = 175,
    getgid = 176,
    getegid = 177,
    gettid = 178,
    sysinfo = 179,
    mq_open = 180,
    mq_unlink = 181,
    mq_timedsend = 182,
    mq_timedreceive = 183,
    mq_notify = 184,
    mq_getsetattr = 185,
    msgget = 186,
    msgctl = 187,
    msgrcv = 188,
    msgsnd = 189,
    semget = 190,
    semctl = 191,
    semtimedop = 192,
    semop = 193,
    shmget = 194,
    shmctl = 195,
    shmat = 196,
    shmdt = 197,
    socket = 198,
    socketpair = 199,
    bind = 200,
    listen = 201,
    accept = 202,
    connect = 203,
    getsockname = 204,
    getpeername = 205,
    sendto = 206,
    recvfrom = 207,
    setsockopt = 208,
    getsockopt = 209,
    shutdown = 210,
    sendmsg = 211,
    recvmsg = 212,
    readahead = 213,
    brk = 214,
    munmap = 215,
    mremap = 216,
    add_key = 217,
    request_key = 218,
    keyctl = 219,
    clone = 220,
    execve = 221,
    mmap = 222,
    fadvise64 = 223,
    swapon = 224,
    swapoff = 225,
    mprotect = 226,
    msync = 227,
    mlock = 228,
    munlock = 229,
    mlockall = 230,
    munlockall = 231,
    mincore = 232,
    madvise = 233,
    remap_file_pages = 234,
    mbind = 235,
    get_mempolicy = 236,
    set_mempolicy = 237,
    migrate_pages = 238,
    move_pages = 239,
    rt_tgsigqueueinfo = 240,
    perf_event_open = 241,
    accept4 = 242,
    recvmmsg = 243,
    wait4 = 260,
    prlimit64 = 261,
    fanotify_init = 262,
    fanotify_mark = 263,
    name_to_handle_at = 264,
    open_by_handle_at = 265,
    clock_adjtime = 266,
    syncfs = 267,
    setns = 268,
    sendmmsg = 269,
    process_vm_readv = 270,
    process_vm_writev = 271,
    kcmp = 272,
    finit_module = 273,
    sched_setattr = 274,
    sched_getattr = 275,
    renameat2 = 276,
    seccomp = 277,
    getrandom = 278,
    memfd_create = 279,
    bpf = 280,
    execveat = 281,
    userfaultfd = 282,
    membarrier = 283,
    mlock2 = 284,
    copy_file_range = 285,
    preadv2 = 286,
    pwritev2 = 287,
    pkey_mprotect = 288,
    pkey_alloc = 289,
    pkey_free = 290,
    statx = 291,
    io_pgetevents = 292,
    rseq = 293,
    kexec_file_load = 294,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    memfd_secret = 447,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,

    riscv_flush_icache = arch_specific_syscall + 15,
};

pub const LoongArch64 = enum(usize) {
    io_setup = 0,
    io_destroy = 1,
    io_submit = 2,
    io_cancel = 3,
    io_getevents = 4,
    setxattr = 5,
    lsetxattr = 6,
    fsetxattr = 7,
    getxattr = 8,
    lgetxattr = 9,
    fgetxattr = 10,
    listxattr = 11,
    llistxattr = 12,
    flistxattr = 13,
    removexattr = 14,
    lremovexattr = 15,
    fremovexattr = 16,
    getcwd = 17,
    lookup_dcookie = 18,
    eventfd2 = 19,
    epoll_create1 = 20,
    epoll_ctl = 21,
    epoll_pwait = 22,
    dup = 23,
    dup3 = 24,
    fcntl = 25,
    inotify_init1 = 26,
    inotify_add_watch = 27,
    inotify_rm_watch = 28,
    ioctl = 29,
    ioprio_set = 30,
    ioprio_get = 31,
    flock = 32,
    mknodat = 33,
    mkdirat = 34,
    unlinkat = 35,
    symlinkat = 36,
    linkat = 37,
    umount2 = 39,
    mount = 40,
    pivot_root = 41,
    nfsservctl = 42,
    statfs = 43,
    fstatfs = 44,
    truncate = 45,
    ftruncate = 46,
    fallocate = 47,
    faccessat = 48,
    chdir = 49,
    fchdir = 50,
    chroot = 51,
    fchmod = 52,
    fchmodat = 53,
    fchownat = 54,
    fchown = 55,
    openat = 56,
    close = 57,
    vhangup = 58,
    pipe2 = 59,
    quotactl = 60,
    getdents64 = 61,
    lseek = 62,
    read = 63,
    write = 64,
    readv = 65,
    writev = 66,
    pread64 = 67,
    pwrite64 = 68,
    preadv = 69,
    pwritev = 70,
    sendfile = 71,
    pselect6 = 72,
    ppoll = 73,
    signalfd4 = 74,
    vmsplice = 75,
    splice = 76,
    tee = 77,
    readlinkat = 78,
    sync = 81,
    fsync = 82,
    fdatasync = 83,
    sync_file_range = 84,
    timerfd_create = 85,
    timerfd_settime = 86,
    timerfd_gettime = 87,
    utimensat = 88,
    acct = 89,
    capget = 90,
    capset = 91,
    personality = 92,
    exit = 93,
    exit_group = 94,
    waitid = 95,
    set_tid_address = 96,
    unshare = 97,
    futex = 98,
    set_robust_list = 99,
    get_robust_list = 100,
    nanosleep = 101,
    getitimer = 102,
    setitimer = 103,
    kexec_load = 104,
    init_module = 105,
    delete_module = 106,
    timer_create = 107,
    timer_gettime = 108,
    timer_getoverrun = 109,
    timer_settime = 110,
    timer_delete = 111,
    clock_settime = 112,
    clock_gettime = 113,
    clock_getres = 114,
    clock_nanosleep = 115,
    syslog = 116,
    ptrace = 117,
    sched_setparam = 118,
    sched_setscheduler = 119,
    sched_getscheduler = 120,
    sched_getparam = 121,
    sched_setaffinity = 122,
    sched_getaffinity = 123,
    sched_yield = 124,
    sched_get_priority_max = 125,
    sched_get_priority_min = 126,
    sched_rr_get_interval = 127,
    restart_syscall = 128,
    kill = 129,
    tkill = 130,
    tgkill = 131,
    sigaltstack = 132,
    rt_sigsuspend = 133,
    rt_sigaction = 134,
    rt_sigprocmask = 135,
    rt_sigpending = 136,
    rt_sigtimedwait = 137,
    rt_sigqueueinfo = 138,
    rt_sigreturn = 139,
    setpriority = 140,
    getpriority = 141,
    reboot = 142,
    setregid = 143,
    setgid = 144,
    setreuid = 145,
    setuid = 146,
    setresuid = 147,
    getresuid = 148,
    setresgid = 149,
    getresgid = 150,
    setfsuid = 151,
    setfsgid = 152,
    times = 153,
    setpgid = 154,
    getpgid = 155,
    getsid = 156,
    setsid = 157,
    getgroups = 158,
    setgroups = 159,
    uname = 160,
    sethostname = 161,
    setdomainname = 162,
    getrusage = 165,
    umask = 166,
    prctl = 167,
    getcpu = 168,
    gettimeofday = 169,
    settimeofday = 170,
    adjtimex = 171,
    getpid = 172,
    getppid = 173,
    getuid = 174,
    geteuid = 175,
    getgid = 176,
    getegid = 177,
    gettid = 178,
    sysinfo = 179,
    mq_open = 180,
    mq_unlink = 181,
    mq_timedsend = 182,
    mq_timedreceive = 183,
    mq_notify = 184,
    mq_getsetattr = 185,
    msgget = 186,
    msgctl = 187,
    msgrcv = 188,
    msgsnd = 189,
    semget = 190,
    semctl = 191,
    semtimedop = 192,
    semop = 193,
    shmget = 194,
    shmctl = 195,
    shmat = 196,
    shmdt = 197,
    socket = 198,
    socketpair = 199,
    bind = 200,
    listen = 201,
    accept = 202,
    connect = 203,
    getsockname = 204,
    getpeername = 205,
    sendto = 206,
    recvfrom = 207,
    setsockopt = 208,
    getsockopt = 209,
    shutdown = 210,
    sendmsg = 211,
    recvmsg = 212,
    readahead = 213,
    brk = 214,
    munmap = 215,
    mremap = 216,
    add_key = 217,
    request_key = 218,
    keyctl = 219,
    clone = 220,
    execve = 221,
    mmap = 222,
    fadvise64 = 223,
    swapon = 224,
    swapoff = 225,
    mprotect = 226,
    msync = 227,
    mlock = 228,
    munlock = 229,
    mlockall = 230,
    munlockall = 231,
    mincore = 232,
    madvise = 233,
    remap_file_pages = 234,
    mbind = 235,
    get_mempolicy = 236,
    set_mempolicy = 237,
    migrate_pages = 238,
    move_pages = 239,
    rt_tgsigqueueinfo = 240,
    perf_event_open = 241,
    accept4 = 242,
    recvmmsg = 243,
    wait4 = 260,
    prlimit64 = 261,
    fanotify_init = 262,
    fanotify_mark = 263,
    name_to_handle_at = 264,
    open_by_handle_at = 265,
    clock_adjtime = 266,
    syncfs = 267,
    setns = 268,
    sendmmsg = 269,
    process_vm_readv = 270,
    process_vm_writev = 271,
    kcmp = 272,
    finit_module = 273,
    sched_setattr = 274,
    sched_getattr = 275,
    renameat2 = 276,
    seccomp = 277,
    getrandom = 278,
    memfd_create = 279,
    bpf = 280,
    execveat = 281,
    userfaultfd = 282,
    membarrier = 283,
    mlock2 = 284,
    copy_file_range = 285,
    preadv2 = 286,
    pwritev2 = 287,
    pkey_mprotect = 288,
    pkey_alloc = 289,
    pkey_free = 290,
    statx = 291,
    io_pgetevents = 292,
    rseq = 293,
    kexec_file_load = 294,
    pidfd_send_signal = 424,
    io_uring_setup = 425,
    io_uring_enter = 426,
    io_uring_register = 427,
    open_tree = 428,
    move_mount = 429,
    fsopen = 430,
    fsconfig = 431,
    fsmount = 432,
    fspick = 433,
    pidfd_open = 434,
    clone3 = 435,
    close_range = 436,
    openat2 = 437,
    pidfd_getfd = 438,
    faccessat2 = 439,
    process_madvise = 440,
    epoll_pwait2 = 441,
    mount_setattr = 442,
    quotactl_fd = 443,
    landlock_create_ruleset = 444,
    landlock_add_rule = 445,
    landlock_restrict_self = 446,
    process_mrelease = 448,
    futex_waitv = 449,
    set_mempolicy_home_node = 450,
    cachestat = 451,
    fchmodat2 = 452,
    map_shadow_stack = 453,
    futex_wake = 454,
    futex_wait = 455,
    futex_requeue = 456,
};
