/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content.x509;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.x509.XMLX509DataContent;
import com.sun.org.apache.xml.internal.security.utils.RFC2253Parser;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLX509IssuerSerial
extends SignatureElementProxy
implements XMLX509DataContent {
    private static Logger log = Logger.getLogger(XMLX509IssuerSerial.class.getName());

    public XMLX509IssuerSerial(Element element, String baseURI) throws XMLSecurityException {
        super(element, baseURI);
    }

    public XMLX509IssuerSerial(Document doc, String x509IssuerName, BigInteger x509SerialNumber) {
        super(doc);
        XMLUtils.addReturnToElement(this.constructionElement);
        this.addTextElement(x509IssuerName, "X509IssuerName");
        this.addTextElement(x509SerialNumber.toString(), "X509SerialNumber");
    }

    public XMLX509IssuerSerial(Document doc, String x509IssuerName, String x509SerialNumber) {
        this(doc, x509IssuerName, new BigInteger(x509SerialNumber));
    }

    public XMLX509IssuerSerial(Document doc, String x509IssuerName, int x509SerialNumber) {
        this(doc, x509IssuerName, new BigInteger(Integer.toString(x509SerialNumber)));
    }

    public XMLX509IssuerSerial(Document doc, X509Certificate x509certificate) {
        this(doc, x509certificate.getIssuerX500Principal().getName(), x509certificate.getSerialNumber());
    }

    public BigInteger getSerialNumber() {
        String text = this.getTextFromChildElement("X509SerialNumber", "http://www.w3.org/2000/09/xmldsig#");
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "X509SerialNumber text: " + text);
        }
        return new BigInteger(text);
    }

    public int getSerialNumberInteger() {
        return this.getSerialNumber().intValue();
    }

    public String getIssuerName() {
        return RFC2253Parser.normalize(this.getTextFromChildElement("X509IssuerName", "http://www.w3.org/2000/09/xmldsig#"));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XMLX509IssuerSerial)) {
            return false;
        }
        XMLX509IssuerSerial other = (XMLX509IssuerSerial)obj;
        return this.getSerialNumber().equals(other.getSerialNumber()) && this.getIssuerName().equals(other.getIssuerName());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getSerialNumber().hashCode();
        result = 31 * result + this.getIssuerName().hashCode();
        return result;
    }

    @Override
    public String getBaseLocalName() {
        return "X509IssuerSerial";
    }
}

