/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.UnsupportedEncodingException;
import org.hsqldb.error.Error;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;

public class TextFileSettings {
    public static final String NL = System.getProperty("line.separator");
    public String fs;
    public String vs;
    public String lvs;
    public String qc;
    public char quoteChar;
    public String stringEncoding;
    public boolean isQuoted;
    public boolean isAllQuoted;
    public boolean isIgnoreFirst;
    public boolean isNullDef;
    public String charEncoding;
    public boolean isUTF8;
    public boolean isUTF16;
    public boolean hasUTF16BOM;
    public boolean isLittleEndian;
    private static final byte[] BYTES_NL = NL.getBytes();
    private static final byte[] SP = new byte[]{32};
    String dataFileName;
    int maxCacheRows;
    int maxCacheBytes;
    char singleSeparator = '\u0000';
    byte[] bytesForLineEnd = BYTES_NL;
    byte[] bytesForSpace = SP;
    static final char DOUBLE_QUOTE_CHAR = '\"';
    static final char BACKSLASH_CHAR = '\\';
    public static final char LF_CHAR = '\n';
    public static final char CR_CHAR = '\r';

    TextFileSettings(HsqlDatabaseProperties hsqlDatabaseProperties, String string) {
        HsqlProperties hsqlProperties = HsqlProperties.delimitedArgPairsToProps(string, "=", ";", "textdb");
        switch (hsqlProperties.errorCodes.length) {
            case 0: {
                this.dataFileName = null;
                break;
            }
            case 1: {
                this.dataFileName = hsqlProperties.errorKeys[0].trim();
                break;
            }
            default: {
                throw Error.error(302);
            }
        }
        this.fs = hsqlDatabaseProperties.getStringProperty("textdb.fs");
        this.fs = hsqlProperties.getProperty("textdb.fs", this.fs);
        this.vs = hsqlDatabaseProperties.getStringProperty("textdb.vs");
        this.vs = hsqlProperties.getProperty("textdb.vs", this.vs);
        this.lvs = hsqlDatabaseProperties.getStringProperty("textdb.lvs");
        this.lvs = hsqlProperties.getProperty("textdb.lvs", this.lvs);
        this.qc = hsqlDatabaseProperties.getStringProperty("textdb.qc");
        this.qc = hsqlProperties.getProperty("textdb.qc", this.qc);
        if (this.vs == null) {
            this.vs = this.fs;
        }
        if (this.lvs == null) {
            this.lvs = this.fs;
        }
        this.fs = TextFileSettings.translateSep(this.fs);
        this.vs = TextFileSettings.translateSep(this.vs);
        this.lvs = TextFileSettings.translateSep(this.lvs);
        this.qc = TextFileSettings.translateSep(this.qc);
        if (this.fs.length() == 0 || this.vs.length() == 0 || this.lvs.length() == 0) {
            throw Error.error(303);
        }
        if (this.qc.length() != 1) {
            throw Error.error(304);
        }
        this.quoteChar = this.qc.charAt(0);
        if (this.quoteChar > '\u007f') {
            throw Error.error(304);
        }
        this.isIgnoreFirst = hsqlDatabaseProperties.isPropertyTrue("textdb.ignore_first");
        this.isIgnoreFirst = hsqlProperties.isPropertyTrue("textdb.ignore_first", this.isIgnoreFirst);
        this.isQuoted = hsqlDatabaseProperties.isPropertyTrue("textdb.quoted");
        this.isQuoted = hsqlProperties.isPropertyTrue("textdb.quoted", this.isQuoted);
        this.isAllQuoted = hsqlDatabaseProperties.isPropertyTrue("textdb.all_quoted");
        this.isAllQuoted = hsqlProperties.isPropertyTrue("textdb.all_quoted", this.isAllQuoted);
        this.isNullDef = hsqlDatabaseProperties.isPropertyTrue("textdb.null_def");
        this.isNullDef = hsqlProperties.isPropertyTrue("textdb.null_def", this.isNullDef);
        this.stringEncoding = hsqlDatabaseProperties.getStringProperty("textdb.encoding");
        this.charEncoding = this.stringEncoding = hsqlProperties.getProperty("textdb.encoding", this.stringEncoding);
        if ("UTF8".equals(this.stringEncoding)) {
            this.isUTF8 = true;
        } else if ("UTF-8".equals(this.stringEncoding)) {
            this.isUTF8 = true;
        } else if ("UTF-16".equals(this.stringEncoding)) {
            this.charEncoding = "UTF-16BE";
            this.isUTF16 = true;
        } else if ("UTF-16BE".equals(this.stringEncoding)) {
            this.isUTF16 = true;
        } else if ("UTF-16LE".equals(this.stringEncoding)) {
            this.isUTF16 = true;
            this.isLittleEndian = true;
        }
        this.setSpaceAndLineEnd();
        if (this.fs.length() == 1 || this.fs.length() == 2 && this.fs.endsWith("\n")) {
            this.singleSeparator = this.fs.charAt(0);
        }
        int n = hsqlDatabaseProperties.getIntegerProperty("textdb.cache_scale");
        n = hsqlProperties.getIntegerProperty("textdb.cache_scale", n);
        int n2 = hsqlDatabaseProperties.getIntegerProperty("textdb.cache_size_scale");
        n2 = hsqlProperties.getIntegerProperty("textdb.cache_size_scale", n2);
        this.maxCacheRows = (1 << n) * 3;
        this.maxCacheRows = hsqlDatabaseProperties.getIntegerProperty("textdb.cache_rows", this.maxCacheRows);
        this.maxCacheRows = hsqlProperties.getIntegerProperty("textdb.cache_rows", this.maxCacheRows);
        this.maxCacheBytes = (1 << n2) * this.maxCacheRows / 1024;
        if (this.maxCacheBytes < 4) {
            this.maxCacheBytes = 4;
        }
        this.maxCacheBytes = hsqlDatabaseProperties.getIntegerProperty("textdb.cache_size", this.maxCacheBytes);
        this.maxCacheBytes = hsqlProperties.getIntegerProperty("textdb.cache_size", this.maxCacheBytes);
        this.maxCacheBytes *= 1024;
    }

    String getFileName() {
        return this.dataFileName;
    }

    int getMaxCacheRows() {
        return this.maxCacheRows;
    }

    int getMaxCacheBytes() {
        return this.maxCacheBytes;
    }

    void setLittleEndianByteOrderMark() {
        if (!"UTF-16".equals(this.stringEncoding)) {
            throw Error.error(331);
        }
        this.charEncoding = "UTF-16LE";
        this.isLittleEndian = true;
        this.hasUTF16BOM = true;
    }

    void setSpaceAndLineEnd() {
        try {
            if (this.isUTF16) {
                this.bytesForLineEnd = NL.getBytes(this.charEncoding);
                this.bytesForSpace = " ".getBytes(this.charEncoding);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Error.error(331, unsupportedEncodingException);
        }
    }

    private static String translateSep(String string) {
        return TextFileSettings.translateSep(string, false);
    }

    private static String translateSep(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(92);
        if (n != -1) {
            int n2 = 0;
            char[] cArray = string.toCharArray();
            int n3 = 0;
            int n4 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n4);
            do {
                stringBuilder.append(cArray, n2, n - n2);
                n2 = ++n;
                if (n >= n4) {
                    stringBuilder.append('\\');
                    break;
                }
                if (!bl) {
                    n3 = cArray[n];
                }
                if (n3 == 110) {
                    stringBuilder.append('\n');
                    ++n2;
                    continue;
                }
                if (n3 == 114) {
                    stringBuilder.append('\r');
                    ++n2;
                    continue;
                }
                if (n3 == 116) {
                    stringBuilder.append('\t');
                    ++n2;
                    continue;
                }
                if (n3 == 92) {
                    stringBuilder.append('\\');
                    ++n2;
                    continue;
                }
                if (n3 == 117) {
                    stringBuilder.append((char)Integer.parseInt(string.substring(++n2, n2 + 4), 16));
                    n2 += 4;
                    continue;
                }
                if (string.startsWith("semi", n)) {
                    stringBuilder.append(';');
                    n2 += 4;
                    continue;
                }
                if (string.startsWith("space", n)) {
                    stringBuilder.append(' ');
                    n2 += 5;
                    continue;
                }
                if (string.startsWith("quote", n)) {
                    stringBuilder.append('\"');
                    n2 += 5;
                    continue;
                }
                if (string.startsWith("apos", n)) {
                    stringBuilder.append('\'');
                    n2 += 4;
                    continue;
                }
                if (string.startsWith("colon", n)) {
                    stringBuilder.append(':');
                    n2 += 5;
                    continue;
                }
                stringBuilder.append('\\');
                stringBuilder.append(cArray[n]);
                ++n2;
            } while ((n = string.indexOf(92, n2)) != -1);
            stringBuilder.append(cArray, n2, n4 - n2);
            string = stringBuilder.toString();
        }
        return string;
    }
}

