/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.hasher;

import com.password4j.BcryptFunction;
import com.password4j.HashingFunction;
import com.password4j.Password;
import com.password4j.types.Bcrypt;
import java.nio.CharBuffer;
import java.security.AccessController;
import java.security.Permission;
import java.util.Arrays;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.SpecialPermission;
import org.opensearch.core.common.Strings;
import org.opensearch.security.hasher.PasswordHasher;

public class BCryptPasswordHasher
implements PasswordHasher {
    private static final HashingFunction DEFAULT_BCRYPT_FUNCTION = BcryptFunction.getInstance((Bcrypt)Bcrypt.Y, (int)12);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hash(char[] password) {
        if (password == null || password.length == 0) {
            throw new OpenSearchSecurityException("Password cannot be empty or null", new Object[0]);
        }
        CharBuffer passwordBuffer = CharBuffer.wrap(password);
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission((Permission)new SpecialPermission());
            }
            String string = AccessController.doPrivileged(() -> Password.hash((CharSequence)passwordBuffer).with(DEFAULT_BCRYPT_FUNCTION).getResult());
            return string;
        }
        finally {
            this.cleanup(passwordBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean check(char[] password, String hash) {
        if (password == null || password.length == 0) {
            throw new OpenSearchSecurityException("Password cannot be empty or null", new Object[0]);
        }
        if (Strings.isNullOrEmpty((String)hash)) {
            throw new OpenSearchSecurityException("Hash cannot be empty or null", new Object[0]);
        }
        CharBuffer passwordBuffer = CharBuffer.wrap(password);
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission((Permission)new SpecialPermission());
            }
            boolean bl = AccessController.doPrivileged(() -> Password.check((CharSequence)passwordBuffer, (String)hash).with(this.getBCryptFunctionFromHash(hash)));
            return bl;
        }
        finally {
            this.cleanup(passwordBuffer);
        }
    }

    private void cleanup(CharBuffer password) {
        password.clear();
        char[] passwordOverwrite = new char[password.capacity()];
        Arrays.fill(passwordOverwrite, '\u0000');
        password.put(passwordOverwrite);
    }

    private HashingFunction getBCryptFunctionFromHash(String hash) {
        return BcryptFunction.getInstanceFromHash((String)hash);
    }
}

