/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.latex.CsvList;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import java.io.IOException;

public class SequenceCommand
extends Command {
    protected TeXObjectList content;

    public SequenceCommand(String string) {
        super(string);
        this.content = new TeXObjectList();
    }

    public SequenceCommand(String string, int n) {
        super(string);
        this.content = new TeXObjectList(n);
    }

    public SequenceCommand(String string, SequenceCommand sequenceCommand) {
        super(string);
        this.content = (TeXObjectList)sequenceCommand.content.clone();
    }

    public static SequenceCommand createFromSeqContent(TeXParser teXParser, String string, TeXObjectList teXObjectList) throws IOException {
        SequenceCommand sequenceCommand = new SequenceCommand(string);
        if (!teXObjectList.isEmpty()) {
            boolean bl = false;
            while (!teXObjectList.isEmpty()) {
                TeXObject teXObject = teXObjectList.popStack(teXParser, TeXObjectList.POP_IGNORE_LEADING_SPACE);
                if (bl) {
                    if (!(teXObject instanceof ControlSequence) || !((ControlSequence)teXObject).getName().equals("__seq_item:n")) continue;
                    teXObject = teXObjectList.popArg(teXParser);
                    sequenceCommand.append(teXObject);
                    continue;
                }
                if (teXObject instanceof WhiteSpace) continue;
                if (teXObject instanceof ControlSequence && ((ControlSequence)teXObject).getName().equals("s__seq")) {
                    bl = true;
                    continue;
                }
                throw new LaTeXSyntaxException(teXParser, "latex.not.sequence", string);
            }
        }
        return sequenceCommand;
    }

    public static SequenceCommand createFromClist(TeXParser teXParser, String string, CsvList csvList) {
        SequenceCommand sequenceCommand = new SequenceCommand(string, csvList.capacity());
        for (int i = 0; i < csvList.size(); ++i) {
            TeXObject teXObject = (TeXObject)csvList.get(i);
            if (teXParser.isStack(teXObject) && teXObject.isEmpty()) continue;
            TeXObject teXObject2 = csvList.getValue(i, true);
            sequenceCommand.append(teXObject2);
        }
        return sequenceCommand;
    }

    @Override
    public Object clone() {
        SequenceCommand sequenceCommand = new SequenceCommand(this.getName(), this.content.capacity());
        for (TeXObject teXObject : this.content) {
            sequenceCommand.append((TeXObject)teXObject.clone());
        }
        return sequenceCommand;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = TeXParserUtils.createStack(teXParser, new TeXObject[0]);
        if (!this.content.isEmpty()) {
            teXObjectList2.add(new TeXCsRef("s__seq"));
            for (TeXObject teXObject : this.content) {
                teXObjectList2.add(new TeXCsRef("__seq_item:n"));
                teXObjectList2.add(TeXParserUtils.createGroup(teXParser, teXObject));
            }
        }
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList);
    }

    public void setContent(TeXObjectList teXObjectList) {
        this.content = teXObjectList;
    }

    public TeXObjectList getContent() {
        return this.content;
    }

    public void append(TeXObject teXObject) {
        this.content.add(teXObject);
    }

    public void prepend(TeXObject teXObject) {
        this.content.add(0, teXObject);
    }

    public void setItem(int n, TeXObject teXObject) throws ArrayIndexOutOfBoundsException {
        if (n < 1 || n > this.content.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this.content.set(n - 1, teXObject);
    }

    public TeXObject set(int n, TeXObject teXObject) throws ArrayIndexOutOfBoundsException {
        return this.content.set(n, teXObject);
    }

    public TeXObject get(int n) {
        return (TeXObject)this.content.get(n);
    }

    public TeXObject item(int n) {
        if (this.content.size() > n) {
            return new TeXObjectList();
        }
        return (TeXObject)this.content.get(n - 1);
    }

    public int size() {
        return this.content.size();
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public void clear() {
        this.content.clear();
    }

    public TeXObject firstElement() {
        if (this.content.isEmpty()) {
            return new TeXCsRef("q_no_value");
        }
        return (TeXObject)this.content.firstElement();
    }

    public TeXObject lastElement() {
        if (this.content.isEmpty()) {
            return new TeXCsRef("q_no_value");
        }
        return (TeXObject)this.content.lastElement();
    }

    public TeXObject popFirst() {
        if (this.content.isEmpty()) {
            return new TeXCsRef("q_no_value");
        }
        return (TeXObject)this.content.remove(0);
    }

    public TeXObject popLast() {
        if (this.content.isEmpty()) {
            return new TeXCsRef("q_no_value");
        }
        return (TeXObject)this.content.remove(this.content.size() - 1);
    }
}

