# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class SubResource(_serialization.Model):
    """Reference to another subresource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AgentPool(SubResource):  # pylint: disable=too-many-instance-attributes
    """Agent Pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for
     system pools. The default value is 1.
    :vartype count: int
    :ivar vm_size: Size of agent VMs. Known values are: "Standard_A1", "Standard_A10",
     "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
     "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
     "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
     "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
     "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
     "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
     "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
     "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
     "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
     "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
     "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
     "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
     "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
     "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
     "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
     "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
     "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
     "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
     "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
     "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
     "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
     "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
     "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
     "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
     "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
     "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
     "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
     "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
     "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
     "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
     "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
     "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
     "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
     "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", and "Standard_NV6".
    :vartype vm_size: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceVMSizeTypes
    :ivar os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every machine
     in this master/agent pool. If you specify 0, it will apply the default osDisk size according to
     the vmSize specified.
    :vartype os_disk_size_gb: int
    :ivar os_disk_type: OS disk type to be used for machines in a given agent pool. Allowed values
     are 'Ephemeral' and 'Managed'. If unspecified, defaults to 'Ephemeral' when the VM supports
     ephemeral OS and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults
     to 'Managed'. May not be changed after creation. Known values are: "Managed" and "Ephemeral".
    :vartype os_disk_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OSDiskType
    :ivar kubelet_disk_type: KubeletDiskType determines the placement of emptyDir volumes,
     container runtime data root, and Kubelet ephemeral storage. Currently allows one value, OS,
     resulting in Kubelet using the OS disk for data. "OS"
    :vartype kubelet_disk_type: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.KubeletDiskType
    :ivar vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier for nodes and maybe
     pods.
    :vartype vnet_subnet_id: str
    :ivar pod_subnet_id: Pod SubnetID specifies the VNet's subnet identifier for pods.
    :vartype pod_subnet_id: str
    :ivar max_pods: Maximum number of pods that can run on a node.
    :vartype max_pods: int
    :ivar os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Known values are: "Linux" and "Windows".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OSType
    :ivar max_count: Maximum number of nodes for auto-scaling.
    :vartype max_count: int
    :ivar min_count: Minimum number of nodes for auto-scaling.
    :vartype min_count: int
    :ivar enable_auto_scaling: Whether to enable auto-scaler.
    :vartype enable_auto_scaling: bool
    :ivar type_properties_type: AgentPoolType represents types of an agent pool. Known values are:
     "VirtualMachineScaleSets" and "AvailabilitySet".
    :vartype type_properties_type: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolType
    :ivar mode: AgentPoolMode represents mode of an agent pool. Known values are: "System" and
     "User".
    :vartype mode: str or ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolMode
    :ivar orchestrator_version: Version of orchestrator specified when creating the managed
     cluster.
    :vartype orchestrator_version: str
    :ivar node_image_version: Version of node image.
    :vartype node_image_version: str
    :ivar upgrade_settings: Settings for upgrading the agentpool.
    :vartype upgrade_settings:
     ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar power_state: Describes whether the Agent Pool is Running or Stopped.
    :vartype power_state: ~azure.mgmt.containerservice.v2020_12_01.models.PowerState
    :ivar availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
     AgentPoolType.
    :vartype availability_zones: list[str]
    :ivar enable_node_public_ip: Enable public IP for nodes.
    :vartype enable_node_public_ip: bool
    :ivar scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
     priority. Default to regular. Known values are: "Spot" and "Regular".
    :vartype scale_set_priority: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.ScaleSetPriority
    :ivar scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction policy
     for Spot virtual machine scale set. Default to Delete. Known values are: "Delete" and
     "Deallocate".
    :vartype scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.ScaleSetEvictionPolicy
    :ivar spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing to
     pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
     indicates default price to be up-to on-demand.
    :vartype spot_max_price: float
    :ivar tags: Agent pool tags to be persisted on the agent pool virtual machine scale set.
    :vartype tags: dict[str, str]
    :ivar node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
    :vartype node_labels: dict[str, str]
    :ivar node_taints: Taints added to new nodes during node pool create and scale. For example,
     key=value:NoSchedule.
    :vartype node_taints: list[str]
    :ivar proximity_placement_group_id: The ID for Proximity Placement Group.
    :vartype proximity_placement_group_id: str
    :ivar kubelet_config: KubeletConfig specifies the configuration of kubelet on agent nodes.
    :vartype kubelet_config: ~azure.mgmt.containerservice.v2020_12_01.models.KubeletConfig
    :ivar linux_os_config: LinuxOSConfig specifies the OS configuration of linux agent nodes.
    :vartype linux_os_config: ~azure.mgmt.containerservice.v2020_12_01.models.LinuxOSConfig
    :ivar enable_encryption_at_host: Whether to enable EncryptionAtHost.
    :vartype enable_encryption_at_host: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "os_disk_size_gb": {"maximum": 1023, "minimum": 0},
        "node_image_version": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "power_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "count": {"key": "properties.count", "type": "int"},
        "vm_size": {"key": "properties.vmSize", "type": "str"},
        "os_disk_size_gb": {"key": "properties.osDiskSizeGB", "type": "int"},
        "os_disk_type": {"key": "properties.osDiskType", "type": "str"},
        "kubelet_disk_type": {"key": "properties.kubeletDiskType", "type": "str"},
        "vnet_subnet_id": {"key": "properties.vnetSubnetID", "type": "str"},
        "pod_subnet_id": {"key": "properties.podSubnetID", "type": "str"},
        "max_pods": {"key": "properties.maxPods", "type": "int"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "max_count": {"key": "properties.maxCount", "type": "int"},
        "min_count": {"key": "properties.minCount", "type": "int"},
        "enable_auto_scaling": {"key": "properties.enableAutoScaling", "type": "bool"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "mode": {"key": "properties.mode", "type": "str"},
        "orchestrator_version": {"key": "properties.orchestratorVersion", "type": "str"},
        "node_image_version": {"key": "properties.nodeImageVersion", "type": "str"},
        "upgrade_settings": {"key": "properties.upgradeSettings", "type": "AgentPoolUpgradeSettings"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "power_state": {"key": "properties.powerState", "type": "PowerState"},
        "availability_zones": {"key": "properties.availabilityZones", "type": "[str]"},
        "enable_node_public_ip": {"key": "properties.enableNodePublicIP", "type": "bool"},
        "scale_set_priority": {"key": "properties.scaleSetPriority", "type": "str"},
        "scale_set_eviction_policy": {"key": "properties.scaleSetEvictionPolicy", "type": "str"},
        "spot_max_price": {"key": "properties.spotMaxPrice", "type": "float"},
        "tags": {"key": "properties.tags", "type": "{str}"},
        "node_labels": {"key": "properties.nodeLabels", "type": "{str}"},
        "node_taints": {"key": "properties.nodeTaints", "type": "[str]"},
        "proximity_placement_group_id": {"key": "properties.proximityPlacementGroupID", "type": "str"},
        "kubelet_config": {"key": "properties.kubeletConfig", "type": "KubeletConfig"},
        "linux_os_config": {"key": "properties.linuxOSConfig", "type": "LinuxOSConfig"},
        "enable_encryption_at_host": {"key": "properties.enableEncryptionAtHost", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        count: Optional[int] = None,
        vm_size: Optional[Union[str, "_models.ContainerServiceVMSizeTypes"]] = None,
        os_disk_size_gb: Optional[int] = None,
        os_disk_type: Optional[Union[str, "_models.OSDiskType"]] = None,
        kubelet_disk_type: Optional[Union[str, "_models.KubeletDiskType"]] = None,
        vnet_subnet_id: Optional[str] = None,
        pod_subnet_id: Optional[str] = None,
        max_pods: Optional[int] = None,
        os_type: Union[str, "_models.OSType"] = "Linux",
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: Optional[bool] = None,
        type_properties_type: Optional[Union[str, "_models.AgentPoolType"]] = None,
        mode: Optional[Union[str, "_models.AgentPoolMode"]] = None,
        orchestrator_version: Optional[str] = None,
        upgrade_settings: Optional["_models.AgentPoolUpgradeSettings"] = None,
        availability_zones: Optional[List[str]] = None,
        enable_node_public_ip: Optional[bool] = None,
        scale_set_priority: Union[str, "_models.ScaleSetPriority"] = "Regular",
        scale_set_eviction_policy: Union[str, "_models.ScaleSetEvictionPolicy"] = "Delete",
        spot_max_price: float = -1,
        tags: Optional[Dict[str, str]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        proximity_placement_group_id: Optional[str] = None,
        kubelet_config: Optional["_models.KubeletConfig"] = None,
        linux_os_config: Optional["_models.LinuxOSConfig"] = None,
        enable_encryption_at_host: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword count: Number of agents (VMs) to host docker containers. Allowed values must be in the
         range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for
         system pools. The default value is 1.
        :paramtype count: int
        :keyword vm_size: Size of agent VMs. Known values are: "Standard_A1", "Standard_A10",
         "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
         "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
         "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
         "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
         "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
         "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
         "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
         "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
         "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
         "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
         "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
         "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
         "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
         "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
         "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
         "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
         "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
         "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
         "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
         "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
         "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
         "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
         "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
         "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
         "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
         "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
         "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
         "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
         "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
         "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
         "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
         "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
         "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
         "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
         "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
         "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
         "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", and "Standard_NV6".
        :paramtype vm_size: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceVMSizeTypes
        :keyword os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
         machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
         according to the vmSize specified.
        :paramtype os_disk_size_gb: int
        :keyword os_disk_type: OS disk type to be used for machines in a given agent pool. Allowed
         values are 'Ephemeral' and 'Managed'. If unspecified, defaults to 'Ephemeral' when the VM
         supports ephemeral OS and has a cache disk larger than the requested OSDiskSizeGB. Otherwise,
         defaults to 'Managed'. May not be changed after creation. Known values are: "Managed" and
         "Ephemeral".
        :paramtype os_disk_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OSDiskType
        :keyword kubelet_disk_type: KubeletDiskType determines the placement of emptyDir volumes,
         container runtime data root, and Kubelet ephemeral storage. Currently allows one value, OS,
         resulting in Kubelet using the OS disk for data. "OS"
        :paramtype kubelet_disk_type: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.KubeletDiskType
        :keyword vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier for nodes and
         maybe pods.
        :paramtype vnet_subnet_id: str
        :keyword pod_subnet_id: Pod SubnetID specifies the VNet's subnet identifier for pods.
        :paramtype pod_subnet_id: str
        :keyword max_pods: Maximum number of pods that can run on a node.
        :paramtype max_pods: int
        :keyword os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default
         to Linux. Known values are: "Linux" and "Windows".
        :paramtype os_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OSType
        :keyword max_count: Maximum number of nodes for auto-scaling.
        :paramtype max_count: int
        :keyword min_count: Minimum number of nodes for auto-scaling.
        :paramtype min_count: int
        :keyword enable_auto_scaling: Whether to enable auto-scaler.
        :paramtype enable_auto_scaling: bool
        :keyword type_properties_type: AgentPoolType represents types of an agent pool. Known values
         are: "VirtualMachineScaleSets" and "AvailabilitySet".
        :paramtype type_properties_type: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolType
        :keyword mode: AgentPoolMode represents mode of an agent pool. Known values are: "System" and
         "User".
        :paramtype mode: str or ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolMode
        :keyword orchestrator_version: Version of orchestrator specified when creating the managed
         cluster.
        :paramtype orchestrator_version: str
        :keyword upgrade_settings: Settings for upgrading the agentpool.
        :paramtype upgrade_settings:
         ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolUpgradeSettings
        :keyword availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
         AgentPoolType.
        :paramtype availability_zones: list[str]
        :keyword enable_node_public_ip: Enable public IP for nodes.
        :paramtype enable_node_public_ip: bool
        :keyword scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
         priority. Default to regular. Known values are: "Spot" and "Regular".
        :paramtype scale_set_priority: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.ScaleSetPriority
        :keyword scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction
         policy for Spot virtual machine scale set. Default to Delete. Known values are: "Delete" and
         "Deallocate".
        :paramtype scale_set_eviction_policy: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.ScaleSetEvictionPolicy
        :keyword spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing
         to pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
         indicates default price to be up-to on-demand.
        :paramtype spot_max_price: float
        :keyword tags: Agent pool tags to be persisted on the agent pool virtual machine scale set.
        :paramtype tags: dict[str, str]
        :keyword node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
        :paramtype node_labels: dict[str, str]
        :keyword node_taints: Taints added to new nodes during node pool create and scale. For example,
         key=value:NoSchedule.
        :paramtype node_taints: list[str]
        :keyword proximity_placement_group_id: The ID for Proximity Placement Group.
        :paramtype proximity_placement_group_id: str
        :keyword kubelet_config: KubeletConfig specifies the configuration of kubelet on agent nodes.
        :paramtype kubelet_config: ~azure.mgmt.containerservice.v2020_12_01.models.KubeletConfig
        :keyword linux_os_config: LinuxOSConfig specifies the OS configuration of linux agent nodes.
        :paramtype linux_os_config: ~azure.mgmt.containerservice.v2020_12_01.models.LinuxOSConfig
        :keyword enable_encryption_at_host: Whether to enable EncryptionAtHost.
        :paramtype enable_encryption_at_host: bool
        """
        super().__init__(**kwargs)
        self.count = count
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.os_disk_type = os_disk_type
        self.kubelet_disk_type = kubelet_disk_type
        self.vnet_subnet_id = vnet_subnet_id
        self.pod_subnet_id = pod_subnet_id
        self.max_pods = max_pods
        self.os_type = os_type
        self.max_count = max_count
        self.min_count = min_count
        self.enable_auto_scaling = enable_auto_scaling
        self.type_properties_type = type_properties_type
        self.mode = mode
        self.orchestrator_version = orchestrator_version
        self.node_image_version = None
        self.upgrade_settings = upgrade_settings
        self.provisioning_state = None
        self.power_state = None
        self.availability_zones = availability_zones
        self.enable_node_public_ip = enable_node_public_ip
        self.scale_set_priority = scale_set_priority
        self.scale_set_eviction_policy = scale_set_eviction_policy
        self.spot_max_price = spot_max_price
        self.tags = tags
        self.node_labels = node_labels
        self.node_taints = node_taints
        self.proximity_placement_group_id = proximity_placement_group_id
        self.kubelet_config = kubelet_config
        self.linux_os_config = linux_os_config
        self.enable_encryption_at_host = enable_encryption_at_host


class AgentPoolAvailableVersions(_serialization.Model):
    """The list of available versions for an agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Id of the agent pool available versions.
    :vartype id: str
    :ivar name: Name of the agent pool available versions.
    :vartype name: str
    :ivar type: Type of the agent pool  available versions.
    :vartype type: str
    :ivar agent_pool_versions: List of versions available for agent pool.
    :vartype agent_pool_versions:
     list[~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "agent_pool_versions": {
            "key": "properties.agentPoolVersions",
            "type": "[AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]",
        },
    }

    def __init__(
        self,
        *,
        agent_pool_versions: Optional[List["_models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword agent_pool_versions: List of versions available for agent pool.
        :paramtype agent_pool_versions:
         list[~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.agent_pool_versions = agent_pool_versions


class AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem(_serialization.Model):  # pylint: disable=name-too-long
    """AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem.

    :ivar default: Whether this version is the default agent pool version.
    :vartype default: bool
    :ivar kubernetes_version: Kubernetes version (major, minor, patch).
    :vartype kubernetes_version: str
    :ivar is_preview: Whether Kubernetes version is currently in preview.
    :vartype is_preview: bool
    """

    _attribute_map = {
        "default": {"key": "default", "type": "bool"},
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "is_preview": {"key": "isPreview", "type": "bool"},
    }

    def __init__(
        self,
        *,
        default: Optional[bool] = None,
        kubernetes_version: Optional[str] = None,
        is_preview: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword default: Whether this version is the default agent pool version.
        :paramtype default: bool
        :keyword kubernetes_version: Kubernetes version (major, minor, patch).
        :paramtype kubernetes_version: str
        :keyword is_preview: Whether Kubernetes version is currently in preview.
        :paramtype is_preview: bool
        """
        super().__init__(**kwargs)
        self.default = default
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class AgentPoolListResult(_serialization.Model):
    """The response from the List Agent Pools operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of agent pools.
    :vartype value: list[~azure.mgmt.containerservice.v2020_12_01.models.AgentPool]
    :ivar next_link: The URL to get the next set of agent pool results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AgentPool]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.AgentPool"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of agent pools.
        :paramtype value: list[~azure.mgmt.containerservice.v2020_12_01.models.AgentPool]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AgentPoolUpgradeProfile(_serialization.Model):
    """The list of available upgrades for an agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Id of the agent pool upgrade profile.
    :vartype id: str
    :ivar name: Name of the agent pool upgrade profile.
    :vartype name: str
    :ivar type: Type of the agent pool upgrade profile.
    :vartype type: str
    :ivar kubernetes_version: Kubernetes version (major, minor, patch). Required.
    :vartype kubernetes_version: str
    :ivar os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Known values are: "Linux" and "Windows".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OSType
    :ivar upgrades: List of orchestrator types and versions available for upgrade.
    :vartype upgrades:
     list[~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolUpgradeProfilePropertiesUpgradesItem]
    :ivar latest_node_image_version: LatestNodeImageVersion is the latest AKS supported node image
     version.
    :vartype latest_node_image_version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kubernetes_version": {"required": True},
        "os_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kubernetes_version": {"key": "properties.kubernetesVersion", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "upgrades": {"key": "properties.upgrades", "type": "[AgentPoolUpgradeProfilePropertiesUpgradesItem]"},
        "latest_node_image_version": {"key": "properties.latestNodeImageVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        kubernetes_version: str,
        os_type: Union[str, "_models.OSType"] = "Linux",
        upgrades: Optional[List["_models.AgentPoolUpgradeProfilePropertiesUpgradesItem"]] = None,
        latest_node_image_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kubernetes_version: Kubernetes version (major, minor, patch). Required.
        :paramtype kubernetes_version: str
        :keyword os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default
         to Linux. Known values are: "Linux" and "Windows".
        :paramtype os_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OSType
        :keyword upgrades: List of orchestrator types and versions available for upgrade.
        :paramtype upgrades:
         list[~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolUpgradeProfilePropertiesUpgradesItem]
        :keyword latest_node_image_version: LatestNodeImageVersion is the latest AKS supported node
         image version.
        :paramtype latest_node_image_version: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.kubernetes_version = kubernetes_version
        self.os_type = os_type
        self.upgrades = upgrades
        self.latest_node_image_version = latest_node_image_version


class AgentPoolUpgradeProfilePropertiesUpgradesItem(_serialization.Model):  # pylint: disable=name-too-long
    """AgentPoolUpgradeProfilePropertiesUpgradesItem.

    :ivar kubernetes_version: Kubernetes version (major, minor, patch).
    :vartype kubernetes_version: str
    :ivar is_preview: Whether Kubernetes version is currently in preview.
    :vartype is_preview: bool
    """

    _attribute_map = {
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "is_preview": {"key": "isPreview", "type": "bool"},
    }

    def __init__(
        self, *, kubernetes_version: Optional[str] = None, is_preview: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kubernetes_version: Kubernetes version (major, minor, patch).
        :paramtype kubernetes_version: str
        :keyword is_preview: Whether Kubernetes version is currently in preview.
        :paramtype is_preview: bool
        """
        super().__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class AgentPoolUpgradeSettings(_serialization.Model):
    """Settings for upgrading an agentpool.

    :ivar max_surge: Count or percentage of additional nodes to be added during upgrade. If empty
     uses AKS default.
    :vartype max_surge: str
    """

    _attribute_map = {
        "max_surge": {"key": "maxSurge", "type": "str"},
    }

    def __init__(self, *, max_surge: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword max_surge: Count or percentage of additional nodes to be added during upgrade. If
         empty uses AKS default.
        :paramtype max_surge: str
        """
        super().__init__(**kwargs)
        self.max_surge = max_surge


class CloudError(_serialization.Model):
    """An error response from the Container service.

    :ivar error: Details about the error.
    :vartype error: ~azure.mgmt.containerservice.v2020_12_01.models.CloudErrorBody
    """

    _attribute_map = {
        "error": {"key": "error", "type": "CloudErrorBody"},
    }

    def __init__(self, *, error: Optional["_models.CloudErrorBody"] = None, **kwargs: Any) -> None:
        """
        :keyword error: Details about the error.
        :paramtype error: ~azure.mgmt.containerservice.v2020_12_01.models.CloudErrorBody
        """
        super().__init__(**kwargs)
        self.error = error


class CloudErrorBody(_serialization.Model):
    """An error response from the Container service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.containerservice.v2020_12_01.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.containerservice.v2020_12_01.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class Components1Q1Og48SchemasManagedclusterAllof1(
    _serialization.Model
):  # pylint: disable=too-many-instance-attributes,name-too-long
    """Components1Q1Og48SchemasManagedclusterAllof1.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar identity: The identity of the managed cluster, if configured.
    :vartype identity: ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterIdentity
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar power_state: Represents the Power State of the cluster.
    :vartype power_state: ~azure.mgmt.containerservice.v2020_12_01.models.PowerState
    :ivar max_agent_pools: The max number of agent pools for the managed cluster.
    :vartype max_agent_pools: int
    :ivar kubernetes_version: Version of Kubernetes specified when creating the managed cluster.
    :vartype kubernetes_version: str
    :ivar dns_prefix: DNS prefix specified when creating the managed cluster.
    :vartype dns_prefix: str
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    :ivar private_fqdn: FQDN of private cluster.
    :vartype private_fqdn: str
    :ivar agent_pool_profiles: Properties of the agent pool.
    :vartype agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAgentPoolProfile]
    :ivar linux_profile: Profile for Linux VMs in the container service cluster.
    :vartype linux_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceLinuxProfile
    :ivar windows_profile: Profile for Windows VMs in the container service cluster.
    :vartype windows_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterWindowsProfile
    :ivar service_principal_profile: Information about a service principal identity for the cluster
     to use for manipulating Azure APIs.
    :vartype service_principal_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterServicePrincipalProfile
    :ivar addon_profiles: Profile of managed cluster add-on.
    :vartype addon_profiles: dict[str,
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAddonProfile]
    :ivar pod_identity_profile: Profile of managed cluster pod identity.
    :vartype pod_identity_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPodIdentityProfile
    :ivar node_resource_group: Name of the resource group containing agent pool nodes.
    :vartype node_resource_group: str
    :ivar enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
    :vartype enable_rbac: bool
    :ivar enable_pod_security_policy: (DEPRECATING) Whether to enable Kubernetes pod security
     policy (preview). This feature is set for removal on October 15th, 2020. Learn more at
     aka.ms/aks/azpodpolicy.
    :vartype enable_pod_security_policy: bool
    :ivar network_profile: Profile of network configuration.
    :vartype network_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceNetworkProfile
    :ivar aad_profile: Profile of Azure Active Directory configuration.
    :vartype aad_profile: ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAADProfile
    :ivar auto_upgrade_profile: Profile of auto upgrade configuration.
    :vartype auto_upgrade_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAutoUpgradeProfile
    :ivar auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled.
    :vartype auto_scaler_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPropertiesAutoScalerProfile
    :ivar api_server_access_profile: Access profile for managed cluster API server.
    :vartype api_server_access_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAPIServerAccessProfile
    :ivar disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
     encryption at rest.
    :vartype disk_encryption_set_id: str
    :ivar identity_profile: Identities associated with the cluster.
    :vartype identity_profile: dict[str,
     ~azure.mgmt.containerservice.v2020_12_01.models.ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties]  # pylint: disable=line-too-long
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "power_state": {"readonly": True},
        "max_agent_pools": {"readonly": True},
        "fqdn": {"readonly": True},
        "private_fqdn": {"readonly": True},
    }

    _attribute_map = {
        "identity": {"key": "identity", "type": "ManagedClusterIdentity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "power_state": {"key": "properties.powerState", "type": "PowerState"},
        "max_agent_pools": {"key": "properties.maxAgentPools", "type": "int"},
        "kubernetes_version": {"key": "properties.kubernetesVersion", "type": "str"},
        "dns_prefix": {"key": "properties.dnsPrefix", "type": "str"},
        "fqdn": {"key": "properties.fqdn", "type": "str"},
        "private_fqdn": {"key": "properties.privateFQDN", "type": "str"},
        "agent_pool_profiles": {"key": "properties.agentPoolProfiles", "type": "[ManagedClusterAgentPoolProfile]"},
        "linux_profile": {"key": "properties.linuxProfile", "type": "ContainerServiceLinuxProfile"},
        "windows_profile": {"key": "properties.windowsProfile", "type": "ManagedClusterWindowsProfile"},
        "service_principal_profile": {
            "key": "properties.servicePrincipalProfile",
            "type": "ManagedClusterServicePrincipalProfile",
        },
        "addon_profiles": {"key": "properties.addonProfiles", "type": "{ManagedClusterAddonProfile}"},
        "pod_identity_profile": {"key": "properties.podIdentityProfile", "type": "ManagedClusterPodIdentityProfile"},
        "node_resource_group": {"key": "properties.nodeResourceGroup", "type": "str"},
        "enable_rbac": {"key": "properties.enableRBAC", "type": "bool"},
        "enable_pod_security_policy": {"key": "properties.enablePodSecurityPolicy", "type": "bool"},
        "network_profile": {"key": "properties.networkProfile", "type": "ContainerServiceNetworkProfile"},
        "aad_profile": {"key": "properties.aadProfile", "type": "ManagedClusterAADProfile"},
        "auto_upgrade_profile": {"key": "properties.autoUpgradeProfile", "type": "ManagedClusterAutoUpgradeProfile"},
        "auto_scaler_profile": {
            "key": "properties.autoScalerProfile",
            "type": "ManagedClusterPropertiesAutoScalerProfile",
        },
        "api_server_access_profile": {
            "key": "properties.apiServerAccessProfile",
            "type": "ManagedClusterAPIServerAccessProfile",
        },
        "disk_encryption_set_id": {"key": "properties.diskEncryptionSetID", "type": "str"},
        "identity_profile": {
            "key": "properties.identityProfile",
            "type": "{ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties}",
        },
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        identity: Optional["_models.ManagedClusterIdentity"] = None,
        kubernetes_version: Optional[str] = None,
        dns_prefix: Optional[str] = None,
        agent_pool_profiles: Optional[List["_models.ManagedClusterAgentPoolProfile"]] = None,
        linux_profile: Optional["_models.ContainerServiceLinuxProfile"] = None,
        windows_profile: Optional["_models.ManagedClusterWindowsProfile"] = None,
        service_principal_profile: Optional["_models.ManagedClusterServicePrincipalProfile"] = None,
        addon_profiles: Optional[Dict[str, "_models.ManagedClusterAddonProfile"]] = None,
        pod_identity_profile: Optional["_models.ManagedClusterPodIdentityProfile"] = None,
        node_resource_group: Optional[str] = None,
        enable_rbac: Optional[bool] = None,
        enable_pod_security_policy: Optional[bool] = None,
        network_profile: Optional["_models.ContainerServiceNetworkProfile"] = None,
        aad_profile: Optional["_models.ManagedClusterAADProfile"] = None,
        auto_upgrade_profile: Optional["_models.ManagedClusterAutoUpgradeProfile"] = None,
        auto_scaler_profile: Optional["_models.ManagedClusterPropertiesAutoScalerProfile"] = None,
        api_server_access_profile: Optional["_models.ManagedClusterAPIServerAccessProfile"] = None,
        disk_encryption_set_id: Optional[str] = None,
        identity_profile: Optional[
            Dict[
                str,
                "_models.ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties",
            ]
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity of the managed cluster, if configured.
        :paramtype identity: ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterIdentity
        :keyword kubernetes_version: Version of Kubernetes specified when creating the managed cluster.
        :paramtype kubernetes_version: str
        :keyword dns_prefix: DNS prefix specified when creating the managed cluster.
        :paramtype dns_prefix: str
        :keyword agent_pool_profiles: Properties of the agent pool.
        :paramtype agent_pool_profiles:
         list[~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAgentPoolProfile]
        :keyword linux_profile: Profile for Linux VMs in the container service cluster.
        :paramtype linux_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceLinuxProfile
        :keyword windows_profile: Profile for Windows VMs in the container service cluster.
        :paramtype windows_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterWindowsProfile
        :keyword service_principal_profile: Information about a service principal identity for the
         cluster to use for manipulating Azure APIs.
        :paramtype service_principal_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterServicePrincipalProfile
        :keyword addon_profiles: Profile of managed cluster add-on.
        :paramtype addon_profiles: dict[str,
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAddonProfile]
        :keyword pod_identity_profile: Profile of managed cluster pod identity.
        :paramtype pod_identity_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPodIdentityProfile
        :keyword node_resource_group: Name of the resource group containing agent pool nodes.
        :paramtype node_resource_group: str
        :keyword enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
        :paramtype enable_rbac: bool
        :keyword enable_pod_security_policy: (DEPRECATING) Whether to enable Kubernetes pod security
         policy (preview). This feature is set for removal on October 15th, 2020. Learn more at
         aka.ms/aks/azpodpolicy.
        :paramtype enable_pod_security_policy: bool
        :keyword network_profile: Profile of network configuration.
        :paramtype network_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceNetworkProfile
        :keyword aad_profile: Profile of Azure Active Directory configuration.
        :paramtype aad_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAADProfile
        :keyword auto_upgrade_profile: Profile of auto upgrade configuration.
        :paramtype auto_upgrade_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAutoUpgradeProfile
        :keyword auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled.
        :paramtype auto_scaler_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPropertiesAutoScalerProfile
        :keyword api_server_access_profile: Access profile for managed cluster API server.
        :paramtype api_server_access_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAPIServerAccessProfile
        :keyword disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
         encryption at rest.
        :paramtype disk_encryption_set_id: str
        :keyword identity_profile: Identities associated with the cluster.
        :paramtype identity_profile: dict[str,
         ~azure.mgmt.containerservice.v2020_12_01.models.ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties]  # pylint: disable=line-too-long
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.provisioning_state = None
        self.power_state = None
        self.max_agent_pools = None
        self.kubernetes_version = kubernetes_version
        self.dns_prefix = dns_prefix
        self.fqdn = None
        self.private_fqdn = None
        self.agent_pool_profiles = agent_pool_profiles
        self.linux_profile = linux_profile
        self.windows_profile = windows_profile
        self.service_principal_profile = service_principal_profile
        self.addon_profiles = addon_profiles
        self.pod_identity_profile = pod_identity_profile
        self.node_resource_group = node_resource_group
        self.enable_rbac = enable_rbac
        self.enable_pod_security_policy = enable_pod_security_policy
        self.network_profile = network_profile
        self.aad_profile = aad_profile
        self.auto_upgrade_profile = auto_upgrade_profile
        self.auto_scaler_profile = auto_scaler_profile
        self.api_server_access_profile = api_server_access_profile
        self.disk_encryption_set_id = disk_encryption_set_id
        self.identity_profile = identity_profile


class Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class UserAssignedIdentity(_serialization.Model):
    """UserAssignedIdentity.

    :ivar resource_id: The resource id of the user assigned identity.
    :vartype resource_id: str
    :ivar client_id: The client id of the user assigned identity.
    :vartype client_id: str
    :ivar object_id: The object id of the user assigned identity.
    :vartype object_id: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        client_id: Optional[str] = None,
        object_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The resource id of the user assigned identity.
        :paramtype resource_id: str
        :keyword client_id: The client id of the user assigned identity.
        :paramtype client_id: str
        :keyword object_id: The object id of the user assigned identity.
        :paramtype object_id: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.client_id = client_id
        self.object_id = object_id


class ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties(
    UserAssignedIdentity
):  # pylint: disable=name-too-long
    """ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties.

    :ivar resource_id: The resource id of the user assigned identity.
    :vartype resource_id: str
    :ivar client_id: The client id of the user assigned identity.
    :vartype client_id: str
    :ivar object_id: The object id of the user assigned identity.
    :vartype object_id: str
    """


class ContainerServiceDiagnosticsProfile(_serialization.Model):
    """Profile for diagnostics on the container service cluster.

    All required parameters must be populated in order to send to server.

    :ivar vm_diagnostics: Profile for diagnostics on the container service VMs. Required.
    :vartype vm_diagnostics:
     ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceVMDiagnostics
    """

    _validation = {
        "vm_diagnostics": {"required": True},
    }

    _attribute_map = {
        "vm_diagnostics": {"key": "vmDiagnostics", "type": "ContainerServiceVMDiagnostics"},
    }

    def __init__(self, *, vm_diagnostics: "_models.ContainerServiceVMDiagnostics", **kwargs: Any) -> None:
        """
        :keyword vm_diagnostics: Profile for diagnostics on the container service VMs. Required.
        :paramtype vm_diagnostics:
         ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceVMDiagnostics
        """
        super().__init__(**kwargs)
        self.vm_diagnostics = vm_diagnostics


class ContainerServiceLinuxProfile(_serialization.Model):
    """Profile for Linux VMs in the container service cluster.

    All required parameters must be populated in order to send to server.

    :ivar admin_username: The administrator username to use for Linux VMs. Required.
    :vartype admin_username: str
    :ivar ssh: SSH configuration for Linux-based VMs running on Azure. Required.
    :vartype ssh: ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceSshConfiguration
    """

    _validation = {
        "admin_username": {"required": True, "pattern": r"^[A-Za-z][-A-Za-z0-9_]*$"},
        "ssh": {"required": True},
    }

    _attribute_map = {
        "admin_username": {"key": "adminUsername", "type": "str"},
        "ssh": {"key": "ssh", "type": "ContainerServiceSshConfiguration"},
    }

    def __init__(self, *, admin_username: str, ssh: "_models.ContainerServiceSshConfiguration", **kwargs: Any) -> None:
        """
        :keyword admin_username: The administrator username to use for Linux VMs. Required.
        :paramtype admin_username: str
        :keyword ssh: SSH configuration for Linux-based VMs running on Azure. Required.
        :paramtype ssh:
         ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceSshConfiguration
        """
        super().__init__(**kwargs)
        self.admin_username = admin_username
        self.ssh = ssh


class ContainerServiceMasterProfile(_serialization.Model):
    """Profile for the container service master.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar count: Number of masters (VMs) in the container service cluster. Allowed values are 1, 3,
     and 5. The default value is 1. Known values are: 1, 3, and 5.
    :vartype count: int or ~azure.mgmt.containerservice.v2020_12_01.models.Count
    :ivar dns_prefix: DNS prefix to be used to create the FQDN for the master pool. Required.
    :vartype dns_prefix: str
    :ivar vm_size: Size of agent VMs. Required. Known values are: "Standard_A1", "Standard_A10",
     "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
     "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
     "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
     "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
     "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
     "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
     "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
     "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
     "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
     "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
     "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
     "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
     "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
     "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
     "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
     "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
     "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
     "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
     "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
     "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
     "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
     "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
     "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
     "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
     "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
     "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
     "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
     "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
     "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
     "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
     "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
     "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
     "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
     "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", and "Standard_NV6".
    :vartype vm_size: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceVMSizeTypes
    :ivar os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every machine
     in this master/agent pool. If you specify 0, it will apply the default osDisk size according to
     the vmSize specified.
    :vartype os_disk_size_gb: int
    :ivar vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
    :vartype vnet_subnet_id: str
    :ivar first_consecutive_static_ip: FirstConsecutiveStaticIP used to specify the first static ip
     of masters.
    :vartype first_consecutive_static_ip: str
    :ivar storage_profile: Storage profile specifies what kind of storage used. Choose from
     StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the
     orchestrator choice. Known values are: "StorageAccount" and "ManagedDisks".
    :vartype storage_profile: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceStorageProfileTypes
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    """

    _validation = {
        "dns_prefix": {"required": True},
        "vm_size": {"required": True},
        "os_disk_size_gb": {"maximum": 1023, "minimum": 0},
        "fqdn": {"readonly": True},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "dns_prefix": {"key": "dnsPrefix", "type": "str"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "os_disk_size_gb": {"key": "osDiskSizeGB", "type": "int"},
        "vnet_subnet_id": {"key": "vnetSubnetID", "type": "str"},
        "first_consecutive_static_ip": {"key": "firstConsecutiveStaticIP", "type": "str"},
        "storage_profile": {"key": "storageProfile", "type": "str"},
        "fqdn": {"key": "fqdn", "type": "str"},
    }

    def __init__(
        self,
        *,
        dns_prefix: str,
        vm_size: Union[str, "_models.ContainerServiceVMSizeTypes"],
        count: Union[int, "_models.Count"] = 1,
        os_disk_size_gb: Optional[int] = None,
        vnet_subnet_id: Optional[str] = None,
        first_consecutive_static_ip: str = "10.240.255.5",
        storage_profile: Optional[Union[str, "_models.ContainerServiceStorageProfileTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword count: Number of masters (VMs) in the container service cluster. Allowed values are 1,
         3, and 5. The default value is 1. Known values are: 1, 3, and 5.
        :paramtype count: int or ~azure.mgmt.containerservice.v2020_12_01.models.Count
        :keyword dns_prefix: DNS prefix to be used to create the FQDN for the master pool. Required.
        :paramtype dns_prefix: str
        :keyword vm_size: Size of agent VMs. Required. Known values are: "Standard_A1", "Standard_A10",
         "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
         "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
         "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
         "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
         "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
         "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
         "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
         "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
         "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
         "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
         "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
         "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
         "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
         "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
         "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
         "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
         "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
         "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
         "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
         "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
         "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
         "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
         "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
         "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
         "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
         "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
         "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
         "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
         "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
         "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
         "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
         "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
         "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
         "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
         "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
         "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
         "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", and "Standard_NV6".
        :paramtype vm_size: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceVMSizeTypes
        :keyword os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
         machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
         according to the vmSize specified.
        :paramtype os_disk_size_gb: int
        :keyword vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
        :paramtype vnet_subnet_id: str
        :keyword first_consecutive_static_ip: FirstConsecutiveStaticIP used to specify the first static
         ip of masters.
        :paramtype first_consecutive_static_ip: str
        :keyword storage_profile: Storage profile specifies what kind of storage used. Choose from
         StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the
         orchestrator choice. Known values are: "StorageAccount" and "ManagedDisks".
        :paramtype storage_profile: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceStorageProfileTypes
        """
        super().__init__(**kwargs)
        self.count = count
        self.dns_prefix = dns_prefix
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.vnet_subnet_id = vnet_subnet_id
        self.first_consecutive_static_ip = first_consecutive_static_ip
        self.storage_profile = storage_profile
        self.fqdn = None


class ContainerServiceNetworkProfile(_serialization.Model):
    """Profile of network configuration.

    :ivar network_plugin: Network plugin used for building Kubernetes network. Known values are:
     "azure" and "kubenet".
    :vartype network_plugin: str or ~azure.mgmt.containerservice.v2020_12_01.models.NetworkPlugin
    :ivar network_policy: Network policy used for building Kubernetes network. Known values are:
     "calico" and "azure".
    :vartype network_policy: str or ~azure.mgmt.containerservice.v2020_12_01.models.NetworkPolicy
    :ivar network_mode: Network mode used for building Kubernetes network. Known values are:
     "transparent" and "bridge".
    :vartype network_mode: str or ~azure.mgmt.containerservice.v2020_12_01.models.NetworkMode
    :ivar pod_cidr: A CIDR notation IP range from which to assign pod IPs when kubenet is used.
    :vartype pod_cidr: str
    :ivar service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must
     not overlap with any Subnet IP ranges.
    :vartype service_cidr: str
    :ivar dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within
     the Kubernetes service address range specified in serviceCidr.
    :vartype dns_service_ip: str
    :ivar docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It
     must not overlap with any Subnet IP ranges or the Kubernetes service address range.
    :vartype docker_bridge_cidr: str
    :ivar outbound_type: The outbound (egress) routing method. Known values are: "loadBalancer" and
     "userDefinedRouting".
    :vartype outbound_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OutboundType
    :ivar load_balancer_sku: The load balancer sku for the managed cluster. Known values are:
     "standard" and "basic".
    :vartype load_balancer_sku: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.LoadBalancerSku
    :ivar load_balancer_profile: Profile of the cluster load balancer.
    :vartype load_balancer_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterLoadBalancerProfile
    """

    _validation = {
        "pod_cidr": {"pattern": r"^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$"},
        "service_cidr": {"pattern": r"^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$"},
        "dns_service_ip": {
            "pattern": r"^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$"
        },
        "docker_bridge_cidr": {"pattern": r"^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$"},
    }

    _attribute_map = {
        "network_plugin": {"key": "networkPlugin", "type": "str"},
        "network_policy": {"key": "networkPolicy", "type": "str"},
        "network_mode": {"key": "networkMode", "type": "str"},
        "pod_cidr": {"key": "podCidr", "type": "str"},
        "service_cidr": {"key": "serviceCidr", "type": "str"},
        "dns_service_ip": {"key": "dnsServiceIP", "type": "str"},
        "docker_bridge_cidr": {"key": "dockerBridgeCidr", "type": "str"},
        "outbound_type": {"key": "outboundType", "type": "str"},
        "load_balancer_sku": {"key": "loadBalancerSku", "type": "str"},
        "load_balancer_profile": {"key": "loadBalancerProfile", "type": "ManagedClusterLoadBalancerProfile"},
    }

    def __init__(
        self,
        *,
        network_plugin: Union[str, "_models.NetworkPlugin"] = "kubenet",
        network_policy: Optional[Union[str, "_models.NetworkPolicy"]] = None,
        network_mode: Optional[Union[str, "_models.NetworkMode"]] = None,
        pod_cidr: str = "10.244.0.0/16",
        service_cidr: str = "10.0.0.0/16",
        dns_service_ip: str = "10.0.0.10",
        docker_bridge_cidr: str = "172.17.0.1/16",
        outbound_type: Union[str, "_models.OutboundType"] = "loadBalancer",
        load_balancer_sku: Optional[Union[str, "_models.LoadBalancerSku"]] = None,
        load_balancer_profile: Optional["_models.ManagedClusterLoadBalancerProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_plugin: Network plugin used for building Kubernetes network. Known values are:
         "azure" and "kubenet".
        :paramtype network_plugin: str or ~azure.mgmt.containerservice.v2020_12_01.models.NetworkPlugin
        :keyword network_policy: Network policy used for building Kubernetes network. Known values are:
         "calico" and "azure".
        :paramtype network_policy: str or ~azure.mgmt.containerservice.v2020_12_01.models.NetworkPolicy
        :keyword network_mode: Network mode used for building Kubernetes network. Known values are:
         "transparent" and "bridge".
        :paramtype network_mode: str or ~azure.mgmt.containerservice.v2020_12_01.models.NetworkMode
        :keyword pod_cidr: A CIDR notation IP range from which to assign pod IPs when kubenet is used.
        :paramtype pod_cidr: str
        :keyword service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It
         must not overlap with any Subnet IP ranges.
        :paramtype service_cidr: str
        :keyword dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be
         within the Kubernetes service address range specified in serviceCidr.
        :paramtype dns_service_ip: str
        :keyword docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It
         must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        :paramtype docker_bridge_cidr: str
        :keyword outbound_type: The outbound (egress) routing method. Known values are: "loadBalancer"
         and "userDefinedRouting".
        :paramtype outbound_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OutboundType
        :keyword load_balancer_sku: The load balancer sku for the managed cluster. Known values are:
         "standard" and "basic".
        :paramtype load_balancer_sku: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.LoadBalancerSku
        :keyword load_balancer_profile: Profile of the cluster load balancer.
        :paramtype load_balancer_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterLoadBalancerProfile
        """
        super().__init__(**kwargs)
        self.network_plugin = network_plugin
        self.network_policy = network_policy
        self.network_mode = network_mode
        self.pod_cidr = pod_cidr
        self.service_cidr = service_cidr
        self.dns_service_ip = dns_service_ip
        self.docker_bridge_cidr = docker_bridge_cidr
        self.outbound_type = outbound_type
        self.load_balancer_sku = load_balancer_sku
        self.load_balancer_profile = load_balancer_profile


class ContainerServiceSshConfiguration(_serialization.Model):
    """SSH configuration for Linux-based VMs running on Azure.

    All required parameters must be populated in order to send to server.

    :ivar public_keys: The list of SSH public keys used to authenticate with Linux-based VMs. Only
     expect one key specified. Required.
    :vartype public_keys:
     list[~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceSshPublicKey]
    """

    _validation = {
        "public_keys": {"required": True},
    }

    _attribute_map = {
        "public_keys": {"key": "publicKeys", "type": "[ContainerServiceSshPublicKey]"},
    }

    def __init__(self, *, public_keys: List["_models.ContainerServiceSshPublicKey"], **kwargs: Any) -> None:
        """
        :keyword public_keys: The list of SSH public keys used to authenticate with Linux-based VMs.
         Only expect one key specified. Required.
        :paramtype public_keys:
         list[~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceSshPublicKey]
        """
        super().__init__(**kwargs)
        self.public_keys = public_keys


class ContainerServiceSshPublicKey(_serialization.Model):
    """Contains information about SSH certificate public key data.

    All required parameters must be populated in order to send to server.

    :ivar key_data: Certificate public key used to authenticate with VMs through SSH. The
     certificate must be in PEM format with or without headers. Required.
    :vartype key_data: str
    """

    _validation = {
        "key_data": {"required": True},
    }

    _attribute_map = {
        "key_data": {"key": "keyData", "type": "str"},
    }

    def __init__(self, *, key_data: str, **kwargs: Any) -> None:
        """
        :keyword key_data: Certificate public key used to authenticate with VMs through SSH. The
         certificate must be in PEM format with or without headers. Required.
        :paramtype key_data: str
        """
        super().__init__(**kwargs)
        self.key_data = key_data


class ContainerServiceVMDiagnostics(_serialization.Model):
    """Profile for diagnostics on the container service VMs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Whether the VM diagnostic agent is provisioned on the VM. Required.
    :vartype enabled: bool
    :ivar storage_uri: The URI of the storage account where diagnostics are stored.
    :vartype storage_uri: str
    """

    _validation = {
        "enabled": {"required": True},
        "storage_uri": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "storage_uri": {"key": "storageUri", "type": "str"},
    }

    def __init__(self, *, enabled: bool, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether the VM diagnostic agent is provisioned on the VM. Required.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.storage_uri = None


class CredentialResult(_serialization.Model):
    """The credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the credential.
    :vartype name: str
    :ivar value: Base64-encoded Kubernetes configuration file.
    :vartype value: bytes
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "bytearray"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class CredentialResults(_serialization.Model):
    """The list of credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kubeconfigs: Base64-encoded Kubernetes configuration file.
    :vartype kubeconfigs: list[~azure.mgmt.containerservice.v2020_12_01.models.CredentialResult]
    """

    _validation = {
        "kubeconfigs": {"readonly": True},
    }

    _attribute_map = {
        "kubeconfigs": {"key": "kubeconfigs", "type": "[CredentialResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kubeconfigs = None


class KubeletConfig(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Kubelet configurations of agent nodes.

    :ivar cpu_manager_policy: CPU Manager policy to use.
    :vartype cpu_manager_policy: str
    :ivar cpu_cfs_quota: Enable CPU CFS quota enforcement for containers that specify CPU limits.
    :vartype cpu_cfs_quota: bool
    :ivar cpu_cfs_quota_period: Sets CPU CFS quota period value.
    :vartype cpu_cfs_quota_period: str
    :ivar image_gc_high_threshold: The percent of disk usage after which image garbage collection
     is always run.
    :vartype image_gc_high_threshold: int
    :ivar image_gc_low_threshold: The percent of disk usage before which image garbage collection
     is never run.
    :vartype image_gc_low_threshold: int
    :ivar topology_manager_policy: Topology Manager policy to use.
    :vartype topology_manager_policy: str
    :ivar allowed_unsafe_sysctls: Allowlist of unsafe sysctls or unsafe sysctl patterns (ending in
     ``*``\ ).
    :vartype allowed_unsafe_sysctls: list[str]
    :ivar fail_swap_on: If set to true it will make the Kubelet fail to start if swap is enabled on
     the node.
    :vartype fail_swap_on: bool
    :ivar container_log_max_size_mb: The maximum size (e.g. 10Mi) of container log file before it
     is rotated.
    :vartype container_log_max_size_mb: int
    :ivar container_log_max_files: The maximum number of container log files that can be present
     for a container. The number must be ≥ 2.
    :vartype container_log_max_files: int
    :ivar pod_max_pids: The maximum number of processes per pod.
    :vartype pod_max_pids: int
    """

    _validation = {
        "container_log_max_files": {"minimum": 2},
    }

    _attribute_map = {
        "cpu_manager_policy": {"key": "cpuManagerPolicy", "type": "str"},
        "cpu_cfs_quota": {"key": "cpuCfsQuota", "type": "bool"},
        "cpu_cfs_quota_period": {"key": "cpuCfsQuotaPeriod", "type": "str"},
        "image_gc_high_threshold": {"key": "imageGcHighThreshold", "type": "int"},
        "image_gc_low_threshold": {"key": "imageGcLowThreshold", "type": "int"},
        "topology_manager_policy": {"key": "topologyManagerPolicy", "type": "str"},
        "allowed_unsafe_sysctls": {"key": "allowedUnsafeSysctls", "type": "[str]"},
        "fail_swap_on": {"key": "failSwapOn", "type": "bool"},
        "container_log_max_size_mb": {"key": "containerLogMaxSizeMB", "type": "int"},
        "container_log_max_files": {"key": "containerLogMaxFiles", "type": "int"},
        "pod_max_pids": {"key": "podMaxPids", "type": "int"},
    }

    def __init__(
        self,
        *,
        cpu_manager_policy: Optional[str] = None,
        cpu_cfs_quota: Optional[bool] = None,
        cpu_cfs_quota_period: Optional[str] = None,
        image_gc_high_threshold: Optional[int] = None,
        image_gc_low_threshold: Optional[int] = None,
        topology_manager_policy: Optional[str] = None,
        allowed_unsafe_sysctls: Optional[List[str]] = None,
        fail_swap_on: Optional[bool] = None,
        container_log_max_size_mb: Optional[int] = None,
        container_log_max_files: Optional[int] = None,
        pod_max_pids: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cpu_manager_policy: CPU Manager policy to use.
        :paramtype cpu_manager_policy: str
        :keyword cpu_cfs_quota: Enable CPU CFS quota enforcement for containers that specify CPU
         limits.
        :paramtype cpu_cfs_quota: bool
        :keyword cpu_cfs_quota_period: Sets CPU CFS quota period value.
        :paramtype cpu_cfs_quota_period: str
        :keyword image_gc_high_threshold: The percent of disk usage after which image garbage
         collection is always run.
        :paramtype image_gc_high_threshold: int
        :keyword image_gc_low_threshold: The percent of disk usage before which image garbage
         collection is never run.
        :paramtype image_gc_low_threshold: int
        :keyword topology_manager_policy: Topology Manager policy to use.
        :paramtype topology_manager_policy: str
        :keyword allowed_unsafe_sysctls: Allowlist of unsafe sysctls or unsafe sysctl patterns (ending
         in ``*``\ ).
        :paramtype allowed_unsafe_sysctls: list[str]
        :keyword fail_swap_on: If set to true it will make the Kubelet fail to start if swap is enabled
         on the node.
        :paramtype fail_swap_on: bool
        :keyword container_log_max_size_mb: The maximum size (e.g. 10Mi) of container log file before
         it is rotated.
        :paramtype container_log_max_size_mb: int
        :keyword container_log_max_files: The maximum number of container log files that can be present
         for a container. The number must be ≥ 2.
        :paramtype container_log_max_files: int
        :keyword pod_max_pids: The maximum number of processes per pod.
        :paramtype pod_max_pids: int
        """
        super().__init__(**kwargs)
        self.cpu_manager_policy = cpu_manager_policy
        self.cpu_cfs_quota = cpu_cfs_quota
        self.cpu_cfs_quota_period = cpu_cfs_quota_period
        self.image_gc_high_threshold = image_gc_high_threshold
        self.image_gc_low_threshold = image_gc_low_threshold
        self.topology_manager_policy = topology_manager_policy
        self.allowed_unsafe_sysctls = allowed_unsafe_sysctls
        self.fail_swap_on = fail_swap_on
        self.container_log_max_size_mb = container_log_max_size_mb
        self.container_log_max_files = container_log_max_files
        self.pod_max_pids = pod_max_pids


class LinuxOSConfig(_serialization.Model):
    """OS configurations of Linux agent nodes.

    :ivar sysctls: Sysctl settings for Linux agent nodes.
    :vartype sysctls: ~azure.mgmt.containerservice.v2020_12_01.models.SysctlConfig
    :ivar transparent_huge_page_enabled: Transparent Huge Page enabled configuration.
    :vartype transparent_huge_page_enabled: str
    :ivar transparent_huge_page_defrag: Transparent Huge Page defrag configuration.
    :vartype transparent_huge_page_defrag: str
    :ivar swap_file_size_mb: SwapFileSizeMB specifies size in MB of a swap file will be created on
     each node.
    :vartype swap_file_size_mb: int
    """

    _attribute_map = {
        "sysctls": {"key": "sysctls", "type": "SysctlConfig"},
        "transparent_huge_page_enabled": {"key": "transparentHugePageEnabled", "type": "str"},
        "transparent_huge_page_defrag": {"key": "transparentHugePageDefrag", "type": "str"},
        "swap_file_size_mb": {"key": "swapFileSizeMB", "type": "int"},
    }

    def __init__(
        self,
        *,
        sysctls: Optional["_models.SysctlConfig"] = None,
        transparent_huge_page_enabled: Optional[str] = None,
        transparent_huge_page_defrag: Optional[str] = None,
        swap_file_size_mb: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sysctls: Sysctl settings for Linux agent nodes.
        :paramtype sysctls: ~azure.mgmt.containerservice.v2020_12_01.models.SysctlConfig
        :keyword transparent_huge_page_enabled: Transparent Huge Page enabled configuration.
        :paramtype transparent_huge_page_enabled: str
        :keyword transparent_huge_page_defrag: Transparent Huge Page defrag configuration.
        :paramtype transparent_huge_page_defrag: str
        :keyword swap_file_size_mb: SwapFileSizeMB specifies size in MB of a swap file will be created
         on each node.
        :paramtype swap_file_size_mb: int
        """
        super().__init__(**kwargs)
        self.sysctls = sysctls
        self.transparent_huge_page_enabled = transparent_huge_page_enabled
        self.transparent_huge_page_defrag = transparent_huge_page_defrag
        self.swap_file_size_mb = swap_file_size_mb


class MaintenanceConfiguration(SubResource):
    """maintenance configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.containerservice.v2020_12_01.models.SystemData
    :ivar time_in_week: Weekday time slots allowed to upgrade.
    :vartype time_in_week: list[~azure.mgmt.containerservice.v2020_12_01.models.TimeInWeek]
    :ivar not_allowed_time: Time slots on which upgrade is not allowed.
    :vartype not_allowed_time: list[~azure.mgmt.containerservice.v2020_12_01.models.TimeSpan]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "time_in_week": {"key": "properties.timeInWeek", "type": "[TimeInWeek]"},
        "not_allowed_time": {"key": "properties.notAllowedTime", "type": "[TimeSpan]"},
    }

    def __init__(
        self,
        *,
        time_in_week: Optional[List["_models.TimeInWeek"]] = None,
        not_allowed_time: Optional[List["_models.TimeSpan"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_in_week: Weekday time slots allowed to upgrade.
        :paramtype time_in_week: list[~azure.mgmt.containerservice.v2020_12_01.models.TimeInWeek]
        :keyword not_allowed_time: Time slots on which upgrade is not allowed.
        :paramtype not_allowed_time: list[~azure.mgmt.containerservice.v2020_12_01.models.TimeSpan]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.time_in_week = time_in_week
        self.not_allowed_time = not_allowed_time


class MaintenanceConfigurationListResult(_serialization.Model):
    """The response from the List maintenance configurations operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of maintenance configurations.
    :vartype value: list[~azure.mgmt.containerservice.v2020_12_01.models.MaintenanceConfiguration]
    :ivar next_link: The URL to get the next set of maintenance configuration results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MaintenanceConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.MaintenanceConfiguration"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of maintenance configurations.
        :paramtype value:
         list[~azure.mgmt.containerservice.v2020_12_01.models.MaintenanceConfiguration]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class Resource(_serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ManagedCluster(
    Resource, Components1Q1Og48SchemasManagedclusterAllof1
):  # pylint: disable=too-many-instance-attributes
    """Managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar identity: The identity of the managed cluster, if configured.
    :vartype identity: ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterIdentity
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar power_state: Represents the Power State of the cluster.
    :vartype power_state: ~azure.mgmt.containerservice.v2020_12_01.models.PowerState
    :ivar max_agent_pools: The max number of agent pools for the managed cluster.
    :vartype max_agent_pools: int
    :ivar kubernetes_version: Version of Kubernetes specified when creating the managed cluster.
    :vartype kubernetes_version: str
    :ivar dns_prefix: DNS prefix specified when creating the managed cluster.
    :vartype dns_prefix: str
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    :ivar private_fqdn: FQDN of private cluster.
    :vartype private_fqdn: str
    :ivar agent_pool_profiles: Properties of the agent pool.
    :vartype agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAgentPoolProfile]
    :ivar linux_profile: Profile for Linux VMs in the container service cluster.
    :vartype linux_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceLinuxProfile
    :ivar windows_profile: Profile for Windows VMs in the container service cluster.
    :vartype windows_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterWindowsProfile
    :ivar service_principal_profile: Information about a service principal identity for the cluster
     to use for manipulating Azure APIs.
    :vartype service_principal_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterServicePrincipalProfile
    :ivar addon_profiles: Profile of managed cluster add-on.
    :vartype addon_profiles: dict[str,
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAddonProfile]
    :ivar pod_identity_profile: Profile of managed cluster pod identity.
    :vartype pod_identity_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPodIdentityProfile
    :ivar node_resource_group: Name of the resource group containing agent pool nodes.
    :vartype node_resource_group: str
    :ivar enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
    :vartype enable_rbac: bool
    :ivar enable_pod_security_policy: (DEPRECATING) Whether to enable Kubernetes pod security
     policy (preview). This feature is set for removal on October 15th, 2020. Learn more at
     aka.ms/aks/azpodpolicy.
    :vartype enable_pod_security_policy: bool
    :ivar network_profile: Profile of network configuration.
    :vartype network_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceNetworkProfile
    :ivar aad_profile: Profile of Azure Active Directory configuration.
    :vartype aad_profile: ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAADProfile
    :ivar auto_upgrade_profile: Profile of auto upgrade configuration.
    :vartype auto_upgrade_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAutoUpgradeProfile
    :ivar auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled.
    :vartype auto_scaler_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPropertiesAutoScalerProfile
    :ivar api_server_access_profile: Access profile for managed cluster API server.
    :vartype api_server_access_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAPIServerAccessProfile
    :ivar disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
     encryption at rest.
    :vartype disk_encryption_set_id: str
    :ivar identity_profile: Identities associated with the cluster.
    :vartype identity_profile: dict[str,
     ~azure.mgmt.containerservice.v2020_12_01.models.ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties]  # pylint: disable=line-too-long
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The managed cluster SKU.
    :vartype sku: ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterSKU
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "power_state": {"readonly": True},
        "max_agent_pools": {"readonly": True},
        "fqdn": {"readonly": True},
        "private_fqdn": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "identity": {"key": "identity", "type": "ManagedClusterIdentity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "power_state": {"key": "properties.powerState", "type": "PowerState"},
        "max_agent_pools": {"key": "properties.maxAgentPools", "type": "int"},
        "kubernetes_version": {"key": "properties.kubernetesVersion", "type": "str"},
        "dns_prefix": {"key": "properties.dnsPrefix", "type": "str"},
        "fqdn": {"key": "properties.fqdn", "type": "str"},
        "private_fqdn": {"key": "properties.privateFQDN", "type": "str"},
        "agent_pool_profiles": {"key": "properties.agentPoolProfiles", "type": "[ManagedClusterAgentPoolProfile]"},
        "linux_profile": {"key": "properties.linuxProfile", "type": "ContainerServiceLinuxProfile"},
        "windows_profile": {"key": "properties.windowsProfile", "type": "ManagedClusterWindowsProfile"},
        "service_principal_profile": {
            "key": "properties.servicePrincipalProfile",
            "type": "ManagedClusterServicePrincipalProfile",
        },
        "addon_profiles": {"key": "properties.addonProfiles", "type": "{ManagedClusterAddonProfile}"},
        "pod_identity_profile": {"key": "properties.podIdentityProfile", "type": "ManagedClusterPodIdentityProfile"},
        "node_resource_group": {"key": "properties.nodeResourceGroup", "type": "str"},
        "enable_rbac": {"key": "properties.enableRBAC", "type": "bool"},
        "enable_pod_security_policy": {"key": "properties.enablePodSecurityPolicy", "type": "bool"},
        "network_profile": {"key": "properties.networkProfile", "type": "ContainerServiceNetworkProfile"},
        "aad_profile": {"key": "properties.aadProfile", "type": "ManagedClusterAADProfile"},
        "auto_upgrade_profile": {"key": "properties.autoUpgradeProfile", "type": "ManagedClusterAutoUpgradeProfile"},
        "auto_scaler_profile": {
            "key": "properties.autoScalerProfile",
            "type": "ManagedClusterPropertiesAutoScalerProfile",
        },
        "api_server_access_profile": {
            "key": "properties.apiServerAccessProfile",
            "type": "ManagedClusterAPIServerAccessProfile",
        },
        "disk_encryption_set_id": {"key": "properties.diskEncryptionSetID", "type": "str"},
        "identity_profile": {
            "key": "properties.identityProfile",
            "type": "{ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties}",
        },
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "ManagedClusterSKU"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        identity: Optional["_models.ManagedClusterIdentity"] = None,
        kubernetes_version: Optional[str] = None,
        dns_prefix: Optional[str] = None,
        agent_pool_profiles: Optional[List["_models.ManagedClusterAgentPoolProfile"]] = None,
        linux_profile: Optional["_models.ContainerServiceLinuxProfile"] = None,
        windows_profile: Optional["_models.ManagedClusterWindowsProfile"] = None,
        service_principal_profile: Optional["_models.ManagedClusterServicePrincipalProfile"] = None,
        addon_profiles: Optional[Dict[str, "_models.ManagedClusterAddonProfile"]] = None,
        pod_identity_profile: Optional["_models.ManagedClusterPodIdentityProfile"] = None,
        node_resource_group: Optional[str] = None,
        enable_rbac: Optional[bool] = None,
        enable_pod_security_policy: Optional[bool] = None,
        network_profile: Optional["_models.ContainerServiceNetworkProfile"] = None,
        aad_profile: Optional["_models.ManagedClusterAADProfile"] = None,
        auto_upgrade_profile: Optional["_models.ManagedClusterAutoUpgradeProfile"] = None,
        auto_scaler_profile: Optional["_models.ManagedClusterPropertiesAutoScalerProfile"] = None,
        api_server_access_profile: Optional["_models.ManagedClusterAPIServerAccessProfile"] = None,
        disk_encryption_set_id: Optional[str] = None,
        identity_profile: Optional[
            Dict[
                str,
                "_models.ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties",
            ]
        ] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.ManagedClusterSKU"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity of the managed cluster, if configured.
        :paramtype identity: ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterIdentity
        :keyword kubernetes_version: Version of Kubernetes specified when creating the managed cluster.
        :paramtype kubernetes_version: str
        :keyword dns_prefix: DNS prefix specified when creating the managed cluster.
        :paramtype dns_prefix: str
        :keyword agent_pool_profiles: Properties of the agent pool.
        :paramtype agent_pool_profiles:
         list[~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAgentPoolProfile]
        :keyword linux_profile: Profile for Linux VMs in the container service cluster.
        :paramtype linux_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceLinuxProfile
        :keyword windows_profile: Profile for Windows VMs in the container service cluster.
        :paramtype windows_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterWindowsProfile
        :keyword service_principal_profile: Information about a service principal identity for the
         cluster to use for manipulating Azure APIs.
        :paramtype service_principal_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterServicePrincipalProfile
        :keyword addon_profiles: Profile of managed cluster add-on.
        :paramtype addon_profiles: dict[str,
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAddonProfile]
        :keyword pod_identity_profile: Profile of managed cluster pod identity.
        :paramtype pod_identity_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPodIdentityProfile
        :keyword node_resource_group: Name of the resource group containing agent pool nodes.
        :paramtype node_resource_group: str
        :keyword enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
        :paramtype enable_rbac: bool
        :keyword enable_pod_security_policy: (DEPRECATING) Whether to enable Kubernetes pod security
         policy (preview). This feature is set for removal on October 15th, 2020. Learn more at
         aka.ms/aks/azpodpolicy.
        :paramtype enable_pod_security_policy: bool
        :keyword network_profile: Profile of network configuration.
        :paramtype network_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceNetworkProfile
        :keyword aad_profile: Profile of Azure Active Directory configuration.
        :paramtype aad_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAADProfile
        :keyword auto_upgrade_profile: Profile of auto upgrade configuration.
        :paramtype auto_upgrade_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAutoUpgradeProfile
        :keyword auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled.
        :paramtype auto_scaler_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPropertiesAutoScalerProfile
        :keyword api_server_access_profile: Access profile for managed cluster API server.
        :paramtype api_server_access_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAPIServerAccessProfile
        :keyword disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
         encryption at rest.
        :paramtype disk_encryption_set_id: str
        :keyword identity_profile: Identities associated with the cluster.
        :paramtype identity_profile: dict[str,
         ~azure.mgmt.containerservice.v2020_12_01.models.ComponentsQit0EtSchemasManagedclusterpropertiesPropertiesIdentityprofileAdditionalproperties]  # pylint: disable=line-too-long
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The managed cluster SKU.
        :paramtype sku: ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterSKU
        """
        super().__init__(
            location=location,
            tags=tags,
            identity=identity,
            kubernetes_version=kubernetes_version,
            dns_prefix=dns_prefix,
            agent_pool_profiles=agent_pool_profiles,
            linux_profile=linux_profile,
            windows_profile=windows_profile,
            service_principal_profile=service_principal_profile,
            addon_profiles=addon_profiles,
            pod_identity_profile=pod_identity_profile,
            node_resource_group=node_resource_group,
            enable_rbac=enable_rbac,
            enable_pod_security_policy=enable_pod_security_policy,
            network_profile=network_profile,
            aad_profile=aad_profile,
            auto_upgrade_profile=auto_upgrade_profile,
            auto_scaler_profile=auto_scaler_profile,
            api_server_access_profile=api_server_access_profile,
            disk_encryption_set_id=disk_encryption_set_id,
            identity_profile=identity_profile,
            **kwargs
        )
        self.identity = identity
        self.provisioning_state = None
        self.power_state = None
        self.max_agent_pools = None
        self.kubernetes_version = kubernetes_version
        self.dns_prefix = dns_prefix
        self.fqdn = None
        self.private_fqdn = None
        self.agent_pool_profiles = agent_pool_profiles
        self.linux_profile = linux_profile
        self.windows_profile = windows_profile
        self.service_principal_profile = service_principal_profile
        self.addon_profiles = addon_profiles
        self.pod_identity_profile = pod_identity_profile
        self.node_resource_group = node_resource_group
        self.enable_rbac = enable_rbac
        self.enable_pod_security_policy = enable_pod_security_policy
        self.network_profile = network_profile
        self.aad_profile = aad_profile
        self.auto_upgrade_profile = auto_upgrade_profile
        self.auto_scaler_profile = auto_scaler_profile
        self.api_server_access_profile = api_server_access_profile
        self.disk_encryption_set_id = disk_encryption_set_id
        self.identity_profile = identity_profile
        self.sku = sku
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ManagedClusterAADProfile(_serialization.Model):
    """AADProfile specifies attributes for Azure Active Directory integration.

    :ivar managed: Whether to enable managed AAD.
    :vartype managed: bool
    :ivar enable_azure_rbac: Whether to enable Azure RBAC for Kubernetes authorization.
    :vartype enable_azure_rbac: bool
    :ivar admin_group_object_i_ds: AAD group object IDs that will have admin role of the cluster.
    :vartype admin_group_object_i_ds: list[str]
    :ivar client_app_id: The client AAD application ID.
    :vartype client_app_id: str
    :ivar server_app_id: The server AAD application ID.
    :vartype server_app_id: str
    :ivar server_app_secret: The server AAD application secret.
    :vartype server_app_secret: str
    :ivar tenant_id: The AAD tenant ID to use for authentication. If not specified, will use the
     tenant of the deployment subscription.
    :vartype tenant_id: str
    """

    _attribute_map = {
        "managed": {"key": "managed", "type": "bool"},
        "enable_azure_rbac": {"key": "enableAzureRBAC", "type": "bool"},
        "admin_group_object_i_ds": {"key": "adminGroupObjectIDs", "type": "[str]"},
        "client_app_id": {"key": "clientAppID", "type": "str"},
        "server_app_id": {"key": "serverAppID", "type": "str"},
        "server_app_secret": {"key": "serverAppSecret", "type": "str"},
        "tenant_id": {"key": "tenantID", "type": "str"},
    }

    def __init__(
        self,
        *,
        managed: Optional[bool] = None,
        enable_azure_rbac: Optional[bool] = None,
        admin_group_object_i_ds: Optional[List[str]] = None,
        client_app_id: Optional[str] = None,
        server_app_id: Optional[str] = None,
        server_app_secret: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed: Whether to enable managed AAD.
        :paramtype managed: bool
        :keyword enable_azure_rbac: Whether to enable Azure RBAC for Kubernetes authorization.
        :paramtype enable_azure_rbac: bool
        :keyword admin_group_object_i_ds: AAD group object IDs that will have admin role of the
         cluster.
        :paramtype admin_group_object_i_ds: list[str]
        :keyword client_app_id: The client AAD application ID.
        :paramtype client_app_id: str
        :keyword server_app_id: The server AAD application ID.
        :paramtype server_app_id: str
        :keyword server_app_secret: The server AAD application secret.
        :paramtype server_app_secret: str
        :keyword tenant_id: The AAD tenant ID to use for authentication. If not specified, will use the
         tenant of the deployment subscription.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.managed = managed
        self.enable_azure_rbac = enable_azure_rbac
        self.admin_group_object_i_ds = admin_group_object_i_ds
        self.client_app_id = client_app_id
        self.server_app_id = server_app_id
        self.server_app_secret = server_app_secret
        self.tenant_id = tenant_id


class ManagedClusterAccessProfile(Resource):
    """Managed cluster Access Profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar kube_config: Base64-encoded Kubernetes configuration file.
    :vartype kube_config: bytes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "kube_config": {"key": "properties.kubeConfig", "type": "bytearray"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        kube_config: Optional[bytes] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kube_config: Base64-encoded Kubernetes configuration file.
        :paramtype kube_config: bytes
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.kube_config = kube_config


class ManagedClusterAddonProfile(_serialization.Model):
    """A Kubernetes add-on profile for a managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Whether the add-on is enabled or not. Required.
    :vartype enabled: bool
    :ivar config: Key-value pairs for configuring an add-on.
    :vartype config: dict[str, str]
    :ivar identity: Information of user assigned identity used by this add-on.
    :vartype identity:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterAddonProfileIdentity
    """

    _validation = {
        "enabled": {"required": True},
        "identity": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "config": {"key": "config", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedClusterAddonProfileIdentity"},
    }

    def __init__(self, *, enabled: bool, config: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether the add-on is enabled or not. Required.
        :paramtype enabled: bool
        :keyword config: Key-value pairs for configuring an add-on.
        :paramtype config: dict[str, str]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.config = config
        self.identity = None


class ManagedClusterAddonProfileIdentity(UserAssignedIdentity):
    """Information of user assigned identity used by this add-on.

    :ivar resource_id: The resource id of the user assigned identity.
    :vartype resource_id: str
    :ivar client_id: The client id of the user assigned identity.
    :vartype client_id: str
    :ivar object_id: The object id of the user assigned identity.
    :vartype object_id: str
    """


class ManagedClusterAgentPoolProfileProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties for the container service agent pool profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for
     system pools. The default value is 1.
    :vartype count: int
    :ivar vm_size: Size of agent VMs. Known values are: "Standard_A1", "Standard_A10",
     "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
     "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
     "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
     "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
     "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
     "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
     "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
     "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
     "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
     "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
     "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
     "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
     "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
     "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
     "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
     "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
     "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
     "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
     "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
     "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
     "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
     "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
     "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
     "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
     "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
     "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
     "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
     "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
     "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
     "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
     "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
     "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
     "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
     "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", and "Standard_NV6".
    :vartype vm_size: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceVMSizeTypes
    :ivar os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every machine
     in this master/agent pool. If you specify 0, it will apply the default osDisk size according to
     the vmSize specified.
    :vartype os_disk_size_gb: int
    :ivar os_disk_type: OS disk type to be used for machines in a given agent pool. Allowed values
     are 'Ephemeral' and 'Managed'. If unspecified, defaults to 'Ephemeral' when the VM supports
     ephemeral OS and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults
     to 'Managed'. May not be changed after creation. Known values are: "Managed" and "Ephemeral".
    :vartype os_disk_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OSDiskType
    :ivar kubelet_disk_type: KubeletDiskType determines the placement of emptyDir volumes,
     container runtime data root, and Kubelet ephemeral storage. Currently allows one value, OS,
     resulting in Kubelet using the OS disk for data. "OS"
    :vartype kubelet_disk_type: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.KubeletDiskType
    :ivar vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier for nodes and maybe
     pods.
    :vartype vnet_subnet_id: str
    :ivar pod_subnet_id: Pod SubnetID specifies the VNet's subnet identifier for pods.
    :vartype pod_subnet_id: str
    :ivar max_pods: Maximum number of pods that can run on a node.
    :vartype max_pods: int
    :ivar os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Known values are: "Linux" and "Windows".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OSType
    :ivar max_count: Maximum number of nodes for auto-scaling.
    :vartype max_count: int
    :ivar min_count: Minimum number of nodes for auto-scaling.
    :vartype min_count: int
    :ivar enable_auto_scaling: Whether to enable auto-scaler.
    :vartype enable_auto_scaling: bool
    :ivar type: AgentPoolType represents types of an agent pool. Known values are:
     "VirtualMachineScaleSets" and "AvailabilitySet".
    :vartype type: str or ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolType
    :ivar mode: AgentPoolMode represents mode of an agent pool. Known values are: "System" and
     "User".
    :vartype mode: str or ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolMode
    :ivar orchestrator_version: Version of orchestrator specified when creating the managed
     cluster.
    :vartype orchestrator_version: str
    :ivar node_image_version: Version of node image.
    :vartype node_image_version: str
    :ivar upgrade_settings: Settings for upgrading the agentpool.
    :vartype upgrade_settings:
     ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar power_state: Describes whether the Agent Pool is Running or Stopped.
    :vartype power_state: ~azure.mgmt.containerservice.v2020_12_01.models.PowerState
    :ivar availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
     AgentPoolType.
    :vartype availability_zones: list[str]
    :ivar enable_node_public_ip: Enable public IP for nodes.
    :vartype enable_node_public_ip: bool
    :ivar scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
     priority. Default to regular. Known values are: "Spot" and "Regular".
    :vartype scale_set_priority: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.ScaleSetPriority
    :ivar scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction policy
     for Spot virtual machine scale set. Default to Delete. Known values are: "Delete" and
     "Deallocate".
    :vartype scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.ScaleSetEvictionPolicy
    :ivar spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing to
     pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
     indicates default price to be up-to on-demand.
    :vartype spot_max_price: float
    :ivar tags: Agent pool tags to be persisted on the agent pool virtual machine scale set.
    :vartype tags: dict[str, str]
    :ivar node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
    :vartype node_labels: dict[str, str]
    :ivar node_taints: Taints added to new nodes during node pool create and scale. For example,
     key=value:NoSchedule.
    :vartype node_taints: list[str]
    :ivar proximity_placement_group_id: The ID for Proximity Placement Group.
    :vartype proximity_placement_group_id: str
    :ivar kubelet_config: KubeletConfig specifies the configuration of kubelet on agent nodes.
    :vartype kubelet_config: ~azure.mgmt.containerservice.v2020_12_01.models.KubeletConfig
    :ivar linux_os_config: LinuxOSConfig specifies the OS configuration of linux agent nodes.
    :vartype linux_os_config: ~azure.mgmt.containerservice.v2020_12_01.models.LinuxOSConfig
    :ivar enable_encryption_at_host: Whether to enable EncryptionAtHost.
    :vartype enable_encryption_at_host: bool
    """

    _validation = {
        "os_disk_size_gb": {"maximum": 1023, "minimum": 0},
        "node_image_version": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "power_state": {"readonly": True},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "os_disk_size_gb": {"key": "osDiskSizeGB", "type": "int"},
        "os_disk_type": {"key": "osDiskType", "type": "str"},
        "kubelet_disk_type": {"key": "kubeletDiskType", "type": "str"},
        "vnet_subnet_id": {"key": "vnetSubnetID", "type": "str"},
        "pod_subnet_id": {"key": "podSubnetID", "type": "str"},
        "max_pods": {"key": "maxPods", "type": "int"},
        "os_type": {"key": "osType", "type": "str"},
        "max_count": {"key": "maxCount", "type": "int"},
        "min_count": {"key": "minCount", "type": "int"},
        "enable_auto_scaling": {"key": "enableAutoScaling", "type": "bool"},
        "type": {"key": "type", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "orchestrator_version": {"key": "orchestratorVersion", "type": "str"},
        "node_image_version": {"key": "nodeImageVersion", "type": "str"},
        "upgrade_settings": {"key": "upgradeSettings", "type": "AgentPoolUpgradeSettings"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "power_state": {"key": "powerState", "type": "PowerState"},
        "availability_zones": {"key": "availabilityZones", "type": "[str]"},
        "enable_node_public_ip": {"key": "enableNodePublicIP", "type": "bool"},
        "scale_set_priority": {"key": "scaleSetPriority", "type": "str"},
        "scale_set_eviction_policy": {"key": "scaleSetEvictionPolicy", "type": "str"},
        "spot_max_price": {"key": "spotMaxPrice", "type": "float"},
        "tags": {"key": "tags", "type": "{str}"},
        "node_labels": {"key": "nodeLabels", "type": "{str}"},
        "node_taints": {"key": "nodeTaints", "type": "[str]"},
        "proximity_placement_group_id": {"key": "proximityPlacementGroupID", "type": "str"},
        "kubelet_config": {"key": "kubeletConfig", "type": "KubeletConfig"},
        "linux_os_config": {"key": "linuxOSConfig", "type": "LinuxOSConfig"},
        "enable_encryption_at_host": {"key": "enableEncryptionAtHost", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        count: Optional[int] = None,
        vm_size: Optional[Union[str, "_models.ContainerServiceVMSizeTypes"]] = None,
        os_disk_size_gb: Optional[int] = None,
        os_disk_type: Optional[Union[str, "_models.OSDiskType"]] = None,
        kubelet_disk_type: Optional[Union[str, "_models.KubeletDiskType"]] = None,
        vnet_subnet_id: Optional[str] = None,
        pod_subnet_id: Optional[str] = None,
        max_pods: Optional[int] = None,
        os_type: Union[str, "_models.OSType"] = "Linux",
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: Optional[bool] = None,
        type: Optional[Union[str, "_models.AgentPoolType"]] = None,
        mode: Optional[Union[str, "_models.AgentPoolMode"]] = None,
        orchestrator_version: Optional[str] = None,
        upgrade_settings: Optional["_models.AgentPoolUpgradeSettings"] = None,
        availability_zones: Optional[List[str]] = None,
        enable_node_public_ip: Optional[bool] = None,
        scale_set_priority: Union[str, "_models.ScaleSetPriority"] = "Regular",
        scale_set_eviction_policy: Union[str, "_models.ScaleSetEvictionPolicy"] = "Delete",
        spot_max_price: float = -1,
        tags: Optional[Dict[str, str]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        proximity_placement_group_id: Optional[str] = None,
        kubelet_config: Optional["_models.KubeletConfig"] = None,
        linux_os_config: Optional["_models.LinuxOSConfig"] = None,
        enable_encryption_at_host: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword count: Number of agents (VMs) to host docker containers. Allowed values must be in the
         range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for
         system pools. The default value is 1.
        :paramtype count: int
        :keyword vm_size: Size of agent VMs. Known values are: "Standard_A1", "Standard_A10",
         "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
         "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
         "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
         "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
         "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
         "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
         "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
         "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
         "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
         "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
         "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
         "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
         "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
         "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
         "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
         "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
         "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
         "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
         "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
         "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
         "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
         "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
         "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
         "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
         "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
         "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
         "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
         "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
         "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
         "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
         "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
         "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
         "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
         "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
         "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
         "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
         "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", and "Standard_NV6".
        :paramtype vm_size: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceVMSizeTypes
        :keyword os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
         machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
         according to the vmSize specified.
        :paramtype os_disk_size_gb: int
        :keyword os_disk_type: OS disk type to be used for machines in a given agent pool. Allowed
         values are 'Ephemeral' and 'Managed'. If unspecified, defaults to 'Ephemeral' when the VM
         supports ephemeral OS and has a cache disk larger than the requested OSDiskSizeGB. Otherwise,
         defaults to 'Managed'. May not be changed after creation. Known values are: "Managed" and
         "Ephemeral".
        :paramtype os_disk_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OSDiskType
        :keyword kubelet_disk_type: KubeletDiskType determines the placement of emptyDir volumes,
         container runtime data root, and Kubelet ephemeral storage. Currently allows one value, OS,
         resulting in Kubelet using the OS disk for data. "OS"
        :paramtype kubelet_disk_type: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.KubeletDiskType
        :keyword vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier for nodes and
         maybe pods.
        :paramtype vnet_subnet_id: str
        :keyword pod_subnet_id: Pod SubnetID specifies the VNet's subnet identifier for pods.
        :paramtype pod_subnet_id: str
        :keyword max_pods: Maximum number of pods that can run on a node.
        :paramtype max_pods: int
        :keyword os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default
         to Linux. Known values are: "Linux" and "Windows".
        :paramtype os_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OSType
        :keyword max_count: Maximum number of nodes for auto-scaling.
        :paramtype max_count: int
        :keyword min_count: Minimum number of nodes for auto-scaling.
        :paramtype min_count: int
        :keyword enable_auto_scaling: Whether to enable auto-scaler.
        :paramtype enable_auto_scaling: bool
        :keyword type: AgentPoolType represents types of an agent pool. Known values are:
         "VirtualMachineScaleSets" and "AvailabilitySet".
        :paramtype type: str or ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolType
        :keyword mode: AgentPoolMode represents mode of an agent pool. Known values are: "System" and
         "User".
        :paramtype mode: str or ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolMode
        :keyword orchestrator_version: Version of orchestrator specified when creating the managed
         cluster.
        :paramtype orchestrator_version: str
        :keyword upgrade_settings: Settings for upgrading the agentpool.
        :paramtype upgrade_settings:
         ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolUpgradeSettings
        :keyword availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
         AgentPoolType.
        :paramtype availability_zones: list[str]
        :keyword enable_node_public_ip: Enable public IP for nodes.
        :paramtype enable_node_public_ip: bool
        :keyword scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
         priority. Default to regular. Known values are: "Spot" and "Regular".
        :paramtype scale_set_priority: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.ScaleSetPriority
        :keyword scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction
         policy for Spot virtual machine scale set. Default to Delete. Known values are: "Delete" and
         "Deallocate".
        :paramtype scale_set_eviction_policy: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.ScaleSetEvictionPolicy
        :keyword spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing
         to pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
         indicates default price to be up-to on-demand.
        :paramtype spot_max_price: float
        :keyword tags: Agent pool tags to be persisted on the agent pool virtual machine scale set.
        :paramtype tags: dict[str, str]
        :keyword node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
        :paramtype node_labels: dict[str, str]
        :keyword node_taints: Taints added to new nodes during node pool create and scale. For example,
         key=value:NoSchedule.
        :paramtype node_taints: list[str]
        :keyword proximity_placement_group_id: The ID for Proximity Placement Group.
        :paramtype proximity_placement_group_id: str
        :keyword kubelet_config: KubeletConfig specifies the configuration of kubelet on agent nodes.
        :paramtype kubelet_config: ~azure.mgmt.containerservice.v2020_12_01.models.KubeletConfig
        :keyword linux_os_config: LinuxOSConfig specifies the OS configuration of linux agent nodes.
        :paramtype linux_os_config: ~azure.mgmt.containerservice.v2020_12_01.models.LinuxOSConfig
        :keyword enable_encryption_at_host: Whether to enable EncryptionAtHost.
        :paramtype enable_encryption_at_host: bool
        """
        super().__init__(**kwargs)
        self.count = count
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.os_disk_type = os_disk_type
        self.kubelet_disk_type = kubelet_disk_type
        self.vnet_subnet_id = vnet_subnet_id
        self.pod_subnet_id = pod_subnet_id
        self.max_pods = max_pods
        self.os_type = os_type
        self.max_count = max_count
        self.min_count = min_count
        self.enable_auto_scaling = enable_auto_scaling
        self.type = type
        self.mode = mode
        self.orchestrator_version = orchestrator_version
        self.node_image_version = None
        self.upgrade_settings = upgrade_settings
        self.provisioning_state = None
        self.power_state = None
        self.availability_zones = availability_zones
        self.enable_node_public_ip = enable_node_public_ip
        self.scale_set_priority = scale_set_priority
        self.scale_set_eviction_policy = scale_set_eviction_policy
        self.spot_max_price = spot_max_price
        self.tags = tags
        self.node_labels = node_labels
        self.node_taints = node_taints
        self.proximity_placement_group_id = proximity_placement_group_id
        self.kubelet_config = kubelet_config
        self.linux_os_config = linux_os_config
        self.enable_encryption_at_host = enable_encryption_at_host


class ManagedClusterAgentPoolProfile(
    ManagedClusterAgentPoolProfileProperties
):  # pylint: disable=too-many-instance-attributes
    """Profile for the container service agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for
     system pools. The default value is 1.
    :vartype count: int
    :ivar vm_size: Size of agent VMs. Known values are: "Standard_A1", "Standard_A10",
     "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
     "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
     "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
     "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
     "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
     "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
     "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
     "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
     "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
     "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
     "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
     "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
     "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
     "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
     "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
     "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
     "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
     "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
     "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
     "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
     "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
     "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
     "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
     "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
     "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
     "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
     "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
     "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
     "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
     "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
     "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
     "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
     "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
     "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", and "Standard_NV6".
    :vartype vm_size: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceVMSizeTypes
    :ivar os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every machine
     in this master/agent pool. If you specify 0, it will apply the default osDisk size according to
     the vmSize specified.
    :vartype os_disk_size_gb: int
    :ivar os_disk_type: OS disk type to be used for machines in a given agent pool. Allowed values
     are 'Ephemeral' and 'Managed'. If unspecified, defaults to 'Ephemeral' when the VM supports
     ephemeral OS and has a cache disk larger than the requested OSDiskSizeGB. Otherwise, defaults
     to 'Managed'. May not be changed after creation. Known values are: "Managed" and "Ephemeral".
    :vartype os_disk_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OSDiskType
    :ivar kubelet_disk_type: KubeletDiskType determines the placement of emptyDir volumes,
     container runtime data root, and Kubelet ephemeral storage. Currently allows one value, OS,
     resulting in Kubelet using the OS disk for data. "OS"
    :vartype kubelet_disk_type: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.KubeletDiskType
    :ivar vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier for nodes and maybe
     pods.
    :vartype vnet_subnet_id: str
    :ivar pod_subnet_id: Pod SubnetID specifies the VNet's subnet identifier for pods.
    :vartype pod_subnet_id: str
    :ivar max_pods: Maximum number of pods that can run on a node.
    :vartype max_pods: int
    :ivar os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Known values are: "Linux" and "Windows".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OSType
    :ivar max_count: Maximum number of nodes for auto-scaling.
    :vartype max_count: int
    :ivar min_count: Minimum number of nodes for auto-scaling.
    :vartype min_count: int
    :ivar enable_auto_scaling: Whether to enable auto-scaler.
    :vartype enable_auto_scaling: bool
    :ivar type: AgentPoolType represents types of an agent pool. Known values are:
     "VirtualMachineScaleSets" and "AvailabilitySet".
    :vartype type: str or ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolType
    :ivar mode: AgentPoolMode represents mode of an agent pool. Known values are: "System" and
     "User".
    :vartype mode: str or ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolMode
    :ivar orchestrator_version: Version of orchestrator specified when creating the managed
     cluster.
    :vartype orchestrator_version: str
    :ivar node_image_version: Version of node image.
    :vartype node_image_version: str
    :ivar upgrade_settings: Settings for upgrading the agentpool.
    :vartype upgrade_settings:
     ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar power_state: Describes whether the Agent Pool is Running or Stopped.
    :vartype power_state: ~azure.mgmt.containerservice.v2020_12_01.models.PowerState
    :ivar availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
     AgentPoolType.
    :vartype availability_zones: list[str]
    :ivar enable_node_public_ip: Enable public IP for nodes.
    :vartype enable_node_public_ip: bool
    :ivar scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
     priority. Default to regular. Known values are: "Spot" and "Regular".
    :vartype scale_set_priority: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.ScaleSetPriority
    :ivar scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction policy
     for Spot virtual machine scale set. Default to Delete. Known values are: "Delete" and
     "Deallocate".
    :vartype scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.ScaleSetEvictionPolicy
    :ivar spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing to
     pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
     indicates default price to be up-to on-demand.
    :vartype spot_max_price: float
    :ivar tags: Agent pool tags to be persisted on the agent pool virtual machine scale set.
    :vartype tags: dict[str, str]
    :ivar node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
    :vartype node_labels: dict[str, str]
    :ivar node_taints: Taints added to new nodes during node pool create and scale. For example,
     key=value:NoSchedule.
    :vartype node_taints: list[str]
    :ivar proximity_placement_group_id: The ID for Proximity Placement Group.
    :vartype proximity_placement_group_id: str
    :ivar kubelet_config: KubeletConfig specifies the configuration of kubelet on agent nodes.
    :vartype kubelet_config: ~azure.mgmt.containerservice.v2020_12_01.models.KubeletConfig
    :ivar linux_os_config: LinuxOSConfig specifies the OS configuration of linux agent nodes.
    :vartype linux_os_config: ~azure.mgmt.containerservice.v2020_12_01.models.LinuxOSConfig
    :ivar enable_encryption_at_host: Whether to enable EncryptionAtHost.
    :vartype enable_encryption_at_host: bool
    :ivar name: Unique name of the agent pool profile in the context of the subscription and
     resource group. Required.
    :vartype name: str
    """

    _validation = {
        "os_disk_size_gb": {"maximum": 1023, "minimum": 0},
        "node_image_version": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "power_state": {"readonly": True},
        "name": {"required": True, "pattern": r"^[a-z][a-z0-9]{0,11}$"},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "os_disk_size_gb": {"key": "osDiskSizeGB", "type": "int"},
        "os_disk_type": {"key": "osDiskType", "type": "str"},
        "kubelet_disk_type": {"key": "kubeletDiskType", "type": "str"},
        "vnet_subnet_id": {"key": "vnetSubnetID", "type": "str"},
        "pod_subnet_id": {"key": "podSubnetID", "type": "str"},
        "max_pods": {"key": "maxPods", "type": "int"},
        "os_type": {"key": "osType", "type": "str"},
        "max_count": {"key": "maxCount", "type": "int"},
        "min_count": {"key": "minCount", "type": "int"},
        "enable_auto_scaling": {"key": "enableAutoScaling", "type": "bool"},
        "type": {"key": "type", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "orchestrator_version": {"key": "orchestratorVersion", "type": "str"},
        "node_image_version": {"key": "nodeImageVersion", "type": "str"},
        "upgrade_settings": {"key": "upgradeSettings", "type": "AgentPoolUpgradeSettings"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "power_state": {"key": "powerState", "type": "PowerState"},
        "availability_zones": {"key": "availabilityZones", "type": "[str]"},
        "enable_node_public_ip": {"key": "enableNodePublicIP", "type": "bool"},
        "scale_set_priority": {"key": "scaleSetPriority", "type": "str"},
        "scale_set_eviction_policy": {"key": "scaleSetEvictionPolicy", "type": "str"},
        "spot_max_price": {"key": "spotMaxPrice", "type": "float"},
        "tags": {"key": "tags", "type": "{str}"},
        "node_labels": {"key": "nodeLabels", "type": "{str}"},
        "node_taints": {"key": "nodeTaints", "type": "[str]"},
        "proximity_placement_group_id": {"key": "proximityPlacementGroupID", "type": "str"},
        "kubelet_config": {"key": "kubeletConfig", "type": "KubeletConfig"},
        "linux_os_config": {"key": "linuxOSConfig", "type": "LinuxOSConfig"},
        "enable_encryption_at_host": {"key": "enableEncryptionAtHost", "type": "bool"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        name: str,
        count: Optional[int] = None,
        vm_size: Optional[Union[str, "_models.ContainerServiceVMSizeTypes"]] = None,
        os_disk_size_gb: Optional[int] = None,
        os_disk_type: Optional[Union[str, "_models.OSDiskType"]] = None,
        kubelet_disk_type: Optional[Union[str, "_models.KubeletDiskType"]] = None,
        vnet_subnet_id: Optional[str] = None,
        pod_subnet_id: Optional[str] = None,
        max_pods: Optional[int] = None,
        os_type: Union[str, "_models.OSType"] = "Linux",
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: Optional[bool] = None,
        type: Optional[Union[str, "_models.AgentPoolType"]] = None,
        mode: Optional[Union[str, "_models.AgentPoolMode"]] = None,
        orchestrator_version: Optional[str] = None,
        upgrade_settings: Optional["_models.AgentPoolUpgradeSettings"] = None,
        availability_zones: Optional[List[str]] = None,
        enable_node_public_ip: Optional[bool] = None,
        scale_set_priority: Union[str, "_models.ScaleSetPriority"] = "Regular",
        scale_set_eviction_policy: Union[str, "_models.ScaleSetEvictionPolicy"] = "Delete",
        spot_max_price: float = -1,
        tags: Optional[Dict[str, str]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        proximity_placement_group_id: Optional[str] = None,
        kubelet_config: Optional["_models.KubeletConfig"] = None,
        linux_os_config: Optional["_models.LinuxOSConfig"] = None,
        enable_encryption_at_host: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword count: Number of agents (VMs) to host docker containers. Allowed values must be in the
         range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for
         system pools. The default value is 1.
        :paramtype count: int
        :keyword vm_size: Size of agent VMs. Known values are: "Standard_A1", "Standard_A10",
         "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
         "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
         "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
         "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
         "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
         "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
         "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
         "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
         "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
         "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
         "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
         "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
         "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
         "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
         "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
         "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
         "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
         "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
         "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
         "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
         "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
         "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
         "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
         "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
         "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
         "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
         "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
         "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
         "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
         "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
         "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
         "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
         "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
         "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
         "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
         "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
         "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", and "Standard_NV6".
        :paramtype vm_size: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.ContainerServiceVMSizeTypes
        :keyword os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
         machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
         according to the vmSize specified.
        :paramtype os_disk_size_gb: int
        :keyword os_disk_type: OS disk type to be used for machines in a given agent pool. Allowed
         values are 'Ephemeral' and 'Managed'. If unspecified, defaults to 'Ephemeral' when the VM
         supports ephemeral OS and has a cache disk larger than the requested OSDiskSizeGB. Otherwise,
         defaults to 'Managed'. May not be changed after creation. Known values are: "Managed" and
         "Ephemeral".
        :paramtype os_disk_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OSDiskType
        :keyword kubelet_disk_type: KubeletDiskType determines the placement of emptyDir volumes,
         container runtime data root, and Kubelet ephemeral storage. Currently allows one value, OS,
         resulting in Kubelet using the OS disk for data. "OS"
        :paramtype kubelet_disk_type: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.KubeletDiskType
        :keyword vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier for nodes and
         maybe pods.
        :paramtype vnet_subnet_id: str
        :keyword pod_subnet_id: Pod SubnetID specifies the VNet's subnet identifier for pods.
        :paramtype pod_subnet_id: str
        :keyword max_pods: Maximum number of pods that can run on a node.
        :paramtype max_pods: int
        :keyword os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default
         to Linux. Known values are: "Linux" and "Windows".
        :paramtype os_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OSType
        :keyword max_count: Maximum number of nodes for auto-scaling.
        :paramtype max_count: int
        :keyword min_count: Minimum number of nodes for auto-scaling.
        :paramtype min_count: int
        :keyword enable_auto_scaling: Whether to enable auto-scaler.
        :paramtype enable_auto_scaling: bool
        :keyword type: AgentPoolType represents types of an agent pool. Known values are:
         "VirtualMachineScaleSets" and "AvailabilitySet".
        :paramtype type: str or ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolType
        :keyword mode: AgentPoolMode represents mode of an agent pool. Known values are: "System" and
         "User".
        :paramtype mode: str or ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolMode
        :keyword orchestrator_version: Version of orchestrator specified when creating the managed
         cluster.
        :paramtype orchestrator_version: str
        :keyword upgrade_settings: Settings for upgrading the agentpool.
        :paramtype upgrade_settings:
         ~azure.mgmt.containerservice.v2020_12_01.models.AgentPoolUpgradeSettings
        :keyword availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
         AgentPoolType.
        :paramtype availability_zones: list[str]
        :keyword enable_node_public_ip: Enable public IP for nodes.
        :paramtype enable_node_public_ip: bool
        :keyword scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
         priority. Default to regular. Known values are: "Spot" and "Regular".
        :paramtype scale_set_priority: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.ScaleSetPriority
        :keyword scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction
         policy for Spot virtual machine scale set. Default to Delete. Known values are: "Delete" and
         "Deallocate".
        :paramtype scale_set_eviction_policy: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.ScaleSetEvictionPolicy
        :keyword spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing
         to pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
         indicates default price to be up-to on-demand.
        :paramtype spot_max_price: float
        :keyword tags: Agent pool tags to be persisted on the agent pool virtual machine scale set.
        :paramtype tags: dict[str, str]
        :keyword node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
        :paramtype node_labels: dict[str, str]
        :keyword node_taints: Taints added to new nodes during node pool create and scale. For example,
         key=value:NoSchedule.
        :paramtype node_taints: list[str]
        :keyword proximity_placement_group_id: The ID for Proximity Placement Group.
        :paramtype proximity_placement_group_id: str
        :keyword kubelet_config: KubeletConfig specifies the configuration of kubelet on agent nodes.
        :paramtype kubelet_config: ~azure.mgmt.containerservice.v2020_12_01.models.KubeletConfig
        :keyword linux_os_config: LinuxOSConfig specifies the OS configuration of linux agent nodes.
        :paramtype linux_os_config: ~azure.mgmt.containerservice.v2020_12_01.models.LinuxOSConfig
        :keyword enable_encryption_at_host: Whether to enable EncryptionAtHost.
        :paramtype enable_encryption_at_host: bool
        :keyword name: Unique name of the agent pool profile in the context of the subscription and
         resource group. Required.
        :paramtype name: str
        """
        super().__init__(
            count=count,
            vm_size=vm_size,
            os_disk_size_gb=os_disk_size_gb,
            os_disk_type=os_disk_type,
            kubelet_disk_type=kubelet_disk_type,
            vnet_subnet_id=vnet_subnet_id,
            pod_subnet_id=pod_subnet_id,
            max_pods=max_pods,
            os_type=os_type,
            max_count=max_count,
            min_count=min_count,
            enable_auto_scaling=enable_auto_scaling,
            type=type,
            mode=mode,
            orchestrator_version=orchestrator_version,
            upgrade_settings=upgrade_settings,
            availability_zones=availability_zones,
            enable_node_public_ip=enable_node_public_ip,
            scale_set_priority=scale_set_priority,
            scale_set_eviction_policy=scale_set_eviction_policy,
            spot_max_price=spot_max_price,
            tags=tags,
            node_labels=node_labels,
            node_taints=node_taints,
            proximity_placement_group_id=proximity_placement_group_id,
            kubelet_config=kubelet_config,
            linux_os_config=linux_os_config,
            enable_encryption_at_host=enable_encryption_at_host,
            **kwargs
        )
        self.name = name


class ManagedClusterAPIServerAccessProfile(_serialization.Model):
    """Access profile for managed cluster API server.

    :ivar authorized_ip_ranges: Authorized IP Ranges to kubernetes API server.
    :vartype authorized_ip_ranges: list[str]
    :ivar enable_private_cluster: Whether to create the cluster as a private cluster or not.
    :vartype enable_private_cluster: bool
    :ivar private_dns_zone: Private dns zone mode for private cluster.
    :vartype private_dns_zone: str
    """

    _attribute_map = {
        "authorized_ip_ranges": {"key": "authorizedIPRanges", "type": "[str]"},
        "enable_private_cluster": {"key": "enablePrivateCluster", "type": "bool"},
        "private_dns_zone": {"key": "privateDNSZone", "type": "str"},
    }

    def __init__(
        self,
        *,
        authorized_ip_ranges: Optional[List[str]] = None,
        enable_private_cluster: Optional[bool] = None,
        private_dns_zone: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authorized_ip_ranges: Authorized IP Ranges to kubernetes API server.
        :paramtype authorized_ip_ranges: list[str]
        :keyword enable_private_cluster: Whether to create the cluster as a private cluster or not.
        :paramtype enable_private_cluster: bool
        :keyword private_dns_zone: Private dns zone mode for private cluster.
        :paramtype private_dns_zone: str
        """
        super().__init__(**kwargs)
        self.authorized_ip_ranges = authorized_ip_ranges
        self.enable_private_cluster = enable_private_cluster
        self.private_dns_zone = private_dns_zone


class ManagedClusterAutoUpgradeProfile(_serialization.Model):
    """Auto upgrade profile for a managed cluster.

    :ivar upgrade_channel: upgrade channel for auto upgrade. Known values are: "rapid", "stable",
     "patch", and "none".
    :vartype upgrade_channel: str or ~azure.mgmt.containerservice.v2020_12_01.models.UpgradeChannel
    """

    _attribute_map = {
        "upgrade_channel": {"key": "upgradeChannel", "type": "str"},
    }

    def __init__(
        self, *, upgrade_channel: Optional[Union[str, "_models.UpgradeChannel"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword upgrade_channel: upgrade channel for auto upgrade. Known values are: "rapid",
         "stable", "patch", and "none".
        :paramtype upgrade_channel: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.UpgradeChannel
        """
        super().__init__(**kwargs)
        self.upgrade_channel = upgrade_channel


class ManagedClusterIdentity(_serialization.Model):
    """Identity for the managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of the system assigned identity which is used by master
     components.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity which is used by master
     components.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the managed cluster. Type 'SystemAssigned' will use
     an implicitly created identity in master components and an auto-created user assigned identity
     in MC_ resource group in agent nodes. Type 'None' will not use MSI for the managed cluster,
     service principal will be used instead. Known values are: "SystemAssigned", "UserAssigned", and
     "None".
    :vartype type: str or ~azure.mgmt.containerservice.v2020_12_01.models.ResourceIdentityType
    :ivar user_assigned_identities: The user identity associated with the managed cluster. This
     identity will be used in control plane and only one user assigned identity is allowed. The user
     identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.  # pylint: disable=line-too-long
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.containerservice.v2020_12_01.models.Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties]  # pylint: disable=line-too-long
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {
            "key": "userAssignedIdentities",
            "type": "{Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties}",
        },
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[
            Dict[
                str,
                "_models.Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties",
            ]
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of identity used for the managed cluster. Type 'SystemAssigned' will
         use an implicitly created identity in master components and an auto-created user assigned
         identity in MC_ resource group in agent nodes. Type 'None' will not use MSI for the managed
         cluster, service principal will be used instead. Known values are: "SystemAssigned",
         "UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.containerservice.v2020_12_01.models.ResourceIdentityType
        :keyword user_assigned_identities: The user identity associated with the managed cluster. This
         identity will be used in control plane and only one user assigned identity is allowed. The user
         identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.  # pylint: disable=line-too-long
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.containerservice.v2020_12_01.models.Components1Umhcm8SchemasManagedclusteridentityPropertiesUserassignedidentitiesAdditionalproperties]  # pylint: disable=line-too-long
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class ManagedClusterListResult(_serialization.Model):
    """The response from the List Managed Clusters operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of managed clusters.
    :vartype value: list[~azure.mgmt.containerservice.v2020_12_01.models.ManagedCluster]
    :ivar next_link: The URL to get the next set of managed cluster results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedCluster]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ManagedCluster"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of managed clusters.
        :paramtype value: list[~azure.mgmt.containerservice.v2020_12_01.models.ManagedCluster]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ManagedClusterLoadBalancerProfile(_serialization.Model):
    """Profile of the managed cluster load balancer.

    :ivar managed_outbound_i_ps: Desired managed outbound IPs for the cluster load balancer.
    :vartype managed_outbound_i_ps:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterLoadBalancerProfileManagedOutboundIPs
    :ivar outbound_ip_prefixes: Desired outbound IP Prefix resources for the cluster load balancer.
    :vartype outbound_ip_prefixes:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterLoadBalancerProfileOutboundIPPrefixes
    :ivar outbound_i_ps: Desired outbound IP resources for the cluster load balancer.
    :vartype outbound_i_ps:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterLoadBalancerProfileOutboundIPs
    :ivar effective_outbound_i_ps: The effective outbound IP resources of the cluster load
     balancer.
    :vartype effective_outbound_i_ps:
     list[~azure.mgmt.containerservice.v2020_12_01.models.ResourceReference]
    :ivar allocated_outbound_ports: Desired number of allocated SNAT ports per VM. Allowed values
     must be in the range of 0 to 64000 (inclusive). The default value is 0 which results in Azure
     dynamically allocating ports.
    :vartype allocated_outbound_ports: int
    :ivar idle_timeout_in_minutes: Desired outbound flow idle timeout in minutes. Allowed values
     must be in the range of 4 to 120 (inclusive). The default value is 30 minutes.
    :vartype idle_timeout_in_minutes: int
    """

    _validation = {
        "allocated_outbound_ports": {"maximum": 64000, "minimum": 0},
        "idle_timeout_in_minutes": {"maximum": 120, "minimum": 4},
    }

    _attribute_map = {
        "managed_outbound_i_ps": {
            "key": "managedOutboundIPs",
            "type": "ManagedClusterLoadBalancerProfileManagedOutboundIPs",
        },
        "outbound_ip_prefixes": {
            "key": "outboundIPPrefixes",
            "type": "ManagedClusterLoadBalancerProfileOutboundIPPrefixes",
        },
        "outbound_i_ps": {"key": "outboundIPs", "type": "ManagedClusterLoadBalancerProfileOutboundIPs"},
        "effective_outbound_i_ps": {"key": "effectiveOutboundIPs", "type": "[ResourceReference]"},
        "allocated_outbound_ports": {"key": "allocatedOutboundPorts", "type": "int"},
        "idle_timeout_in_minutes": {"key": "idleTimeoutInMinutes", "type": "int"},
    }

    def __init__(
        self,
        *,
        managed_outbound_i_ps: Optional["_models.ManagedClusterLoadBalancerProfileManagedOutboundIPs"] = None,
        outbound_ip_prefixes: Optional["_models.ManagedClusterLoadBalancerProfileOutboundIPPrefixes"] = None,
        outbound_i_ps: Optional["_models.ManagedClusterLoadBalancerProfileOutboundIPs"] = None,
        effective_outbound_i_ps: Optional[List["_models.ResourceReference"]] = None,
        allocated_outbound_ports: int = 0,
        idle_timeout_in_minutes: int = 30,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_outbound_i_ps: Desired managed outbound IPs for the cluster load balancer.
        :paramtype managed_outbound_i_ps:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterLoadBalancerProfileManagedOutboundIPs
        :keyword outbound_ip_prefixes: Desired outbound IP Prefix resources for the cluster load
         balancer.
        :paramtype outbound_ip_prefixes:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterLoadBalancerProfileOutboundIPPrefixes
        :keyword outbound_i_ps: Desired outbound IP resources for the cluster load balancer.
        :paramtype outbound_i_ps:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterLoadBalancerProfileOutboundIPs
        :keyword effective_outbound_i_ps: The effective outbound IP resources of the cluster load
         balancer.
        :paramtype effective_outbound_i_ps:
         list[~azure.mgmt.containerservice.v2020_12_01.models.ResourceReference]
        :keyword allocated_outbound_ports: Desired number of allocated SNAT ports per VM. Allowed
         values must be in the range of 0 to 64000 (inclusive). The default value is 0 which results in
         Azure dynamically allocating ports.
        :paramtype allocated_outbound_ports: int
        :keyword idle_timeout_in_minutes: Desired outbound flow idle timeout in minutes. Allowed values
         must be in the range of 4 to 120 (inclusive). The default value is 30 minutes.
        :paramtype idle_timeout_in_minutes: int
        """
        super().__init__(**kwargs)
        self.managed_outbound_i_ps = managed_outbound_i_ps
        self.outbound_ip_prefixes = outbound_ip_prefixes
        self.outbound_i_ps = outbound_i_ps
        self.effective_outbound_i_ps = effective_outbound_i_ps
        self.allocated_outbound_ports = allocated_outbound_ports
        self.idle_timeout_in_minutes = idle_timeout_in_minutes


class ManagedClusterLoadBalancerProfileManagedOutboundIPs(_serialization.Model):  # pylint: disable=name-too-long
    """Desired managed outbound IPs for the cluster load balancer.

    :ivar count: Desired number of outbound IP created/managed by Azure for the cluster load
     balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
    :vartype count: int
    """

    _validation = {
        "count": {"maximum": 100, "minimum": 1},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, *, count: int = 1, **kwargs: Any) -> None:
        """
        :keyword count: Desired number of outbound IP created/managed by Azure for the cluster load
         balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
        :paramtype count: int
        """
        super().__init__(**kwargs)
        self.count = count


class ManagedClusterLoadBalancerProfileOutboundIPPrefixes(_serialization.Model):  # pylint: disable=name-too-long
    """Desired outbound IP Prefix resources for the cluster load balancer.

    :ivar public_ip_prefixes: A list of public IP prefix resources.
    :vartype public_ip_prefixes:
     list[~azure.mgmt.containerservice.v2020_12_01.models.ResourceReference]
    """

    _attribute_map = {
        "public_ip_prefixes": {"key": "publicIPPrefixes", "type": "[ResourceReference]"},
    }

    def __init__(
        self, *, public_ip_prefixes: Optional[List["_models.ResourceReference"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword public_ip_prefixes: A list of public IP prefix resources.
        :paramtype public_ip_prefixes:
         list[~azure.mgmt.containerservice.v2020_12_01.models.ResourceReference]
        """
        super().__init__(**kwargs)
        self.public_ip_prefixes = public_ip_prefixes


class ManagedClusterLoadBalancerProfileOutboundIPs(_serialization.Model):  # pylint: disable=name-too-long
    """Desired outbound IP resources for the cluster load balancer.

    :ivar public_i_ps: A list of public IP resources.
    :vartype public_i_ps: list[~azure.mgmt.containerservice.v2020_12_01.models.ResourceReference]
    """

    _attribute_map = {
        "public_i_ps": {"key": "publicIPs", "type": "[ResourceReference]"},
    }

    def __init__(self, *, public_i_ps: Optional[List["_models.ResourceReference"]] = None, **kwargs: Any) -> None:
        """
        :keyword public_i_ps: A list of public IP resources.
        :paramtype public_i_ps: list[~azure.mgmt.containerservice.v2020_12_01.models.ResourceReference]
        """
        super().__init__(**kwargs)
        self.public_i_ps = public_i_ps


class ManagedClusterPodIdentity(_serialization.Model):
    """ManagedClusterPodIdentity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the pod identity. Required.
    :vartype name: str
    :ivar namespace: Namespace of the pod identity. Required.
    :vartype namespace: str
    :ivar identity: Information of the user assigned identity. Required.
    :vartype identity: ~azure.mgmt.containerservice.v2020_12_01.models.UserAssignedIdentity
    :ivar provisioning_state: The current provisioning state of the pod identity. Known values are:
     "Assigned", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPodIdentityProvisioningState
    :ivar provisioning_info:
    :vartype provisioning_info:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPodIdentityProvisioningInfo
    """

    _validation = {
        "name": {"required": True},
        "namespace": {"required": True},
        "identity": {"required": True},
        "provisioning_state": {"readonly": True},
        "provisioning_info": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
        "identity": {"key": "identity", "type": "UserAssignedIdentity"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "provisioning_info": {"key": "provisioningInfo", "type": "ManagedClusterPodIdentityProvisioningInfo"},
    }

    def __init__(self, *, name: str, namespace: str, identity: "_models.UserAssignedIdentity", **kwargs: Any) -> None:
        """
        :keyword name: Name of the pod identity. Required.
        :paramtype name: str
        :keyword namespace: Namespace of the pod identity. Required.
        :paramtype namespace: str
        :keyword identity: Information of the user assigned identity. Required.
        :paramtype identity: ~azure.mgmt.containerservice.v2020_12_01.models.UserAssignedIdentity
        """
        super().__init__(**kwargs)
        self.name = name
        self.namespace = namespace
        self.identity = identity
        self.provisioning_state = None
        self.provisioning_info = None


class ManagedClusterPodIdentityException(_serialization.Model):
    """ManagedClusterPodIdentityException.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the pod identity exception. Required.
    :vartype name: str
    :ivar namespace: Namespace of the pod identity exception. Required.
    :vartype namespace: str
    :ivar pod_labels: Pod labels to match. Required.
    :vartype pod_labels: dict[str, str]
    """

    _validation = {
        "name": {"required": True},
        "namespace": {"required": True},
        "pod_labels": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
        "pod_labels": {"key": "podLabels", "type": "{str}"},
    }

    def __init__(self, *, name: str, namespace: str, pod_labels: Dict[str, str], **kwargs: Any) -> None:
        """
        :keyword name: Name of the pod identity exception. Required.
        :paramtype name: str
        :keyword namespace: Namespace of the pod identity exception. Required.
        :paramtype namespace: str
        :keyword pod_labels: Pod labels to match. Required.
        :paramtype pod_labels: dict[str, str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.namespace = namespace
        self.pod_labels = pod_labels


class ManagedClusterPodIdentityProfile(_serialization.Model):
    """ManagedClusterPodIdentityProfile.

    :ivar enabled: Whether the pod identity addon is enabled.
    :vartype enabled: bool
    :ivar user_assigned_identities: User assigned pod identity settings.
    :vartype user_assigned_identities:
     list[~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPodIdentity]
    :ivar user_assigned_identity_exceptions: User assigned pod identity exception settings.
    :vartype user_assigned_identity_exceptions:
     list[~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPodIdentityException]
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "[ManagedClusterPodIdentity]"},
        "user_assigned_identity_exceptions": {
            "key": "userAssignedIdentityExceptions",
            "type": "[ManagedClusterPodIdentityException]",
        },
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        user_assigned_identities: Optional[List["_models.ManagedClusterPodIdentity"]] = None,
        user_assigned_identity_exceptions: Optional[List["_models.ManagedClusterPodIdentityException"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Whether the pod identity addon is enabled.
        :paramtype enabled: bool
        :keyword user_assigned_identities: User assigned pod identity settings.
        :paramtype user_assigned_identities:
         list[~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPodIdentity]
        :keyword user_assigned_identity_exceptions: User assigned pod identity exception settings.
        :paramtype user_assigned_identity_exceptions:
         list[~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPodIdentityException]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.user_assigned_identities = user_assigned_identities
        self.user_assigned_identity_exceptions = user_assigned_identity_exceptions


class ManagedClusterPodIdentityProvisioningInfo(_serialization.Model):  # pylint: disable=name-too-long
    """ManagedClusterPodIdentityProvisioningInfo.

    :ivar error: Pod identity assignment error (if any).
    :vartype error: ~azure.mgmt.containerservice.v2020_12_01.models.CloudError
    """

    _attribute_map = {
        "error": {"key": "error", "type": "CloudError"},
    }

    def __init__(self, *, error: Optional["_models.CloudError"] = None, **kwargs: Any) -> None:
        """
        :keyword error: Pod identity assignment error (if any).
        :paramtype error: ~azure.mgmt.containerservice.v2020_12_01.models.CloudError
        """
        super().__init__(**kwargs)
        self.error = error


class ManagedClusterPoolUpgradeProfile(_serialization.Model):
    """The list of available upgrade versions.

    All required parameters must be populated in order to send to server.

    :ivar kubernetes_version: Kubernetes version (major, minor, patch). Required.
    :vartype kubernetes_version: str
    :ivar name: Pool name.
    :vartype name: str
    :ivar os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Known values are: "Linux" and "Windows".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OSType
    :ivar upgrades: List of orchestrator types and versions available for upgrade.
    :vartype upgrades:
     list[~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPoolUpgradeProfileUpgradesItem]
    """

    _validation = {
        "kubernetes_version": {"required": True},
        "os_type": {"required": True},
    }

    _attribute_map = {
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "upgrades": {"key": "upgrades", "type": "[ManagedClusterPoolUpgradeProfileUpgradesItem]"},
    }

    def __init__(
        self,
        *,
        kubernetes_version: str,
        os_type: Union[str, "_models.OSType"] = "Linux",
        name: Optional[str] = None,
        upgrades: Optional[List["_models.ManagedClusterPoolUpgradeProfileUpgradesItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kubernetes_version: Kubernetes version (major, minor, patch). Required.
        :paramtype kubernetes_version: str
        :keyword name: Pool name.
        :paramtype name: str
        :keyword os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default
         to Linux. Known values are: "Linux" and "Windows".
        :paramtype os_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.OSType
        :keyword upgrades: List of orchestrator types and versions available for upgrade.
        :paramtype upgrades:
         list[~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPoolUpgradeProfileUpgradesItem]
        """
        super().__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.name = name
        self.os_type = os_type
        self.upgrades = upgrades


class ManagedClusterPoolUpgradeProfileUpgradesItem(_serialization.Model):  # pylint: disable=name-too-long
    """ManagedClusterPoolUpgradeProfileUpgradesItem.

    :ivar kubernetes_version: Kubernetes version (major, minor, patch).
    :vartype kubernetes_version: str
    :ivar is_preview: Whether Kubernetes version is currently in preview.
    :vartype is_preview: bool
    """

    _attribute_map = {
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "is_preview": {"key": "isPreview", "type": "bool"},
    }

    def __init__(
        self, *, kubernetes_version: Optional[str] = None, is_preview: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kubernetes_version: Kubernetes version (major, minor, patch).
        :paramtype kubernetes_version: str
        :keyword is_preview: Whether Kubernetes version is currently in preview.
        :paramtype is_preview: bool
        """
        super().__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class ManagedClusterPropertiesAutoScalerProfile(
    _serialization.Model
):  # pylint: disable=too-many-instance-attributes,name-too-long
    """Parameters to be applied to the cluster-autoscaler when enabled.

    :ivar balance_similar_node_groups:
    :vartype balance_similar_node_groups: str
    :ivar expander: Known values are: "least-waste", "most-pods", "priority", and "random".
    :vartype expander: str or ~azure.mgmt.containerservice.v2020_12_01.models.Expander
    :ivar max_empty_bulk_delete:
    :vartype max_empty_bulk_delete: str
    :ivar max_graceful_termination_sec:
    :vartype max_graceful_termination_sec: str
    :ivar max_node_provision_time:
    :vartype max_node_provision_time: str
    :ivar max_total_unready_percentage:
    :vartype max_total_unready_percentage: str
    :ivar new_pod_scale_up_delay:
    :vartype new_pod_scale_up_delay: str
    :ivar ok_total_unready_count:
    :vartype ok_total_unready_count: str
    :ivar scan_interval:
    :vartype scan_interval: str
    :ivar scale_down_delay_after_add:
    :vartype scale_down_delay_after_add: str
    :ivar scale_down_delay_after_delete:
    :vartype scale_down_delay_after_delete: str
    :ivar scale_down_delay_after_failure:
    :vartype scale_down_delay_after_failure: str
    :ivar scale_down_unneeded_time:
    :vartype scale_down_unneeded_time: str
    :ivar scale_down_unready_time:
    :vartype scale_down_unready_time: str
    :ivar scale_down_utilization_threshold:
    :vartype scale_down_utilization_threshold: str
    :ivar skip_nodes_with_local_storage:
    :vartype skip_nodes_with_local_storage: str
    :ivar skip_nodes_with_system_pods:
    :vartype skip_nodes_with_system_pods: str
    """

    _attribute_map = {
        "balance_similar_node_groups": {"key": "balance-similar-node-groups", "type": "str"},
        "expander": {"key": "expander", "type": "str"},
        "max_empty_bulk_delete": {"key": "max-empty-bulk-delete", "type": "str"},
        "max_graceful_termination_sec": {"key": "max-graceful-termination-sec", "type": "str"},
        "max_node_provision_time": {"key": "max-node-provision-time", "type": "str"},
        "max_total_unready_percentage": {"key": "max-total-unready-percentage", "type": "str"},
        "new_pod_scale_up_delay": {"key": "new-pod-scale-up-delay", "type": "str"},
        "ok_total_unready_count": {"key": "ok-total-unready-count", "type": "str"},
        "scan_interval": {"key": "scan-interval", "type": "str"},
        "scale_down_delay_after_add": {"key": "scale-down-delay-after-add", "type": "str"},
        "scale_down_delay_after_delete": {"key": "scale-down-delay-after-delete", "type": "str"},
        "scale_down_delay_after_failure": {"key": "scale-down-delay-after-failure", "type": "str"},
        "scale_down_unneeded_time": {"key": "scale-down-unneeded-time", "type": "str"},
        "scale_down_unready_time": {"key": "scale-down-unready-time", "type": "str"},
        "scale_down_utilization_threshold": {"key": "scale-down-utilization-threshold", "type": "str"},
        "skip_nodes_with_local_storage": {"key": "skip-nodes-with-local-storage", "type": "str"},
        "skip_nodes_with_system_pods": {"key": "skip-nodes-with-system-pods", "type": "str"},
    }

    def __init__(
        self,
        *,
        balance_similar_node_groups: Optional[str] = None,
        expander: Optional[Union[str, "_models.Expander"]] = None,
        max_empty_bulk_delete: Optional[str] = None,
        max_graceful_termination_sec: Optional[str] = None,
        max_node_provision_time: Optional[str] = None,
        max_total_unready_percentage: Optional[str] = None,
        new_pod_scale_up_delay: Optional[str] = None,
        ok_total_unready_count: Optional[str] = None,
        scan_interval: Optional[str] = None,
        scale_down_delay_after_add: Optional[str] = None,
        scale_down_delay_after_delete: Optional[str] = None,
        scale_down_delay_after_failure: Optional[str] = None,
        scale_down_unneeded_time: Optional[str] = None,
        scale_down_unready_time: Optional[str] = None,
        scale_down_utilization_threshold: Optional[str] = None,
        skip_nodes_with_local_storage: Optional[str] = None,
        skip_nodes_with_system_pods: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword balance_similar_node_groups:
        :paramtype balance_similar_node_groups: str
        :keyword expander: Known values are: "least-waste", "most-pods", "priority", and "random".
        :paramtype expander: str or ~azure.mgmt.containerservice.v2020_12_01.models.Expander
        :keyword max_empty_bulk_delete:
        :paramtype max_empty_bulk_delete: str
        :keyword max_graceful_termination_sec:
        :paramtype max_graceful_termination_sec: str
        :keyword max_node_provision_time:
        :paramtype max_node_provision_time: str
        :keyword max_total_unready_percentage:
        :paramtype max_total_unready_percentage: str
        :keyword new_pod_scale_up_delay:
        :paramtype new_pod_scale_up_delay: str
        :keyword ok_total_unready_count:
        :paramtype ok_total_unready_count: str
        :keyword scan_interval:
        :paramtype scan_interval: str
        :keyword scale_down_delay_after_add:
        :paramtype scale_down_delay_after_add: str
        :keyword scale_down_delay_after_delete:
        :paramtype scale_down_delay_after_delete: str
        :keyword scale_down_delay_after_failure:
        :paramtype scale_down_delay_after_failure: str
        :keyword scale_down_unneeded_time:
        :paramtype scale_down_unneeded_time: str
        :keyword scale_down_unready_time:
        :paramtype scale_down_unready_time: str
        :keyword scale_down_utilization_threshold:
        :paramtype scale_down_utilization_threshold: str
        :keyword skip_nodes_with_local_storage:
        :paramtype skip_nodes_with_local_storage: str
        :keyword skip_nodes_with_system_pods:
        :paramtype skip_nodes_with_system_pods: str
        """
        super().__init__(**kwargs)
        self.balance_similar_node_groups = balance_similar_node_groups
        self.expander = expander
        self.max_empty_bulk_delete = max_empty_bulk_delete
        self.max_graceful_termination_sec = max_graceful_termination_sec
        self.max_node_provision_time = max_node_provision_time
        self.max_total_unready_percentage = max_total_unready_percentage
        self.new_pod_scale_up_delay = new_pod_scale_up_delay
        self.ok_total_unready_count = ok_total_unready_count
        self.scan_interval = scan_interval
        self.scale_down_delay_after_add = scale_down_delay_after_add
        self.scale_down_delay_after_delete = scale_down_delay_after_delete
        self.scale_down_delay_after_failure = scale_down_delay_after_failure
        self.scale_down_unneeded_time = scale_down_unneeded_time
        self.scale_down_unready_time = scale_down_unready_time
        self.scale_down_utilization_threshold = scale_down_utilization_threshold
        self.skip_nodes_with_local_storage = skip_nodes_with_local_storage
        self.skip_nodes_with_system_pods = skip_nodes_with_system_pods


class ManagedClusterServicePrincipalProfile(_serialization.Model):
    """Information about a service principal identity for the cluster to use for manipulating Azure
    APIs.

    All required parameters must be populated in order to send to server.

    :ivar client_id: The ID for the service principal. Required.
    :vartype client_id: str
    :ivar secret: The secret password associated with the service principal in plain text.
    :vartype secret: str
    """

    _validation = {
        "client_id": {"required": True},
    }

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "secret": {"key": "secret", "type": "str"},
    }

    def __init__(self, *, client_id: str, secret: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword client_id: The ID for the service principal. Required.
        :paramtype client_id: str
        :keyword secret: The secret password associated with the service principal in plain text.
        :paramtype secret: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.secret = secret


class ManagedClusterSKU(_serialization.Model):
    """ManagedClusterSKU.

    :ivar name: Name of a managed cluster SKU. "Basic"
    :vartype name: str or ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterSKUName
    :ivar tier: Tier of a managed cluster SKU. Known values are: "Paid" and "Free".
    :vartype tier: str or ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterSKUTier
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.ManagedClusterSKUName"]] = None,
        tier: Optional[Union[str, "_models.ManagedClusterSKUTier"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of a managed cluster SKU. "Basic"
        :paramtype name: str or ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterSKUName
        :keyword tier: Tier of a managed cluster SKU. Known values are: "Paid" and "Free".
        :paramtype tier: str or ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterSKUTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier


class ManagedClusterUpgradeProfile(_serialization.Model):
    """The list of available upgrades for compute pools.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Id of upgrade profile.
    :vartype id: str
    :ivar name: Name of upgrade profile.
    :vartype name: str
    :ivar type: Type of upgrade profile.
    :vartype type: str
    :ivar control_plane_profile: The list of available upgrade versions for the control plane.
     Required.
    :vartype control_plane_profile:
     ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPoolUpgradeProfile
    :ivar agent_pool_profiles: The list of available upgrade versions for agent pools. Required.
    :vartype agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPoolUpgradeProfile]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "control_plane_profile": {"required": True},
        "agent_pool_profiles": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "control_plane_profile": {"key": "properties.controlPlaneProfile", "type": "ManagedClusterPoolUpgradeProfile"},
        "agent_pool_profiles": {"key": "properties.agentPoolProfiles", "type": "[ManagedClusterPoolUpgradeProfile]"},
    }

    def __init__(
        self,
        *,
        control_plane_profile: "_models.ManagedClusterPoolUpgradeProfile",
        agent_pool_profiles: List["_models.ManagedClusterPoolUpgradeProfile"],
        **kwargs: Any
    ) -> None:
        """
        :keyword control_plane_profile: The list of available upgrade versions for the control plane.
         Required.
        :paramtype control_plane_profile:
         ~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPoolUpgradeProfile
        :keyword agent_pool_profiles: The list of available upgrade versions for agent pools. Required.
        :paramtype agent_pool_profiles:
         list[~azure.mgmt.containerservice.v2020_12_01.models.ManagedClusterPoolUpgradeProfile]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.control_plane_profile = control_plane_profile
        self.agent_pool_profiles = agent_pool_profiles


class ManagedClusterWindowsProfile(_serialization.Model):
    """Profile for Windows VMs in the container service cluster.

    All required parameters must be populated in order to send to server.

    :ivar admin_username: Specifies the name of the administrator account. :code:`<br>`:code:`<br>`
     **restriction:** Cannot end in "." :code:`<br>`:code:`<br>` **Disallowed values:**
     "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1",
     "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
     "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2",
     "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length:** 1 character
     :code:`<br>`:code:`<br>` **Max-length:** 20 characters. Required.
    :vartype admin_username: str
    :ivar admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length:** 8 characters :code:`<br>`:code:`<br>`
     **Max-length:** 123 characters :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4
     conditions below need to be fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper
     characters :code:`<br>` Has a digit :code:`<br>` Has a special character (Regex match [\W_])
     :code:`<br>`:code:`<br>` **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd",
     "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!".
    :vartype admin_password: str
    :ivar license_type: The licenseType to use for Windows VMs. Windows_Server is used to enable
     Azure Hybrid User Benefits for Windows VMs. Known values are: "None" and "Windows_Server".
    :vartype license_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.LicenseType
    """

    _validation = {
        "admin_username": {"required": True},
    }

    _attribute_map = {
        "admin_username": {"key": "adminUsername", "type": "str"},
        "admin_password": {"key": "adminPassword", "type": "str"},
        "license_type": {"key": "licenseType", "type": "str"},
    }

    def __init__(
        self,
        *,
        admin_username: str,
        admin_password: Optional[str] = None,
        license_type: Optional[Union[str, "_models.LicenseType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword admin_username: Specifies the name of the administrator account.
         :code:`<br>`:code:`<br>` **restriction:** Cannot end in "." :code:`<br>`:code:`<br>`
         **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1",
         "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console",
         "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0",
         "sys", "test2", "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length:** 1
         character :code:`<br>`:code:`<br>` **Max-length:** 20 characters. Required.
        :paramtype admin_username: str
        :keyword admin_password: Specifies the password of the administrator account.
         :code:`<br>`:code:`<br>` **Minimum-length:** 8 characters :code:`<br>`:code:`<br>`
         **Max-length:** 123 characters :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4
         conditions below need to be fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper
         characters :code:`<br>` Has a digit :code:`<br>` Has a special character (Regex match [\W_])
         :code:`<br>`:code:`<br>` **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd",
         "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!".
        :paramtype admin_password: str
        :keyword license_type: The licenseType to use for Windows VMs. Windows_Server is used to enable
         Azure Hybrid User Benefits for Windows VMs. Known values are: "None" and "Windows_Server".
        :paramtype license_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.LicenseType
        """
        super().__init__(**kwargs)
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.license_type = license_type


class OperationListResult(_serialization.Model):
    """The List Compute Operation operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of compute operations.
    :vartype value: list[~azure.mgmt.containerservice.v2020_12_01.models.OperationValue]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationValue]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class OperationValue(_serialization.Model):
    """Describes the properties of a Compute Operation value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        "origin": {"readonly": True},
        "name": {"readonly": True},
        "operation": {"readonly": True},
        "resource": {"readonly": True},
        "description": {"readonly": True},
        "provider": {"readonly": True},
    }

    _attribute_map = {
        "origin": {"key": "origin", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "operation": {"key": "display.operation", "type": "str"},
        "resource": {"key": "display.resource", "type": "str"},
        "description": {"key": "display.description", "type": "str"},
        "provider": {"key": "display.provider", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.origin = None
        self.name = None
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class PowerState(_serialization.Model):
    """Describes the Power State of the cluster.

    :ivar code: Tells whether the cluster is Running or Stopped. Known values are: "Running" and
     "Stopped".
    :vartype code: str or ~azure.mgmt.containerservice.v2020_12_01.models.Code
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
    }

    def __init__(self, *, code: Optional[Union[str, "_models.Code"]] = None, **kwargs: Any) -> None:
        """
        :keyword code: Tells whether the cluster is Running or Stopped. Known values are: "Running" and
         "Stopped".
        :paramtype code: str or ~azure.mgmt.containerservice.v2020_12_01.models.Code
        """
        super().__init__(**kwargs)
        self.code = code


class PrivateEndpoint(_serialization.Model):
    """Private endpoint which a connection belongs to.

    :ivar id: The resource Id for private endpoint.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The resource Id for private endpoint.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateEndpointConnection(_serialization.Model):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the private endpoint connection.
    :vartype id: str
    :ivar name: The name of the private endpoint connection.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar provisioning_state: The current provisioning state. Known values are: "Succeeded",
     "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.PrivateEndpointConnectionProvisioningState
    :ivar private_endpoint: The resource of private endpoint.
    :vartype private_endpoint: ~azure.mgmt.containerservice.v2020_12_01.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.containerservice.v2020_12_01.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The resource of private endpoint.
        :paramtype private_endpoint: ~azure.mgmt.containerservice.v2020_12_01.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.containerservice.v2020_12_01.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateEndpointConnectionListResult(_serialization.Model):
    """A list of private endpoint connections.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.containerservice.v2020_12_01.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The collection value.
        :paramtype value:
         list[~azure.mgmt.containerservice.v2020_12_01.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkResource(_serialization.Model):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the private link resource.
    :vartype id: str
    :ivar name: The name of the private link resource.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar group_id: The group ID of the resource.
    :vartype group_id: str
    :ivar required_members: RequiredMembers of the resource.
    :vartype required_members: list[str]
    :ivar private_link_service_id: The private link service ID of the resource, this field is
     exposed only to NRP internally.
    :vartype private_link_service_id: str
    """

    _validation = {
        "private_link_service_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "private_link_service_id": {"key": "privateLinkServiceID", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the private link resource.
        :paramtype id: str
        :keyword name: The name of the private link resource.
        :paramtype name: str
        :keyword type: The resource type.
        :paramtype type: str
        :keyword group_id: The group ID of the resource.
        :paramtype group_id: str
        :keyword required_members: RequiredMembers of the resource.
        :paramtype required_members: list[str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.group_id = group_id
        self.required_members = required_members
        self.private_link_service_id = None


class PrivateLinkResourcesListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.containerservice.v2020_12_01.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.containerservice.v2020_12_01.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(_serialization.Model):
    """The state of a private link service connection.

    :ivar status: The private link service connection status. Known values are: "Pending",
     "Approved", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.containerservice.v2020_12_01.models.ConnectionStatus
    :ivar description: The private link service connection description.
    :vartype description: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.ConnectionStatus"]] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The private link service connection status. Known values are: "Pending",
         "Approved", "Rejected", and "Disconnected".
        :paramtype status: str or ~azure.mgmt.containerservice.v2020_12_01.models.ConnectionStatus
        :keyword description: The private link service connection description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description


class ResourceReference(_serialization.Model):
    """A reference to an Azure resource.

    :ivar id: The fully qualified Azure resource id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The fully qualified Azure resource id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SysctlConfig(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Sysctl settings for Linux agent nodes.

    :ivar net_core_somaxconn: Sysctl setting net.core.somaxconn.
    :vartype net_core_somaxconn: int
    :ivar net_core_netdev_max_backlog: Sysctl setting net.core.netdev_max_backlog.
    :vartype net_core_netdev_max_backlog: int
    :ivar net_core_rmem_default: Sysctl setting net.core.rmem_default.
    :vartype net_core_rmem_default: int
    :ivar net_core_rmem_max: Sysctl setting net.core.rmem_max.
    :vartype net_core_rmem_max: int
    :ivar net_core_wmem_default: Sysctl setting net.core.wmem_default.
    :vartype net_core_wmem_default: int
    :ivar net_core_wmem_max: Sysctl setting net.core.wmem_max.
    :vartype net_core_wmem_max: int
    :ivar net_core_optmem_max: Sysctl setting net.core.optmem_max.
    :vartype net_core_optmem_max: int
    :ivar net_ipv4_tcp_max_syn_backlog: Sysctl setting net.ipv4.tcp_max_syn_backlog.
    :vartype net_ipv4_tcp_max_syn_backlog: int
    :ivar net_ipv4_tcp_max_tw_buckets: Sysctl setting net.ipv4.tcp_max_tw_buckets.
    :vartype net_ipv4_tcp_max_tw_buckets: int
    :ivar net_ipv4_tcp_fin_timeout: Sysctl setting net.ipv4.tcp_fin_timeout.
    :vartype net_ipv4_tcp_fin_timeout: int
    :ivar net_ipv4_tcp_keepalive_time: Sysctl setting net.ipv4.tcp_keepalive_time.
    :vartype net_ipv4_tcp_keepalive_time: int
    :ivar net_ipv4_tcp_keepalive_probes: Sysctl setting net.ipv4.tcp_keepalive_probes.
    :vartype net_ipv4_tcp_keepalive_probes: int
    :ivar net_ipv4_tcpkeepalive_intvl: Sysctl setting net.ipv4.tcp_keepalive_intvl.
    :vartype net_ipv4_tcpkeepalive_intvl: int
    :ivar net_ipv4_tcp_tw_reuse: Sysctl setting net.ipv4.tcp_tw_reuse.
    :vartype net_ipv4_tcp_tw_reuse: bool
    :ivar net_ipv4_ip_local_port_range: Sysctl setting net.ipv4.ip_local_port_range.
    :vartype net_ipv4_ip_local_port_range: str
    :ivar net_ipv4_neigh_default_gc_thresh1: Sysctl setting net.ipv4.neigh.default.gc_thresh1.
    :vartype net_ipv4_neigh_default_gc_thresh1: int
    :ivar net_ipv4_neigh_default_gc_thresh2: Sysctl setting net.ipv4.neigh.default.gc_thresh2.
    :vartype net_ipv4_neigh_default_gc_thresh2: int
    :ivar net_ipv4_neigh_default_gc_thresh3: Sysctl setting net.ipv4.neigh.default.gc_thresh3.
    :vartype net_ipv4_neigh_default_gc_thresh3: int
    :ivar net_netfilter_nf_conntrack_max: Sysctl setting net.netfilter.nf_conntrack_max.
    :vartype net_netfilter_nf_conntrack_max: int
    :ivar net_netfilter_nf_conntrack_buckets: Sysctl setting net.netfilter.nf_conntrack_buckets.
    :vartype net_netfilter_nf_conntrack_buckets: int
    :ivar fs_inotify_max_user_watches: Sysctl setting fs.inotify.max_user_watches.
    :vartype fs_inotify_max_user_watches: int
    :ivar fs_file_max: Sysctl setting fs.file-max.
    :vartype fs_file_max: int
    :ivar fs_aio_max_nr: Sysctl setting fs.aio-max-nr.
    :vartype fs_aio_max_nr: int
    :ivar fs_nr_open: Sysctl setting fs.nr_open.
    :vartype fs_nr_open: int
    :ivar kernel_threads_max: Sysctl setting kernel.threads-max.
    :vartype kernel_threads_max: int
    :ivar vm_max_map_count: Sysctl setting vm.max_map_count.
    :vartype vm_max_map_count: int
    :ivar vm_swappiness: Sysctl setting vm.swappiness.
    :vartype vm_swappiness: int
    :ivar vm_vfs_cache_pressure: Sysctl setting vm.vfs_cache_pressure.
    :vartype vm_vfs_cache_pressure: int
    """

    _attribute_map = {
        "net_core_somaxconn": {"key": "netCoreSomaxconn", "type": "int"},
        "net_core_netdev_max_backlog": {"key": "netCoreNetdevMaxBacklog", "type": "int"},
        "net_core_rmem_default": {"key": "netCoreRmemDefault", "type": "int"},
        "net_core_rmem_max": {"key": "netCoreRmemMax", "type": "int"},
        "net_core_wmem_default": {"key": "netCoreWmemDefault", "type": "int"},
        "net_core_wmem_max": {"key": "netCoreWmemMax", "type": "int"},
        "net_core_optmem_max": {"key": "netCoreOptmemMax", "type": "int"},
        "net_ipv4_tcp_max_syn_backlog": {"key": "netIpv4TcpMaxSynBacklog", "type": "int"},
        "net_ipv4_tcp_max_tw_buckets": {"key": "netIpv4TcpMaxTwBuckets", "type": "int"},
        "net_ipv4_tcp_fin_timeout": {"key": "netIpv4TcpFinTimeout", "type": "int"},
        "net_ipv4_tcp_keepalive_time": {"key": "netIpv4TcpKeepaliveTime", "type": "int"},
        "net_ipv4_tcp_keepalive_probes": {"key": "netIpv4TcpKeepaliveProbes", "type": "int"},
        "net_ipv4_tcpkeepalive_intvl": {"key": "netIpv4TcpkeepaliveIntvl", "type": "int"},
        "net_ipv4_tcp_tw_reuse": {"key": "netIpv4TcpTwReuse", "type": "bool"},
        "net_ipv4_ip_local_port_range": {"key": "netIpv4IpLocalPortRange", "type": "str"},
        "net_ipv4_neigh_default_gc_thresh1": {"key": "netIpv4NeighDefaultGcThresh1", "type": "int"},
        "net_ipv4_neigh_default_gc_thresh2": {"key": "netIpv4NeighDefaultGcThresh2", "type": "int"},
        "net_ipv4_neigh_default_gc_thresh3": {"key": "netIpv4NeighDefaultGcThresh3", "type": "int"},
        "net_netfilter_nf_conntrack_max": {"key": "netNetfilterNfConntrackMax", "type": "int"},
        "net_netfilter_nf_conntrack_buckets": {"key": "netNetfilterNfConntrackBuckets", "type": "int"},
        "fs_inotify_max_user_watches": {"key": "fsInotifyMaxUserWatches", "type": "int"},
        "fs_file_max": {"key": "fsFileMax", "type": "int"},
        "fs_aio_max_nr": {"key": "fsAioMaxNr", "type": "int"},
        "fs_nr_open": {"key": "fsNrOpen", "type": "int"},
        "kernel_threads_max": {"key": "kernelThreadsMax", "type": "int"},
        "vm_max_map_count": {"key": "vmMaxMapCount", "type": "int"},
        "vm_swappiness": {"key": "vmSwappiness", "type": "int"},
        "vm_vfs_cache_pressure": {"key": "vmVfsCachePressure", "type": "int"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        net_core_somaxconn: Optional[int] = None,
        net_core_netdev_max_backlog: Optional[int] = None,
        net_core_rmem_default: Optional[int] = None,
        net_core_rmem_max: Optional[int] = None,
        net_core_wmem_default: Optional[int] = None,
        net_core_wmem_max: Optional[int] = None,
        net_core_optmem_max: Optional[int] = None,
        net_ipv4_tcp_max_syn_backlog: Optional[int] = None,
        net_ipv4_tcp_max_tw_buckets: Optional[int] = None,
        net_ipv4_tcp_fin_timeout: Optional[int] = None,
        net_ipv4_tcp_keepalive_time: Optional[int] = None,
        net_ipv4_tcp_keepalive_probes: Optional[int] = None,
        net_ipv4_tcpkeepalive_intvl: Optional[int] = None,
        net_ipv4_tcp_tw_reuse: Optional[bool] = None,
        net_ipv4_ip_local_port_range: Optional[str] = None,
        net_ipv4_neigh_default_gc_thresh1: Optional[int] = None,
        net_ipv4_neigh_default_gc_thresh2: Optional[int] = None,
        net_ipv4_neigh_default_gc_thresh3: Optional[int] = None,
        net_netfilter_nf_conntrack_max: Optional[int] = None,
        net_netfilter_nf_conntrack_buckets: Optional[int] = None,
        fs_inotify_max_user_watches: Optional[int] = None,
        fs_file_max: Optional[int] = None,
        fs_aio_max_nr: Optional[int] = None,
        fs_nr_open: Optional[int] = None,
        kernel_threads_max: Optional[int] = None,
        vm_max_map_count: Optional[int] = None,
        vm_swappiness: Optional[int] = None,
        vm_vfs_cache_pressure: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword net_core_somaxconn: Sysctl setting net.core.somaxconn.
        :paramtype net_core_somaxconn: int
        :keyword net_core_netdev_max_backlog: Sysctl setting net.core.netdev_max_backlog.
        :paramtype net_core_netdev_max_backlog: int
        :keyword net_core_rmem_default: Sysctl setting net.core.rmem_default.
        :paramtype net_core_rmem_default: int
        :keyword net_core_rmem_max: Sysctl setting net.core.rmem_max.
        :paramtype net_core_rmem_max: int
        :keyword net_core_wmem_default: Sysctl setting net.core.wmem_default.
        :paramtype net_core_wmem_default: int
        :keyword net_core_wmem_max: Sysctl setting net.core.wmem_max.
        :paramtype net_core_wmem_max: int
        :keyword net_core_optmem_max: Sysctl setting net.core.optmem_max.
        :paramtype net_core_optmem_max: int
        :keyword net_ipv4_tcp_max_syn_backlog: Sysctl setting net.ipv4.tcp_max_syn_backlog.
        :paramtype net_ipv4_tcp_max_syn_backlog: int
        :keyword net_ipv4_tcp_max_tw_buckets: Sysctl setting net.ipv4.tcp_max_tw_buckets.
        :paramtype net_ipv4_tcp_max_tw_buckets: int
        :keyword net_ipv4_tcp_fin_timeout: Sysctl setting net.ipv4.tcp_fin_timeout.
        :paramtype net_ipv4_tcp_fin_timeout: int
        :keyword net_ipv4_tcp_keepalive_time: Sysctl setting net.ipv4.tcp_keepalive_time.
        :paramtype net_ipv4_tcp_keepalive_time: int
        :keyword net_ipv4_tcp_keepalive_probes: Sysctl setting net.ipv4.tcp_keepalive_probes.
        :paramtype net_ipv4_tcp_keepalive_probes: int
        :keyword net_ipv4_tcpkeepalive_intvl: Sysctl setting net.ipv4.tcp_keepalive_intvl.
        :paramtype net_ipv4_tcpkeepalive_intvl: int
        :keyword net_ipv4_tcp_tw_reuse: Sysctl setting net.ipv4.tcp_tw_reuse.
        :paramtype net_ipv4_tcp_tw_reuse: bool
        :keyword net_ipv4_ip_local_port_range: Sysctl setting net.ipv4.ip_local_port_range.
        :paramtype net_ipv4_ip_local_port_range: str
        :keyword net_ipv4_neigh_default_gc_thresh1: Sysctl setting net.ipv4.neigh.default.gc_thresh1.
        :paramtype net_ipv4_neigh_default_gc_thresh1: int
        :keyword net_ipv4_neigh_default_gc_thresh2: Sysctl setting net.ipv4.neigh.default.gc_thresh2.
        :paramtype net_ipv4_neigh_default_gc_thresh2: int
        :keyword net_ipv4_neigh_default_gc_thresh3: Sysctl setting net.ipv4.neigh.default.gc_thresh3.
        :paramtype net_ipv4_neigh_default_gc_thresh3: int
        :keyword net_netfilter_nf_conntrack_max: Sysctl setting net.netfilter.nf_conntrack_max.
        :paramtype net_netfilter_nf_conntrack_max: int
        :keyword net_netfilter_nf_conntrack_buckets: Sysctl setting net.netfilter.nf_conntrack_buckets.
        :paramtype net_netfilter_nf_conntrack_buckets: int
        :keyword fs_inotify_max_user_watches: Sysctl setting fs.inotify.max_user_watches.
        :paramtype fs_inotify_max_user_watches: int
        :keyword fs_file_max: Sysctl setting fs.file-max.
        :paramtype fs_file_max: int
        :keyword fs_aio_max_nr: Sysctl setting fs.aio-max-nr.
        :paramtype fs_aio_max_nr: int
        :keyword fs_nr_open: Sysctl setting fs.nr_open.
        :paramtype fs_nr_open: int
        :keyword kernel_threads_max: Sysctl setting kernel.threads-max.
        :paramtype kernel_threads_max: int
        :keyword vm_max_map_count: Sysctl setting vm.max_map_count.
        :paramtype vm_max_map_count: int
        :keyword vm_swappiness: Sysctl setting vm.swappiness.
        :paramtype vm_swappiness: int
        :keyword vm_vfs_cache_pressure: Sysctl setting vm.vfs_cache_pressure.
        :paramtype vm_vfs_cache_pressure: int
        """
        super().__init__(**kwargs)
        self.net_core_somaxconn = net_core_somaxconn
        self.net_core_netdev_max_backlog = net_core_netdev_max_backlog
        self.net_core_rmem_default = net_core_rmem_default
        self.net_core_rmem_max = net_core_rmem_max
        self.net_core_wmem_default = net_core_wmem_default
        self.net_core_wmem_max = net_core_wmem_max
        self.net_core_optmem_max = net_core_optmem_max
        self.net_ipv4_tcp_max_syn_backlog = net_ipv4_tcp_max_syn_backlog
        self.net_ipv4_tcp_max_tw_buckets = net_ipv4_tcp_max_tw_buckets
        self.net_ipv4_tcp_fin_timeout = net_ipv4_tcp_fin_timeout
        self.net_ipv4_tcp_keepalive_time = net_ipv4_tcp_keepalive_time
        self.net_ipv4_tcp_keepalive_probes = net_ipv4_tcp_keepalive_probes
        self.net_ipv4_tcpkeepalive_intvl = net_ipv4_tcpkeepalive_intvl
        self.net_ipv4_tcp_tw_reuse = net_ipv4_tcp_tw_reuse
        self.net_ipv4_ip_local_port_range = net_ipv4_ip_local_port_range
        self.net_ipv4_neigh_default_gc_thresh1 = net_ipv4_neigh_default_gc_thresh1
        self.net_ipv4_neigh_default_gc_thresh2 = net_ipv4_neigh_default_gc_thresh2
        self.net_ipv4_neigh_default_gc_thresh3 = net_ipv4_neigh_default_gc_thresh3
        self.net_netfilter_nf_conntrack_max = net_netfilter_nf_conntrack_max
        self.net_netfilter_nf_conntrack_buckets = net_netfilter_nf_conntrack_buckets
        self.fs_inotify_max_user_watches = fs_inotify_max_user_watches
        self.fs_file_max = fs_file_max
        self.fs_aio_max_nr = fs_aio_max_nr
        self.fs_nr_open = fs_nr_open
        self.kernel_threads_max = kernel_threads_max
        self.vm_max_map_count = vm_max_map_count
        self.vm_swappiness = vm_swappiness
        self.vm_vfs_cache_pressure = vm_vfs_cache_pressure


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.containerservice.v2020_12_01.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.containerservice.v2020_12_01.models.CreatedByType
    :ivar last_modified_at: The type of identity that last modified the resource.
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.containerservice.v2020_12_01.models.CreatedByType
        :keyword last_modified_at: The type of identity that last modified the resource.
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsObject(_serialization.Model):
    """Tags object for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class TimeInWeek(_serialization.Model):
    """Time in a week.

    :ivar day: A day in a week. Known values are: "Sunday", "Monday", "Tuesday", "Wednesday",
     "Thursday", "Friday", and "Saturday".
    :vartype day: str or ~azure.mgmt.containerservice.v2020_12_01.models.WeekDay
    :ivar hour_slots: hour slots in a day.
    :vartype hour_slots: list[int]
    """

    _attribute_map = {
        "day": {"key": "day", "type": "str"},
        "hour_slots": {"key": "hourSlots", "type": "[int]"},
    }

    def __init__(
        self,
        *,
        day: Optional[Union[str, "_models.WeekDay"]] = None,
        hour_slots: Optional[List[int]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword day: A day in a week. Known values are: "Sunday", "Monday", "Tuesday", "Wednesday",
         "Thursday", "Friday", and "Saturday".
        :paramtype day: str or ~azure.mgmt.containerservice.v2020_12_01.models.WeekDay
        :keyword hour_slots: hour slots in a day.
        :paramtype hour_slots: list[int]
        """
        super().__init__(**kwargs)
        self.day = day
        self.hour_slots = hour_slots


class TimeSpan(_serialization.Model):
    """The time span with start and end properties.

    :ivar start: The start of a time span.
    :vartype start: ~datetime.datetime
    :ivar end: The end of a time span.
    :vartype end: ~datetime.datetime
    """

    _attribute_map = {
        "start": {"key": "start", "type": "iso-8601"},
        "end": {"key": "end", "type": "iso-8601"},
    }

    def __init__(
        self, *, start: Optional[datetime.datetime] = None, end: Optional[datetime.datetime] = None, **kwargs: Any
    ) -> None:
        """
        :keyword start: The start of a time span.
        :paramtype start: ~datetime.datetime
        :keyword end: The end of a time span.
        :paramtype end: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.start = start
        self.end = end
