/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.KnnByteVectorField;
import org.apache.lucene.document.KnnVectorField;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.BytesRef;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;
import org.opensearch.knn.index.codec.util.KNNVectorSerializerFactory;

public enum VectorDataType {
    BYTE("byte"){

        @Override
        public FieldType createKnnVectorFieldType(int dimension, VectorSimilarityFunction vectorSimilarityFunction) {
            return KnnByteVectorField.createFieldType((int)dimension, (VectorSimilarityFunction)vectorSimilarityFunction);
        }

        @Override
        public float[] getVectorFromBytesRef(BytesRef binaryValue) {
            float[] vector = new float[binaryValue.length];
            int i = 0;
            int j = binaryValue.offset;
            while (i < binaryValue.length) {
                vector[i++] = binaryValue.bytes[j++];
            }
            return vector;
        }
    }
    ,
    FLOAT("float"){

        @Override
        public FieldType createKnnVectorFieldType(int dimension, VectorSimilarityFunction vectorSimilarityFunction) {
            return KnnVectorField.createFieldType((int)dimension, (VectorSimilarityFunction)vectorSimilarityFunction);
        }

        @Override
        public float[] getVectorFromBytesRef(BytesRef binaryValue) {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(binaryValue.bytes, binaryValue.offset, binaryValue.length);
            KNNVectorSerializer vectorSerializer = KNNVectorSerializerFactory.getSerializerByStreamContent(byteStream);
            return vectorSerializer.byteToFloatArray(byteStream);
        }
    };

    public static final String SUPPORTED_VECTOR_DATA_TYPES;
    private final String value;

    public abstract FieldType createKnnVectorFieldType(int var1, VectorSimilarityFunction var2);

    public abstract float[] getVectorFromBytesRef(BytesRef var1);

    public static VectorDataType get(String vectorDataType) {
        Objects.requireNonNull(vectorDataType, String.format(Locale.ROOT, "[%s] should not be null. Supported types are [%s]", "data_type", SUPPORTED_VECTOR_DATA_TYPES));
        try {
            return VectorDataType.valueOf(vectorDataType.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid value provided for [%s] field. Supported values are [%s]", "data_type", SUPPORTED_VECTOR_DATA_TYPES));
        }
    }

    @Generated
    private VectorDataType(String value) {
        this.value = value;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    static {
        SUPPORTED_VECTOR_DATA_TYPES = Arrays.stream(VectorDataType.values()).map(VectorDataType::getValue).collect(Collectors.joining(","));
    }
}

