/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport;

import com.sun.corba.ee.impl.transport.ConnectionCacheBase;
import com.sun.corba.ee.impl.transport.InboundConnectionCacheProbeProvider;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.Acceptor;
import com.sun.corba.ee.spi.transport.Connection;
import com.sun.corba.ee.spi.transport.InboundConnectionCache;
import java.util.ArrayList;
import java.util.Collection;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedObject;

@Transport
@ManagedObject
@Description(value="Cache of connections accepted by the ORB")
@AMXMetadata(type="corba-inbound-connection-cache-mon", group="monitoring")
public class InboundConnectionCacheImpl
extends ConnectionCacheBase
implements InboundConnectionCache {
    protected Collection<Connection> connectionCache;
    private InboundConnectionCacheProbeProvider pp = new InboundConnectionCacheProbeProvider();

    public InboundConnectionCacheImpl(ORB orb, Acceptor acceptor) {
        super(orb, acceptor.getConnectionCacheType(), acceptor.getMonitoringName());
        this.connectionCache = new ArrayList<Connection>();
    }

    @Override
    public Connection get(Acceptor acceptor) {
        throw wrapper.methodShouldNotBeCalled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void put(Acceptor acceptor, Connection connection) {
        Object object = this.backingStore();
        synchronized (object) {
            this.connectionCache.add(connection);
            connection.setConnectionCache(this);
            this.cacheStatisticsInfo();
            this.pp.connectionOpenedEvent(acceptor.toString(), connection.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transport
    public void remove(Connection connection) {
        Object object = this.backingStore();
        synchronized (object) {
            this.connectionCache.remove(connection);
            this.cacheStatisticsInfo();
            this.pp.connectionClosedEvent(connection.toString());
        }
    }

    @Override
    public Collection values() {
        return this.connectionCache;
    }

    @Override
    protected Object backingStore() {
        return this.connectionCache;
    }
}

