/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.GlsResource;

public enum FieldReference {
    SELF("self"),
    PARENT("parent"),
    ROOT("root"),
    ENTRY_TYPE("entrytype"),
    ENTRY_LABEL("entrylabel"),
    ENTRY_BIB("entrybib");

    private final String id;

    private FieldReference(String string2) {
        this.id = string2;
    }

    public static FieldReference getReference(String string) throws IllegalArgumentException {
        if (string == null || string.isEmpty() || string.equals("self")) {
            return SELF;
        }
        if (string.equals("parent")) {
            return PARENT;
        }
        if (string.equals("root")) {
            return ROOT;
        }
        if (string.equals("entrytype")) {
            return ENTRY_TYPE;
        }
        if (string.equals("entrylabel")) {
            return ENTRY_LABEL;
        }
        if (string.equals("entrybib")) {
            return ENTRY_BIB;
        }
        throw new IllegalArgumentException("Invalid field reference tag: " + string);
    }

    public Bib2GlsEntry getEntry(Bib2GlsEntry bib2GlsEntry) {
        if (this == SELF || this == ENTRY_TYPE || this == ENTRY_LABEL || this == ENTRY_BIB) {
            return bib2GlsEntry;
        }
        String string = bib2GlsEntry.getParent();
        if (string == null) {
            return null;
        }
        GlsResource glsResource = bib2GlsEntry.getResource();
        Bib2GlsEntry bib2GlsEntry2 = glsResource.getEntry(string);
        if (bib2GlsEntry2 == null || this == PARENT) {
            return bib2GlsEntry2;
        }
        return bib2GlsEntry2.getHierarchyRoot();
    }

    public String getTag() {
        return this.id;
    }
}

