/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.threads;

import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.StopPooledThreadException;

public class TaskThread
extends Thread {
    private static final Log log = LogFactory.getLog(TaskThread.class);
    private static final StringManager sm = StringManager.getManager(TaskThread.class);
    private final long creationTime = System.currentTimeMillis();

    public TaskThread(ThreadGroup threadGroup, Runnable runnable, String string) {
        super(threadGroup, new WrappingRunnable(runnable), string);
    }

    public TaskThread(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
        super(threadGroup, new WrappingRunnable(runnable), string, l);
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    private static class WrappingRunnable
    implements Runnable {
        private Runnable wrappedRunnable;

        WrappingRunnable(Runnable runnable) {
            this.wrappedRunnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.wrappedRunnable.run();
            }
            catch (StopPooledThreadException stopPooledThreadException) {
                log.debug((Object)sm.getString("taskThread.exiting"), (Throwable)stopPooledThreadException);
            }
        }
    }
}

