/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import sun.nio.ch.DirectBuffer;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11Mac
extends MacSpi {
    private final Token token;
    private final String algorithm;
    private final CK_MECHANISM ckMechanism;
    private final int macLength;
    private P11Key p11Key;
    private Session session;
    private boolean initialized;
    private byte[] oneByte;

    P11Mac(Token token, String string, long l) throws PKCS11Exception {
        this.token = token;
        this.algorithm = string;
        Long l2 = null;
        switch ((int)l) {
            case 529: {
                this.macLength = 16;
                break;
            }
            case 545: {
                this.macLength = 20;
                break;
            }
            case 598: {
                this.macLength = 28;
                break;
            }
            case 593: {
                this.macLength = 32;
                break;
            }
            case 609: {
                this.macLength = 48;
                break;
            }
            case 625: {
                this.macLength = 64;
                break;
            }
            case 896: {
                this.macLength = 16;
                l2 = 16L;
                break;
            }
            case 897: {
                this.macLength = 20;
                l2 = 20L;
                break;
            }
            default: {
                throw new ProviderException("Unknown mechanism: " + l);
            }
        }
        this.ckMechanism = new CK_MECHANISM(l, l2);
    }

    private void reset(boolean bl) {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        try {
            if (this.session == null) {
                return;
            }
            if (bl && this.token.explicitCancel) {
                this.cancelOperation();
            }
        }
        finally {
            this.p11Key.releaseKeyID();
            this.session = this.token.releaseSession(this.session);
        }
    }

    private void cancelOperation() {
        this.token.ensureValid();
        try {
            this.token.p11.C_SignFinal(this.session.id(), 0);
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (pKCS11Exception.getErrorCode() == 145L) {
                return;
            }
            throw new ProviderException("Cancel failed", pKCS11Exception);
        }
    }

    private void ensureInitialized() throws PKCS11Exception {
        if (!this.initialized) {
            this.initialize();
        }
    }

    private void initialize() throws PKCS11Exception {
        if (this.p11Key == null) {
            throw new ProviderException("Operation cannot be performed without calling engineInit first");
        }
        this.token.ensureValid();
        long l = this.p11Key.getKeyID();
        try {
            if (this.session == null) {
                this.session = this.token.getOpSession();
            }
            this.token.p11.C_SignInit(this.session.id(), this.ckMechanism, l);
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.p11Key.releaseKeyID();
            this.session = this.token.releaseSession(this.session);
            throw pKCS11Exception;
        }
        this.initialized = true;
    }

    @Override
    protected int engineGetMacLength() {
        return this.macLength;
    }

    @Override
    protected void engineReset() {
        this.reset(true);
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.reset(true);
        this.p11Key = P11SecretKeyFactory.convertKey(this.token, key, this.algorithm);
        try {
            this.initialize();
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("init() failed", pKCS11Exception);
        }
    }

    @Override
    protected byte[] engineDoFinal() {
        try {
            this.ensureInitialized();
            byte[] byArray = this.token.p11.C_SignFinal(this.session.id(), 0);
            return byArray;
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("doFinal() failed", pKCS11Exception);
        }
        finally {
            this.reset(false);
        }
    }

    @Override
    protected void engineUpdate(byte by) {
        if (this.oneByte == null) {
            this.oneByte = new byte[1];
        }
        this.oneByte[0] = by;
        this.engineUpdate(this.oneByte, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        try {
            this.ensureInitialized();
            this.token.p11.C_SignUpdate(this.session.id(), 0L, byArray, n, n2);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("update() failed", pKCS11Exception);
        }
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        try {
            this.ensureInitialized();
            int n = byteBuffer.remaining();
            if (n <= 0) {
                return;
            }
            if (!(byteBuffer instanceof DirectBuffer)) {
                super.engineUpdate(byteBuffer);
                return;
            }
            long l = ((DirectBuffer)((Object)byteBuffer)).address();
            int n2 = byteBuffer.position();
            this.token.p11.C_SignUpdate(this.session.id(), l + (long)n2, null, 0, n);
            byteBuffer.position(n2 + n);
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new ProviderException("update() failed", pKCS11Exception);
        }
    }
}

