/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.properties.HasName;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.codeexplorer.graph.GraphCycleFinder;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNode;

public class ClassNode
extends CodeNode {
    private final JavaClass javaClass;
    private Set<JavaClass> innerClasses;
    static final String ANNOTATION_ICON_NAME = "code_annotation";
    static final String INTERFACE_ICON_NAME = "code_interface";
    static final String ABSTRACT_CLASS_ICON_NAME = "code_abstractClass";
    static final String CLASS_ICON_NAME = "code_class";
    static final String ENUM_ICON_NAME = "code_enum";

    ClassNode(JavaClass javaClass, CodeMap map, int groupIndex) {
        super(map, groupIndex);
        this.javaClass = javaClass;
        this.innerClasses = null;
        this.setFolded(false);
        this.setIdWithIndex(javaClass.getName());
        String nodeText = ClassNode.classNameWithEnclosingClasses(javaClass);
        this.setText(nodeText);
    }

    @Override
    Set<? extends JavaAnnotation<? extends HasName>> getAnnotations() {
        return this.javaClass.getAnnotations();
    }

    @Override
    Set<JavaType> getInterfaces() {
        return this.javaClass.getInterfaces();
    }

    @Override
    protected Stream<JavaClass> getClasses() {
        return Stream.of(this.javaClass);
    }

    public static String classNameWithEnclosingClasses(JavaClass javaClass) {
        String simpleName = ClassNode.getSimpleName(javaClass);
        return javaClass.getEnclosingClass().map(ec -> ClassNode.classNameWithEnclosingClasses(ec) + "." + simpleName).orElse(simpleName);
    }

    public static String getSimpleName(JavaClass javaClass) {
        String simpleName = javaClass.getSimpleName();
        if (simpleName.isEmpty()) {
            int lastIndexOfNon$;
            String fullName = javaClass.getName();
            for (lastIndexOfNon$ = fullName.length() - 1; lastIndexOfNon$ >= 0 && fullName.charAt(lastIndexOfNon$) == '$'; --lastIndexOfNon$) {
            }
            return Formatters.ensureSimpleName((String)fullName.substring(0, lastIndexOfNon$ + 1)) + fullName.substring(lastIndexOfNon$ + 1);
        }
        return simpleName;
    }

    @Override
    HasName getCodeElement() {
        return this.javaClass;
    }

    public int getChildCount() {
        return 0;
    }

    protected List<NodeModel> getChildrenInternal() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.getText();
    }

    @Override
    Stream<Dependency> getOutgoingDependencies() {
        return this.getDependencies(JavaClass::getDirectDependenciesFromSelf).filter(dep -> ClassNode.hasValidTopLevelClass(dep.getTargetClass()));
    }

    @Override
    Stream<Dependency> getIncomingDependencies() {
        return this.getDependencies(JavaClass::getDirectDependenciesToSelf).filter(dep -> ClassNode.hasValidTopLevelClass(dep.getOriginClass()));
    }

    private Stream<Dependency> getDependencies(Function<? super JavaClass, ? extends Set<Dependency>> mapper) {
        return this.innerClasses == null ? mapper.apply((JavaClass)this.javaClass).stream() : Stream.concat(Stream.of(this.javaClass), this.innerClasses.stream()).map(mapper).flatMap(Collection::stream).filter(this::connectsDifferentNodes);
    }

    private boolean connectsDifferentNodes(Dependency dep) {
        return ClassNode.findEnclosingNamedClass(dep.getOriginClass()) != ClassNode.findEnclosingNamedClass(dep.getTargetClass());
    }

    void registerInnerClass(JavaClass innerClass) {
        if (innerClass == this.javaClass) {
            return;
        }
        if (this.innerClasses == null) {
            this.innerClasses = new HashSet<JavaClass>();
        }
        this.innerClasses.add(innerClass);
    }

    @Override
    String getUIIconName() {
        if (this.javaClass.isAnnotation()) {
            return ANNOTATION_ICON_NAME;
        }
        if (this.javaClass.isInterface()) {
            return INTERFACE_ICON_NAME;
        }
        if (this.javaClass.isEnum()) {
            return ENUM_ICON_NAME;
        }
        if (this.javaClass.getModifiers().contains(JavaModifier.ABSTRACT)) {
            return ABSTRACT_CLASS_ICON_NAME;
        }
        return CLASS_ICON_NAME;
    }

    @Override
    Set<CodeNode> findCyclicDependencies() {
        GraphCycleFinder<CodeNode> cycleFinder = new GraphCycleFinder<CodeNode>();
        cycleFinder.addNode(this);
        cycleFinder.stopSearchHere();
        cycleFinder.exploreGraph(Collections.singleton(this), this::connectedTargetNodesInGroup, this::connectedOriginNodesInGroup);
        LinkedHashSet cycles = cycleFinder.findSimpleCycles().stream().map(Map.Entry::getKey).collect(Collectors.toCollection(LinkedHashSet::new));
        return cycles;
    }

    private Stream<CodeNode> connectedOriginNodesInGroup(CodeNode node) {
        Stream<JavaClass> originClasses = node.getIncomingDependenciesWithKnownOrigins().map(Dependency::getOriginClass);
        return this.nodes(originClasses);
    }

    private Stream<CodeNode> connectedTargetNodesInGroup(CodeNode node) {
        Stream<JavaClass> targetClasses = node.getOutgoingDependenciesWithKnownTargets().map(Dependency::getTargetClass);
        return this.nodes(targetClasses);
    }

    private Stream<CodeNode> nodes(Stream<JavaClass> classes) {
        return classes.map(this::idWithGroupIndex).map(arg_0 -> ((CodeMap)this.getMap()).getNodeForID(arg_0)).map(CodeNode.class::cast);
    }

    static {
        IconStoreFactory.INSTANCE.createStateIcon(INTERFACE_ICON_NAME, "code/interface.svg");
        IconStoreFactory.INSTANCE.createStateIcon(ABSTRACT_CLASS_ICON_NAME, "code/classAbstract.svg");
        IconStoreFactory.INSTANCE.createStateIcon(CLASS_ICON_NAME, "code/class.svg");
        IconStoreFactory.INSTANCE.createStateIcon(ENUM_ICON_NAME, "code/enum.svg");
        IconStoreFactory.INSTANCE.createStateIcon(ANNOTATION_ICON_NAME, "code/annotation.svg");
    }
}

