/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.freeplane.extension;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.Source;
import com.tngtech.archunit.freeplane.extension.ArchitectureViolations;
import com.tngtech.archunit.freeplane.extension.ViolationDescription;
import com.tngtech.archunit.library.cycle_detection.Cycle;
import com.tngtech.archunit.library.dependencies.Slice;
import com.tngtech.archunit.library.dependencies.SliceDependency;
import com.tngtech.archunit.library.modules.ArchModule;
import com.tngtech.archunit.library.modules.ModuleDependency;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

class TransferObjectBuilder {
    private final List<ViolationDescription> violationDescriptions = new ArrayList<ViolationDescription>();
    private final Map<String, Set<JavaClass>> violatingClasses = new HashMap<String, Set<JavaClass>>();
    private SortedSet<String> violationDependencyDescriptions = Collections.emptySortedSet();
    private SortedSet<String> cyclicDependencyDescriptions = Collections.emptySortedSet();
    private SortedSet<String> violatingClassesGroup = Collections.emptySortedSet();

    TransferObjectBuilder() {
    }

    void handle(Collection<Object> violatingObjects, String message) {
        this.violationDependencyDescriptions = new TreeSet<String>();
        this.cyclicDependencyDescriptions = new TreeSet<String>();
        this.violatingClassesGroup = new TreeSet<String>();
        violatingObjects.forEach(this::handle);
        this.violationDescriptions.add(new ViolationDescription(message, this.violationDependencyDescriptions, this.cyclicDependencyDescriptions, this.violatingClassesGroup));
    }

    private void handle(Object violatingObject) {
        if (violatingObject instanceof JavaAccess) {
            JavaAccess javaAccess = (JavaAccess)violatingObject;
            JavaClass originOwner = javaAccess.getOriginOwner();
            JavaClass targetOwner = javaAccess.getTargetOwner();
            Set<JavaClass> set = this.violatingClassSet("");
            set.add(originOwner);
            set.add(targetOwner);
            if (originOwner.equals(targetOwner)) {
                this.violatingClassesGroup.add(originOwner.getName());
            } else {
                this.violationDependencyDescriptions.add(javaAccess.getDescription());
            }
            return;
        }
        if (violatingObject instanceof Dependency) {
            Dependency dependency = (Dependency)violatingObject;
            JavaClass originOwner = dependency.getOriginClass();
            JavaClass targetOwner = dependency.getTargetClass();
            Set<JavaClass> set = this.violatingClassSet("");
            set.add(originOwner);
            set.add(targetOwner);
            this.violationDependencyDescriptions.add(dependency.getDescription());
            return;
        }
        if (violatingObject instanceof JavaClass) {
            Set<JavaClass> set = this.violatingClassSet("");
            JavaClass violatingClass = (JavaClass)violatingObject;
            set.add(violatingClass);
            this.violatingClassesGroup.add(violatingClass.getName());
            return;
        }
        if (violatingObject instanceof JavaMember) {
            Set<JavaClass> set = this.violatingClassSet("");
            JavaClass violatingClass = ((JavaMember)violatingObject).getOwner();
            set.add(violatingClass);
            this.violatingClassesGroup.add(violatingClass.getName());
            return;
        }
        if (violatingObject instanceof Cycle) {
            Cycle cycle = (Cycle)violatingObject;
            cycle.getEdges().forEach(edge -> {
                Object originObject = edge.getOrigin();
                Object targetObject = edge.getTarget();
                if (originObject instanceof Slice && targetObject instanceof Slice) {
                    Slice origin = (Slice)originObject;
                    Slice target = (Slice)targetObject;
                    Set<JavaClass> originClasses = this.violatingClassSet(origin.getDescription());
                    Set<JavaClass> targetClasses = this.violatingClassSet(target.getDescription());
                    origin.getDependenciesFromSelf().stream().filter(d -> target.contains((Object)d.getTargetClass())).forEach(d -> {
                        this.cyclicDependencyDescriptions.add(d.getDescription());
                        originClasses.add(d.getOriginClass());
                        targetClasses.add(d.getTargetClass());
                    });
                } else if (originObject instanceof ArchModule && targetObject instanceof ArchModule) {
                    ArchModule origin = (ArchModule)originObject;
                    ArchModule target = (ArchModule)targetObject;
                    Set<JavaClass> originClasses = this.violatingClassSet(origin.getName());
                    Set<JavaClass> targetClasses = this.violatingClassSet(target.getName());
                    origin.getModuleDependenciesFromSelf().stream().filter(d -> target.equals((Object)d.getTarget())).flatMap(d -> d.toClassDependencies().stream()).forEach(d -> {
                        this.cyclicDependencyDescriptions.add(d.getDescription());
                        originClasses.add(d.getOriginClass());
                        targetClasses.add(d.getTargetClass());
                    });
                }
            });
            return;
        }
        if (violatingObject instanceof SliceDependency) {
            SliceDependency dependency = (SliceDependency)violatingObject;
            Slice origin = dependency.getOrigin();
            Slice target = dependency.getTarget();
            Set<JavaClass> originClasses = this.violatingClassSet(origin.getDescription());
            Set<JavaClass> targetClasses = this.violatingClassSet(target.getDescription());
            origin.stream().map(JavaClass::getDirectDependenciesFromSelf).flatMap(Collection::stream).filter(d -> target.contains((Object)d.getTargetClass())).forEach(d -> {
                originClasses.add(d.getOriginClass());
                targetClasses.add(d.getTargetClass());
                this.violationDependencyDescriptions.add(d.getDescription());
            });
            return;
        }
        if (violatingObject instanceof ModuleDependency) {
            ModuleDependency dependency = (ModuleDependency)violatingObject;
            ArchModule origin = dependency.getOrigin();
            ArchModule target = dependency.getTarget();
            Set<JavaClass> originClasses = this.violatingClassSet(origin.getName());
            Set<JavaClass> targetClasses = this.violatingClassSet(target.getName());
            dependency.toClassDependencies().forEach(d -> {
                originClasses.add(d.getOriginClass());
                targetClasses.add(d.getTargetClass());
                this.violationDependencyDescriptions.add(d.getDescription());
            });
            return;
        }
    }

    private Set<JavaClass> violatingClassSet(String name) {
        return this.violatingClasses.computeIfAbsent(name, key -> new HashSet());
    }

    ArchitectureViolations buildTransferObject(String ruleDescription) {
        Map<String, Set<String>> locationSpecs = this.violatingClasses.entrySet().stream().map(e -> new AbstractMap.SimpleEntry((String)e.getKey(), ((Set)e.getValue()).stream().map(JavaClass::getSource).filter(Optional::isPresent).map(Optional::get).map(Source::getUri).map(Object::toString).collect(Collectors.toSet()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new ArchitectureViolations(ruleDescription, locationSpecs, this.violationDescriptions);
    }
}

