/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.conf.valueset;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class LabelledValue {
    @Nonnull
    private final Object value;
    @Nonnull
    private final String label;

    public LabelledValue(@Nonnull Object value, @Nonnull String label) {
        this.value = Preconditions.checkNotNull((Object)value);
        this.label = (String)Preconditions.checkNotNull((Object)label);
    }

    @Nonnull
    public Object getValue() {
        return this.value;
    }

    @Nonnull
    public String getLabel() {
        return this.label;
    }

    @Nonnull
    public Optional<OWLAnnotationValue> toOWLAnnotationValue(@Nonnull OWLDataFactory dataFactory) {
        if (this.value instanceof OWLAnnotationValue) {
            return Optional.of((OWLAnnotationValue)this.value);
        }
        if (this.value instanceof OWLEntity) {
            return Optional.of(((OWLEntity)this.value).getIRI());
        }
        if (this.value instanceof String) {
            return Optional.of(dataFactory.getOWLLiteral((String)this.value));
        }
        if (this.value instanceof Boolean) {
            return Optional.of(dataFactory.getOWLLiteral(((Boolean)this.value).booleanValue()));
        }
        if (this.value instanceof Integer) {
            return Optional.of(dataFactory.getOWLLiteral(((Integer)this.value).intValue()));
        }
        if (this.value instanceof Double) {
            return Optional.of(dataFactory.getOWLLiteral(Double.toString((Double)this.value), OWL2Datatype.XSD_DECIMAL));
        }
        if (this.value instanceof Float) {
            return Optional.of(dataFactory.getOWLLiteral(Double.toString(((Float)this.value).floatValue()), OWL2Datatype.XSD_DECIMAL));
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.label});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LabelledValue)) {
            return false;
        }
        LabelledValue other = (LabelledValue)obj;
        return this.value.equals(other.value) && this.label.equals(other.label);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LabelledValue").add("value", this.value).add("label", (Object)this.label).toString();
    }
}

