# Cargo-sweep

A cargo subcommand for cleaning up unused build files generated by Cargo.

## Motivation
Ideally you want:
* Caching of recent artifacts for fast build times
* Limited target size so that CI caches (on Travis etc.) are fast
* An easy way of maintaining one or more projects at the same time

Cargo-sweep aims to solve all these issues for which a simple cargo clean is not sufficient.

## Quick start

To install run:

```
cargo install cargo-sweep
```

To clean all build files older than 30 days in the local cargo project run:

```
cargo sweep --time 30
```

To clean all build files not made by the currently installed (by rustup) nightly compiler:

```
cargo sweep --toolchains nightly
```

This can be useful if you checked that your library works on stable, but mostly develop on nightly.


To clean all build files not made by any of the currently installed (by rustup) compilers:

```
cargo sweep --installed
```

This can be useful if you just updated your compilers with a `rustup update`.

Non-rustup environment are also supported. If `cargo-sweep` fails to run rustup, it fallbacks to bare `rustc` call (`rustc` must be installed and the path to it must be available through the PATH environment variable).

To preview the results of a sweep run, which is recommended as a first step, add the `--dry-run` flag, for instance:

```
cargo sweep --dry-run --time 30
```

You can also specify a path instead of defaulting to the current directory:

```
cargo sweep --time 30 <path>
```

To clean everything but the latest build you will need to run it in several steps.

```
cargo sweep --stamp

<Insert any number of cargo build, cargo test etc...>

cargo sweep --file
```
The first step generates a timestamp file which will be used to clean everything that was not used between it and the next time the file (--file) option is used.

Finally, you can recursively clean all cargo project below a given path by adding the `--recursive` flag, for instance:

```
cargo sweep --recursive --time 30 path/to/project
```

For more information run:

```
cargo sweep --help
```

## License

Cargo-sweep is distributed under the terms the MIT license.

See [LICENSE](LICENSE) for details.
