/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.options.CurlOption;
import io.cucumber.core.plugin.UrlReporter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class UrlOutputStream
extends OutputStream {
    private final UrlReporter urlReporter;
    private final CurlOption option;
    private final Path temp;
    private final OutputStream tempOutputStream;

    UrlOutputStream(CurlOption option, UrlReporter urlReporter) throws IOException {
        this.option = Objects.requireNonNull(option);
        this.urlReporter = urlReporter;
        this.temp = Files.createTempFile("cucumber", null, new FileAttribute[0]);
        this.tempOutputStream = Files.newOutputStream(this.temp, new OpenOption[0]);
    }

    @Override
    public void write(int b) throws IOException {
        this.tempOutputStream.write(b);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.tempOutputStream.write(buffer);
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        this.tempOutputStream.write(buffer, offset, count);
    }

    @Override
    public void flush() throws IOException {
        this.tempOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.tempOutputStream.close();
        this.sendRequest(this.option.getProxy(), this.option.getUri().toURL(), this.option.getMethod(), true).ifPresent(redirectResponse -> {
            if (this.urlReporter != null) {
                this.urlReporter.report((String)redirectResponse);
            }
        });
    }

    private Optional<String> sendRequest(Proxy proxy, URL url, CurlOption.HttpMethod method, boolean setHeaders) throws IOException {
        HttpURLConnection urlConnection = UrlOutputStream.openConnection(proxy, url, method);
        if (setHeaders) {
            for (Map.Entry<String, String> header : this.option.getHeaders()) {
                urlConnection.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        Map<String, List<String>> requestHeaders = urlConnection.getRequestProperties();
        urlConnection.setInstanceFollowRedirects(true);
        urlConnection.setRequestMethod(method.name());
        String redirectMessage = null;
        if (method == CurlOption.HttpMethod.GET) {
            redirectMessage = UrlOutputStream.getResponseBody(urlConnection, requestHeaders);
            String location = urlConnection.getHeaderField("Location");
            if (urlConnection.getResponseCode() == 202 && location != null) {
                this.sendRequest(this.option.getProxy(), new URL(location), CurlOption.HttpMethod.PUT, false);
            }
        } else {
            urlConnection.setDoOutput(true);
            UrlOutputStream.sendRequestBody(urlConnection, requestHeaders, this.temp);
            UrlOutputStream.getResponseBody(urlConnection, requestHeaders);
        }
        return Optional.ofNullable(redirectMessage);
    }

    private static HttpURLConnection openConnection(Proxy proxy, URL url, CurlOption.HttpMethod method) throws IOException {
        try {
            return (HttpURLConnection)url.openConnection(proxy);
        }
        catch (IOException e) {
            throw UrlOutputStream.createCurlLikeException(method.name(), url, Collections.emptyMap(), Collections.emptyMap(), "", e);
        }
    }

    private static void sendRequestBody(HttpURLConnection urlConnection, Map<String, List<String>> requestHeaders, Path requestBody) throws IOException {
        try (OutputStream outputStream = urlConnection.getOutputStream();){
            Files.copy(requestBody, outputStream);
        }
        catch (IOException e) {
            String method = urlConnection.getRequestMethod();
            URL url = urlConnection.getURL();
            throw UrlOutputStream.createCurlLikeException(method, url, requestHeaders, Collections.emptyMap(), "", e);
        }
    }

    private static String getResponseBody(HttpURLConnection urlConnection, Map<String, List<String>> requestHeaders) throws IOException {
        Map<String, List<String>> responseHeaders = urlConnection.getHeaderFields();
        int responseCode = urlConnection.getResponseCode();
        boolean unsuccessful = responseCode >= 400;
        InputStream inputStream = urlConnection.getErrorStream() != null ? urlConnection.getErrorStream() : urlConnection.getInputStream();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String responseBody = br.lines().collect(Collectors.joining(System.lineSeparator()));
            if (unsuccessful) {
                String method = urlConnection.getRequestMethod();
                URL url = urlConnection.getURL();
                throw UrlOutputStream.createCurlLikeException(method, url, requestHeaders, responseHeaders, responseBody, null);
            }
            String string = responseBody;
            return string;
        }
    }

    private static IOException createCurlLikeException(String method, URL url, Map<String, List<String>> requestHeaders, Map<String, List<String>> responseHeaders, String responseBody, Exception e) {
        return new IOException(String.format("%s:\n> %s %s%s%s%s", "HTTP request failed", method, url, UrlOutputStream.headersToString("> ", requestHeaders), UrlOutputStream.headersToString("< ", responseHeaders), responseBody), e);
    }

    private static String headersToString(String prefix, Map<String, List<String>> headers) {
        return headers.entrySet().stream().flatMap(header -> ((List)header.getValue()).stream().map(value -> {
            if (header.getKey() == null) {
                return prefix + value;
            }
            if (header.getValue() == null) {
                return prefix + (String)header.getKey();
            }
            return prefix + (String)header.getKey() + ": " + value;
        })).collect(Collectors.joining("\n", "", "\n"));
    }
}

