/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.executor;

import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.opensearch.sql.common.response.ResponseListener;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.executor.ExecutionContext;
import org.opensearch.sql.executor.ExecutionEngine;
import org.opensearch.sql.executor.Explain;
import org.opensearch.sql.executor.pagination.PlanSerializer;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.executor.protector.ExecutionProtector;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.storage.TableScanOperator;

public class OpenSearchExecutionEngine
implements ExecutionEngine {
    private final OpenSearchClient client;
    private final ExecutionProtector executionProtector;
    private final PlanSerializer planSerializer;

    public void execute(PhysicalPlan physicalPlan, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        this.execute(physicalPlan, ExecutionContext.emptyExecutionContext(), listener);
    }

    public void execute(PhysicalPlan physicalPlan, ExecutionContext context, ResponseListener<ExecutionEngine.QueryResponse> listener) {
        PhysicalPlan plan = this.executionProtector.protect(physicalPlan);
        this.client.schedule(() -> {
            try {
                ArrayList<ExprValue> result = new ArrayList<ExprValue>();
                context.getSplit().ifPresent(arg_0 -> ((PhysicalPlan)plan).add(arg_0));
                plan.open();
                while (plan.hasNext()) {
                    result.add((ExprValue)plan.next());
                }
                ExecutionEngine.QueryResponse response = new ExecutionEngine.QueryResponse(physicalPlan.schema(), result, this.planSerializer.convertToCursor(plan));
                listener.onResponse((Object)response);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
            finally {
                plan.close();
            }
        });
    }

    public void explain(PhysicalPlan plan, ResponseListener<ExecutionEngine.ExplainResponse> listener) {
        this.client.schedule(() -> {
            try {
                Explain openSearchExplain = new Explain(){

                    public ExecutionEngine.ExplainResponseNode visitTableScan(TableScanOperator node, Object context) {
                        return this.explain((PhysicalPlan)node, context, explainNode -> explainNode.setDescription(Map.of("request", node.explain())));
                    }
                };
                listener.onResponse((Object)openSearchExplain.apply(plan));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        });
    }

    @Generated
    public OpenSearchExecutionEngine(OpenSearchClient client, ExecutionProtector executionProtector, PlanSerializer planSerializer) {
        this.client = client;
        this.executionProtector = executionProtector;
        this.planSerializer = planSerializer;
    }
}

