"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const yargs = require("yargs");
const lsp = require("vscode-languageserver/node");
const server_1 = require("./server");
const argv = yargs
    .version(require('../package.json').version)
    .options({
    "stdio": {
        type: "boolean",
        description: "Use stdio",
        require: false,
    },
    "node-ipc": {
        type: "boolean",
        description: "Use node-ipc",
        require: false,
    },
    "socket": {
        type: "number",
        description: "Use socket",
        require: false,
    },
    "pipe": {
        type: "string",
        description: "Use pipe",
        require: false,
    }
})
    .help()
    .argv;
const setArgs = [argv.stdio, argv.socket, argv.nodeIpc, argv.pipe];
if (setArgs.every(a => !a)) {
    console.error("Connection type required (stdio, node-ipc, socket, pipe). Refer to --help for more details.");
    process.exit(1);
}
if (setArgs.filter(a => !!a).length !== 1) {
    console.error("You can only set exactly one connection type (stdio, node-ipc, socket, pipe). Refer to --help for more details.");
    process.exit(1);
}
const connection = lsp.createConnection();
(0, server_1.runServer)(connection);
//# sourceMappingURL=cli.js.map