# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide6.QtConcurrent, except for defaults which are replaced by "...".
"""

# Module `PySide6.QtConcurrent`

import PySide6.QtConcurrent
import PySide6.QtCore

import enum
from typing import Optional, overload
from shiboken6 import Shiboken


NoneType: TypeAlias = type[None]


class QFutureQString(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QFutureQString: PySide6.QtConcurrent.QFutureQString) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def cancel(self) -> None: ...
    def isCanceled(self) -> bool: ...
    def isFinished(self) -> bool: ...
    def isPaused(self) -> bool: ...
    def isRunning(self) -> bool: ...
    def isStarted(self) -> bool: ...
    def isSuspended(self) -> bool: ...
    def isSuspending(self) -> bool: ...
    def isValid(self) -> bool: ...
    def pause(self) -> None: ...
    def progressMaximum(self) -> int: ...
    def progressMinimum(self) -> int: ...
    def progressText(self) -> str: ...
    def progressValue(self) -> int: ...
    def resultCount(self) -> int: ...
    def resume(self) -> None: ...
    def setPaused(self, paused: bool) -> None: ...
    def setSuspended(self, suspend: bool) -> None: ...
    def suspend(self) -> None: ...
    def togglePaused(self) -> None: ...
    def toggleSuspended(self) -> None: ...
    def waitForFinished(self) -> None: ...


class QFutureVoid(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QFutureVoid: PySide6.QtConcurrent.QFutureVoid) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def cancel(self) -> None: ...
    def isCanceled(self) -> bool: ...
    def isFinished(self) -> bool: ...
    def isPaused(self) -> bool: ...
    def isRunning(self) -> bool: ...
    def isStarted(self) -> bool: ...
    def isSuspended(self) -> bool: ...
    def isSuspending(self) -> bool: ...
    def isValid(self) -> bool: ...
    def pause(self) -> None: ...
    def progressMaximum(self) -> int: ...
    def progressMinimum(self) -> int: ...
    def progressText(self) -> str: ...
    def progressValue(self) -> int: ...
    def resultCount(self) -> int: ...
    def resume(self) -> None: ...
    def setPaused(self, paused: bool) -> None: ...
    def setSuspended(self, suspend: bool) -> None: ...
    def suspend(self) -> None: ...
    def togglePaused(self) -> None: ...
    def toggleSuspended(self) -> None: ...
    def waitForFinished(self) -> None: ...


class QFutureWatcherQString(PySide6.QtCore.QObject):

    def __init__(self, _parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def future(self) -> PySide6.QtConcurrent.QFutureQString: ...
    def setFuture(self, future: PySide6.QtConcurrent.QFutureQString) -> None: ...


class QFutureWatcherVoid(PySide6.QtCore.QObject):

    def __init__(self, _parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...


class QIntList(object): ...


class QtConcurrent(Shiboken.Object):

    class FutureResult(enum.Enum):

        Ignore                   : QtConcurrent.FutureResult = ... # 0x0

    class ReduceOption(enum.Flag):

        UnorderedReduce          : QtConcurrent.ReduceOption = ... # 0x1
        OrderedReduce            : QtConcurrent.ReduceOption = ... # 0x2
        SequentialReduce         : QtConcurrent.ReduceOption = ... # 0x4

    class ThreadFunctionResult(enum.Enum):

        ThrottleThread           : QtConcurrent.ThreadFunctionResult = ... # 0x0
        ThreadFinished           : QtConcurrent.ThreadFunctionResult = ... # 0x1


# eof
