/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.compat.JreVendor;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;

public class SpnegoAuthenticator
extends AuthenticatorBase {
    private final Log log = LogFactory.getLog(SpnegoAuthenticator.class);
    private static final String AUTH_HEADER_VALUE_NEGOTIATE = "Negotiate";
    private String loginConfigName = "com.sun.security.jgss.krb5.accept";
    private boolean storeDelegatedCredential = true;
    private Pattern noKeepAliveUserAgents = null;
    private boolean applyJava8u40Fix = true;

    public String getLoginConfigName() {
        return this.loginConfigName;
    }

    public void setLoginConfigName(String string) {
        this.loginConfigName = string;
    }

    public boolean isStoreDelegatedCredential() {
        return this.storeDelegatedCredential;
    }

    public void setStoreDelegatedCredential(boolean bl) {
        this.storeDelegatedCredential = bl;
    }

    public String getNoKeepAliveUserAgents() {
        Pattern pattern = this.noKeepAliveUserAgents;
        if (pattern == null) {
            return null;
        }
        return pattern.pattern();
    }

    public void setNoKeepAliveUserAgents(String string) {
        this.noKeepAliveUserAgents = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    public boolean getApplyJava8u40Fix() {
        return this.applyJava8u40Fix;
    }

    public void setApplyJava8u40Fix(boolean bl) {
        this.applyJava8u40Fix = bl;
    }

    @Override
    protected String getAuthMethod() {
        return "SPNEGO";
    }

    @Override
    protected void initInternal() throws LifecycleException {
        Object object;
        super.initInternal();
        String string = System.getProperty("java.security.krb5.conf");
        if (string == null) {
            object = new File(this.container.getCatalinaBase(), "conf/krb5.ini");
            System.setProperty("java.security.krb5.conf", ((File)object).getAbsolutePath());
        }
        if ((object = System.getProperty("java.security.auth.login.config")) == null) {
            File file = new File(this.container.getCatalinaBase(), "conf/jaas.conf");
            System.setProperty("java.security.auth.login.config", file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doAuthenticate(Request request, HttpServletResponse httpServletResponse) throws IOException {
        boolean bl;
        Object object;
        Serializable serializable;
        if (this.checkForCachedAuthentication(request, httpServletResponse, true)) {
            return true;
        }
        MessageBytes messageBytes = request.getCoyoteRequest().getMimeHeaders().getValue("authorization");
        if (messageBytes == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("authenticator.noAuthHeader"));
            }
            httpServletResponse.setHeader("WWW-Authenticate", AUTH_HEADER_VALUE_NEGOTIATE);
            httpServletResponse.sendError(401);
            return false;
        }
        messageBytes.toBytes();
        ByteChunk byteChunk = messageBytes.getByteChunk();
        if (!byteChunk.startsWithIgnoreCase("negotiate ", 0)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("spnegoAuthenticator.authHeaderNotNego"));
            }
            httpServletResponse.setHeader("WWW-Authenticate", AUTH_HEADER_VALUE_NEGOTIATE);
            httpServletResponse.sendError(401);
            return false;
        }
        byteChunk.setStart(byteChunk.getStart() + 10);
        byte[] byArray = new byte[byteChunk.getLength()];
        System.arraycopy(byteChunk.getBuffer(), byteChunk.getStart(), byArray, 0, byteChunk.getLength());
        byte[] byArray2 = Base64.getDecoder().decode(byArray);
        if (this.getApplyJava8u40Fix()) {
            SpnegoTokenFixer.fix(byArray2);
        }
        if (byArray2.length == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("spnegoAuthenticator.authHeaderNoToken"));
            }
            httpServletResponse.setHeader("WWW-Authenticate", AUTH_HEADER_VALUE_NEGOTIATE);
            httpServletResponse.sendError(401);
            return false;
        }
        LoginContext loginContext = null;
        GSSContext gSSContext = null;
        byte[] byArray3 = null;
        Principal principal = null;
        try {
            try {
                loginContext = new LoginContext(this.getLoginConfigName());
                loginContext.login();
            }
            catch (LoginException loginException) {
                this.log.error((Object)sm.getString("spnegoAuthenticator.serviceLoginFail"), (Throwable)loginException);
                httpServletResponse.sendError(500);
                boolean bl2 = false;
                if (gSSContext != null) {
                    try {
                        gSSContext.dispose();
                    }
                    catch (GSSException gSSException) {
                        // empty catch block
                    }
                }
                if (loginContext != null) {
                    try {
                        loginContext.logout();
                    }
                    catch (LoginException loginException2) {
                        // empty catch block
                    }
                }
                return bl2;
            }
            serializable = loginContext.getSubject();
            object = GSSManager.getInstance();
            bl = JreVendor.IS_IBM_JVM ? Integer.MAX_VALUE : false;
            PrivilegedExceptionAction<GSSCredential> privilegedExceptionAction = () -> SpnegoAuthenticator.lambda$doAuthenticate$0((GSSManager)object, (int)(bl ? 1 : 0));
            gSSContext = ((GSSManager)object).createContext(Subject.doAs((Subject)serializable, privilegedExceptionAction));
            byArray3 = Subject.doAs(loginContext.getSubject(), new AcceptAction(gSSContext, byArray2));
            if (byArray3 == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("spnegoAuthenticator.ticketValidateFail"));
                }
                httpServletResponse.setHeader("WWW-Authenticate", AUTH_HEADER_VALUE_NEGOTIATE);
                httpServletResponse.sendError(401);
                boolean bl3 = false;
                return bl3;
            }
            principal = Subject.doAs((Subject)serializable, new AuthenticateAction(this.context.getRealm(), gSSContext, this.storeDelegatedCredential));
        }
        catch (GSSException gSSException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("spnegoAuthenticator.ticketValidateFail"), (Throwable)gSSException);
            }
            httpServletResponse.setHeader("WWW-Authenticate", AUTH_HEADER_VALUE_NEGOTIATE);
            httpServletResponse.sendError(401);
            boolean bl4 = false;
            return bl4;
        }
        catch (PrivilegedActionException privilegedActionException) {
            object = privilegedActionException.getCause();
            if (object instanceof GSSException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("spnegoAuthenticator.serviceLoginFail"), (Throwable)privilegedActionException);
                }
            } else {
                this.log.error((Object)sm.getString("spnegoAuthenticator.serviceLoginFail"), (Throwable)privilegedActionException);
            }
            httpServletResponse.setHeader("WWW-Authenticate", AUTH_HEADER_VALUE_NEGOTIATE);
            httpServletResponse.sendError(401);
            bl = false;
            return bl;
        }
        finally {
            if (gSSContext != null) {
                try {
                    gSSContext.dispose();
                }
                catch (GSSException gSSException) {}
            }
            if (loginContext != null) {
                try {
                    loginContext.logout();
                }
                catch (LoginException loginException) {}
            }
        }
        httpServletResponse.setHeader("WWW-Authenticate", "Negotiate " + Base64.getEncoder().encodeToString(byArray3));
        if (principal != null) {
            this.register(request, httpServletResponse, principal, "SPNEGO", principal.getName(), null);
            serializable = this.noKeepAliveUserAgents;
            if (serializable != null && (object = request.getCoyoteRequest().getMimeHeaders().getValue("user-agent")) != null && ((Pattern)serializable).matcher(object.toString()).matches()) {
                httpServletResponse.setHeader("Connection", "close");
            }
            return true;
        }
        httpServletResponse.sendError(401);
        return false;
    }

    @Override
    protected boolean isPreemptiveAuthPossible(Request request) {
        MessageBytes messageBytes = request.getCoyoteRequest().getMimeHeaders().getValue("authorization");
        return messageBytes != null && messageBytes.startsWithIgnoreCase("negotiate ", 0);
    }

    private static /* synthetic */ GSSCredential lambda$doAuthenticate$0(GSSManager gSSManager, int n) throws Exception {
        return gSSManager.createCredential(null, n, new Oid("1.3.6.1.5.5.2"), 2);
    }

    public static class SpnegoTokenFixer {
        private final byte[] token;
        private int pos = 0;

        public static void fix(byte[] byArray) {
            SpnegoTokenFixer spnegoTokenFixer = new SpnegoTokenFixer(byArray);
            spnegoTokenFixer.fix();
        }

        private SpnegoTokenFixer(byte[] byArray) {
            this.token = byArray;
        }

        private void fix() {
            Object[] objectArray;
            if (!this.tag(96)) {
                return;
            }
            if (!this.length()) {
                return;
            }
            if (!this.oid("1.3.6.1.5.5.2")) {
                return;
            }
            if (!this.tag(160)) {
                return;
            }
            if (!this.length()) {
                return;
            }
            if (!this.tag(48)) {
                return;
            }
            if (!this.length()) {
                return;
            }
            if (!this.tag(160)) {
                return;
            }
            this.lengthAsInt();
            if (!this.tag(48)) {
                return;
            }
            int n = this.lengthAsInt();
            int n2 = this.pos;
            LinkedHashMap<String, int[]> linkedHashMap = new LinkedHashMap<String, int[]>();
            while (this.pos < n2 + n) {
                objectArray = new int[2];
                objectArray[0] = this.pos;
                String string = this.oidAsString();
                objectArray[1] = this.pos - objectArray[0];
                linkedHashMap.put(string, (int[])objectArray);
            }
            objectArray = new byte[n];
            int n3 = 0;
            int[] nArray = (int[])linkedHashMap.remove("1.2.840.113554.1.2.2");
            if (nArray != null) {
                System.arraycopy(this.token, nArray[0], objectArray, n3, nArray[1]);
                n3 += nArray[1];
            }
            for (int[] nArray2 : linkedHashMap.values()) {
                System.arraycopy(this.token, nArray2[0], objectArray, n3, nArray2[1]);
                n3 += nArray2[1];
            }
            System.arraycopy(objectArray, 0, this.token, n2, n);
        }

        private boolean tag(int n) {
            return (this.token[this.pos++] & 0xFF) == n;
        }

        private boolean length() {
            int n = this.lengthAsInt();
            return this.pos + n == this.token.length;
        }

        private int lengthAsInt() {
            int n;
            if ((n = this.token[this.pos++] & 0xFF) > 127) {
                int n2 = n - 128;
                n = 0;
                for (int i = 0; i < n2; ++i) {
                    n <<= 8;
                    n += this.token[this.pos++] & 0xFF;
                }
            }
            return n;
        }

        private boolean oid(String string) {
            return string.equals(this.oidAsString());
        }

        private String oidAsString() {
            if (!this.tag(6)) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.lengthAsInt();
            int n2 = this.token[this.pos++] & 0xFF;
            int n3 = n2 % 40;
            int n4 = (n2 - n3) / 40;
            stringBuilder.append(n4);
            stringBuilder.append('.');
            stringBuilder.append(n3);
            int n5 = 0;
            boolean bl = false;
            for (int i = 1; i < n; ++i) {
                int n6;
                if ((n6 = this.token[this.pos++] & 0xFF) > 127) {
                    n6 -= 128;
                } else {
                    bl = true;
                }
                n5 <<= 7;
                n5 += n6;
                if (!bl) continue;
                stringBuilder.append('.');
                stringBuilder.append(n5);
                n5 = 0;
                bl = false;
            }
            return stringBuilder.toString();
        }
    }

    public static class AcceptAction
    implements PrivilegedExceptionAction<byte[]> {
        GSSContext gssContext;
        byte[] decoded;

        public AcceptAction(GSSContext gSSContext, byte[] byArray) {
            this.gssContext = gSSContext;
            this.decoded = byArray;
        }

        @Override
        public byte[] run() throws GSSException {
            return this.gssContext.acceptSecContext(this.decoded, 0, this.decoded.length);
        }
    }

    public static class AuthenticateAction
    implements PrivilegedAction<Principal> {
        private final Realm realm;
        private final GSSContext gssContext;
        private final boolean storeDelegatedCredential;

        public AuthenticateAction(Realm realm, GSSContext gSSContext, boolean bl) {
            this.realm = realm;
            this.gssContext = gSSContext;
            this.storeDelegatedCredential = bl;
        }

        @Override
        public Principal run() {
            return this.realm.authenticate(this.gssContext, this.storeDelegatedCredential);
        }
    }
}

