/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.catalina.security.SecurityClassLoad;
import org.apache.catalina.startup.CatalinaProperties;
import org.apache.catalina.startup.ClassLoaderFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class Bootstrap {
    private static final Log log;
    private static final Object daemonLock;
    private static volatile Bootstrap daemon;
    private static final File catalinaBaseFile;
    private static final File catalinaHomeFile;
    private static final Pattern PATH_PATTERN;
    private Object catalinaDaemon = null;
    ClassLoader commonLoader = null;
    ClassLoader catalinaLoader = null;
    ClassLoader sharedLoader = null;

    private void initClassLoaders() {
        try {
            this.commonLoader = this.createClassLoader("common", null);
            if (this.commonLoader == null) {
                this.commonLoader = this.getClass().getClassLoader();
            }
            this.catalinaLoader = this.createClassLoader("server", this.commonLoader);
            this.sharedLoader = this.createClassLoader("shared", this.commonLoader);
        }
        catch (Throwable throwable) {
            Bootstrap.handleThrowable(throwable);
            log.error((Object)"Class loader creation threw exception", throwable);
            System.exit(1);
        }
    }

    private ClassLoader createClassLoader(String string, ClassLoader classLoader) throws Exception {
        String[] stringArray;
        String string2 = CatalinaProperties.getProperty(string + ".loader");
        if (string2 == null || string2.equals("")) {
            return classLoader;
        }
        string2 = this.replace(string2);
        ArrayList<ClassLoaderFactory.Repository> arrayList = new ArrayList<ClassLoaderFactory.Repository>();
        for (String string3 : stringArray = Bootstrap.getPaths(string2)) {
            try {
                URI uRI = new URI(string3);
                URL uRL = uRI.toURL();
                arrayList.add(new ClassLoaderFactory.Repository(string3, ClassLoaderFactory.RepositoryType.URL));
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {
                if (string3.endsWith("*.jar")) {
                    string3 = string3.substring(0, string3.length() - "*.jar".length());
                    arrayList.add(new ClassLoaderFactory.Repository(string3, ClassLoaderFactory.RepositoryType.GLOB));
                    continue;
                }
                if (string3.endsWith(".jar")) {
                    arrayList.add(new ClassLoaderFactory.Repository(string3, ClassLoaderFactory.RepositoryType.JAR));
                    continue;
                }
                arrayList.add(new ClassLoaderFactory.Repository(string3, ClassLoaderFactory.RepositoryType.DIR));
            }
        }
        return ClassLoaderFactory.createClassLoader(arrayList, classLoader);
    }

    protected String replace(String string) {
        String string2 = string;
        int n = string.indexOf("${");
        if (n >= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = -1;
            while (n >= 0) {
                stringBuilder.append(string, n2 + 1, n);
                n2 = string.indexOf(125, n + 2);
                if (n2 < 0) {
                    n2 = n - 1;
                    break;
                }
                String string3 = string.substring(n + 2, n2);
                String string4 = string3.length() == 0 ? null : ("catalina.home".equals(string3) ? Bootstrap.getCatalinaHome() : ("catalina.base".equals(string3) ? Bootstrap.getCatalinaBase() : System.getProperty(string3)));
                if (string4 != null) {
                    stringBuilder.append(string4);
                } else {
                    stringBuilder.append(string, n, n2 + 1);
                }
                n = string.indexOf("${", n2 + 1);
            }
            stringBuilder.append(string, n2 + 1, string.length());
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public void init() throws Exception {
        this.initClassLoaders();
        Thread.currentThread().setContextClassLoader(this.catalinaLoader);
        SecurityClassLoad.securityClassLoad(this.catalinaLoader);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Loading startup class");
        }
        Class<?> clazz = this.catalinaLoader.loadClass("org.apache.catalina.startup.Catalina");
        Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Setting startup class properties");
        }
        String string = "setParentClassLoader";
        Class[] classArray = new Class[]{Class.forName("java.lang.ClassLoader")};
        Object[] objectArray = new Object[]{this.sharedLoader};
        Method method = obj.getClass().getMethod(string, classArray);
        method.invoke(obj, objectArray);
        this.catalinaDaemon = obj;
    }

    private void load(String[] stringArray) throws Exception {
        Object[] objectArray;
        Class[] classArray;
        String string = "load";
        if (stringArray == null || stringArray.length == 0) {
            classArray = null;
            objectArray = null;
        } else {
            classArray = new Class[]{stringArray.getClass()};
            objectArray = new Object[]{stringArray};
        }
        Method method = this.catalinaDaemon.getClass().getMethod(string, classArray);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Calling startup class " + method));
        }
        method.invoke(this.catalinaDaemon, objectArray);
    }

    private Object getServer() throws Exception {
        String string = "getServer";
        Method method = this.catalinaDaemon.getClass().getMethod(string, new Class[0]);
        return method.invoke(this.catalinaDaemon, new Object[0]);
    }

    public void init(String[] stringArray) throws Exception {
        this.init();
        this.load(stringArray);
    }

    public void start() throws Exception {
        if (this.catalinaDaemon == null) {
            this.init();
        }
        Method method = this.catalinaDaemon.getClass().getMethod("start", null);
        method.invoke(this.catalinaDaemon, (Object[])null);
    }

    public void stop() throws Exception {
        Method method = this.catalinaDaemon.getClass().getMethod("stop", null);
        method.invoke(this.catalinaDaemon, (Object[])null);
    }

    public void stopServer() throws Exception {
        Method method = this.catalinaDaemon.getClass().getMethod("stopServer", null);
        method.invoke(this.catalinaDaemon, (Object[])null);
    }

    public void stopServer(String[] stringArray) throws Exception {
        Object[] objectArray;
        Class[] classArray;
        if (stringArray == null || stringArray.length == 0) {
            classArray = null;
            objectArray = null;
        } else {
            classArray = new Class[]{stringArray.getClass()};
            objectArray = new Object[]{stringArray};
        }
        Method method = this.catalinaDaemon.getClass().getMethod("stopServer", classArray);
        method.invoke(this.catalinaDaemon, objectArray);
    }

    public void setAwait(boolean bl) throws Exception {
        Class[] classArray = new Class[]{Boolean.TYPE};
        Object[] objectArray = new Object[]{bl};
        Method method = this.catalinaDaemon.getClass().getMethod("setAwait", classArray);
        method.invoke(this.catalinaDaemon, objectArray);
    }

    public boolean getAwait() throws Exception {
        Class[] classArray = new Class[]{};
        Object[] objectArray = new Object[]{};
        Method method = this.catalinaDaemon.getClass().getMethod("getAwait", classArray);
        Boolean bl = (Boolean)method.invoke(this.catalinaDaemon, objectArray);
        return bl;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object = daemonLock;
        synchronized (object) {
            if (daemon == null) {
                Bootstrap bootstrap = new Bootstrap();
                try {
                    bootstrap.init();
                }
                catch (Throwable throwable) {
                    Bootstrap.handleThrowable(throwable);
                    log.error((Object)"Init exception", throwable);
                    return;
                }
                daemon = bootstrap;
            } else {
                Thread.currentThread().setContextClassLoader(Bootstrap.daemon.catalinaLoader);
            }
        }
        try {
            object = "start";
            if (stringArray.length > 0) {
                object = stringArray[stringArray.length - 1];
            }
            if (((String)object).equals("startd")) {
                stringArray[stringArray.length - 1] = "start";
                daemon.load(stringArray);
                daemon.start();
            } else if (((String)object).equals("stopd")) {
                stringArray[stringArray.length - 1] = "stop";
                daemon.stop();
            } else if (((String)object).equals("start")) {
                daemon.setAwait(true);
                daemon.load(stringArray);
                daemon.start();
                if (null == daemon.getServer()) {
                    System.exit(1);
                }
            } else if (((String)object).equals("stop")) {
                daemon.stopServer(stringArray);
            } else if (((String)object).equals("configtest")) {
                daemon.load(stringArray);
                if (null == daemon.getServer()) {
                    System.exit(1);
                }
                System.exit(0);
            } else {
                log.warn((Object)("Bootstrap: command \"" + (String)object + "\" does not exist."));
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
                throwable2 = throwable.getCause();
            }
            Bootstrap.handleThrowable(throwable2);
            log.error((Object)"Error running command", throwable2);
            System.exit(1);
        }
    }

    public static String getCatalinaHome() {
        return catalinaHomeFile.getPath();
    }

    public static String getCatalinaBase() {
        return catalinaBaseFile.getPath();
    }

    public static File getCatalinaHomeFile() {
        return catalinaHomeFile;
    }

    public static File getCatalinaBaseFile() {
        return catalinaBaseFile;
    }

    static void handleThrowable(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (throwable instanceof StackOverflowError) {
            return;
        }
        if (throwable instanceof VirtualMachineError) {
            throw (VirtualMachineError)throwable;
        }
    }

    static Throwable unwrapInvocationTargetException(Throwable throwable) {
        if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            return throwable.getCause();
        }
        return throwable;
    }

    protected static String[] getPaths(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = PATH_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = string.substring(matcher.start(), matcher.end());
            if ((string2 = string2.trim()).length() == 0) continue;
            char c = string2.charAt(0);
            char c2 = string2.charAt(string2.length() - 1);
            if (c == '\"' && c2 == '\"' && string2.length() > 1) {
                string2 = string2.substring(1, string2.length() - 1);
                if ((string2 = string2.trim()).length() == 0) {
                    continue;
                }
            } else if (string2.contains("\"")) {
                throw new IllegalArgumentException("The double quote [\"] character can only be used to quote paths. It must not appear in a path. This loader path is not valid: [" + string + "]");
            }
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[0]);
    }

    static {
        File file;
        Object object;
        log = LogFactory.getLog(Bootstrap.class);
        daemonLock = new Object();
        daemon = null;
        PATH_PATTERN = Pattern.compile("(\"[^\"]*\")|(([^,])*)");
        String string = System.getProperty("user.dir");
        String string2 = System.getProperty("catalina.home");
        File file2 = null;
        if (string2 != null) {
            object = new File(string2);
            try {
                file2 = ((File)object).getCanonicalFile();
            }
            catch (IOException iOException) {
                file2 = ((File)object).getAbsoluteFile();
            }
        }
        if (file2 == null && ((File)(object = new File(string, "bootstrap.jar"))).exists()) {
            file = new File(string, "..");
            try {
                file2 = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                file2 = file.getAbsoluteFile();
            }
        }
        if (file2 == null) {
            object = new File(string);
            try {
                file2 = ((File)object).getCanonicalFile();
            }
            catch (IOException iOException) {
                file2 = ((File)object).getAbsoluteFile();
            }
        }
        catalinaHomeFile = file2;
        System.setProperty("catalina.home", catalinaHomeFile.getPath());
        object = System.getProperty("catalina.base");
        if (object == null) {
            catalinaBaseFile = catalinaHomeFile;
        } else {
            file = new File((String)object);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                file = file.getAbsoluteFile();
            }
            catalinaBaseFile = file;
        }
        System.setProperty("catalina.base", catalinaBaseFile.getPath());
    }
}

