/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.forms.util.LayoutStyle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.SeparatorProperty;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.mindmapmode.MUIFactory;
import org.freeplane.features.styles.mindmapmode.SelectedNodeChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.BorderColorAndColorMatchesEdgeControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.BorderDashAndDashMatchesEdgeControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.BorderWidthAndBorderWidthMatchesEdgeControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ChildHorizontalGapControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ChildNodesLayoutControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ChildVerticalGapControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.CloudColorShapeControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.CssControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.DetailContentTypeControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.EdgeColorControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.EdgeDashControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.EdgeStyleControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.EdgeWidthControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.FontBoldControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.FontItalicControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.FontNameControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.FontSizeControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.FontStrikeThroughControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.FormatControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.GroupSeparator;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.IconSizeControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.MaxNodeWidthControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.MinNodeWidthControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.NextLineControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.NodeBackgroundColorControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.NodeColorControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.NodeFontHyperLinkControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.NodeHorizontalTextAlignmentControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.NodeNumberingControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.NodeShapeControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.NodeTextWritingDirectionControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.NoteContentTypeControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StyleControlGroup;

public class StyleEditorPanel
extends JPanel {
    private static final String STYLE_EDITOR_PANEL_SIZE_PROPERTY = "styleEditorPanelSize";
    private static final long serialVersionUID = 1L;
    private boolean internalChange;
    ControlGroup[] controlGroups;
    private PanelEnabler panelEnabler;
    private final StyleEditorPanelSize panelConfiguration;
    private final ModeController modeController;

    public StyleEditorPanel(ModeController modeController, MUIFactory uiFactory, boolean addStyleBox) throws HeadlessException {
        this.modeController = modeController;
        this.setLayout(new BorderLayout());
        ResourceController resourceController = ResourceController.getResourceController();
        if ("MIDDLE".equals(resourceController.getProperty(STYLE_EDITOR_PANEL_SIZE_PROPERTY, null))) {
            resourceController.setProperty(STYLE_EDITOR_PANEL_SIZE_PROPERTY, StyleEditorPanelSize.MEDIUM.name());
        }
        this.panelConfiguration = (StyleEditorPanelSize)resourceController.getEnumProperty(STYLE_EDITOR_PANEL_SIZE_PROPERTY, (Enum)StyleEditorPanelSize.MEDIUM);
        this.controlGroups = this.createControlGroups(modeController, uiFactory, addStyleBox);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (StyleEditorPanel.this.isDisplayable()) {
                    StyleEditorPanel.this.removeHierarchyListener(this);
                    StyleEditorPanel.this.init();
                }
            }
        });
    }

    private ControlGroup[] createControlGroups(ModeController modeController, MUIFactory uiFactory, boolean addStyleBox) {
        return new ControlGroup[]{new StyleControlGroup(addStyleBox, uiFactory, modeController, this.panelConfiguration.fontSize), new GroupSeparator("OptionPanel.separator.NodeColors"), new NodeColorControlGroup(), new NodeBackgroundColorControlGroup(), new GroupSeparator("OptionPanel.separator.NodeFont"), new FontNameControlGroup(), new FontSizeControlGroup(), new FontBoldControlGroup(), new FontStrikeThroughControlGroup(), new FontItalicControlGroup(), new NodeHorizontalTextAlignmentControlGroup(), new NodeTextWritingDirectionControlGroup(), new NodeFontHyperLinkControlGroup(), new NextLineControlGroup(), new CssControlGroup(modeController), new GroupSeparator("OptionPanel.separator.IconControls"), new IconSizeControlGroup(), new GroupSeparator("OptionPanel.separator.NodeText"), new FormatControlGroup(), new NodeNumberingControlGroup(), new GroupSeparator("OptionPanel.separator.ContentTypes"), new DetailContentTypeControlGroup(), new NoteContentTypeControlGroup(), new GroupSeparator("OptionPanel.separator.NodeShape"), new NodeShapeControlGroup(), new MinNodeWidthControlGroup(), new MaxNodeWidthControlGroup(), new GroupSeparator("OptionPanel.separator.NodeLayout"), new ChildNodesLayoutControlGroup(), new ChildHorizontalGapControlGroup(), new ChildVerticalGapControlGroup(), new GroupSeparator("OptionPanel.separator.NodeBorder"), new BorderWidthAndBorderWidthMatchesEdgeControlGroup(), new BorderDashAndDashMatchesEdgeControlGroup(), new BorderColorAndColorMatchesEdgeControlGroup(), new NextLineControlGroup(), new GroupSeparator("OptionPanel.separator.EdgeControls"), new EdgeWidthControlGroup(), new EdgeDashControlGroup(), new EdgeStyleControlGroup(), new EdgeColorControlGroup(), new NextLineControlGroup(), new GroupSeparator("OptionPanel.separator.CloudControls"), new CloudColorShapeControlGroup()};
    }

    private void init() {
        String colSpec = "right:max(20dlu;p), 4dlu, 40dlu:grow, 4dlu, max(10dlu;p)";
        FormLayout rightLayout = new FormLayout("right:max(20dlu;p), 4dlu, 40dlu:grow, 4dlu, max(10dlu;p)", "");
        DefaultFormBuilder formBuilder = new DefaultFormBuilder(rightLayout);
        formBuilder.border((Border)Paddings.DLU2);
        formBuilder.lineGapSize(LayoutStyle.getCurrent().getNarrowLinePad());
        formBuilder.paragraphGapSize(this.panelConfiguration.paragraphGapSize);
        new SeparatorProperty("OptionPanel.separator.NodeStyle").appendToForm(formBuilder);
        for (ControlGroup controlGroup : this.controlGroups) {
            controlGroup.addControlGroup(formBuilder);
        }
        formBuilder.getLayout().setHonorsVisibility(false);
        this.add((Component)formBuilder.getPanel(), "Center");
        this.addListeners();
        this.setFont(this, this.panelConfiguration.fontSize);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        return new Dimension((int)(100.0f * UITools.FONT_SCALE_FACTOR), preferredSize.height);
    }

    private void setFont(Container c, float size) {
        c.setFont(c.getFont().deriveFont(size));
        for (int i = 0; i < c.getComponentCount(); ++i) {
            this.setFont((Container)c.getComponent(i), size);
        }
    }

    private void setStyle(NodeModel node) {
        if (this.internalChange) {
            return;
        }
        this.internalChange = true;
        try {
            for (int i = 0; i < this.controlGroups.length; ++i) {
                this.controlGroups[i].setStyle(node, this.panelEnabler != null && this.panelEnabler.canEdit);
            }
        }
        finally {
            this.internalChange = false;
        }
    }

    private void updatePanel(NodeModel selected) {
        if (Controller.getCurrentModeController() != this.modeController) {
            return;
        }
        if (selected == null) {
            this.setComponentsEnabled(false);
        } else {
            if (Controller.getCurrentModeController().canEdit(selected.getMap())) {
                this.setComponentsEnabled(true);
            }
            this.setStyle(selected);
        }
    }

    private void setComponentsEnabled(boolean enabled) {
        Container panel = (Container)this.getComponent(0);
        if (panel.isEnabled() != enabled) {
            this.setComponentsEnabled(panel, enabled);
        }
    }

    private void setComponentsEnabled(Container container, boolean enabled) {
        container.setEnabled(enabled);
        if (container instanceof Box || container instanceof JPanel) {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                if (!(container instanceof Container)) continue;
                this.setComponentsEnabled((Container)component, enabled);
            }
        }
    }

    private void addListeners() {
        SelectedNodeChangeListener.onSelectedNodeChange(this::updatePanel);
        Controller controller = this.modeController.getController();
        this.panelEnabler = new PanelEnabler(controller, this.modeController);
        controller.getMapViewManager().addMapSelectionListener((IMapSelectionListener)this.panelEnabler);
        ResourceController.getResourceController().addPropertyChangeListener((IFreeplanePropertyListener)this.panelEnabler);
    }

    public static enum StyleEditorPanelSize {
        SMALL(0.6f),
        MEDIUM(0.8f),
        BIG(1.0f);

        final float fontSize;
        final ConstantSize paragraphGapSize;

        private StyleEditorPanelSize(float scalingFactor) {
            this.fontSize = UITools.getUIFontSize((float)scalingFactor);
            this.paragraphGapSize = Sizes.pixel((int)((int)(2.5 * (double)scalingFactor * (double)this.fontSize)));
        }
    }

    private final class PanelEnabler
    implements IFreeplanePropertyListener,
    IMapSelectionListener {
        private final Controller controller;
        private final ModeController modeController;
        boolean canEdit = true;

        private PanelEnabler(Controller controller, ModeController modeController) {
            this.controller = controller;
            this.modeController = modeController;
        }

        public void propertyChanged(String propertyName, String newValue, String oldValue) {
            if (propertyName.equals("view_mode")) {
                this.updatePanel();
            }
        }

        public void afterMapChange(MapModel oldMap, MapModel newMap) {
            if (this.modeController.equals(Controller.getCurrentModeController())) {
                this.updatePanel();
            }
        }

        private void updatePanel() {
            boolean canEditNow = this.modeController.canEdit(this.controller.getMap());
            if (this.canEdit != canEditNow) {
                this.canEdit = canEditNow;
                StyleEditorPanel.this.setComponentsEnabled(this.canEdit);
            }
        }
    }
}

