"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.acFrequency = exports.soil_moisture = exports.fanMode = exports.powerFactor = exports.rmsVoltage = exports.rmsCurrent = exports.apparentPower = exports.reactivePower = exports.activePower = exports.presentValue = exports.thermostatAcLouverPosition = exports.thermostatTemperatureSetpointHoldDuration = exports.thermostatTemperatureSetpointHold = exports.thermostatOccupancy = exports.thermostatRunningMode = exports.thermostatRunningState = exports.thermostatPIHeatingDemand = exports.thermostatUnoccupiedCoolingSetpoint = exports.thermostatOccupiedCoolingSetpoint = exports.thermostatUnoccupiedHeatingSetpoint = exports.thermostatOccupiedHeatingSetpoint = exports.thermostatTemperatureCalibration = exports.thermostatTemperature = exports.thermostatKeypadLockMode = exports.humidity = exports.thermostatSystemMode = exports.currentSummReceived = exports.currentSummDelivered = exports.instantaneousDemand = exports.illuminance = exports.pressureExtended = exports.pressure = exports.deviceTemperature = exports.co2 = exports.temperature = exports.occupancy = exports.colorTemperature = exports.brightness = exports.doorState = exports.lockState = exports.onTime = exports.onOff = exports.batteryAlarmState = exports.batteryVoltage = exports.batteryPercentageRemaining = exports.currentPositionTiltPercentage = exports.currentPositionLiftPercentage = void 0;
exports.payload = payload;
exports.readEletricalMeasurementMultiplierDivisors = readEletricalMeasurementMultiplierDivisors;
exports.readMeteringMultiplierDivisor = readMeteringMultiplierDivisor;
exports.bind = bind;
/* eslint camelcase: 0 */
const constants_1 = require("./constants");
function payload(attribute, min, max, change, overrides) {
    const payload = {
        attribute: attribute,
        minimumReportInterval: min,
        maximumReportInterval: max,
        reportableChange: change,
    };
    if (overrides) {
        if (overrides.hasOwnProperty('min'))
            payload.minimumReportInterval = overrides.min;
        if (overrides.hasOwnProperty('max'))
            payload.maximumReportInterval = overrides.max;
        // @ts-expect-error
        if (overrides.hasOwnProperty('change'))
            payload.reportableChange = overrides.change;
    }
    return [payload];
}
// Fix the problem that commit #3839 introduced.
// You can set readFrequencyAttrs = true if the device support acFrequencyDivisor and acFrequencyMultiplier
// See Develco.js SPLZB-132 for example
async function readEletricalMeasurementMultiplierDivisors(endpoint, readFrequencyAttrs = false) {
    // Split into three chunks, some devices fail to respond when reading too much attributes at once.
    await endpoint.read('haElectricalMeasurement', ['acVoltageMultiplier', 'acVoltageDivisor', 'acCurrentMultiplier']);
    await endpoint.read('haElectricalMeasurement', ['acCurrentDivisor', 'acPowerMultiplier', 'acPowerDivisor']);
    // Only read frequency multiplier/divisor when enabled as not all devices support this.
    if (readFrequencyAttrs) {
        await endpoint.read('haElectricalMeasurement', ['acFrequencyDivisor', 'acFrequencyMultiplier']);
    }
}
async function readMeteringMultiplierDivisor(endpoint) {
    await endpoint.read('seMetering', ['multiplier', 'divisor']);
}
async function bind(endpoint, target, clusters) {
    for (const cluster of clusters) {
        await endpoint.bind(cluster, target);
    }
}
const currentPositionLiftPercentage = async (endpoint, overrides) => {
    const p = payload('currentPositionLiftPercentage', 1, constants_1.repInterval.MAX, 1, overrides);
    await endpoint.configureReporting('closuresWindowCovering', p);
};
exports.currentPositionLiftPercentage = currentPositionLiftPercentage;
const currentPositionTiltPercentage = async (endpoint, overrides) => {
    const p = payload('currentPositionTiltPercentage', 1, constants_1.repInterval.MAX, 1, overrides);
    await endpoint.configureReporting('closuresWindowCovering', p);
};
exports.currentPositionTiltPercentage = currentPositionTiltPercentage;
const batteryPercentageRemaining = async (endpoint, overrides) => {
    const p = payload('batteryPercentageRemaining', constants_1.repInterval.HOUR, constants_1.repInterval.MAX, 0, overrides);
    await endpoint.configureReporting('genPowerCfg', p);
    await endpoint.read('genPowerCfg', ['batteryPercentageRemaining']);
};
exports.batteryPercentageRemaining = batteryPercentageRemaining;
const batteryVoltage = async (endpoint, overrides) => {
    const p = payload('batteryVoltage', constants_1.repInterval.HOUR, constants_1.repInterval.MAX, 0, overrides);
    await endpoint.configureReporting('genPowerCfg', p);
    await endpoint.read('genPowerCfg', ['batteryVoltage']);
};
exports.batteryVoltage = batteryVoltage;
const batteryAlarmState = async (endpoint, overrides) => {
    const p = payload('batteryAlarmState', constants_1.repInterval.HOUR, constants_1.repInterval.MAX, 0, overrides);
    await endpoint.configureReporting('genPowerCfg', p);
    await endpoint.read('genPowerCfg', ['batteryAlarmState']);
};
exports.batteryAlarmState = batteryAlarmState;
const onOff = async (endpoint, overrides) => {
    const p = payload('onOff', 0, constants_1.repInterval.HOUR, 0, overrides);
    await endpoint.configureReporting('genOnOff', p);
};
exports.onOff = onOff;
const onTime = async (endpoint, overrides) => {
    const p = payload('onTime', 0, constants_1.repInterval.HOUR, 40, overrides);
    await endpoint.configureReporting('genOnOff', p);
};
exports.onTime = onTime;
const lockState = async (endpoint, overrides) => {
    const p = payload('lockState', 0, constants_1.repInterval.HOUR, 0, overrides);
    await endpoint.configureReporting('closuresDoorLock', p);
};
exports.lockState = lockState;
const doorState = async (endpoint, overrides) => {
    const p = payload('doorState', 0, constants_1.repInterval.HOUR, 0, overrides);
    await endpoint.configureReporting('closuresDoorLock', p);
};
exports.doorState = doorState;
const brightness = async (endpoint, overrides) => {
    const p = payload('currentLevel', 1, constants_1.repInterval.HOUR, 1, overrides);
    await endpoint.configureReporting('genLevelCtrl', p);
};
exports.brightness = brightness;
const colorTemperature = async (endpoint, overrides) => {
    const p = payload('colorTemperature', 0, constants_1.repInterval.HOUR, 1, overrides);
    await endpoint.configureReporting('lightingColorCtrl', p);
};
exports.colorTemperature = colorTemperature;
const occupancy = async (endpoint, overrides) => {
    const p = payload('occupancy', 0, constants_1.repInterval.HOUR, 0, overrides);
    await endpoint.configureReporting('msOccupancySensing', p);
};
exports.occupancy = occupancy;
const temperature = async (endpoint, overrides) => {
    const p = payload('measuredValue', 10, constants_1.repInterval.HOUR, 100, overrides);
    await endpoint.configureReporting('msTemperatureMeasurement', p);
};
exports.temperature = temperature;
const co2 = async (endpoint, overrides) => {
    const p = payload('measuredValue', 10, constants_1.repInterval.HOUR, 1, overrides);
    await endpoint.configureReporting('msCO2', p);
};
exports.co2 = co2;
const deviceTemperature = async (endpoint, overrides) => {
    const p = payload('currentTemperature', 300, constants_1.repInterval.HOUR, 1, overrides);
    await endpoint.configureReporting('genDeviceTempCfg', p);
};
exports.deviceTemperature = deviceTemperature;
const pressure = async (endpoint, overrides) => {
    const p = payload('measuredValue', 10, constants_1.repInterval.HOUR, 5, overrides);
    await endpoint.configureReporting('msPressureMeasurement', p);
};
exports.pressure = pressure;
const pressureExtended = async (endpoint, overrides) => {
    const p = payload('scaledValue', 10, constants_1.repInterval.HOUR, 5, overrides);
    await endpoint.configureReporting('msPressureMeasurement', p);
};
exports.pressureExtended = pressureExtended;
const illuminance = async (endpoint, overrides) => {
    const p = payload('measuredValue', 10, constants_1.repInterval.HOUR, 5, overrides);
    await endpoint.configureReporting('msIlluminanceMeasurement', p);
};
exports.illuminance = illuminance;
const instantaneousDemand = async (endpoint, overrides) => {
    const p = payload('instantaneousDemand', 5, constants_1.repInterval.HOUR, 1, overrides);
    await endpoint.configureReporting('seMetering', p);
};
exports.instantaneousDemand = instantaneousDemand;
const currentSummDelivered = async (endpoint, overrides) => {
    // @ts-expect-error
    const p = payload('currentSummDelivered', 5, constants_1.repInterval.HOUR, [1, 1], overrides);
    await endpoint.configureReporting('seMetering', p);
};
exports.currentSummDelivered = currentSummDelivered;
const currentSummReceived = async (endpoint, overrides) => {
    // @ts-expect-error
    const p = payload('currentSummReceived', 5, constants_1.repInterval.HOUR, [1, 1], overrides);
    await endpoint.configureReporting('seMetering', p);
};
exports.currentSummReceived = currentSummReceived;
const thermostatSystemMode = async (endpoint, overrides) => {
    const p = payload('systemMode', 10, constants_1.repInterval.HOUR, null, overrides);
    await endpoint.configureReporting('hvacThermostat', p);
};
exports.thermostatSystemMode = thermostatSystemMode;
const humidity = async (endpoint, overrides) => {
    const p = payload('measuredValue', 10, constants_1.repInterval.HOUR, 100, overrides);
    await endpoint.configureReporting('msRelativeHumidity', p);
};
exports.humidity = humidity;
const thermostatKeypadLockMode = async (endpoint, overrides) => {
    const p = payload('keypadLockout', 10, constants_1.repInterval.HOUR, null, overrides);
    await endpoint.configureReporting('hvacUserInterfaceCfg', p);
};
exports.thermostatKeypadLockMode = thermostatKeypadLockMode;
const thermostatTemperature = async (endpoint, overrides) => {
    const p = payload('localTemp', 0, constants_1.repInterval.HOUR, 10, overrides);
    await endpoint.configureReporting('hvacThermostat', p);
};
exports.thermostatTemperature = thermostatTemperature;
const thermostatTemperatureCalibration = async (endpoint, overrides) => {
    const p = payload('localTemperatureCalibration', 0, constants_1.repInterval.HOUR, 0, overrides);
    await endpoint.configureReporting('hvacThermostat', p);
};
exports.thermostatTemperatureCalibration = thermostatTemperatureCalibration;
const thermostatOccupiedHeatingSetpoint = async (endpoint, overrides) => {
    const p = payload('occupiedHeatingSetpoint', 0, constants_1.repInterval.HOUR, 10, overrides);
    await endpoint.configureReporting('hvacThermostat', p);
};
exports.thermostatOccupiedHeatingSetpoint = thermostatOccupiedHeatingSetpoint;
const thermostatUnoccupiedHeatingSetpoint = async (endpoint, overrides) => {
    const p = payload('unoccupiedHeatingSetpoint', 0, constants_1.repInterval.HOUR, 10, overrides);
    await endpoint.configureReporting('hvacThermostat', p);
};
exports.thermostatUnoccupiedHeatingSetpoint = thermostatUnoccupiedHeatingSetpoint;
const thermostatOccupiedCoolingSetpoint = async (endpoint, overrides) => {
    const p = payload('occupiedCoolingSetpoint', 0, constants_1.repInterval.HOUR, 10, overrides);
    await endpoint.configureReporting('hvacThermostat', p);
};
exports.thermostatOccupiedCoolingSetpoint = thermostatOccupiedCoolingSetpoint;
const thermostatUnoccupiedCoolingSetpoint = async (endpoint, overrides) => {
    const p = payload('unoccupiedCoolingSetpoint', 0, constants_1.repInterval.HOUR, 10, overrides);
    await endpoint.configureReporting('hvacThermostat', p);
};
exports.thermostatUnoccupiedCoolingSetpoint = thermostatUnoccupiedCoolingSetpoint;
const thermostatPIHeatingDemand = async (endpoint, overrides) => {
    const p = payload('pIHeatingDemand', 0, constants_1.repInterval.HOUR, 10, overrides);
    await endpoint.configureReporting('hvacThermostat', p);
};
exports.thermostatPIHeatingDemand = thermostatPIHeatingDemand;
const thermostatRunningState = async (endpoint, overrides) => {
    const p = payload('runningState', 0, constants_1.repInterval.HOUR, 0, overrides);
    await endpoint.configureReporting('hvacThermostat', p);
};
exports.thermostatRunningState = thermostatRunningState;
const thermostatRunningMode = async (endpoint, overrides) => {
    const p = payload('runningMode', 10, constants_1.repInterval.HOUR, null, overrides);
    await endpoint.configureReporting('hvacThermostat', p);
};
exports.thermostatRunningMode = thermostatRunningMode;
const thermostatOccupancy = async (endpoint, overrides) => {
    const p = payload('occupancy', 0, constants_1.repInterval.HOUR, 0, overrides);
    await endpoint.configureReporting('hvacThermostat', p);
};
exports.thermostatOccupancy = thermostatOccupancy;
const thermostatTemperatureSetpointHold = async (endpoint, overrides) => {
    const p = payload('tempSetpointHold', 0, constants_1.repInterval.HOUR, 0, overrides);
    await endpoint.configureReporting('hvacThermostat', p);
};
exports.thermostatTemperatureSetpointHold = thermostatTemperatureSetpointHold;
const thermostatTemperatureSetpointHoldDuration = async (endpoint, overrides) => {
    const p = payload('tempSetpointHoldDuration', 0, constants_1.repInterval.HOUR, 10, overrides);
    await endpoint.configureReporting('hvacThermostat', p);
};
exports.thermostatTemperatureSetpointHoldDuration = thermostatTemperatureSetpointHoldDuration;
const thermostatAcLouverPosition = async (endpoint, overrides) => {
    const p = payload('acLouverPosition', 0, constants_1.repInterval.HOUR, null, overrides);
    await endpoint.configureReporting('hvacThermostat', p);
};
exports.thermostatAcLouverPosition = thermostatAcLouverPosition;
const presentValue = async (endpoint, overrides) => {
    const p = payload('presentValue', 10, constants_1.repInterval.MINUTE, 1, overrides);
    await endpoint.configureReporting('genBinaryInput', p);
};
exports.presentValue = presentValue;
const activePower = async (endpoint, overrides) => {
    const p = payload('activePower', 5, constants_1.repInterval.HOUR, 1, overrides);
    await endpoint.configureReporting('haElectricalMeasurement', p);
};
exports.activePower = activePower;
const reactivePower = async (endpoint, overrides) => {
    const p = payload('reactivePower', 5, constants_1.repInterval.HOUR, 1, overrides);
    await endpoint.configureReporting('haElectricalMeasurement', p);
};
exports.reactivePower = reactivePower;
const apparentPower = async (endpoint, overrides) => {
    const p = payload('apparentPower', 5, constants_1.repInterval.HOUR, 1, overrides);
    await endpoint.configureReporting('haElectricalMeasurement', p);
};
exports.apparentPower = apparentPower;
const rmsCurrent = async (endpoint, overrides) => {
    const p = payload('rmsCurrent', 5, constants_1.repInterval.HOUR, 1, overrides);
    await endpoint.configureReporting('haElectricalMeasurement', p);
};
exports.rmsCurrent = rmsCurrent;
const rmsVoltage = async (endpoint, overrides) => {
    const p = payload('rmsVoltage', 5, constants_1.repInterval.HOUR, 1, overrides);
    await endpoint.configureReporting('haElectricalMeasurement', p);
};
exports.rmsVoltage = rmsVoltage;
const powerFactor = async (endpoint, overrides) => {
    const p = payload('powerFactor', 0, constants_1.repInterval.MAX, 1, overrides);
    await endpoint.configureReporting('haElectricalMeasurement', p);
};
exports.powerFactor = powerFactor;
const fanMode = async (endpoint, overrides) => {
    const p = payload('fanMode', 0, constants_1.repInterval.HOUR, 0, overrides);
    await endpoint.configureReporting('hvacFanCtrl', p);
};
exports.fanMode = fanMode;
const soil_moisture = async (endpoint, overrides) => {
    const p = payload('measuredValue', 10, constants_1.repInterval.HOUR, 100, overrides);
    await endpoint.configureReporting('msSoilMoisture', p);
};
exports.soil_moisture = soil_moisture;
const acFrequency = async (endpoint, overrides) => {
    const p = payload('acFrequency', 5, constants_1.repInterval.MINUTES_5, 10, overrides);
    await endpoint.configureReporting('haElectricalMeasurement', p);
};
exports.acFrequency = acFrequency;
exports.payload = payload;
exports.bind = bind;
exports.readEletricalMeasurementMultiplierDivisors = readEletricalMeasurementMultiplierDivisors;
exports.readMeteringMultiplierDivisor = readMeteringMultiplierDivisor;
exports.currentPositionLiftPercentage = exports.currentPositionLiftPercentage;
exports.currentPositionTiltPercentage = exports.currentPositionTiltPercentage;
exports.batteryPercentageRemaining = exports.batteryPercentageRemaining;
exports.batteryVoltage = exports.batteryVoltage;
exports.batteryAlarmState = exports.batteryAlarmState;
exports.onOff = exports.onOff;
exports.onTime = exports.onTime;
exports.lockState = exports.lockState;
exports.doorState = exports.doorState;
exports.brightness = exports.brightness;
exports.colorTemperature = exports.colorTemperature;
exports.occupancy = exports.occupancy;
exports.temperature = exports.temperature;
exports.co2 = exports.co2;
exports.deviceTemperature = exports.deviceTemperature;
exports.pressure = exports.pressure;
exports.pressureExtended = exports.pressureExtended;
exports.illuminance = exports.illuminance;
exports.instantaneousDemand = exports.instantaneousDemand;
exports.currentSummDelivered = exports.currentSummDelivered;
exports.currentSummReceived = exports.currentSummReceived;
exports.thermostatSystemMode = exports.thermostatSystemMode;
exports.humidity = exports.humidity;
exports.thermostatKeypadLockMode = exports.thermostatKeypadLockMode;
exports.thermostatTemperature = exports.thermostatTemperature;
exports.thermostatTemperatureCalibration = exports.thermostatTemperatureCalibration;
exports.thermostatOccupiedHeatingSetpoint = exports.thermostatOccupiedHeatingSetpoint;
exports.thermostatUnoccupiedHeatingSetpoint = exports.thermostatUnoccupiedHeatingSetpoint;
exports.thermostatOccupiedCoolingSetpoint = exports.thermostatOccupiedCoolingSetpoint;
exports.thermostatUnoccupiedCoolingSetpoint = exports.thermostatUnoccupiedCoolingSetpoint;
exports.thermostatPIHeatingDemand = exports.thermostatPIHeatingDemand;
exports.thermostatRunningState = exports.thermostatRunningState;
exports.thermostatRunningMode = exports.thermostatRunningMode;
exports.thermostatOccupancy = exports.thermostatOccupancy;
exports.thermostatTemperatureSetpointHold = exports.thermostatTemperatureSetpointHold;
exports.thermostatTemperatureSetpointHoldDuration = exports.thermostatTemperatureSetpointHoldDuration;
exports.thermostatAcLouverPosition = exports.thermostatAcLouverPosition;
exports.presentValue = exports.presentValue;
exports.activePower = exports.activePower;
exports.reactivePower = exports.reactivePower;
exports.apparentPower = exports.apparentPower;
exports.rmsCurrent = exports.rmsCurrent;
exports.rmsVoltage = exports.rmsVoltage;
exports.powerFactor = exports.powerFactor;
exports.fanMode = exports.fanMode;
exports.soil_moisture = exports.soil_moisture;
exports.acFrequency = exports.acFrequency;
//# sourceMappingURL=reporting.js.map