"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isBroadcastAddress = exports.uint32MaskToChannels = exports.channelsToUInt32Mask = void 0;
const consts_1 = require("./consts");
const enums_1 = require("./enums");
/**
 * Convert a channels array to a uint32 channel mask.
 * @param channels
 * @returns
 */
const channelsToUInt32Mask = (channels) => {
    return channels.reduce((a, c) => a + (1 << c), 0);
};
exports.channelsToUInt32Mask = channelsToUInt32Mask;
/**
 * Convert a uint32 channel mask to a channels array.
 * @param mask
 * @returns
 */
const uint32MaskToChannels = (mask) => {
    return consts_1.ALL_802_15_4_CHANNELS.map((c) => ((2 ** c) & mask ? c : null)).filter((x) => x);
};
exports.uint32MaskToChannels = uint32MaskToChannels;
const isBroadcastAddress = (address) => {
    return (address === enums_1.BroadcastAddress.DEFAULT ||
        address === enums_1.BroadcastAddress.RX_ON_WHEN_IDLE ||
        address === enums_1.BroadcastAddress.SLEEPY ||
        address === enums_1.BroadcastAddress.LOW_POWER_ROUTERS);
};
exports.isBroadcastAddress = isBroadcastAddress;
//# sourceMappingURL=utils.js.map