complete -c oct -n "__fish_use_subcommand" -l output-format -d 'Produce output in the chosen format' -r -f -a "{json\t'',text\t'',yaml\t''}"
complete -c oct -n "__fish_use_subcommand" -l output-version -d 'Pick output version to use, for non-textual formats' -r
complete -c oct -n "__fish_use_subcommand" -s h -l help -d 'Print help'
complete -c oct -n "__fish_use_subcommand" -s V -l version -d 'Print version'
complete -c oct -n "__fish_use_subcommand" -f -a "list" -d 'Enumerate available OpenPGP cards'
complete -c oct -n "__fish_use_subcommand" -f -a "status" -d 'Show information about the data on a card'
complete -c oct -n "__fish_use_subcommand" -f -a "info" -d 'Show technical details about a card'
complete -c oct -n "__fish_use_subcommand" -f -a "ssh" -d 'Show a card\'s authentication key as an SSH public key'
complete -c oct -n "__fish_use_subcommand" -f -a "pubkey" -d 'Export the key data on a card as an OpenPGP public key'
complete -c oct -n "__fish_use_subcommand" -f -a "admin" -d 'Administer data on a card (including keys and metadata)'
complete -c oct -n "__fish_use_subcommand" -f -a "pin" -d 'PIN management (change PINs, reset blocked PINs)'
complete -c oct -n "__fish_use_subcommand" -f -a "decrypt" -d 'Decrypt data using a card'
complete -c oct -n "__fish_use_subcommand" -f -a "sign" -d 'Sign data using a card'
complete -c oct -n "__fish_use_subcommand" -f -a "attestation" -d 'Attestation management (Yubico only)'
complete -c oct -n "__fish_use_subcommand" -f -a "system" -d 'Initialization and similar functionality'
complete -c oct -n "__fish_use_subcommand" -f -a "output-versions" -d 'Show supported output format versions'
complete -c oct -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from list" -s i -l idents-only -d 'Only show card idents'
complete -c oct -n "__fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from status" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from status" -s v -l verbose -d 'Use verbose output'
complete -c oct -n "__fish_seen_subcommand_from status" -s K -l public-key-material -d 'Print public key material for each key slot'
complete -c oct -n "__fish_seen_subcommand_from status" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from info" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from info" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from ssh" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from ssh" -l key-only -d 'Only print the ssh public key'
complete -c oct -n "__fish_seen_subcommand_from ssh" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from pubkey" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from pubkey" -s p -l user-pin -d 'Optionally, get User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pubkey" -s u -l userid -d 'User ID to add to the exported certificate representation' -r
complete -c oct -n "__fish_seen_subcommand_from pubkey" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -s P -l admin-pin -d 'Optionally, get Admin PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "name" -d 'Set cardholder name'
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "url" -d 'Set certificate URL'
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "signing-pin-validity" -d 'Configure if user PIN presentation is valid for just one signing operation, or for unlimited signing operations'
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "import" -d 'Import a Key onto the card'
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "generate" -d 'Generate a Key on the card'
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "touch" -d 'Set the card\'s touch policy (if supported)'
complete -c oct -n "__fish_seen_subcommand_from admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from admin name" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from admin url" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from admin signing-pin-validity" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from admin import" -s s -l sig-fp -d 'Optionally, select the subkey to import in the SIG slot' -r
complete -c oct -n "__fish_seen_subcommand_from admin import" -s d -l dec-fp -d 'Optionally, select the subkey to import in the DEC slot' -r
complete -c oct -n "__fish_seen_subcommand_from admin import" -s a -l aut-fp -d 'Optionally, select the subkey to import in the AUT slot' -r
complete -c oct -n "__fish_seen_subcommand_from admin import" -l key-passphrase -d 'Optionally, provide a passphrase for encrypted secret key material in a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from admin import" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from admin generate" -s o -l output -d 'Output file' -r -F
complete -c oct -n "__fish_seen_subcommand_from admin generate" -s u -l userid -d 'User ID to add to the exported certificate representation' -r
complete -c oct -n "__fish_seen_subcommand_from admin generate" -s p -l user-pin -d 'Optionally, get User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from admin generate" -l no-dec -d 'Do not create a key in the DEC slot'
complete -c oct -n "__fish_seen_subcommand_from admin generate" -l no-aut -d 'Do not create a key in the AUT slot'
complete -c oct -n "__fish_seen_subcommand_from admin generate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from admin touch" -s k -l key -d 'Key slot to set the touch policy for' -r -f -a "{SIG\t'',DEC\t'',AUT\t'',ATT\t''}"
complete -c oct -n "__fish_seen_subcommand_from admin touch" -s p -l policy -d 'Touch policy to set on this key slot' -r -f -a "{Off\t'',On\t'',Fixed\t'',Cached\t'',Cached-Fixed\t''}"
complete -c oct -n "__fish_seen_subcommand_from admin touch" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from admin help; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "name" -d 'Set cardholder name'
complete -c oct -n "__fish_seen_subcommand_from admin help; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "url" -d 'Set certificate URL'
complete -c oct -n "__fish_seen_subcommand_from admin help; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "signing-pin-validity" -d 'Configure if user PIN presentation is valid for just one signing operation, or for unlimited signing operations'
complete -c oct -n "__fish_seen_subcommand_from admin help; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "import" -d 'Import a Key onto the card'
complete -c oct -n "__fish_seen_subcommand_from admin help; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "generate" -d 'Generate a Key on the card'
complete -c oct -n "__fish_seen_subcommand_from admin help; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "touch" -d 'Set the card\'s touch policy (if supported)'
complete -c oct -n "__fish_seen_subcommand_from admin help; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "set-user" -d 'Set User PIN'
complete -c oct -n "__fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "set-admin" -d 'Set Admin PIN'
complete -c oct -n "__fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "reset-user" -d 'Reset User PIN with Admin PIN'
complete -c oct -n "__fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "reset-user-rc" -d 'Reset User PIN with Resetting Code'
complete -c oct -n "__fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "set-reset" -d 'Set Resetting Code'
complete -c oct -n "__fish_seen_subcommand_from pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from pin set-user" -s p -l user-pin-old -d 'Optionally, get old User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin set-user" -s q -l user-pin-new -d 'Optionally, get new User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin set-user" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from pin set-admin" -s P -l admin-pin-old -d 'Optionally, get old Admin PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin set-admin" -s Q -l admin-pin-new -d 'Optionally, get new Admin PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin set-admin" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from pin reset-user" -s P -l admin-pin -d 'Optionally, get Admin PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin reset-user" -s p -l user-pin-new -d 'Optionally, get new User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin reset-user" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from pin reset-user-rc" -s r -l reset-code -d 'Optionally, get the Resetting Code from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin reset-user-rc" -s p -l user-pin-new -d 'Optionally, get new User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin reset-user-rc" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from pin set-reset" -s P -l admin-pin -d 'Optionally, get Admin PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin set-reset" -s r -l reset-code -d 'Optionally, get the Resetting Code from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from pin set-reset" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from pin help; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "set-user" -d 'Set User PIN'
complete -c oct -n "__fish_seen_subcommand_from pin help; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "set-admin" -d 'Set Admin PIN'
complete -c oct -n "__fish_seen_subcommand_from pin help; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "reset-user" -d 'Reset User PIN with Admin PIN'
complete -c oct -n "__fish_seen_subcommand_from pin help; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "reset-user-rc" -d 'Reset User PIN with Resetting Code'
complete -c oct -n "__fish_seen_subcommand_from pin help; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "set-reset" -d 'Set Resetting Code'
complete -c oct -n "__fish_seen_subcommand_from pin help; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from decrypt" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from decrypt" -s p -l user-pin -d 'Optionally, get User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from decrypt" -s o -l output -d 'Output file (stdout if unset)' -r -F
complete -c oct -n "__fish_seen_subcommand_from decrypt" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached cleartext inline help" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached cleartext inline help" -s p -l user-pin -d 'Optionally, get User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached cleartext inline help" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached cleartext inline help" -f -a "detached" -d 'Create a detached signature'
complete -c oct -n "__fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached cleartext inline help" -f -a "cleartext" -d 'Create a cleartext signature'
complete -c oct -n "__fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached cleartext inline help" -f -a "inline" -d 'Create an inline signature'
complete -c oct -n "__fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from detached cleartext inline help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from sign detached" -s o -l output -d 'Output file (stdout if unset)' -r -F
complete -c oct -n "__fish_seen_subcommand_from sign detached" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from sign cleartext" -s o -l output -d 'Output file (stdout if unset)' -r -F
complete -c oct -n "__fish_seen_subcommand_from sign cleartext" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from sign inline" -s o -l output -d 'Output file (stdout if unset)' -r -F
complete -c oct -n "__fish_seen_subcommand_from sign inline" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from sign help; and not __fish_seen_subcommand_from detached cleartext inline help" -f -a "detached" -d 'Create a detached signature'
complete -c oct -n "__fish_seen_subcommand_from sign help; and not __fish_seen_subcommand_from detached cleartext inline help" -f -a "cleartext" -d 'Create a cleartext signature'
complete -c oct -n "__fish_seen_subcommand_from sign help; and not __fish_seen_subcommand_from detached cleartext inline help" -f -a "inline" -d 'Create an inline signature'
complete -c oct -n "__fish_seen_subcommand_from sign help; and not __fish_seen_subcommand_from detached cleartext inline help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from cert generate statement help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from cert generate statement help" -f -a "cert" -d 'Print the card\'s attestation certificate'
complete -c oct -n "__fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from cert generate statement help" -f -a "generate" -d 'Generate attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from cert generate statement help" -f -a "statement" -d 'Print the attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_seen_subcommand_from attestation; and not __fish_seen_subcommand_from cert generate statement help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from attestation cert" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from attestation cert" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from attestation generate" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from attestation generate" -s k -l key -d 'Key slot to use' -r -f -a "{SIG\t'',DEC\t'',AUT\t''}"
complete -c oct -n "__fish_seen_subcommand_from attestation generate" -s p -l user-pin -d 'Optionally, get User PIN from a file' -r -F
complete -c oct -n "__fish_seen_subcommand_from attestation generate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from attestation statement" -s c -l card -d 'Identifier of the card to reset' -r
complete -c oct -n "__fish_seen_subcommand_from attestation statement" -s k -l key -d 'Key slot to use' -r -f -a "{SIG\t'',DEC\t'',AUT\t''}"
complete -c oct -n "__fish_seen_subcommand_from attestation statement" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from attestation help; and not __fish_seen_subcommand_from cert generate statement help" -f -a "cert" -d 'Print the card\'s attestation certificate'
complete -c oct -n "__fish_seen_subcommand_from attestation help; and not __fish_seen_subcommand_from cert generate statement help" -f -a "generate" -d 'Generate attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_seen_subcommand_from attestation help; and not __fish_seen_subcommand_from cert generate statement help" -f -a "statement" -d 'Print the attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_seen_subcommand_from attestation help; and not __fish_seen_subcommand_from cert generate statement help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from system; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from system; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -f -a "factory-reset" -d 'Completely reset a card (deletes all data including keys!)'
complete -c oct -n "__fish_seen_subcommand_from system; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -f -a "kdf-setup" -d 'Set up KDF mode'
complete -c oct -n "__fish_seen_subcommand_from system; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -f -a "set-identity" -d 'Change identity (Nitrokey Start only)'
complete -c oct -n "__fish_seen_subcommand_from system; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -f -a "activate-file" -d 'Activate File (recover from "card terminated" state)'
complete -c oct -n "__fish_seen_subcommand_from system; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from system factory-reset" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from system factory-reset" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from system kdf-setup" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from system kdf-setup" -s h -l help -d 'Print help'
complete -c oct -n "__fish_seen_subcommand_from system set-identity" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_seen_subcommand_from system set-identity" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from system activate-file" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from system help; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -f -a "factory-reset" -d 'Completely reset a card (deletes all data including keys!)'
complete -c oct -n "__fish_seen_subcommand_from system help; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -f -a "kdf-setup" -d 'Set up KDF mode'
complete -c oct -n "__fish_seen_subcommand_from system help; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -f -a "set-identity" -d 'Change identity (Nitrokey Start only)'
complete -c oct -n "__fish_seen_subcommand_from system help; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -f -a "activate-file" -d 'Activate File (recover from "card terminated" state)'
complete -c oct -n "__fish_seen_subcommand_from system help; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from output-versions" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "list" -d 'Enumerate available OpenPGP cards'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "status" -d 'Show information about the data on a card'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "info" -d 'Show technical details about a card'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "ssh" -d 'Show a card\'s authentication key as an SSH public key'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "pubkey" -d 'Export the key data on a card as an OpenPGP public key'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "admin" -d 'Administer data on a card (including keys and metadata)'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "pin" -d 'PIN management (change PINs, reset blocked PINs)'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "decrypt" -d 'Decrypt data using a card'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "sign" -d 'Sign data using a card'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "attestation" -d 'Attestation management (Yubico only)'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "system" -d 'Initialization and similar functionality'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "output-versions" -d 'Show supported output format versions'
complete -c oct -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_seen_subcommand_from help admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch" -f -a "name" -d 'Set cardholder name'
complete -c oct -n "__fish_seen_subcommand_from help admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch" -f -a "url" -d 'Set certificate URL'
complete -c oct -n "__fish_seen_subcommand_from help admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch" -f -a "signing-pin-validity" -d 'Configure if user PIN presentation is valid for just one signing operation, or for unlimited signing operations'
complete -c oct -n "__fish_seen_subcommand_from help admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch" -f -a "import" -d 'Import a Key onto the card'
complete -c oct -n "__fish_seen_subcommand_from help admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch" -f -a "generate" -d 'Generate a Key on the card'
complete -c oct -n "__fish_seen_subcommand_from help admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch" -f -a "touch" -d 'Set the card\'s touch policy (if supported)'
complete -c oct -n "__fish_seen_subcommand_from help pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset" -f -a "set-user" -d 'Set User PIN'
complete -c oct -n "__fish_seen_subcommand_from help pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset" -f -a "set-admin" -d 'Set Admin PIN'
complete -c oct -n "__fish_seen_subcommand_from help pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset" -f -a "reset-user" -d 'Reset User PIN with Admin PIN'
complete -c oct -n "__fish_seen_subcommand_from help pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset" -f -a "reset-user-rc" -d 'Reset User PIN with Resetting Code'
complete -c oct -n "__fish_seen_subcommand_from help pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset" -f -a "set-reset" -d 'Set Resetting Code'
complete -c oct -n "__fish_seen_subcommand_from help sign; and not __fish_seen_subcommand_from detached cleartext inline" -f -a "detached" -d 'Create a detached signature'
complete -c oct -n "__fish_seen_subcommand_from help sign; and not __fish_seen_subcommand_from detached cleartext inline" -f -a "cleartext" -d 'Create a cleartext signature'
complete -c oct -n "__fish_seen_subcommand_from help sign; and not __fish_seen_subcommand_from detached cleartext inline" -f -a "inline" -d 'Create an inline signature'
complete -c oct -n "__fish_seen_subcommand_from help attestation; and not __fish_seen_subcommand_from cert generate statement" -f -a "cert" -d 'Print the card\'s attestation certificate'
complete -c oct -n "__fish_seen_subcommand_from help attestation; and not __fish_seen_subcommand_from cert generate statement" -f -a "generate" -d 'Generate attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_seen_subcommand_from help attestation; and not __fish_seen_subcommand_from cert generate statement" -f -a "statement" -d 'Print the attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_seen_subcommand_from help system; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file" -f -a "factory-reset" -d 'Completely reset a card (deletes all data including keys!)'
complete -c oct -n "__fish_seen_subcommand_from help system; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file" -f -a "kdf-setup" -d 'Set up KDF mode'
complete -c oct -n "__fish_seen_subcommand_from help system; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file" -f -a "set-identity" -d 'Change identity (Nitrokey Start only)'
complete -c oct -n "__fish_seen_subcommand_from help system; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file" -f -a "activate-file" -d 'Activate File (recover from "card terminated" state)'
