/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.netty4.ssl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.AccessController;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.Version;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.network.NetworkModule;
import org.opensearch.common.network.NetworkService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.PageCacheRecycler;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.plugins.SecureTransportSettingsProvider;
import org.opensearch.plugins.TransportExceptionHandler;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.SharedGroupFactory;
import org.opensearch.transport.TcpChannel;
import org.opensearch.transport.Transport;
import org.opensearch.transport.netty4.Netty4Transport;
import org.opensearch.transport.netty4.ssl.DualModeSslHandler;
import org.opensearch.transport.netty4.ssl.SecureConnectionTestUtil;
import org.opensearch.transport.netty4.ssl.SslUtils;

public class SecureNetty4Transport
extends Netty4Transport {
    private static final Logger logger = LogManager.getLogger(SecureNetty4Transport.class);
    private final SecureTransportSettingsProvider secureTransportSettingsProvider;
    private final TransportExceptionHandler exceptionHandler;

    public SecureNetty4Transport(Settings settings, Version version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, SharedGroupFactory sharedGroupFactory, SecureTransportSettingsProvider secureTransportSettingsProvider, Tracer tracer) {
        super(settings, version, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, sharedGroupFactory, tracer);
        this.secureTransportSettingsProvider = secureTransportSettingsProvider;
        this.exceptionHandler = secureTransportSettingsProvider.buildServerTransportExceptionHandler(settings, (Transport)this).orElse(TransportExceptionHandler.NOOP);
    }

    public void onException(TcpChannel channel, Exception e) {
        Throwable cause = e;
        if (e instanceof DecoderException && e != null) {
            cause = e.getCause();
        }
        this.exceptionHandler.onError(cause);
        logger.error("Exception during establishing a SSL connection: " + cause, cause);
        if (channel == null || !channel.isOpen()) {
            throw new OpenSearchSecurityException("The provided TCP channel is invalid.", e, new Object[0]);
        }
        super.onException(channel, e);
    }

    @Override
    protected ChannelHandler getServerChannelInitializer(String name) {
        return new SSLServerChannelInitializer(name);
    }

    @Override
    protected ChannelHandler getClientChannelInitializer(DiscoveryNode node) {
        return new SSLClientChannelInitializer(node);
    }

    protected class SSLClientChannelInitializer
    extends Netty4Transport.ClientChannelInitializer {
        private final boolean hostnameVerificationEnabled;
        private final boolean hostnameVerificationResolveHostName;
        private final DiscoveryNode node;
        private SecureConnectionTestUtil.SSLConnectionTestResult connectionTestResult;

        public SSLClientChannelInitializer(DiscoveryNode node) {
            this.node = node;
            boolean dualModeEnabled = (Boolean)NetworkModule.TRANSPORT_SSL_DUAL_MODE_ENABLED.get(SecureNetty4Transport.this.settings);
            this.hostnameVerificationEnabled = (Boolean)NetworkModule.TRANSPORT_SSL_ENFORCE_HOSTNAME_VERIFICATION.get(SecureNetty4Transport.this.settings);
            this.hostnameVerificationResolveHostName = (Boolean)NetworkModule.TRANSPORT_SSL_ENFORCE_HOSTNAME_VERIFICATION_RESOLVE_HOST_NAME.get(SecureNetty4Transport.this.settings);
            this.connectionTestResult = SecureConnectionTestUtil.SSLConnectionTestResult.SSL_AVAILABLE;
            if (dualModeEnabled) {
                SecureConnectionTestUtil sslConnectionTestUtil = new SecureConnectionTestUtil(node.getAddress().getAddress(), node.getAddress().getPort());
                this.connectionTestResult = AccessController.doPrivileged(sslConnectionTestUtil::testConnection);
            }
        }

        @Override
        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            if (this.connectionTestResult == SecureConnectionTestUtil.SSLConnectionTestResult.OPENSEARCH_PING_FAILED) {
                logger.error("SSL dual mode is enabled but dual mode handshake and OpenSearch ping has failed during client connection setup, closing channel");
                ch.close();
                return;
            }
            if (this.connectionTestResult == SecureConnectionTestUtil.SSLConnectionTestResult.SSL_AVAILABLE) {
                logger.debug("Connection to {} needs to be ssl, adding ssl handler to the client channel ", (Object)this.node.getHostName());
                ch.pipeline().addFirst("client_ssl_handler", (ChannelHandler)new ClientSSLHandler(SecureNetty4Transport.this.settings, SecureNetty4Transport.this.secureTransportSettingsProvider, this.hostnameVerificationEnabled, this.hostnameVerificationResolveHostName));
            } else {
                logger.debug("Connection to {} needs to be non ssl", (Object)this.node.getHostName());
            }
        }

        @Override
        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof DecoderException && cause != null) {
                cause = cause.getCause();
            }
            logger.error("Exception during establishing a SSL connection: " + cause, cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    protected static class ClientSSLHandler
    extends ChannelOutboundHandlerAdapter {
        private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
        private final Settings settings;
        private final SecureTransportSettingsProvider secureTransportSettingsProvider;
        private final boolean hostnameVerificationEnabled;
        private final boolean hostnameVerificationResovleHostName;

        private ClientSSLHandler(Settings settings, SecureTransportSettingsProvider secureTransportSettingsProvider, boolean hostnameVerificationEnabled, boolean hostnameVerificationResovleHostName) {
            this.settings = settings;
            this.secureTransportSettingsProvider = secureTransportSettingsProvider;
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            this.hostnameVerificationResovleHostName = hostnameVerificationResovleHostName;
        }

        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof DecoderException && cause != null) {
                cause = cause.getCause();
            }
            logger.error("Exception during establishing a SSL connection: " + cause, cause);
            super.exceptionCaught(ctx, cause);
        }

        @SuppressForbidden(reason="The java.net.InetSocketAddress#getHostName() needs to be used")
        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            SSLEngine sslEngine = null;
            try {
                if (this.hostnameVerificationEnabled) {
                    String hostname;
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
                    String string = hostname = this.hostnameVerificationResovleHostName ? inetSocketAddress.getHostName() : inetSocketAddress.getHostString();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Hostname of peer is {} ({}/{}) with hostnameVerificationResolveHostName: {}", (Object)hostname, (Object)inetSocketAddress.getHostName(), (Object)inetSocketAddress.getHostString(), (Object)this.hostnameVerificationResovleHostName);
                    }
                    sslEngine = this.secureTransportSettingsProvider.buildSecureClientTransportEngine(this.settings, hostname, inetSocketAddress.getPort()).orElse(null);
                } else {
                    sslEngine = this.secureTransportSettingsProvider.buildSecureClientTransportEngine(this.settings, null, -1).orElse(null);
                }
                if (sslEngine == null) {
                    sslEngine = SslUtils.createDefaultClientSSLEngine();
                }
            }
            catch (SSLException e) {
                throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
            }
            SslHandler sslHandler = new SslHandler(sslEngine);
            ctx.pipeline().replace((ChannelHandler)this, "ssl_client", (ChannelHandler)sslHandler);
            super.connect(ctx, remoteAddress, localAddress, promise);
        }
    }

    protected class SSLServerChannelInitializer
    extends Netty4Transport.ServerChannelInitializer {
        public SSLServerChannelInitializer(String name) {
            super(name);
        }

        @Override
        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            boolean dualModeEnabled = (Boolean)NetworkModule.TRANSPORT_SSL_DUAL_MODE_ENABLED.get(SecureNetty4Transport.this.settings);
            if (dualModeEnabled) {
                logger.info("SSL Dual mode enabled, using port unification handler");
                DualModeSslHandler portUnificationHandler = new DualModeSslHandler(SecureNetty4Transport.this.settings, SecureNetty4Transport.this.secureTransportSettingsProvider, SecureNetty4Transport.this);
                ch.pipeline().addFirst("port_unification_handler", (ChannelHandler)portUnificationHandler);
            } else {
                SSLEngine sslEngine = SecureNetty4Transport.this.secureTransportSettingsProvider.buildSecureServerTransportEngine(SecureNetty4Transport.this.settings, (Transport)SecureNetty4Transport.this).orElseGet(SslUtils::createDefaultServerSSLEngine);
                SslHandler sslHandler = new SslHandler(sslEngine);
                ch.pipeline().addFirst("ssl_server", (ChannelHandler)sslHandler);
            }
        }

        @Override
        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof DecoderException && cause != null) {
                cause = cause.getCause();
            }
            logger.error("Exception during establishing a SSL connection: " + cause, cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

