/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.functions.resolver;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.NamedArgumentExpression;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.function.FunctionSignature;
import org.opensearch.sql.spark.client.SparkClient;
import org.opensearch.sql.spark.functions.implementation.SparkSqlFunctionImplementation;

public class SparkSqlTableFunctionResolver
implements FunctionResolver {
    private final SparkClient sparkClient;
    public static final String SQL = "sql";
    public static final String QUERY = "query";

    public Pair<FunctionSignature, FunctionBuilder> resolve(FunctionSignature unresolvedSignature) {
        FunctionName functionName = FunctionName.of((String)SQL);
        FunctionSignature functionSignature = new FunctionSignature(functionName, List.of(ExprCoreType.STRING));
        List<String> argumentNames = List.of(QUERY);
        FunctionBuilder functionBuilder = (functionProperties, arguments) -> {
            Boolean argumentsPassedByName = arguments.stream().noneMatch(arg -> StringUtils.isEmpty((CharSequence)((NamedArgumentExpression)arg).getArgName()));
            Boolean argumentsPassedByPosition = arguments.stream().allMatch(arg -> StringUtils.isEmpty((CharSequence)((NamedArgumentExpression)arg).getArgName()));
            if (!argumentsPassedByName.booleanValue() && !argumentsPassedByPosition.booleanValue()) {
                throw new SemanticCheckException("Arguments should be either passed by name or position");
            }
            if (arguments.size() != argumentNames.size()) {
                throw new SemanticCheckException(String.format("Missing arguments:[%s]", String.join((CharSequence)",", argumentNames.subList(arguments.size(), argumentNames.size()))));
            }
            if (argumentsPassedByPosition.booleanValue()) {
                ArrayList<Expression> namedArguments = new ArrayList<Expression>();
                for (int i = 0; i < arguments.size(); ++i) {
                    namedArguments.add((Expression)new NamedArgumentExpression((String)argumentNames.get(i), ((NamedArgumentExpression)arguments.get(i)).getValue()));
                }
                return new SparkSqlFunctionImplementation(functionName, namedArguments, this.sparkClient);
            }
            return new SparkSqlFunctionImplementation(functionName, arguments, this.sparkClient);
        };
        return Pair.of((Object)functionSignature, (Object)functionBuilder);
    }

    public FunctionName getFunctionName() {
        return FunctionName.of((String)SQL);
    }

    @Generated
    public SparkSqlTableFunctionResolver(SparkClient sparkClient) {
        this.sparkClient = sparkClient;
    }
}

