/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.AU;
import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class ShelxReader
extends AtomSetCollectionReader {
    private String[] sfacElementSymbols;
    private boolean isCmdf;
    String[] tokens;
    private static final String unsupportedRecordTypes = ";ZERR;DISP;UNIT;LAUE;REM;MORE;TIME;HKLF;OMIT;SHEL;BASF;TWIN;EXTI;SWAT;HOPE;MERG;SPEC;RESI;MOVE;ANIS;AFIX;HFIX;FRAG;FEND;EXYZ;EXTI;EADP;EQIV;CONN;BIND;FREE;DFIX;DANG;BUMP;SAME;SADI;CHIV;FLAT;DELU;SIMU;DEFS;ISOR;NCSY;SUMP;L.S.;CGLS;BLOC;DAMP;STIR;WGHT;FVAR;BOND;CONF;MPLA;RTAB;HTAB;LIST;ACTA;SIZE;TEMP;WPDB;FMAP;GRID;PLAN;MOLE;";
    private static final String[] supportedRecordTypes = new String[]{"TITL", "CELL", "SPGR", "SFAC", "LATT", "SYMM", "NOTE", "ATOM", "PART", "END"};
    char altloc = '\u0000';
    private boolean negDisorder;
    private boolean isCentroSymmetric;
    boolean haveXYZ;

    @Override
    public void initializeReader() {
        this.setFractionalCoordinates(true);
    }

    @Override
    protected boolean checkLine() throws Exception {
        int lineLength;
        while ((lineLength = (this.line = this.line.trim()).length()) > 0 && this.line.charAt(lineLength - 1) == '=') {
            this.line = this.line.substring(0, lineLength - 1) + this.rd();
        }
        this.tokens = this.getTokens();
        if (this.tokens.length == 0) {
            return true;
        }
        String command = this.tokens[0].toUpperCase();
        if (command.equals("TITL")) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.sfacElementSymbols = null;
            this.applySymmetryAndSetTrajectory();
            this.setFractionalCoordinates(true);
            this.asc.newAtomSet();
            this.asc.setAtomSetName(this.line.substring(4).trim());
            return true;
        }
        if (command.equals("NOTE")) {
            this.isCmdf = true;
            return true;
        }
        if (!this.doProcessLines || lineLength < 3) {
            return true;
        }
        if (unsupportedRecordTypes.indexOf(";" + command + ";") >= 0) {
            return true;
        }
        int i = supportedRecordTypes.length;
        while (--i >= 0) {
            if (!command.equals(supportedRecordTypes[i])) continue;
            this.processSupportedRecord(i);
            return true;
        }
        if (!this.isCmdf) {
            this.assumeAtomRecord();
        }
        return true;
    }

    private void processSupportedRecord(int recordIndex) throws Exception {
        switch (recordIndex) {
            case 0: 
            case 9: {
                break;
            }
            case 1: {
                this.cell();
                break;
            }
            case 2: {
                this.setSpaceGroupName(PT.parseTrimmedAt(this.line, 4));
                break;
            }
            case 3: {
                this.parseSfacRecord();
                break;
            }
            case 4: {
                this.parseLattRecord();
                break;
            }
            case 5: {
                this.parseSymmRecord();
                break;
            }
            case 6: {
                this.isCmdf = true;
                break;
            }
            case 7: {
                this.isCmdf = true;
                this.processCmdfAtoms();
                break;
            }
            case 8: {
                this.processPartRecord();
            }
        }
    }

    private void processPartRecord() {
        int part = this.parseIntStr(this.tokens[1]);
        this.altloc = (char)(part == 0 ? 0 : 48 + Math.abs(part));
        if (part < 0) {
            this.negDisorder = true;
        }
    }

    private void parseLattRecord() throws Exception {
        int latt = this.parseIntStr(this.tokens[1]);
        boolean bl = this.isCentroSymmetric = latt > 0;
        if (latt == 1 || latt == -1) {
            return;
        }
        this.asc.getXSymmetry().setLatticeParameter(latt);
    }

    private void parseSymmRecord() throws Exception {
        if (!this.haveXYZ) {
            this.setSymmetryOperator("x,y,z");
            this.haveXYZ = true;
        }
        this.setSymmetryOperator(this.line.substring(4).trim());
    }

    private void cell() throws Exception {
        int ioff = this.tokens.length - 6;
        if (ioff == 2) {
            this.asc.setInfo("wavelength", Float.valueOf(this.parseFloatStr(this.tokens[1])));
        }
        for (int ipt = 0; ipt < 6; ++ipt) {
            this.setUnitCellItem(ipt, this.parseFloatStr(this.tokens[ipt + ioff]));
        }
    }

    private void parseSfacRecord() {
        boolean allElementSymbols = true;
        int i = this.tokens.length;
        while (allElementSymbols && --i >= 1) {
            String token = this.tokens[i];
            allElementSymbols = ShelxReader.isValidElementSymbolNoCaseSecondChar(token);
        }
        String[] sfacTokens = PT.getTokens(this.line.substring(4));
        if (allElementSymbols) {
            this.parseSfacElementSymbols(sfacTokens);
        } else {
            this.parseSfacCoefficients(sfacTokens);
        }
    }

    private void parseSfacElementSymbols(String[] sfacTokens) {
        if (this.sfacElementSymbols == null) {
            this.sfacElementSymbols = sfacTokens;
        } else {
            int oldCount = this.sfacElementSymbols.length;
            int tokenCount = sfacTokens.length;
            this.sfacElementSymbols = AU.arrayCopyS(this.sfacElementSymbols, oldCount + tokenCount);
            int i = tokenCount;
            while (--i >= 0) {
                this.sfacElementSymbols[oldCount + i] = sfacTokens[i];
            }
        }
    }

    private void parseSfacCoefficients(String[] sfacTokens) {
        float a1 = this.parseFloatStr(sfacTokens[1]);
        float a2 = this.parseFloatStr(sfacTokens[3]);
        float a3 = this.parseFloatStr(sfacTokens[5]);
        float a4 = this.parseFloatStr(sfacTokens[7]);
        float c = this.parseFloatStr(sfacTokens[9]);
        int z = Math.round(a1 + a2 + a3 + a4 + c);
        String elementSymbol = ShelxReader.getElementSymbol(z);
        int oldCount = 0;
        if (this.sfacElementSymbols == null) {
            this.sfacElementSymbols = new String[1];
        } else {
            oldCount = this.sfacElementSymbols.length;
            this.sfacElementSymbols = AU.arrayCopyS(this.sfacElementSymbols, oldCount + 1);
            this.sfacElementSymbols[oldCount] = elementSymbol;
        }
        this.sfacElementSymbols[oldCount] = elementSymbol;
    }

    private void assumeAtomRecord() throws Exception {
        float x = Float.NaN;
        float y = Float.NaN;
        float z = Float.NaN;
        float occ = 1.0f;
        int elementIndex = -1;
        String atomName = null;
        try {
            atomName = this.tokens[0];
            x = this.parsePrecision(this.tokens[2]) % 10.0f;
            y = this.parsePrecision(this.tokens[3]) % 10.0f;
            z = this.parsePrecision(this.tokens[4]) % 10.0f;
            occ = this.parseFloatStr(this.tokens[5]) % 10.0f;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) {
            Logger.error("skipping line " + this.line);
            return;
        }
        Atom atom = this.asc.addNewAtom();
        atom.atomName = atomName;
        atom.foccupancy = occ;
        boolean isQPeak = atomName.startsWith("Q");
        if (isQPeak) {
            atom.elementSymbol = "Xx";
        } else if (this.sfacElementSymbols != null && elementIndex >= 0 && elementIndex < this.sfacElementSymbols.length) {
            atom.elementSymbol = this.sfacElementSymbols[elementIndex];
        }
        this.setAtomCoordXYZ(atom, x, y, z);
        atom.altLoc = this.altloc;
        atom.isNegDisorder = this.negDisorder;
        if (this.tokens.length == 12) {
            float[] data = new float[8];
            data[0] = this.parseFloatStr(this.tokens[6]);
            data[1] = this.parseFloatStr(this.tokens[7]);
            data[2] = this.parseFloatStr(this.tokens[8]);
            data[3] = this.parseFloatStr(this.tokens[11]);
            data[4] = this.parseFloatStr(this.tokens[10]);
            data[5] = this.parseFloatStr(this.tokens[9]);
            for (int i = 0; i < 6; ++i) {
                if (!Float.isNaN(data[i])) continue;
                Logger.error("Bad anisotropic Uij data: " + this.line);
                return;
            }
            this.asc.setAnisoBorU(atom, data, 8);
        }
    }

    private void processCmdfAtoms() throws Exception {
        while (this.rd() != null && this.line.length() > 10) {
            this.tokens = this.getTokens();
            this.addAtomXYZSymName(this.tokens, 2, this.getSymbol(this.tokens[0]), this.tokens[1]);
        }
    }

    private String getSymbol(String sym) {
        if (sym == null) {
            return "Xx";
        }
        int len = sym.length();
        if (len < 2) {
            return sym;
        }
        char ch1 = sym.charAt(1);
        if (ch1 >= 'a' && ch1 <= 'z') {
            return sym.substring(0, 2);
        }
        return "" + sym.charAt(0);
    }

    public static boolean isValidElementSymbolNoCaseSecondChar(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        char chFirst = str.charAt(0);
        if (length == 1) {
            return Atom.isValidSym1(chFirst);
        }
        if (length > 2) {
            return false;
        }
        char chSecond = str.charAt(1);
        return Atom.isValidSymNoCase(chFirst, chSecond);
    }

    @Override
    public void applySymmetryAndSetTrajectory() throws Exception {
        if (this.isCentroSymmetric && !this.ignoreFileSymmetryOperators) {
            if (!this.haveXYZ) {
                this.setSymmetryOperator("x,y,z");
            }
            this.asc.getXSymmetry().getSymmetry().addInversion();
            this.isCentroSymmetric = false;
            this.haveXYZ = false;
        }
        this.applySymTrajASCR();
    }
}

