(window["anomalyDetectionDashboards_bundle_jsonpfunction"]=window["anomalyDetectionDashboards_bundle_jsonpfunction"]||[]).push([[2],{2091:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.createSingleDataSource=createSingleDataSource;exports.dataSourceOptionGroupLabel=void 0;exports.deleteDataSourceById=deleteDataSourceById;exports.deleteMultipleDataSources=deleteMultipleDataSources;exports.extractRegisteredAuthTypeCredentials=void 0;exports.fetchDataSourceMetaData=fetchDataSourceMetaData;exports.getApplication=exports.generateComponentId=void 0;exports.getDataSourceById=getDataSourceById;exports.getDataSourceSelection=void 0;exports.getDataSources=getDataSources;exports.getDataSourcesWithFields=getDataSourcesWithFields;exports.getDefaultAuthMethod=void 0;exports.getDefaultDataSource=getDefaultDataSource;exports.getDefaultDataSourceId=getDefaultDataSourceId;exports.getDefaultDataSourceId$=getDefaultDataSourceId$;exports.getFilteredDataSources=getFilteredDataSources;exports.handleDataSourceFetchError=exports.getUiSettings=exports.getHideLocalCluster=void 0;exports.handleNoAvailableDataSourceError=handleNoAvailableDataSourceError;exports.handleSetDefaultDatasource=handleSetDefaultDatasource;exports.setDataSourceSelection=exports.setApplication=exports.isValidUrl=void 0;exports.setFirstDataSourceAsDefault=setFirstDataSourceAsDefault;exports.setUiSettings=exports.setHideLocalCluster=void 0;exports.testConnection=testConnection;exports.updateDataSourceById=updateDataSourceById;var _i18n=__webpack_require__(3);var _std=__webpack_require__(25);var _uuid=_interopRequireDefault(__webpack_require__(67));var _types=__webpack_require__(2094);var _public=__webpack_require__(26);var _public2=__webpack_require__(18);var _toast_button=__webpack_require__(2528);var _constants=__webpack_require__(2110);var _data_source_selection_service=__webpack_require__(2138);async function getDataSources(savedObjectsClient){return savedObjectsClient.find({type:"data-source",fields:["id","description","title"],perPage:1e4}).then(response=>{var _response$savedObject,_response$savedObject2;return(response===null||response===void 0||(_response$savedObject=response.savedObjects)===null||_response$savedObject===void 0||(_response$savedObject2=_response$savedObject.map)===null||_response$savedObject2===void 0?void 0:_response$savedObject2.call(_response$savedObject,source=>{const id=source.id;const title=source.get("title");const description=source.get("description");return{id:id,title:title,description:description,sort:"".concat(title)}}))||[]})}async function getDataSourcesWithFields(savedObjectsClient,fields){const response=await savedObjectsClient.find({type:"data-source",fields:fields,perPage:1e4});return response===null||response===void 0?void 0:response.savedObjects}async function handleSetDefaultDatasource(savedObjectsClient,uiSettings){if(!getDefaultDataSourceId(uiSettings)){return await setFirstDataSourceAsDefault(savedObjectsClient,uiSettings,false)}}async function setFirstDataSourceAsDefault(savedObjectsClient,uiSettings,exists){if(exists){uiSettings.remove(_constants.DEFAULT_DATA_SOURCE_UI_SETTINGS_ID)}const listOfDataSources=await getDataSources(savedObjectsClient);if(Array.isArray(listOfDataSources)&&listOfDataSources.length>=1){const datasourceId=listOfDataSources[0].id;return await uiSettings.set(_constants.DEFAULT_DATA_SOURCE_UI_SETTINGS_ID,datasourceId)}}function handleNoAvailableDataSourceError(props){const{changeState:changeState,notifications:notifications,application:application,callback:callback,incompatibleDataSourcesExist:incompatibleDataSourcesExist}=props;const defaultMessage=incompatibleDataSourcesExist?"".concat(_constants.NO_COMPATIBLE_DATASOURCES_MESSAGE," ").concat(_constants.ADD_COMPATIBLE_DATASOURCES_MESSAGE):"".concat(_constants.NO_DATASOURCES_CONNECTED_MESSAGE," ").concat(_constants.CONNECT_DATASOURCES_MESSAGE);changeState();if(callback)callback([]);notifications.add({title:_i18n.i18n.translate("dataSource.noAvailableDataSourceError",{defaultMessage:defaultMessage}),text:(0,_public2.toMountPoint)((0,_toast_button.getManageDataSourceButton)(application)),color:"warning"})}function getFilteredDataSources(dataSources){let filter=arguments.length>1&&arguments[1]!==undefined?arguments[1]:ds=>true;return dataSources.filter(ds=>filter(ds)).map(ds=>{var _ds$attributes;return{id:ds.id,label:((_ds$attributes=ds.attributes)===null||_ds$attributes===void 0?void 0:_ds$attributes.title)||""}}).sort((a,b)=>a.label.toLowerCase().localeCompare(b.label.toLowerCase()))}function getDefaultDataSourceId(uiSettings){if(!uiSettings)return null;return uiSettings.get(_constants.DEFAULT_DATA_SOURCE_UI_SETTINGS_ID,null)}function getDefaultDataSourceId$(uiSettings){if(!uiSettings)return null;return uiSettings.get$(_constants.DEFAULT_DATA_SOURCE_UI_SETTINGS_ID,null)}function getDefaultDataSource(dataSourcesOptions,LocalCluster,defaultDataSourceId,hideLocalCluster){const defaultDataSourceAfterCheck=dataSourcesOptions.find(dataSource=>dataSource.id===defaultDataSourceId);if(defaultDataSourceAfterCheck){return[{id:defaultDataSourceAfterCheck.id,label:defaultDataSourceAfterCheck.label}]}if(!hideLocalCluster){return[LocalCluster]}if(dataSourcesOptions.length>0){return[{id:dataSourcesOptions[0].id,label:dataSourcesOptions[0].label}]}return[]}async function getDataSourceById(id,savedObjectsClient){const response=await savedObjectsClient.get("data-source",id);if(!response||response.error){var _response$error,_response$error2;const statusCode=(_response$error=response.error)===null||_response$error===void 0?void 0:_response$error.statusCode;if(statusCode===404){throw new _types.DataSourceError({statusCode:statusCode,body:"Unable to find data source"})}throw new _types.DataSourceError({statusCode:statusCode,body:(_response$error2=response.error)===null||_response$error2===void 0?void 0:_response$error2.message})}const attributes=(response===null||response===void 0?void 0:response.attributes)||{};return{id:response.id,title:attributes.title,endpoint:attributes.endpoint,description:attributes.description||"",auth:attributes.auth}}async function createSingleDataSource(savedObjectsClient,attributes){return savedObjectsClient.create("data-source",attributes)}async function updateDataSourceById(savedObjectsClient,id,attributes){return savedObjectsClient.update("data-source",id,attributes)}async function deleteDataSourceById(id,savedObjectsClient){return savedObjectsClient.delete("data-source",id)}async function deleteMultipleDataSources(savedObjectsClient,selectedDataSources){await Promise.all(selectedDataSources.map(async selectedDataSource=>{await deleteDataSourceById(selectedDataSource.id,savedObjectsClient)}))}async function testConnection(http,_ref,dataSourceID){let{endpoint:endpoint,auth:{type:type,credentials:credentials}}=_ref;const query={id:dataSourceID,dataSourceAttr:{endpoint:endpoint,auth:{type:type,credentials:credentials}}};await http.post("/internal/data-source-management/validate",{body:JSON.stringify(query)})}async function fetchDataSourceMetaData(http,_ref2,dataSourceID){let{endpoint:endpoint,auth:{type:type,credentials:credentials}}=_ref2;const query={id:dataSourceID,dataSourceAttr:{endpoint:endpoint,auth:{type:type,credentials:credentials}}};return await http.post("/internal/data-source-management/fetchDataSourceMetaData",{body:JSON.stringify(query)})}const isValidUrl=endpoint=>{try{const url=new URL(endpoint);return Boolean(url)&&(url.protocol==="http:"||url.protocol==="https:")}catch(e){return false}};exports.isValidUrl=isValidUrl;const getDefaultAuthMethod=authenticationMethodRegistry=>{var _authenticationMethod;const registeredAuthMethods=authenticationMethodRegistry.getAllAuthenticationMethods();const defaultAuthMethod=registeredAuthMethods.length>0?authenticationMethodRegistry.getAuthenticationMethod(registeredAuthMethods[0].name):_types.noAuthCredentialAuthMethod;const initialSelectedAuthMethod=(_authenticationMethod=authenticationMethodRegistry.getAuthenticationMethod(_types.defaultAuthType))!==null&&_authenticationMethod!==void 0?_authenticationMethod:defaultAuthMethod;return initialSelectedAuthMethod};exports.getDefaultAuthMethod=getDefaultAuthMethod;const extractRegisteredAuthTypeCredentials=(currentCredentialState,authType,authenticationMethodRegistry)=>{var _authenticationMethod2,_authenticationMethod3;const registeredCredentials={};const registeredCredentialField=(_authenticationMethod2=(_authenticationMethod3=authenticationMethodRegistry.getAuthenticationMethod(authType))===null||_authenticationMethod3===void 0?void 0:_authenticationMethod3.credentialFormField)!==null&&_authenticationMethod2!==void 0?_authenticationMethod2:{};Object.keys(registeredCredentialField).forEach(credentialField=>{var _currentCredentialSta;registeredCredentials[credentialField]=(_currentCredentialSta=currentCredentialState[credentialField])!==null&&_currentCredentialSta!==void 0?_currentCredentialSta:registeredCredentialField[credentialField]});return registeredCredentials};exports.extractRegisteredAuthTypeCredentials=extractRegisteredAuthTypeCredentials;const handleDataSourceFetchError=(changeState,notifications,callback)=>{changeState({showError:true});if(callback)callback([]);notifications.add({title:_i18n.i18n.translate("dataSource.fetchDataSourceError",{defaultMessage:"Failed to fetch data sources"}),text:(0,_public2.toMountPoint)((0,_toast_button.getReloadButton)()),color:"danger"})};exports.handleDataSourceFetchError=handleDataSourceFetchError;const dataSourceOptionGroupLabel=exports.dataSourceOptionGroupLabel=(0,_std.deepFreeze)({opensearchCluster:{id:"opensearchClusterGroupLabel",label:"OpenSearch cluster",isGroupLabel:true}});const[getApplication,setApplication]=(0,_public.createGetterSetter)("Application");exports.setApplication=setApplication;exports.getApplication=getApplication;const[getUiSettings,setUiSettings]=(0,_public.createGetterSetter)("UiSettings");exports.setUiSettings=setUiSettings;exports.getUiSettings=getUiSettings;const[getHideLocalCluster,setHideLocalCluster]=(0,_public.createGetterSetter)("HideLocalCluster");exports.setHideLocalCluster=setHideLocalCluster;exports.getHideLocalCluster=getHideLocalCluster;const[getDataSourceSelectionInstance,setDataSourceSelection]=(0,_public.createGetterSetter)("DataSourceSelectionService");exports.setDataSourceSelection=setDataSourceSelection;const getDataSourceSelection=()=>{try{return getDataSourceSelectionInstance()}catch(e){return _data_source_selection_service.defaultDataSourceSelection}};exports.getDataSourceSelection=getDataSourceSelection;const generateComponentId=()=>_uuid.default.v4();exports.generateComponentId=generateComponentId},2094:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"AuthType",{enumerable:true,get:function(){return _data_sources.AuthType}});Object.defineProperty(exports,"DataSourceAttributes",{enumerable:true,get:function(){return _data_sources.DataSourceAttributes}});Object.defineProperty(exports,"DataSourceError",{enumerable:true,get:function(){return _data_sources.DataSourceError}});Object.defineProperty(exports,"SigV4Content",{enumerable:true,get:function(){return _data_sources.SigV4Content}});Object.defineProperty(exports,"UsernamePasswordTypedContent",{enumerable:true,get:function(){return _data_sources.UsernamePasswordTypedContent}});exports.usernamePasswordCredentialOption=exports.usernamePasswordCredentialField=exports.usernamePasswordAuthMethod=exports.sigV4ServiceOptions=exports.sigV4CredentialOption=exports.sigV4CredentialField=exports.sigV4AuthMethod=exports.noAuthCredentialOption=exports.noAuthCredentialField=exports.noAuthCredentialAuthMethod=exports.defaultAuthType=exports.credentialSourceOptions=void 0;var _i18n=__webpack_require__(3);var _data_sources=__webpack_require__(2192);const defaultAuthType=exports.defaultAuthType=_data_sources.AuthType.UsernamePasswordType;const noAuthCredentialOption=exports.noAuthCredentialOption={value:_data_sources.AuthType.NoAuth,inputDisplay:_i18n.i18n.translate("dataSourceManagement.credentialSourceOptions.NoAuthentication",{defaultMessage:"No authentication"})};const noAuthCredentialField=exports.noAuthCredentialField={};const noAuthCredentialAuthMethod=exports.noAuthCredentialAuthMethod={name:_data_sources.AuthType.NoAuth,credentialSourceOption:noAuthCredentialOption,credentialFormField:noAuthCredentialField};const usernamePasswordCredentialOption=exports.usernamePasswordCredentialOption={value:_data_sources.AuthType.UsernamePasswordType,inputDisplay:_i18n.i18n.translate("dataSourceManagement.credentialSourceOptions.UsernamePassword",{defaultMessage:"Username & Password"})};const usernamePasswordCredentialField=exports.usernamePasswordCredentialField={username:"",password:""};const usernamePasswordAuthMethod=exports.usernamePasswordAuthMethod={name:_data_sources.AuthType.UsernamePasswordType,credentialSourceOption:usernamePasswordCredentialOption,credentialFormField:usernamePasswordCredentialField};const sigV4CredentialOption=exports.sigV4CredentialOption={value:_data_sources.AuthType.SigV4,inputDisplay:_i18n.i18n.translate("dataSourceManagement.credentialSourceOptions.AwsSigV4",{defaultMessage:"AWS SigV4"})};const sigV4ServiceOptions=exports.sigV4ServiceOptions=[{value:_data_sources.SigV4ServiceName.OpenSearch,inputDisplay:_i18n.i18n.translate("dataSourceManagement.SigV4ServiceOptions.OpenSearch",{defaultMessage:"Amazon OpenSearch Service"})},{value:_data_sources.SigV4ServiceName.OpenSearchServerless,inputDisplay:_i18n.i18n.translate("dataSourceManagement.SigV4ServiceOptions.OpenSearchServerless",{defaultMessage:"Amazon OpenSearch Serverless"})}];const sigV4CredentialField=exports.sigV4CredentialField={region:"",accessKey:"",secretKey:"",service:_data_sources.SigV4ServiceName.OpenSearch};const sigV4AuthMethod=exports.sigV4AuthMethod={name:_data_sources.AuthType.SigV4,credentialSourceOption:sigV4CredentialOption,credentialFormField:sigV4CredentialField};const credentialSourceOptions=exports.credentialSourceOptions=[noAuthCredentialOption,usernamePasswordCredentialOption,sigV4CredentialOption]},2100:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.createAppNavigationHandler=void 0;var _opensearch_dashboards_services=__webpack_require__(166);const createAppNavigationHandler=targetUrl=>event=>{if(event.altKey||event.metaKey||event.ctrlKey){return}const{application:application,addBasePath:addBasePath}=(0,_opensearch_dashboards_services.getServices)();event.preventDefault();application.navigateToUrl(addBasePath(targetUrl))};exports.createAppNavigationHandler=createAppNavigationHandler},2101:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.DataSourceManagementPlugin=exports.DSM_APP_ID=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _common=__webpack_require__(2524);var _create_data_source_selector=__webpack_require__(2525);var _data_source_column=__webpack_require__(2541);var _auth_registry=__webpack_require__(2542);var _types=__webpack_require__(2094);var _create_data_source_menu=__webpack_require__(2193);var _utils=__webpack_require__(2091);var _data_source_selection_service=__webpack_require__(2138);const DSM_APP_ID=exports.DSM_APP_ID="dataSources";class DataSourceManagementPlugin{constructor(){(0,_defineProperty2.default)(this,"started",false);(0,_defineProperty2.default)(this,"authMethodsRegistry",new _auth_registry.AuthenticationMethodRegistry);(0,_defineProperty2.default)(this,"dataSourceSelection",new _data_source_selection_service.DataSourceSelectionService)}setup(core,_ref){let{management:management,indexPatternManagement:indexPatternManagement,dataSource:dataSource}=_ref;const opensearchDashboardsSection=management.sections.section.opensearchDashboards;const uiSettings=core.uiSettings;if(!opensearchDashboardsSection){throw new Error("`opensearchDashboards` management section not found.")}const savedObjectPromise=core.getStartServices().then(_ref2=>{let[coreStart]=_ref2;return coreStart.savedObjects});const column=new _data_source_column.DataSourceColumn(savedObjectPromise);indexPatternManagement.columns.register(column);opensearchDashboardsSection.registerApp({id:DSM_APP_ID,title:_common.PLUGIN_NAME,order:1,mount:async params=>{const{mountManagementSection:mountManagementSection}=await __webpack_require__.e(8).then(__webpack_require__.t.bind(null,2686,7));return mountManagementSection(core.getStartServices,params,this.authMethodsRegistry)}});const registerAuthenticationMethod=authMethod=>{if(this.started){throw new Error("cannot call `registerAuthenticationMethod` after data source management startup.")}this.authMethodsRegistry.registerAuthenticationMethod(authMethod)};if(dataSource.noAuthenticationTypeEnabled){registerAuthenticationMethod(_types.noAuthCredentialAuthMethod)}if(dataSource.usernamePasswordAuthEnabled){registerAuthenticationMethod(_types.usernamePasswordAuthMethod)}if(dataSource.awsSigV4AuthEnabled){registerAuthenticationMethod(_types.sigV4AuthMethod)}(0,_utils.setHideLocalCluster)({enabled:dataSource.hideLocalCluster});(0,_utils.setUiSettings)(uiSettings);(0,_utils.setDataSourceSelection)(this.dataSourceSelection);return{registerAuthenticationMethod:registerAuthenticationMethod,dataSourceSelection:this.dataSourceSelection,ui:{DataSourceSelector:(0,_create_data_source_selector.createDataSourceSelector)(uiSettings,dataSource),getDataSourceMenu:()=>(0,_create_data_source_menu.createDataSourceMenu)()},getDefaultDataSourceId:_utils.getDefaultDataSourceId,getDefaultDataSourceId$:_utils.getDefaultDataSourceId$}}start(core){this.started=true;(0,_utils.setApplication)(core.application);return{getAuthenticationMethodRegistry:()=>this.authMethodsRegistry}}stop(){}}exports.DataSourceManagementPlugin=DataSourceManagementPlugin},2102:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"DataSourceItem",{enumerable:true,get:function(){return _data_source_item.DataSourceItem}});var _data_source_item=__webpack_require__(2531)},2103:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"DataSourceDropDownHeader",{enumerable:true,get:function(){return _drop_down_header.DataSourceDropDownHeader}});var _drop_down_header=__webpack_require__(2567)},2109:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.Synopsis=Synopsis;var _react=_interopRequireDefault(__webpack_require__(2));var _classnames=_interopRequireDefault(__webpack_require__(28));var _eui=__webpack_require__(6);function Synopsis(_ref){let{id:id,description:description,iconUrl:iconUrl,iconType:iconType,title:title,url:url,wrapInPanel:wrapInPanel,onClick:onClick,isBeta:isBeta}=_ref;let optionalImg;if(iconUrl){optionalImg=_react.default.createElement("img",{alt:"",className:"synopsisIcon",src:iconUrl})}else if(iconType){optionalImg=_react.default.createElement(_eui.EuiIcon,{color:"text",size:"l",title:"",type:iconType})}const classes=(0,_classnames.default)("homSynopsis__card",{"homSynopsis__card--noPanel":!wrapInPanel});return _react.default.createElement(_eui.EuiCard,{className:classes,layout:"horizontal",icon:optionalImg,titleSize:"xs",title:title,description:description,onClick:onClick,href:url,"data-test-subj":"homeSynopsisLink".concat(id.toLowerCase()),betaBadgeLabel:isBeta?"Beta":null,titleElement:"h3"})}Synopsis.defaultProps={isBeta:false}},2110:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.NO_DATASOURCES_CONNECTED_MESSAGE=exports.NO_COMPATIBLE_DATASOURCES_MESSAGE=exports.LocalCluster=exports.DEFAULT_DATA_SOURCE_UI_SETTINGS_ID=exports.CONNECT_DATASOURCES_MESSAGE=exports.ADD_COMPATIBLE_DATASOURCES_MESSAGE=void 0;var _i18n=__webpack_require__(3);const LocalCluster=exports.LocalCluster={label:_i18n.i18n.translate("dataSource.localCluster",{defaultMessage:"Local cluster"}),id:""};const NO_DATASOURCES_CONNECTED_MESSAGE=exports.NO_DATASOURCES_CONNECTED_MESSAGE="No data sources connected yet.";const CONNECT_DATASOURCES_MESSAGE=exports.CONNECT_DATASOURCES_MESSAGE="Connect your data sources to get started.";const NO_COMPATIBLE_DATASOURCES_MESSAGE=exports.NO_COMPATIBLE_DATASOURCES_MESSAGE="No compatible data sources are available.";const ADD_COMPATIBLE_DATASOURCES_MESSAGE=exports.ADD_COMPATIBLE_DATASOURCES_MESSAGE="Add a compatible data source.";const DEFAULT_DATA_SOURCE_UI_SETTINGS_ID=exports.DEFAULT_DATA_SOURCE_UI_SETTINGS_ID="defaultDataSource"},2111:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"DataSourceErrorMenu",{enumerable:true,get:function(){return _data_source_error_menu.DataSourceErrorMenu}});var _data_source_error_menu=__webpack_require__(2579)},2137:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.LocalCluster=exports.DataSourceSelector=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _react=_interopRequireDefault(__webpack_require__(2));var _i18n=__webpack_require__(3);var _eui=__webpack_require__(6);var _utils=__webpack_require__(2091);var _data_source_item=__webpack_require__(2102);__webpack_require__(2532);function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter((function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable}))),t.push.apply(t,o)}return t}function _objectSpread(e){for(var r=1;r<arguments.length;r++){var t=null!=arguments[r]?arguments[r]:{};r%2?ownKeys(Object(t),!0).forEach((function(r){(0,_defineProperty2.default)(e,r,t[r])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach((function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r))}))}return e}const LocalCluster=exports.LocalCluster={label:_i18n.i18n.translate("dataSource.localCluster",{defaultMessage:"Local cluster"}),id:""};class DataSourceSelector extends _react.default.Component{constructor(props){super(props);(0,_defineProperty2.default)(this,"_isMounted",false);this.state={allDataSources:[],defaultDataSource:"",selectedOption:this.props.hideLocalCluster?[]:[LocalCluster],dataSourceOptions:[],componentId:(0,_utils.generateComponentId)()}}componentWillUnmount(){this._isMounted=false;(0,_utils.getDataSourceSelection)().remove(this.state.componentId)}onSelectedDataSource(dataSource){(0,_utils.getDataSourceSelection)().selectDataSource(this.state.componentId,dataSource);this.props.onSelectedDataSource(dataSource)}handleSelectedOption(dataSourceOptions,allDataSources,defaultDataSource){const[{id:id}]=this.props.defaultOption;const dataSource=dataSourceOptions.find(ds=>ds.id===id);const selectedOption=dataSource?[{id:id,label:dataSource.label}]:[];if(!dataSource){this.props.notifications.addWarning(_i18n.i18n.translate("dataSource.fetchDataSourceError",{defaultMessage:"Data source with id is not available"}))}this.setState(_objectSpread(_objectSpread({},this.state),{},{dataSourceOptions:dataSourceOptions,selectedOption:selectedOption,defaultDataSource:defaultDataSource,allDataSources:allDataSources}));this.onSelectedDataSource(selectedOption)}handleDefaultDataSource(dataSourceOptions,allDataSources,defaultDataSource){const selectedDataSource=(0,_utils.getDefaultDataSource)(dataSourceOptions,LocalCluster,defaultDataSource,this.props.hideLocalCluster);if(selectedDataSource.length===0){this.props.notifications.addWarning("No connected data source available.");this.onSelectedDataSource([]);return}this.setState(_objectSpread(_objectSpread({},this.state),{},{dataSourceOptions:dataSourceOptions,selectedOption:selectedDataSource,defaultDataSource:defaultDataSource,allDataSources:allDataSources}));this.onSelectedDataSource(selectedDataSource)}async componentDidMount(){this._isMounted=true;try{var _getDefaultDataSource,_this$props$defaultOp,_this$props$defaultOp2;const fetchedDataSources=await(0,_utils.getDataSourcesWithFields)(this.props.savedObjectsClient,["id","title","auth.type"]);const dataSourceOptions=(0,_utils.getFilteredDataSources)(fetchedDataSources,this.props.dataSourceFilter);if(!this.props.hideLocalCluster){dataSourceOptions.unshift(LocalCluster)}if(!dataSourceOptions.length){this.props.notifications.addWarning("No connected data source available.");this.onSelectedDataSource([]);return}const defaultDataSource=(_getDefaultDataSource=(0,_utils.getDefaultDataSourceId)(this.props.uiSettings))!==null&&_getDefaultDataSource!==void 0?_getDefaultDataSource:null;if(((_this$props$defaultOp=this.props.defaultOption)===null||_this$props$defaultOp===void 0?void 0:_this$props$defaultOp.length)===0){this.setState(_objectSpread(_objectSpread({},this.state),{},{dataSourceOptions:dataSourceOptions,selectedOption:[],defaultDataSource:defaultDataSource,allDataSources:fetchedDataSources}));return}if((_this$props$defaultOp2=this.props.defaultOption)!==null&&_this$props$defaultOp2!==void 0&&_this$props$defaultOp2.length){this.handleSelectedOption(dataSourceOptions,fetchedDataSources,defaultDataSource);return}this.handleDefaultDataSource(dataSourceOptions,fetchedDataSources,defaultDataSource)}catch(err){this.props.notifications.addWarning(_i18n.i18n.translate("dataSource.fetchDataSourceError",{defaultMessage:"Unable to fetch existing data sources"}))}}onChange(e){if(!this._isMounted)return;this.setState({selectedOption:e});this.onSelectedDataSource(e)}render(){const placeholderText=this.props.placeholderText===undefined?"Select a data source":this.props.placeholderText;const options=(0,_utils.getFilteredDataSources)(this.state.allDataSources,this.props.dataSourceFilter);if(!this.props.hideLocalCluster){options.unshift(LocalCluster)}return _react.default.createElement(_eui.EuiComboBox,{isClearable:this.props.isClearable,"aria-label":placeholderText?_i18n.i18n.translate("dataSourceSelectorComboBoxAriaLabel",{defaultMessage:placeholderText}):"dataSourceSelectorCombobox",placeholder:placeholderText?_i18n.i18n.translate("dataSourceSelectorComboBoxPlaceholder",{defaultMessage:placeholderText}):"",singleSelection:{asPlainText:true},options:options,selectedOptions:this.state.selectedOption,onChange:e=>this.onChange(e),prepend:this.props.removePrepend?undefined:_i18n.i18n.translate("dataSourceSelectorComboBoxPrepend",{defaultMessage:"Data source"}),compressed:this.props.compressed||false,isDisabled:this.props.disabled,fullWidth:this.props.fullWidth||false,"data-test-subj":"dataSourceSelectorComboBox",renderOption:option=>_react.default.createElement(_data_source_item.DataSourceItem,{className:"dataSourceSelector",option:option,defaultDataSource:this.state.defaultDataSource})})}}exports.DataSourceSelector=DataSourceSelector},2138:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.defaultDataSourceSelection=exports.DataSourceSelectionService=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _rxjs=__webpack_require__(12);class DataSourceSelectionService{constructor(){(0,_defineProperty2.default)(this,"selectedDataSource$",new _rxjs.BehaviorSubject(new Map));(0,_defineProperty2.default)(this,"removedComponentIds",[]);(0,_defineProperty2.default)(this,"selectDataSource",(componentId,dataSource)=>{if(this.removedComponentIds.indexOf(componentId)>-1){return}const newMap=new Map(this.selectedDataSource$.value);newMap.set(componentId,dataSource);this.selectedDataSource$.next(newMap)});(0,_defineProperty2.default)(this,"remove",componentId=>{this.removedComponentIds.push(componentId);const newMap=new Map(this.selectedDataSource$.value);newMap.delete(componentId);this.selectedDataSource$.next(newMap)});(0,_defineProperty2.default)(this,"getSelectionValue",()=>this.selectedDataSource$.value);(0,_defineProperty2.default)(this,"getSelection$",()=>this.selectedDataSource$)}}exports.DataSourceSelectionService=DataSourceSelectionService;const defaultDataSourceSelection=exports.defaultDataSourceSelection={selectDataSource:()=>{},remove:()=>{},getSelectionValue:()=>{},getSelection$:()=>{}}},2139:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"NoDataSource",{enumerable:true,get:function(){return _no_data_source.NoDataSource}});var _no_data_source=__webpack_require__(2546)},2140:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.DataSourceMenuPopoverButton=void 0;var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);var _i18n=__webpack_require__(3);const DataSourceMenuPopoverButton=_ref=>{let{className:className,label:label,onClick:onClick}=_ref;return _react.default.createElement(_react.default.Fragment,null,_react.default.createElement(_eui.EuiButtonEmpty,{className:"dataSourceComponentButtonTitle","data-test-subj":"".concat(className,"Button"),onClick:onClick,"aria-label":_i18n.i18n.translate("".concat(className,".dataSourceOptionsViewAriaLabel"),{defaultMessage:"".concat(className,"Button")}),iconType:"database",iconSide:"left",size:"s"},label?label:null))};exports.DataSourceMenuPopoverButton=DataSourceMenuPopoverButton},2141:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.Content=Content;var _react=_interopRequireDefault(__webpack_require__(2));var _public=__webpack_require__(18);const whiteListedRules=["backticks","emphasis","link","list"];const allowListedRules=["backticks","emphasis","link","list"];function Content(_ref){let{text:text}=_ref;return _react.default.createElement(_public.Markdown,{className:"euiText",markdown:text,openLinksInNewTab:true,whiteListedRules:whiteListedRules,allowListedRules:allowListedRules})}},2189:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.Welcome=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _react=_interopRequireWildcard(__webpack_require__(2));var _eui=__webpack_require__(6);var _analytics=__webpack_require__(117);var _react2=__webpack_require__(13);var _opensearch_dashboards_services=__webpack_require__(166);var _sample_data=__webpack_require__(2511);function _getRequireWildcardCache(e){if("function"!=typeof WeakMap)return null;var r=new WeakMap,t=new WeakMap;return(_getRequireWildcardCache=function(e){return e?t:r})(e)}function _interopRequireWildcard(e,r){if(!r&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var t=_getRequireWildcardCache(r);if(t&&t.has(e))return t.get(e);var n={__proto__:null},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var u in e)if("default"!==u&&Object.prototype.hasOwnProperty.call(e,u)){var i=a?Object.getOwnPropertyDescriptor(e,u):null;i&&(i.get||i.set)?Object.defineProperty(n,u,i):n[u]=e[u]}return n.default=e,t&&t.set(e,n),n}class Welcome extends _react.default.Component{constructor(){super(...arguments);(0,_defineProperty2.default)(this,"services",(0,_opensearch_dashboards_services.getServices)());(0,_defineProperty2.default)(this,"hideOnEsc",e=>{if(e.key==="Escape"){this.props.onSkip()}});(0,_defineProperty2.default)(this,"onSampleDataDecline",()=>{this.services.trackUiMetric(_analytics.METRIC_TYPE.CLICK,"sampleDataDecline");this.props.onSkip()});(0,_defineProperty2.default)(this,"onSampleDataConfirm",()=>{this.services.trackUiMetric(_analytics.METRIC_TYPE.CLICK,"sampleDataConfirm");this.redirecToAddData()});(0,_defineProperty2.default)(this,"renderTelemetryEnabledOrDisabledText",()=>{const{telemetry:telemetry}=this.props;if(!telemetry||!telemetry.telemetryService.userCanChangeSettings){return null}const isOptedIn=telemetry.telemetryService.getIsOptedIn();if(isOptedIn){return _react.default.createElement(_react.Fragment,null,_react.default.createElement(_react2.FormattedMessage,{id:"home.dataManagementDisableCollection",defaultMessage:" To stop collection, "}),_react.default.createElement(_eui.EuiLink,{href:this.services.addBasePath("management/opensearch-dashboards/settings")},_react.default.createElement(_react2.FormattedMessage,{id:"home.dataManagementDisableCollectionLink",defaultMessage:"disable usage data here."})))}else{return _react.default.createElement(_react.Fragment,null,_react.default.createElement(_react2.FormattedMessage,{id:"home.dataManagementEnableCollection",defaultMessage:" To start collection, "}),_react.default.createElement(_eui.EuiLink,{href:this.services.addBasePath("management/opensearch-dashboards/settings")},_react.default.createElement(_react2.FormattedMessage,{id:"home.dataManagementEnableCollectionLink",defaultMessage:"enable usage data here."})))}});(0,_defineProperty2.default)(this,"applicationTitle",this.props.branding.applicationTitle);(0,_defineProperty2.default)(this,"renderWelcomeLogo",()=>{const{url:centerMarkURL,type:centerMarkType}=this.props.logos.CenterMark;if(centerMarkType==="custom"){return _react.default.createElement("div",{className:"homWelcome__customLogoContainer"},_react.default.createElement("img",{className:"homWelcome__customLogo","data-test-subj":"welcomeCustomLogo","data-test-image-url":centerMarkURL,alt:this.applicationTitle+" logo",src:centerMarkURL}))}return _react.default.createElement("span",{className:"homWelcome__logo"},_react.default.createElement(_eui.EuiIcon,{type:centerMarkURL,size:"original"}))})}redirecToAddData(){const path=this.services.addBasePath("#/tutorial_directory");window.location.href=path}componentDidMount(){const{telemetry:telemetry}=this.props;this.services.trackUiMetric(_analytics.METRIC_TYPE.LOADED,"welcomeScreenMount");if(telemetry!==null&&telemetry!==void 0&&telemetry.telemetryService.userCanChangeSettings){telemetry.telemetryNotifications.setOptedInNoticeSeen()}document.addEventListener("keydown",this.hideOnEsc)}componentWillUnmount(){document.removeEventListener("keydown",this.hideOnEsc)}render(){const{urlBasePath:urlBasePath,telemetry:telemetry,branding:branding}=this.props;return _react.default.createElement(_eui.EuiPortal,null,_react.default.createElement("div",{className:"homWelcome"},_react.default.createElement("header",{className:"homWelcome__header"},_react.default.createElement("div",{className:"homWelcome__content eui-textCenter"},_react.default.createElement(_eui.EuiSpacer,{size:"xl"}),this.renderWelcomeLogo(),_react.default.createElement(_eui.EuiTitle,{size:"l",className:"homWelcome__title","data-test-subj":"welcomeCustomTitle","data-test-title-message":"Welcome to ".concat(branding.applicationTitle)},_react.default.createElement("h1",null,_react.default.createElement(_react2.FormattedMessage,{id:"home.welcomeTitle",defaultMessage:"Welcome to ".concat(branding.applicationTitle)}))),_react.default.createElement(_eui.EuiSpacer,{size:"m"}))),_react.default.createElement("div",{className:"homWelcome__content homWelcome-body"},_react.default.createElement(_eui.EuiFlexGroup,{gutterSize:"l"},_react.default.createElement(_eui.EuiFlexItem,null,_react.default.createElement(_sample_data.SampleDataCard,{urlBasePath:urlBasePath,onConfirm:this.onSampleDataConfirm,onDecline:this.onSampleDataDecline}),_react.default.createElement(_eui.EuiSpacer,{size:"s"}),!!telemetry&&_react.default.createElement(_react.Fragment,null,_react.default.createElement(_eui.EuiTextColor,{className:"euiText--small",color:"subdued"},_react.default.createElement(_react2.FormattedMessage,{id:"home.dataManagementDisclaimerPrivacy",defaultMessage:"To learn about how usage data helps us manage and improve our products and services, see our "}),_react.default.createElement(_eui.EuiLink,{href:telemetry.telemetryConstants.getPrivacyStatementUrl(),target:"_blank"},_react.default.createElement(_react2.FormattedMessage,{id:"home.dataManagementDisclaimerPrivacyLink",defaultMessage:"Privacy Statement."})),this.renderTelemetryEnabledOrDisabledText()),_react.default.createElement(_eui.EuiSpacer,{size:"xs"})))))))}}exports.Welcome=Welcome},2190:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.LazyRender=void 0;var _react=_interopRequireWildcard(__webpack_require__(2));function _getRequireWildcardCache(e){if("function"!=typeof WeakMap)return null;var r=new WeakMap,t=new WeakMap;return(_getRequireWildcardCache=function(e){return e?t:r})(e)}function _interopRequireWildcard(e,r){if(!r&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var t=_getRequireWildcardCache(r);if(t&&t.has(e))return t.get(e);var n={__proto__:null},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var u in e)if("default"!==u&&Object.prototype.hasOwnProperty.call(e,u)){var i=a?Object.getOwnPropertyDescriptor(e,u):null;i&&(i.get||i.set)?Object.defineProperty(n,u,i):n[u]=e[u]}return n.default=e,t&&t.set(e,n),n}const LazyRender=_ref=>{let{render:render}=_ref;const ref=(0,_react.useRef)(null);(0,_react.useEffect)(()=>{if(!ref.current){return}return render(ref.current)},[render]);return _react.default.createElement("div",{style:{display:"contents"},ref:ref})};exports.LazyRender=LazyRender},2191:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.getTutorial=getTutorial;exports.getTutorials=getTutorials;var _lodash=_interopRequireDefault(__webpack_require__(5));var _opensearch_dashboards_services=__webpack_require__(166);var _i18n=__webpack_require__(3);const baseUrl=(0,_opensearch_dashboards_services.getServices)().addBasePath("/api/opensearch-dashboards/home/tutorials");const headers=new Headers;headers.append("Accept","application/json");headers.append("Content-Type","application/json");headers.append("osd-xsrf","opensearchDashboards");let tutorials=[];let tutorialsLoaded=false;async function loadTutorials(){try{const response=await fetch(baseUrl,{method:"get",credentials:"include",headers:headers});if(response.status>=300){throw new Error(_i18n.i18n.translate("home.loadTutorials.requestFailedErrorMessage",{defaultMessage:"Request failed with status code: {status}",values:{status:response.status}}))}tutorials=await response.json();tutorialsLoaded=true}catch(err){(0,_opensearch_dashboards_services.getServices)().toastNotifications.addDanger({title:_i18n.i18n.translate("home.loadTutorials.unableToLoadErrorMessage",{defaultMessage:"Unable to load tutorials"}),text:err.message})}}async function getTutorials(){if(!tutorialsLoaded){await loadTutorials()}return _lodash.default.cloneDeep(tutorials)}async function getTutorial(id){if(!tutorialsLoaded){await loadTutorials()}const tutorial=tutorials.find(tutorial=>tutorial.id===id);if(tutorial){return _lodash.default.cloneDeep(tutorial)}}},2192:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _types=__webpack_require__(2526);Object.keys(_types).forEach((function(key){if(key==="default"||key==="__esModule")return;if(key in exports&&exports[key]===_types[key])return;Object.defineProperty(exports,key,{enumerable:true,get:function(){return _types[key]}})}))},2193:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.createDataSourceMenu=createDataSourceMenu;var _extends2=_interopRequireDefault(__webpack_require__(23));var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);var _data_source_menu=__webpack_require__(2194);var _public=__webpack_require__(18);var _utils=__webpack_require__(2091);function createDataSourceMenu(){const application=(0,_utils.getApplication)();const uiSettings=(0,_utils.getUiSettings)();const hideLocalCluster=(0,_utils.getHideLocalCluster)().enabled;return props=>{if(props.setMenuMountPoint){return _react.default.createElement(_public.MountPointPortal,{setMountPoint:props.setMenuMountPoint},_react.default.createElement(_eui.EuiHeaderLinks,{"data-test-subj":"top-nav",gutterSize:"xs"},_react.default.createElement(_data_source_menu.DataSourceMenu,(0,_extends2.default)({},props,{uiSettings:uiSettings,hideLocalCluster:hideLocalCluster,application:application}))))}return _react.default.createElement(_data_source_menu.DataSourceMenu,(0,_extends2.default)({},props,{uiSettings:uiSettings,hideLocalCluster:hideLocalCluster,application:application}))}}},2194:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.DataSourceMenu=DataSourceMenu;var _react=_interopRequireDefault(__webpack_require__(2));var _data_source_aggregated_view=__webpack_require__(2544);var _data_source_view=__webpack_require__(2589);var _data_source_multi_selectable=__webpack_require__(2600);var _types=__webpack_require__(2198);var _data_source_selectable=__webpack_require__(2612);function DataSourceMenu(props){const{componentType:componentType,componentConfig:componentConfig,uiSettings:uiSettings,hideLocalCluster:hideLocalCluster,application:application}=props;function renderDataSourceView(config){const{activeOption:activeOption,fullWidth:fullWidth,savedObjects:savedObjects,notifications:notifications,dataSourceFilter:dataSourceFilter,onSelectedDataSources:onSelectedDataSources}=config;return _react.default.createElement(_data_source_view.DataSourceView,{fullWidth:fullWidth,selectedOption:activeOption,savedObjectsClient:savedObjects,notifications:notifications===null||notifications===void 0?void 0:notifications.toasts,hideLocalCluster:hideLocalCluster||false,dataSourceFilter:dataSourceFilter,onSelectedDataSources:onSelectedDataSources,uiSettings:uiSettings,application:application})}function renderDataSourceMultiSelectable(config){const{fullWidth:fullWidth,savedObjects:savedObjects,notifications:notifications,onSelectedDataSources:onSelectedDataSources}=config;return _react.default.createElement(_data_source_multi_selectable.DataSourceMultiSelectable,{fullWidth:fullWidth,hideLocalCluster:hideLocalCluster||false,savedObjectsClient:savedObjects,notifications:notifications.toasts,onSelectedDataSources:onSelectedDataSources,uiSettings:uiSettings,application:application})}function renderDataSourceSelectable(config){const{onSelectedDataSources:onSelectedDataSources,disabled:disabled,activeOption:activeOption,fullWidth:fullWidth,savedObjects:savedObjects,notifications:notifications,dataSourceFilter:dataSourceFilter}=config;return _react.default.createElement(_data_source_selectable.DataSourceSelectable,{savedObjectsClient:savedObjects,notifications:notifications.toasts,onSelectedDataSources:onSelectedDataSources,disabled:disabled||false,selectedOption:activeOption&&activeOption.length>0?activeOption:undefined,dataSourceFilter:dataSourceFilter,hideLocalCluster:hideLocalCluster||false,fullWidth:fullWidth,uiSettings:uiSettings,application:application})}function renderDataSourceAggregatedView(config){const{fullWidth:fullWidth,activeDataSourceIds:activeDataSourceIds,displayAllCompatibleDataSources:displayAllCompatibleDataSources,savedObjects:savedObjects,notifications:notifications,dataSourceFilter:dataSourceFilter}=config;return _react.default.createElement(_data_source_aggregated_view.DataSourceAggregatedView,{fullWidth:fullWidth,hideLocalCluster:hideLocalCluster||false,savedObjectsClient:savedObjects,notifications:notifications.toasts,activeDataSourceIds:activeDataSourceIds,dataSourceFilter:dataSourceFilter,displayAllCompatibleDataSources:displayAllCompatibleDataSources,uiSettings:uiSettings,application:application})}function renderLayout(){switch(componentType){case _types.DataSourceComponentType.DataSourceAggregatedView:return renderDataSourceAggregatedView(componentConfig);case _types.DataSourceComponentType.DataSourceSelectable:return renderDataSourceSelectable(componentConfig);case _types.DataSourceComponentType.DataSourceView:return renderDataSourceView(componentConfig);case _types.DataSourceComponentType.DataSourceMultiSelectable:return renderDataSourceMultiSelectable(componentConfig);default:return null}}return renderLayout()}},2197:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"EmptyIcon",{enumerable:true,get:function(){return _empty_icon.EmptyIcon}});Object.defineProperty(exports,"ErrorIcon",{enumerable:true,get:function(){return _error_icon.ErrorIcon}});var _error_icon=__webpack_require__(2577);var _empty_icon=__webpack_require__(2578)},2198:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.DataSourceComponentType=void 0;const DataSourceComponentType=exports.DataSourceComponentType={DataSourceSelectable:"DataSourceSelectable",DataSourceView:"DataSourceView",DataSourceAggregatedView:"DataSourceAggregatedView",DataSourceMultiSelectable:"DataSourceMultiSelectable"}},2199:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.NO_DATA=exports.NOT_CHECKED=exports.HAS_DATA=exports.FETCHING=exports.ERROR=void 0;const HAS_DATA=exports.HAS_DATA="has_data";const FETCHING=exports.FETCHING="FETCHING";const NO_DATA=exports.NO_DATA="NO_DATA";const NOT_CHECKED=exports.NOT_CHECKED="NOT_CHECKED";const ERROR=exports.ERROR="ERROR"},2200:function(module,exports){module.exports="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIzMTAiIGhlaWdodD0iNDc3IiB2aWV3Qm94PSIwIDAgMzEwIDQ3NyI+CiAgPGcgZmlsbD0ibm9uZSIgZmlsbC1ydWxlPSJldmVub2RkIj4KICAgIDxwYXRoIGZpbGw9IiMxODE5MUUiIGZpbGwtcnVsZT0ibm9uemVybyIgZD0iTS04NC44MTkyLDQyOS4zNjIgQzc5LjMwOTMsNDI5LjM2MiAyMTIuMzYyLDI5Ni4zMDkgMjEyLjM2MiwxMzIuMTgxIEMyMTIuMzYyLC0zMS45NDc2IDc5LjMwOTMsLTE2NSAtODQuODE5MiwtMTY1IEMtMjQ4Ljk0OCwtMTY1IC0zODIsLTMxLjk0NzYgLTM4MiwxMzIuMTgxIEMtMzgyLDI5Ni4zMDkgLTI0OC45NDgsNDI5LjM2MiAtODQuODE5Miw0MjkuMzYyIFoiLz4KICAgIDxwYXRoIGZpbGw9IiMxNTE2MUIiIGQ9Ik0xOTEuNzY1LDIwOC42ODMgTDE5MS43NjUsMjIzLjM5NSBMMTc3LjA1MywyMjMuMzk1IEwxNzcuMDUzLDIwOC42ODMgTDE5MS43NjUsMjA4LjY4MyBaIE0yMzAuOTk3LDIwOC42ODMgTDIzMC45OTcsMjIzLjM5NSBMMjE2LjI4NSwyMjMuMzk1IEwyMTYuMjg1LDIwOC42ODMgTDIzMC45OTcsMjA4LjY4MyBaIE0xNTIuNTMzLDIwOC42ODMgTDE1Mi41MzMsMjIzLjM5NSBMMTM3LjgyMSwyMjMuMzk1IEwxMzcuODIxLDIwOC42ODMgTDE1Mi41MzMsMjA4LjY4MyBaIE0xMTMuMzAxLDIwOC42ODMgTDExMy4zMDEsMjIzLjM5NSBMOTguNTg5MywyMjMuMzk1IEw5OC41ODkzLDIwOC42ODMgTDExMy4zMDEsMjA4LjY4MyBaIE03NS4wNTA0LDIwOC42ODMgTDc1LjA1MDQsMjIzLjM5NSBMNjAuMzM4NSwyMjMuMzk1IEw2MC4zMzg1LDIwOC42ODMgTDc1LjA1MDQsMjA4LjY4MyBaIE0zNC44Mzc1LDIwOC42ODMgTDM0LjgzNzUsMjIzLjM5NSBMMjAuMTI1NiwyMjMuMzk1IEwyMC4xMjU2LDIwOC42ODMgTDM0LjgzNzUsMjA4LjY4MyBaIE0yMzAuOTk3LDE2OS40NTEgTDIzMC45OTcsMTg0LjE2MyBMMjE2LjI4NSwxODQuMTYzIEwyMTYuMjg1LDE2OS40NTEgTDIzMC45OTcsMTY5LjQ1MSBaIE0yNzAuMjI4LDE2OS40NTEgTDI3MC4yMjgsMTg0LjE2MyBMMjU1LjUxNiwxODQuMTYzIEwyNTUuNTE2LDE2OS40NTEgTDI3MC4yMjgsMTY5LjQ1MSBaIE0xOTEuNzY1LDE2OS40NTEgTDE5MS43NjUsMTg0LjE2MyBMMTc3LjA1MywxODQuMTYzIEwxNzcuMDUzLDE2OS40NTEgTDE5MS43NjUsMTY5LjQ1MSBaIE0xNTIuNTMzLDE2OS40NTEgTDE1Mi41MzMsMTg0LjE2MyBMMTM3LjgyMSwxODQuMTYzIEwxMzcuODIxLDE2OS40NTEgTDE1Mi41MzMsMTY5LjQ1MSBaIE0xMTQuMjgyLDE2OS40NTEgTDExNC4yODIsMTg0LjE2MyBMOTkuNTcwMSwxODQuMTYzIEw5OS41NzAxLDE2OS40NTEgTDExNC4yODIsMTY5LjQ1MSBaIE03NC4wNjk3LDE2OS40NTEgTDc0LjA2OTcsMTg0LjE2MyBMNTkuMzU3OCwxODQuMTYzIEw1OS4zNTc4LDE2OS40NTEgTDc0LjA2OTcsMTY5LjQ1MSBaIE0zMy44NTY4LDE2OS40NTEgTDMzLjg1NjgsMTg0LjE2MyBMMTkuMTQ0OSwxODQuMTYzIEwxOS4xNDQ5LDE2OS40NTEgTDMzLjg1NjgsMTY5LjQ1MSBaIE0yNzAuMjI4LDEzMC4yMTkgTDI3MC4yMjgsMTQ0LjkzMSBMMjU1LjUxNiwxNDQuOTMxIEwyNTUuNTE2LDEzMC4yMTkgTDI3MC4yMjgsMTMwLjIxOSBaIE0zMDkuNDYsMTMwLjIxOSBMMzA5LjQ2LDE0NC45MzEgTDI5NC43NDgsMTQ0LjkzMSBMMjk0Ljc0OCwxMzAuMjE5IEwzMDkuNDYsMTMwLjIxOSBaIE0yMzAuOTk3LDEzMC4yMTkgTDIzMC45OTcsMTQ0LjkzMSBMMjE2LjI4NSwxNDQuOTMxIEwyMTYuMjg1LDEzMC4yMTkgTDIzMC45OTcsMTMwLjIxOSBaIE0xOTEuNzY1LDEzMC4yMTkgTDE5MS43NjUsMTQ0LjkzMSBMMTc3LjA1MywxNDQuOTMxIEwxNzcuMDUzLDEzMC4yMTkgTDE5MS43NjUsMTMwLjIxOSBaIE0xNTMuNTE0LDEzMC4yMTkgTDE1My41MTQsMTQ0LjkzMSBMMTM4LjgwMiwxNDQuOTMxIEwxMzguODAyLDEzMC4yMTkgTDE1My41MTQsMTMwLjIxOSBaIE0xMTMuMzAxLDEzMC4yMTkgTDExMy4zMDEsMTQ0LjkzMSBMOTguNTg5MywxNDQuOTMxIEw5OC41ODkzLDEzMC4yMTkgTDExMy4zMDEsMTMwLjIxOSBaIE03My4wODg5LDEzMC4yMTkgTDczLjA4ODksMTQ0LjkzMSBMNTguMzc2OSwxNDQuOTMxIEw1OC4zNzY5LDEzMC4yMTkgTDczLjA4ODksMTMwLjIxOSBaIE0zNS44MTg0LDEzMC4yMTkgTDM1LjgxODQsMTQ0LjkzMSBMMjEuMTA2NCwxNDQuOTMxIEwyMS4xMDY0LDEzMC4yMTkgTDM1LjgxODQsMTMwLjIxOSBaIi8+CiAgICA8cGF0aCBmaWxsPSIjMTgxOTFFIiBmaWxsLXJ1bGU9Im5vbnplcm8iIGQ9Ik02NS45MDgxLDQzMC45MDggQzc2LjQ1MjMsNDIwLjM2NCA5My41NDc3LDQyMC4zNjQgMTA0LjA5Miw0MzAuOTA4IEMxMTQuNjM2LDQ0MS40NTIgMTE0LjYzNiw0NTguNTQ4IDEwNC4wOTIsNDY5LjA5MiBDOTMuNTQ3Nyw0NzkuNjM2IDc2LjQ1MjMsNDc5LjYzNiA2NS45MDgxLDQ2OS4wOTIgQzU1LjM2NCw0NTguNTQ4IDU1LjM2NCw0NDEuNDUyIDY1LjkwODEsNDMwLjkwOCBaIE05Ni4zMTM3LDQzOC42ODYgQzkwLjA2NTMsNDMyLjQzOCA3OS45MzQ3LDQzMi40MzggNzMuNjg2Myw0MzguNjg2IEM2Ny40Mzc5LDQ0NC45MzUgNjcuNDM3OSw0NTUuMDY1IDczLjY4NjMsNDYxLjMxNCBDNzkuOTM0Nyw0NjcuNTYyIDkwLjA2NTMsNDY3LjU2MiA5Ni4zMTM3LDQ2MS4zMTQgQzEwMi41NjIsNDU1LjA2NSAxMDIuNTYyLDQ0NC45MzUgOTYuMzEzNyw0MzguNjg2IFoiLz4KICAgIDxwYXRoIGZpbGw9IiMxNTE2MUIiIGZpbGwtcnVsZT0ibm9uemVybyIgZD0iTTY1LjkwODIsNDMwLjkwOCBDNTUuMzY0LDQ0MS40NTIgNTUuMzY0LDQ1OC41NDggNjUuOTA4Miw0NjkuMDkyIEw3My42ODY0LDQ2MS4zMTQgQzY3LjQzOCw0NTUuMDY1IDY3LjQzOCw0NDQuOTM1IDczLjY4NjQsNDM4LjY4NiBMNjUuOTA4Miw0MzAuOTA4IFoiLz4KICA8L2c+Cjwvc3ZnPgo="},2201:function(module,exports){module.exports="data:image/svg+xml;base64,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"},2202:function(module,exports){module.exports="data:image/svg+xml;base64,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"},2203:function(module,exports){module.exports="data:image/svg+xml;base64,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"},2499:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.renderImportSampleDataApp=exports.renderApp=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _react=_interopRequireDefault(__webpack_require__(2));var _reactDom=__webpack_require__(17);var _i18n=__webpack_require__(3);var _public=__webpack_require__(18);var _home_app=__webpack_require__(2500);var _opensearch_dashboards_services=__webpack_require__(166);__webpack_require__(2645);function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter((function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable}))),t.push.apply(t,o)}return t}function _objectSpread(e){for(var r=1;r<arguments.length;r++){var t=null!=arguments[r]?arguments[r]:{};r%2?ownKeys(Object(t),!0).forEach((function(r){(0,_defineProperty2.default)(e,r,t[r])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach((function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r))}))}return e}const renderApp=async(element,coreStart,history)=>{const homeTitle=_i18n.i18n.translate("home.breadcrumbs.homeTitle",{defaultMessage:"Home"});const{featureCatalogue:featureCatalogue,chrome:chrome}=(0,_opensearch_dashboards_services.getServices)();const navLinks=chrome.navLinks.getAll();const directories=featureCatalogue.get();const solutions=featureCatalogue.getSolutions().filter(_ref=>{let{id:id}=_ref;return navLinks.find(_ref2=>{let{category:category,hidden:hidden}=_ref2;return!hidden&&(category===null||category===void 0?void 0:category.id)===id})});chrome.setBreadcrumbs([{text:homeTitle}]);const unlisten=history.listen(location=>{window.dispatchEvent(new HashChangeEvent("hashchange"))});(0,_reactDom.render)(_react.default.createElement(_public.OpenSearchDashboardsContextProvider,{services:_objectSpread({},coreStart)},_react.default.createElement(_home_app.HomeApp,{directories:directories,solutions:solutions})),element);return()=>{(0,_reactDom.unmountComponentAtNode)(element);unlisten()}};exports.renderApp=renderApp;const renderImportSampleDataApp=async(element,coreStart)=>{(0,_reactDom.render)(_react.default.createElement(_public.OpenSearchDashboardsContextProvider,{services:_objectSpread({},coreStart)},_react.default.createElement(_home_app.ImportSampleDataApp,null)),element);return()=>{(0,_reactDom.unmountComponentAtNode)(element)}};exports.renderImportSampleDataApp=renderImportSampleDataApp},2500:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.HomeApp=HomeApp;exports.ImportSampleDataApp=ImportSampleDataApp;var _react=_interopRequireDefault(__webpack_require__(2));var _react2=__webpack_require__(13);var _home=__webpack_require__(2501);var _homepage=__webpack_require__(2512);var _feature_directory=__webpack_require__(2517);var _tutorial_directory=__webpack_require__(2518);var _tutorial=__webpack_require__(2634);var _reactRouterDom=__webpack_require__(77);var _load_tutorials=__webpack_require__(2191);var _replace_template_strings=__webpack_require__(2643);var _opensearch_dashboards_services=__webpack_require__(166);var _reactUse=__webpack_require__(631);var _constants=__webpack_require__(637);const RedirectToDefaultApp=()=>{(0,_reactUse.useMount)(()=>{const{urlForwarding:urlForwarding}=(0,_opensearch_dashboards_services.getServices)();urlForwarding.navigateToDefaultApp()});return null};const renderTutorialDirectory=props=>{const{addBasePath:addBasePath,environmentService:environmentService}=(0,_opensearch_dashboards_services.getServices)();const environment=environmentService.getEnvironment();const isCloudEnabled=environment.cloud;return _react.default.createElement(_tutorial_directory.TutorialDirectory,{addBasePath:addBasePath,openTab:props.match.params.tab,isCloudEnabled:isCloudEnabled,withoutHomeBreadCrumb:props.withoutHomeBreadCrumb})};function ImportSampleDataApp(){return _react.default.createElement(_react2.I18nProvider,null,renderTutorialDirectory({match:{params:{tab:"sampleData"}},withoutHomeBreadCrumb:true}))}function HomeApp(_ref){let{directories:directories,solutions:solutions}=_ref;const{savedObjectsClient:savedObjectsClient,getBasePath:getBasePath,addBasePath:addBasePath,environmentService:environmentService,telemetry:telemetry,uiSettings:uiSettings}=(0,_opensearch_dashboards_services.getServices)();const environment=environmentService.getEnvironment();const isCloudEnabled=environment.cloud;const renderTutorial=props=>_react.default.createElement(_tutorial.Tutorial,{addBasePath:addBasePath,isCloudEnabled:isCloudEnabled,getTutorial:_load_tutorials.getTutorial,replaceTemplateStrings:_replace_template_strings.replaceTemplateStrings,tutorialId:props.match.params.id,bulkCreate:savedObjectsClient.bulkCreate});const legacyHome=_react.default.createElement(_home.Home,{addBasePath:addBasePath,directories:directories,solutions:solutions,find:savedObjectsClient.find,localStorage:localStorage,urlBasePath:getBasePath(),telemetry:telemetry});const homepage=_react.default.createElement(_homepage.Homepage,null);return _react.default.createElement(_react2.I18nProvider,null,_react.default.createElement(_reactRouterDom.HashRouter,null,_react.default.createElement(_reactRouterDom.Switch,null,_react.default.createElement(_reactRouterDom.Route,{path:"/tutorial/:id",render:renderTutorial}),_react.default.createElement(_reactRouterDom.Route,{path:"/tutorial_directory/:tab?",render:renderTutorialDirectory}),_react.default.createElement(_reactRouterDom.Route,{exact:true,path:"/feature_directory"},_react.default.createElement(_feature_directory.FeatureDirectory,{addBasePath:addBasePath,directories:directories})),uiSettings.get(_constants.USE_NEW_HOME_PAGE)?_react.default.createElement(_react.default.Fragment,null,_react.default.createElement(_reactRouterDom.Route,{exact:true,path:"/legacy-home"},legacyHome),_react.default.createElement(_reactRouterDom.Route,{exact:true,path:"/"},homepage)):_react.default.createElement(_react.default.Fragment,null,_react.default.createElement(_reactRouterDom.Route,{exact:true,path:"/next-home"},homepage),_react.default.createElement(_reactRouterDom.Route,{exact:true,path:"/"},legacyHome)),_react.default.createElement(_reactRouterDom.Route,{path:"*",exact:true,component:RedirectToDefaultApp}))))}},2501:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.Home=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _react=_interopRequireWildcard(__webpack_require__(2));var _react2=__webpack_require__(13);var _eui=__webpack_require__(6);var _i18n=__webpack_require__(3);var _public=__webpack_require__(18);var _constants=__webpack_require__(637);var _services=__webpack_require__(268);var _opensearch_dashboards_services=__webpack_require__(166);var _add_data=__webpack_require__(2502);var _manage_data=__webpack_require__(2504);var _new_theme_modal=__webpack_require__(2506);var _solutions_section=__webpack_require__(2507);var _welcome=__webpack_require__(2189);function _getRequireWildcardCache(e){if("function"!=typeof WeakMap)return null;var r=new WeakMap,t=new WeakMap;return(_getRequireWildcardCache=function(e){return e?t:r})(e)}function _interopRequireWildcard(e,r){if(!r&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var t=_getRequireWildcardCache(r);if(t&&t.has(e))return t.get(e);var n={__proto__:null},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var u in e)if("default"!==u&&Object.prototype.hasOwnProperty.call(e,u)){var i=a?Object.getOwnPropertyDescriptor(e,u):null;i&&(i.get||i.set)?Object.defineProperty(n,u,i):n[u]=e[u]}return n.default=e,t&&t.set(e,n),n}function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter((function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable}))),t.push.apply(t,o)}return t}function _objectSpread(e){for(var r=1;r<arguments.length;r++){var t=null!=arguments[r]?arguments[r]:{};r%2?ownKeys(Object(t),!0).forEach((function(r){(0,_defineProperty2.default)(e,r,t[r])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach((function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r))}))}return e}const KEY_ENABLE_WELCOME="home:welcome:show";const KEY_ENABLE_NEW_THEME_MODAL="home:newThemeModal:show";class Home extends _react.Component{constructor(props){var _this;super(props);_this=this;(0,_defineProperty2.default)(this,"fetchIsNewOpenSearchDashboardsInstance",async()=>{try{setTimeout(()=>{if(this.state.isLoading){this.setState({isWelcomeEnabled:false})}},500);const resp=await this.props.find({type:"index-pattern",fields:["title"],search:"*",search_fields:["title"],perPage:1});this.endLoading({isNewOpenSearchDashboardsInstance:resp.total===0})}catch(err){this.endLoading()}});(0,_defineProperty2.default)(this,"endLoading",(function(){let state=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};if(_this._isMounted){_this.setState(_objectSpread(_objectSpread({},state),{},{isLoading:false}))}}));(0,_defineProperty2.default)(this,"skipWelcome",()=>{this.props.localStorage.setItem(KEY_ENABLE_WELCOME,"false");this._isMounted&&this.setState({isWelcomeEnabled:false})});(0,_defineProperty2.default)(this,"dismissNewThemeModal",()=>{this.props.localStorage.setItem(KEY_ENABLE_NEW_THEME_MODAL,"false");this._isMounted&&this.setState({isNewThemeModalEnabled:false})});(0,_defineProperty2.default)(this,"onCloseNewThemeModal",()=>{this.dismissNewThemeModal()});(0,_defineProperty2.default)(this,"findDirectoryById",id=>this.props.directories.find(directory=>directory.id===id));(0,_defineProperty2.default)(this,"getFeaturesByCategory",category=>this.props.directories.filter(directory=>directory.showOnHomePage&&directory.category===category).sort((directoryA,directoryB)=>directoryA.order-directoryB.order));const isWelcomeEnabled=!((0,_opensearch_dashboards_services.getServices)().homeConfig.disableWelcomeScreen||props.localStorage.getItem(KEY_ENABLE_WELCOME)==="false");const isNewThemeModalEnabled=!((0,_opensearch_dashboards_services.getServices)().uiSettings.get("theme:version")==="v7"||(0,_opensearch_dashboards_services.getServices)().homeConfig.disableNewThemeModal||props.localStorage.getItem(KEY_ENABLE_NEW_THEME_MODAL)==="false");const body=document.querySelector("body");body.classList.add("isHomPage");this.state={isLoading:isWelcomeEnabled,isNewOpenSearchDashboardsInstance:false,isWelcomeEnabled:isWelcomeEnabled,isNewThemeModalEnabled:isNewThemeModalEnabled}}componentWillUnmount(){this._isMounted=false}componentDidMount(){this._isMounted=true;this.fetchIsNewOpenSearchDashboardsInstance();const homeTitle=_i18n.i18n.translate("home.breadcrumbs.homeTitle",{defaultMessage:"Home"});(0,_opensearch_dashboards_services.getServices)().chrome.setBreadcrumbs([{text:homeTitle}])}renderNormal(){const{addBasePath:addBasePath,solutions:solutions,directories:directories}=this.props;const{isNewThemeModalEnabled:isNewThemeModalEnabled}=this.state;const devTools=this.findDirectoryById("console");const addDataFeatures=this.getFeaturesByCategory(_services.FeatureCatalogueCategory.DATA);const manageDataFeatures=this.getFeaturesByCategory(_services.FeatureCatalogueCategory.ADMIN);if(manageDataFeatures.length<1&&devTools){manageDataFeatures.push(devTools)}return _react.default.createElement("main",{"aria-labelledby":"osdOverviewPageHeader__title",className:"homWrapper","data-test-subj":"homeApp"},_react.default.createElement(_public.OverviewPageHeader,{addBasePath:addBasePath,overlap:solutions.length,showDevToolsLink:true,showManagementLink:true,title:_react.default.createElement(_react2.FormattedMessage,{id:"home.header.title",defaultMessage:"Home"}),branding:(0,_opensearch_dashboards_services.getServices)().injectedMetadata.getBranding()}),_react.default.createElement("div",{className:"homContent"},solutions.length?_react.default.createElement(_solutions_section.SolutionsSection,{addBasePath:addBasePath,solutions:solutions,directories:directories,branding:(0,_opensearch_dashboards_services.getServices)().injectedMetadata.getBranding(),logos:(0,_opensearch_dashboards_services.getServices)().chrome.logos}):null,_react.default.createElement(_eui.EuiFlexGroup,{className:"homData ".concat(addDataFeatures.length===1&&manageDataFeatures.length===1?"homData--compressed":"homData--expanded")},_react.default.createElement(_eui.EuiFlexItem,null,_react.default.createElement(_add_data.AddData,{addBasePath:addBasePath,features:addDataFeatures})),_react.default.createElement(_eui.EuiFlexItem,null,_react.default.createElement(_manage_data.ManageData,{addBasePath:addBasePath,features:manageDataFeatures}))),_react.default.createElement(_eui.EuiHorizontalRule,{margin:"xl","aria-hidden":"true"}),isNewThemeModalEnabled&&_react.default.createElement(_new_theme_modal.NewThemeModal,{addBasePath:addBasePath,onClose:this.onCloseNewThemeModal}),_react.default.createElement(_public.OverviewPageFooter,{addBasePath:addBasePath,path:_constants.HOME_APP_BASE_PATH})))}renderLoading(){return""}renderWelcome(){return _react.default.createElement(_welcome.Welcome,{onSkip:this.skipWelcome,urlBasePath:this.props.urlBasePath,telemetry:this.props.telemetry,branding:(0,_opensearch_dashboards_services.getServices)().injectedMetadata.getBranding(),logos:(0,_opensearch_dashboards_services.getServices)().chrome.logos})}render(){const{isLoading:isLoading,isWelcomeEnabled:isWelcomeEnabled,isNewOpenSearchDashboardsInstance:isNewOpenSearchDashboardsInstance}=this.state;if(isWelcomeEnabled){if(isLoading){return this.renderLoading()}if(isNewOpenSearchDashboardsInstance){return this.renderWelcome()}}return this.renderNormal()}}exports.Home=Home},2502:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _add_data=__webpack_require__(2503);Object.keys(_add_data).forEach((function(key){if(key==="default"||key==="__esModule")return;if(key in exports&&exports[key]===_add_data[key])return;Object.defineProperty(exports,key,{enumerable:true,get:function(){return _add_data[key]}})}))},2503:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.AddData=void 0;var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);var _react2=__webpack_require__(13);var _app_navigation_handler=__webpack_require__(2100);var _synopsis=__webpack_require__(2109);const AddData=_ref=>{let{addBasePath:addBasePath,features:features}=_ref;return _react.default.createElement("section",{className:"homDataAdd","aria-labelledby":"homDataAdd__title"},_react.default.createElement(_eui.EuiFlexGroup,{alignItems:"center"},_react.default.createElement(_eui.EuiFlexItem,{grow:1},_react.default.createElement(_eui.EuiTitle,{size:"s"},_react.default.createElement("h2",{id:"homDataAdd__title"},_react.default.createElement(_react2.FormattedMessage,{id:"home.addData.sectionTitle",defaultMessage:"Ingest your data"}))))),_react.default.createElement(_eui.EuiSpacer,{size:"m"}),_react.default.createElement(_eui.EuiFlexGroup,{className:"homDataAdd__content"},features.map(feature=>_react.default.createElement(_eui.EuiFlexItem,{key:feature.id},_react.default.createElement(_synopsis.Synopsis,{id:feature.id,onClick:(0,_app_navigation_handler.createAppNavigationHandler)(feature.path),description:feature.description,iconType:feature.icon,title:feature.title,url:addBasePath(feature.path),wrapInPanel:true})))))};exports.AddData=AddData},2504:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _manage_data=__webpack_require__(2505);Object.keys(_manage_data).forEach((function(key){if(key==="default"||key==="__esModule")return;if(key in exports&&exports[key]===_manage_data[key])return;Object.defineProperty(exports,key,{enumerable:true,get:function(){return _manage_data[key]}})}))},2505:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.ManageData=void 0;var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);var _react2=__webpack_require__(13);var _app_navigation_handler=__webpack_require__(2100);var _synopsis=__webpack_require__(2109);const ManageData=_ref=>{let{addBasePath:addBasePath,features:features}=_ref;return _react.default.createElement(_react.default.Fragment,null,features.length>1&&_react.default.createElement(_eui.EuiHorizontalRule,{margin:"xl","aria-hidden":"true"}),features.length>0&&_react.default.createElement("section",{className:"homDataManage","aria-labelledby":"homDataManage__title","data-test-subj":"homDataManage"},_react.default.createElement(_eui.EuiTitle,{size:"s"},_react.default.createElement("h2",{id:"homDataManage__title"},_react.default.createElement(_react2.FormattedMessage,{id:"home.manageData.sectionTitle",defaultMessage:"Manage your data"}))),_react.default.createElement(_eui.EuiSpacer,{size:"m"}),_react.default.createElement(_eui.EuiFlexGroup,{className:"homDataManage__content"},features.map(feature=>_react.default.createElement(_eui.EuiFlexItem,{key:feature.id},_react.default.createElement(_synopsis.Synopsis,{id:feature.id,onClick:(0,_app_navigation_handler.createAppNavigationHandler)(feature.path),description:feature.description,iconType:feature.icon,title:feature.title,url:addBasePath(feature.path),wrapInPanel:true}))))))};exports.ManageData=ManageData},2506:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.NewThemeModal=void 0;var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);var _i18n=__webpack_require__(3);var _react2=__webpack_require__(13);var _public=__webpack_require__(18);const NewThemeModal=_ref=>{let{addBasePath:addBasePath,onClose:onClose}=_ref;const{services:{application:application}}=(0,_public.useOpenSearchDashboards)();return _react.default.createElement(_eui.EuiModal,{onClose:onClose},_react.default.createElement(_eui.EuiModalHeader,null,_react.default.createElement(_eui.EuiModalHeaderTitle,null,_react.default.createElement(_react2.FormattedMessage,{id:"home.newThemeModal.title",defaultMessage:"Introducing new OpenSearch Dashboards look & feel"}))),_react.default.createElement(_eui.EuiModalBody,null,_react.default.createElement(_public.RedirectAppLinks,{application:application},_react.default.createElement(_eui.EuiText,null,_react.default.createElement(_react2.FormattedMessage,{id:"home.newThemeModal.previewDescription.previewDetail",defaultMessage:"You are now previewing the newest OpenSearch Dashboards theme with improved light and dark modes. You or your administrator can change to the previous theme by visiting {advancedSettingsLink}.",values:{advancedSettingsLink:_react.default.createElement(_eui.EuiLink,{href:addBasePath("/app/management/opensearch-dashboards/settings#appearance")},_react.default.createElement(_react2.FormattedMessage,{id:"home.newThemeModal.previewDescription.advancedSettingsLinkText",defaultMessage:"Advanced Settings"}))}}))),_react.default.createElement(_eui.EuiSpacer,null),_react.default.createElement(_eui.EuiFlexGroup,{gutterSize:"s"},_react.default.createElement(_eui.EuiFlexItem,null,_react.default.createElement(_eui.EuiImage,{url:addBasePath("/plugins/home/assets/new_theme_light.png"),alt:_i18n.i18n.translate("home.newThemeModal.lightModeImageAltDescription",{defaultMessage:"screenshot of new theme in light mode"})})),_react.default.createElement(_eui.EuiFlexItem,null,_react.default.createElement(_eui.EuiImage,{url:addBasePath("/plugins/home/assets/new_theme_dark.png"),alt:_i18n.i18n.translate("home.newThemeModal.darkModeImageAltDescription",{defaultMessage:"screenshot of new theme in dark mode"})})))),_react.default.createElement(_eui.EuiModalFooter,null,_react.default.createElement(_eui.EuiButton,{onClick:onClose,fill:true},_react.default.createElement(_react2.FormattedMessage,{id:"home.newThemeModal.dismissButtonLabel",defaultMessage:"Dismiss"}))))};exports.NewThemeModal=NewThemeModal},2507:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _solutions_section=__webpack_require__(2508);Object.keys(_solutions_section).forEach((function(key){if(key==="default"||key==="__esModule")return;if(key in exports&&exports[key]===_solutions_section[key])return;Object.defineProperty(exports,key,{enumerable:true,get:function(){return _solutions_section[key]}})}))},2508:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.SolutionsSection=void 0;var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);var _react2=__webpack_require__(13);var _solution_panel=__webpack_require__(2509);const sortByOrder=(_ref,_ref2)=>{let{order:orderA=0}=_ref;let{order:orderB=0}=_ref2;return orderA-orderB};const SolutionsSection=_ref3=>{let{addBasePath:addBasePath,solutions:solutions,directories:directories,branding:branding,logos:logos}=_ref3;const opensearchDashboards=solutions.find(_ref4=>{let{id:id}=_ref4;return id==="opensearchDashboards"});const opensearchDashboardsApps=directories.filter(_ref5=>{let{solutionId:solutionId}=_ref5;return solutionId==="opensearchDashboards"}).sort(sortByOrder);solutions=solutions.sort(sortByOrder).filter(_ref6=>{let{id:id}=_ref6;return id!=="opensearchDashboards"});return _react.default.createElement(_react.default.Fragment,null,_react.default.createElement("section",{"aria-labelledby":"homSolutions__title",className:"homSolutions"},_react.default.createElement(_eui.EuiScreenReaderOnly,null,_react.default.createElement("h2",{id:"homSolutions__title"},_react.default.createElement(_react2.FormattedMessage,{id:"home.solutionsSection.sectionTitle",defaultMessage:"Pick your solution"}))),_react.default.createElement(_eui.EuiFlexGroup,{className:"homSolutions__content",justifyContent:"spaceAround"},solutions.length?_react.default.createElement(_eui.EuiFlexItem,{grow:1,className:"homSolutions__group homSolutions__group--multiple"},_react.default.createElement(_eui.EuiFlexGroup,{direction:"column"},solutions.map(solution=>_react.default.createElement(_solution_panel.SolutionPanel,{key:solution.id,solution:solution,addBasePath:addBasePath,branding:branding,logos:logos})))):null,opensearchDashboards?_react.default.createElement(_solution_panel.SolutionPanel,{solution:opensearchDashboards,addBasePath:addBasePath,apps:opensearchDashboardsApps.length?opensearchDashboardsApps:undefined,branding:branding,logos:logos}):null)),_react.default.createElement(_eui.EuiHorizontalRule,{margin:"xl","aria-hidden":"true"}))};exports.SolutionsSection=SolutionsSection},2509:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.SolutionPanel=void 0;var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);var _app_navigation_handler=__webpack_require__(2100);var _solution_title=__webpack_require__(2510);const getDescriptionText=description=>_react.default.createElement(_eui.EuiText,{size:"s",key:"".concat(description)},_react.default.createElement("p",null,description));const addSpacersBetweenElementsReducer=(acc,element,index,elements)=>{acc.push(element);if(index<elements.length-1){acc.push(_react.default.createElement(_eui.EuiSpacer,{key:"homeSolutionsPanel__UseCaseSpacer".concat(index),size:"m"}))}return acc};const getDescriptions=appDescriptions=>appDescriptions.map(getDescriptionText).reduce(addSpacersBetweenElementsReducer,[]);const SolutionPanel=_ref=>{let{addBasePath:addBasePath,solution:solution,apps:apps=[],branding:branding,logos:logos}=_ref;return _react.default.createElement(_eui.EuiFlexItem,{key:solution.id,"data-test-subj":"homSolutionPanel homSolutionPanel_".concat(solution.id),className:"".concat(solution.id==="opensearchDashboards"?"homSolutions__group homSolutions__group--single":""," homSolutions__item"),grow:1},_react.default.createElement("a",{className:"homSolutionPanel homSolutionPanel--".concat(solution.id),href:addBasePath(solution.path),onClick:(0,_app_navigation_handler.createAppNavigationHandler)(solution.path)},_react.default.createElement(_eui.EuiPanel,{className:"homSolutionPanel__inner",paddingSize:"none"},_react.default.createElement(_eui.EuiFlexGroup,{gutterSize:"none"},_react.default.createElement(_eui.EuiFlexItem,{grow:1,className:"homSolutionPanel__header"},_react.default.createElement(_solution_title.SolutionTitle,{iconType:solution.icon,title:solution.title,subtitle:solution.subtitle,branding:branding,logos:logos})),_react.default.createElement(_eui.EuiFlexItem,{grow:1,className:"homSolutionPanel__content"},getDescriptions(apps.length?apps.map(_ref2=>{let{subtitle:subtitle=""}=_ref2;return subtitle}):solution.appDescriptions))))))};exports.SolutionPanel=SolutionPanel},2510:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.SolutionTitle=void 0;var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);const SolutionTitle=_ref=>{let{subtitle:subtitle,branding:branding,logos:logos}=_ref;return _react.default.createElement(_eui.EuiFlexGroup,{gutterSize:"none",alignItems:"center"},_react.default.createElement(_eui.EuiFlexItem,{className:"eui-textCenter"},logos.Mark.type==="custom"?_react.default.createElement("div",{className:"homSolutionPanel__customIcon"},_react.default.createElement("img",{className:"homSolutionPanel__customIconContainer","data-test-subj":"dashboardCustomLogo","data-test-image-url":logos.Mark.url,alt:branding.applicationTitle+" logo",src:logos.Mark.url})):_react.default.createElement(_eui.EuiToken,{iconType:logos.Mark.url,shape:"circle",fill:"light",size:"l",className:"homSolutionPanel__icon"}),_react.default.createElement(_eui.EuiTitle,{className:"homSolutionPanel__title eui-textInheritColor",size:"s","data-test-subj":"dashboardCustomTitle","data-test-title":branding.applicationTitle},_react.default.createElement("h3",null,branding.applicationTitle)),_react.default.createElement(_eui.EuiText,{size:"s"},_react.default.createElement("p",{className:"homSolutionPanel__subtitle"},subtitle," ",_react.default.createElement(_eui.EuiIcon,{type:"sortRight"})))))};exports.SolutionTitle=SolutionTitle},2511:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.SampleDataCard=SampleDataCard;var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);var _react2=__webpack_require__(13);var _opensearch_dashboards_services=__webpack_require__(166);function SampleDataCard(_ref){let{urlBasePath:urlBasePath,onDecline:onDecline,onConfirm:onConfirm}=_ref;const IS_DARK_THEME=(0,_opensearch_dashboards_services.getServices)().uiSettings.get("theme:darkMode");const cardGraphicFile=!IS_DARK_THEME?"illustration_integrations_lightmode.png":"illustration_integrations_darkmode.png";const cardGraphicURL="".concat(urlBasePath,"/plugins/home/assets/common/").concat(cardGraphicFile);return _react.default.createElement(_eui.EuiCard,{image:cardGraphicURL,textAlign:"left",title:_react.default.createElement(_react2.FormattedMessage,{id:"home.letsStartTitle",defaultMessage:"Start by adding your data"}),description:_react.default.createElement(_react2.FormattedMessage,{id:"home.letsStartDescription",defaultMessage:"Add data to your cluster from any source, then analyze and visualize it in real time. Use our solutions to add search anywhere, observe your ecosystem, and protect against security threats."}),footer:_react.default.createElement("footer",null,_react.default.createElement(_eui.EuiButton,{fill:true,className:"homWelcome__footerAction",onClick:onConfirm},_react.default.createElement(_react2.FormattedMessage,{id:"home.tryButtonLabel",defaultMessage:"Add data"})),_react.default.createElement(_eui.EuiButtonEmpty,{className:"homWelcome__footerAction",onClick:onDecline,"data-test-subj":"skipWelcomeScreen"},_react.default.createElement(_react2.FormattedMessage,{id:"home.exploreButtonLabel",defaultMessage:"Explore on my own"})))})}},2512:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"Homepage",{enumerable:true,get:function(){return _homepage.Homepage}});var _homepage=__webpack_require__(2513)},2513:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.Homepage=void 0;var _react=_interopRequireWildcard(__webpack_require__(2));var _reactUse=__webpack_require__(631);var _rxjs=__webpack_require__(12);var _i18n=__webpack_require__(3);var _react2=__webpack_require__(13);var _eui=__webpack_require__(6);var _opensearch_dashboards_services=__webpack_require__(166);var _hero_section=__webpack_require__(2514);var _section=__webpack_require__(2515);var _footer=__webpack_require__(2516);var _welcome=__webpack_require__(2189);function _getRequireWildcardCache(e){if("function"!=typeof WeakMap)return null;var r=new WeakMap,t=new WeakMap;return(_getRequireWildcardCache=function(e){return e?t:r})(e)}function _interopRequireWildcard(e,r){if(!r&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var t=_getRequireWildcardCache(r);if(t&&t.has(e))return t.get(e);var n={__proto__:null},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var u in e)if("default"!==u&&Object.prototype.hasOwnProperty.call(e,u)){var i=a?Object.getOwnPropertyDescriptor(e,u):null;i&&(i.get||i.set)?Object.defineProperty(n,u,i):n[u]=e[u]}return n.default=e,t&&t.set(e,n),n}const KEY_ENABLE_WELCOME="home:welcome:show";const useHomepage=()=>{const{sectionTypes:sectionTypes}=(0,_opensearch_dashboards_services.getServices)();const[heroes,setHeroes]=(0,_react.useState)();const[sections,setSections]=(0,_react.useState)();const[error,setError]=(0,_react.useState)();(0,_react.useEffect)(()=>{const homepage=sectionTypes.getHomepage();const subscriptions=new _rxjs.Subscription;subscriptions.add(homepage.heroes$.subscribe(setHeroes));subscriptions.add(homepage.sections$.subscribe(setSections));subscriptions.add(homepage.error$.subscribe(setError));return()=>{subscriptions.unsubscribe();homepage.cleanup()}},[sectionTypes]);const isLoading=!heroes&&!sections;return{heroes:heroes,sections:sections,error:error,isLoading:isLoading}};const useShowWelcome=()=>{const[isLoading,setIsLoading]=(0,_react.useState)(true);const[isNewInstance,setIsNewInstance]=(0,_react.useState)(false);const{homeConfig:homeConfig,savedObjectsClient:savedObjectsClient}=(0,_opensearch_dashboards_services.getServices)();const[isWelcomeEnabled,setIsWelcomeEnabled]=(0,_react.useState)(!(homeConfig.disableWelcomeScreen||localStorage.getItem(KEY_ENABLE_WELCOME)==="false"));(0,_react.useEffect)(()=>{if(!isWelcomeEnabled){setIsLoading(false);return}const timeout=setTimeout(()=>{setIsLoading(false);setIsWelcomeEnabled(false)},500);savedObjectsClient.find({type:"index-pattern",fields:["title"],search:"*",searchFields:["title"],perPage:1}).then(resp=>{setIsLoading(false);setIsNewInstance(resp.total===0);clearTimeout(timeout)});return()=>{clearTimeout(timeout)}},[isWelcomeEnabled,savedObjectsClient]);return{isLoading:isLoading,showWelcome:isWelcomeEnabled&&isNewInstance,onSkip:()=>{localStorage.setItem(KEY_ENABLE_WELCOME,"false");setIsWelcomeEnabled(false)}}};const Content=()=>{const{heroes:heroes,sections:sections,error:error,isLoading:isHomepageLoading}=useHomepage();const{chrome:{logos:logos},getBasePath:getBasePath,injectedMetadata:{getBranding:getBranding},telemetry:telemetry,toastNotifications:toastNotifications}=(0,_opensearch_dashboards_services.getServices)();const{isLoading:isWelcomeLoading,showWelcome:showWelcome,onSkip:onSkip}=useShowWelcome();(0,_react.useEffect)(()=>{if(!error){return}toastNotifications.addDanger({title:_i18n.i18n.translate("home.loadingError.title",{defaultMessage:"Error loading homepage"}),text:_i18n.i18n.translate("home.loadingError.description",{defaultMessage:"There was an error loading the homepage. Please refresh the page to try again."})});console.error(error)},[toastNotifications,error]);if(error){return _react.default.createElement(_eui.EuiFlexGroup,{className:"home-homepage-body--fill",direction:"column",justifyContent:"center",alignItems:"center"},_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiIcon,{type:"alert",color:"danger",size:"xxl"})),_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_react2.FormattedMessage,{id:"home.errorText",defaultMessage:"There was an error loading the homepage."})))}if(isHomepageLoading||isWelcomeLoading){return _react.default.createElement(_eui.EuiFlexGroup,{className:"home-homepage-body--fill",direction:"column",justifyContent:"center",alignItems:"center"},_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiLoadingSpinner,{"aria-label":_i18n.i18n.translate("home.loadingSpinner",{defaultMessage:"Loading homepage"}),size:"xl"})),_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_react2.FormattedMessage,{id:"home.loadingText",defaultMessage:"Loading..."})))}if(showWelcome){return _react.default.createElement(_welcome.Welcome,{urlBasePath:getBasePath(),onSkip:onSkip,telemetry:telemetry,branding:getBranding(),logos:logos})}const hero=heroes===null||heroes===void 0?void 0:heroes[0];return _react.default.createElement(_react.default.Fragment,null,hero&&_react.default.createElement(_hero_section.HeroSection,{render:hero.render}),sections===null||sections===void 0?void 0:sections.map((_ref,i)=>{let{render:render,title:title,description:description,links:links}=_ref;return _react.default.createElement(_section.Section,{key:i,title:title,description:description,links:links,render:render})}),_react.default.createElement(_eui.EuiHorizontalRule,null),_react.default.createElement(_footer.Footer,null))};const Homepage=()=>{var _branding$mark,_branding$mark2;const{application:{getUrlForApp:getUrlForApp},chrome:chrome,injectedMetadata:{getBranding:getBranding}}=(0,_opensearch_dashboards_services.getServices)();const branding=getBranding();const title=branding.applicationTitle!=="OpenSearch Dashboards"?_i18n.i18n.translate("home.customBrandingTitle",{defaultMessage:"{title} - Home",values:{title:branding.applicationTitle}}):_i18n.i18n.translate("home.title",{defaultMessage:"Home"});const mark=branding.darkMode&&((_branding$mark=branding.mark)===null||_branding$mark===void 0?void 0:_branding$mark.darkModeUrl)||((_branding$mark2=branding.mark)===null||_branding$mark2===void 0?void 0:_branding$mark2.defaultUrl);(0,_reactUse.useMount)(()=>{chrome.setBreadcrumbs([{text:_i18n.i18n.translate("home.breadcrumbs.homeTitle",{defaultMessage:"Home"})}])});const sideItems=[_react.default.createElement(_eui.EuiButtonEmpty,{iconType:"wrench",href:getUrlForApp("dev_tools",{path:"#/console"}),"data-test-subj":"homeSynopsisLinkconsole"},_react.default.createElement(_react2.FormattedMessage,{id:"home.devTools",defaultMessage:"Dev tools"})),_react.default.createElement(_eui.EuiButtonEmpty,{iconType:"gear",href:getUrlForApp("management")},_react.default.createElement(_react2.FormattedMessage,{id:"home.manage",defaultMessage:"Manage"})),_react.default.createElement(_eui.EuiButtonEmpty,{iconType:"indexOpen",href:getUrlForApp("home",{path:"#/tutorial_directory"})},_react.default.createElement(_react2.FormattedMessage,{id:"home.addData",defaultMessage:"Add data"}))];return _react.default.createElement(_eui.EuiPageTemplate,{restrictWidth:1400,pageHeader:{pageTitle:_react.default.createElement("span",{"data-test-subj":"dashboardCustomTitle"},title),rightSideItems:sideItems,alignItems:"center",iconType:mark,iconProps:{"data-test-subj":mark&&"dashboardCustomLogo"}},pageContentProps:{color:"transparent",hasBorder:false,hasShadow:false},pageContentBodyProps:{paddingSize:"none",className:"home-homepage-pageBody"}},_react.default.createElement(Content,null))};exports.Homepage=Homepage},2514:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.HeroSection=void 0;var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);var _lazy_render=__webpack_require__(2190);const HeroSection=_ref=>{let{render:render}=_ref;return _react.default.createElement(_eui.EuiPanel,{"data-test-subj":"homepageHeroSection"},_react.default.createElement(_lazy_render.LazyRender,{render:render}))};exports.HeroSection=HeroSection},2515:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.Section=void 0;var _extends2=_interopRequireDefault(__webpack_require__(23));var _react=_interopRequireWildcard(__webpack_require__(2));var _i18n=__webpack_require__(3);var _eui=__webpack_require__(6);var _lazy_render=__webpack_require__(2190);function _getRequireWildcardCache(e){if("function"!=typeof WeakMap)return null;var r=new WeakMap,t=new WeakMap;return(_getRequireWildcardCache=function(e){return e?t:r})(e)}function _interopRequireWildcard(e,r){if(!r&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var t=_getRequireWildcardCache(r);if(t&&t.has(e))return t.get(e);var n={__proto__:null},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var u in e)if("default"!==u&&Object.prototype.hasOwnProperty.call(e,u)){var i=a?Object.getOwnPropertyDescriptor(e,u):null;i&&(i.get||i.set)?Object.defineProperty(n,u,i):n[u]=e[u]}return n.default=e,t&&t.set(e,n),n}const Section=_ref=>{let{render:render,title:title,description:description,links:links}=_ref;const[isExpanded,setExpanded]=(0,_react.useState)(true);const hasDescription=!!description;const hasLinks=Array.isArray(links)&&links.length>0;const hasDescriptionSection=hasDescription||hasLinks;const hasDescriptionSpacer=hasDescription&&hasLinks;const toggleExpanded=()=>setExpanded(expanded=>!expanded);const memoizedContent=(0,_react.useMemo)(()=>_react.default.createElement(_eui.EuiFlexGroup,{direction:"row","data-test-subj":"homepageSectionContent"},hasDescriptionSection&&_react.default.createElement(_eui.EuiFlexItem,{grow:1},_react.default.createElement(_eui.EuiText,null,description),hasDescriptionSpacer&&_react.default.createElement(_eui.EuiSpacer,null),hasLinks&&links.map((_ref2,i)=>{let{label:label,url:url,props:props}=_ref2;return _react.default.createElement(_eui.EuiLink,(0,_extends2.default)({key:i},props,{href:url}),label)})),_react.default.createElement(_eui.EuiFlexItem,{grow:3},_react.default.createElement(_lazy_render.LazyRender,{render:render}))),[description,hasDescriptionSection,hasDescriptionSpacer,hasLinks,links,render]);return _react.default.createElement(_eui.EuiPanel,{hasBorder:false,hasShadow:false,color:"transparent","data-test-subj":"homepageSection"},_react.default.createElement(_eui.EuiFlexGroup,{direction:"row",alignItems:"center",gutterSize:"s",responsive:false},_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiButtonIcon,{iconType:isExpanded?"arrowDown":"arrowRight",onClick:toggleExpanded,size:"s",iconSize:"m",color:"text","aria-label":isExpanded?_i18n.i18n.translate("home.section.collapse",{defaultMessage:"Collapse section"}):_i18n.i18n.translate("home.section.expand",{defaultMessage:"Expand section"})})),_react.default.createElement(_eui.EuiFlexItem,{grow:true},_react.default.createElement(_eui.EuiTitle,{size:"m"},_react.default.createElement("h2",null,title)))),isExpanded&&memoizedContent)};exports.Section=Section},2516:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.Footer=void 0;var _react=_interopRequireDefault(__webpack_require__(2));var _react2=__webpack_require__(13);var _eui=__webpack_require__(6);var _i18n=__webpack_require__(3);var _constants=__webpack_require__(637);var _public=__webpack_require__(18);const Footer=()=>{var _application$capabili;const[defaultRoute,setDefaultRoute]=(0,_public.useUiSetting$)("defaultRoute");const{services:{application:application,notifications:{toasts:toasts}}}=(0,_public.useOpenSearchDashboards)();const getUrlForApp=application.getUrlForApp;const{show:show,save:save}=(_application$capabili=application.capabilities.advancedSettings)!==null&&_application$capabili!==void 0?_application$capabili:{};const isAdvancedSettingsEnabled=show&&save;const defaultRouteButton=defaultRoute===_constants.HOME_APP_BASE_PATH?_react.default.createElement(_public.RedirectAppLinks,{application:application},_react.default.createElement(_eui.EuiButtonEmpty,{flush:"both",href:getUrlForApp("management",{path:"opensearch-dashboards/settings#defaultRoute"}),iconType:"home",size:"xs"},_react.default.createElement(_react2.FormattedMessage,{id:"home.footer.changeHomeRouteLink",defaultMessage:"Display a different page on log in"}))):_react.default.createElement(_eui.EuiButtonEmpty,{flush:"both",iconType:"home",onClick:()=>{setDefaultRoute(_constants.HOME_APP_BASE_PATH);toasts.addSuccess({title:_i18n.i18n.translate("home.footer.changeDefaultRouteSuccessToast",{defaultMessage:"Landing page updated"})})},size:"xs"},_react.default.createElement(_react2.FormattedMessage,{id:"home.footer.makeDefaultRouteLink",defaultMessage:"Make this my landing page"}));return _react.default.createElement(_eui.EuiFlexGroup,{direction:"row",wrap:true},isAdvancedSettingsEnabled&&_react.default.createElement(_eui.EuiFlexItem,{grow:false},defaultRouteButton),_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_public.RedirectAppLinks,{application:application},_react.default.createElement(_eui.EuiButtonEmpty,{flush:"both",href:getUrlForApp("home",{path:"#/feature_directory"}),iconType:"apps",size:"xs"},_react.default.createElement(_react2.FormattedMessage,{id:"home.footer.appDirectoryButtonLabel",defaultMessage:"View app directory"})))),_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_public.RedirectAppLinks,{application:application},_react.default.createElement(_eui.EuiButtonEmpty,{flush:"both",href:getUrlForApp("opensearch_dashboards_overview"),iconType:"visualizeApp",size:"xs"},_react.default.createElement(_react2.FormattedMessage,{id:"home.footer.visualizeAndAnalyze",defaultMessage:"Visualize & Analyze"})))))};exports.Footer=Footer},2517:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.FeatureDirectory=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _react=_interopRequireDefault(__webpack_require__(2));var _synopsis=__webpack_require__(2109);var _eui=__webpack_require__(6);var _services=__webpack_require__(268);var _i18n=__webpack_require__(3);var _react2=__webpack_require__(13);var _app_navigation_handler=__webpack_require__(2100);const ALL_TAB_ID="all";const OTHERS_TAB_ID="others";const isOtherCategory=directory=>directory.category!==_services.FeatureCatalogueCategory.DATA&&directory.category!==_services.FeatureCatalogueCategory.ADMIN;class FeatureDirectory extends _react.default.Component{constructor(props){super(props);(0,_defineProperty2.default)(this,"onSelectedTabChanged",id=>{this.setState({selectedTabId:id})});(0,_defineProperty2.default)(this,"renderTabs",()=>this.tabs.map((tab,index)=>_react.default.createElement(_eui.EuiTab,{"data-test-subj":"tab-".concat(tab.id),onClick:()=>this.onSelectedTabChanged(tab.id),isSelected:tab.id===this.state.selectedTabId,key:index},tab.name)));(0,_defineProperty2.default)(this,"renderDirectories",()=>this.props.directories.filter(directory=>{if(this.state.selectedTabId===ALL_TAB_ID){return true}if(this.state.selectedTabId===OTHERS_TAB_ID){return isOtherCategory(directory)}return this.state.selectedTabId===directory.category}).map(directory=>_react.default.createElement(_eui.EuiFlexItem,{key:directory.id},_react.default.createElement(_synopsis.Synopsis,{id:directory.id,onClick:(0,_app_navigation_handler.createAppNavigationHandler)(directory.path),description:directory.description,iconType:directory.icon,title:directory.title,url:this.props.addBasePath(directory.path),wrapInPanel:true}))));this.tabs=[{id:ALL_TAB_ID,name:_i18n.i18n.translate("home.directory.tabs.allTitle",{defaultMessage:"All"})},{id:_services.FeatureCatalogueCategory.DATA,name:_i18n.i18n.translate("home.directory.tabs.dataTitle",{defaultMessage:"Data Exploration & Visualization"})},{id:_services.FeatureCatalogueCategory.ADMIN,name:_i18n.i18n.translate("home.directory.tabs.administrativeTitle",{defaultMessage:"Administrative"})}];if(props.directories.some(isOtherCategory)){this.tabs.push({id:OTHERS_TAB_ID,name:_i18n.i18n.translate("home.directory.tabs.otherTitle",{defaultMessage:"Other"})})}this.state={selectedTabId:ALL_TAB_ID}}render(){return _react.default.createElement(_eui.EuiPage,{restrictWidth:1200},_react.default.createElement(_eui.EuiPageBody,{component:"main"},_react.default.createElement(_eui.EuiTitle,{size:"l"},_react.default.createElement("h1",null,_react.default.createElement(_react2.FormattedMessage,{id:"home.directory.directoryTitle",defaultMessage:"Directory"}))),_react.default.createElement(_eui.EuiSpacer,{size:"m"}),_react.default.createElement(_eui.EuiTabs,{className:"homeDirectoryTabs"},this.renderTabs()),_react.default.createElement(_eui.EuiSpacer,null),_react.default.createElement(_eui.EuiFlexGrid,{columns:4},this.renderDirectories())))}}exports.FeatureDirectory=FeatureDirectory},2518:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.TutorialDirectory=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _lodash=_interopRequireDefault(__webpack_require__(5));var _react=_interopRequireDefault(__webpack_require__(2));var _synopsis=__webpack_require__(2109);var _sample_data_set_cards=__webpack_require__(2519);var _opensearch_dashboards_services=__webpack_require__(166);var _eui=__webpack_require__(6);var _load_tutorials=__webpack_require__(2191);var _react2=__webpack_require__(13);var _i18n=__webpack_require__(3);var _public=__webpack_require__(2523);const ALL_TAB_ID="all";const SAMPLE_DATA_TAB_ID="sampleData";const homeTitle=_i18n.i18n.translate("home.breadcrumbs.homeTitle",{defaultMessage:"Home"});const addDataTitle=_i18n.i18n.translate("home.breadcrumbs.addDataTitle",{defaultMessage:"Add data"});class TutorialDirectoryUi extends _react.default.Component{constructor(props){var _getServices$dataSour,_getServices$dataSour2;super(props);(0,_defineProperty2.default)(this,"onSelectedTabChanged",id=>{this.setState({selectedTabId:id})});(0,_defineProperty2.default)(this,"renderTabs",()=>this.tabs.map((tab,index)=>_react.default.createElement(_eui.EuiTab,{onClick:()=>this.onSelectedTabChanged(tab.id),isSelected:tab.id===this.state.selectedTabId,key:index},tab.name)));(0,_defineProperty2.default)(this,"renderTabContent",()=>{if(this.state.selectedTabId===SAMPLE_DATA_TAB_ID){return _react.default.createElement(_sample_data_set_cards.SampleDataSetCards,{addBasePath:this.props.addBasePath,dataSourceId:this.state.selectedDataSourceId,isDataSourceEnabled:this.state.isDataSourceEnabled,isLocalClusterHidden:this.state.isLocalClusterHidden})}return _react.default.createElement(_eui.EuiFlexGrid,{columns:4},this.state.tutorialCards.filter(tutorial=>this.state.selectedTabId===ALL_TAB_ID||this.state.selectedTabId===tutorial.category).map(tutorial=>_react.default.createElement(_eui.EuiFlexItem,{key:tutorial.name},_react.default.createElement(_synopsis.Synopsis,{id:tutorial.id,iconType:tutorial.icon,description:tutorial.description,title:tutorial.name,wrapInPanel:true,url:tutorial.url,onClick:tutorial.onClick,isBeta:tutorial.isBeta}))))});(0,_defineProperty2.default)(this,"onSelectedDataSourceChange",e=>{const dataSourceId=e[0]?e[0].id:undefined;this.setState({selectedDataSourceId:dataSourceId})});(0,_defineProperty2.default)(this,"renderDataSourceSelector",()=>{const{isDataSourceEnabled:isDataSourceEnabled,isLocalClusterHidden:isLocalClusterHidden}=this.state;return isDataSourceEnabled?_react.default.createElement("div",{className:"sampleDataSourceSelector"},_react.default.createElement(_public.DataSourceSelector,{savedObjectsClient:(0,_opensearch_dashboards_services.getServices)().savedObjectsClient,notifications:(0,_opensearch_dashboards_services.getServices)().toastNotifications,onSelectedDataSource:this.onSelectedDataSourceChange,disabled:!isDataSourceEnabled,hideLocalCluster:isLocalClusterHidden,uiSettings:(0,_opensearch_dashboards_services.getServices)().uiSettings})):null});(0,_defineProperty2.default)(this,"renderNotices",()=>{const notices=(0,_opensearch_dashboards_services.getServices)().tutorialService.getDirectoryNotices();return notices.length?_react.default.createElement(_eui.EuiFlexGroup,{direction:"column",gutterSize:"none"},notices.map((DirectoryNotice,index)=>_react.default.createElement(_eui.EuiFlexItem,{key:index},_react.default.createElement(DirectoryNotice,null)))):null});(0,_defineProperty2.default)(this,"renderHeaderLinks",()=>{const headerLinks=(0,_opensearch_dashboards_services.getServices)().tutorialService.getDirectoryHeaderLinks();return headerLinks.length?_react.default.createElement(_eui.EuiFlexGroup,{gutterSize:"m",alignItems:"center"},headerLinks.map((HeaderLink,index)=>_react.default.createElement(_eui.EuiFlexItem,{key:index},_react.default.createElement(HeaderLink,null)))):null});(0,_defineProperty2.default)(this,"renderHeader",()=>{const notices=this.renderNotices();const headerLinks=this.renderHeaderLinks();return _react.default.createElement(_react.default.Fragment,null,_react.default.createElement(_eui.EuiFlexGroup,{alignItems:"center"},_react.default.createElement(_eui.EuiFlexItem,null,_react.default.createElement(_eui.EuiTitle,{size:"l"},_react.default.createElement("h1",null,_react.default.createElement(_react2.FormattedMessage,{id:"home.tutorial.addDataToOpenSearchDashboardsTitle",defaultMessage:"Add sample data"})))),headerLinks?_react.default.createElement(_eui.EuiFlexItem,{grow:false},headerLinks):null),notices)});(0,_defineProperty2.default)(this,"renderPageBody",()=>_react.default.createElement(_eui.EuiPageBody,{component:"main"},this.renderHeader(),_react.default.createElement(_eui.EuiSpacer,{size:"m"}),this.renderDataSourceSelector(),_react.default.createElement(_eui.EuiTabs,null,this.renderTabs()),_react.default.createElement(_eui.EuiSpacer,null),this.renderTabContent()));this.tabs=[];let openTab=SAMPLE_DATA_TAB_ID;if(props.openTab&&this.tabs.some(tab=>tab.id===props.openTab)){openTab=props.openTab}this.state={selectedTabId:openTab,tutorialCards:[],notices:(0,_opensearch_dashboards_services.getServices)().tutorialService.getDirectoryNotices(),isDataSourceEnabled:!!(0,_opensearch_dashboards_services.getServices)().dataSource,isLocalClusterHidden:(_getServices$dataSour=(_getServices$dataSour2=(0,_opensearch_dashboards_services.getServices)().dataSource)===null||_getServices$dataSour2===void 0?void 0:_getServices$dataSour2.hideLocalCluster)!==null&&_getServices$dataSour!==void 0?_getServices$dataSour:false}}componentWillUnmount(){this._isMounted=false}async componentDidMount(){this._isMounted=true;const{chrome:chrome}=(0,_opensearch_dashboards_services.getServices)();const{withoutHomeBreadCrumb:withoutHomeBreadCrumb}=this.props;const breadcrumbs=[{text:addDataTitle}];if(!withoutHomeBreadCrumb){breadcrumbs.splice(0,0,{text:homeTitle,href:"#/"})}chrome.setBreadcrumbs(breadcrumbs);const tutorialConfigs=await(0,_load_tutorials.getTutorials)();if(!this._isMounted){return}let tutorialCards=tutorialConfigs.map(tutorialConfig=>{let icon=tutorialConfig.euiIconType;if(icon&&icon.includes("/")){icon=this.props.addBasePath(icon)}return{id:tutorialConfig.id,category:tutorialConfig.category,icon:icon,name:tutorialConfig.name,description:tutorialConfig.shortDescription,url:this.props.addBasePath("#/tutorial/".concat(tutorialConfig.id)),elasticCloud:tutorialConfig.elasticCloud}});tutorialCards.push({id:"sample_data",name:this.props.intl.formatMessage({id:"home.tutorial.card.sampleDataTitle",defaultMessage:"Sample Data"}),description:this.props.intl.formatMessage({id:"home.tutorial.card.sampleDataDescription",defaultMessage:'Get started exploring OpenSearch Dashboards with these "one click" data sets.'}),url:this.props.addBasePath("#/tutorial_directory/sampleData"),elasticCloud:true,onClick:this.onSelectedTabChanged.bind(null,SAMPLE_DATA_TAB_ID)});if(this.props.isCloudEnabled){tutorialCards=tutorialCards.filter(tutorial=>_lodash.default.has(tutorial,"elasticCloud"))}tutorialCards.sort((a,b)=>a.name.toLowerCase().localeCompare(b.name.toLowerCase()));this.setState({tutorialCards:tutorialCards})}render(){const{isDataSourceEnabled:isDataSourceEnabled}=this.state;return isDataSourceEnabled?_react.default.createElement(_eui.EuiPanel,{paddingSize:"l",style:{width:"70%",margin:"50px auto"}},this.renderPageBody()):_react.default.createElement(_eui.EuiPage,{restrictWidth:1200},this.renderPageBody())}}const TutorialDirectory=exports.TutorialDirectory=(0,_react2.injectI18n)(TutorialDirectoryUi)},2519:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.SampleDataSetCards=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _lodash=_interopRequireDefault(__webpack_require__(5));var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);var _sample_data_set_card=__webpack_require__(2520);var _opensearch_dashboards_services=__webpack_require__(166);var _sample_data_client=__webpack_require__(2522);var _i18n=__webpack_require__(3);function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter((function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable}))),t.push.apply(t,o)}return t}function _objectSpread(e){for(var r=1;r<arguments.length;r++){var t=null!=arguments[r]?arguments[r]:{};r%2?ownKeys(Object(t),!0).forEach((function(r){(0,_defineProperty2.default)(e,r,t[r])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach((function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r))}))}return e}class SampleDataSetCards extends _react.default.Component{constructor(props){super(props);(0,_defineProperty2.default)(this,"loadSampleDataSets",async dataSourceId=>{let sampleDataSets;try{sampleDataSets=await(0,_sample_data_client.listSampleDataSets)(dataSourceId)}catch(fetchError){this.toastNotifications.addDanger({title:_i18n.i18n.translate("home.sampleDataSet.unableToLoadListErrorMessage",{defaultMessage:"Unable to load sample data sets list"}),text:"".concat(fetchError.message)});sampleDataSets=[]}if(!this._isMounted){return}this.setState({sampleDataSets:sampleDataSets.sort((a,b)=>a.name.toLowerCase().localeCompare(b.name.toLowerCase())),processingStatus:{}})});(0,_defineProperty2.default)(this,"install",async(id,dataSourceId)=>{const targetSampleDataSet=this.state.sampleDataSets.find(sampleDataSet=>sampleDataSet.id===id);this.setState(prevState=>({processingStatus:_objectSpread(_objectSpread({},prevState.processingStatus),{},{[id]:true})}));try{await(0,_sample_data_client.installSampleDataSet)(id,targetSampleDataSet.defaultIndex,dataSourceId)}catch(fetchError){if(this._isMounted){this.setState(prevState=>({processingStatus:_objectSpread(_objectSpread({},prevState.processingStatus),{},{[id]:false})}))}this.toastNotifications.addDanger({title:_i18n.i18n.translate("home.sampleDataSet.unableToInstallErrorMessage",{defaultMessage:"Unable to install sample data set: {name}",values:{name:targetSampleDataSet.name}}),text:"".concat(fetchError.message)});return}if(this._isMounted){this.setState(prevState=>({processingStatus:_objectSpread(_objectSpread({},prevState.processingStatus),{},{[id]:false}),sampleDataSets:prevState.sampleDataSets.map(sampleDataSet=>{if(sampleDataSet.id===id){sampleDataSet.status=_sample_data_set_card.INSTALLED_STATUS}return sampleDataSet})}))}this.toastNotifications.addSuccess({title:_i18n.i18n.translate("home.sampleDataSet.installedLabel",{defaultMessage:"{name} installed",values:{name:targetSampleDataSet.name}}),["data-test-subj"]:"sampleDataSetInstallToast"})});(0,_defineProperty2.default)(this,"uninstall",async(id,dataSourceId)=>{const targetSampleDataSet=this.state.sampleDataSets.find(sampleDataSet=>sampleDataSet.id===id);this.setState(prevState=>({processingStatus:_objectSpread(_objectSpread({},prevState.processingStatus),{},{[id]:true})}));try{await(0,_sample_data_client.uninstallSampleDataSet)(id,targetSampleDataSet.defaultIndex,dataSourceId)}catch(fetchError){if(this._isMounted){this.setState(prevState=>({processingStatus:_objectSpread(_objectSpread({},prevState.processingStatus),{},{[id]:false})}))}this.toastNotifications.addDanger({title:_i18n.i18n.translate("home.sampleDataSet.unableToUninstallErrorMessage",{defaultMessage:"Unable to uninstall sample data set: {name}",values:{name:targetSampleDataSet.name}}),text:"".concat(fetchError.message)});return}if(this._isMounted){this.setState(prevState=>({processingStatus:_objectSpread(_objectSpread({},prevState.processingStatus),{},{[id]:false}),sampleDataSets:prevState.sampleDataSets.map(sampleDataSet=>{if(sampleDataSet.id===id){sampleDataSet.status=_sample_data_set_card.UNINSTALLED_STATUS}return sampleDataSet})}))}this.toastNotifications.addSuccess({title:_i18n.i18n.translate("home.sampleDataSet.uninstalledLabel",{defaultMessage:"{name} uninstalled",values:{name:targetSampleDataSet.name}}),["data-test-subj"]:"sampleDataSetUninstallToast"})});(0,_defineProperty2.default)(this,"lightOrDarkImage",sampleDataSet=>{let imagePath=sampleDataSet.previewImagePath;if(sampleDataSet.darkPreviewImagePath&&(0,_opensearch_dashboards_services.getServices)().uiSettings.get("theme:darkMode")){imagePath=sampleDataSet.darkPreviewImagePath}if(sampleDataSet.hasNewThemeImages&&(0,_opensearch_dashboards_services.getServices)().uiSettings.get("theme:version")!=="v7"){imagePath=imagePath.replace(/.png/,"_new.png")}return imagePath});this.toastNotifications=(0,_opensearch_dashboards_services.getServices)().toastNotifications;this.state={sampleDataSets:[],processingStatus:{}}}componentWillUnmount(){this._isMounted=false}async componentDidMount(){this._isMounted=true;this.loadSampleDataSets()}componentDidUpdate(prevProps){if(this.props.isDataSourceEnabled){this._isMounted=true;if(prevProps&&prevProps.dataSourceId!==this.props.dataSourceId){this.setState({dataSourceId:this.props.dataSourceId},()=>this.loadSampleDataSets(this.state.dataSourceId))}}}render(){return _react.default.createElement(_eui.EuiFlexGrid,{columns:3,className:"homSampleDataSetCards"},this.state.sampleDataSets.map(sampleDataSet=>_react.default.createElement(_eui.EuiFlexItem,{key:sampleDataSet.id},_react.default.createElement(_sample_data_set_card.SampleDataSetCard,{id:sampleDataSet.id,description:sampleDataSet.description,name:sampleDataSet.name,overviewDashboard:sampleDataSet.overviewDashboard,appLinks:sampleDataSet.appLinks,status:sampleDataSet.status,isProcessing:_lodash.default.get(this.state.processingStatus,sampleDataSet.id,false),statusMsg:sampleDataSet.statusMsg,previewUrl:this.props.addBasePath(this.lightOrDarkImage(sampleDataSet)),onInstall:this.install,onUninstall:this.uninstall,dataSourceId:this.state.dataSourceId,isDataSourceEnabled:this.props.isDataSourceEnabled,isLocalClusterHidden:this.props.isLocalClusterHidden}))))}}exports.SampleDataSetCards=SampleDataSetCards},2520:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.UNINSTALLED_STATUS=exports.SampleDataSetCard=exports.INSTALLED_STATUS=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);var _i18n=__webpack_require__(3);var _react2=__webpack_require__(13);var _sample_data_view_data_button=__webpack_require__(2521);const INSTALLED_STATUS=exports.INSTALLED_STATUS="installed";const UNINSTALLED_STATUS=exports.UNINSTALLED_STATUS="not_installed";class SampleDataSetCard extends _react.default.Component{constructor(){super(...arguments);(0,_defineProperty2.default)(this,"isInstalled",()=>{if(this.props.status===INSTALLED_STATUS){return true}return false});(0,_defineProperty2.default)(this,"install",()=>{this.props.onInstall(this.props.id,this.props.dataSourceId)});(0,_defineProperty2.default)(this,"uninstall",()=>{this.props.onUninstall(this.props.id,this.props.dataSourceId)});(0,_defineProperty2.default)(this,"renderBtn",()=>{const dataSourceEnabled=this.props.isDataSourceEnabled;const hideLocalCluster=this.props.isLocalClusterHidden;const dataSourceId=this.props.dataSourceId;let buttonDisabled=false;if(dataSourceEnabled&&hideLocalCluster){buttonDisabled=dataSourceId===undefined}switch(this.props.status){case INSTALLED_STATUS:return _react.default.createElement(_eui.EuiFlexGroup,{gutterSize:"none",justifyContent:"spaceBetween"},_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiButtonEmpty,{isLoading:this.props.isProcessing,onClick:this.uninstall,color:"danger","data-test-subj":"removeSampleDataSet".concat(this.props.id),flush:"left","aria-label":this.props.isProcessing?_i18n.i18n.translate("home.sampleDataSetCard.removingButtonAriaLabel",{defaultMessage:"Removing {datasetName}",values:{datasetName:this.props.name}}):_i18n.i18n.translate("home.sampleDataSetCard.removeButtonAriaLabel",{defaultMessage:"Remove {datasetName}",values:{datasetName:this.props.name}})},this.props.isProcessing?_react.default.createElement(_react2.FormattedMessage,{id:"home.sampleDataSetCard.removingButtonLabel",defaultMessage:"Removing"}):_react.default.createElement(_react2.FormattedMessage,{id:"home.sampleDataSetCard.removeButtonLabel",defaultMessage:"Remove"}))),_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_sample_data_view_data_button.SampleDataViewDataButton,{id:this.props.id,name:this.props.name,overviewDashboard:this.props.overviewDashboard,appLinks:this.props.appLinks})));case UNINSTALLED_STATUS:return _react.default.createElement(_eui.EuiFlexGroup,{justifyContent:"flexEnd"},_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiButton,{isDisabled:buttonDisabled,isLoading:this.props.isProcessing,onClick:this.install,"data-test-subj":"addSampleDataSet".concat(this.props.id),"aria-label":this.props.isProcessing?_i18n.i18n.translate("home.sampleDataSetCard.addingButtonAriaLabel",{defaultMessage:"Adding {datasetName}",values:{datasetName:this.props.name}}):_i18n.i18n.translate("home.sampleDataSetCard.addButtonAriaLabel",{defaultMessage:"Add {datasetName}",values:{datasetName:this.props.name}})},this.props.isProcessing?_react.default.createElement(_react2.FormattedMessage,{id:"home.sampleDataSetCard.addingButtonLabel",defaultMessage:"Adding"}):_react.default.createElement(_react2.FormattedMessage,{id:"home.sampleDataSetCard.addButtonLabel",defaultMessage:"Add data"}))));default:{return _react.default.createElement(_eui.EuiFlexGroup,{justifyContent:"flexEnd"},_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiToolTip,{position:"top",content:_react.default.createElement("p",null,_react.default.createElement(_react2.FormattedMessage,{id:"home.sampleDataSetCard.default.unableToVerifyErrorMessage",defaultMessage:"Unable to verify dataset status, error: {statusMsg}",values:{statusMsg:this.props.statusMsg}}))},_react.default.createElement(_eui.EuiButton,{isDisabled:buttonDisabled,"data-test-subj":"addSampleDataSet".concat(this.props.id),"aria-label":_i18n.i18n.translate("home.sampleDataSetCard.default.addButtonAriaLabel",{defaultMessage:"Add {datasetName}",values:{datasetName:this.props.name}})},_react.default.createElement(_react2.FormattedMessage,{id:"home.sampleDataSetCard.default.addButtonLabel",defaultMessage:"Add data"})))))}}})}render(){return _react.default.createElement(_eui.EuiCard,{textAlign:"left",className:"homSampleDataSetCard",image:this.props.previewUrl,title:this.props.name,description:this.props.description,betaBadgeLabel:this.isInstalled()?"INSTALLED":null,footer:this.renderBtn(),"data-test-subj":"sampleDataSetCard".concat(this.props.id)})}}exports.SampleDataSetCard=SampleDataSetCard},2521:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.SampleDataViewDataButton=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);var _i18n=__webpack_require__(3);var _opensearch_dashboards_services=__webpack_require__(166);var _app_navigation_handler=__webpack_require__(2100);class SampleDataViewDataButton extends _react.default.Component{constructor(){super(...arguments);(0,_defineProperty2.default)(this,"addBasePath",(0,_opensearch_dashboards_services.getServices)().addBasePath);(0,_defineProperty2.default)(this,"state",{isPopoverOpen:false});(0,_defineProperty2.default)(this,"togglePopoverVisibility",()=>{this.setState(prevState=>({isPopoverOpen:!prevState.isPopoverOpen}))});(0,_defineProperty2.default)(this,"closePopover",()=>{this.setState({isPopoverOpen:false})})}render(){const viewDataButtonLabel=_i18n.i18n.translate("home.sampleDataSetCard.viewDataButtonLabel",{defaultMessage:"View data"});const viewDataButtonAriaLabel=_i18n.i18n.translate("home.sampleDataSetCard.viewDataButtonAriaLabel",{defaultMessage:"View {datasetName}",values:{datasetName:this.props.name}});const dashboardPath="/app/dashboards#/view/".concat(this.props.overviewDashboard);const prefixedDashboardPath=this.addBasePath(dashboardPath);if(this.props.appLinks.length===0){return _react.default.createElement(_eui.EuiButton,{onClick:(0,_app_navigation_handler.createAppNavigationHandler)(dashboardPath),"data-test-subj":"launchSampleDataSet".concat(this.props.id),"aria-label":viewDataButtonAriaLabel},viewDataButtonLabel)}const additionalItems=this.props.appLinks.map(_ref=>{let{path:path,label:label,icon:icon}=_ref;return{name:label,icon:_react.default.createElement(_eui.EuiIcon,{type:icon,size:"m"}),href:this.addBasePath(path),onClick:(0,_app_navigation_handler.createAppNavigationHandler)(path)}});const panels=[{id:0,items:[{name:_i18n.i18n.translate("home.sampleDataSetCard.dashboardLinkLabel",{defaultMessage:"Dashboard"}),icon:_react.default.createElement(_eui.EuiIcon,{type:"dashboardApp",size:"m"}),href:prefixedDashboardPath,onClick:(0,_app_navigation_handler.createAppNavigationHandler)(dashboardPath)},...additionalItems]}];const popoverButton=_react.default.createElement(_eui.EuiButton,{"aria-label":viewDataButtonAriaLabel,onClick:this.togglePopoverVisibility,iconType:"arrowDown",iconSide:"right"},viewDataButtonLabel);return _react.default.createElement(_eui.EuiPopover,{id:"sampleDataLinks".concat(this.props.id),button:popoverButton,isOpen:this.state.isPopoverOpen,closePopover:this.closePopover,panelPaddingSize:"none",anchorPosition:"downCenter","data-test-subj":"launchSampleDataSet".concat(this.props.id)},_react.default.createElement(_eui.EuiContextMenu,{initialPanelId:0,panels:panels}))}}exports.SampleDataViewDataButton=SampleDataViewDataButton},2522:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.installSampleDataSet=installSampleDataSet;exports.listSampleDataSets=listSampleDataSets;exports.uninstallSampleDataSet=uninstallSampleDataSet;var _opensearch_dashboards_services=__webpack_require__(166);const sampleDataUrl="/api/sample_data";function clearIndexPatternsCache(){(0,_opensearch_dashboards_services.getServices)().indexPatternService.clearCache()}async function listSampleDataSets(dataSourceId){const query=buildQuery(dataSourceId);return await(0,_opensearch_dashboards_services.getServices)().http.get(sampleDataUrl,{query:query})}async function installSampleDataSet(id,sampleDataDefaultIndex,dataSourceId){const query=buildQuery(dataSourceId);await(0,_opensearch_dashboards_services.getServices)().http.post("".concat(sampleDataUrl,"/").concat(id),{query:query});if((0,_opensearch_dashboards_services.getServices)().uiSettings.isDefault("defaultIndex")){(0,_opensearch_dashboards_services.getServices)().uiSettings.set("defaultIndex",sampleDataDefaultIndex)}clearIndexPatternsCache()}async function uninstallSampleDataSet(id,sampleDataDefaultIndex,dataSourceId){const query=buildQuery(dataSourceId);await(0,_opensearch_dashboards_services.getServices)().http.delete("".concat(sampleDataUrl,"/").concat(id),{query:query});const uiSettings=(0,_opensearch_dashboards_services.getServices)().uiSettings;if(!uiSettings.isDefault("defaultIndex")&&uiSettings.get("defaultIndex")===sampleDataDefaultIndex){uiSettings.set("defaultIndex",null)}clearIndexPatternsCache()}function buildQuery(dataSourceId){const query={};if(dataSourceId){query.data_source_id=dataSourceId}return query}},2523:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"DataSourceAggregatedViewConfig",{enumerable:true,get:function(){return _data_source_menu.DataSourceAggregatedViewConfig}});Object.defineProperty(exports,"DataSourceComponentType",{enumerable:true,get:function(){return _data_source_menu.DataSourceComponentType}});Object.defineProperty(exports,"DataSourceManagementPlugin",{enumerable:true,get:function(){return _plugin.DataSourceManagementPlugin}});Object.defineProperty(exports,"DataSourceManagementPluginSetup",{enumerable:true,get:function(){return _plugin.DataSourceManagementPluginSetup}});Object.defineProperty(exports,"DataSourceManagementPluginStart",{enumerable:true,get:function(){return _types.DataSourceManagementPluginStart}});Object.defineProperty(exports,"DataSourceMenu",{enumerable:true,get:function(){return _data_source_menu.DataSourceMenu}});Object.defineProperty(exports,"DataSourceMenuProps",{enumerable:true,get:function(){return _data_source_menu.DataSourceMenuProps}});Object.defineProperty(exports,"DataSourceMultiSelectableConfig",{enumerable:true,get:function(){return _data_source_menu.DataSourceMultiSelectableConfig}});Object.defineProperty(exports,"DataSourceOption",{enumerable:true,get:function(){return _data_source_selector.DataSourceOption}});Object.defineProperty(exports,"DataSourceSelectableConfig",{enumerable:true,get:function(){return _data_source_menu.DataSourceSelectableConfig}});Object.defineProperty(exports,"DataSourceSelectionService",{enumerable:true,get:function(){return _data_source_selection_service.DataSourceSelectionService}});Object.defineProperty(exports,"DataSourceSelector",{enumerable:true,get:function(){return _data_source_selector.DataSourceSelector}});Object.defineProperty(exports,"DataSourceViewConfig",{enumerable:true,get:function(){return _data_source_menu.DataSourceViewConfig}});Object.defineProperty(exports,"createDataSourceMenu",{enumerable:true,get:function(){return _data_source_menu.createDataSourceMenu}});Object.defineProperty(exports,"getDefaultDataSourceId",{enumerable:true,get:function(){return _utils.getDefaultDataSourceId}});Object.defineProperty(exports,"getDefaultDataSourceId$",{enumerable:true,get:function(){return _utils.getDefaultDataSourceId$}});exports.plugin=plugin;var _plugin=__webpack_require__(2101);var _types=__webpack_require__(2094);var _data_source_selector=__webpack_require__(2632);var _data_source_menu=__webpack_require__(2633);var _data_source_selection_service=__webpack_require__(2138);var _utils=__webpack_require__(2091);function plugin(){return new _plugin.DataSourceManagementPlugin}},2524:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.PLUGIN_NAME=exports.PLUGIN_ID=void 0;const PLUGIN_ID=exports.PLUGIN_ID="dataSourceManagement";const PLUGIN_NAME=exports.PLUGIN_NAME="Data sources"},2525:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.createDataSourceSelector=createDataSourceSelector;var _extends2=_interopRequireDefault(__webpack_require__(23));var _react=_interopRequireDefault(__webpack_require__(2));var _data_source_selector=__webpack_require__(2137);function createDataSourceSelector(uiSettings,dataSourcePluginSetup){const{hideLocalCluster:hideLocalCluster}=dataSourcePluginSetup;return props=>_react.default.createElement(_data_source_selector.DataSourceSelector,(0,_extends2.default)({},props,{uiSettings:uiSettings,hideLocalCluster:hideLocalCluster}))}},2526:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.AuthType=void 0;Object.defineProperty(exports,"DataSourceError",{enumerable:true,get:function(){return _error.DataSourceError}});exports.SigV4ServiceName=void 0;var _error=__webpack_require__(2527);let AuthType=exports.AuthType=function(AuthType){AuthType["NoAuth"]="no_auth";AuthType["UsernamePasswordType"]="username_password";AuthType["SigV4"]="sigv4";return AuthType}({});let SigV4ServiceName=exports.SigV4ServiceName=function(SigV4ServiceName){SigV4ServiceName["OpenSearch"]="es";SigV4ServiceName["OpenSearchServerless"]="aoss";return SigV4ServiceName}({})},2527:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.isResponseError=exports.DataSourceError=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _common=__webpack_require__(33);class DataSourceError extends _common.OsdError{constructor(error,context,statusCode){let message;if(context){message=context}else if(isResponseError(error)){message=JSON.stringify(error.meta.body)}else{message=error.message}super("Data Source Error: "+message);(0,_defineProperty2.default)(this,"statusCode",void 0);(0,_defineProperty2.default)(this,"body",void 0);if(error.body){this.body=error.body}if(statusCode){this.statusCode=statusCode}else if(error.statusCode){this.statusCode=error.statusCode}else{this.statusCode=400}}}exports.DataSourceError=DataSourceError;const isResponseError=error=>Boolean(error.body&&error.statusCode&&error.headers);exports.isResponseError=isResponseError},2528:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"getManageDataSourceButton",{enumerable:true,get:function(){return _manage_data_source_button.getManageDataSourceButton}});Object.defineProperty(exports,"getReloadButton",{enumerable:true,get:function(){return _reload_button.getReloadButton}});var _reload_button=__webpack_require__(2529);var _manage_data_source_button=__webpack_require__(2530)},2529:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.getReloadButton=void 0;var _eui=__webpack_require__(6);var _react=_interopRequireDefault(__webpack_require__(2));var _i18n=__webpack_require__(3);const getReloadButton=()=>_react.default.createElement(_react.default.Fragment,null,_react.default.createElement(_eui.EuiFlexGroup,{justifyContent:"flexEnd",gutterSize:"s"},_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiButton,{size:"s",onClick:()=>window.location.reload()},_i18n.i18n.translate("dataSourceMenu.requiresPageReloadToastButtonLabel",{defaultMessage:"Refresh the page"})))));exports.getReloadButton=getReloadButton},2530:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.getManageDataSourceButton=void 0;var _eui=__webpack_require__(6);var _react=_interopRequireDefault(__webpack_require__(2));var _i18n=__webpack_require__(3);var _plugin=__webpack_require__(2101);const getManageDataSourceButton=application=>_react.default.createElement(_react.default.Fragment,null,_react.default.createElement(_eui.EuiFlexGroup,{"data-test-subj":"manageDataSourceButtonContainer",justifyContent:"flexEnd",gutterSize:"s"},_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiButton,{"data-test-subj":"manageDataSourceButton",size:"s",onClick:()=>application===null||application===void 0?void 0:application.navigateToApp("management",{path:"opensearch-dashboards/".concat(_plugin.DSM_APP_ID)})},_i18n.i18n.translate("dataSourceMenu.manageDataSourceToastButtonLabel",{defaultMessage:"Manage data sources"})))));exports.getManageDataSourceButton=getManageDataSourceButton},2531:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.DataSourceItem=void 0;var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);const DataSourceItem=_ref=>{let{className:className,option:option,defaultDataSource:defaultDataSource}=_ref;return _react.default.createElement(_eui.EuiFlexGroup,{justifyContent:"spaceBetween",className:"".concat(className,"OuiFlexGroup")},_react.default.createElement(_eui.EuiFlexItem,{className:"".concat(className,"OuiFlexItem"),grow:false},option.label||""),option.id===defaultDataSource&&_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiBadge,{iconSide:"left"},"Default")))};exports.DataSourceItem=DataSourceItem},2532:function(module,exports,__webpack_require__){switch(window.__osdThemeTag__){case"v7dark":return __webpack_require__(2533);case"v7light":return __webpack_require__(2535);case"v8dark":return __webpack_require__(2537);case"v8light":return __webpack_require__(2539)}},2533:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2534);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2534:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceSelectorOuiFlexGroup .dataSourceSelectorOuiFlexItem{text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2535:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2536);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2536:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceSelectorOuiFlexGroup .dataSourceSelectorOuiFlexItem{text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2537:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2538);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2538:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceSelectorOuiFlexGroup .dataSourceSelectorOuiFlexItem{text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2539:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2540);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2540:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceSelectorOuiFlexGroup .dataSourceSelectorOuiFlexItem{text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2541:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.DataSourceColumn=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _i18n=__webpack_require__(3);var _eui=__webpack_require__(6);var _react=_interopRequireDefault(__webpack_require__(2));var _utils=__webpack_require__(2091);var _plugin=__webpack_require__(2101);class DataSourceColumn{constructor(savedObjectPromise){this.savedObjectPromise=savedObjectPromise;(0,_defineProperty2.default)(this,"id","data_source");(0,_defineProperty2.default)(this,"data",void 0);(0,_defineProperty2.default)(this,"euiColumn",{field:"referenceId",name:_i18n.i18n.translate("dataSource.management.dataSourceColumn",{defaultMessage:"Data Source Connection"}),render:referenceId=>{var _this$data;if(!referenceId){return null}const dataSource=(_this$data=this.data)===null||_this$data===void 0?void 0:_this$data.get(referenceId);if(!dataSource){return _react.default.createElement(_eui.EuiBadge,{color:"danger"},"Deleted")}const{title:title,id:id}=dataSource;return _react.default.createElement(_eui.EuiLink,{onClick:()=>(0,_utils.getApplication)().navigateToApp("management",{path:"opensearch-dashboards/".concat(_plugin.DSM_APP_ID,"/").concat(encodeURIComponent(id))})},title)}});(0,_defineProperty2.default)(this,"loadData",async()=>{const savedObject=await this.savedObjectPromise;return(0,_utils.getDataSources)(savedObject.client).then(dataSources=>{this.data=dataSources===null||dataSources===void 0?void 0:dataSources.reduce((map,dataSource)=>map.set(dataSource.id,dataSource),new Map);return this.data})})}}exports.DataSourceColumn=DataSourceColumn},2542:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"AuthenticationMethod",{enumerable:true,get:function(){return _authentication_methods_registry.AuthenticationMethod}});Object.defineProperty(exports,"AuthenticationMethodRegistry",{enumerable:true,get:function(){return _authentication_methods_registry.AuthenticationMethodRegistry}});Object.defineProperty(exports,"IAuthenticationMethodRegistry",{enumerable:true,get:function(){return _authentication_methods_registry.IAuthenticationMethodRegistry}});var _authentication_methods_registry=__webpack_require__(2543)},2543:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.AuthenticationMethodRegistry=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _std=__webpack_require__(25);class AuthenticationMethodRegistry{constructor(){(0,_defineProperty2.default)(this,"authMethods",new Map)}registerAuthenticationMethod(method){if(this.authMethods.has(method.name)){throw new Error("Authentication method '".concat(method.name,"' is already registered"))}this.authMethods.set(method.name,(0,_std.deepFreeze)(method))}getAllAuthenticationMethods(){return[...this.authMethods.values()]}getAuthenticationMethod(name){return this.authMethods.get(name)}}exports.AuthenticationMethodRegistry=AuthenticationMethodRegistry},2544:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"DataSourceAggregatedView",{enumerable:true,get:function(){return _data_source_aggregated_view.DataSourceAggregatedView}});var _data_source_aggregated_view=__webpack_require__(2545)},2545:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.DataSourceAggregatedView=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);var _utils=__webpack_require__(2091);var _no_data_source=__webpack_require__(2139);var _data_source_error_menu=__webpack_require__(2111);var _data_source_item=__webpack_require__(2102);var _drop_down_header=__webpack_require__(2103);__webpack_require__(2580);var _popover_button=__webpack_require__(2140);function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter((function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable}))),t.push.apply(t,o)}return t}function _objectSpread(e){for(var r=1;r<arguments.length;r++){var t=null!=arguments[r]?arguments[r]:{};r%2?ownKeys(Object(t),!0).forEach((function(r){(0,_defineProperty2.default)(e,r,t[r])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach((function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r))}))}return e}class DataSourceAggregatedView extends _react.default.Component{constructor(props){super(props);(0,_defineProperty2.default)(this,"_isMounted",false);this.state={isPopoverOpen:false,allDataSourcesIdToTitleMap:new Map,showEmptyState:false,showError:false,switchChecked:false,defaultDataSource:null,incompatibleDataSourcesExist:false,componentId:(0,_utils.generateComponentId)()}}componentWillUnmount(){this._isMounted=false;(0,_utils.getDataSourceSelection)().remove(this.state.componentId)}onDataSourcesClick(){this.setState(_objectSpread(_objectSpread({},this.state),{},{isPopoverOpen:!this.state.isPopoverOpen}))}onSwitchClick(e){this.setState(_objectSpread(_objectSpread({},this.state),{},{switchChecked:e.target.checked}))}closePopover(){this.setState(_objectSpread(_objectSpread({},this.state),{},{isPopoverOpen:false}))}async componentDidMount(){this._isMounted=true;(0,_utils.getDataSourcesWithFields)(this.props.savedObjectsClient,["id","title","auth.type"]).then(fetchedDataSources=>{var _getDefaultDataSource;const allDataSourcesIdToTitleMap=new Map;if(fetchedDataSources!==null&&fetchedDataSources!==void 0&&fetchedDataSources.length){let filteredDataSources=fetchedDataSources;if(this.props.dataSourceFilter){filteredDataSources=fetchedDataSources.filter(ds=>this.props.dataSourceFilter(ds))}filteredDataSources.forEach(ds=>{allDataSourcesIdToTitleMap.set(ds.id,ds.attributes.title||"")});if(!this._isMounted)return}if(!this.props.hideLocalCluster){allDataSourcesIdToTitleMap.set("","Local cluster")}if(allDataSourcesIdToTitleMap.size===0){(0,_utils.handleNoAvailableDataSourceError)({changeState:this.onEmptyState.bind(this,!!(fetchedDataSources!==null&&fetchedDataSources!==void 0&&fetchedDataSources.length)),notifications:this.props.notifications,application:this.props.application,incompatibleDataSourcesExist:!!(fetchedDataSources!==null&&fetchedDataSources!==void 0&&fetchedDataSources.length)});return}this.setState(_objectSpread(_objectSpread({},this.state),{},{allDataSourcesIdToTitleMap:allDataSourcesIdToTitleMap,defaultDataSource:(_getDefaultDataSource=(0,_utils.getDefaultDataSourceId)(this.props.uiSettings))!==null&&_getDefaultDataSource!==void 0?_getDefaultDataSource:null,showEmptyState:allDataSourcesIdToTitleMap.size===0}))}).catch(()=>{(0,_utils.handleDataSourceFetchError)(this.onError.bind(this),this.props.notifications)})}onEmptyState(incompatibleDataSourcesExist){this.setState({showEmptyState:true,incompatibleDataSourcesExist:incompatibleDataSourcesExist})}onError(){this.setState({showError:true})}render(){if(this.state.showEmptyState){return _react.default.createElement(_no_data_source.NoDataSource,{application:this.props.application,incompatibleDataSourcesExist:this.state.incompatibleDataSourcesExist})}if(this.state.showError){return _react.default.createElement(_data_source_error_menu.DataSourceErrorMenu,{application:this.props.application})}let items=[];if(!this.props.displayAllCompatibleDataSources&&this.state.switchChecked){items=this.props.activeDataSourceIds.filter(id=>this.state.allDataSourcesIdToTitleMap.has(id)).map(id=>({id:id,label:this.state.allDataSourcesIdToTitleMap.get(id),disabled:true,checked:"on"}))}else{this.state.allDataSourcesIdToTitleMap.forEach((label,id)=>{items.push({id:id,label:label,disabled:true,checked:!this.props.displayAllCompatibleDataSources&&this.props.activeDataSourceIds&&this.props.activeDataSourceIds.length&&this.props.activeDataSourceIds.includes(id)?"on":undefined})})}const selectedItems=items.filter(item=>item.checked==="on");(0,_utils.getDataSourceSelection)().selectDataSource(this.state.componentId,selectedItems);const numSelectedItems=selectedItems.length;const titleComponent=_react.default.createElement(_drop_down_header.DataSourceDropDownHeader,{totalDataSourceCount:this.state.allDataSourcesIdToTitleMap.size,activeDataSourceCount:!this.props.displayAllCompatibleDataSources?numSelectedItems:undefined,application:(0,_utils.getApplication)()});return _react.default.createElement(_react.default.Fragment,null,_react.default.createElement(_eui.EuiPopover,{id:"dataSourceSViewContextMenuPopover",button:_react.default.createElement(_popover_button.DataSourceMenuPopoverButton,{className:"dataSourceAggregatedView",onClick:this.onDataSourcesClick.bind(this)}),isOpen:this.state.isPopoverOpen,closePopover:this.closePopover.bind(this),panelPaddingSize:"none",anchorPosition:"downLeft"},titleComponent,_react.default.createElement(_eui.EuiContextMenuPanel,null,_react.default.createElement(_eui.EuiPanel,{className:"dataSourceAggregatedViewOuiPanel",paddingSize:"none",borderRadius:"none",hasShadow:false},_react.default.createElement(_eui.EuiPanel,{className:"dataSourceAggregatedViewOuiPanel",color:"subdued",paddingSize:"s",borderRadius:"none"},_react.default.createElement(_eui.EuiSelectable,{options:items,renderOption:option=>_react.default.createElement(_data_source_item.DataSourceItem,{className:this.props.displayAllCompatibleDataSources?"dataSourceAggregatedView":"dataSourceListAllActive",option:option,defaultDataSource:this.state.defaultDataSource})},list=>list))),!this.props.displayAllCompatibleDataSources&&_react.default.createElement(_eui.EuiPanel,{className:"dataSourceAggregatedViewOuiPanel",color:"transparent",hasBorder:false,hasShadow:false,borderRadius:"m"},_react.default.createElement(_eui.EuiSwitch,{className:"dataSourceAggregatedViewOuiSwitch",label:"Used on this page (".concat(numSelectedItems,")"),checked:this.state.switchChecked,onChange:e=>this.onSwitchClick(e),compressed:true})))))}}exports.DataSourceAggregatedView=DataSourceAggregatedView},2546:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.NoDataSource=void 0;var _react=_interopRequireWildcard(__webpack_require__(2));var _i18n=__webpack_require__(3);var _eui=__webpack_require__(6);var _reactIntl=__webpack_require__(2547);var _drop_down_header=__webpack_require__(2103);var _plugin=__webpack_require__(2101);var _custom_database_icon=__webpack_require__(2197);var _constants=__webpack_require__(2110);function _getRequireWildcardCache(e){if("function"!=typeof WeakMap)return null;var r=new WeakMap,t=new WeakMap;return(_getRequireWildcardCache=function(e){return e?t:r})(e)}function _interopRequireWildcard(e,r){if(!r&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var t=_getRequireWildcardCache(r);if(t&&t.has(e))return t.get(e);var n={__proto__:null},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var u in e)if("default"!==u&&Object.prototype.hasOwnProperty.call(e,u)){var i=a?Object.getOwnPropertyDescriptor(e,u):null;i&&(i.get||i.set)?Object.defineProperty(n,u,i):n[u]=e[u]}return n.default=e,t&&t.set(e,n),n}const NoDataSource=_ref=>{let{application:application,incompatibleDataSourcesExist:incompatibleDataSourcesExist}=_ref;const[showPopover,setShowPopover]=(0,_react.useState)(false);const button=_react.default.createElement(_eui.EuiButtonIcon,{className:"euiHeaderLink","data-test-subj":"dataSourceEmptyMenuHeaderLink","aria-label":_i18n.i18n.translate("dataSourceEmpty.dataSourceEmptyMenuHeaderLink",{defaultMessage:"dataSourceEmptyMenuHeaderLink"}),iconType:()=>_react.default.createElement(_custom_database_icon.EmptyIcon,null),size:"s",onClick:()=>setShowPopover(!showPopover)});const redirectButton=_react.default.createElement(_eui.EuiButton,{"data-test-subj":"dataSourceEmptyStateManageDataSourceButton",fill:false,size:"s",onClick:()=>application===null||application===void 0?void 0:application.navigateToApp("management",{path:"opensearch-dashboards/".concat(_plugin.DSM_APP_ID)})},_react.default.createElement(_reactIntl.FormattedMessage,{id:"dataSourcesManagement.dataSourceMenu.manageDataSource",defaultMessage:"Manage data sources"}));const text=_react.default.createElement(_react.default.Fragment,null,_react.default.createElement(_eui.EuiText,{size:"s",textAlign:"center"},_react.default.createElement(_reactIntl.FormattedMessage,{id:"dataSourcesManagement.dataSourceEmptyMenu.noData",defaultMessage:incompatibleDataSourcesExist?_constants.NO_COMPATIBLE_DATASOURCES_MESSAGE:_constants.NO_DATASOURCES_CONNECTED_MESSAGE})),_react.default.createElement(_eui.EuiText,{size:"s",textAlign:"center"},_react.default.createElement(_reactIntl.FormattedMessage,{id:"dataSourcesManagement.dataSourceEmptyMenu.connect",defaultMessage:incompatibleDataSourcesExist?_constants.ADD_COMPATIBLE_DATASOURCES_MESSAGE:_constants.CONNECT_DATASOURCES_MESSAGE})));return _react.default.createElement(_eui.EuiPopover,{id:"dataSourceEmptyStatePopover",button:button,isOpen:showPopover,closePopover:()=>setShowPopover(false),panelPaddingSize:"none",anchorPosition:"downLeft","data-test-subj":"dataSourceEmptyStatePopover"},_react.default.createElement(_drop_down_header.DataSourceDropDownHeader,{totalDataSourceCount:0,application:application}),_react.default.createElement(_eui.EuiPanel,{hasBorder:false,hasShadow:false,className:"dataSourceEmptyStatePanel","data-test-subj":"dataSourceEmptyStatePanel"},_react.default.createElement(_eui.EuiFlexGroup,{justifyContent:"center"},_react.default.createElement(_eui.EuiFlexItem,{grow:false},text)),_react.default.createElement(_eui.EuiFlexGroup,{justifyContent:"center"},_react.default.createElement(_eui.EuiFlexItem,{grow:false},redirectButton))))};exports.NoDataSource=NoDataSource},2548:function(module,exports){},2556:function(module,exports){},2563:function(module,exports){},2567:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.DataSourceDropDownHeader=void 0;__webpack_require__(2568);var _eui=__webpack_require__(6);var _react=_interopRequireDefault(__webpack_require__(2));var _plugin=__webpack_require__(2101);const DataSourceDropDownHeader=_ref=>{let{activeDataSourceCount:activeDataSourceCount,totalDataSourceCount:totalDataSourceCount,application:application}=_ref;const dataSourceCounterPrefix=totalDataSourceCount===1?"DATA SOURCE":"DATA SOURCES";const dataSourceCounter=activeDataSourceCount!==undefined?"".concat(activeDataSourceCount,"/").concat(totalDataSourceCount):totalDataSourceCount;return _react.default.createElement(_eui.EuiPopoverTitle,{paddingSize:"s"},_react.default.createElement(_eui.EuiFlexGroup,{responsive:false,alignItems:"center"},_react.default.createElement(_eui.EuiFlexItem,null,dataSourceCounterPrefix," (",dataSourceCounter,")"),_react.default.createElement("div",{tabIndex:0,className:"dataSourceDropDownHeaderInvisibleFocusable"}),_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiLink,{onClick:()=>application===null||application===void 0?void 0:application.navigateToApp("management",{path:"opensearch-dashboards/".concat(_plugin.DSM_APP_ID)})},"Manage"))))};exports.DataSourceDropDownHeader=DataSourceDropDownHeader},2568:function(module,exports,__webpack_require__){switch(window.__osdThemeTag__){case"v7dark":return __webpack_require__(2569);case"v7light":return __webpack_require__(2571);case"v8dark":return __webpack_require__(2573);case"v8light":return __webpack_require__(2575)}},2569:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2570);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2570:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceDropDownHeaderInvisibleFocusable{opacity:0}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2571:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2572);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2572:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceDropDownHeaderInvisibleFocusable{opacity:0}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2573:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2574);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2574:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceDropDownHeaderInvisibleFocusable{opacity:0}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2575:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2576);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2576:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceDropDownHeaderInvisibleFocusable{opacity:0}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2577:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.ErrorIcon=void 0;var _react=_interopRequireDefault(__webpack_require__(2));const ErrorIcon=()=>_react.default.createElement("svg",{width:"16",height:"16",viewBox:"0 0 16 16",fill:"none",xmlns:"http://www.w3.org/2000/svg"},_react.default.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M6.88072 12.9734C7.24621 12.991 7.62038 13 8 13C9.79424 13 11.4669 12.7979 12.675 12.4527C12.7139 12.4416 12.7534 12.4304 12.7931 12.419C13.2562 12.2873 13.7656 12.1424 14.0018 12H14V10.0307C12.7751 10.6115 10.5463 11 8 11C7.61431 11 7.23591 10.9911 6.86718 10.9739C6.77052 10.6087 6.62348 10.2639 6.43395 9.94748C6.93903 9.98197 7.46409 10 8 10C9.79424 10 11.4669 9.79786 12.675 9.45269C12.7139 9.44158 12.7534 9.43036 12.7931 9.41904C13.2562 9.28731 13.7656 9.1424 14.0018 9H14V7.03074C12.7751 7.61155 10.5463 8 8 8C5.45367 8 3.2249 7.61155 2 7.03074V8.12602C1.64523 8.21733 1.30951 8.35609 1 8.53513V3C1 1.89543 4.13401 1 8 1C11.866 1 15 1.89543 15 3V12C15 13.1046 11.866 14 8 14C7.48207 14 6.97727 13.9839 6.49139 13.9534C6.66201 13.6491 6.79401 13.3202 6.88072 12.9734ZM2 6V4.03074C3.2249 4.61155 5.45367 5 8 5C10.5463 5 12.7751 4.61155 14 4.03074V6H14.0018C13.7656 6.1424 13.2562 6.28731 12.7931 6.41904C12.7534 6.43036 12.7139 6.44158 12.675 6.45269C11.4669 6.79786 9.79424 7 8 7C6.20576 7 4.53308 6.79786 3.32497 6.45269C3.28838 6.44223 3.25131 6.43168 3.21394 6.42104C2.74926 6.28878 2.23754 6.14312 2.00012 6H2ZM8 2C9.79424 2 11.4669 2.20214 12.675 2.54731C13.1666 2.68777 13.5549 2.84537 13.8114 3C13.5549 3.15463 13.1666 3.31223 12.675 3.45269C11.4669 3.79786 9.79424 4 8 4C6.20576 4 4.53308 3.79786 3.32497 3.45269C2.83335 3.31223 2.44512 3.15463 2.1886 3C2.44512 2.84537 2.83335 2.68777 3.32497 2.54731C4.53308 2.20214 6.20576 2 8 2Z",fill:"currentColor"}),_react.default.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M6 12C6 13.6569 4.65685 15 3 15C1.34315 15 0 13.6569 0 12C0 10.3431 1.34315 9 3 9C4.65685 9 6 10.3431 6 12Z",fill:"#BD271E"}));exports.ErrorIcon=ErrorIcon},2578:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.EmptyIcon=void 0;var _react=_interopRequireDefault(__webpack_require__(2));const EmptyIcon=()=>_react.default.createElement("svg",{width:"16",height:"16",viewBox:"0 0 16 16",fill:"none",xmlns:"http://www.w3.org/2000/svg"},_react.default.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M6.88072 12.9734C7.24621 12.991 7.62038 13 8 13C9.79424 13 11.4669 12.7979 12.675 12.4527C12.7139 12.4416 12.7534 12.4304 12.7931 12.419C13.2562 12.2873 13.7656 12.1424 14.0018 12H14V10.0307C12.7751 10.6115 10.5463 11 8 11C7.61431 11 7.23591 10.9911 6.86718 10.9739C6.77052 10.6087 6.62348 10.2639 6.43395 9.94748C6.93903 9.98197 7.46409 10 8 10C9.79424 10 11.4669 9.79786 12.675 9.45269C12.7139 9.44158 12.7534 9.43036 12.7931 9.41904C13.2562 9.28731 13.7656 9.1424 14.0018 9H14V7.03074C12.7751 7.61155 10.5463 8 8 8C5.45367 8 3.2249 7.61155 2 7.03074V8.12602C1.64523 8.21733 1.30951 8.35609 1 8.53513V3C1 1.89543 4.13401 1 8 1C11.866 1 15 1.89543 15 3V12C15 13.1046 11.866 14 8 14C7.48207 14 6.97727 13.9839 6.49139 13.9534C6.66201 13.6491 6.79401 13.3202 6.88072 12.9734ZM2 6V4.03074C3.2249 4.61155 5.45367 5 8 5C10.5463 5 12.7751 4.61155 14 4.03074V6H14.0018C13.7656 6.1424 13.2562 6.28731 12.7931 6.41904C12.7534 6.43036 12.7139 6.44158 12.675 6.45269C11.4669 6.79786 9.79424 7 8 7C6.20576 7 4.53308 6.79786 3.32497 6.45269C3.28838 6.44223 3.25131 6.43168 3.21394 6.42104C2.74926 6.28878 2.23754 6.14312 2.00012 6H2ZM8 2C9.79424 2 11.4669 2.20214 12.675 2.54731C13.1666 2.68777 13.5549 2.84537 13.8114 3C13.5549 3.15463 13.1666 3.31223 12.675 3.45269C11.4669 3.79786 9.79424 4 8 4C6.20576 4 4.53308 3.79786 3.32497 3.45269C2.83335 3.31223 2.44512 3.15463 2.1886 3C2.44512 2.84537 2.83335 2.68777 3.32497 2.54731C4.53308 2.20214 6.20576 2 8 2Z",fill:"#006BB4"}),_react.default.createElement("mask",{id:"path-2-inside-1_1269_81032",fill:"white"},_react.default.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M6 12C6 13.6569 4.65685 15 3 15C1.34315 15 0 13.6569 0 12C0 10.3431 1.34315 9 3 9C4.65685 9 6 10.3431 6 12Z"})),_react.default.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M6 12C6 13.6569 4.65685 15 3 15C1.34315 15 0 13.6569 0 12C0 10.3431 1.34315 9 3 9C4.65685 9 6 10.3431 6 12Z",fill:"#FAFBFD"}),_react.default.createElement("path",{d:"M3 16C5.20914 16 7 14.2091 7 12H5C5 13.1046 4.10457 14 3 14V16ZM-1 12C-1 14.2091 0.790861 16 3 16V14C1.89543 14 1 13.1046 1 12H-1ZM3 8C0.790861 8 -1 9.79086 -1 12H1C1 10.8954 1.89543 10 3 10V8ZM7 12C7 9.79086 5.20914 8 3 8V10C4.10457 10 5 10.8954 5 12H7Z",fill:"#6A717D",mask:"url(#path-2-inside-1_1269_81032)"}));exports.EmptyIcon=EmptyIcon},2579:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.DataSourceErrorMenu=void 0;var _react=_interopRequireWildcard(__webpack_require__(2));var _i18n=__webpack_require__(3);var _eui=__webpack_require__(6);var _custom_database_icon=__webpack_require__(2197);var _drop_down_header=__webpack_require__(2103);function _getRequireWildcardCache(e){if("function"!=typeof WeakMap)return null;var r=new WeakMap,t=new WeakMap;return(_getRequireWildcardCache=function(e){return e?t:r})(e)}function _interopRequireWildcard(e,r){if(!r&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var t=_getRequireWildcardCache(r);if(t&&t.has(e))return t.get(e);var n={__proto__:null},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var u in e)if("default"!==u&&Object.prototype.hasOwnProperty.call(e,u)){var i=a?Object.getOwnPropertyDescriptor(e,u):null;i&&(i.get||i.set)?Object.defineProperty(n,u,i):n[u]=e[u]}return n.default=e,t&&t.set(e,n),n}const DataSourceErrorMenu=_ref=>{let{application:application}=_ref;const[showPopover,setShowPopover]=(0,_react.useState)(false);const refreshButton=_react.default.createElement(_eui.EuiButton,{"data-test-subj":"dataSourceErrorRefreshButton",fill:false,iconType:"refresh",size:"s",onClick:()=>window.location.reload()},_i18n.i18n.translate("dataSourcesManagement.dataSourceErrorMenu.refreshPage",{defaultMessage:"Refresh the page"}));const iconButton=_react.default.createElement(_eui.EuiButtonIcon,{className:"euiHeaderLink","data-test-subj":"dataSourceErrorMenuHeaderLink","aria-label":_i18n.i18n.translate("dataSourceError.dataSourceErrorMenuHeaderLink",{defaultMessage:"dataSourceErrorMenuHeaderLink"}),iconType:()=>_react.default.createElement(_custom_database_icon.ErrorIcon,null),size:"s",onClick:()=>setShowPopover(!showPopover)});return _react.default.createElement(_react.default.Fragment,null,_react.default.createElement(_eui.EuiPopover,{id:"dataSourceErrorPopover",button:iconButton,isOpen:showPopover,closePopover:()=>setShowPopover(false),panelPaddingSize:"none",anchorPosition:"downLeft","data-test-subj":"dataSourceErrorPopover"},_react.default.createElement(_drop_down_header.DataSourceDropDownHeader,{totalDataSourceCount:0,application:application}),_react.default.createElement(_eui.EuiPanel,{hasBorder:false,hasShadow:false,className:"dataSourceEmptyStatePanel","data-test-subj":"datasourceTableEmptyState"},_react.default.createElement(_eui.EuiText,{size:"s",textAlign:"center"},_i18n.i18n.translate("dataSourcesManagement.dataSourceErrorMenu.text",{defaultMessage:"Failed to fetch data sources"}))),_react.default.createElement(_eui.EuiPopoverFooter,null,_react.default.createElement(_eui.EuiFlexGroup,{justifyContent:"spaceAround"},_react.default.createElement(_eui.EuiFlexItem,null,refreshButton)))))};exports.DataSourceErrorMenu=DataSourceErrorMenu},2580:function(module,exports,__webpack_require__){switch(window.__osdThemeTag__){case"v7dark":return __webpack_require__(2581);case"v7light":return __webpack_require__(2583);case"v8dark":return __webpack_require__(2585);case"v8light":return __webpack_require__(2587)}},2581:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2582);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2582:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceAggregatedViewOuiPanel{width:300px;border-left-width:0;border-right-width:0;border-top-width:0}.dataSourceAggregatedViewOuiPanel .euiSelectableListItem{cursor:default}.dataSourceAggregatedViewOuiPanel .euiSelectableListItem__content{cursor:default;padding-left:0;margin-right:0}.dataSourceAggregatedViewOuiPanel .euiSelectableListItem__content .euiSelectableListItem__text{max-height:100%}.dataSourceAggregatedViewOuiPanel .euiSelectableListItem__content .euiSelectableListItem__icon,.dataSourceAggregatedViewOuiPanel .euiSelectableListItem__content .euiSelectableListItem__prepend{margin-right:0}.dataSourceAggregatedViewOuiPanel .dataSourceAggregatedViewOuiFlexGroup .euiFlexItem{max-width:fit-content}.dataSourceAggregatedViewOuiPanel .dataSourceAggregatedViewOuiFlexGroup .dataSourceAggregatedViewOuiFlexItem{color:gray;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block;padding-left:0}.dataSourceAggregatedViewOuiPanel .dataSourceAggregatedViewOuiSwitch{display:flex;align-items:center;justify-content:center}.dataSourceAggregatedViewOuiPanel .dataSourceAggregatedViewOuiFlexItem{color:gray;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block;padding-left:0}.dataSourceAggregatedViewOuiPanel .dataSourceListAllActiveOuiFlexItem{color:gray;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block;padding-left:1em}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2583:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2584);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2584:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceAggregatedViewOuiPanel{width:300px;border-left-width:0;border-right-width:0;border-top-width:0}.dataSourceAggregatedViewOuiPanel .euiSelectableListItem{cursor:default}.dataSourceAggregatedViewOuiPanel .euiSelectableListItem__content{cursor:default;padding-left:0;margin-right:0}.dataSourceAggregatedViewOuiPanel .euiSelectableListItem__content .euiSelectableListItem__text{max-height:100%}.dataSourceAggregatedViewOuiPanel .euiSelectableListItem__content .euiSelectableListItem__icon,.dataSourceAggregatedViewOuiPanel .euiSelectableListItem__content .euiSelectableListItem__prepend{margin-right:0}.dataSourceAggregatedViewOuiPanel .dataSourceAggregatedViewOuiFlexGroup .euiFlexItem{max-width:fit-content}.dataSourceAggregatedViewOuiPanel .dataSourceAggregatedViewOuiFlexGroup .dataSourceAggregatedViewOuiFlexItem{color:gray;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block;padding-left:0}.dataSourceAggregatedViewOuiPanel .dataSourceAggregatedViewOuiSwitch{display:flex;align-items:center;justify-content:center}.dataSourceAggregatedViewOuiPanel .dataSourceAggregatedViewOuiFlexItem{color:gray;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block;padding-left:0}.dataSourceAggregatedViewOuiPanel .dataSourceListAllActiveOuiFlexItem{color:gray;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block;padding-left:1em}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2585:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2586);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2586:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceAggregatedViewOuiPanel{width:300px;border-left-width:0;border-right-width:0;border-top-width:0}.dataSourceAggregatedViewOuiPanel .euiSelectableListItem{cursor:default}.dataSourceAggregatedViewOuiPanel .euiSelectableListItem__content{cursor:default;padding-left:0;margin-right:0}.dataSourceAggregatedViewOuiPanel .euiSelectableListItem__content .euiSelectableListItem__text{max-height:100%}.dataSourceAggregatedViewOuiPanel .euiSelectableListItem__content .euiSelectableListItem__icon,.dataSourceAggregatedViewOuiPanel .euiSelectableListItem__content .euiSelectableListItem__prepend{margin-right:0}.dataSourceAggregatedViewOuiPanel .dataSourceAggregatedViewOuiFlexGroup .euiFlexItem{max-width:fit-content}.dataSourceAggregatedViewOuiPanel .dataSourceAggregatedViewOuiFlexGroup .dataSourceAggregatedViewOuiFlexItem{color:gray;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block;padding-left:0}.dataSourceAggregatedViewOuiPanel .dataSourceAggregatedViewOuiSwitch{display:flex;align-items:center;justify-content:center}.dataSourceAggregatedViewOuiPanel .dataSourceAggregatedViewOuiFlexItem{color:gray;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block;padding-left:0}.dataSourceAggregatedViewOuiPanel .dataSourceListAllActiveOuiFlexItem{color:gray;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block;padding-left:1em}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2587:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2588);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2588:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceAggregatedViewOuiPanel{width:300px;border-left-width:0;border-right-width:0;border-top-width:0}.dataSourceAggregatedViewOuiPanel .euiSelectableListItem{cursor:default}.dataSourceAggregatedViewOuiPanel .euiSelectableListItem__content{cursor:default;padding-left:0;margin-right:0}.dataSourceAggregatedViewOuiPanel .euiSelectableListItem__content .euiSelectableListItem__text{max-height:100%}.dataSourceAggregatedViewOuiPanel .euiSelectableListItem__content .euiSelectableListItem__icon,.dataSourceAggregatedViewOuiPanel .euiSelectableListItem__content .euiSelectableListItem__prepend{margin-right:0}.dataSourceAggregatedViewOuiPanel .dataSourceAggregatedViewOuiFlexGroup .euiFlexItem{max-width:fit-content}.dataSourceAggregatedViewOuiPanel .dataSourceAggregatedViewOuiFlexGroup .dataSourceAggregatedViewOuiFlexItem{color:gray;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block;padding-left:0}.dataSourceAggregatedViewOuiPanel .dataSourceAggregatedViewOuiSwitch{display:flex;align-items:center;justify-content:center}.dataSourceAggregatedViewOuiPanel .dataSourceAggregatedViewOuiFlexItem{color:gray;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block;padding-left:0}.dataSourceAggregatedViewOuiPanel .dataSourceListAllActiveOuiFlexItem{color:gray;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block;padding-left:1em}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2589:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"DataSourceView",{enumerable:true,get:function(){return _data_source_view.DataSourceView}});var _data_source_view=__webpack_require__(2590)},2590:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.DataSourceView=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);var _data_source_error_menu=__webpack_require__(2111);var _utils=__webpack_require__(2091);var _drop_down_header=__webpack_require__(2103);var _data_source_item=__webpack_require__(2102);var _constants=__webpack_require__(2110);__webpack_require__(2591);var _popover_button=__webpack_require__(2140);function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter((function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable}))),t.push.apply(t,o)}return t}function _objectSpread(e){for(var r=1;r<arguments.length;r++){var t=null!=arguments[r]?arguments[r]:{};r%2?ownKeys(Object(t),!0).forEach((function(r){(0,_defineProperty2.default)(e,r,t[r])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach((function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r))}))}return e}class DataSourceView extends _react.default.Component{constructor(props){super(props);(0,_defineProperty2.default)(this,"_isMounted",false);this.state={isPopoverOpen:false,selectedOption:this.props.selectedOption?this.props.selectedOption:[],showEmptyState:false,showError:false,defaultDataSource:null,componentId:(0,_utils.generateComponentId)()}}componentWillUnmount(){this._isMounted=false;(0,_utils.getDataSourceSelection)().remove(this.state.componentId)}async componentDidMount(){var _getDefaultDataSource;this._isMounted=true;const selectedOption=this.props.selectedOption;const option=selectedOption[0];const optionId=option.id;const defaultDataSource=(_getDefaultDataSource=(0,_utils.getDefaultDataSourceId)(this.props.uiSettings))!==null&&_getDefaultDataSource!==void 0?_getDefaultDataSource:null;if(optionId===""&&!this.props.hideLocalCluster){this.setState({selectedOption:[_constants.LocalCluster],defaultDataSource:defaultDataSource});this.onSelectedDataSources([_constants.LocalCluster]);return}if(optionId===""&&this.props.hideLocalCluster||this.props.dataSourceFilter&&this.props.selectedOption.filter(this.props.dataSourceFilter).length===0){this.setState({selectedOption:[]});this.onSelectedDataSources([]);return}if(!option.label){try{const selectedDataSource=await(0,_utils.getDataSourceById)(optionId,this.props.savedObjectsClient);if(!this._isMounted)return;this.setState({selectedOption:[{id:optionId,label:selectedDataSource.title}],defaultDataSource:defaultDataSource});this.onSelectedDataSources([{id:optionId,label:selectedDataSource.title}])}catch(error){(0,_utils.handleDataSourceFetchError)(this.onError.bind(this),this.props.notifications,this.onSelectedDataSources.bind(this))}}else{this.setState(_objectSpread(_objectSpread({},this.state),{},{defaultDataSource:defaultDataSource}));this.onSelectedDataSources([option])}}onSelectedDataSources(dataSource){(0,_utils.getDataSourceSelection)().selectDataSource(this.state.componentId,dataSource);if(this.props.onSelectedDataSources){this.props.onSelectedDataSources(dataSource)}}onError(){this.setState({showError:true})}onClick(){this.setState(_objectSpread(_objectSpread({},this.state),{},{isPopoverOpen:!this.state.isPopoverOpen}))}closePopover(){this.setState(_objectSpread(_objectSpread({},this.state),{},{isPopoverOpen:false}))}render(){if(this.state.showError){return _react.default.createElement(_data_source_error_menu.DataSourceErrorMenu,{application:this.props.application})}const label=this.state.selectedOption.length>0&&this.state.selectedOption[0].label?this.state.selectedOption[0].label:"";const options=this.state.selectedOption.length>0?this.state.selectedOption.map(option=>_objectSpread(_objectSpread({},option),{},{checked:"on",disabled:true})):[];return _react.default.createElement(_eui.EuiPopover,{id:"dataSourceViewPopover",button:_react.default.createElement(_popover_button.DataSourceMenuPopoverButton,{className:"dataSourceView",label:label,onClick:this.onClick.bind(this)}),isOpen:this.state.isPopoverOpen,closePopover:this.closePopover.bind(this),panelPaddingSize:"none",anchorPosition:"downLeft"},_react.default.createElement(_drop_down_header.DataSourceDropDownHeader,{totalDataSourceCount:1,application:this.props.application}),_react.default.createElement(_eui.EuiContextMenuPanel,{className:"dataSourceViewOuiPanel"},_react.default.createElement(_eui.EuiPanel,{color:"subdued",paddingSize:"none",borderRadius:"none"},_react.default.createElement(_eui.EuiSelectable,{options:options,singleSelection:true,"data-test-subj":"dataSourceView",renderOption:option=>_react.default.createElement(_data_source_item.DataSourceItem,{option:option,defaultDataSource:this.state.defaultDataSource,className:"dataSourceView"})},list=>list))))}}exports.DataSourceView=DataSourceView},2591:function(module,exports,__webpack_require__){switch(window.__osdThemeTag__){case"v7dark":return __webpack_require__(2592);case"v7light":return __webpack_require__(2594);case"v8dark":return __webpack_require__(2596);case"v8light":return __webpack_require__(2598)}},2592:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2593);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2593:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceViewOuiPanel{width:300px}.dataSourceViewOuiPanel .euiSelectableListItem__text{max-height:100%}.dataSourceViewOuiFlexGroup .euiFlexItem{max-width:fit-content}.dataSourceViewOuiFlexGroup .dataSourceViewOuiFlexItem{color:gray;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2594:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2595);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2595:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceViewOuiPanel{width:300px}.dataSourceViewOuiPanel .euiSelectableListItem__text{max-height:100%}.dataSourceViewOuiFlexGroup .euiFlexItem{max-width:fit-content}.dataSourceViewOuiFlexGroup .dataSourceViewOuiFlexItem{color:gray;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2596:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2597);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2597:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceViewOuiPanel{width:300px}.dataSourceViewOuiPanel .euiSelectableListItem__text{max-height:100%}.dataSourceViewOuiFlexGroup .euiFlexItem{max-width:fit-content}.dataSourceViewOuiFlexGroup .dataSourceViewOuiFlexItem{color:gray;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2598:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2599);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2599:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceViewOuiPanel{width:300px}.dataSourceViewOuiPanel .euiSelectableListItem__text{max-height:100%}.dataSourceViewOuiFlexGroup .euiFlexItem{max-width:fit-content}.dataSourceViewOuiFlexGroup .dataSourceViewOuiFlexItem{color:gray;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2600:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"DataSourceMultiSelectable",{enumerable:true,get:function(){return _data_source_multi_selectable.DataSourceMultiSelectable}});var _data_source_multi_selectable=__webpack_require__(2601)},2601:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.DataSourceMultiSelectable=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _react=_interopRequireDefault(__webpack_require__(2));var _data_source_filter_group=__webpack_require__(2602);var _no_data_source=__webpack_require__(2139);var _utils=__webpack_require__(2091);var _data_source_error_menu=__webpack_require__(2111);function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter((function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable}))),t.push.apply(t,o)}return t}function _objectSpread(e){for(var r=1;r<arguments.length;r++){var t=null!=arguments[r]?arguments[r]:{};r%2?ownKeys(Object(t),!0).forEach((function(r){(0,_defineProperty2.default)(e,r,t[r])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach((function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r))}))}return e}class DataSourceMultiSelectable extends _react.default.Component{constructor(props){super(props);(0,_defineProperty2.default)(this,"_isMounted",false);this.state={dataSourceOptions:[],selectedOptions:[],defaultDataSource:null,showEmptyState:false,showError:false,incompatibleDataSourcesExist:false,componentId:(0,_utils.generateComponentId)()}}componentWillUnmount(){this._isMounted=false;const{componentId:componentId}=this.state;(0,_utils.getDataSourceSelection)().remove(componentId)}onSelectedDataSources(dataSources){(0,_utils.getDataSourceSelection)().selectDataSource(this.state.componentId,dataSources);if(this.props.onSelectedDataSources){this.props.onSelectedDataSources(dataSources)}}async componentDidMount(){this._isMounted=true;try{var _getDefaultDataSource;const defaultDataSource=(_getDefaultDataSource=(0,_utils.getDefaultDataSourceId)(this.props.uiSettings))!==null&&_getDefaultDataSource!==void 0?_getDefaultDataSource:null;let selectedOptions=[];const fetchedDataSources=await(0,_utils.getDataSourcesWithFields)(this.props.savedObjectsClient,["id","title","auth.type"]);if(fetchedDataSources!==null&&fetchedDataSources!==void 0&&fetchedDataSources.length){selectedOptions=fetchedDataSources.map(dataSource=>{var _dataSource$attribute;return{id:dataSource.id,label:((_dataSource$attribute=dataSource.attributes)===null||_dataSource$attribute===void 0?void 0:_dataSource$attribute.title)||"",checked:"on",visible:true}})}if(!this.props.hideLocalCluster){selectedOptions.unshift({id:"",label:"Local cluster",checked:"on",visible:true})}if(!this._isMounted)return;if(selectedOptions.length===0){(0,_utils.handleNoAvailableDataSourceError)({changeState:this.onEmptyState.bind(this,!!(fetchedDataSources!==null&&fetchedDataSources!==void 0&&fetchedDataSources.length)),notifications:this.props.notifications,application:this.props.application,callback:this.onSelectedDataSources.bind(this),incompatibleDataSourcesExist:!!(fetchedDataSources!==null&&fetchedDataSources!==void 0&&fetchedDataSources.length)});return}this.setState(_objectSpread(_objectSpread({},this.state),{},{selectedOptions:selectedOptions,defaultDataSource:defaultDataSource}));this.onSelectedDataSources(selectedOptions)}catch(error){(0,_utils.handleDataSourceFetchError)(this.onError.bind(this),this.props.notifications,this.onSelectedDataSources.bind(this))}}onEmptyState(incompatibleDataSourcesExist){this.setState({showEmptyState:true,incompatibleDataSourcesExist:incompatibleDataSourcesExist})}onError(){this.setState({showError:true})}onChange(selectedOptions){if(!this._isMounted)return;this.setState({selectedOptions:selectedOptions});this.onSelectedDataSources(selectedOptions.filter(option=>option.checked==="on"))}render(){if(this.state.showEmptyState){return _react.default.createElement(_no_data_source.NoDataSource,{application:this.props.application})}if(this.state.showError){return _react.default.createElement(_data_source_error_menu.DataSourceErrorMenu,{application:this.props.application})}return _react.default.createElement(_data_source_filter_group.DataSourceFilterGroup,{selectedOptions:this.state.selectedOptions,setSelectedOptions:this.onChange.bind(this),defaultDataSource:this.state.defaultDataSource})}}exports.DataSourceMultiSelectable=DataSourceMultiSelectable},2602:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.DataSourceFilterGroup=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _react=_interopRequireWildcard(__webpack_require__(2));var _eui=__webpack_require__(6);var _data_source_item=__webpack_require__(2102);__webpack_require__(2603);function _getRequireWildcardCache(e){if("function"!=typeof WeakMap)return null;var r=new WeakMap,t=new WeakMap;return(_getRequireWildcardCache=function(e){return e?t:r})(e)}function _interopRequireWildcard(e,r){if(!r&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var t=_getRequireWildcardCache(r);if(t&&t.has(e))return t.get(e);var n={__proto__:null},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var u in e)if("default"!==u&&Object.prototype.hasOwnProperty.call(e,u)){var i=a?Object.getOwnPropertyDescriptor(e,u):null;i&&(i.get||i.set)?Object.defineProperty(n,u,i):n[u]=e[u]}return n.default=e,t&&t.set(e,n),n}function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter((function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable}))),t.push.apply(t,o)}return t}function _objectSpread(e){for(var r=1;r<arguments.length;r++){var t=null!=arguments[r]?arguments[r]:{};r%2?ownKeys(Object(t),!0).forEach((function(r){(0,_defineProperty2.default)(e,r,t[r])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach((function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r))}))}return e}const selectionToggleButtons=[{id:"select_all",label:"Select all"},{id:"deselect_all",label:"Deselect all"}];const DataSourceFilterGroup=_ref=>{let{selectedOptions:selectedOptions,setSelectedOptions:setSelectedOptions,defaultDataSource:defaultDataSource}=_ref;const[isPopoverOpen,setIsPopoverOpen]=(0,_react.useState)(false);const[selectionToggleSelectedId,setSelectionToggleSelectedId]=(0,_react.useState)("select_all");const onButtonClick=()=>{setIsPopoverOpen(!isPopoverOpen)};const closePopover=()=>{setIsPopoverOpen(false)};function toggleItem(index){if(!selectedOptions[index]){return}const newItems=[...selectedOptions];if(newItems[index].checked==="on"){newItems[index]=_objectSpread(_objectSpread({},newItems[index]),{},{checked:undefined})}else{newItems[index]=_objectSpread(_objectSpread({},newItems[index]),{},{checked:"on"})}setSelectedOptions(newItems)}function onSelectionToggleChange(optionId){setSelectionToggleSelectedId(optionId);toggleAll(optionId==="select_all"?"on":undefined)}function toggleAll(state){const optionsAfterToggle=selectedOptions.map(option=>_objectSpread(_objectSpread({},option),{},{checked:state}));setSelectedOptions(optionsAfterToggle)}function search(term){const optionsAfterSearch=selectedOptions.map(option=>{option.visible=option.label.toLowerCase().includes(term.toLowerCase());return option});setSelectedOptions(optionsAfterSearch)}const numActiveSelections=selectedOptions.filter(option=>option.checked==="on").length;const button=_react.default.createElement(_react.default.Fragment,null,_react.default.createElement(_eui.EuiButtonEmpty,{className:"euiHeaderLink",onClick:onButtonClick,iconType:"database",size:"s","data-test-subj":"dataSourceFilterGroupButton"},"Data sources"),_react.default.createElement(_eui.EuiNotificationBadge,{color:"subdued"},numActiveSelections));return _react.default.createElement(_eui.EuiPopover,{id:"popoverExampleMultiSelect",button:button,isOpen:isPopoverOpen,closePopover:closePopover,panelPaddingSize:"none"},_react.default.createElement(_eui.EuiPopoverTitle,{paddingSize:"s"},_react.default.createElement(_eui.EuiFieldSearch,{compressed:true,onSearch:search,isClearable:true,"data-test-subj":"dataSourceMultiSelectFieldSearch"})),_react.default.createElement("div",{className:"dataSourceFilterGroupItems"},selectedOptions.map((item,index)=>{const itemStyle={};itemStyle.display=!item.visible?"none":itemStyle.display;return _react.default.createElement(_eui.EuiFilterSelectItem,{checked:item.checked,key:index,onClick:()=>toggleItem(index),showIcons:true,style:itemStyle},_react.default.createElement(_data_source_item.DataSourceItem,{option:item,defaultDataSource:defaultDataSource,className:"dataSourceFilterGroup"}))})),_react.default.createElement(_eui.EuiPopoverFooter,null,_react.default.createElement(_eui.EuiButtonGroup,{legend:"All options selection toggle group",options:selectionToggleButtons,idSelected:selectionToggleSelectedId,onChange:onSelectionToggleChange})))};exports.DataSourceFilterGroup=DataSourceFilterGroup},2603:function(module,exports,__webpack_require__){switch(window.__osdThemeTag__){case"v7dark":return __webpack_require__(2604);case"v7light":return __webpack_require__(2606);case"v8dark":return __webpack_require__(2608);case"v8light":return __webpack_require__(2610)}},2604:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2605);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2605:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceFilterGroupItems{overflow:scroll;max-width:300px}.dataSourceFilterGroupItems .dataSourceFilterGroupOuiFlexGroup .dataSourceFilterGroupOuiFlexItem{text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2606:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2607);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2607:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceFilterGroupItems{overflow:scroll;max-width:300px}.dataSourceFilterGroupItems .dataSourceFilterGroupOuiFlexGroup .dataSourceFilterGroupOuiFlexItem{text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2608:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2609);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2609:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceFilterGroupItems{overflow:scroll;max-width:300px}.dataSourceFilterGroupItems .dataSourceFilterGroupOuiFlexGroup .dataSourceFilterGroupOuiFlexItem{text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2610:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2611);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2611:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceFilterGroupItems{overflow:scroll;max-width:300px}.dataSourceFilterGroupItems .dataSourceFilterGroupOuiFlexGroup .dataSourceFilterGroupOuiFlexItem{text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2612:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"DataSourceSelectable",{enumerable:true,get:function(){return _data_source_selectable.DataSourceSelectable}});var _data_source_selectable=__webpack_require__(2613)},2613:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.DataSourceSelectable=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _react=_interopRequireDefault(__webpack_require__(2));var _i18n=__webpack_require__(3);var _eui=__webpack_require__(6);var _utils=__webpack_require__(2091);var _data_source_selector=__webpack_require__(2137);var _data_source_error_menu=__webpack_require__(2111);var _data_source_item=__webpack_require__(2102);var _no_data_source=__webpack_require__(2139);__webpack_require__(2614);var _drop_down_header=__webpack_require__(2103);__webpack_require__(2623);var _popover_button=__webpack_require__(2140);function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter((function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable}))),t.push.apply(t,o)}return t}function _objectSpread(e){for(var r=1;r<arguments.length;r++){var t=null!=arguments[r]?arguments[r]:{};r%2?ownKeys(Object(t),!0).forEach((function(r){(0,_defineProperty2.default)(e,r,t[r])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach((function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r))}))}return e}class DataSourceSelectable extends _react.default.Component{constructor(props){super(props);(0,_defineProperty2.default)(this,"_isMounted",false);this.state={dataSourceOptions:[],isPopoverOpen:false,selectedOption:[],defaultDataSource:null,showEmptyState:false,showError:false,incompatibleDataSourcesExist:false,componentId:(0,_utils.generateComponentId)()};this.onChange.bind(this)}componentWillUnmount(){this._isMounted=false;(0,_utils.getDataSourceSelection)().remove(this.state.componentId)}onClick(){this.setState(_objectSpread(_objectSpread({},this.state),{},{isPopoverOpen:!this.state.isPopoverOpen}))}closePopover(){this.setState(_objectSpread(_objectSpread({},this.state),{},{isPopoverOpen:false}))}onSelectedDataSources(dataSources){(0,_utils.getDataSourceSelection)().selectDataSource(this.state.componentId,dataSources);this.props.onSelectedDataSources(dataSources)}getUpdatedDataSourceOptions(selectedDataSourceId,dataSourceOptions){return dataSourceOptions.map(option=>_objectSpread(_objectSpread({},option),option.id===selectedDataSourceId&&{checked:"on"}))}handleSelectedOption(dataSourceOptions,defaultDataSource){const[{id:id}]=this.props.selectedOption;const dsOption=dataSourceOptions.find(ds=>ds.id===id);if(!dsOption){this.props.notifications.addWarning(_i18n.i18n.translate("dataSource.fetchDataSourceError",{defaultMessage:"Data source with id: ".concat(id," is not available")}));this.setState(_objectSpread(_objectSpread({},this.state),{},{dataSourceOptions:dataSourceOptions,selectedOption:[],defaultDataSource:defaultDataSource}));this.onSelectedDataSources([]);return}const updatedDataSourceOptions=this.getUpdatedDataSourceOptions(id,dataSourceOptions);this.setState(_objectSpread(_objectSpread({},this.state),{},{dataSourceOptions:updatedDataSourceOptions,selectedOption:[{id:id,label:dsOption.label}],defaultDataSource:defaultDataSource}));this.onSelectedDataSources([{id:id,label:dsOption.label}])}handleDefaultDataSource(dataSourceOptions,defaultDataSource){const selectedDataSource=(0,_utils.getDefaultDataSource)(dataSourceOptions,_data_source_selector.LocalCluster,defaultDataSource,this.props.hideLocalCluster);if(selectedDataSource.length===0){this.props.notifications.addWarning("No connected data source available.");this.onSelectedDataSources([]);return}const updatedDataSourceOptions=this.getUpdatedDataSourceOptions(selectedDataSource[0].id,dataSourceOptions);this.setState(_objectSpread(_objectSpread({},this.state),{},{selectedOption:selectedDataSource,dataSourceOptions:updatedDataSourceOptions,defaultDataSource:defaultDataSource}));this.onSelectedDataSources(selectedDataSource)}async componentDidMount(){this._isMounted=true;try{var _getDefaultDataSource,_this$props$selectedO;const fetchedDataSources=await(0,_utils.getDataSourcesWithFields)(this.props.savedObjectsClient,["id","title","auth.type"]);const dataSourceOptions=(0,_utils.getFilteredDataSources)(fetchedDataSources,this.props.dataSourceFilter);if(dataSourceOptions.length===0&&this.props.hideLocalCluster){this.setState({showEmptyState:true})}if(!this.props.hideLocalCluster){dataSourceOptions.unshift(_data_source_selector.LocalCluster)}if(dataSourceOptions.length===0){(0,_utils.handleNoAvailableDataSourceError)({changeState:this.onEmptyState.bind(this,!!(fetchedDataSources!==null&&fetchedDataSources!==void 0&&fetchedDataSources.length)),notifications:this.props.notifications,application:this.props.application,callback:this.onSelectedDataSources.bind(this),incompatibleDataSourcesExist:!!(fetchedDataSources!==null&&fetchedDataSources!==void 0&&fetchedDataSources.length)});return}const defaultDataSource=(_getDefaultDataSource=(0,_utils.getDefaultDataSourceId)(this.props.uiSettings))!==null&&_getDefaultDataSource!==void 0?_getDefaultDataSource:null;if((_this$props$selectedO=this.props.selectedOption)!==null&&_this$props$selectedO!==void 0&&_this$props$selectedO.length){this.handleSelectedOption(dataSourceOptions,defaultDataSource);return}this.handleDefaultDataSource(dataSourceOptions,defaultDataSource)}catch(error){(0,_utils.handleDataSourceFetchError)(this.onError.bind(this),this.props.notifications,this.onSelectedDataSources.bind(this))}}onEmptyState(incompatibleDataSourcesExist){this.setState({showEmptyState:true,incompatibleDataSourcesExist:incompatibleDataSourcesExist})}onError(){this.setState({showError:true})}onChange(options){if(!this._isMounted)return;const selectedDataSource=options.find(_ref=>{let{checked:checked}=_ref;return checked});this.setState({dataSourceOptions:options});if(selectedDataSource){this.setState({selectedOption:[selectedDataSource],isPopoverOpen:false});this.onSelectedDataSources([{id:selectedDataSource.id,label:selectedDataSource.label}])}}render(){var _this$state$selectedO;if(this.state.showEmptyState){return _react.default.createElement(_no_data_source.NoDataSource,{application:this.props.application,incompatibleDataSourcesExist:this.state.incompatibleDataSourcesExist})}if(this.state.showError){return _react.default.createElement(_data_source_error_menu.DataSourceErrorMenu,{application:this.props.application})}const label=this.state.selectedOption&&this.state.selectedOption.length>0&&((_this$state$selectedO=this.state.selectedOption[0])===null||_this$state$selectedO===void 0?void 0:_this$state$selectedO.label)||"";return _react.default.createElement(_eui.EuiPopover,{initialFocus:".euiSelectableSearch",id:"dataSourceSelectableContextMenuPopover",button:_react.default.createElement(_popover_button.DataSourceMenuPopoverButton,{className:"dataSourceSelectable",label:label,onClick:this.onClick.bind(this)}),isOpen:this.state.isPopoverOpen,closePopover:this.closePopover.bind(this),panelPaddingSize:"none",anchorPosition:"downLeft","data-test-subj":"dataSourceSelectableContextMenuPopover"},_react.default.createElement(_drop_down_header.DataSourceDropDownHeader,{totalDataSourceCount:this.state.dataSourceOptions.length,application:this.props.application}),_react.default.createElement(_eui.EuiContextMenuPanel,null,_react.default.createElement(_eui.EuiPanel,{className:"dataSourceSelectableOuiPanel",color:"transparent",paddingSize:"none"},_react.default.createElement(_eui.EuiSelectable,{"aria-label":"Search",searchable:true,searchProps:{placeholder:"Search",compressed:true},listProps:{onFocusBadge:false},options:this.state.dataSourceOptions,onChange:newOptions=>this.onChange(newOptions),singleSelection:"always","data-test-subj":"dataSourceSelectable",renderOption:option=>_react.default.createElement(_data_source_item.DataSourceItem,{option:option,defaultDataSource:this.state.defaultDataSource,className:"dataSourceSelectable"})},(list,search)=>_react.default.createElement(_react.default.Fragment,null,_react.default.createElement(_eui.EuiPopoverTitle,{paddingSize:"s"},search),list)))))}}exports.DataSourceSelectable=DataSourceSelectable},2614:function(module,exports,__webpack_require__){switch(window.__osdThemeTag__){case"v7dark":return __webpack_require__(2615);case"v7light":return __webpack_require__(2617);case"v8dark":return __webpack_require__(2619);case"v8light":return __webpack_require__(2621)}},2615:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2616);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2616:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceSelectableOuiPanel{width:300px}.dataSourceSelectableOuiPanel .euiSelectableListItem__text{max-height:100%}.dataSourceSelectableOuiPanel .dataSourceSelectableOuiFlexGroup .euiFlexItem{max-width:fit-content}.dataSourceSelectableOuiPanel .dataSourceSelectableOuiFlexGroup .dataSourceSelectableOuiFlexItem{text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block;max-width:fit-content}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2617:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2618);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2618:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceSelectableOuiPanel{width:300px}.dataSourceSelectableOuiPanel .euiSelectableListItem__text{max-height:100%}.dataSourceSelectableOuiPanel .dataSourceSelectableOuiFlexGroup .euiFlexItem{max-width:fit-content}.dataSourceSelectableOuiPanel .dataSourceSelectableOuiFlexGroup .dataSourceSelectableOuiFlexItem{text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block;max-width:fit-content}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2619:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2620);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2620:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceSelectableOuiPanel{width:300px}.dataSourceSelectableOuiPanel .euiSelectableListItem__text{max-height:100%}.dataSourceSelectableOuiPanel .dataSourceSelectableOuiFlexGroup .euiFlexItem{max-width:fit-content}.dataSourceSelectableOuiPanel .dataSourceSelectableOuiFlexGroup .dataSourceSelectableOuiFlexItem{text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block;max-width:fit-content}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2621:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2622);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2622:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceSelectableOuiPanel{width:300px}.dataSourceSelectableOuiPanel .euiSelectableListItem__text{max-height:100%}.dataSourceSelectableOuiPanel .dataSourceSelectableOuiFlexGroup .euiFlexItem{max-width:fit-content}.dataSourceSelectableOuiPanel .dataSourceSelectableOuiFlexGroup .dataSourceSelectableOuiFlexItem{text-overflow:ellipsis;overflow:hidden;white-space:nowrap;display:inline-block;max-width:fit-content}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2623:function(module,exports,__webpack_require__){switch(window.__osdThemeTag__){case"v7dark":return __webpack_require__(2624);case"v7light":return __webpack_require__(2626);case"v8dark":return __webpack_require__(2628);case"v8light":return __webpack_require__(2630)}},2624:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2625);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2625:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceComponentButtonTitle{white-space:nowrap;overflow:hidden;text-overflow:ellipsis;width:auto;max-width:16ch}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2626:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2627);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2627:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceComponentButtonTitle{white-space:nowrap;overflow:hidden;text-overflow:ellipsis;width:auto;max-width:16ch}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2628:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2629);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2629:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceComponentButtonTitle{white-space:nowrap;overflow:hidden;text-overflow:ellipsis;width:auto;max-width:16ch}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2630:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2631);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2631:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.dataSourceComponentButtonTitle{white-space:nowrap;overflow:hidden;text-overflow:ellipsis;width:auto;max-width:16ch}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2632:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"DataSourceOption",{enumerable:true,get:function(){return _data_source_selector.DataSourceOption}});Object.defineProperty(exports,"DataSourceSelector",{enumerable:true,get:function(){return _data_source_selector.DataSourceSelector}});var _data_source_selector=__webpack_require__(2137)},2633:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"DataSourceAggregatedViewConfig",{enumerable:true,get:function(){return _types.DataSourceAggregatedViewConfig}});Object.defineProperty(exports,"DataSourceComponentType",{enumerable:true,get:function(){return _types.DataSourceComponentType}});Object.defineProperty(exports,"DataSourceMenu",{enumerable:true,get:function(){return _data_source_menu.DataSourceMenu}});Object.defineProperty(exports,"DataSourceMenuProps",{enumerable:true,get:function(){return _types.DataSourceMenuProps}});Object.defineProperty(exports,"DataSourceMultiSelectableConfig",{enumerable:true,get:function(){return _types.DataSourceMultiSelectableConfig}});Object.defineProperty(exports,"DataSourceSelectableConfig",{enumerable:true,get:function(){return _types.DataSourceSelectableConfig}});Object.defineProperty(exports,"DataSourceViewConfig",{enumerable:true,get:function(){return _types.DataSourceViewConfig}});Object.defineProperty(exports,"createDataSourceMenu",{enumerable:true,get:function(){return _create_data_source_menu.createDataSourceMenu}});var _data_source_menu=__webpack_require__(2194);var _create_data_source_menu=__webpack_require__(2193);var _types=__webpack_require__(2198)},2634:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.Tutorial=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _lodash=_interopRequireDefault(__webpack_require__(5));var _react=_interopRequireDefault(__webpack_require__(2));var _footer=__webpack_require__(2635);var _introduction=__webpack_require__(2636);var _instruction_set=__webpack_require__(2637);var _saved_objects_installer=__webpack_require__(2642);var _eui=__webpack_require__(6);var StatusCheckStates=_interopRequireWildcard(__webpack_require__(2199));var _react2=__webpack_require__(13);var _i18n=__webpack_require__(3);var _opensearch_dashboards_services=__webpack_require__(166);function _getRequireWildcardCache(e){if("function"!=typeof WeakMap)return null;var r=new WeakMap,t=new WeakMap;return(_getRequireWildcardCache=function(e){return e?t:r})(e)}function _interopRequireWildcard(e,r){if(!r&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var t=_getRequireWildcardCache(r);if(t&&t.has(e))return t.get(e);var n={__proto__:null},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var u in e)if("default"!==u&&Object.prototype.hasOwnProperty.call(e,u)){var i=a?Object.getOwnPropertyDescriptor(e,u):null;i&&(i.get||i.set)?Object.defineProperty(n,u,i):n[u]=e[u]}return n.default=e,t&&t.set(e,n),n}function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter((function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable}))),t.push.apply(t,o)}return t}function _objectSpread(e){for(var r=1;r<arguments.length;r++){var t=null!=arguments[r]?arguments[r]:{};r%2?ownKeys(Object(t),!0).forEach((function(r){(0,_defineProperty2.default)(e,r,t[r])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach((function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r))}))}return e}const INSTRUCTIONS_TYPE={ELASTIC_CLOUD:"OpenSearchCloud",ON_PREM:"onPrem",ON_PREM_ELASTIC_CLOUD:"onPremElasticCloud"};const homeTitle=_i18n.i18n.translate("home.breadcrumbs.homeTitle",{defaultMessage:"Home"});const addDataTitle=_i18n.i18n.translate("home.breadcrumbs.addDataTitle",{defaultMessage:"Add data"});class TutorialUi extends _react.default.Component{constructor(props){super(props);(0,_defineProperty2.default)(this,"getInstructions",()=>{if(!this.state.tutorial){return{instructionSets:[]}}switch(this.state.visibleInstructions){case INSTRUCTIONS_TYPE.ELASTIC_CLOUD:return this.state.tutorial.OpenSearchCloud;case INSTRUCTIONS_TYPE.ON_PREM:return this.state.tutorial.onPrem;case INSTRUCTIONS_TYPE.ON_PREM_ELASTIC_CLOUD:return this.state.tutorial.onPremElasticCloud;default:throw new Error(this.props.intl.formatMessage({id:"home.tutorial.unhandledInstructionTypeErrorDescription",defaultMessage:"Unhandled instruction type {visibleInstructions}"},{visibleInstructions:this.state.visibleInstructions}))}});(0,_defineProperty2.default)(this,"getInstructionSets",()=>this.getInstructions().instructionSets);(0,_defineProperty2.default)(this,"initInstructionsState",()=>{const instructions=this.getInstructions();const paramValues={};if(instructions.params){instructions.params.forEach(param=>{paramValues[param.id]=param.defaultValue})}const statusCheckStates=new Array(instructions.instructionSets.length).fill(StatusCheckStates.NOT_CHECKED);this.setState({paramValues:paramValues,statusCheckStates:statusCheckStates})});(0,_defineProperty2.default)(this,"setVisibleInstructions",instructionsType=>{this.setState({visibleInstructions:instructionsType},this.initInstructionsState)});(0,_defineProperty2.default)(this,"setParameter",(paramId,newValue)=>{this.setState(previousState=>{const paramValues=_lodash.default.cloneDeep(previousState.paramValues);paramValues[paramId]=newValue;return{paramValues:paramValues}})});(0,_defineProperty2.default)(this,"checkInstructionSetStatus",async instructionSetIndex=>{const instructionSet=this.getInstructionSets()[instructionSetIndex];const opensearchHitsCheckConfig=_lodash.default.get(instructionSet,"statusCheck.opensearchHitsCheck");if(opensearchHitsCheckConfig){const statusCheckState=await this.fetchOpenSearchHitsStatus(opensearchHitsCheckConfig);this.setState(prevState=>({statusCheckStates:_objectSpread(_objectSpread({},prevState.statusCheckStates),{},{[instructionSetIndex]:statusCheckState})}))}});(0,_defineProperty2.default)(this,"fetchOpenSearchHitsStatus",async opensearchHitsCheckConfig=>{const{http:http}=(0,_opensearch_dashboards_services.getServices)();try{const response=await http.post("/api/home/hits_status",{body:JSON.stringify({index:opensearchHitsCheckConfig.index,query:opensearchHitsCheckConfig.query})});return response.count>0?StatusCheckStates.HAS_DATA:StatusCheckStates.NO_DATA}catch(e){return StatusCheckStates.ERROR}});(0,_defineProperty2.default)(this,"renderInstructionSetsToggle",()=>{if(!this.props.isCloudEnabled&&this.state.tutorial.onPremElasticCloud){const selfManagedLabel=this.props.intl.formatMessage({id:"home.tutorial.selfManagedButtonLabel",defaultMessage:"Self managed"});const cloudLabel=this.props.intl.formatMessage({id:"home.tutorial.OpenSearchCloudButtonLabel",defaultMessage:"Elastic Cloud"});const radioButtons=[{id:INSTRUCTIONS_TYPE.ON_PREM,label:selfManagedLabel,"data-test-subj":"selfManagedTutorial"},{id:INSTRUCTIONS_TYPE.ON_PREM_ELASTIC_CLOUD,label:cloudLabel,"data-test-subj":"onCloudTutorial"}];return _react.default.createElement(_eui.EuiFlexGroup,{justifyContent:"center"},_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiButtonGroup,{options:radioButtons,legend:_i18n.i18n.translate("home.tutorial.instructionsTypeLegend",{defaultMessage:"Instructions Type"}),idSelected:this.state.visibleInstructions,onChange:this.setVisibleInstructions,color:"primary"})))}});(0,_defineProperty2.default)(this,"onStatusCheck",instructionSetIndex=>{this.setState(prevState=>({statusCheckStates:_objectSpread(_objectSpread({},prevState.statusCheckStates),{},{[instructionSetIndex]:StatusCheckStates.FETCHING})}),this.checkInstructionSetStatus.bind(null,instructionSetIndex))});(0,_defineProperty2.default)(this,"renderInstructionSets",instructions=>{let offset=1;return instructions.instructionSets.map((instructionSet,index)=>{const currentOffset=offset;offset+=instructionSet.instructionVariants[0].instructions.length;return _react.default.createElement(_instruction_set.InstructionSet,{title:instructionSet.title,instructionVariants:instructionSet.instructionVariants,statusCheckConfig:instructionSet.statusCheck,statusCheckState:this.state.statusCheckStates[index],onStatusCheck:()=>{this.onStatusCheck(index)},offset:currentOffset,params:instructions.params,paramValues:this.state.paramValues,setParameter:this.setParameter,replaceTemplateStrings:this.props.replaceTemplateStrings,key:index})})});(0,_defineProperty2.default)(this,"renderSavedObjectsInstaller",()=>{if(!this.state.tutorial.savedObjects){return}return _react.default.createElement(_saved_objects_installer.SavedObjectsInstaller,{bulkCreate:this.props.bulkCreate,savedObjects:this.state.tutorial.savedObjects,installMsg:this.state.tutorial.savedObjectsInstallMsg})});(0,_defineProperty2.default)(this,"renderFooter",()=>{let label;let url;if(_lodash.default.has(this.state,"tutorial.artifacts.application")){label=this.state.tutorial.artifacts.application.label;url=this.props.addBasePath(this.state.tutorial.artifacts.application.path)}else if(_lodash.default.has(this.state,"tutorial.artifacts.dashboards")){const overviewDashboard=this.state.tutorial.artifacts.dashboards.find(dashboard=>dashboard.isOverview);if(overviewDashboard){label=overviewDashboard.linkLabel;url=this.props.addBasePath("/app/dashboards#/view/".concat(overviewDashboard.id))}}if(url&&label){return _react.default.createElement(_footer.Footer,{label:label,url:url})}});this.state={notFound:false,paramValues:{},statusCheckStates:[],tutorial:null};if(props.isCloudEnabled){this.state.visibleInstructions=INSTRUCTIONS_TYPE.ELASTIC_CLOUD}else{this.state.visibleInstructions=INSTRUCTIONS_TYPE.ON_PREM}}UNSAFE_componentWillMount(){this._isMounted=true}componentWillUnmount(){this._isMounted=false}async componentDidMount(){const tutorial=await this.props.getTutorial(this.props.tutorialId);if(!this._isMounted){return}if(tutorial){this.setState({tutorial:tutorial},this.initInstructionsState)}else{this.setState({notFound:true})}(0,_opensearch_dashboards_services.getServices)().chrome.setBreadcrumbs([{text:homeTitle,href:"#/"},{text:addDataTitle,href:"#/tutorial_directory"},{text:tutorial?tutorial.name:this.props.tutorialId}])}renderModuleNotices(){const notices=(0,_opensearch_dashboards_services.getServices)().tutorialService.getModuleNotices();if(notices.length&&this.state.tutorial.moduleName){return _react.default.createElement(_eui.EuiFlexGroup,{direction:"column",gutterSize:"none"},notices.map((ModuleNotice,index)=>_react.default.createElement(_eui.EuiFlexItem,{key:index},_react.default.createElement(ModuleNotice,{moduleName:this.state.tutorial.moduleName}))))}else{return null}}render(){let content;if(this.state.notFound){content=_react.default.createElement("div",{className:"homTutorial__notFoundPanel"},_react.default.createElement(_eui.EuiText,null,_react.default.createElement("p",null,_react.default.createElement(_react2.FormattedMessage,{id:"home.tutorial.noTutorialLabel",defaultMessage:"Unable to find tutorial {tutorialId}",values:{tutorialId:this.props.tutorialId}}))))}if(this.state.tutorial){let previewUrl;if(this.state.tutorial.previewImagePath){previewUrl=this.props.addBasePath(this.state.tutorial.previewImagePath)}let exportedFieldsUrl;if(_lodash.default.has(this.state,"tutorial.artifacts.exportedFields")){exportedFieldsUrl=this.props.replaceTemplateStrings(this.state.tutorial.artifacts.exportedFields.documentationUrl)}let icon=this.state.tutorial.euiIconType;if(icon&&icon.includes("/")){icon=this.props.addBasePath(icon)}const instructions=this.getInstructions();content=_react.default.createElement("div",null,_react.default.createElement(_introduction.Introduction,{title:this.state.tutorial.name,description:this.props.replaceTemplateStrings(this.state.tutorial.longDescription),previewUrl:previewUrl,exportedFieldsUrl:exportedFieldsUrl,iconType:icon,isBeta:this.state.tutorial.isBeta}),this.renderModuleNotices(),_react.default.createElement(_eui.EuiSpacer,null),_react.default.createElement("div",{className:"eui-textCenter"},this.renderInstructionSetsToggle()),_react.default.createElement(_eui.EuiSpacer,null),_react.default.createElement(_eui.EuiPanel,{paddingSize:"l"},this.renderInstructionSets(instructions),this.renderSavedObjectsInstaller(),this.renderFooter()))}return _react.default.createElement(_eui.EuiPage,{restrictWidth:1200},_react.default.createElement(_eui.EuiPageBody,{component:"main"},content))}}const Tutorial=exports.Tutorial=(0,_react2.injectI18n)(TutorialUi)},2635:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.Footer=Footer;var _react=_interopRequireDefault(__webpack_require__(2));var _eui=__webpack_require__(6);var _react2=__webpack_require__(13);function Footer(_ref){let{url:url,label:label}=_ref;return _react.default.createElement("div",null,_react.default.createElement(_eui.EuiHorizontalRule,null),_react.default.createElement(_eui.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiText,null,_react.default.createElement("p",null,_react.default.createElement(_react2.FormattedMessage,{id:"home.exploreYourDataDescription",defaultMessage:"When all steps are complete, you're ready to explore your data."})))),_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiButton,{fill:true,href:url},label))))}},2636:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.Introduction=void 0;var _react=_interopRequireDefault(__webpack_require__(2));var _content=__webpack_require__(2141);var _eui=__webpack_require__(6);var _react2=__webpack_require__(13);function IntroductionUI(_ref){let{description:description,previewUrl:previewUrl,title:title,exportedFieldsUrl:exportedFieldsUrl,iconType:iconType,isBeta:isBeta,intl:intl}=_ref;let img;if(previewUrl){img=_react.default.createElement(_eui.EuiImage,{size:"l",hasShadow:true,allowFullScreen:true,fullScreenIconColor:"dark",alt:intl.formatMessage({id:"home.tutorial.introduction.imageAltDescription",defaultMessage:"screenshot of primary dashboard."}),url:previewUrl})}let exportedFields;if(exportedFieldsUrl){exportedFields=_react.default.createElement("div",null,_react.default.createElement(_eui.EuiSpacer,null),_react.default.createElement(_eui.EuiButton,{href:exportedFieldsUrl,target:"_blank",rel:"noopener noreferrer"},_react.default.createElement(_react2.FormattedMessage,{id:"home.tutorial.introduction.viewButtonLabel",defaultMessage:"View exported fields"})))}let icon;if(iconType){icon=_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiIcon,{size:"xl",title:"",type:iconType}))}let betaBadge;if(isBeta){betaBadge=_react.default.createElement(_eui.EuiBetaBadge,{label:intl.formatMessage({id:"home.tutorial.introduction.betaLabel",defaultMessage:"Beta"})})}return _react.default.createElement(_eui.EuiFlexGroup,null,_react.default.createElement(_eui.EuiFlexItem,null,_react.default.createElement(_eui.EuiFlexGroup,{gutterSize:"l",alignItems:"center"},icon,_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiTitle,{size:"l"},_react.default.createElement("h1",null,title,betaBadge&&_react.default.createElement(_react.default.Fragment,null," ",betaBadge))))),_react.default.createElement(_content.Content,{text:description}),exportedFields),_react.default.createElement(_eui.EuiFlexItem,{grow:false},img))}IntroductionUI.defaultProps={isBeta:false};const Introduction=exports.Introduction=(0,_react2.injectI18n)(IntroductionUI)},2637:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.InstructionSet=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _react=_interopRequireWildcard(__webpack_require__(2));var _instruction=__webpack_require__(2638);var _parameter_form=__webpack_require__(2639);var _content=__webpack_require__(2141);var _instruction_variant=__webpack_require__(645);var _eui=__webpack_require__(6);var StatusCheckStates=_interopRequireWildcard(__webpack_require__(2199));var _react2=__webpack_require__(13);function _getRequireWildcardCache(e){if("function"!=typeof WeakMap)return null;var r=new WeakMap,t=new WeakMap;return(_getRequireWildcardCache=function(e){return e?t:r})(e)}function _interopRequireWildcard(e,r){if(!r&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var t=_getRequireWildcardCache(r);if(t&&t.has(e))return t.get(e);var n={__proto__:null},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var u in e)if("default"!==u&&Object.prototype.hasOwnProperty.call(e,u)){var i=a?Object.getOwnPropertyDescriptor(e,u):null;i&&(i.get||i.set)?Object.defineProperty(n,u,i):n[u]=e[u]}return n.default=e,t&&t.set(e,n),n}class InstructionSetUi extends _react.default.Component{constructor(props){super(props);(0,_defineProperty2.default)(this,"handleToggleVisibility",()=>{this.setState(prevState=>({isParamFormVisible:!prevState.isParamFormVisible}))});(0,_defineProperty2.default)(this,"onSelectedTabChanged",id=>{this.setState({selectedTabId:id})});(0,_defineProperty2.default)(this,"renderTabs",()=>this.tabs.map((tab,index)=>_react.default.createElement(_eui.EuiTab,{onClick:()=>this.onSelectedTabChanged(tab.id),isSelected:tab.id===this.state.selectedTabId,key:index},tab.name)));(0,_defineProperty2.default)(this,"renderInstructions",()=>{const instructionVariant=this.props.instructionVariants.find(variant=>variant.id===this.state.selectedTabId);if(!instructionVariant){return}const steps=instructionVariant.instructions.map((instruction,index)=>{const step=_react.default.createElement(_instruction.Instruction,{commands:instruction.commands,paramValues:this.props.paramValues,textPre:instruction.textPre,textPost:instruction.textPost,replaceTemplateStrings:this.props.replaceTemplateStrings});return{title:instruction.title,children:step,key:index}});if(this.props.statusCheckConfig){steps.push(this.renderStatusCheck())}return _react.default.createElement(_eui.EuiSteps,{steps:steps,firstStepNumber:this.props.offset})});(0,_defineProperty2.default)(this,"renderHeader",()=>{let paramsVisibilityToggle;if(this.props.params){const ariaLabel=this.props.intl.formatMessage({id:"home.tutorial.instructionSet.toggleAriaLabel",defaultMessage:"toggle command parameters visibility"});paramsVisibilityToggle=_react.default.createElement(_eui.EuiButtonEmpty,{iconType:this.state.isParamFormVisible?"arrowDown":"arrowRight","aria-label":ariaLabel,onClick:this.handleToggleVisibility},_react.default.createElement(_react2.FormattedMessage,{id:"home.tutorial.instructionSet.customizeLabel",defaultMessage:"Customize your code snippets"}))}return _react.default.createElement(_eui.EuiFlexGroup,{responsive:false,wrap:true,justifyContent:"spaceBetween"},_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiTitle,{size:"m"},_react.default.createElement("h2",null,this.props.title))),_react.default.createElement(_eui.EuiFlexItem,{grow:false},paramsVisibilityToggle))});this.tabs=props.instructionVariants.map(variant=>({id:variant.id,name:(0,_instruction_variant.getDisplayText)(variant.id)}));this.state={isParamFormVisible:false};if(this.tabs.length>0){this.state.selectedTabId=this.tabs[0].id}}renderStatusCheckMessage(){let message;let color;switch(this.props.statusCheckState){case StatusCheckStates.NOT_CHECKED:case StatusCheckStates.FETCHING:return null;case StatusCheckStates.HAS_DATA:message=this.props.statusCheckConfig.success?this.props.statusCheckConfig.success:this.props.intl.formatMessage({id:"home.tutorial.instructionSet.successLabel",defaultMessage:"Success"});color="success";break;case StatusCheckStates.ERROR:case StatusCheckStates.NO_DATA:message=this.props.statusCheckConfig.error?this.props.statusCheckConfig.error:this.props.intl.formatMessage({id:"home.tutorial.instructionSet.noDataLabel",defaultMessage:"No data found"});color="warning";break}return _react.default.createElement(_eui.EuiCallOut,{title:message,color:color})}getStepStatus(statusCheckState){switch(statusCheckState){case undefined:case StatusCheckStates.NOT_CHECKED:case StatusCheckStates.FETCHING:return"incomplete";case StatusCheckStates.HAS_DATA:return"complete";case StatusCheckStates.NO_DATA:return"warning";case StatusCheckStates.ERROR:return"danger";default:throw new Error(this.props.intl.formatMessage({id:"home.tutorial.unexpectedStatusCheckStateErrorDescription",defaultMessage:"Unexpected status check state {statusCheckState}"},{statusCheckState:statusCheckState}))}}renderStatusCheck(){const{statusCheckState:statusCheckState,statusCheckConfig:statusCheckConfig,onStatusCheck:onStatusCheck}=this.props;const checkStatusStep=_react.default.createElement(_react.Fragment,null,_react.default.createElement(_eui.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},_react.default.createElement(_eui.EuiFlexItem,null,_react.default.createElement(_content.Content,{text:statusCheckConfig.text})),_react.default.createElement(_eui.EuiFlexItem,{grow:false},_react.default.createElement(_eui.EuiButton,{onClick:onStatusCheck,isLoading:statusCheckState===StatusCheckStates.FETCHING},statusCheckConfig.btnLabel||_react.default.createElement(_react2.FormattedMessage,{id:"home.tutorial.instructionSet.checkStatusButtonLabel",defaultMessage:"Check status"})))),_react.default.createElement(_eui.EuiSpacer,{size:"s"}),this.renderStatusCheckMessage());return{title:statusCheckConfig.title||this.props.intl.formatMessage({id:"home.tutorial.instructionSet.statusCheckTitle",defaultMessage:"Status Check"}),status:this.getStepStatus(statusCheckState),children:checkStatusStep,key:"checkStatusStep"}}render(){let paramsForm;if(this.props.params&&this.state.isParamFormVisible){paramsForm=_react.default.createElement(_parameter_form.ParameterForm,{params:this.props.params,paramValues:this.props.paramValues,setParameter:this.props.setParameter})}return _react.default.createElement("div",null,this.renderHeader(),paramsForm,_react.default.createElement(_eui.EuiTabs,null,this.renderTabs()),_react.default.createElement(_eui.EuiSpacer,{size:"m"}),this.renderInstructions())}}const InstructionSet=exports.InstructionSet=(0,_react2.injectI18n)(InstructionSetUi)},2638:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.Instruction=Instruction;var _react=_interopRequireDefault(__webpack_require__(2));var _content=__webpack_require__(2141);var _eui=__webpack_require__(6);var _react2=__webpack_require__(13);function Instruction(_ref){let{commands:commands,paramValues:paramValues,textPost:textPost,textPre:textPre,replaceTemplateStrings:replaceTemplateStrings}=_ref;let pre;if(textPre){pre=_react.default.createElement(_content.Content,{text:replaceTemplateStrings(textPre)})}let post;if(textPost){post=_react.default.createElement("div",null,_react.default.createElement(_eui.EuiSpacer,{size:"m"}),_react.default.createElement(_content.Content,{text:replaceTemplateStrings(textPost)}))}let copyButton;let commandBlock;if(commands){const cmdText=commands.map(cmd=>replaceTemplateStrings(cmd,paramValues)).join("\n");copyButton=_react.default.createElement(_eui.EuiCopy,{textToCopy:cmdText},copy=>_react.default.createElement(_eui.EuiButton,{size:"s",onClick:copy},_react.default.createElement(_react2.FormattedMessage,{id:"home.tutorial.instruction.copyButtonLabel",defaultMessage:"Copy snippet"})));commandBlock=_react.default.createElement("div",null,_react.default.createElement(_eui.EuiSpacer,{size:"m"}),_react.default.createElement(_eui.EuiCodeBlock,{language:"bash"},cmdText))}return _react.default.createElement("div",null,_react.default.createElement(_eui.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"flexEnd"},_react.default.createElement(_eui.EuiFlexItem,{grow:false},pre),_react.default.createElement(_eui.EuiFlexItem,{className:"homTutorial__instruction",grow:false},copyButton)),commandBlock,post,_react.default.createElement(_eui.EuiSpacer,null))}},2639:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.ParameterForm=void 0;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _react=_interopRequireDefault(__webpack_require__(2));var _number_parameter=__webpack_require__(2640);var _string_parameter=__webpack_require__(2641);var _eui=__webpack_require__(6);class ParameterForm extends _react.default.Component{constructor(){super(...arguments);(0,_defineProperty2.default)(this,"renderInputs",()=>this.props.params.map(param=>{switch(param.type){case"number":return _react.default.createElement(_number_parameter.NumberParameter,{key:param.id,id:param.id,label:param.label,value:this.props.paramValues[param.id],setParameter:this.props.setParameter});case"string":return _react.default.createElement(_string_parameter.StringParameter,{key:param.id,id:param.id,label:param.label,value:this.props.paramValues[param.id],setParameter:this.props.setParameter});default:throw new Error("Unhandled parameter type ".concat(param.type))}}))}render(){return _react.default.createElement(_eui.EuiPanel,null,this.renderInputs())}}exports.ParameterForm=ParameterForm},2640:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.NumberParameter=NumberParameter;var _react=_interopRequireDefault(__webpack_require__(2));function NumberParameter(_ref){let{id:id,label:label,value:value,setParameter:setParameter}=_ref;const handleChange=evt=>{setParameter(id,parseFloat(evt.target.value))};return _react.default.createElement("div",{className:"visEditorSidebar__formRow"},_react.default.createElement("label",{className:"visEditorSidebar__formLabel",htmlFor:id},label),_react.default.createElement("div",{className:"visEditorSidebar__formControl kuiFieldGroupSection--wide"},_react.default.createElement("input",{className:"kuiTextInput",type:"number",value:value,onChange:handleChange,id:id})))}},2641:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.StringParameter=StringParameter;var _react=_interopRequireDefault(__webpack_require__(2));function StringParameter(_ref){let{id:id,label:label,value:value,setParameter:setParameter}=_ref;const handleChange=evt=>{setParameter(id,evt.target.value)};return _react.default.createElement("div",{className:"visEditorSidebar__formRow"},_react.default.createElement("label",{className:"visEditorSidebar__formLabel"},label),_react.default.createElement("div",{className:"visEditorSidebar__formControl kuiFieldGroupSection--wide"},_react.default.createElement("input",{className:"kuiTextInput",type:"text",value:value,onChange:handleChange})))}},2642:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.SavedObjectsInstaller=void 0;var _objectWithoutProperties2=_interopRequireDefault(__webpack_require__(9));var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _react=__webpack_require__(13);var _react2=_interopRequireWildcard(__webpack_require__(2));var _eui=__webpack_require__(6);const _excluded=["version"];function _getRequireWildcardCache(e){if("function"!=typeof WeakMap)return null;var r=new WeakMap,t=new WeakMap;return(_getRequireWildcardCache=function(e){return e?t:r})(e)}function _interopRequireWildcard(e,r){if(!r&&e&&e.__esModule)return e;if(null===e||"object"!=typeof e&&"function"!=typeof e)return{default:e};var t=_getRequireWildcardCache(r);if(t&&t.has(e))return t.get(e);var n={__proto__:null},a=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var u in e)if("default"!==u&&Object.prototype.hasOwnProperty.call(e,u)){var i=a?Object.getOwnPropertyDescriptor(e,u):null;i&&(i.get||i.set)?Object.defineProperty(n,u,i):n[u]=e[u]}return n.default=e,t&&t.set(e,n),n}class SavedObjectsInstallerUi extends _react2.default.Component{constructor(){super(...arguments);(0,_defineProperty2.default)(this,"DEFAULT_BUTTON_LABEL",this.props.intl.formatMessage({id:"home.tutorial.savedObject.defaultButtonLabel",defaultMessage:"Load OpenSearch Dashboards objects"}));(0,_defineProperty2.default)(this,"state",{isInstalling:false,isInstalled:false,overwrite:false,buttonLabel:this.DEFAULT_BUTTON_LABEL});(0,_defineProperty2.default)(this,"installSavedObjects",async()=>{this.setState({isInstalling:true});let resp;try{const objectsToCreate=this.props.savedObjects.map(_ref=>{let{version:version}=_ref,savedObject=(0,_objectWithoutProperties2.default)(_ref,_excluded);return savedObject});resp=await this.props.bulkCreate(objectsToCreate,{overwrite:this.state.overwrite})}catch(error){if(!this._isMounted){return}this.setState({isInstalling:false,installStatusMsg:this.props.intl.formatMessage({id:"home.tutorial.savedObject.requestFailedErrorMessage",defaultMessage:"Request failed, Error: {message}"},{message:error.message}),isInstalled:false,overwrite:false,buttonLabel:this.DEFAULT_BUTTON_LABEL});return}if(!this._isMounted){return}const errors=resp.savedObjects.filter(savedObject=>Boolean(savedObject.error));const overwriteErrors=errors.filter(savedObject=>savedObject.error.statusCode===409);if(overwriteErrors.length>0){this.setState({isInstalling:false,installStatusMsg:this.props.intl.formatMessage({id:"home.tutorial.savedObject.installStatusLabel",defaultMessage:"{overwriteErrorsLength} of {savedObjectsLength} objects already exist. Click 'Confirm overwrite' to import and overwrite existing objects. Any changes to the objects will be lost."},{overwriteErrorsLength:overwriteErrors.length,savedObjectsLength:this.props.savedObjects.length}),isInstalled:false,overwrite:true,buttonLabel:this.props.intl.formatMessage({id:"home.tutorial.savedObject.confirmButtonLabel",defaultMessage:"Confirm overwrite"})});return}const hasErrors=errors.length>0;const statusMsg=hasErrors?this.props.intl.formatMessage({id:"home.tutorial.savedObject.unableToAddErrorMessage",defaultMessage:"Unable to add {errorsLength} of {savedObjectsLength} OpenSearch Dashboards objects, Error: {errorMessage}"},{errorsLength:errors.length,savedObjectsLength:this.props.savedObjects.length,errorMessage:errors[0].error.message}):this.props.intl.formatMessage({id:"home.tutorial.savedObject.addedLabel",defaultMessage:"{savedObjectsLength} saved objects successfully added"},{savedObjectsLength:this.props.savedObjects.length});this.setState({isInstalling:false,installStatusMsg:statusMsg,isInstalled:!hasErrors,overwrite:false,buttonLabel:this.DEFAULT_BUTTON_LABEL})});(0,_defineProperty2.default)(this,"renderInstallStep",()=>{const installMsg=this.props.installMsg?this.props.installMsg:this.props.intl.formatMessage({id:"home.tutorial.savedObject.installLabel",defaultMessage:"Imports index pattern, visualizations and pre-defined dashboards."});const installStep=_react2.default.createElement(_react2.Fragment,null,_react2.default.createElement(_eui.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},_react2.default.createElement(_eui.EuiFlexItem,null,_react2.default.createElement(_eui.EuiText,null,_react2.default.createElement("p",null,installMsg))),_react2.default.createElement(_eui.EuiFlexItem,{grow:false},_react2.default.createElement(_eui.EuiButton,{onClick:this.installSavedObjects,isLoading:this.state.isInstalling,"data-test-subj":"loadSavedObjects"},this.state.buttonLabel))),_react2.default.createElement(_eui.EuiSpacer,{size:"s"}),this.renderInstallMessage());return{title:this.props.intl.formatMessage({id:"home.tutorial.savedObject.loadTitle",defaultMessage:"Load OpenSearch Dashboards objects"}),status:this.state.isInstalled?"complete":"incomplete",children:installStep,key:"installStep"}})}componentDidMount(){this._isMounted=true}componentWillUnmount(){this._isMounted=false}renderInstallMessage(){if(!this.state.installStatusMsg){return}return _react2.default.createElement(_eui.EuiCallOut,{title:this.state.installStatusMsg,color:this.state.isInstalled?"success":"warning","data-test-subj":this.state.isInstalled?"loadSavedObjects_success":"loadSavedObjects_failed"})}render(){return _react2.default.createElement(_eui.EuiSteps,{steps:[this.renderInstallStep()]})}}const SavedObjectsInstaller=exports.SavedObjectsInstaller=(0,_react.injectI18n)(SavedObjectsInstallerUi)},2643:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(0);Object.defineProperty(exports,"__esModule",{value:true});exports.replaceTemplateStrings=replaceTemplateStrings;var _defineProperty2=_interopRequireDefault(__webpack_require__(1));var _mustache=__webpack_require__(2644);var _opensearch_dashboards_services=__webpack_require__(166);function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter((function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable}))),t.push.apply(t,o)}return t}function _objectSpread(e){for(var r=1;r<arguments.length;r++){var t=null!=arguments[r]?arguments[r]:{};r%2?ownKeys(Object(t),!0).forEach((function(r){(0,_defineProperty2.default)(e,r,t[r])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach((function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r))}))}return e}const TEMPLATE_TAGS=["{","}"];const mustacheWriter=new _mustache.Writer;mustacheWriter.escapedValue=function escapedValue(token,context){const value=context.lookup(token[1]);if(value!=null){return value}};function replaceTemplateStrings(text){let params=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};const{tutorialService:tutorialService,opensearchDashboardsVersion:opensearchDashboardsVersion,docLinks:docLinks}=(0,_opensearch_dashboards_services.getServices)();const variables={curlyOpen:"{",curlyClose:"}",config:_objectSpread(_objectSpread({},tutorialService.getVariables()),{},{docs:{base_url:docLinks.OPENSEARCH_WEBSITE_URL,beats:{filebeat:docLinks.links.noDocumentation.filebeat,metricbeat:docLinks.links.noDocumentation.metricbeat,heartbeat:docLinks.links.noDocumentation.heartbeat,functionbeat:docLinks.links.noDocumentation.functionbeat,winlogbeat:docLinks.links.noDocumentation.winlogbeat,auditbeat:docLinks.links.noDocumentation.auditbeat},logstash:docLinks.links.noDocumentation.logstash,version:docLinks.DOC_LINK_VERSION},opensearchDashboards:{version:opensearchDashboardsVersion}}),params:params};mustacheWriter.parse(text,TEMPLATE_TAGS);return mustacheWriter.render(text,variables)}},2645:function(module,exports,__webpack_require__){switch(window.__osdThemeTag__){case"v7dark":return __webpack_require__(2646);case"v7light":return __webpack_require__(2648);case"v8dark":return __webpack_require__(2650);case"v8light":return __webpack_require__(2652)}},2646:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2647);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2647:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(2112);var _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1__);var _core_public_core_app_images_bg_top_branded_dark_svg__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(2200);var _core_public_core_app_images_bg_top_branded_dark_svg__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_core_public_core_app_images_bg_top_branded_dark_svg__WEBPACK_IMPORTED_MODULE_2__);var _core_public_core_app_images_bg_bottom_branded_dark_svg__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(2201);var _core_public_core_app_images_bg_bottom_branded_dark_svg__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_core_public_core_app_images_bg_bottom_branded_dark_svg__WEBPACK_IMPORTED_MODULE_3__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));var ___CSS_LOADER_URL_REPLACEMENT_0___=_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1___default()(_core_public_core_app_images_bg_top_branded_dark_svg__WEBPACK_IMPORTED_MODULE_2___default.a);var ___CSS_LOADER_URL_REPLACEMENT_1___=_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1___default()(_core_public_core_app_images_bg_bottom_branded_dark_svg__WEBPACK_IMPORTED_MODULE_3___default.a);___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.homWrapper{background-color:#1d1e24;display:flex;flex-direction:column;min-height:calc(100vh - 49px)}.headerIsExpanded .homWrapper{min-height:calc(100vh - 98px)}.homContent{margin:0 auto;max-width:1200px;padding:32px 16px;width:100%}.homData--expanded{flex-direction:column}.homData--expanded,.homData--expanded>*{margin-bottom:0 !important;margin-top:0 !important}.homDataAdd__actionButton{margin-right:0}.homSampleDataSetCards{min-height:1px}.homSolutions{margin-top:-68px}.homSolutions__content{min-height:256px}@media only screen and (max-width: 574px){.homSolutions__content{flex-direction:column}}@media only screen and (min-width: 575px)and (max-width: 767px){.homSolutions__content{flex-direction:column}}@media only screen and (min-width: 992px)and (max-width: 1199px){.homSolutions__group{max-width:calc(75% - 24px)}}@media only screen and (min-width: 1200px){.homSolutions__group{max-width:calc(50% - 24px)}}.homSolutionPanel{border-radius:4px;color:inherit;flex:1;transition:all 150ms cubic-bezier(0.694, 0.0482, 0.335, 1)}.homSolutionPanel:hover,.homSolutionPanel:focus{box-shadow:0 4px 8px 0 rgba(0,0,0,.15),0 2px 2px -1px rgba(0,0,0,.3);transform:translateY(-2px)}.homSolutionPanel:hover .homSolutionPanel__title,.homSolutionPanel:focus .homSolutionPanel__title{text-decoration:underline}.homSolutionPanel,.homSolutionPanel__inner{display:flex;flex-direction:column}.homSolutionPanel__inner{overflow:hidden}.homSolutionPanel__header{color:#1d1e24;padding:16px}.homSolutionPanel__icon{background-color:#1d1e24 !important;box-shadow:none !important;margin:0 auto 8px;padding:8px}.homSolutionPanel__subtitle{margin-top:4px}.homSolutionPanel__content{flex-direction:column;justify-content:center;padding:16px}@media only screen and (max-width: 574px){.homSolutionPanel__content{text-align:center}}@media only screen and (min-width: 575px)and (max-width: 767px){.homSolutionPanel__content{text-align:center}}.homSolutionPanel__header{background-color:#1ba9f5;background-repeat:no-repeat;background-position:top 0 left 0,bottom 0 right 0;background-size:128px,192px}.homSolutionPanel--enterpriseSearch .homSolutionPanel__header{background-color:#7de2d1;background-position:top 8px left 0,bottom 8px right 8px;background-size:20px,32px}.homSolutionPanel--observability .homSolutionPanel__header{background-color:#f990c0;background-position:top 8px right 8px;background-size:36px}.homSolutionPanel--securitySolution .homSolutionPanel__header{background-color:#d4dae5;background-position:top 8px left 8px;background-size:48px}.homSolutionPanel__customIconContainer{height:50px;padding:5px}.homSolutionPanel__customIcon{height:100%;max-width:100%}.homSynopsis__card.homSynopsis__card--noPanel{border:none;box-shadow:none}.homSynopsis__card .homSynopsis__cardTitle{display:flex}.homSynopsis__card .euiCard__content{padding-top:0 !important}.homWelcome{position:fixed;top:0;left:0;right:0;bottom:0;z-index:7000;background:inherit;background-color:#141519;opacity:0;overflow:auto;animation:opensearchDashboardsFullScreenGraphics_FadeIn 500ms cubic-bezier(0.694, 0.0482, 0.335, 1) 0s forwards}.homWelcome::before{position:absolute;top:0;left:0;z-index:1;width:310px;height:477px;content:url("+___CSS_LOADER_URL_REPLACEMENT_0___+")}.homWelcome::after{position:fixed;bottom:0;right:0;z-index:1;width:313px;height:461px;content:url("+___CSS_LOADER_URL_REPLACEMENT_1___+")}@keyframes opensearchDashboardsFullScreenGraphics_FadeIn{from{opacity:0}to{opacity:1}}.homWelcome__header{position:relative;padding:32px;z-index:10}.homWelcome__logo{margin-bottom:32px;display:inline-block;width:80px;height:80px;line-height:80px;text-align:center;background-color:#1d1e24;border-radius:100%;padding:8px;box-shadow:0 6px 12px -1px rgba(0,0,0,.2),0 4px 4px -1px rgba(0,0,0,.2),0 2px 2px 0 rgba(0,0,0,.2)}.homWelcome__logo .euiIcon{vertical-align:baseline}.homWelcome__customLogoContainer{height:80px;padding:10px}.homWelcome__customLogo{height:100%;max-width:100%}.homWelcome__footerAction{margin-right:8px}.homWelcome__content{position:relative;margin:auto;max-width:512px;padding-left:32px;padding-right:32px;z-index:10}.homTutorial__notFoundPanel{background:#1d1e24;padding:24px}.homTutorial__instruction{flex-shrink:0}.home-homepage-pageBody{padding:0 24px}.home-homepage-body--fill{min-height:800px}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2648:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2649);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2649:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(2112);var _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1__);var _core_public_core_app_images_bg_top_branded_svg__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(2202);var _core_public_core_app_images_bg_top_branded_svg__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_core_public_core_app_images_bg_top_branded_svg__WEBPACK_IMPORTED_MODULE_2__);var _core_public_core_app_images_bg_bottom_branded_svg__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(2203);var _core_public_core_app_images_bg_bottom_branded_svg__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_core_public_core_app_images_bg_bottom_branded_svg__WEBPACK_IMPORTED_MODULE_3__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));var ___CSS_LOADER_URL_REPLACEMENT_0___=_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1___default()(_core_public_core_app_images_bg_top_branded_svg__WEBPACK_IMPORTED_MODULE_2___default.a);var ___CSS_LOADER_URL_REPLACEMENT_1___=_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1___default()(_core_public_core_app_images_bg_bottom_branded_svg__WEBPACK_IMPORTED_MODULE_3___default.a);___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.homWrapper{background-color:#fff;display:flex;flex-direction:column;min-height:calc(100vh - 49px)}.headerIsExpanded .homWrapper{min-height:calc(100vh - 98px)}.homContent{margin:0 auto;max-width:1200px;padding:32px 16px;width:100%}.homData--expanded{flex-direction:column}.homData--expanded,.homData--expanded>*{margin-bottom:0 !important;margin-top:0 !important}.homDataAdd__actionButton{margin-right:0}.homSampleDataSetCards{min-height:1px}.homSolutions{margin-top:-68px}.homSolutions__content{min-height:256px}@media only screen and (max-width: 574px){.homSolutions__content{flex-direction:column}}@media only screen and (min-width: 575px)and (max-width: 767px){.homSolutions__content{flex-direction:column}}@media only screen and (min-width: 992px)and (max-width: 1199px){.homSolutions__group{max-width:calc(75% - 24px)}}@media only screen and (min-width: 1200px){.homSolutions__group{max-width:calc(50% - 24px)}}.homSolutionPanel{border-radius:4px;color:inherit;flex:1;transition:all 150ms cubic-bezier(0.694, 0.0482, 0.335, 1)}.homSolutionPanel:hover,.homSolutionPanel:focus{box-shadow:0 4px 8px 0 rgba(152,162,179,.15),0 2px 2px -1px rgba(152,162,179,.3);transform:translateY(-2px)}.homSolutionPanel:hover .homSolutionPanel__title,.homSolutionPanel:focus .homSolutionPanel__title{text-decoration:underline}.homSolutionPanel,.homSolutionPanel__inner{display:flex;flex-direction:column}.homSolutionPanel__inner{overflow:hidden}.homSolutionPanel__header{color:#fff;padding:16px}.homSolutionPanel__icon{background-color:#fff !important;box-shadow:none !important;margin:0 auto 8px;padding:8px}.homSolutionPanel__subtitle{margin-top:4px}.homSolutionPanel__content{flex-direction:column;justify-content:center;padding:16px}@media only screen and (max-width: 574px){.homSolutionPanel__content{text-align:center}}@media only screen and (min-width: 575px)and (max-width: 767px){.homSolutionPanel__content{text-align:center}}.homSolutionPanel__header{background-color:#006bb4;background-repeat:no-repeat;background-position:top 0 left 0,bottom 0 right 0;background-size:128px,192px}.homSolutionPanel--enterpriseSearch .homSolutionPanel__header{background-color:#017d73;background-position:top 8px left 0,bottom 8px right 8px;background-size:20px,32px}.homSolutionPanel--observability .homSolutionPanel__header{background-color:#dd0a73;background-position:top 8px right 8px;background-size:36px}.homSolutionPanel--securitySolution .homSolutionPanel__header{background-color:#343741;background-position:top 8px left 8px;background-size:48px}.homSolutionPanel__customIconContainer{height:50px;padding:5px}.homSolutionPanel__customIcon{height:100%;max-width:100%}.homSynopsis__card.homSynopsis__card--noPanel{border:none;box-shadow:none}.homSynopsis__card .homSynopsis__cardTitle{display:flex}.homSynopsis__card .euiCard__content{padding-top:0 !important}.homWelcome{position:fixed;top:0;left:0;right:0;bottom:0;z-index:7000;background:inherit;background-color:#fafbfd;opacity:0;overflow:auto;animation:opensearchDashboardsFullScreenGraphics_FadeIn 500ms cubic-bezier(0.694, 0.0482, 0.335, 1) 0s forwards}.homWelcome::before{position:absolute;top:0;left:0;z-index:1;width:310px;height:477px;content:url("+___CSS_LOADER_URL_REPLACEMENT_0___+")}.homWelcome::after{position:fixed;bottom:0;right:0;z-index:1;width:313px;height:461px;content:url("+___CSS_LOADER_URL_REPLACEMENT_1___+")}@keyframes opensearchDashboardsFullScreenGraphics_FadeIn{from{opacity:0}to{opacity:1}}.homWelcome__header{position:relative;padding:32px;z-index:10}.homWelcome__logo{margin-bottom:32px;display:inline-block;width:80px;height:80px;line-height:80px;text-align:center;background-color:#fff;border-radius:100%;padding:8px;box-shadow:0 6px 12px -1px rgba(152,162,179,.2),0 4px 4px -1px rgba(152,162,179,.2),0 2px 2px 0 rgba(152,162,179,.2)}.homWelcome__logo .euiIcon{vertical-align:baseline}.homWelcome__customLogoContainer{height:80px;padding:10px}.homWelcome__customLogo{height:100%;max-width:100%}.homWelcome__footerAction{margin-right:8px}.homWelcome__content{position:relative;margin:auto;max-width:512px;padding-left:32px;padding-right:32px;z-index:10}.homTutorial__notFoundPanel{background:#fff;padding:24px}.homTutorial__instruction{flex-shrink:0}.home-homepage-pageBody{padding:0 24px}.home-homepage-body--fill{min-height:800px}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2650:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2651);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2651:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(2112);var _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1__);var _core_public_core_app_images_bg_top_branded_dark_svg__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(2200);var _core_public_core_app_images_bg_top_branded_dark_svg__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_core_public_core_app_images_bg_top_branded_dark_svg__WEBPACK_IMPORTED_MODULE_2__);var _core_public_core_app_images_bg_bottom_branded_dark_svg__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(2201);var _core_public_core_app_images_bg_bottom_branded_dark_svg__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_core_public_core_app_images_bg_bottom_branded_dark_svg__WEBPACK_IMPORTED_MODULE_3__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));var ___CSS_LOADER_URL_REPLACEMENT_0___=_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1___default()(_core_public_core_app_images_bg_top_branded_dark_svg__WEBPACK_IMPORTED_MODULE_2___default.a);var ___CSS_LOADER_URL_REPLACEMENT_1___=_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1___default()(_core_public_core_app_images_bg_bottom_branded_dark_svg__WEBPACK_IMPORTED_MODULE_3___default.a);___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.homWrapper{background-color:#0a121a;display:flex;flex-direction:column;min-height:calc(100vh - 49px)}.headerIsExpanded .homWrapper{min-height:calc(100vh - 98px)}.homContent{margin:0 auto;max-width:1200px;padding:32px 16px;width:100%}.homData--expanded{flex-direction:column}.homData--expanded,.homData--expanded>*{margin-bottom:0 !important;margin-top:0 !important}.homDataAdd__actionButton{margin-right:0}.homSampleDataSetCards{min-height:1px}.homSolutions{margin-top:-68px}.homSolutions__content{min-height:256px}@media only screen and (max-width: 574px){.homSolutions__content{flex-direction:column}}@media only screen and (min-width: 575px)and (max-width: 767px){.homSolutions__content{flex-direction:column}}@media only screen and (min-width: 992px)and (max-width: 1199px){.homSolutions__group{max-width:calc(75% - 24px)}}@media only screen and (min-width: 1200px){.homSolutions__group{max-width:calc(50% - 24px)}}.homSolutionPanel{border-radius:4px;color:inherit;flex:1;transition:all 150ms cubic-bezier(0.694, 0.0482, 0.335, 1)}.homSolutionPanel:hover,.homSolutionPanel:focus{box-shadow:0 4px 8px 0 rgba(0,0,0,.15),0 2px 2px -1px rgba(0,0,0,.3);transform:translateY(-2px)}.homSolutionPanel:hover .homSolutionPanel__title,.homSolutionPanel:focus .homSolutionPanel__title{text-decoration:underline}.homSolutionPanel,.homSolutionPanel__inner{display:flex;flex-direction:column}.homSolutionPanel__inner{overflow:hidden}.homSolutionPanel__header{color:#0a121a;padding:16px}.homSolutionPanel__icon{background-color:#0a121a !important;box-shadow:none !important;margin:0 auto 8px;padding:8px}.homSolutionPanel__subtitle{margin-top:4px}.homSolutionPanel__content{flex-direction:column;justify-content:center;padding:16px}@media only screen and (max-width: 574px){.homSolutionPanel__content{text-align:center}}@media only screen and (min-width: 575px)and (max-width: 767px){.homSolutionPanel__content{text-align:center}}.homSolutionPanel__header{background-color:#159d8d;background-repeat:no-repeat;background-position:top 0 left 0,bottom 0 right 0;background-size:128px,192px}.homSolutionPanel--enterpriseSearch .homSolutionPanel__header{background-color:#7de2d1;background-position:top 8px left 0,bottom 8px right 8px;background-size:20px,32px}.homSolutionPanel--observability .homSolutionPanel__header{background-color:#f990c0;background-position:top 8px right 8px;background-size:36px}.homSolutionPanel--securitySolution .homSolutionPanel__header{background-color:#dfe3e8;background-position:top 8px left 8px;background-size:48px}.homSolutionPanel__customIconContainer{height:50px;padding:5px}.homSolutionPanel__customIcon{height:100%;max-width:100%}.homSynopsis__card.homSynopsis__card--noPanel{border:none;box-shadow:none}.homSynopsis__card .homSynopsis__cardTitle{display:flex}.homSynopsis__card .euiCard__content{padding-top:0 !important}.homWelcome{position:fixed;top:0;left:0;right:0;bottom:0;z-index:7000;background:inherit;background-color:#172430;opacity:0;overflow:auto;animation:opensearchDashboardsFullScreenGraphics_FadeIn 500ms cubic-bezier(0.694, 0.0482, 0.335, 1) 0s forwards}.homWelcome::before{position:absolute;top:0;left:0;z-index:1;width:310px;height:477px;content:url("+___CSS_LOADER_URL_REPLACEMENT_0___+")}.homWelcome::after{position:fixed;bottom:0;right:0;z-index:1;width:313px;height:461px;content:url("+___CSS_LOADER_URL_REPLACEMENT_1___+")}@keyframes opensearchDashboardsFullScreenGraphics_FadeIn{from{opacity:0}to{opacity:1}}.homWelcome__header{position:relative;padding:32px;z-index:10}.homWelcome__logo{margin-bottom:32px;display:inline-block;width:80px;height:80px;line-height:80px;text-align:center;background-color:#0a121a;border-radius:100%;padding:8px;box-shadow:0 6px 12px -1px rgba(0,0,0,.2),0 4px 4px -1px rgba(0,0,0,.2),0 2px 2px 0 rgba(0,0,0,.2)}.homWelcome__logo .euiIcon{vertical-align:baseline}.homWelcome__customLogoContainer{height:80px;padding:10px}.homWelcome__customLogo{height:100%;max-width:100%}.homWelcome__footerAction{margin-right:8px}.homWelcome__content{position:relative;margin:auto;max-width:512px;padding-left:32px;padding-right:32px;z-index:10}.homTutorial__notFoundPanel{background:#0a121a;padding:24px}.homTutorial__instruction{flex-shrink:0}.home-homepage-pageBody{padding:0 24px}.home-homepage-body--fill{min-height:800px}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},2652:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(2653);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},2653:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(2112);var _node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1__);var _core_public_core_app_images_bg_top_branded_svg__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(2202);var _core_public_core_app_images_bg_top_branded_svg__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_core_public_core_app_images_bg_top_branded_svg__WEBPACK_IMPORTED_MODULE_2__);var _core_public_core_app_images_bg_bottom_branded_svg__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(2203);var _core_public_core_app_images_bg_bottom_branded_svg__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_core_public_core_app_images_bg_bottom_branded_svg__WEBPACK_IMPORTED_MODULE_3__);var ___CSS_LOADER_EXPORT___=_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));var ___CSS_LOADER_URL_REPLACEMENT_0___=_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1___default()(_core_public_core_app_images_bg_top_branded_svg__WEBPACK_IMPORTED_MODULE_2___default.a);var ___CSS_LOADER_URL_REPLACEMENT_1___=_node_modules_css_loader_dist_runtime_getUrl_js__WEBPACK_IMPORTED_MODULE_1___default()(_core_public_core_app_images_bg_bottom_branded_svg__WEBPACK_IMPORTED_MODULE_3___default.a);___CSS_LOADER_EXPORT___.push([module.i,"/*!\n * SPDX-License-Identifier: Apache-2.0\n *\n * The OpenSearch Contributors require contributions made to\n * this file be licensed under the Apache-2.0 license or a\n * compatible open source license.\n *\n * Modifications Copyright OpenSearch Contributors. See\n * GitHub history for details.\n */\n\n.homWrapper{background-color:#fcfeff;display:flex;flex-direction:column;min-height:calc(100vh - 49px)}.headerIsExpanded .homWrapper{min-height:calc(100vh - 98px)}.homContent{margin:0 auto;max-width:1200px;padding:32px 16px;width:100%}.homData--expanded{flex-direction:column}.homData--expanded,.homData--expanded>*{margin-bottom:0 !important;margin-top:0 !important}.homDataAdd__actionButton{margin-right:0}.homSampleDataSetCards{min-height:1px}.homSolutions{margin-top:-68px}.homSolutions__content{min-height:256px}@media only screen and (max-width: 574px){.homSolutions__content{flex-direction:column}}@media only screen and (min-width: 575px)and (max-width: 767px){.homSolutions__content{flex-direction:column}}@media only screen and (min-width: 992px)and (max-width: 1199px){.homSolutions__group{max-width:calc(75% - 24px)}}@media only screen and (min-width: 1200px){.homSolutions__group{max-width:calc(50% - 24px)}}.homSolutionPanel{border-radius:4px;color:inherit;flex:1;transition:all 150ms cubic-bezier(0.694, 0.0482, 0.335, 1)}.homSolutionPanel:hover,.homSolutionPanel:focus{box-shadow:0 4px 8px 0 rgba(173,180,186,.15),0 2px 2px -1px rgba(173,180,186,.3);transform:translateY(-2px)}.homSolutionPanel:hover .homSolutionPanel__title,.homSolutionPanel:focus .homSolutionPanel__title{text-decoration:underline}.homSolutionPanel,.homSolutionPanel__inner{display:flex;flex-direction:column}.homSolutionPanel__inner{overflow:hidden}.homSolutionPanel__header{color:#fcfeff;padding:16px}.homSolutionPanel__icon{background-color:#fcfeff !important;box-shadow:none !important;margin:0 auto 8px;padding:8px}.homSolutionPanel__subtitle{margin-top:4px}.homSolutionPanel__content{flex-direction:column;justify-content:center;padding:16px}@media only screen and (max-width: 574px){.homSolutionPanel__content{text-align:center}}@media only screen and (min-width: 575px)and (max-width: 767px){.homSolutionPanel__content{text-align:center}}.homSolutionPanel__header{background-color:#07827e;background-repeat:no-repeat;background-position:top 0 left 0,bottom 0 right 0;background-size:128px,192px}.homSolutionPanel--enterpriseSearch .homSolutionPanel__header{background-color:#017d73;background-position:top 8px left 0,bottom 8px right 8px;background-size:20px,32px}.homSolutionPanel--observability .homSolutionPanel__header{background-color:#dd0a73;background-position:top 8px right 8px;background-size:36px}.homSolutionPanel--securitySolution .homSolutionPanel__header{background-color:#2a3947;background-position:top 8px left 8px;background-size:48px}.homSolutionPanel__customIconContainer{height:50px;padding:5px}.homSolutionPanel__customIcon{height:100%;max-width:100%}.homSynopsis__card.homSynopsis__card--noPanel{border:none;box-shadow:none}.homSynopsis__card .homSynopsis__cardTitle{display:flex}.homSynopsis__card .euiCard__content{padding-top:0 !important}.homWelcome{position:fixed;top:0;left:0;right:0;bottom:0;z-index:7000;background:inherit;background-color:#f0f2f4;opacity:0;overflow:auto;animation:opensearchDashboardsFullScreenGraphics_FadeIn 500ms cubic-bezier(0.694, 0.0482, 0.335, 1) 0s forwards}.homWelcome::before{position:absolute;top:0;left:0;z-index:1;width:310px;height:477px;content:url("+___CSS_LOADER_URL_REPLACEMENT_0___+")}.homWelcome::after{position:fixed;bottom:0;right:0;z-index:1;width:313px;height:461px;content:url("+___CSS_LOADER_URL_REPLACEMENT_1___+")}@keyframes opensearchDashboardsFullScreenGraphics_FadeIn{from{opacity:0}to{opacity:1}}.homWelcome__header{position:relative;padding:32px;z-index:10}.homWelcome__logo{margin-bottom:32px;display:inline-block;width:80px;height:80px;line-height:80px;text-align:center;background-color:#fcfeff;border-radius:100%;padding:8px;box-shadow:0 6px 12px -1px rgba(173,180,186,.2),0 4px 4px -1px rgba(173,180,186,.2),0 2px 2px 0 rgba(173,180,186,.2)}.homWelcome__logo .euiIcon{vertical-align:baseline}.homWelcome__customLogoContainer{height:80px;padding:10px}.homWelcome__customLogo{height:100%;max-width:100%}.homWelcome__footerAction{margin-right:8px}.homWelcome__content{position:relative;margin:auto;max-width:512px;padding-left:32px;padding-right:32px;z-index:10}.homTutorial__notFoundPanel{background:#fcfeff;padding:24px}.homTutorial__instruction{flex-shrink:0}.home-homepage-pageBody{padding:0 24px}.home-homepage-body--fill{min-height:800px}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},655:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"renderApp",{enumerable:true,get:function(){return _application.renderApp}});Object.defineProperty(exports,"renderImportSampleDataApp",{enumerable:true,get:function(){return _application.renderImportSampleDataApp}});var _application=__webpack_require__(2499)}}]);