info = {
    "name": "sk",
    "date_order": "DMY",
    "january": [
        "jan",
        "január",
        "januára"
    ],
    "february": [
        "feb",
        "február",
        "februára"
    ],
    "march": [
        "mar",
        "marca",
        "marec"
    ],
    "april": [
        "apr",
        "apríl",
        "apríla"
    ],
    "may": [
        "máj",
        "mája"
    ],
    "june": [
        "jún",
        "júna"
    ],
    "july": [
        "júl",
        "júla"
    ],
    "august": [
        "aug",
        "august",
        "augusta"
    ],
    "september": [
        "sep",
        "september",
        "septembra"
    ],
    "october": [
        "okt",
        "október",
        "októbra"
    ],
    "november": [
        "nov",
        "november",
        "novembra"
    ],
    "december": [
        "dec",
        "december",
        "decembra"
    ],
    "monday": [
        "po",
        "pondelok"
    ],
    "tuesday": [
        "ut",
        "utorok"
    ],
    "wednesday": [
        "st",
        "streda"
    ],
    "thursday": [
        "št",
        "štvrtok"
    ],
    "friday": [
        "pi",
        "piatok"
    ],
    "saturday": [
        "so",
        "sobota"
    ],
    "sunday": [
        "ne",
        "nedeľa"
    ],
    "am": [
        "am"
    ],
    "pm": [
        "pm"
    ],
    "year": [
        "r",
        "rok"
    ],
    "month": [
        "mes",
        "mesiac"
    ],
    "week": [
        "týž",
        "týždeň"
    ],
    "day": [
        "d",
        "deň"
    ],
    "hour": [
        "h",
        "hodina"
    ],
    "minute": [
        "min",
        "minúta"
    ],
    "second": [
        "s",
        "sekunda"
    ],
    "relative-type": {
        "0 day ago": [
            "dnes"
        ],
        "0 hour ago": [
            "v tejto hodine"
        ],
        "0 minute ago": [
            "v tejto minúte"
        ],
        "0 month ago": [
            "tento mesiac"
        ],
        "0 second ago": [
            "teraz"
        ],
        "0 week ago": [
            "tento týždeň"
        ],
        "0 year ago": [
            "tento rok"
        ],
        "1 day ago": [
            "včera"
        ],
        "1 month ago": [
            "minulý mesiac"
        ],
        "1 week ago": [
            "minulý týždeň"
        ],
        "1 year ago": [
            "minulý rok"
        ],
        "in 1 day": [
            "zajtra"
        ],
        "in 1 month": [
            "budúci mesiac"
        ],
        "in 1 week": [
            "budúci týždeň"
        ],
        "in 1 year": [
            "budúci rok"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "pred (\\d+) d",
            "pred (\\d+) dňami",
            "pred (\\d+) dňom"
        ],
        "\\1 hour ago": [
            "pred (\\d+) h",
            "pred (\\d+) hodinami",
            "pred (\\d+) hodinou"
        ],
        "\\1 minute ago": [
            "pred (\\d+) min",
            "pred (\\d+) minútami",
            "pred (\\d+) minútou"
        ],
        "\\1 month ago": [
            "pred (\\d+) mes",
            "pred (\\d+) mesiacmi",
            "pred (\\d+) mesiacom"
        ],
        "\\1 second ago": [
            "pred (\\d+) s",
            "pred (\\d+) sekundami",
            "pred (\\d+) sekundou"
        ],
        "\\1 week ago": [
            "pred (\\d+) týž",
            "pred (\\d+) týždňami",
            "pred (\\d+) týždňom"
        ],
        "\\1 year ago": [
            "pred (\\d+) r",
            "pred (\\d+) rokmi",
            "pred (\\d+) rokom"
        ],
        "in \\1 day": [
            "o (\\d+) d",
            "o (\\d+) deň",
            "o (\\d+) dní"
        ],
        "in \\1 hour": [
            "o (\\d+) h",
            "o (\\d+) hodinu",
            "o (\\d+) hodín"
        ],
        "in \\1 minute": [
            "o (\\d+) min",
            "o (\\d+) minút",
            "o (\\d+) minútu"
        ],
        "in \\1 month": [
            "o (\\d+) mes",
            "o (\\d+) mesiac",
            "o (\\d+) mesiacov"
        ],
        "in \\1 second": [
            "o (\\d+) s",
            "o (\\d+) sekundu",
            "o (\\d+) sekúnd"
        ],
        "in \\1 week": [
            "o (\\d+) týž",
            "o (\\d+) týždeň",
            "o (\\d+) týždňov"
        ],
        "in \\1 year": [
            "o (\\d+) r",
            "o (\\d+) rok",
            "o (\\d+) rokov"
        ]
    },
    "locale_specific": {},
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
