# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
Media module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_media.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Media
else:
    import _Media

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Media.delete_SwigPyIterator

    def value(self):
        return _Media.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _Media.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _Media.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _Media.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _Media.SwigPyIterator_equal(self, x)

    def copy(self):
        return _Media.SwigPyIterator_copy(self)

    def next(self):
        return _Media.SwigPyIterator_next(self)

    def __next__(self):
        return _Media.SwigPyIterator___next__(self)

    def previous(self):
        return _Media.SwigPyIterator_previous(self)

    def advance(self, n):
        return _Media.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _Media.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _Media.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _Media.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _Media.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _Media.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _Media.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Media:
_Media.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _Media.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TCollection
import OCC.Core.Image
import OCC.Core.Graphic3d
import OCC.Core.BVH
import OCC.Core.Quantity
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.Aspect
import OCC.Core.TopLoc
import OCC.Core.Bnd
import OCC.Core.TColgp
import OCC.Core.OSD

from enum import IntEnum
from OCC.Core.Exception import *




def Handle_Media_BufferPool_Create():
    return _Media.Handle_Media_BufferPool_Create()

def Handle_Media_BufferPool_DownCast(t):
    return _Media.Handle_Media_BufferPool_DownCast(t)

def Handle_Media_BufferPool_IsNull(t):
    return _Media.Handle_Media_BufferPool_IsNull(t)

def Handle_Media_CodecContext_Create():
    return _Media.Handle_Media_CodecContext_Create()

def Handle_Media_CodecContext_DownCast(t):
    return _Media.Handle_Media_CodecContext_DownCast(t)

def Handle_Media_CodecContext_IsNull(t):
    return _Media.Handle_Media_CodecContext_IsNull(t)

def Handle_Media_FormatContext_Create():
    return _Media.Handle_Media_FormatContext_Create()

def Handle_Media_FormatContext_DownCast(t):
    return _Media.Handle_Media_FormatContext_DownCast(t)

def Handle_Media_FormatContext_IsNull(t):
    return _Media.Handle_Media_FormatContext_IsNull(t)

def Handle_Media_Frame_Create():
    return _Media.Handle_Media_Frame_Create()

def Handle_Media_Frame_DownCast(t):
    return _Media.Handle_Media_Frame_DownCast(t)

def Handle_Media_Frame_IsNull(t):
    return _Media.Handle_Media_Frame_IsNull(t)

def Handle_Media_Packet_Create():
    return _Media.Handle_Media_Packet_Create()

def Handle_Media_Packet_DownCast(t):
    return _Media.Handle_Media_Packet_DownCast(t)

def Handle_Media_Packet_IsNull(t):
    return _Media.Handle_Media_Packet_IsNull(t)

def Handle_Media_PlayerContext_Create():
    return _Media.Handle_Media_PlayerContext_Create()

def Handle_Media_PlayerContext_DownCast(t):
    return _Media.Handle_Media_PlayerContext_DownCast(t)

def Handle_Media_PlayerContext_IsNull(t):
    return _Media.Handle_Media_PlayerContext_IsNull(t)

def Handle_Media_Scaler_Create():
    return _Media.Handle_Media_Scaler_Create()

def Handle_Media_Scaler_DownCast(t):
    return _Media.Handle_Media_Scaler_DownCast(t)

def Handle_Media_Scaler_IsNull(t):
    return _Media.Handle_Media_Scaler_IsNull(t)

def Handle_Media_Timer_Create():
    return _Media.Handle_Media_Timer_Create()

def Handle_Media_Timer_DownCast(t):
    return _Media.Handle_Media_Timer_DownCast(t)

def Handle_Media_Timer_IsNull(t):
    return _Media.Handle_Media_Timer_IsNull(t)
class Media_BufferPool(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _Media.Media_BufferPool_swiginit(self, _Media.new_Media_BufferPool(*args))

    def BufferSize(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return buffer size within the pool.

        """
        return _Media.Media_BufferPool_BufferSize(self, *args)

    def GetBuffer(self, *args):
        r"""
        Return
        -------
        AVBufferRef *

        Description
        -----------
        Get new buffer from the pool.

        """
        return _Media.Media_BufferPool_GetBuffer(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        theBufferSize: int

        Return
        -------
        bool

        Description
        -----------
        (re-)initialize the pool.

        """
        return _Media.Media_BufferPool_Init(self, *args)

    def Release(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Release the pool (reference-counted buffer will be released when needed).

        """
        return _Media.Media_BufferPool_Release(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Media_BufferPool_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_BufferPool

# Register Media_BufferPool in _Media:
_Media.Media_BufferPool_swigregister(Media_BufferPool)
class Media_CodecContext(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructor.

        """
        _Media.Media_CodecContext_swiginit(self, _Media.new_Media_CodecContext(*args))

    def CanProcessPacket(self, *args):
        r"""

        Parameters
        ----------
        thePacket: Media_Packet

        Return
        -------
        bool

        Description
        -----------
        Return true if packet belongs to this stream.

        """
        return _Media.Media_CodecContext_CanProcessPacket(self, *args)

    def Close(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Close input.

        """
        return _Media.Media_CodecContext_Close(self, *args)

    def Context(self, *args):
        r"""
        Return
        -------
        AVCodecContext *

        Description
        -----------
        Return context.

        """
        return _Media.Media_CodecContext_Context(self, *args)

    def Flush(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Avcodec_flush_buffers() wrapper.

        """
        return _Media.Media_CodecContext_Flush(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        theStream: AVStream
        thePtsStartBase: double
        theNbThreads: int (optional, default to -1)

        Return
        -------
        bool

        Description
        -----------
        Open codec specified within the stream. @param thestream stream to open @param theptsstartbase pts start in seconds @param thenbthreads amount of threads to use for avmedia_type_video stream; -1 means osd_parallel::nblogicalprocessors(),  0 means auto by ffmpeg itself >0 means specified number of threads (decoder should support multi-threading to take effect).

        Parameters
        ----------
        theStream: AVStream
        thePtsStartBase: double
        theNbThreads: int
        theCodecId: int

        Return
        -------
        bool

        Description
        -----------
        Open codec. @param thestream stream to open @param theptsstartbase pts start in seconds @param thenbthreads amount of threads to use for avmedia_type_video stream; -1 means osd_parallel::nblogicalprocessors(),  0 means auto by ffmpeg itself >0 means specified number of threads (decoder should support multi-threading to take effect) @param thecodecid codec (avcodecid) to open.

        """
        return _Media.Media_CodecContext_Init(self, *args)

    def ReceiveFrame(self, *args):
        r"""

        Parameters
        ----------
        theFrame: Media_Frame

        Return
        -------
        bool

        Description
        -----------
        Avcodec_receive_frame() wrapper.

        """
        return _Media.Media_CodecContext_ReceiveFrame(self, *args)

    def SendPacket(self, *args):
        r"""

        Parameters
        ----------
        thePacket: Media_Packet

        Return
        -------
        bool

        Description
        -----------
        Avcodec_send_packet() wrapper.

        """
        return _Media.Media_CodecContext_SendPacket(self, *args)

    def SizeX(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return source frame width.

        """
        return _Media.Media_CodecContext_SizeX(self, *args)

    def SizeY(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return source frame height.

        """
        return _Media.Media_CodecContext_SizeY(self, *args)

    def StreamIndex(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return stream index.

        """
        return _Media.Media_CodecContext_StreamIndex(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Media_CodecContext_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_CodecContext

# Register Media_CodecContext in _Media:
_Media.Media_CodecContext_swigregister(Media_CodecContext)
class Media_FormatContext(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructor.

        """
        _Media.Media_FormatContext_swiginit(self, _Media.new_Media_FormatContext(*args))

    def Close(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Close input.

        """
        return _Media.Media_FormatContext_Close(self, *args)

    def Context(self, *args):
        r"""
        Return
        -------
        AVFormatContext *

        Description
        -----------
        Return context.

        """
        return _Media.Media_FormatContext_Context(self, *args)

    def Duration(self, *args):
        r"""
        Return
        -------
        double

        Description
        -----------
        Return duration in seconds.

        """
        return _Media.Media_FormatContext_Duration(self, *args)

    @staticmethod
    def FormatAVErrorDescription(*args):
        r"""

        Parameters
        ----------
        theErrCodeAV: int

        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        Returns string description for averror code.

        """
        return _Media.Media_FormatContext_FormatAVErrorDescription(*args)

    @staticmethod
    def FormatTime(*args):
        r"""

        Parameters
        ----------
        theSeconds: double

        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        Time formatter.

        """
        return _Media.Media_FormatContext_FormatTime(*args)

    @staticmethod
    def FormatTimeProgress(*args):
        r"""

        Parameters
        ----------
        theProgress: double
        theDuration: double

        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        Time progress / duration formatter.

        """
        return _Media.Media_FormatContext_FormatTimeProgress(*args)

    @staticmethod
    def FormatUnitsToSeconds(*args):
        r"""

        Parameters
        ----------
        theTimeUnits: int64_t

        Return
        -------
        double

        Description
        -----------
        Convert time units into seconds for context. @param thetimeunits value to convert return converted time units in seconds.

        """
        return _Media.Media_FormatContext_FormatUnitsToSeconds(*args)

    def NbSteams(self, *args):
        r"""
        Return
        -------
        unsigned int

        Description
        -----------
        Return amount of streams.

        """
        return _Media.Media_FormatContext_NbSteams(self, *args)

    def OpenInput(self, *args):
        r"""

        Parameters
        ----------
        theInput: str

        Return
        -------
        bool

        Description
        -----------
        Open input.

        """
        return _Media.Media_FormatContext_OpenInput(self, *args)

    def PtsStartBase(self, *args):
        r"""
        Return
        -------
        double

        Description
        -----------
        Return pts start base in seconds.

        """
        return _Media.Media_FormatContext_PtsStartBase(self, *args)

    def ReadPacket(self, *args):
        r"""

        Parameters
        ----------
        thePacket: Media_Packet

        Return
        -------
        bool

        Description
        -----------
        Av_read_frame() wrapper.

        """
        return _Media.Media_FormatContext_ReadPacket(self, *args)

    @staticmethod
    def SecondsToUnits(*args):
        r"""

        Parameters
        ----------
        theTimeSeconds: double

        Return
        -------
        int64_t

        Description
        -----------
        Convert seconds into time units for context. @param thetimeseconds value to convert return time units.

        Parameters
        ----------
        theTimeBase: AVRational
        theTimeSeconds: double

        Return
        -------
        int64_t

        Description
        -----------
        Convert seconds into time units. @param thetimebase the timebase @param thetimeseconds value to convert return time units.

        """
        return _Media.Media_FormatContext_SecondsToUnits(*args)

    def Seek(self, *args):
        r"""

        Parameters
        ----------
        theSeekPts: double
        toSeekBack: bool

        Return
        -------
        bool

        Description
        -----------
        Seek context to specified position.

        """
        return _Media.Media_FormatContext_Seek(self, *args)

    def SeekStream(self, *args):
        r"""

        Parameters
        ----------
        theStreamId: unsigned int
        theSeekPts: double
        toSeekBack: bool

        Return
        -------
        bool

        Description
        -----------
        Seek stream to specified position.

        """
        return _Media.Media_FormatContext_SeekStream(self, *args)

    def Stream(self, *args):
        r"""

        Parameters
        ----------
        theIndex: unsigned int

        Return
        -------
        AVStream

        Description
        -----------
        Return stream.

        """
        return _Media.Media_FormatContext_Stream(self, *args)

    def StreamInfo(self, *args):
        r"""

        Parameters
        ----------
        theIndex: unsigned int
        theCodecCtx: AVCodecContext * (optional, default to NULL)

        Return
        -------
        TCollection_AsciiString

        Description
        -----------
        Format stream info.

        """
        return _Media.Media_FormatContext_StreamInfo(self, *args)

    @staticmethod
    def StreamSecondsToUnits(*args):
        r"""

        Parameters
        ----------
        theStream: AVStream
        theTimeSeconds: double

        Return
        -------
        int64_t

        Description
        -----------
        Convert seconds into time units for stream. @param thestream the stream @param thetimeseconds value to convert return time units.

        """
        return _Media.Media_FormatContext_StreamSecondsToUnits(*args)

    @staticmethod
    def StreamUnitsToSeconds(*args):
        r"""

        Parameters
        ----------
        theStream: AVStream
        theTimeUnits: int64_t

        Return
        -------
        double

        Description
        -----------
        Convert time units into seconds using stream base. @param thestream the stream; @param thetimeunits value to convert; return converted time units in seconds.

        """
        return _Media.Media_FormatContext_StreamUnitsToSeconds(*args)

    @staticmethod
    def UnitsToSeconds(*args):
        r"""

        Parameters
        ----------
        theTimeBase: AVRational
        theTimeUnits: int64_t

        Return
        -------
        double

        Description
        -----------
        Convert time units into seconds. returns zero for invalid value. @param thetimebase the timebase @param thetimeunits value to convert return converted time units in seconds.

        """
        return _Media.Media_FormatContext_UnitsToSeconds(*args)


    @staticmethod
    def DownCast(t):
      return Handle_Media_FormatContext_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_FormatContext

# Register Media_FormatContext in _Media:
_Media.Media_FormatContext_swigregister(Media_FormatContext)
class Media_Frame(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _Media.Media_Frame_swiginit(self, _Media.new_Media_Frame(*args))

    def BestEffortTimestamp(self, *args):
        r"""
        Return
        -------
        int64_t

        Description
        -----------
        Return frame timestamp estimated using various heuristics, in stream time base.

        """
        return _Media.Media_Frame_BestEffortTimestamp(self, *args)

    def ChangeFrame(self, *args):
        r"""
        Return
        -------
        AVFrame *

        Description
        -----------
        Return frame.

        """
        return _Media.Media_Frame_ChangeFrame(self, *args)

    def Format(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return pixel format (avpixelformat).

        """
        return _Media.Media_Frame_Format(self, *args)

    @staticmethod
    def FormatFFmpeg2Occt(*args):
        r"""

        Parameters
        ----------
        theFormat: int

        Return
        -------
        Image_Format

        Description
        -----------
        Convert pixel format from ffmpeg (avpixelformat) to occt.

        """
        return _Media.Media_Frame_FormatFFmpeg2Occt(*args)

    @staticmethod
    def FormatOcct2FFmpeg(*args):
        r"""

        Parameters
        ----------
        theFormat: Image_Format

        Return
        -------
        int

        Description
        -----------
        Convert pixel format from occt to ffmpeg (avpixelformat). returns -1 (av_pix_fmt_none) if undefined.

        """
        return _Media.Media_Frame_FormatOcct2FFmpeg(*args)

    def Frame(self, *args):
        r"""
        Return
        -------
        AVFrame *

        Description
        -----------
        Return frame.

        """
        return _Media.Media_Frame_Frame(self, *args)

    def InitWrapper(self, *args):
        r"""

        Parameters
        ----------
        thePixMap: Image_PixMap

        Return
        -------
        bool

        Description
        -----------
        Wrap allocated image pixmap.

        """
        return _Media.Media_Frame_InitWrapper(self, *args)

    def IsEmpty(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if frame does not contain any data.

        """
        return _Media.Media_Frame_IsEmpty(self, *args)

    def IsFullRangeYUV(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if yuv range is full.

        """
        return _Media.Media_Frame_IsFullRangeYUV(self, *args)

    def IsLocked(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return locked state.

        """
        return _Media.Media_Frame_IsLocked(self, *args)

    def LineSize(self, *args):
        r"""

        Parameters
        ----------
        thePlaneId: int

        Return
        -------
        int

        Description
        -----------
        Return linesize in bytes for specified data plane.

        """
        return _Media.Media_Frame_LineSize(self, *args)

    def PixelAspectRatio(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return par.

        """
        return _Media.Media_Frame_PixelAspectRatio(self, *args)

    def Plane(self, *args):
        r"""

        Parameters
        ----------
        thePlaneId: int

        Return
        -------
        uint8_t *

        Description
        -----------
        Access data plane for specified id.

        """
        return _Media.Media_Frame_Plane(self, *args)

    def Pts(self, *args):
        r"""
        Return
        -------
        double

        Description
        -----------
        Return presentation timestamp (pts).

        """
        return _Media.Media_Frame_Pts(self, *args)

    def SetLocked(self, *args):
        r"""

        Parameters
        ----------
        theToLock: bool

        Return
        -------
        None

        Description
        -----------
        Lock/free frame for edition.

        """
        return _Media.Media_Frame_SetLocked(self, *args)

    def SetPixelAspectRatio(self, *args):
        r"""

        Parameters
        ----------
        theRatio: float

        Return
        -------
        None

        Description
        -----------
        Set par.

        """
        return _Media.Media_Frame_SetPixelAspectRatio(self, *args)

    def SetPts(self, *args):
        r"""

        Parameters
        ----------
        thePts: double

        Return
        -------
        None

        Description
        -----------
        Set presentation timestamp (pts).

        """
        return _Media.Media_Frame_SetPts(self, *args)

    def Size(self, *args):
        r"""
        Return
        -------
        Graphic3d_Vec2i

        Description
        -----------
        Return image dimensions.

        """
        return _Media.Media_Frame_Size(self, *args)

    def SizeX(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return image width.

        """
        return _Media.Media_Frame_SizeX(self, *args)

    def SizeY(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return image height.

        """
        return _Media.Media_Frame_SizeY(self, *args)

    @staticmethod
    def Swap(*args):
        r"""

        Parameters
        ----------
        theFrame1: Media_Frame
        theFrame2: Media_Frame

        Return
        -------
        None

        Description
        -----------
        Swap avframe* within two frames.

        """
        return _Media.Media_Frame_Swap(*args)

    def Unref(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Av_frame_unref() wrapper.

        """
        return _Media.Media_Frame_Unref(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Media_Frame_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_Frame

# Register Media_Frame in _Media:
_Media.Media_Frame_swigregister(Media_Frame)
class Media_IFrameQueue(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def LockFrame(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Media_Frame>

        Description
        -----------
        Lock the frame, e.g. take ownership on a single (not currently displayed) frame from the queue to perform decoding into.

        """
        return _Media.Media_IFrameQueue_LockFrame(self, *args)

    def ReleaseFrame(self, *args):
        r"""

        Parameters
        ----------
        theFrame: Media_Frame

        Return
        -------
        None

        Description
        -----------
        Release previously locked frame, e.g. it can be displayed on the screen.

        """
        return _Media.Media_IFrameQueue_ReleaseFrame(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_IFrameQueue

# Register Media_IFrameQueue in _Media:
_Media.Media_IFrameQueue_swigregister(Media_IFrameQueue)
class Media_Packet(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _Media.Media_Packet_swiginit(self, _Media.new_Media_Packet(*args))

    def ChangeData(self, *args):
        r"""
        Return
        -------
        uint8_t *

        Description
        -----------
        Return data.

        """
        return _Media.Media_Packet_ChangeData(self, *args)

    def ChangePacket(self, *args):
        r"""
        Return
        -------
        AVPacket *

        Description
        -----------
        Return packet.

        """
        return _Media.Media_Packet_ChangePacket(self, *args)

    def Data(self, *args):
        r"""
        Return
        -------
        uint8_t *

        Description
        -----------
        Return data.

        """
        return _Media.Media_Packet_Data(self, *args)

    def Dts(self, *args):
        r"""
        Return
        -------
        int64_t

        Description
        -----------
        Return decoding timestamp (dts).

        """
        return _Media.Media_Packet_Dts(self, *args)

    def Duration(self, *args):
        r"""
        Return
        -------
        int64_t

        Description
        -----------
        Return duration.

        """
        return _Media.Media_Packet_Duration(self, *args)

    def DurationSeconds(self, *args):
        r"""
        Return
        -------
        double

        Description
        -----------
        Return duration in seconds.

        """
        return _Media.Media_Packet_DurationSeconds(self, *args)

    def IsKeyFrame(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true for a key frame.

        """
        return _Media.Media_Packet_IsKeyFrame(self, *args)

    def Packet(self, *args):
        r"""
        Return
        -------
        AVPacket *

        Description
        -----------
        Return packet.

        """
        return _Media.Media_Packet_Packet(self, *args)

    def Pts(self, *args):
        r"""
        Return
        -------
        int64_t

        Description
        -----------
        Return presentation timestamp (pts).

        """
        return _Media.Media_Packet_Pts(self, *args)

    def SetDurationSeconds(self, *args):
        r"""

        Parameters
        ----------
        theDurationSec: double

        Return
        -------
        None

        Description
        -----------
        Set duration in seconds.

        """
        return _Media.Media_Packet_SetDurationSeconds(self, *args)

    def SetKeyFrame(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Mark as key frame.

        """
        return _Media.Media_Packet_SetKeyFrame(self, *args)

    def Size(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return data size.

        """
        return _Media.Media_Packet_Size(self, *args)

    def StreamIndex(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return stream index.

        """
        return _Media.Media_Packet_StreamIndex(self, *args)

    def Unref(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Av_packet_unref() wrapper.

        """
        return _Media.Media_Packet_Unref(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Media_Packet_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_Packet

# Register Media_Packet in _Media:
_Media.Media_Packet_swigregister(Media_Packet)
class Media_PlayerContext(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theFrameQueue: Media_IFrameQueue *

        Return
        -------
        None

        Description
        -----------
        Main constructor. note that frame queue is stored as pointer, and it is expected that this context is stored as a class field of frame queue.

        """
        _Media.Media_PlayerContext_swiginit(self, _Media.new_Media_PlayerContext(*args))

    @staticmethod
    def DumpFirstFrame(*args):
        r"""

        Parameters
        ----------
        theSrcVideo: str
        theMediaInfo: str

        Return
        -------
        opencascade::handle<Media_Frame>

        Description
        -----------
        Dump first video frame. @param thesrcvideo [in] path to the video @param themediainfo [out] video description.

        Parameters
        ----------
        theSrcVideo: str
        theOutImage: str
        theMediaInfo: str
        theMaxSize: int (optional, default to 0)

        Return
        -------
        bool

        Description
        -----------
        Dump first video frame. @param thesrcvideo [in] path to the video @param theoutimage [in] path to make a screenshot @param themediainfo [out] video description @param themaxsize [in] when positive - downscales image to specified size.

        """
        return _Media.Media_PlayerContext_DumpFirstFrame(*args)

    def Pause(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Pause playback.

        """
        return _Media.Media_PlayerContext_Pause(self, *args)

    def PlayPause(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theIsPaused: bool
        theProgress: float
        theDuration: float

        Description
        -----------
        Pause/pause playback depending on the current state.

        """
        return _Media.Media_PlayerContext_PlayPause(self, *args)

    def PlaybackState(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theIsPaused: bool
        theProgress: float
        theDuration: float

        Description
        -----------
        Return playback state.

        """
        return _Media.Media_PlayerContext_PlaybackState(self, *args)

    def Resume(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Resume playback.

        """
        return _Media.Media_PlayerContext_Resume(self, *args)

    def Seek(self, *args):
        r"""

        Parameters
        ----------
        thePosSec: float

        Return
        -------
        None

        Description
        -----------
        Seek to specified position.

        """
        return _Media.Media_PlayerContext_Seek(self, *args)

    def SetForceRgb(self, *args):
        r"""

        Parameters
        ----------
        theToForce: bool

        Return
        -------
        None

        Description
        -----------
        Set if queue requires rgb pixel format or can handle also yuv pixel format.

        """
        return _Media.Media_PlayerContext_SetForceRgb(self, *args)

    def SetInput(self, *args):
        r"""

        Parameters
        ----------
        theInputPath: str
        theToWait: bool

        Return
        -------
        None

        Description
        -----------
        Set new input for playback.

        """
        return _Media.Media_PlayerContext_SetInput(self, *args)

    def ToForceRgb(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if queue requires rgb pixel format or can handle also yuv pixel format; true by default.

        """
        return _Media.Media_PlayerContext_ToForceRgb(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Media_PlayerContext_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_PlayerContext

# Register Media_PlayerContext in _Media:
_Media.Media_PlayerContext_swigregister(Media_PlayerContext)
class Media_Scaler(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _Media.Media_Scaler_swiginit(self, _Media.new_Media_Scaler(*args))

    def Convert(self, *args):
        r"""

        Parameters
        ----------
        theSrc: Media_Frame
        theRes: Media_Frame

        Return
        -------
        bool

        Description
        -----------
        Convert one frame to another.

        """
        return _Media.Media_Scaler_Convert(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        theSrcDims: Graphic3d_Vec2i
        theSrcFormat: int
        theResDims: Graphic3d_Vec2i
        theResFormat: int

        Return
        -------
        bool

        Description
        -----------
        Sws_getcontext() wrapper - creates conversion context. @param thesrcdims dimensions of input frame @param thesrcformat pixel format (avpixelformat) of input frame @param theresdims dimensions of destination frame @param theresformat pixel format (avpixelformat) of destination frame.

        """
        return _Media.Media_Scaler_Init(self, *args)

    def IsValid(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if context was initialized.

        """
        return _Media.Media_Scaler_IsValid(self, *args)

    def Release(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Sws_freecontext() wrapper.

        """
        return _Media.Media_Scaler_Release(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Media_Scaler_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_Scaler

# Register Media_Scaler in _Media:
_Media.Media_Scaler_swigregister(Media_Scaler)
class Media_Timer(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor.

        """
        _Media.Media_Timer_swiginit(self, _Media.new_Media_Timer(*args))

    def ElapsedTime(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return elapsed time in seconds.

        """
        return _Media.Media_Timer_ElapsedTime(self, *args)

    def IsStarted(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if timer has been started.

        """
        return _Media.Media_Timer_IsStarted(self, *args)

    def Pause(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Pause the timer.

        """
        return _Media.Media_Timer_Pause(self, *args)

    def PlaybackSpeed(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Return playback speed coefficient (1.0 means normal speed).

        """
        return _Media.Media_Timer_PlaybackSpeed(self, *args)

    def Seek(self, *args):
        r"""

        Parameters
        ----------
        theTime: float

        Return
        -------
        None

        Description
        -----------
        Seek the timer to specified position.

        """
        return _Media.Media_Timer_Seek(self, *args)

    def SetPlaybackSpeed(self, *args):
        r"""

        Parameters
        ----------
        theSpeed: float

        Return
        -------
        None

        Description
        -----------
        Setup playback speed coefficient.

        """
        return _Media.Media_Timer_SetPlaybackSpeed(self, *args)

    def Start(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Start the timer.

        """
        return _Media.Media_Timer_Start(self, *args)

    def Stop(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Stop the timer.

        """
        return _Media.Media_Timer_Stop(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Media_Timer_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Media.delete_Media_Timer

# Register Media_Timer in _Media:
_Media.Media_Timer_swigregister(Media_Timer)



@deprecated
def Media_FormatContext_FormatAVErrorDescription(*args):
	return Media_FormatContext.FormatAVErrorDescription(*args)

@deprecated
def Media_FormatContext_FormatTime(*args):
	return Media_FormatContext.FormatTime(*args)

@deprecated
def Media_FormatContext_FormatTimeProgress(*args):
	return Media_FormatContext.FormatTimeProgress(*args)

@deprecated
def Media_FormatContext_FormatUnitsToSeconds(*args):
	return Media_FormatContext.FormatUnitsToSeconds(*args)

@deprecated
def Media_FormatContext_SecondsToUnits(*args):
	return Media_FormatContext.SecondsToUnits(*args)

@deprecated
def Media_FormatContext_SecondsToUnits(*args):
	return Media_FormatContext.SecondsToUnits(*args)

@deprecated
def Media_FormatContext_StreamSecondsToUnits(*args):
	return Media_FormatContext.StreamSecondsToUnits(*args)

@deprecated
def Media_FormatContext_StreamUnitsToSeconds(*args):
	return Media_FormatContext.StreamUnitsToSeconds(*args)

@deprecated
def Media_FormatContext_UnitsToSeconds(*args):
	return Media_FormatContext.UnitsToSeconds(*args)

@deprecated
def Media_Frame_FormatFFmpeg2Occt(*args):
	return Media_Frame.FormatFFmpeg2Occt(*args)

@deprecated
def Media_Frame_FormatOcct2FFmpeg(*args):
	return Media_Frame.FormatOcct2FFmpeg(*args)

@deprecated
def Media_Frame_Swap(*args):
	return Media_Frame.Swap(*args)

@deprecated
def Media_PlayerContext_DumpFirstFrame(*args):
	return Media_PlayerContext.DumpFirstFrame(*args)

@deprecated
def Media_PlayerContext_DumpFirstFrame(*args):
	return Media_PlayerContext.DumpFirstFrame(*args)



