/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory.webservices;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.spi.ObjectFactory;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;
import org.apache.naming.HandlerRef;
import org.apache.naming.ServiceRef;
import org.apache.naming.factory.webservices.ServiceProxy;

public class ServiceRefFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        if (object instanceof ServiceRef) {
            Object object2;
            Object object3;
            Object object4;
            Map map;
            Object object5;
            Object object6;
            Object object7;
            Class<?> clazz;
            ServiceRef serviceRef = (ServiceRef)object;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            ServiceFactory serviceFactory = ServiceFactory.newInstance();
            Service service = null;
            RefAddr refAddr = serviceRef.get("serviceInterface");
            String string = null;
            if (refAddr != null) {
                string = (String)refAddr.getContent();
            }
            refAddr = serviceRef.get("wsdl");
            String string2 = null;
            if (refAddr != null) {
                string2 = (String)refAddr.getContent();
            }
            Hashtable<String, QName> hashtable2 = new Hashtable<String, QName>();
            QName qName = null;
            refAddr = serviceRef.get("service local part");
            if (refAddr != null) {
                clazz = (String)refAddr.getContent();
                refAddr = serviceRef.get("service namespace");
                if (refAddr == null) {
                    qName = new QName((String)((Object)clazz));
                } else {
                    object7 = (String)refAddr.getContent();
                    qName = new QName((String)object7, (String)((Object)clazz));
                }
            }
            clazz = null;
            if (string == null) {
                if (qName == null) {
                    throw new NamingException("Could not create service-ref instance");
                }
                try {
                    if (string2 == null) {
                        service = serviceFactory.createService(qName);
                    }
                    service = serviceFactory.createService(new URI(string2).toURL(), qName);
                }
                catch (Exception exception) {
                    NamingException namingException = new NamingException("Could not create service");
                    namingException.initCause(exception);
                    throw namingException;
                }
            } else {
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NamingException namingException = new NamingException("Could not load service Interface");
                    namingException.initCause(classNotFoundException);
                    throw namingException;
                }
                if (clazz == null) {
                    throw new NamingException("Could not load service Interface");
                }
                try {
                    if (string2 == null) {
                        if (!Service.class.isAssignableFrom(clazz)) {
                            throw new NamingException("service Interface should extend javax.xml.rpc.Service");
                        }
                        service = serviceFactory.loadService((Class)clazz);
                    } else {
                        service = serviceFactory.loadService(new URI(string2).toURL(), clazz, new Properties());
                    }
                }
                catch (Exception exception) {
                    NamingException namingException = new NamingException("Could not create service");
                    namingException.initCause(exception);
                    throw namingException;
                }
            }
            if (service == null) {
                throw new NamingException("Cannot create service object");
            }
            qName = service.getServiceName();
            clazz = service.getClass();
            if (string2 != null) {
                try {
                    object7 = WSDLFactory.newInstance();
                    WSDLReader wSDLReader = object7.newWSDLReader();
                    wSDLReader.setFeature("javax.wsdl.importDocuments", true);
                    object6 = wSDLReader.readWSDL(new URI(string2).toURL().toExternalForm());
                    object5 = object6.getService(qName);
                    map = object5.getPorts();
                    object4 = clazz.getMethod("setEndpointAddress", String.class, String.class);
                    for (String string3 : map.keySet()) {
                        object3 = object5.getPort(string3);
                        object2 = this.getSOAPLocation((Port)object3);
                        ((Method)object4).invoke((Object)service, object3.getName(), object2);
                        hashtable2.put((String)object2, new QName(object3.getName()));
                    }
                }
                catch (Exception exception) {
                    Throwable throwable;
                    if (exception instanceof InvocationTargetException) {
                        throwable = exception.getCause();
                        if (throwable instanceof ThreadDeath) {
                            throw (ThreadDeath)throwable;
                        }
                        if (throwable instanceof VirtualMachineError) {
                            throw (VirtualMachineError)throwable;
                        }
                    }
                    throwable = new NamingException("Error while reading Wsdl File");
                    ((NamingException)throwable).initCause(exception);
                    throw throwable;
                }
            }
            object7 = new ServiceProxy(service);
            for (int i = 0; i < serviceRef.size(); ++i) {
                if (!"serviceendpointinterface".equals(serviceRef.get(i).getType())) continue;
                object6 = "";
                object5 = "";
                object6 = (String)serviceRef.get(i).getContent();
                if ("portcomponentlink".equals(serviceRef.get(i + 1).getType())) {
                    object5 = (String)serviceRef.get(++i).getContent();
                }
                hashtable2.put((String)object6, new QName((String)object5));
            }
            ((ServiceProxy)object7).setPortComponentRef(hashtable2);
            Class<?>[] classArray = clazz.getInterfaces();
            object6 = Arrays.copyOf(classArray, classArray.length + 1);
            object6[((Class<?>[])object6).length - 1] = Service.class;
            object5 = null;
            try {
                object5 = Proxy.newProxyInstance(classLoader, object6, (InvocationHandler)object7);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object5 = Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)object7);
            }
            if (serviceRef.getHandlersSize() > 0) {
                map = service.getHandlerRegistry();
                object4 = new ArrayList();
                while (serviceRef.getHandlersSize() > 0) {
                    String string3;
                    HandlerRef handlerRef = serviceRef.getHandler();
                    string3 = new HandlerInfo();
                    refAddr = handlerRef.get("handlerclass");
                    if (refAddr == null || refAddr.getContent() == null) break;
                    object3 = null;
                    try {
                        object3 = classLoader.loadClass((String)refAddr.getContent());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        break;
                    }
                    object2 = new ArrayList();
                    Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = 0; i < handlerRef.size(); ++i) {
                        String string4;
                        String string5;
                        if ("handlerlocalpart".equals(handlerRef.get(i).getType())) {
                            string5 = "";
                            string4 = "";
                            string5 = (String)handlerRef.get(i).getContent();
                            if ("handlernamespace".equals(handlerRef.get(i + 1).getType())) {
                                string4 = (String)handlerRef.get(++i).getContent();
                            }
                            QName qName2 = new QName(string4, string5);
                            object2.add(qName2);
                            continue;
                        }
                        if ("handlerparamname".equals(handlerRef.get(i).getType())) {
                            string5 = "";
                            string4 = "";
                            string5 = (String)handlerRef.get(i).getContent();
                            if ("handlerparamvalue".equals(handlerRef.get(i + 1).getType())) {
                                string4 = (String)handlerRef.get(++i).getContent();
                            }
                            hashtable3.put(string5, string4);
                            continue;
                        }
                        if ("handlersoaprole".equals(handlerRef.get(i).getType())) {
                            string5 = "";
                            string5 = (String)handlerRef.get(i).getContent();
                            object4.add(string5);
                            continue;
                        }
                        if (!"handlerportname".equals(handlerRef.get(i).getType())) continue;
                        string5 = "";
                        string5 = (String)handlerRef.get(i).getContent();
                        arrayList.add(string5);
                    }
                    string3.setHandlerClass((Class)object3);
                    string3.setHeaders(object2.toArray(new QName[0]));
                    string3.setHandlerConfig(hashtable3);
                    if (!arrayList.isEmpty()) {
                        for (String string5 : arrayList) {
                            this.initHandlerChain(new QName(string5), (HandlerRegistry)map, (HandlerInfo)string3, (List<String>)object4);
                        }
                        continue;
                    }
                    Enumeration<QName> enumeration = hashtable2.elements();
                    while (enumeration.hasMoreElements()) {
                        this.initHandlerChain((QName)enumeration.nextElement(), (HandlerRegistry)map, (HandlerInfo)string3, (List<String>)object4);
                    }
                }
            }
            return object5;
        }
        return null;
    }

    private String getSOAPLocation(Port port) {
        String string = null;
        List list = port.getExtensibilityElements();
        for (ExtensibilityElement extensibilityElement : list) {
            if (!(extensibilityElement instanceof SOAPAddress)) continue;
            SOAPAddress sOAPAddress = (SOAPAddress)extensibilityElement;
            string = sOAPAddress.getLocationURI();
        }
        return string;
    }

    private void initHandlerChain(QName qName, HandlerRegistry handlerRegistry, HandlerInfo handlerInfo, List<String> list) {
        Handler handler2;
        HandlerChain handlerChain = (HandlerChain)handlerRegistry.getHandlerChain(qName);
        for (Handler handler2 : handlerChain) {
            handler2.init(handlerInfo);
        }
        handler2 = handlerChain.getRoles();
        String[] stringArray = new String[((Handler)handler2).length + list.size()];
        for (int i = 0; i < ((Handler)handler2).length; ++i) {
            stringArray[i] = handler2[i];
        }
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i + i] = list.get(i);
        }
        handlerChain.setRoles(stringArray);
        handlerRegistry.setHandlerChain(qName, (List)handlerChain);
    }
}

