"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var NodeKind;
(function (NodeKind) {
    NodeKind[NodeKind["BASIC"] = 0] = "BASIC";
    NodeKind[NodeKind["NODE"] = 1] = "NODE";
    NodeKind[NodeKind["ATTRIBUTE"] = 2] = "ATTRIBUTE";
})(NodeKind = exports.NodeKind || (exports.NodeKind = {}));
var RAMLVersion;
(function (RAMLVersion) {
    RAMLVersion[RAMLVersion["RAML10"] = 0] = "RAML10";
    RAMLVersion[RAMLVersion["RAML08"] = 1] = "RAML08";
})(RAMLVersion = exports.RAMLVersion || (exports.RAMLVersion = {}));
function isParseResult(object) {
    return object.asElement && object.getKind && object.asAttr && object.lowLevel;
}
exports.isParseResult = isParseResult;
var IssueCode;
(function (IssueCode) {
    IssueCode[IssueCode["UNRESOLVED_REFERENCE"] = 0] = "UNRESOLVED_REFERENCE";
    IssueCode[IssueCode["YAML_ERROR"] = 1] = "YAML_ERROR";
    IssueCode[IssueCode["UNKNOWN_NODE"] = 2] = "UNKNOWN_NODE";
    IssueCode[IssueCode["MISSING_REQUIRED_PROPERTY"] = 3] = "MISSING_REQUIRED_PROPERTY";
    IssueCode[IssueCode["PROPERTY_EXPECT_TO_HAVE_SINGLE_VALUE"] = 4] = "PROPERTY_EXPECT_TO_HAVE_SINGLE_VALUE";
    //TODO IMPLEMENT
    IssueCode[IssueCode["KEY_SHOULD_BE_UNIQUE_INTHISCONTEXT"] = 5] = "KEY_SHOULD_BE_UNIQUE_INTHISCONTEXT";
    IssueCode[IssueCode["UNABLE_TO_RESOLVE_INCLUDE_FILE"] = 6] = "UNABLE_TO_RESOLVE_INCLUDE_FILE";
    IssueCode[IssueCode["INVALID_VALUE_SCHEMA"] = 7] = "INVALID_VALUE_SCHEMA";
    IssueCode[IssueCode["MISSED_CONTEXT_REQUIREMENT"] = 8] = "MISSED_CONTEXT_REQUIREMENT";
    IssueCode[IssueCode["NODE_HAS_VALUE"] = 9] = "NODE_HAS_VALUE";
    IssueCode[IssueCode["ONLY_OVERRIDE_ALLOWED"] = 10] = "ONLY_OVERRIDE_ALLOWED";
    IssueCode[IssueCode["ILLEGAL_PROPERTY_VALUE"] = 11] = "ILLEGAL_PROPERTY_VALUE";
    IssueCode[IssueCode["ILLEGAL_PROPERTY"] = 12] = "ILLEGAL_PROPERTY";
    IssueCode[IssueCode["INVALID_PROPERTY"] = 13] = "INVALID_PROPERTY";
})(IssueCode = exports.IssueCode || (exports.IssueCode = {}));
/**
 * Retrieve a list of registered node validation plugins
 */
function getNodeValidationPlugins() {
    var rv = global.ramlValidation;
    if (rv) {
        var nodeValidators = rv.nodeValidators;
        if (Array.isArray(nodeValidators)) {
            return nodeValidators;
        }
    }
    return [];
}
exports.getNodeValidationPlugins = getNodeValidationPlugins;
/**
 * Retrieve a list of registered annotation node validation plugins
 */
function getNodeAnnotationValidationPlugins() {
    var rv = global.ramlValidation;
    if (rv) {
        var astAnnotationValidators = rv.astAnnotationValidators;
        if (Array.isArray(astAnnotationValidators)) {
            return astAnnotationValidators;
        }
    }
    return [];
}
exports.getNodeAnnotationValidationPlugins = getNodeAnnotationValidationPlugins;
//# sourceMappingURL=highLevelAST.js.map