/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.parser;

import com.cronutils.StringValidations;
import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.model.field.expression.And;
import com.cronutils.model.field.expression.Between;
import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.value.FieldValue;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.model.field.value.SpecialCharFieldValue;
import com.cronutils.utils.Preconditions;
import com.cronutils.utils.StringUtils;
import com.cronutils.utils.VisibleForTesting;
import java.util.regex.Pattern;

public class FieldParser {
    private static final String SLASH = "/";
    private static final String W_STRING = "W";
    private static final String EMPTY_STRING = "";
    private static final String LW_STRING = "LW";
    private static final String HASH_TAG = "#";
    private static final String L_STRING = "L";
    private static final String QUESTION_MARK_STRING = "?";
    private static final String ASTERISK = "*";
    private static final char[] SPECIAL_CHARS_MINUS_STAR = new char[]{'/', '-', ','};
    private static final Pattern L_PATTERN = Pattern.compile("[0-9]L", 2);
    private static final Pattern W_PATTERN = Pattern.compile("[0-9]W", 2);
    private static final String ASTERISK_ALWAYS_VALUE = "1";
    private final FieldConstraints fieldConstraints;

    public FieldParser(FieldConstraints constraints) {
        this.fieldConstraints = Preconditions.checkNotNull(constraints, "FieldConstraints must not be null");
    }

    public FieldExpression parse(String expression) {
        if (!StringUtils.containsAny(expression, SPECIAL_CHARS_MINUS_STAR)) {
            if (expression.contains(QUESTION_MARK_STRING) && !this.fieldConstraints.getSpecialChars().contains((Object)SpecialChar.QUESTION_MARK)) {
                throw new IllegalArgumentException("Invalid expression: " + expression);
            }
            return this.noSpecialCharsNorStar(expression);
        }
        String[] array = expression.split(",");
        if (array.length > 1) {
            return this.commaSplitResult(array);
        }
        String[] splitted = expression.split("-");
        if (expression.contains("-") && splitted.length != 2) {
            throw new IllegalArgumentException("Missing values for range: " + expression);
        }
        return splitted[0].equalsIgnoreCase(L_STRING) ? this.parseOnWithL(splitted[0], this.mapToIntegerFieldValue(splitted[1])) : this.dashSplitResult(expression, splitted);
    }

    private FieldExpression dashSplitResult(String expression, String[] betweenArray) {
        if (betweenArray.length > 1) {
            return this.parseBetween(betweenArray);
        }
        return this.slashSplit(expression, expression.split(SLASH));
    }

    private FieldExpression commaSplitResult(String[] array) {
        And and = new And();
        for (String exp : array) {
            and.and(this.parse(exp));
        }
        return and;
    }

    private FieldExpression slashSplit(String expression, String[] values) {
        if (values.length == 2) {
            String start = values[0];
            String value = values[1];
            return this.asteriskOrempty(start, value);
        }
        if (values.length == 1) {
            throw new IllegalArgumentException("Missing steps for expression: " + expression);
        }
        throw new IllegalArgumentException("Invalid expression: " + expression);
    }

    private FieldExpression asteriskOrempty(String start, String value) {
        String trimmedStart = start.trim();
        if (ASTERISK.equals(trimmedStart) && value.equals(ASTERISK_ALWAYS_VALUE)) {
            return this.noSpecialCharsNorStar(start);
        }
        if (ASTERISK.equals(trimmedStart) || EMPTY_STRING.equals(start.trim())) {
            return new Every(new IntegerFieldValue(Integer.parseInt(value)));
        }
        return new Every(new On(this.mapToIntegerFieldValue(start)), new IntegerFieldValue(Integer.parseInt(value)));
    }

    private FieldExpression noSpecialCharsNorStar(String expression) {
        if (ASTERISK.equals(expression)) {
            return FieldExpression.always();
        }
        if (QUESTION_MARK_STRING.equals(expression)) {
            return FieldExpression.questionMark();
        }
        return this.parseOn(expression);
    }

    @VisibleForTesting
    protected FieldExpression parseBetween(String[] array) {
        if (array[0].isEmpty() || array[1].isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid expression! Expression: %s-%s does not describe a range. Negative numbers are not allowed.", array[0], array[1]));
        }
        if (array[1].contains(SLASH)) {
            String[] every = array[1].split(SLASH);
            return new Every(new Between(this.map(array[0]), this.map(every[0])), this.mapToIntegerFieldValue(every[1]));
        }
        return new Between(this.map(array[0]), this.map(array[1]));
    }

    @VisibleForTesting
    protected On parseOn(String exp) {
        if (QUESTION_MARK_STRING.equals(exp)) {
            return this.parseOnWithQuestionMark(exp);
        }
        if (exp.contains(HASH_TAG)) {
            return this.parseOnWithHash(exp);
        }
        if (exp.contains(LW_STRING)) {
            return this.parseOnWithLW(exp);
        }
        if (L_PATTERN.matcher(exp).find() || exp.equalsIgnoreCase(L_STRING)) {
            return this.parseOnWithL(exp);
        }
        if (W_PATTERN.matcher(exp).find()) {
            return this.parseOnWithW(exp);
        }
        return new On(this.mapToIntegerFieldValue(exp), new SpecialCharFieldValue(SpecialChar.NONE), new IntegerFieldValue(-1));
    }

    @VisibleForTesting
    protected On parseOnWithHash(String exp) {
        if (!this.fieldConstraints.getSpecialChars().contains((Object)SpecialChar.HASH)) {
            throw new IllegalArgumentException("Invalid expression: " + exp);
        }
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.HASH);
        String[] array = exp.split(HASH_TAG);
        if (array.length == 0) {
            throw new IllegalArgumentException("Invalid Position of # Character!");
        }
        IntegerFieldValue nth = this.mapToIntegerFieldValue(array[1]);
        if (array[0].isEmpty()) {
            throw new IllegalArgumentException("Time should be specified!");
        }
        return new On(this.mapToIntegerFieldValue(array[0]), specialChar, nth);
    }

    @VisibleForTesting
    protected On parseOnWithQuestionMark(String exp) {
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.QUESTION_MARK);
        String questionMarkExpression = exp.replace(QUESTION_MARK_STRING, EMPTY_STRING);
        if (EMPTY_STRING.equals(questionMarkExpression)) {
            return new On(new IntegerFieldValue(-1), specialChar, new IntegerFieldValue(-1));
        }
        throw new IllegalArgumentException(String.format("Expected: '?', found: %s", questionMarkExpression));
    }

    @VisibleForTesting
    protected On parseOnWithLW(String exp) {
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.LW);
        String lwExpression = exp.replace(LW_STRING, EMPTY_STRING);
        if (EMPTY_STRING.equals(lwExpression)) {
            return new On(new IntegerFieldValue(-1), specialChar, new IntegerFieldValue(-1));
        }
        throw new IllegalArgumentException(String.format("Expected: LW, found: %s", lwExpression));
    }

    @VisibleForTesting
    protected On parseOnWithL(String exp) {
        return this.parseOnWithL(exp, new IntegerFieldValue(-1));
    }

    protected On parseOnWithL(String exp, IntegerFieldValue daysBefore) {
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.L);
        String expression = exp.replace(L_STRING, EMPTY_STRING);
        IntegerFieldValue time = new IntegerFieldValue(-1);
        if (!EMPTY_STRING.equals(expression)) {
            time = this.mapToIntegerFieldValue(expression);
        }
        return new On(time, specialChar, daysBefore);
    }

    @VisibleForTesting
    protected On parseOnWithW(String exp) {
        return new On(this.mapToIntegerFieldValue(exp.replace(W_STRING, EMPTY_STRING)), new SpecialCharFieldValue(SpecialChar.W), new IntegerFieldValue(-1));
    }

    @VisibleForTesting
    protected IntegerFieldValue mapToIntegerFieldValue(String string) {
        try {
            return new IntegerFieldValue(this.intToInt(this.stringToInt(string)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Invalid value. Expected some integer, found %s", string));
        }
    }

    @VisibleForTesting
    protected FieldValue<?> map(String string) {
        for (SpecialChar sc : SpecialChar.values()) {
            if (!sc.toString().equals(string)) continue;
            return new SpecialCharFieldValue(sc);
        }
        return new IntegerFieldValue(this.stringToInt(string));
    }

    @VisibleForTesting
    protected int stringToInt(String exp) {
        Integer value = this.fieldConstraints.getStringMappingValue(exp);
        if (value != null) {
            return value;
        }
        try {
            return Integer.parseInt(exp);
        }
        catch (NumberFormatException e) {
            String invalidChars = new StringValidations(this.fieldConstraints).removeValidChars(exp);
            throw new IllegalArgumentException(String.format("Invalid chars in expression! Expression: %s Invalid chars: %s", exp, invalidChars));
        }
    }

    @VisibleForTesting
    protected int intToInt(Integer exp) {
        Integer value = this.fieldConstraints.getIntMappingValue(exp);
        if (value != null) {
            return value;
        }
        return exp;
    }
}

