/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec;

import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;

public abstract class BasePerFieldKnnVectorsFormat
extends PerFieldKnnVectorsFormat {
    @Generated
    private static final Logger log = LogManager.getLogger(BasePerFieldKnnVectorsFormat.class);
    private final Optional<MapperService> mapperService;
    private final int defaultMaxConnections;
    private final int defaultBeamWidth;
    private final Supplier<KnnVectorsFormat> defaultFormatSupplier;
    private final BiFunction<Integer, Integer, KnnVectorsFormat> formatSupplier;

    public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
        if (!this.isKnnVectorFieldType(field)) {
            log.debug("Initialize KNN vector format for field [{}] with default params [max_connections] = \"{}\" and [beam_width] = \"{}\"", (Object)field, (Object)this.defaultMaxConnections, (Object)this.defaultBeamWidth);
            return this.defaultFormatSupplier.get();
        }
        KNNVectorFieldMapper.KNNVectorFieldType type = (KNNVectorFieldMapper.KNNVectorFieldType)this.mapperService.orElseThrow(() -> new IllegalStateException(String.format("Cannot read field type for field [%s] because mapper service is not available", field))).fieldType(field);
        Map<String, Object> params = type.getKnnMethodContext().getMethodComponentContext().getParameters();
        int maxConnections = this.getMaxConnections(params);
        int beamWidth = this.getBeamWidth(params);
        log.debug("Initialize KNN vector format for field [{}] with params [max_connections] = \"{}\" and [beam_width] = \"{}\"", (Object)field, (Object)maxConnections, (Object)beamWidth);
        return this.formatSupplier.apply(maxConnections, beamWidth);
    }

    public int getMaxDimensions(String fieldName) {
        return this.getKnnVectorsFormatForField(fieldName).getMaxDimensions(fieldName);
    }

    private boolean isKnnVectorFieldType(String field) {
        return this.mapperService.isPresent() && this.mapperService.get().fieldType(field) instanceof KNNVectorFieldMapper.KNNVectorFieldType;
    }

    private int getMaxConnections(Map<String, Object> params) {
        if (params != null && params.containsKey("m")) {
            return (Integer)params.get("m");
        }
        return this.defaultMaxConnections;
    }

    private int getBeamWidth(Map<String, Object> params) {
        if (params != null && params.containsKey("ef_construction")) {
            return (Integer)params.get("ef_construction");
        }
        return this.defaultBeamWidth;
    }

    @Generated
    public BasePerFieldKnnVectorsFormat(Optional<MapperService> mapperService, int defaultMaxConnections, int defaultBeamWidth, Supplier<KnnVectorsFormat> defaultFormatSupplier, BiFunction<Integer, Integer, KnnVectorsFormat> formatSupplier) {
        this.mapperService = mapperService;
        this.defaultMaxConnections = defaultMaxConnections;
        this.defaultBeamWidth = defaultBeamWidth;
        this.defaultFormatSupplier = defaultFormatSupplier;
        this.formatSupplier = formatSupplier;
    }
}

