/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class ToolMetadata
implements ToXContentObject,
Writeable {
    public static final String TOOL_NAME_FIELD = "name";
    public static final String TOOL_DESCRIPTION_FIELD = "description";
    public static final String TOOL_TYPE_FIELD = "type";
    public static final String TOOL_VERSION_FIELD = "version";
    private String name;
    private String description;
    private String type;
    private String version;

    public ToolMetadata(String name, String description, String type, String version) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.version = version;
    }

    public ToolMetadata(StreamInput input) throws IOException {
        this.name = input.readString();
        this.description = input.readString();
        this.type = input.readString();
        this.version = input.readOptionalString();
    }

    public void writeTo(StreamOutput output) throws IOException {
        output.writeString(this.name);
        output.writeString(this.description);
        output.writeString(this.type);
        output.writeOptionalString(this.version);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.name != null) {
            builder.field(TOOL_NAME_FIELD, this.name);
        }
        if (this.description != null) {
            builder.field(TOOL_DESCRIPTION_FIELD, this.description);
        }
        if (this.type != null) {
            builder.field(TOOL_TYPE_FIELD, this.type);
        }
        builder.field(TOOL_VERSION_FIELD, this.version != null ? this.version : "undefined");
        builder.endObject();
        return builder;
    }

    public static ToolMetadata parse(XContentParser parser) throws IOException {
        String name = null;
        String description = null;
        String type = null;
        String version = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "name": {
                    name = parser.text();
                    continue block12;
                }
                case "description": {
                    description = parser.text();
                    continue block12;
                }
                case "type": {
                    type = parser.text();
                    continue block12;
                }
                case "version": {
                    version = parser.text();
                }
            }
            parser.skipChildren();
        }
        return ToolMetadata.builder().name(name).description(description).type(type).version(version).build();
    }

    public static ToolMetadata fromStream(StreamInput in) throws IOException {
        ToolMetadata toolMetadata = new ToolMetadata(in);
        return toolMetadata;
    }

    @Generated
    public static ToolMetadataBuilder builder() {
        return new ToolMetadataBuilder();
    }

    @Generated
    public ToolMetadataBuilder toBuilder() {
        return new ToolMetadataBuilder().name(this.name).description(this.description).type(this.type).version(this.version);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public static class ToolMetadataBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String type;
        @Generated
        private String version;

        @Generated
        ToolMetadataBuilder() {
        }

        @Generated
        public ToolMetadataBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ToolMetadataBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public ToolMetadataBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public ToolMetadataBuilder version(String version) {
            this.version = version;
            return this;
        }

        @Generated
        public ToolMetadata build() {
            return new ToolMetadata(this.name, this.description, this.type, this.version);
        }

        @Generated
        public String toString() {
            return "ToolMetadata.ToolMetadataBuilder(name=" + this.name + ", description=" + this.description + ", type=" + this.type + ", version=" + this.version + ")";
        }
    }
}

