/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.factory;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import lombok.Generated;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.neuralsearch.processor.rerank.MLOpenSearchRerankProcessor;
import org.opensearch.neuralsearch.processor.rerank.RerankType;
import org.opensearch.neuralsearch.processor.rerank.context.ContextSourceFetcher;
import org.opensearch.neuralsearch.processor.rerank.context.DocumentContextSourceFetcher;
import org.opensearch.neuralsearch.processor.rerank.context.QueryContextSourceFetcher;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchResponseProcessor;

public class RerankProcessorFactory
implements Processor.Factory<SearchResponseProcessor> {
    public static final String RERANK_PROCESSOR_TYPE = "rerank";
    public static final String CONTEXT_CONFIG_FIELD = "context";
    private final MLCommonsClientAccessor clientAccessor;
    private final ClusterService clusterService;

    public SearchResponseProcessor create(Map<String, Processor.Factory<SearchResponseProcessor>> processorFactories, String tag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) {
        RerankType type = this.findRerankType(config);
        boolean includeQueryContextFetcher = ContextFetcherFactory.shouldIncludeQueryContextFetcher(type);
        List<ContextSourceFetcher> contextFetchers = ContextFetcherFactory.createFetchers(config, includeQueryContextFetcher, tag, this.clusterService);
        switch (type) {
            case ML_OPENSEARCH: {
                Map rerankerConfig = ConfigurationUtils.readMap((String)RERANK_PROCESSOR_TYPE, (String)tag, config, (String)type.getLabel());
                String modelId = ConfigurationUtils.readStringProperty((String)RERANK_PROCESSOR_TYPE, (String)tag, (Map)rerankerConfig, (String)"model_id");
                return new MLOpenSearchRerankProcessor(description, tag, ignoreFailure, modelId, contextFetchers, this.clientAccessor);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Cannot build reranker type %s", type.getLabel()));
    }

    private RerankType findRerankType(Map<String, Object> config) throws IllegalArgumentException {
        Sets.SetView rerankTypes = Sets.intersection(config.keySet(), RerankType.labelMap().keySet());
        if (rerankTypes.size() == 0) {
            StringJoiner msgBuilder = new StringJoiner(", ", "No rerank type found. Possible rerank types are: [", "]");
            for (RerankType t : RerankType.values()) {
                msgBuilder.add(t.getLabel());
            }
            throw new IllegalArgumentException(msgBuilder.toString());
        }
        if (rerankTypes.size() > 1) {
            StringJoiner msgBuilder = new StringJoiner(", ", "Multiple rerank types found: [", "]. Only one is permitted.");
            rerankTypes.forEach(rt -> msgBuilder.add((CharSequence)rt));
            throw new IllegalArgumentException(msgBuilder.toString());
        }
        return RerankType.from((String)rerankTypes.iterator().next());
    }

    @Generated
    public RerankProcessorFactory(MLCommonsClientAccessor clientAccessor, ClusterService clusterService) {
        this.clientAccessor = clientAccessor;
        this.clusterService = clusterService;
    }

    private static class ContextFetcherFactory {
        private ContextFetcherFactory() {
        }

        public static boolean shouldIncludeQueryContextFetcher(RerankType type) {
            return type == RerankType.ML_OPENSEARCH;
        }

        public static List<ContextSourceFetcher> createFetchers(Map<String, Object> config, boolean includeQueryContextFetcher, String tag, ClusterService clusterService) {
            Map contextConfig = ConfigurationUtils.readMap((String)RerankProcessorFactory.RERANK_PROCESSOR_TYPE, (String)tag, config, (String)RerankProcessorFactory.CONTEXT_CONFIG_FIELD);
            ArrayList<ContextSourceFetcher> fetchers = new ArrayList<ContextSourceFetcher>();
            block6: for (String key : contextConfig.keySet()) {
                Object cfg = contextConfig.get(key);
                switch (key) {
                    case "document_fields": {
                        fetchers.add(DocumentContextSourceFetcher.create(cfg, clusterService));
                        continue block6;
                    }
                }
                throw new IllegalArgumentException(String.format(Locale.ROOT, "unrecognized context field: %s", key));
            }
            if (includeQueryContextFetcher) {
                fetchers.add(new QueryContextSourceFetcher(clusterService));
            }
            return fetchers;
        }
    }
}

