/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util;

import lombok.Generated;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.index.search.NestedHelper;
import org.opensearch.neuralsearch.query.HybridQuery;
import org.opensearch.search.internal.SearchContext;

public class HybridQueryUtil {
    public static boolean isHybridQuery(Query query, SearchContext searchContext) {
        if (query instanceof HybridQuery) {
            return true;
        }
        if (HybridQueryUtil.isWrappedHybridQuery(query) && HybridQueryUtil.hasNestedFieldOrNestedDocs(query, searchContext)) {
            return ((BooleanQuery)query).clauses().stream().filter(clause -> !(clause.getQuery() instanceof HybridQuery)).allMatch(clause -> clause.getOccur() == BooleanClause.Occur.FILTER && clause.getQuery() instanceof FieldExistsQuery && "_primary_term".equals(((FieldExistsQuery)clause.getQuery()).getField()));
        }
        return false;
    }

    private static boolean hasNestedFieldOrNestedDocs(Query query, SearchContext searchContext) {
        return searchContext.mapperService().hasNested() && new NestedHelper(searchContext.mapperService()).mightMatchNestedDocs(query);
    }

    private static boolean isWrappedHybridQuery(Query query) {
        return query instanceof BooleanQuery && ((BooleanQuery)query).clauses().stream().anyMatch(clauseQuery -> clauseQuery.getQuery() instanceof HybridQuery);
    }

    @Generated
    private HybridQueryUtil() {
    }
}

