/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLStorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOWLStorer
implements OWLStorer {
    private static final long serialVersionUID = 40000L;
    protected static final String UTF_8 = "UTF-8";
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractOWLStorer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeOntology(OWLOntology ontology, @Nonnull IRI documentIRI, OWLDocumentFormat ontologyFormat) throws OWLOntologyStorageException {
        if (!documentIRI.isAbsolute()) {
            throw new OWLOntologyStorageException("Document IRI must be absolute: " + documentIRI);
        }
        try (OutputStream os = null;){
            os = AbstractOWLStorer.prepareActualOutput(documentIRI);
            this.store(ontology, ontologyFormat, os);
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    @Nonnull
    private static OutputStream prepareActualOutput(@Nonnull IRI documentIRI) throws IOException {
        OutputStream os;
        if ("file".equals(documentIRI.getScheme())) {
            File file = new File(documentIRI.toURI());
            file.getParentFile().mkdirs();
            os = new FileOutputStream(file);
        } else {
            URL url = documentIRI.toURI().toURL();
            URLConnection conn = url.openConnection();
            os = conn.getOutputStream();
        }
        assert (os != null);
        return os;
    }

    private void store(@Nonnull OWLOntology ontology, @Nonnull OWLDocumentFormat ontologyFormat, @Nonnull OutputStream tempOutputStream) throws OWLOntologyStorageException, IOException {
        BufferedWriter tempWriter = new BufferedWriter(new OutputStreamWriter(tempOutputStream, UTF_8));
        this.storeOntology(ontology, tempWriter, ontologyFormat);
        ((Writer)tempWriter).flush();
        ((Writer)tempWriter).close();
    }

    @Override
    public void storeOntology(OWLOntology ontology, @Nonnull OWLOntologyDocumentTarget target, OWLDocumentFormat format) throws OWLOntologyStorageException {
        block21: {
            if (format.isTextual() && target.isWriterAvailable()) {
                try (Writer w = target.getWriter();){
                    this.storeOntology(ontology, w, format);
                    w.flush();
                    break block21;
                }
                catch (IOException e) {
                    throw new OWLOntologyStorageException(e);
                }
            }
            if (target.isOutputStreamAvailable()) {
                try {
                    this.storeOntology(ontology, target.getOutputStream(), format);
                }
                catch (IOException e) {
                    throw new OWLOntologyStorageException(e);
                }
            } else if (target.isDocumentIRIAvailable()) {
                this.storeOntology(ontology, target.getDocumentIRI(), format);
            } else {
                throw new OWLOntologyStorageException("Neither a Writer, OutputStream or Document IRI could be obtained to store the ontology in this format: " + format.getKey());
            }
        }
    }

    protected abstract void storeOntology(@Nonnull OWLOntology var1, @Nonnull Writer var2, @Nonnull OWLDocumentFormat var3) throws OWLOntologyStorageException;

    protected void storeOntology(@Nonnull OWLOntology ontology, @Nonnull OutputStream outputStream, @Nonnull OWLDocumentFormat format) throws OWLOntologyStorageException {
        if (!format.isTextual()) {
            throw new OWLOntologyStorageException("This method must be overridden to support this binary format: " + format.getKey());
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, UTF_8));
            this.storeOntology(ontology, writer, format);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException(e);
        }
    }
}

