/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.menu;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class PopupMenuId {
    private final String id;

    public PopupMenuId(String id) {
        this.id = (String)Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((boolean)id.startsWith("["), (Object)"PopupMenuIds must start with '['");
        Preconditions.checkArgument((boolean)id.endsWith("]"), (Object)"PopupMenuIds must end with ']'");
    }

    public static boolean isPopupMenuId(String id) {
        return id.startsWith("[") && id.endsWith("]");
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PopupMenuId)) {
            return false;
        }
        PopupMenuId other = (PopupMenuId)obj;
        return this.id.equals(other.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PopupMenuId").addValue((Object)this.id).toString();
    }
}

