/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.lms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.pqc.crypto.lms.Composer;
import org.bouncycastle.pqc.crypto.lms.HSSSignature;
import org.bouncycastle.pqc.crypto.lms.LMS;
import org.bouncycastle.pqc.crypto.lms.LMSContext;
import org.bouncycastle.pqc.crypto.lms.LMSContextBasedVerifier;
import org.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSSignature;
import org.bouncycastle.pqc.crypto.lms.LMSSignedPubKey;
import org.bouncycastle.util.io.Streams;

public class HSSPublicKeyParameters
extends LMSKeyParameters
implements LMSContextBasedVerifier {
    private final int l;
    private final LMSPublicKeyParameters lmsPublicKey;

    public HSSPublicKeyParameters(int l, LMSPublicKeyParameters lmsPublicKey) {
        super(false);
        if (lmsPublicKey == null) {
            throw new NullPointerException("lmsPublicKey");
        }
        this.l = l;
        this.lmsPublicKey = lmsPublicKey;
    }

    public static HSSPublicKeyParameters getInstance(Object src) throws IOException {
        if (src instanceof HSSPublicKeyParameters) {
            return (HSSPublicKeyParameters)src;
        }
        if (src instanceof DataInputStream) {
            int L = ((DataInputStream)src).readInt();
            LMSPublicKeyParameters lmsPublicKey = LMSPublicKeyParameters.getInstance(src);
            return new HSSPublicKeyParameters(L, lmsPublicKey);
        }
        if (src instanceof byte[]) {
            try (InputStream in = null;){
                in = new DataInputStream(new ByteArrayInputStream((byte[])src));
                HSSPublicKeyParameters hSSPublicKeyParameters = HSSPublicKeyParameters.getInstance(in);
                return hSSPublicKeyParameters;
            }
        }
        if (src instanceof InputStream) {
            return HSSPublicKeyParameters.getInstance(Streams.readAll((InputStream)src));
        }
        throw new IllegalArgumentException("cannot parse " + src);
    }

    public int getL() {
        return this.l;
    }

    public LMSPublicKeyParameters getLMSPublicKey() {
        return this.lmsPublicKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HSSPublicKeyParameters publicKey = (HSSPublicKeyParameters)o;
        if (this.l != publicKey.l) {
            return false;
        }
        return this.lmsPublicKey.equals(publicKey.lmsPublicKey);
    }

    public int hashCode() {
        int result = this.l;
        result = 31 * result + this.lmsPublicKey.hashCode();
        return result;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return Composer.compose().u32str(this.l).bytes(this.lmsPublicKey.getEncoded()).build();
    }

    @Override
    public LMSContext generateLMSContext(byte[] sigEnc) {
        HSSSignature signature;
        try {
            signature = HSSSignature.getInstance(sigEnc, this.getL());
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot parse signature: " + e.getMessage());
        }
        LMSSignedPubKey[] signedPubKeys = signature.getSignedPubKey();
        LMSPublicKeyParameters key = signedPubKeys.length != 0 ? signedPubKeys[signedPubKeys.length - 1].getPublicKey() : this.getLMSPublicKey();
        return key.generateOtsContext(signature.getSignature()).withSignedPublicKeys(signedPubKeys);
    }

    @Override
    public boolean verify(LMSContext context) {
        boolean failed = false;
        LMSSignedPubKey[] sigKeys = context.getSignedPubKeys();
        if (sigKeys.length != this.getL() - 1) {
            return false;
        }
        LMSPublicKeyParameters key = this.getLMSPublicKey();
        for (int i = 0; i < sigKeys.length; ++i) {
            byte[] msg;
            LMSSignature sig = sigKeys[i].getSignature();
            if (!LMS.verifySignature(key, sig, msg = sigKeys[i].getPublicKey().toByteArray())) {
                failed = true;
            }
            key = sigKeys[i].getPublicKey();
        }
        return !failed & key.verify(context);
    }
}

