(window["notificationsDashboards_bundle_jsonpfunction"]=window["notificationsDashboards_bundle_jsonpfunction"]||[]).push([[3],{248:function(module,exports,__webpack_require__){"use strict";const strictUriEncode=__webpack_require__(265);const decodeComponent=__webpack_require__(266);const splitOnFirst=__webpack_require__(267);const filterObject=__webpack_require__(268);const isNullOrUndefined=value=>value===null||value===undefined;function encoderForArrayFormat(options){switch(options.arrayFormat){case"index":return key=>(result,value)=>{const index=result.length;if(value===undefined||options.skipNull&&value===null||options.skipEmptyString&&value===""){return result}if(value===null){return[...result,[encode(key,options),"[",index,"]"].join("")]}return[...result,[encode(key,options),"[",encode(index,options),"]=",encode(value,options)].join("")]};case"bracket":return key=>(result,value)=>{if(value===undefined||options.skipNull&&value===null||options.skipEmptyString&&value===""){return result}if(value===null){return[...result,[encode(key,options),"[]"].join("")]}return[...result,[encode(key,options),"[]=",encode(value,options)].join("")]};case"comma":case"separator":return key=>(result,value)=>{if(value===null||value===undefined||value.length===0){return result}if(result.length===0){return[[encode(key,options),"=",encode(value,options)].join("")]}return[[result,encode(value,options)].join(options.arrayFormatSeparator)]};default:return key=>(result,value)=>{if(value===undefined||options.skipNull&&value===null||options.skipEmptyString&&value===""){return result}if(value===null){return[...result,encode(key,options)]}return[...result,[encode(key,options),"=",encode(value,options)].join("")]}}}function parserForArrayFormat(options){let result;switch(options.arrayFormat){case"index":return(key,value,accumulator)=>{result=/\[(\d*)\]$/.exec(key);key=key.replace(/\[\d*\]$/,"");if(!result){accumulator[key]=value;return}if(accumulator[key]===undefined){accumulator[key]={}}accumulator[key][result[1]]=value};case"bracket":return(key,value,accumulator)=>{result=/(\[\])$/.exec(key);key=key.replace(/\[\]$/,"");if(!result){accumulator[key]=value;return}if(accumulator[key]===undefined){accumulator[key]=[value];return}accumulator[key]=[].concat(accumulator[key],value)};case"comma":case"separator":return(key,value,accumulator)=>{const isArray=typeof value==="string"&&value.includes(options.arrayFormatSeparator);const isEncodedArray=typeof value==="string"&&!isArray&&decode(value,options).includes(options.arrayFormatSeparator);value=isEncodedArray?decode(value,options):value;const newValue=isArray||isEncodedArray?value.split(options.arrayFormatSeparator).map(item=>decode(item,options)):value===null?value:decode(value,options);accumulator[key]=newValue};default:return(key,value,accumulator)=>{if(accumulator[key]===undefined){accumulator[key]=value;return}accumulator[key]=[].concat(accumulator[key],value)}}}function validateArrayFormatSeparator(value){if(typeof value!=="string"||value.length!==1){throw new TypeError("arrayFormatSeparator must be single character string")}}function encode(value,options){if(options.encode){return options.strict?strictUriEncode(value):encodeURIComponent(value)}return value}function decode(value,options){if(options.decode){return decodeComponent(value)}return value}function keysSorter(input){if(Array.isArray(input)){return input.sort()}if(typeof input==="object"){return keysSorter(Object.keys(input)).sort((a,b)=>Number(a)-Number(b)).map(key=>input[key])}return input}function removeHash(input){const hashStart=input.indexOf("#");if(hashStart!==-1){input=input.slice(0,hashStart)}return input}function getHash(url){let hash="";const hashStart=url.indexOf("#");if(hashStart!==-1){hash=url.slice(hashStart)}return hash}function extract(input){input=removeHash(input);const queryStart=input.indexOf("?");if(queryStart===-1){return""}return input.slice(queryStart+1)}function parseValue(value,options){if(options.parseNumbers&&!Number.isNaN(Number(value))&&(typeof value==="string"&&value.trim()!=="")){value=Number(value)}else if(options.parseBooleans&&value!==null&&(value.toLowerCase()==="true"||value.toLowerCase()==="false")){value=value.toLowerCase()==="true"}return value}function parse(query,options){options=Object.assign({decode:true,sort:true,arrayFormat:"none",arrayFormatSeparator:",",parseNumbers:false,parseBooleans:false},options);validateArrayFormatSeparator(options.arrayFormatSeparator);const formatter=parserForArrayFormat(options);const ret=Object.create(null);if(typeof query!=="string"){return ret}query=query.trim().replace(/^[?#&]/,"");if(!query){return ret}for(const param of query.split("&")){if(param===""){continue}let[key,value]=splitOnFirst(options.decode?param.replace(/\+/g," "):param,"=");value=value===undefined?null:["comma","separator"].includes(options.arrayFormat)?value:decode(value,options);formatter(decode(key,options),value,ret)}for(const key of Object.keys(ret)){const value=ret[key];if(typeof value==="object"&&value!==null){for(const k of Object.keys(value)){value[k]=parseValue(value[k],options)}}else{ret[key]=parseValue(value,options)}}if(options.sort===false){return ret}return(options.sort===true?Object.keys(ret).sort():Object.keys(ret).sort(options.sort)).reduce((result,key)=>{const value=ret[key];if(Boolean(value)&&typeof value==="object"&&!Array.isArray(value)){result[key]=keysSorter(value)}else{result[key]=value}return result},Object.create(null))}exports.extract=extract;exports.parse=parse;exports.stringify=(object,options)=>{if(!object){return""}options=Object.assign({encode:true,strict:true,arrayFormat:"none",arrayFormatSeparator:","},options);validateArrayFormatSeparator(options.arrayFormatSeparator);const shouldFilter=key=>options.skipNull&&isNullOrUndefined(object[key])||options.skipEmptyString&&object[key]==="";const formatter=encoderForArrayFormat(options);const objectCopy={};for(const key of Object.keys(object)){if(!shouldFilter(key)){objectCopy[key]=object[key]}}const keys=Object.keys(objectCopy);if(options.sort!==false){keys.sort(options.sort)}return keys.map(key=>{const value=object[key];if(value===undefined){return""}if(value===null){return encode(key,options)}if(Array.isArray(value)){return value.reduce(formatter(key),[]).join("&")}return encode(key,options)+"="+encode(value,options)}).filter(x=>x.length>0).join("&")};exports.parseUrl=(url,options)=>{options=Object.assign({decode:true},options);const[url_,hash]=splitOnFirst(url,"#");return Object.assign({url:url_.split("?")[0]||"",query:parse(extract(url),options)},options&&options.parseFragmentIdentifier&&hash?{fragmentIdentifier:decode(hash,options)}:{})};exports.stringifyUrl=(object,options)=>{options=Object.assign({encode:true,strict:true},options);const url=removeHash(object.url).split("?")[0]||"";const queryFromUrl=exports.extract(object.url);const parsedQueryFromUrl=exports.parse(queryFromUrl,{sort:false});const query=Object.assign(parsedQueryFromUrl,object.query);let queryString=exports.stringify(query,options);if(queryString){queryString=`?${queryString}`}let hash=getHash(object.url);if(object.fragmentIdentifier){hash=`#${encode(object.fragmentIdentifier,options)}`}return`${url}${queryString}${hash}`};exports.pick=(input,filter,options)=>{options=Object.assign({parseFragmentIdentifier:true},options);const{url:url,query:query,fragmentIdentifier:fragmentIdentifier}=exports.parseUrl(input,options);return exports.stringifyUrl({url:url,query:filterObject(query,filter),fragmentIdentifier:fragmentIdentifier},options)};exports.exclude=(input,filter,options)=>{const exclusionFilter=Array.isArray(filter)?key=>!filter.includes(key):(key,value)=>!filter(key,value);return exports.pick(input,exclusionFilter,options)}},265:function(module,exports,__webpack_require__){"use strict";module.exports=str=>encodeURIComponent(str).replace(/[!'()*]/g,x=>`%${x.charCodeAt(0).toString(16).toUpperCase()}`)},266:function(module,exports,__webpack_require__){"use strict";var token="%[a-f0-9]{2}";var singleMatcher=new RegExp("("+token+")|([^%]+?)","gi");var multiMatcher=new RegExp("("+token+")+","gi");function decodeComponents(components,split){try{return[decodeURIComponent(components.join(""))]}catch(err){}if(components.length===1){return components}split=split||1;var left=components.slice(0,split);var right=components.slice(split);return Array.prototype.concat.call([],decodeComponents(left),decodeComponents(right))}function decode(input){try{return decodeURIComponent(input)}catch(err){var tokens=input.match(singleMatcher)||[];for(var i=1;i<tokens.length;i++){input=decodeComponents(tokens,i).join("");tokens=input.match(singleMatcher)||[]}return input}}function customDecodeURIComponent(input){var replaceMap={"%FE%FF":"��","%FF%FE":"��"};var match=multiMatcher.exec(input);while(match){try{replaceMap[match[0]]=decodeURIComponent(match[0])}catch(err){var result=decode(match[0]);if(result!==match[0]){replaceMap[match[0]]=result}}match=multiMatcher.exec(input)}replaceMap["%C2"]="�";var entries=Object.keys(replaceMap);for(var i=0;i<entries.length;i++){var key=entries[i];input=input.replace(new RegExp(key,"g"),replaceMap[key])}return input}module.exports=function(encodedURI){if(typeof encodedURI!=="string"){throw new TypeError("Expected `encodedURI` to be of type `string`, got `"+typeof encodedURI+"`")}try{encodedURI=encodedURI.replace(/\+/g," ");return decodeURIComponent(encodedURI)}catch(err){return customDecodeURIComponent(encodedURI)}}},267:function(module,exports,__webpack_require__){"use strict";module.exports=(string,separator)=>{if(!(typeof string==="string"&&typeof separator==="string")){throw new TypeError("Expected the arguments to be of type `string`")}if(separator===""){return[string]}const separatorIndex=string.indexOf(separator);if(separatorIndex===-1){return[string]}return[string.slice(0,separatorIndex),string.slice(separatorIndex+separator.length)]}},268:function(module,exports,__webpack_require__){"use strict";module.exports=function(obj,predicate){var ret={};var keys=Object.keys(obj);var isArr=Array.isArray(predicate);for(var i=0;i<keys.length;i++){var key=keys[i];var val=obj[key];if(isArr?predicate.indexOf(key)!==-1:predicate(key,val,obj)){ret[key]=val}}return ret}},391:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"renderApp",(function(){return renderApp}));var external_osdSharedDeps_React_=__webpack_require__(0);var external_osdSharedDeps_React_default=__webpack_require__.n(external_osdSharedDeps_React_);var external_osdSharedDeps_ReactDom_=__webpack_require__(9);var external_osdSharedDeps_ReactDom_default=__webpack_require__.n(external_osdSharedDeps_ReactDom_);var external_osdSharedDeps_ReactRouterDom_=__webpack_require__(20);const CoreServicesContext=Object(external_osdSharedDeps_React_["createContext"])(null);const CoreServicesConsumer=CoreServicesContext.Consumer;var external_osdSharedDeps_ElasticEui_=__webpack_require__(2);function _defineProperty(obj,key,value){key=_toPropertyKey(key);if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function _toPropertyKey(arg){var key=_toPrimitive(arg,"string");return typeof key==="symbol"?key:String(key)}function _toPrimitive(input,hint){if(typeof input!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(typeof res!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.")}return(hint==="string"?String:Number)(input)}const ModalContext=Object(external_osdSharedDeps_React_["createContext"])({component:null,props:{},onShow:(component,props)=>{},onClose:()=>{}});const ModalConsumer=ModalContext.Consumer;class Modal_ModalProvider extends external_osdSharedDeps_React_["Component"]{constructor(){super(...arguments);_defineProperty(this,"state",{component:null,props:{}});_defineProperty(this,"onShow",(component,props)=>{this.setState({component:component,props:props})});_defineProperty(this,"onClose",()=>{this.setState({component:null,props:{}})})}render(){return external_osdSharedDeps_React_default.a.createElement(ModalContext.Provider,{value:{...this.state,onShow:this.onShow,onClose:this.onClose}},this.props.children)}}function _extends(){_extends=Object.assign?Object.assign.bind():function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const ModalRoot=_ref=>{let{services:services}=_ref;return external_osdSharedDeps_React_default.a.createElement(ModalConsumer,null,_ref2=>{let{component:Komponent,props:props,onClose:onClose}=_ref2;return Komponent?external_osdSharedDeps_React_default.a.createElement(Komponent,_extends({},props,{onClose:onClose,services:services})):null})};var Modal_ModalRoot=ModalRoot;const ServicesContext=Object(external_osdSharedDeps_React_["createContext"])(null);const ServicesConsumer=ServicesContext.Consumer;const DOCUMENTATION_LINK="";const ALERTING_DOCUMENTATION_LINK="https://opensearch.org/docs/monitoring-plugins/alerting/monitors/#authenticate-sender-account";const ROUTES=Object.freeze({NOTIFICATIONS:"/notifications",CHANNELS:"/channels",CHANNEL_DETAILS:"/channel-details",CREATE_CHANNEL:"/create-channel",EDIT_CHANNEL:"/edit-channel",EMAIL_SENDERS:"/email-senders",EMAIL_GROUPS:"/email-recipient-groups",CREATE_SENDER:"/create-smtp-sender",EDIT_SENDER:"/edit-smtp-sender",CREATE_SES_SENDER:"/create-ses-sender",EDIT_SES_SENDER:"/edit-ses-sender",CREATE_RECIPIENT_GROUP:"/create-recipient-group",EDIT_RECIPIENT_GROUP:"/edit-recipient-group"});const BREADCRUMBS=Object.freeze({NOTIFICATIONS:{text:"Notifications",href:"#/"},CHANNELS:{text:"Channels",href:"#".concat(ROUTES.CHANNELS)},CHANNEL_DETAILS:{text:"Channels",href:"#".concat(ROUTES.CHANNEL_DETAILS)},CREATE_CHANNEL:{text:"Create channel",href:"#".concat(ROUTES.CREATE_CHANNEL)},EDIT_CHANNEL:{text:"Edit channel"},EMAIL_SENDERS:{text:"Email senders",href:"#".concat(ROUTES.EMAIL_SENDERS)},EMAIL_GROUPS:{text:"Email recipient groups",href:"#".concat(ROUTES.EMAIL_GROUPS)},CREATE_SENDER:{text:"Create SMTP sender",href:"#".concat(ROUTES.CREATE_SENDER)},EDIT_SENDER:{text:"Edit SMTP sender"},CREATE_SES_SENDER:{text:"Create SES sender",href:"#".concat(ROUTES.CREATE_SENDER)},EDIT_SES_SENDER:{text:"Edit SES sender"},CREATE_RECIPIENT_GROUP:{text:"Create recipient group",href:"#".concat(ROUTES.CREATE_RECIPIENT_GROUP)},EDIT_RECIPIENT_GROUP:{text:"Edit recipient group"}});const ENCRYPTION_TYPE=Object.freeze({ssl:"SSL/TLS",start_tls:"STARTTLS",none:"None"});const SEVERITY_TYPE=Object.freeze({none:"None",info:"Info",high:"High",critical:"Critical"});const CUSTOM_WEBHOOK_ENDPOINT_TYPE=Object.freeze({WEBHOOK_URL:"Webhook URL",CUSTOM_URL:"Custom attributes URL"});const BACKEND_CHANNEL_TYPE=Object.freeze({SLACK:"slack",EMAIL:"email",CHIME:"chime",MICROSOFT_TEAMS:"microsoft_teams",CUSTOM_WEBHOOK:"webhook",SNS:"sns"});const CHANNEL_TYPE=Object.freeze({[BACKEND_CHANNEL_TYPE.SLACK]:"Slack",[BACKEND_CHANNEL_TYPE.EMAIL]:"Email",[BACKEND_CHANNEL_TYPE.CHIME]:"Chime",[BACKEND_CHANNEL_TYPE.MICROSOFT_TEAMS]:"Microsoft Teams",[BACKEND_CHANNEL_TYPE.CUSTOM_WEBHOOK]:"Custom webhook",[BACKEND_CHANNEL_TYPE.SNS]:"Amazon SNS"});var external_osdSharedDeps_Lodash_=__webpack_require__(7);var external_osdSharedDeps_Lodash_default=__webpack_require__.n(external_osdSharedDeps_Lodash_);const ContentPanel=_ref=>{let{title:title="",titleSize:titleSize="l",total:total=undefined,bodyStyles:bodyStyles={},panelStyles:panelStyles={},horizontalRuleClassName:horizontalRuleClassName="",actions:actions,children:children}=_ref;return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiPanel"],{style:{...panelStyles}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{style:{padding:"0px 0px"},justifyContent:"spaceBetween",alignItems:"center"},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiTitle"],{size:titleSize},external_osdSharedDeps_React_default.a.createElement("h3",null,title,total!==undefined?external_osdSharedDeps_React_default.a.createElement("span",{style:{color:"#9f9f9f",fontWeight:300}}," (".concat(total,")")):null))),actions?external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},Array.isArray(actions)?actions.map((action,idx)=>external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{key:idx},action)):external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],null,actions))):null),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiHorizontalRule"],{margin:"s",className:horizontalRuleClassName}),external_osdSharedDeps_React_default.a.createElement("div",{style:{padding:"0px 10px",...bodyStyles}},children))};var ContentPanel_ContentPanel=ContentPanel;function ContentPanelActions_extends(){ContentPanelActions_extends=Object.assign?Object.assign.bind():function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return ContentPanelActions_extends.apply(this,arguments)}const ContentPanelActions=_ref=>{let{actions:actions}=_ref;return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},actions.map((_ref2,index)=>{let{component:component,flexItemProps:flexItemProps={}}=_ref2;return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],ContentPanelActions_extends({},flexItemProps,{grow:false,key:index}),component)}))};var ContentPanel_ContentPanelActions=ContentPanelActions;var external_osdSharedDeps_Moment_=__webpack_require__(225);var external_osdSharedDeps_Moment_default=__webpack_require__.n(external_osdSharedDeps_Moment_);var external_osdSharedDeps_MomentTimezone_=__webpack_require__(18);function getErrorMessage(err,defaultMessage){if(defaultMessage)return defaultMessage;if(err&&err.message)console.error(defaultMessage,err);return""}const renderTime=time=>{const momentTime=external_osdSharedDeps_Moment_default()(time).local();const timezone=external_osdSharedDeps_Moment_default.a.tz(external_osdSharedDeps_Moment_default.a.tz.guess()).zoneAbbr();if(time&&momentTime.isValid())return"".concat(momentTime.format("MM/DD/YY h:mm a")," ").concat(timezone);return"-"};const DEFAULT_PAGE_SIZE_OPTIONS=[5,10,20,50];var common=__webpack_require__(29);const configToChannel=config=>({...config.config,config_id:config.config_id,created_time_ms:config.created_time_ms,last_updated_time_ms:config.last_updated_time_ms});const configListToChannels=configs=>(configs===null||configs===void 0?void 0:configs.map(config=>configToChannel(config)))||[];const configToSender=config=>({name:config.config.name,description:config.config.description,config_id:config.config_id,created_time_ms:config.created_time_ms,last_updated_time_ms:config.last_updated_time_ms,smtp_account:config.config.smtp_account});const configListToSenders=configs=>(configs===null||configs===void 0?void 0:configs.map(config=>configToSender(config)))||[];const configToSESSender=config=>({name:config.config.name,description:config.config.description,config_id:config.config_id,created_time_ms:config.created_time_ms,last_updated_time_ms:config.last_updated_time_ms,ses_account:config.config.ses_account});const configListToSESSenders=configs=>(configs===null||configs===void 0?void 0:configs.map(config=>configToSESSender(config)))||[];const configToRecipientGroup=config=>({name:config.config.name,description:config.config.description,config_id:config.config_id,created_time_ms:config.created_time_ms,last_updated_time_ms:config.last_updated_time_ms,email_group:config.config.email_group});const configListToRecipientGroups=configs=>(configs===null||configs===void 0?void 0:configs.map(config=>configToRecipientGroup(config)))||[];const isStatusCodeSuccess=statusCode=>{if(!statusCode)return true;return statusCode!=="207"&&/^2\d\d/.test(statusCode)};const eventToNotification=event=>{const success=event.event.status_list.every(status=>isStatusCodeSuccess(status.delivery_status.status_code));return{status_list:event.event.status_list,event_id:event.event_id,created_time_ms:event.created_time_ms,last_updated_time_ms:event.last_updated_time_ms,success:success}};function NotificationService_defineProperty(obj,key,value){key=NotificationService_toPropertyKey(key);if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function NotificationService_toPropertyKey(arg){var key=NotificationService_toPrimitive(arg,"string");return typeof key==="symbol"?key:String(key)}function NotificationService_toPrimitive(input,hint){if(typeof input!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(typeof res!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.")}return(hint==="string"?String:Number)(input)}class NotificationService_NotificationService{constructor(httpClient,dataSourceId,multiDataSourceEnabled){NotificationService_defineProperty(this,"httpClient",void 0);NotificationService_defineProperty(this,"dataSourceId",void 0);NotificationService_defineProperty(this,"multiDataSourceEnabled",void 0);NotificationService_defineProperty(this,"createConfig",async config=>{let queryObj;if(this.multiDataSourceEnabled){queryObj={body:JSON.stringify({config:config}),query:{dataSourceId:this.dataSourceId}}}else{queryObj={body:JSON.stringify({config:config})}}const response=await this.httpClient.post(common["a"].CREATE_CONFIG,queryObj);return response});NotificationService_defineProperty(this,"updateConfig",async(id,config)=>{let queryObj;if(this.multiDataSourceEnabled){queryObj={body:JSON.stringify({config:config}),query:{dataSourceId:this.dataSourceId}}}else{queryObj={body:JSON.stringify({config:config})}}const response=await this.httpClient.put("".concat(common["a"].UPDATE_CONFIG,"/").concat(id),queryObj);return response});NotificationService_defineProperty(this,"deleteConfigs",async ids=>{let queryObject={config_id_list:ids};if(this.multiDataSourceEnabled){queryObject={...queryObject,dataSourceId:this.dataSourceId}}const response=await this.httpClient.delete(common["a"].DELETE_CONFIGS,{query:queryObject});return response});NotificationService_defineProperty(this,"getConfigs",async queryObject=>{if(this.multiDataSourceEnabled){queryObject={...queryObject,dataSourceId:this.dataSourceId}}return this.httpClient.get(common["a"].GET_CONFIGS,{query:queryObject})});NotificationService_defineProperty(this,"getConfig",async id=>{if(this.multiDataSourceEnabled){return this.httpClient.get("".concat(common["a"].GET_CONFIG,"/").concat(id),{query:{dataSourceId:this.dataSourceId}})}else{return this.httpClient.get("".concat(common["a"].GET_CONFIG,"/").concat(id))}});NotificationService_defineProperty(this,"getChannels",async queryObject=>{const response=await this.getConfigs(queryObject);return{items:configListToChannels(response.config_list),total:response.total_hits||0}});NotificationService_defineProperty(this,"getChannel",async id=>{const response=await this.getConfig(id);return configToChannel(response.config_list[0])});NotificationService_defineProperty(this,"getEmailConfigDetails",async channel=>{if(!channel.email)return channel;const idMap={};const ids=[channel.email.email_account_id,...channel.email.email_group_id_list];let senderType;const invalidIds=[];try{await this.getConfigs({from_index:0,max_items:ids.length,config_id_list:ids,sort_order:external_osdSharedDeps_ElasticEui_["SortDirection"].ASC,sort_field:"name",config_type:["smtp_account","ses_account","email_group"]}).then(response=>{response.config_list.map(config=>{var _channel$email;if(config.config_id===((_channel$email=channel.email)===null||_channel$email===void 0?void 0:_channel$email.email_account_id))senderType=config.config.config_type;idMap[config.config_id]=config.config.name})}).catch(async error=>{console.error("error fetching email senders and recipients, retrying",error);await Promise.all(ids.map(config_id=>this.getConfig(config_id).then(response=>{var _channel$email2;const config=response.config_list[0];if(config.config_id===((_channel$email2=channel.email)===null||_channel$email2===void 0?void 0:_channel$email2.email_account_id))senderType=config.config.config_type;idMap[config_id]=config.config.name}).catch(error=>{invalidIds.push(config_id);console.error("error fetching config id ".concat(config_id,":"),error);idMap[config_id]="(invalid-id)"})))});channel.email.sender_type=senderType||"smtp_account";channel.email.email_account_name=idMap[channel.email.email_account_id];channel.email.email_group_id_map={};channel.email.email_group_id_list.map(id=>channel.email.email_group_id_map[id]=idMap[id]);channel.email.invalid_ids=invalidIds}catch(error){console.error("error fetching email senders and recipients",error)}return channel});NotificationService_defineProperty(this,"getSenders",async queryObject=>{const response=await this.getConfigs(queryObject);return{items:configListToSenders(response.config_list),total:response.total_hits||0}});NotificationService_defineProperty(this,"getSender",async id=>{const response=await this.getConfig(id);return configToSender(response.config_list[0])});NotificationService_defineProperty(this,"getSESSenders",async queryObject=>{const response=await this.getConfigs(queryObject);return{items:configListToSESSenders(response.config_list),total:response.total_hits||0}});NotificationService_defineProperty(this,"getSESSender",async id=>{const response=await this.getConfig(id);return configToSESSender(response.config_list[0])});NotificationService_defineProperty(this,"getRecipientGroups",async queryObject=>{const response=await this.getConfigs(queryObject);return{items:configListToRecipientGroups(response.config_list),total:response.total_hits||0}});NotificationService_defineProperty(this,"getRecipientGroup",async id=>{const response=await this.getConfig(id);return configToRecipientGroup(response.config_list[0])});NotificationService_defineProperty(this,"getServerFeatures",async()=>{try{const query=this.multiDataSourceEnabled?{dataSourceId:this.dataSourceId}:undefined;const response=await this.httpClient.get(common["a"].GET_AVAILABLE_FEATURES,{query:query});return response}catch(error){console.error("error fetching available features",error);return null}});NotificationService_defineProperty(this,"getNotification",async id=>{let response;if(this.multiDataSourceEnabled){response=await this.httpClient.get("".concat(common["a"].GET_EVENT,"/").concat(id),{query:{dataSourceId:this.dataSourceId}})}else{response=await this.httpClient.get("".concat(common["a"].GET_EVENT,"/").concat(id))}return eventToNotification(response.event_list[0])});NotificationService_defineProperty(this,"sendTestMessage",async configId=>{let response;if(this.multiDataSourceEnabled){response=await this.httpClient.post("".concat(common["a"].SEND_TEST_MESSAGE,"/").concat(configId),{query:{dataSourceId:this.dataSourceId}})}else{response=await this.httpClient.post("".concat(common["a"].SEND_TEST_MESSAGE,"/").concat(configId))}if(response.status_list[0].delivery_status.status_code!=200){console.error(response);const error=new Error("Failed to send the test message.");error.stack=JSON.stringify(response,null,2);throw error}return response});this.httpClient=httpClient;this.dataSourceId=dataSourceId;this.multiDataSourceEnabled=multiDataSourceEnabled}}const DeleteChannelModal=props=>{if(!props.selected.length)return null;const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);const[input,setInput]=Object(external_osdSharedDeps_React_["useState"])("");const num=props.selected.length;const name=num>=2?"".concat(num," channels"):props.selected[0].name;const message="Delete ".concat(num>=2?"the following channels":name," permanently? Any notify actions will no longer be able to send notifications using ").concat(num>=2?"these channels":"this channel",".");return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiOverlayMask"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModal"],{onClose:props.onClose,maxWidth:500},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeader"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,"Delete ".concat(name,"?"))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalBody"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],null,message),num>=2&&external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),props.selected.map((channel,i)=>external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],{key:"channel-list-item-".concat(i),style:{marginLeft:20}},external_osdSharedDeps_React_default.a.createElement("li",null,channel.name)))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],null,"To confirm delete, type ",external_osdSharedDeps_React_default.a.createElement("i",null,"delete")," in the field."),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:"delete",value:input,onChange:e=>setInput(e.target.value)})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalFooter"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd"},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:props.onClose},"Cancel")),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{fill:true,"data-test-subj":"delete-channel-modal-delete-button",color:"danger",onClick:async()=>{props.services.notificationService.deleteConfigs(props.selected.map(channel=>channel.config_id)).then(resp=>{coreContext.notifications.toasts.addSuccess("".concat(props.selected.length>1?props.selected.length+" channels":"Channel "+props.selected[0].name," successfully deleted."));props.onClose();if(props.href)setTimeout(()=>location.hash=props.href,common["c"]);else if(props.refresh)setTimeout(()=>props.refresh(),common["c"])}).catch(error=>{coreContext.notifications.toasts.addError((error===null||error===void 0?void 0:error.body)||error,{title:"Failed to delete one or more channels."});props.onClose()})},disabled:input!=="delete"},"Delete"))))))};const MuteChannelModal=props=>{if(props.selected.length!==1)return null;const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiOverlayMask"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModal"],{onClose:props.onClose,maxWidth:500},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeader"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,"Mute ".concat(props.selected[0].name,"?"))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalBody"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],null,"This channel will stop sending notifications to its recipients. However, the channel will remain available for selection.")),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalFooter"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd"},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:props.onClose},"Cancel")),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{fill:true,"data-test-subj":"mute-channel-modal-mute-button",onClick:async()=>{const channel={...props.selected[0],is_enabled:false};await props.services.notificationService.updateConfig(channel.config_id,channel).then(resp=>{coreContext.notifications.toasts.addSuccess("Channel ".concat(channel.name," successfully muted."));props.setSelected([channel]);if(props.refresh)setTimeout(()=>props.refresh(),common["c"])}).catch(error=>{coreContext.notifications.toasts.addError((error===null||error===void 0?void 0:error.body)||error,{title:"Failed to mute channel"})});props.onClose()}},"Mute"))))))};function ChannelActions(props){var _props$selected$;const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);const servicesContext=Object(external_osdSharedDeps_React_["useContext"])(ServicesContext);const[isPopoverOpen,setIsPopoverOpen]=Object(external_osdSharedDeps_React_["useState"])(false);const actions=[{label:"Edit",disabled:props.selected.length!==1,href:"#".concat(ROUTES.EDIT_CHANNEL,"/").concat((_props$selected$=props.selected[0])===null||_props$selected$===void 0?void 0:_props$selected$.config_id)},{label:"Delete",disabled:props.selected.length===0,modal:DeleteChannelModal,modalParams:{refresh:props.refresh}},{label:"Mute",disabled:props.selected.length!==1||!props.selected[0].is_enabled,modal:MuteChannelModal,modalParams:{refresh:props.refresh,setSelected:props.setSelected}},{label:"Unmute",disabled:props.selected.length!==1||props.selected[0].is_enabled,action:async()=>{const channel={...props.selected[0],is_enabled:true};servicesContext.notificationService.updateConfig(channel.config_id,channel).then(resp=>{coreContext.notifications.toasts.addSuccess("Channel ".concat(channel.name," successfully unmuted."));props.setSelected([channel]);setTimeout(()=>props.refresh(),common["c"])}).catch(error=>{coreContext.notifications.toasts.addError((error===null||error===void 0?void 0:error.body)||error,{title:"Failed to unmute channel"})})}}];return external_osdSharedDeps_React_default.a.createElement(ModalConsumer,null,_ref=>{let{onShow:onShow}=_ref;return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiPopover"],{panelPaddingSize:"none",button:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{iconType:"arrowDown",iconSide:"right",disabled:props.selected.length===0,onClick:()=>setIsPopoverOpen(!isPopoverOpen)},"Actions"),isOpen:isPopoverOpen,closePopover:()=>setIsPopoverOpen(false)},actions.map(params=>external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiContextMenuItem"],{key:params.label,disabled:params.disabled,onClick:()=>{setIsPopoverOpen(false);if(params.modal){onShow(params.modal,{selected:props.selected,...params.modalParams||{}})}if(params.href)location.assign(params.href);if(params.action)params.action()}},params.label)))})}const ChannelControls=props=>{const mainStateContext=Object(external_osdSharedDeps_React_["useContext"])(MainContext);const[isStatePopoverOpen,setIsStatePopoverOpen]=Object(external_osdSharedDeps_React_["useState"])(false);const[stateItems,setStateItems]=Object(external_osdSharedDeps_React_["useState"])([{field:"true",display:"Active",checked:"off"},{field:"false",display:"Muted",checked:"off"}]);const[isTypePopoverOpen,setIsTypePopoverOpen]=Object(external_osdSharedDeps_React_["useState"])(false);const[typeItems,setTypeItems]=Object(external_osdSharedDeps_React_["useState"])(Object.entries(mainStateContext.availableChannels).map(_ref=>{let[key,value]=_ref;return{field:key,display:value,checked:"off"}}));Object(external_osdSharedDeps_React_["useEffect"])(()=>{const newItems=typeItems.filter(_ref2=>{let{field:field}=_ref2;return!!mainStateContext.availableChannels[field]});if(newItems.length!==typeItems.length)setTypeItems(newItems)},[mainStateContext.availableChannels]);function updateItem(items,index,type,singleSelect){if(!items[index])return;const newItems=[...items];if(singleSelect){const checked=newItems[index].checked==="off"?"on":"off";newItems.forEach((item,i)=>item.checked="off");newItems[index].checked=checked}else{newItems[index].checked=newItems[index].checked==="off"?"on":"off"}const newFilters=external_osdSharedDeps_Lodash_default.a.clone(props.filters);const checkedItems=newItems.filter(item=>item.checked==="on").map(item=>item.field);switch(type){case"state":setStateItems(newItems);newFilters.state=checkedItems[0];break;case"type":setTypeItems(newItems);newFilters.type=checkedItems;break;default:break}props.onFiltersChange(newFilters)}function isItemSelected(items){return items.map(item=>item.checked==="on").reduce((flag,curr)=>flag||curr,false)}return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldSearch"],{fullWidth:true,placeholder:"Search",onSearch:props.onSearchChange})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFilterGroup"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiPopover"],{button:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFilterButton"],{iconType:"arrowDown",grow:false,onClick:()=>setIsStatePopoverOpen(!isStatePopoverOpen)},isItemSelected(stateItems)?external_osdSharedDeps_React_default.a.createElement("b",null,"Status"):"Status"),isOpen:isStatePopoverOpen,closePopover:()=>setIsStatePopoverOpen(false),panelPaddingSize:"none"},stateItems.map((item,index)=>external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFilterSelectItem"],{key:"channel-state-filter-".concat(index),checked:item.checked==="on"?"on":undefined,onClick:()=>{updateItem(stateItems,index,"state",true);setIsStatePopoverOpen(false)}},item.display))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiPopover"],{button:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFilterButton"],{iconType:"arrowDown",grow:false,onClick:()=>setIsTypePopoverOpen(!isTypePopoverOpen)},isItemSelected(typeItems)?external_osdSharedDeps_React_default.a.createElement("b",null,"Type"):"Type"),isOpen:isTypePopoverOpen,closePopover:()=>setIsTypePopoverOpen(false),panelPaddingSize:"none"},typeItems.map((item,index)=>external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFilterSelectItem"],{key:"channel-type-filter-".concat(index),checked:item.checked==="on"?"on":undefined,onClick:()=>updateItem(typeItems,index,"type")},item.display))))))};class MDSEnabledComponent_MDSEnabledComponent extends external_osdSharedDeps_React_default.a.Component{constructor(props){super(props);this.state={dataSourceId:props.dataSourceId,multiDataSourceEnabled:props.multiDataSourceEnabled}}}function isDataSourceChanged(prevProps,currentProps){var _prevProps$notificati,_currentProps$notific;if((_prevProps$notificati=prevProps.notificationService)!==null&&_prevProps$notificati!==void 0&&_prevProps$notificati.multiDataSourceEnabled&&(_currentProps$notific=currentProps.notificationService)!==null&&_currentProps$notific!==void 0&&_currentProps$notific.multiDataSourceEnabled){const prevDataSourceId=prevProps.notificationService.dataSourceId;const currDataSourceId=currentProps.notificationService.dataSourceId;if(!external_osdSharedDeps_Lodash_default.a.isEqual(prevDataSourceId,currDataSourceId)){return true}}return false}function isDataSourceError(error){return error.body&&error.body.message&&error.body.message.includes("Data Source Error")}function Channels_defineProperty(obj,key,value){key=Channels_toPropertyKey(key);if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function Channels_toPropertyKey(arg){var key=Channels_toPrimitive(arg,"string");return typeof key==="symbol"?key:String(key)}function Channels_toPrimitive(input,hint){if(typeof input!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(typeof res!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.")}return(hint==="string"?String:Number)(input)}class Channels_Channels extends MDSEnabledComponent_MDSEnabledComponent{constructor(props){super(props);Channels_defineProperty(this,"columns",void 0);Channels_defineProperty(this,"onTableChange",_ref=>{let{page:tablePage,sort:sort}=_ref;const{index:page,size:size}=tablePage;const{field:sortField,direction:sortDirection}=sort;this.setState({from:page*size,size:size,sortField:sortField,sortDirection:sortDirection})});Channels_defineProperty(this,"onSelectionChange",selectedItems=>{this.setState({selectedItems:selectedItems})});Channels_defineProperty(this,"onSearchChange",search=>{this.setState({from:0,search:search})});Channels_defineProperty(this,"onFiltersChange",filters=>{this.setState({from:0,filters:filters})});const state={total:0,from:0,size:10,search:"",filters:{},sortField:"name",sortDirection:external_osdSharedDeps_ElasticEui_["SortDirection"].ASC,items:[],selectedItems:[],loading:true};this.state=state;this.columns=[{field:"name",name:"Name",sortable:true,truncateText:true,render:(name,item)=>external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiLink"],{href:"#".concat(ROUTES.CHANNEL_DETAILS,"/").concat(item.config_id)},name)},{field:"is_enabled",name:"Notification status",sortable:true,render:enabled=>{const color=enabled?"success":"subdued";const label=enabled?"Active":"Muted";return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiHealth"],{color:color},label)}},{field:"config_type",name:"Type",sortable:true,truncateText:false,render:type=>external_osdSharedDeps_Lodash_default.a.get(CHANNEL_TYPE,type,"-")},{field:"description",name:"Description",sortable:true,truncateText:true,render:description=>description||"-"}];this.refresh=this.refresh.bind(this)}async componentDidMount(){this.context.chrome.setBreadcrumbs([BREADCRUMBS.NOTIFICATIONS,BREADCRUMBS.CHANNELS]);window.scrollTo(0,0);await this.refresh()}async componentDidUpdate(prevProps,prevState){const prevQuery=this.getQueryObjectFromState(prevState);const currQuery=this.getQueryObjectFromState(this.state);if(!external_osdSharedDeps_Lodash_default.a.isEqual(prevQuery,currQuery)){await this.refresh()}if(isDataSourceChanged(this.props,prevProps)){await this.refresh()}}getQueryObjectFromState(state){const config_type=external_osdSharedDeps_Lodash_default.a.isEmpty(state.filters.type)?Object.keys(CHANNEL_TYPE):state.filters.type;const queryObject={from_index:state.from,max_items:state.size,query:state.search,config_type:config_type,sort_field:state.sortField,sort_order:state.sortDirection};if(state.filters.state!=undefined)queryObject.is_enabled=state.filters.state;return queryObject}async refresh(){this.setState({loading:true});try{const queryObject=this.getQueryObjectFromState(this.state);const channels=await this.props.notificationService.getChannels(queryObject);this.setState({items:channels.items,total:channels.total})}catch(error){if(isDataSourceError(error)){this.setState({items:[],total:0})}this.context.notifications.toasts.addDanger(getErrorMessage(error,"There was a problem loading channels."))}this.setState({loading:false})}render(){const filterIsApplied=!!this.state.search;const page=Math.floor(this.state.from/this.state.size);const pagination={pageIndex:page,pageSize:this.state.size,pageSizeOptions:DEFAULT_PAGE_SIZE_OPTIONS,totalItemCount:this.state.total};const sorting={sort:{direction:this.state.sortDirection,field:this.state.sortField}};const selection={selectable:()=>true,onSelectionChange:this.onSelectionChange};return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(ContentPanel_ContentPanel,{actions:external_osdSharedDeps_React_default.a.createElement(ContentPanel_ContentPanelActions,{actions:[{component:external_osdSharedDeps_React_default.a.createElement(ChannelActions,{selected:this.state.selectedItems,setSelected:selectedItems=>this.setState({selectedItems:selectedItems}),items:this.state.items,setItems:items=>this.setState({items:items}),refresh:this.refresh})},{component:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{fill:true,href:"#".concat(ROUTES.CREATE_CHANNEL)},"Create channel")}]}),bodyStyles:{padding:"initial"},title:"Channels",titleSize:"m",total:this.state.total},external_osdSharedDeps_React_default.a.createElement(ChannelControls,{onSearchChange:this.onSearchChange,filters:this.state.filters,onFiltersChange:this.onFiltersChange}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiHorizontalRule"],{margin:"s"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiBasicTable"],{columns:this.columns,items:this.state.items,itemId:"config_id",isSelectable:true,selection:selection,noItemsMessage:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiEmptyPrompt"],{title:external_osdSharedDeps_React_default.a.createElement("h2",null,"No channels to display"),body:"To send or receive notifications, you will need to create a notification channel.",actions:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{href:"#".concat(ROUTES.CREATE_CHANNEL)},"Create channel")}),onChange:this.onTableChange,pagination:pagination,sorting:sorting,tableLayout:"auto",loading:this.state.loading})))}}Channels_defineProperty(Channels_Channels,"contextType",CoreServicesContext);function ChannelDetailItems(props){const getPaddedDescriptionList=list=>list.concat(new Array(Math.ceil(list.length/3)*3-list.length).fill(null)).reduce((rows,item,i)=>{if(i%3===0)rows.push([item]);else rows[rows.length-1].push(item);return rows},[]);return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,getPaddedDescriptionList(props.listItems).map((row,rowIndex)=>external_osdSharedDeps_React_default.a.createElement("div",{key:"channel-description-row-".concat(rowIndex)},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],null,row.map((item,itemIndex)=>external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{key:"channel-description-item-".concat(itemIndex)},item&&external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiDescriptionList"],{style:{wordBreak:"break-word",whiteSpace:"pre-line"},listItems:[item]})))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}))))}function ChannelDetailsActions(props){const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);const servicesContext=Object(external_osdSharedDeps_React_["useContext"])(ServicesContext);const[isPopoverOpen,setIsPopoverOpen]=Object(external_osdSharedDeps_React_["useState"])(false);const sendTestMessage=async()=>{try{await servicesContext.notificationService.sendTestMessage(props.channel.config_id);coreContext.notifications.toasts.addSuccess("Successfully sent a test message.")}catch(error){coreContext.notifications.toasts.addError((error===null||error===void 0?void 0:error.body)||error,{title:"Failed to send the test message.",toastMessage:"View error details and adjust the channel settings."})}};const actions=[{label:"Edit",href:"#".concat(ROUTES.EDIT_CHANNEL,"/").concat(props.channel.config_id,"?from=details")},{label:"Send test message",disabled:!props.channel.config_id||!props.channel.is_enabled,action:sendTestMessage},{label:"Delete",color:"danger",modal:DeleteChannelModal,modalParams:{href:"#".concat(ROUTES.CHANNELS)}}];return external_osdSharedDeps_React_default.a.createElement(ModalConsumer,null,_ref=>{let{onShow:onShow}=_ref;return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiPopover"],{panelPaddingSize:"none",button:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{iconType:"arrowDown",iconSide:"right",onClick:()=>setIsPopoverOpen(!isPopoverOpen)},"Actions"),isOpen:isPopoverOpen,closePopover:()=>setIsPopoverOpen(false)},actions.map(params=>external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiContextMenuItem"],{key:params.label,disabled:params.disabled,onClick:()=>{setIsPopoverOpen(false);if(params.modal){onShow(params.modal,{selected:[props.channel],...params.modalParams||{}})}if(params.href)location.assign(params.href);if(params.action)params.action()}},params.color?external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiTextColor"],{color:params.color},params.label):params.label)))})}const constructWebhookObject=(webhookTypeIdSelected,webhookURL,customURLType,customURLHost,customURLPort,customURLPath,webhookMethod,webhookParams,webhookHeaders)=>{let url;if(webhookTypeIdSelected==="WEBHOOK_URL"){url=webhookURL}else{url="".concat(customURLType.toLowerCase(),"://").concat(customURLHost.replace(/^https?:\/\//,""));if(customURLPort)url+=":".concat(customURLPort);if(customURLPath)url+="/".concat(customURLPath.replace(/^\//,""));if(webhookParams.length>0){const params=new URLSearchParams(webhookParams.filter(_ref=>{let{key:key,value:value}=_ref;return key}).map(_ref2=>{let{key:key,value:value}=_ref2;return[key,value]}));url+="?"+params.toString()}}const header_params=webhookHeaders.filter(_ref3=>{let{key:key,value:value}=_ref3;return key}).reduce((prev,curr)=>({...prev,[curr.key]:curr.value}),{});return{url:url,header_params:header_params,method:webhookMethod}};const deconstructWebhookObject=webhook=>{try{const url=new URL(webhook.url);const customURLType=url.protocol.replace(":","").toUpperCase();const customURLHost=url.hostname;const customURLPort=url.port;const customURLPath=url.pathname.replace(/^\//,"");const webhookParams=[];url.searchParams.forEach((value,key)=>webhookParams.push({key:key,value:value}));const webhookHeaders=Object.entries(webhook.header_params).map(_ref4=>{let[key,value]=_ref4;return{key:key,value:value}});return{webhookURL:webhook.url,customURLType:customURLType,customURLHost:customURLHost,customURLPort:customURLPort,customURLPath:customURLPath,webhookMethod:webhook.method,webhookParams:webhookParams,webhookHeaders:webhookHeaders}}catch(error){console.error("Error parsing url:",error);return{webhookURL:webhook.url,customURLType:"HTTPS",customURLHost:"",customURLPort:"",customURLPath:"",webhookMethod:"POST",webhookParams:[],webhookHeaders:[]}}};const constructEmailObject=(selectedSenderOptions,selectedRecipientGroupOptions)=>{const customEmailsList=[];const recipientGroupIds=[];for(let i=0;i<selectedRecipientGroupOptions.length;i++){const group=selectedRecipientGroupOptions[i];if(group.value){recipientGroupIds.push(group.value)}else{customEmailsList.push({recipient:group.label})}}return{email_account_id:selectedSenderOptions[0].value,recipient_list:customEmailsList,email_group_id_list:recipientGroupIds}};const deconstructEmailObject=email=>{const selectedSenderOptions=[{label:email.email_account_name||"-",value:email.email_account_id}];const selectedRecipientGroupOptions=[...email.email_group_id_list.map(groupId=>({label:external_osdSharedDeps_Lodash_default.a.get(email.email_group_id_map,groupId,"-"),value:groupId})),...email.recipient_list.map(recipient=>({label:recipient.recipient}))];return{senderType:email.sender_type,selectedSenderOptions:selectedSenderOptions,selectedRecipientGroupOptions:selectedRecipientGroupOptions}};function DetailsListModal(props){return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiOverlayMask"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModal"],{onClose:props.onClose,maxWidth:800},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeader"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,props.header)),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalBody"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiTitle"],{size:"xxs"},external_osdSharedDeps_React_default.a.createElement("h1",null,props.title)),props.items.map((item,i)=>external_osdSharedDeps_React_default.a.createElement("div",{key:"details-list-modal-item-".concat(i)},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiHorizontalRule"],{margin:"s"}),external_osdSharedDeps_React_default.a.createElement("p",null,item)))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalFooter"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{fill:true,onClick:props.onClose},"Close")))))}function DetailsTableModal(props){const keyColumn=props.isParameters?"Parameter":"Header";const columns=[{field:"key",name:keyColumn,align:"left",truncateText:false,render:item=>item?item:"-"},{field:"value",name:"Value",align:"left",truncateText:false,render:item=>item?item:"-"}];return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiOverlayMask"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModal"],{onClose:props.onClose,maxWidth:800},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeader"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,props.header)),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalBody"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiInMemoryTable"],{items:props.items,columns:columns})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalFooter"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{fill:true,onClick:props.onClose},"Close")))))}function ChannelSettingsDetails(props){if(!props.channel)return null;const settingsList=[];const getModalComponent=function(items,header,title){let separator=arguments.length>3&&arguments[3]!==undefined?arguments[3]:", ";let isParameters=arguments.length>4?arguments[4]:undefined;return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement("div",{style:{whiteSpace:"pre-line"}},items.slice(0,5).map(item=>typeof item==="string"?item:"".concat(item.key,": ").concat(item.value)).join(separator)||"-"),items.length>5&&external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null," ",external_osdSharedDeps_React_default.a.createElement(ModalConsumer,null,_ref=>{let{onShow:onShow}=_ref;return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiLink"],{onClick:typeof items[0]==="string"?()=>onShow(DetailsListModal,{header:"".concat(header," (").concat(items.length,")"),title:title,items:items}):()=>onShow(DetailsTableModal,{header:"".concat(header," (").concat(items.length,")"),isParameters:isParameters,items:items})},items.length-5," more")})))};const type=props.channel.config_type;if(type===BACKEND_CHANNEL_TYPE.SLACK){settingsList.push(...[{title:"Channel type",description:CHANNEL_TYPE.slack},{title:"Webhook URL",description:props.channel.slack.url||"-"}])}else if(type===BACKEND_CHANNEL_TYPE.CHIME){settingsList.push(...[{title:"Channel type",description:CHANNEL_TYPE.chime},{title:"Webhook URL",description:props.channel.chime.url||"-"}])}else if(type===BACKEND_CHANNEL_TYPE.MICROSOFT_TEAMS){settingsList.push(...[{title:"Channel type",description:CHANNEL_TYPE.microsoft_teams},{title:"Webhook URL",description:props.channel.microsoft_teams.url||"-"}])}else if(type===BACKEND_CHANNEL_TYPE.EMAIL){const emailObject=deconstructEmailObject(props.channel.email);const recipientsDescription=getModalComponent(emailObject.selectedRecipientGroupOptions.map(group=>group.label),"Default recipients","Recipients");settingsList.push(...[{title:"Channel type",description:CHANNEL_TYPE.email},{title:"Sender",description:emailObject.selectedSenderOptions[0].label||"-"},{title:"Default recipients",description:recipientsDescription}])}else if(type===BACKEND_CHANNEL_TYPE.CUSTOM_WEBHOOK){const webhookObject=deconstructWebhookObject(props.channel.webhook);const parametersDescription=getModalComponent(webhookObject.webhookParams,"Query parameters",undefined,"\n",true);const headersDescription=getModalComponent(webhookObject.webhookHeaders,"Webhook headers",undefined,"\n",false);settingsList.push(...[{title:"Channel type",description:CHANNEL_TYPE.webhook},{title:"Method",description:webhookObject.webhookMethod||"-"},{title:"Type",description:webhookObject.customURLType||"-"},{title:"Host",description:webhookObject.customURLHost||"-"},{title:"Port",description:webhookObject.customURLPort||"-"},{title:"Path",description:webhookObject.customURLPath||"-"},{title:"Query parameters",description:parametersDescription},{title:"Webhook headers",description:headersDescription}])}else if(type===BACKEND_CHANNEL_TYPE.SNS){var _props$channel$sns,_props$channel$sns2;settingsList.push(...[{title:"Channel type",description:CHANNEL_TYPE.sns},{title:"SNS topic ARN",description:((_props$channel$sns=props.channel.sns)===null||_props$channel$sns===void 0?void 0:_props$channel$sns.topic_arn)||"-"},{title:"IAM role ARN",description:((_props$channel$sns2=props.channel.sns)===null||_props$channel$sns2===void 0?void 0:_props$channel$sns2.role_arn)||"-"}])}return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(ChannelDetailItems,{listItems:settingsList}))}function ChannelDetails(props){const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);const servicesContext=Object(external_osdSharedDeps_React_["useContext"])(ServicesContext);const id=props.match.params.id;const[channel,setChannel]=Object(external_osdSharedDeps_React_["useState"])();const[toasts,setToasts]=Object(external_osdSharedDeps_React_["useState"])([]);Object(external_osdSharedDeps_React_["useEffect"])(()=>{coreContext.chrome.setBreadcrumbs([BREADCRUMBS.NOTIFICATIONS,BREADCRUMBS.CHANNELS]);refresh()},[]);const refresh=async()=>{servicesContext.notificationService.getChannel(id).then(async response=>{if(response.config_type==="email"){var _channel$email;const channel=await servicesContext.notificationService.getEmailConfigDetails(response);if((_channel$email=channel.email)!==null&&_channel$email!==void 0&&(_channel$email=_channel$email.invalid_ids)!==null&&_channel$email!==void 0&&_channel$email.length){coreContext.notifications.toasts.addDanger("The sender and/or some recipient groups might have been deleted.")}return channel}return response}).then(response=>{setChannel(response);coreContext.chrome.setBreadcrumbs([BREADCRUMBS.NOTIFICATIONS,BREADCRUMBS.CHANNELS,{text:(response===null||response===void 0?void 0:response.name)||"",href:"".concat(BREADCRUMBS.CHANNEL_DETAILS.href,"/").concat(id)}])}).catch(error=>{const newToast={id:"channel-not-found-toast",title:"Channel not found",color:"danger",iconType:"alert",text:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],{size:"s",style:{fontWeight:400,color:"rgb(52, 55, 65)",marginTop:10,marginBottom:20}},"The channel might have been deleted."),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd"},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{size:"s",href:"#".concat(ROUTES.NOTIFICATIONS)},"View Notifications dashboard"))))};setToasts([...toasts,newToast])})};const nameList=[{title:"Channel name",description:(channel===null||channel===void 0?void 0:channel.name)||"-"},{title:"Description",description:(channel===null||channel===void 0?void 0:channel.description)||"-"},{title:"Last updated",description:renderTime((channel===null||channel===void 0?void 0:channel.last_updated_time_ms)||NaN)}];return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiGlobalToastList"],{toasts:toasts,dismissToast:removedToast=>{setToasts(toasts.filter(toast=>toast.id!==removedToast.id))},toastLifeTimeMs:6e4}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"m",style:{maxWidth:1316}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"m",alignItems:"flexEnd"},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiTitle"],{size:"l"},external_osdSharedDeps_React_default.a.createElement("h1",null,(channel===null||channel===void 0?void 0:channel.name)||"-"))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,style:{paddingBottom:5}},(channel===null||channel===void 0?void 0:channel.is_enabled)===undefined?null:channel.is_enabled?external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiHealth"],{color:"success"},"Active"):external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiHealth"],{color:"subdued"},"Muted")))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],null),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},channel&&external_osdSharedDeps_React_default.a.createElement(ChannelDetailsActions,{channel:channel})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},channel&&external_osdSharedDeps_React_default.a.createElement(ModalConsumer,null,_ref=>{let{onShow:onShow}=_ref;return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"channel-details-mute-button",iconType:channel!==null&&channel!==void 0&&channel.is_enabled?"bellSlash":"bell",onClick:()=>{if(!channel)return;if(channel.is_enabled){onShow(MuteChannelModal,{selected:[channel],setSelected:selected=>setChannel(selected[0])})}else{const newChannel={...channel,is_enabled:true};servicesContext.notificationService.updateConfig(channel.config_id,newChannel).then(resp=>{coreContext.notifications.toasts.addSuccess("Channel ".concat(channel.name," successfully unmuted."));setChannel(newChannel)})}}},channel!==null&&channel!==void 0&&channel.is_enabled?"Mute channel":"Unmute channel")}))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(ContentPanel_ContentPanel,{bodyStyles:{padding:"initial"},title:"Name and description",titleSize:"s",panelStyles:{maxWidth:1300}},external_osdSharedDeps_React_default.a.createElement(ChannelDetailItems,{listItems:nameList})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(ContentPanel_ContentPanel,{bodyStyles:{padding:"initial"},title:"Configurations",titleSize:"s",panelStyles:{maxWidth:1300}},external_osdSharedDeps_React_default.a.createElement(ChannelSettingsDetails,{channel:channel})))}var query_string=__webpack_require__(248);var query_string_default=__webpack_require__.n(query_string);const validateChannelName=name=>{const errors=[];if(external_osdSharedDeps_Lodash_default.a.trim(name).length===0)errors.push("Channel name cannot be empty.");return errors};const validateWebhookURL=url=>{const errors=[];if(url.length===0)errors.push("Webhook URL cannot be empty.");else if(!url.match(/^https?:\/\/.+/))errors.push("Invalid webhook URL.");return errors};const validateWebhookKey=key=>{const errors=[];if(key.length===0)errors.push("Key cannot be empty.");return errors};const validateWebhookValue=value=>{const errors=[];if(value.length===0)errors.push("Value cannot be empty.");return errors};const validateCustomURLHost=host=>{const errors=[];if(host.length===0)errors.push("Host cannot be empty.");return errors};const validateCustomURLPort=port=>{const errors=[];if(port.length===0)return errors;const portNum=parseInt(port);if(isNaN(portNum)||portNum<0||portNum>65535)errors.push("Invalid port.");return errors};const validateEmailSender=sender=>{const errors=[];if(sender.length===0)errors.push("Sender cannot be empty.");return errors};const validateRecipients=group=>{const errors=[];if(group.length===0)errors.push("Default recipients cannot be empty.");return errors};const validateArn=arn=>{const errors=[];if(arn.length===0)errors.push("ARN key cannot be empty.");return errors};function ChannelNamePanel(props){const context=Object(external_osdSharedDeps_React_["useContext"])(CreateChannelContext);return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(ContentPanel_ContentPanel,{bodyStyles:{padding:"initial"},title:"Name and description",titleSize:"s"},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Name",error:context.inputErrors.name.join(" "),isInvalid:context.inputErrors.name.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{"data-test-subj":"create-channel-name-input",placeholder:"Enter channel name",value:props.name,onChange:e=>props.setName(e.target.value),isInvalid:context.inputErrors.name.length>0,onBlur:()=>{context.setInputErrors({...context.inputErrors,name:validateChannelName(props.name)})}})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:external_osdSharedDeps_React_default.a.createElement("span",null,"Description - ",external_osdSharedDeps_React_default.a.createElement("i",{style:{fontWeight:"normal"}},"optional"))},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiTextArea"],{"data-test-subj":"create-channel-description-input",placeholder:"What is the purpose of this channel?",style:{height:"4.1rem"},value:props.description,onChange:e=>props.setDescription(e.target.value)})))))}function ChimeSettings(props){const context=Object(external_osdSharedDeps_React_["useContext"])(CreateChannelContext);return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Webhook URL",style:{maxWidth:"700px"},error:context.inputErrors.chimeWebhook.join(" "),isInvalid:context.inputErrors.chimeWebhook.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{fullWidth:true,"data-test-subj":"create-channel-chime-webhook-input",placeholder:"https://hooks.chime.aws/incomingwebhooks/XXXXX...",value:props.chimeWebhook,onChange:e=>props.setChimeWebhook(e.target.value),isInvalid:context.inputErrors.chimeWebhook.length>0,onBlur:()=>{context.setInputErrors({...context.inputErrors,chimeWebhook:validateWebhookURL(props.chimeWebhook)})}}))}function MicrosoftTeamsSettings(props){const context=Object(external_osdSharedDeps_React_["useContext"])(CreateChannelContext);return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Webhook URL",style:{maxWidth:"700px"},error:context.inputErrors.microsoftTeamsWebhook.join(" "),isInvalid:context.inputErrors.microsoftTeamsWebhook.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{fullWidth:true,"data-test-subj":"create-channel-microsoftTeams-webhook-input",placeholder:"https://xxxxx.webhook.office.com/webhookb2/xxxxx/IncomingWebhook/xxxxx...",value:props.microsoftTeamsWebhook,onChange:e=>props.setMicrosoftTeamsWebhook(e.target.value),isInvalid:context.inputErrors.microsoftTeamsWebhook.length>0,onBlur:()=>{context.setInputErrors({...context.inputErrors,microsoftTeamsWebhook:validateWebhookURL(props.microsoftTeamsWebhook)})}}))}function WebhookHeaders(props){const setHeader=(key,value,index)=>{const header=props.headers[index];const newHeaders=[...props.headers];if(key!==null)header.key=key;else if(value!==null)header.value=value;newHeaders.splice(index,1,header);props.setHeaders(newHeaders)};return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_osdSharedDeps_React_default.a.createElement("h4",null,props.type==="parameter"?"Query parameters":"Webhook headers")),props.headers.length===0&&external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],{size:"s"},"No ".concat(props.type,"s defined."))),props.headers.map((header,i)=>external_osdSharedDeps_React_default.a.createElement("div",{key:"webhook-".concat(props.type,"-").concat(i)},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{style:{maxWidth:639}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Key"},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:"",value:header.key,onChange:e=>setHeader(e.target.value,null,i),disabled:props.type==="header"&&i===0&&header.key==="Content-Type"}))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Value"},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:"",value:header.value,onChange:e=>setHeader(null,e.target.value,i)}))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>{const newHeaders=[...props.headers];newHeaders.splice(i,1);props.setHeaders(newHeaders)},disabled:props.type==="header"&&i===0&&header.key==="Content-Type"},"Remove ".concat(props.type))))))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>{props.setHeaders([...props.headers,{key:"",value:""}])}},"Add ".concat(props.type)))}function CustomWebhookSettings(props){const context=Object(external_osdSharedDeps_React_["useContext"])(CreateChannelContext);const webhookTypeOptions=Object.entries(CUSTOM_WEBHOOK_ENDPOINT_TYPE).map(_ref=>{let[key,value]=_ref;return{id:key,label:value}});const renderWebhook=()=>external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Webhook URL",error:context.inputErrors.webhookURL.join(" "),isInvalid:context.inputErrors.webhookURL.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:"https://name.example.com/XXXXX...","data-test-subj":"custom-webhook-url-input",value:props.webhookURL,onChange:e=>props.setWebhookURL(e.target.value),isInvalid:context.inputErrors.webhookURL.length>0,onBlur:()=>{context.setInputErrors({...context.inputErrors,webhookURL:validateWebhookURL(props.webhookURL)})}}));const renderCustomURL=()=>external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Type"},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSuperSelect"],{options:[{value:"HTTPS",inputDisplay:"HTTPS"},{value:"HTTP",inputDisplay:"HTTP"}],valueOfSelected:props.customURLType,onChange:props.setCustomURLType})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Host",error:context.inputErrors.customURLHost.join(" "),isInvalid:context.inputErrors.customURLHost.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:"name.example.com","data-test-subj":"custom-webhook-host-input",value:props.customURLHost,onChange:e=>props.setCustomURLHost(e.target.value),isInvalid:context.inputErrors.customURLHost.length>0,onBlur:()=>{context.setInputErrors({...context.inputErrors,customURLHost:validateCustomURLHost(props.customURLHost)})}})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:external_osdSharedDeps_React_default.a.createElement("span",null,"Port - ",external_osdSharedDeps_React_default.a.createElement("i",{style:{fontWeight:"normal"}},"optional")),error:context.inputErrors.customURLPort.join(" "),isInvalid:context.inputErrors.customURLPort.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldNumber"],{placeholder:"Enter port","data-test-subj":"custom-webhook-port-input",value:props.customURLPort,onChange:e=>props.setCustomURLPort(e.target.value),isInvalid:context.inputErrors.customURLPort.length>0,onBlur:()=>{context.setInputErrors({...context.inputErrors,customURLPort:validateCustomURLPort(props.customURLPort)})}})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:external_osdSharedDeps_React_default.a.createElement("span",null,"Path - ",external_osdSharedDeps_React_default.a.createElement("i",{style:{fontWeight:"normal"}},"optional"))},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:"Enter path","data-test-subj":"custom-webhook-path-input",value:props.customURLPath,onChange:e=>props.setCustomURLPath(e.target.value)})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(WebhookHeaders,{headers:props.webhookParams,setHeaders:props.setWebhookParams,type:"parameter"}));return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Method",style:{maxWidth:"700px"}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSuperSelect"],{options:[{value:"POST",inputDisplay:"POST"},{value:"PUT",inputDisplay:"PUT"},{value:"PATCH",inputDisplay:"PATCH"}],valueOfSelected:props.webhookMethod,onChange:props.setWebhookMethod})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Define endpoints by",style:{maxWidth:"700px"}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiRadioGroup"],{options:webhookTypeOptions,idSelected:props.webhookTypeIdSelected,onChange:id=>props.setWebhookTypeIdSelected(id)})),props.webhookTypeIdSelected==="WEBHOOK_URL"?renderWebhook():renderCustomURL(),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"xxl"}),external_osdSharedDeps_React_default.a.createElement(WebhookHeaders,{headers:props.webhookHeaders,setHeaders:props.setWebhookHeaders,type:"header"}))}const createSenderConfigObject=(senderName,host,port,encryption,email)=>({name:senderName,config_type:"smtp_account",is_enabled:true,smtp_account:{host:host,port:port,method:encryption,from_address:email}});const createSesSenderConfigObject=(senderName,email,awsRegion,roleArn)=>({name:senderName,config_type:"ses_account",is_enabled:true,ses_account:{from_address:email,region:awsRegion,...roleArn&&{role_arn:roleArn}}});const createRecipientGroupConfigObject=(name,description,selectedEmailOptions)=>({name:name,description:description,config_type:"email_group",is_enabled:true,email_group:{recipient_list:selectedEmailOptions.map(email=>({recipient:email.label}))}});const onComboBoxCreateOption=function(searchValue){let flattenedOptions=arguments.length>1&&arguments[1]!==undefined?arguments[1]:[];let options=arguments.length>2?arguments[2]:undefined;let setOptions=arguments.length>3?arguments[3]:undefined;let selectedOptions=arguments.length>4?arguments[4]:undefined;let setSelectedOptions=arguments.length>5?arguments[5]:undefined;let setInputError=arguments.length>6?arguments[6]:undefined;const normalizedSearchValue=searchValue.trim().toLowerCase();if(!normalizedSearchValue)return;const newOption={label:searchValue};if(flattenedOptions.findIndex(option=>option.label.trim().toLowerCase()===normalizedSearchValue)===-1){setOptions([...options,newOption])}const newOptions=[...selectedOptions,newOption];setSelectedOptions(newOptions);setInputError(newOptions)};const validateSenderName=name=>{const errors=[];if(external_osdSharedDeps_Lodash_default.a.trim(name).length===0){errors.push("Sender name cannot be empty.");return errors}if(name.length>50||name.length<2)errors.push("Sender name must contain 2 to 50 characters.");if(!/^[a-z0-9-_]+$/.test(name))errors.push("Sender name contains invalid characters.");return errors};const validateEmail=email=>{const errors=[];if(email.length===0)errors.push("Email address cannot be empty.");return errors};const validateHost=host=>{const errors=[];if(host.length===0)errors.push("Host cannot be empty.");return errors};const validatePort=port=>{const errors=[];const portNum=parseInt(port);if(port.length===0)errors.push("Port cannot be empty.");else if(isNaN(portNum)||portNum<0||portNum>65535)errors.push("Invalid port.");return errors};const validateRoleArn=roleArn=>{const errors=[];if(roleArn.length===0)errors.push("IAM role ARN cannot be empty.");return errors};const validateAwsRegion=region=>{const errors=[];if(region.length===0)errors.push("AWS region cannot be empty.");return errors};const validateRecipientGroupName=name=>{const errors=[];if(external_osdSharedDeps_Lodash_default.a.trim(name).length===0){errors.push("Recipient group name cannot be empty.");return errors}if(name.length>50||name.length<2)errors.push("Recipient group name must contain 2 to 50 characters.");return errors};const validateRecipientGroupEmails=emails=>{const errors=[];if(emails.length===0)errors.push("Email addresses cannot be empty.");return errors};function CreateRecipientGroupForm(props){return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Name",style:{maxWidth:"650px"},helpText:"The name must contain 2 to 50 characters. Valid characters are A-Z, a-z, 0-9, (_) underscore, (-) hyphen and unicode characters.",error:props.inputErrors.name.join(" "),isInvalid:props.inputErrors.name.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{fullWidth:true,"data-test-subj":"create-recipient-group-form-name-input",placeholder:"Enter recipient group name",value:props.name,onChange:e=>props.setName(e.target.value),isInvalid:props.inputErrors.name.length>0,onBlur:()=>{props.setInputErrors({...props.inputErrors,name:validateRecipientGroupName(props.name)})}})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:external_osdSharedDeps_React_default.a.createElement("span",null,"Description - ",external_osdSharedDeps_React_default.a.createElement("i",{style:{fontWeight:"normal"}},"optional")),style:{maxWidth:"650px"}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued"},"Describe the purpose of the channel."),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiTextArea"],{fullWidth:true,"data-test-subj":"create-recipient-group-form-description-input",placeholder:"What is the purpose of this recipient group?",style:{height:"4.1rem"},value:props.description,onChange:e=>props.setDescription(e.target.value)}))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Emails",style:{maxWidth:"650px"},error:props.inputErrors.emailOptions.join(" "),isInvalid:props.inputErrors.emailOptions.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued"},"Select or type in one or more email addresses."),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiComboBox"],{placeholder:"Email addresses","data-test-subj":"create-recipient-group-form-emails-input",fullWidth:true,options:props.emailOptions,selectedOptions:props.selectedEmailOptions,onChange:props.setSelectedEmailOptions,onCreateOption:(searchValue,flattenedOptions)=>onComboBoxCreateOption(searchValue,flattenedOptions,props.emailOptions,props.setEmailOptions,props.selectedEmailOptions,props.setSelectedEmailOptions,options=>props.setInputErrors({...props.inputErrors,emailOptions:validateRecipientGroupEmails(options)})),customOptionText:"Add {searchValue} as an email address",isClearable:true,isInvalid:props.inputErrors.emailOptions.length>0,onBlur:()=>{props.setInputErrors({...props.inputErrors,emailOptions:validateRecipientGroupEmails(props.selectedEmailOptions)})}}))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}))}function CreateRecipientGroupModal(props){const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);const[name,setName]=Object(external_osdSharedDeps_React_["useState"])("");const[description,setDescription]=Object(external_osdSharedDeps_React_["useState"])("");const[selectedEmailOptions,setSelectedEmailOptions]=Object(external_osdSharedDeps_React_["useState"])([]);const[emailOptions,setEmailOptions]=Object(external_osdSharedDeps_React_["useState"])([{label:"no-reply@company.com"}]);const[inputErrors,setInputErrors]=Object(external_osdSharedDeps_React_["useState"])({name:[],emailOptions:[]});const isInputValid=()=>{const errors={name:validateRecipientGroupName(name),emailOptions:validateRecipientGroupEmails(emailOptions)};setInputErrors(errors);return!Object.values(errors).reduce((errorFlag,error)=>errorFlag||error.length>0,false)};return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiOverlayMask"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModal"],{onClose:props.onClose,style:{width:650}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeader"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,"Create recipient group")),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalBody"],null,external_osdSharedDeps_React_default.a.createElement(CreateRecipientGroupForm,{name:name,setName:setName,description:description,setDescription:setDescription,selectedEmailOptions:selectedEmailOptions,setSelectedEmailOptions:setSelectedEmailOptions,emailOptions:emailOptions,setEmailOptions:setEmailOptions,inputErrors:inputErrors,setInputErrors:setInputErrors})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalFooter"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:props.onClose},"Cancel"),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"create-recipient-group-modal-create-button",fill:true,onClick:async()=>{if(!isInputValid()){coreContext.notifications.toasts.addDanger("Some fields are invalid. Fix all highlighted error(s) before continuing.");return}const config=createRecipientGroupConfigObject(name,description,selectedEmailOptions);await props.services.notificationService.createConfig(config).then(response=>{coreContext.notifications.toasts.addSuccess("Recipient group ".concat(name," successfully created. You can select ").concat(name," from the list of recipient groups."));props.addRecipientGroupOptionAndSelect({label:name,value:response.config_id});props.onClose()}).catch(error=>{coreContext.notifications.toasts.addError((error===null||error===void 0?void 0:error.body)||error,{title:"Failed to create sender."})})}},"Create"))))}function CreateSenderForm(props){const encryptionOptions=Object.entries(ENCRYPTION_TYPE).map(_ref=>{let[key,value]=_ref;return{value:key,inputDisplay:value}});return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Sender name",style:{maxWidth:"650px"},helpText:"Use a unique, descriptive name. The sender name must contain from 2 to 50 characters. Valid characters are lowercase a-z, 0-9, - (hyphen) and _ (underscore).",error:props.inputErrors.senderName.join(" "),isInvalid:props.inputErrors.senderName.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{fullWidth:true,placeholder:"Enter sender name","data-test-subj":"create-sender-form-name-input",value:props.senderName,onChange:e=>props.setSenderName(e.target.value),isInvalid:props.inputErrors.senderName.length>0,onBlur:()=>{props.setInputErrors({...props.inputErrors,senderName:validateSenderName(props.senderName)})}})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",style:{maxWidth:"658px"}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:4},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Email address",error:props.inputErrors.email.join(" "),isInvalid:props.inputErrors.email.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:"name@example.com","data-test-subj":"create-sender-form-email-input",value:props.email,onChange:e=>props.setEmail(e.target.value),isInvalid:props.inputErrors.email.length>0,onBlur:()=>{props.setInputErrors({...props.inputErrors,email:validateEmail(props.email)})}}))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:4},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Host",error:props.inputErrors.host.join(" "),isInvalid:props.inputErrors.host.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:"smtp.example.com","data-test-subj":"create-sender-form-host-input",value:props.host,onChange:e=>props.setHost(e.target.value),isInvalid:props.inputErrors.host.length>0,onBlur:()=>{props.setInputErrors({...props.inputErrors,host:validateHost(props.host)})}}))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:2},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Port",error:props.inputErrors.port.join(" "),isInvalid:props.inputErrors.port.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldNumber"],{placeholder:"465","data-test-subj":"create-sender-form-port-input",value:props.port,onChange:e=>props.setPort(e.target.value),isInvalid:props.inputErrors.port.length>0,onBlur:()=>{props.setInputErrors({...props.inputErrors,port:validatePort(props.port)})}})))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Encryption method",style:{maxWidth:"650px"},helpText:external_osdSharedDeps_React_default.a.createElement("div",null,"SSL/TLS or STARTTLS is recommended for security. To use either one, you must enter each sender account's credentials to the OpenSearch keystore using the CLI."," ",external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiLink"],{href:ALERTING_DOCUMENTATION_LINK,target:"_blank",external:true},"Learn more"))},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSuperSelect"],{fullWidth:true,"data-test-subj":"create-sender-form-encryption-input",options:encryptionOptions,valueOfSelected:props.encryption,onChange:props.setEncryption})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}))}function CreateSenderModal(props){const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);const[senderName,setSenderName]=Object(external_osdSharedDeps_React_["useState"])("");const[email,setEmail]=Object(external_osdSharedDeps_React_["useState"])("");const[host,setHost]=Object(external_osdSharedDeps_React_["useState"])("");const[port,setPort]=Object(external_osdSharedDeps_React_["useState"])("");const[encryption,setEncryption]=Object(external_osdSharedDeps_React_["useState"])(Object.keys(ENCRYPTION_TYPE)[0]);const[inputErrors,setInputErrors]=Object(external_osdSharedDeps_React_["useState"])({senderName:[],email:[],host:[],port:[]});const isInputValid=()=>{const errors={senderName:validateSenderName(senderName),email:validateEmail(email),host:validateHost(host),port:validatePort(port)};setInputErrors(errors);return!Object.values(errors).reduce((errorFlag,error)=>errorFlag||error.length>0,false)};return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiOverlayMask"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModal"],{onClose:props.onClose,style:{width:750}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeader"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,"Create SMTP sender")),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalBody"],null,external_osdSharedDeps_React_default.a.createElement(CreateSenderForm,{senderName:senderName,setSenderName:setSenderName,email:email,setEmail:setEmail,host:host,setHost:setHost,port:port,setPort:setPort,encryption:encryption,setEncryption:setEncryption,inputErrors:inputErrors,setInputErrors:setInputErrors})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalFooter"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:props.onClose},"Cancel"),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"create-sender-modal-create-button",fill:true,onClick:async()=>{if(!isInputValid()){coreContext.notifications.toasts.addDanger("Some fields are invalid. Fix all highlighted error(s) before continuing.");return}const config=createSenderConfigObject(senderName,host,port,encryption,email);await props.services.notificationService.createConfig(config).then(response=>{coreContext.notifications.toasts.addSuccess("Sender ".concat(senderName," successfully created. You can select ").concat(senderName," from the list of senders."));props.addSenderOptionAndSelect({label:senderName,value:response.config_id});props.onClose()}).catch(error=>{coreContext.notifications.toasts.addError((error===null||error===void 0?void 0:error.body)||error,{title:"Failed to create sender."})})}},"Create"))))}function CreateSESSenderForm(props){const mainStateContext=Object(external_osdSharedDeps_React_["useContext"])(MainContext);return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Sender name",style:{maxWidth:"650px"},helpText:"Use a unique, descriptive name. The sender name must contain from 2 to 50 characters. Valid characters are lowercase a-z, 0-9, - (hyphen) and _ (underscore).",error:props.inputErrors.senderName.join(" "),isInvalid:props.inputErrors.senderName.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{fullWidth:true,placeholder:"Enter sender name","data-test-subj":"create-ses-sender-form-name-input",value:props.senderName,onChange:e=>props.setSenderName(e.target.value),isInvalid:props.inputErrors.senderName.length>0,onBlur:()=>{props.setInputErrors({...props.inputErrors,senderName:validateSenderName(props.senderName)})}})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Email address",style:{maxWidth:"650px"},error:props.inputErrors.email.join(" "),isInvalid:props.inputErrors.email.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{fullWidth:true,placeholder:"name@example.com","data-test-subj":"create-ses-sender-form-email-input",value:props.email,onChange:e=>props.setEmail(e.target.value),isInvalid:props.inputErrors.email.length>0,onBlur:()=>{props.setInputErrors({...props.inputErrors,email:validateEmail(props.email)})}})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",style:{maxWidth:"658px"}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:6},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:mainStateContext.tooltipSupport?external_osdSharedDeps_React_default.a.createElement("span",null,"IAM Role ARN -"," ",external_osdSharedDeps_React_default.a.createElement("i",{style:{fontWeight:"normal"}},"optional")):"IAM Role ARN",error:props.inputErrors.roleArn.join(" "),isInvalid:props.inputErrors.roleArn.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:"ARN key","data-test-subj":"create-ses-sender-form-role-arn-input",value:props.roleArn,onChange:e=>props.setRoleArn(e.target.value),isInvalid:props.inputErrors.roleArn.length>0,onBlur:()=>{if(!mainStateContext.tooltipSupport){props.setInputErrors({...props.inputErrors,roleArn:validateRoleArn(props.roleArn)})}}}))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:4},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"AWS region",error:props.inputErrors.awsRegion.join(" "),isInvalid:props.inputErrors.awsRegion.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:"us-east-1","data-test-subj":"create-ses-sender-form-aws-region-input",value:props.awsRegion,onChange:e=>props.setAwsRegion(e.target.value),isInvalid:props.inputErrors.awsRegion.length>0,onBlur:()=>{props.setInputErrors({...props.inputErrors,awsRegion:validateAwsRegion(props.awsRegion)})}})))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}))}function CreateSESSenderModal(props){const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);const mainStateContext=Object(external_osdSharedDeps_React_["useContext"])(MainContext);const[senderName,setSenderName]=Object(external_osdSharedDeps_React_["useState"])("");const[email,setEmail]=Object(external_osdSharedDeps_React_["useState"])("");const[roleArn,setRoleArn]=Object(external_osdSharedDeps_React_["useState"])("");const[awsRegion,setAwsRegion]=Object(external_osdSharedDeps_React_["useState"])("");const[inputErrors,setInputErrors]=Object(external_osdSharedDeps_React_["useState"])({senderName:[],email:[],roleArn:[],awsRegion:[]});const isInputValid=()=>{const errors={senderName:validateSenderName(senderName),email:validateEmail(email),awsRegion:validateAwsRegion(awsRegion),roleArn:[]};if(!mainStateContext.tooltipSupport){errors.roleArn=validateRoleArn(roleArn)}setInputErrors(errors);return!Object.values(errors).reduce((errorFlag,error)=>errorFlag||error.length>0,false)};return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiOverlayMask"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModal"],{onClose:props.onClose,style:{width:750}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeader"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,"Create SES sender")),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalBody"],null,external_osdSharedDeps_React_default.a.createElement(CreateSESSenderForm,{senderName:senderName,setSenderName:setSenderName,email:email,setEmail:setEmail,roleArn:roleArn,setRoleArn:setRoleArn,awsRegion:awsRegion,setAwsRegion:setAwsRegion,inputErrors:inputErrors,setInputErrors:setInputErrors})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalFooter"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:props.onClose},"Cancel"),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"create-ses-sender-modal-create-button",fill:true,onClick:async()=>{if(!isInputValid()){coreContext.notifications.toasts.addDanger("Some fields are invalid. Fix all highlighted error(s) before continuing.");return}const config=createSesSenderConfigObject(senderName,email,awsRegion,roleArn);await props.services.notificationService.createConfig(config).then(response=>{coreContext.notifications.toasts.addSuccess("Sender ".concat(senderName," successfully created. You can select ").concat(senderName," from the list of senders."));props.addSenderOptionAndSelect({label:senderName,value:response.config_id});props.onClose()}).catch(error=>{coreContext.notifications.toasts.addError((error===null||error===void 0?void 0:error.body)||error,{title:"Failed to create sender."})})}},"Create"))))}function EmailSettings(props){const context=Object(external_osdSharedDeps_React_["useContext"])(CreateChannelContext);const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);const servicesContext=Object(external_osdSharedDeps_React_["useContext"])(ServicesContext);const mainStateContext=Object(external_osdSharedDeps_React_["useContext"])(MainContext);const[smtpAvailable,setSmtpAvailable]=Object(external_osdSharedDeps_React_["useState"])(true);Object(external_osdSharedDeps_React_["useEffect"])(()=>{if(!mainStateContext.availableConfigTypes.includes("smtp_account")){setSmtpAvailable(false);props.setSenderType("ses_account")}},[]);const[sesSenderOptions,setSesSenderOptions]=Object(external_osdSharedDeps_React_["useState"])([]);const[smtpSenderOptions,setSmtpSenderOptions]=Object(external_osdSharedDeps_React_["useState"])([]);const[recipientGroupOptions,setRecipientGroupOptions]=Object(external_osdSharedDeps_React_["useState"])([]);const getQueryObject=(config_type,query)=>({from_index:0,max_items:1e4,config_type:config_type,sort_field:"name",sort_order:external_osdSharedDeps_ElasticEui_["SortDirection"].ASC,...query?{query:query}:{}});const refreshSenders=Object(external_osdSharedDeps_React_["useCallback"])(async query=>{try{const smtpSenders=await servicesContext.notificationService.getSenders(getQueryObject("smtp_account",query));setSmtpSenderOptions(smtpSenders.items.map(sender=>({label:sender.name,value:sender.config_id})));const sesSenders=await servicesContext.notificationService.getSenders(getQueryObject("ses_account",query));setSesSenderOptions(sesSenders.items.map(sender=>({label:sender.name,value:sender.config_id})))}catch(error){coreContext.notifications.toasts.addDanger(getErrorMessage(error,"There was a problem loading senders."))}},[]);const refreshRecipientGroups=Object(external_osdSharedDeps_React_["useCallback"])(async query=>{try{const recipientGroups=await servicesContext.notificationService.getRecipientGroups(getQueryObject("email_group",query));setRecipientGroupOptions(recipientGroups.items.map(recipientGroup=>({label:recipientGroup.name,value:recipientGroup.config_id})))}catch(error){coreContext.notifications.toasts.addDanger(getErrorMessage(error,"There was a problem loading recipient groups."))}},[]);Object(external_osdSharedDeps_React_["useEffect"])(()=>{refreshSenders();refreshRecipientGroups()},[]);return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,smtpAvailable&&external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Sender type"},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiRadioGroup"],{options:[{id:"smtp_account",label:"SMTP sender"},{id:"ses_account",label:"SES sender"}],idSelected:props.senderType,onChange:id=>props.setSenderType(id),name:"sender type radio group"})),props.senderType==="ses_account"?external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{style:{maxWidth:400}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"SES sender",helpText:'A destination only allows one SMTP or SES sender. Use "Create SES sender" to create a sender with its email address, IAM role, AWS region.',error:context.inputErrors.sesSender.join(" "),isInvalid:context.inputErrors.sesSender.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiComboBox"],{placeholder:"Sender name",fullWidth:true,singleSelection:true,options:sesSenderOptions,selectedOptions:props.selectedSesSenderOptions,onChange:props.setSelectedSesSenderOptions,isClearable:true,isInvalid:context.inputErrors.sesSender.length>0,onBlur:()=>{context.setInputErrors({...context.inputErrors,sesSender:validateEmailSender(props.selectedSesSenderOptions)})}}))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true},external_osdSharedDeps_React_default.a.createElement(ModalConsumer,null,_ref=>{let{onShow:onShow}=_ref;return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>onShow(CreateSESSenderModal,{addSenderOptionAndSelect:newOption=>{setSesSenderOptions([...sesSenderOptions,newOption]);props.setSelectedSesSenderOptions([newOption]);context.setInputErrors({...context.inputErrors,sesSender:validateEmailSender([newOption])})}})},"Create SES sender")}))))):external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{style:{maxWidth:400}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"SMTP sender",helpText:'A destination only allows one SMTP or SES sender. Use "Create SMTP sender" to create a sender with its email address, host, port, encryption method.',error:context.inputErrors.smtpSender.join(" "),isInvalid:context.inputErrors.smtpSender.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiComboBox"],{placeholder:"Sender name",fullWidth:true,singleSelection:true,options:smtpSenderOptions,selectedOptions:props.selectedSmtpSenderOptions,onChange:props.setSelectedSmtpSenderOptions,isClearable:true,isInvalid:context.inputErrors.smtpSender.length>0,onBlur:()=>{context.setInputErrors({...context.inputErrors,smtpSender:validateEmailSender(props.selectedSmtpSenderOptions)})}}))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true},external_osdSharedDeps_React_default.a.createElement(ModalConsumer,null,_ref2=>{let{onShow:onShow}=_ref2;return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>onShow(CreateSenderModal,{addSenderOptionAndSelect:newOption=>{setSmtpSenderOptions([...smtpSenderOptions,newOption]);props.setSelectedSmtpSenderOptions([newOption]);context.setInputErrors({...context.inputErrors,smtpSender:validateEmailSender([newOption])})}})},"Create SMTP sender")}))))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{style:{maxWidth:400}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Default recipients",helpText:'Add recipient(s) using an email address or pre-created email group. Use "Create email group" to create an email group.',error:context.inputErrors.recipients.join(" "),isInvalid:context.inputErrors.recipients.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiComboBox"],{placeholder:"Email address, recipient group name",fullWidth:true,options:recipientGroupOptions,selectedOptions:props.selectedRecipientGroupOptions,onChange:props.setSelectedRecipientGroupOptions,onCreateOption:(searchValue,flattenedOptions)=>onComboBoxCreateOption(searchValue,flattenedOptions,recipientGroupOptions,setRecipientGroupOptions,props.selectedRecipientGroupOptions,props.setSelectedRecipientGroupOptions,options=>context.setInputErrors({...context.inputErrors,recipients:validateRecipients(options)})),customOptionText:"Add {searchValue} as a default recipient",isClearable:true,isInvalid:context.inputErrors.recipients.length>0,onBlur:()=>{context.setInputErrors({...context.inputErrors,recipients:validateRecipients(props.selectedRecipientGroupOptions)})}}))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true},external_osdSharedDeps_React_default.a.createElement(ModalConsumer,null,_ref3=>{let{onShow:onShow}=_ref3;return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>onShow(CreateRecipientGroupModal,{addRecipientGroupOptionAndSelect:newOption=>{setRecipientGroupOptions([...recipientGroupOptions,newOption]);props.setSelectedRecipientGroupOptions([...props.selectedRecipientGroupOptions,newOption]);context.setInputErrors({...context.inputErrors,recipients:validateRecipients([newOption])})}})},"Create recipient group")})))))}function SlackSettings(props){const context=Object(external_osdSharedDeps_React_["useContext"])(CreateChannelContext);return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Slack webhook URL",style:{maxWidth:"700px"},error:context.inputErrors.slackWebhook.join(" "),isInvalid:context.inputErrors.slackWebhook.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{fullWidth:true,"data-test-subj":"create-channel-slack-webhook-input",placeholder:"https://hooks.slack.com/services/XXXXX/XXXXX/XXXXX...",value:props.slackWebhook,onChange:e=>props.setSlackWebhook(e.target.value),isInvalid:context.inputErrors.slackWebhook.length>0,onBlur:()=>{context.setInputErrors({...context.inputErrors,slackWebhook:validateWebhookURL(props.slackWebhook)})}}))}function SNSSettings(props){const context=Object(external_osdSharedDeps_React_["useContext"])(CreateChannelContext);const mainStateContext=Object(external_osdSharedDeps_React_["useContext"])(MainContext);return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"SNS topic ARN",error:context.inputErrors.topicArn.join(" "),isInvalid:context.inputErrors.topicArn.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:"ARN key","data-test-subj":"sns-settings-topic-arn-input",value:props.topicArn,onChange:e=>props.setTopicArn(e.target.value),isInvalid:context.inputErrors.topicArn.length>0,onBlur:()=>{context.setInputErrors({...context.inputErrors,topicArn:validateArn(props.topicArn)})}})),mainStateContext.tooltipSupport?external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:external_osdSharedDeps_React_default.a.createElement("span",null,"IAM role ARN - ",external_osdSharedDeps_React_default.a.createElement("i",{style:{fontWeight:"normal"}},"optional"))},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued"},"IAM role ARN can only be used for clusters running on AWS network."),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{"data-test-subj":"sns-settings-role-arn-input",placeholder:"ARN key",value:props.roleArn,onChange:e=>props.setRoleArn(e.target.value)}))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiCallOut"],{title:"Using Amazon SNS outside of AWS",style:{maxWidth:720}},external_osdSharedDeps_React_default.a.createElement("div",null,"If your cluster is not running on AWS, you must configure aws credentials on your OpenSearch cluster."," ",external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiLink"],{href:DOCUMENTATION_LINK,target:"_blank",external:true},"Learn more")))):external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"IAM role ARN",error:context.inputErrors.roleArn.join(" "),isInvalid:context.inputErrors.roleArn.length>0},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:"ARN key","data-test-subj":"sns-settings-role-arn-input",value:props.roleArn,onChange:e=>props.setRoleArn(e.target.value),isInvalid:context.inputErrors.roleArn.length>0,onBlur:()=>{context.setInputErrors({...context.inputErrors,roleArn:validateArn(props.roleArn)})}})))}const CreateChannelContext=Object(external_osdSharedDeps_React_["createContext"])(null);function CreateChannel(props){const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);const servicesContext=Object(external_osdSharedDeps_React_["useContext"])(ServicesContext);const mainStateContext=Object(external_osdSharedDeps_React_["useContext"])(MainContext);const id=props.match.params.id;const prevURL=props.edit&&query_string_default.a.parse(props.location.search).from==="details"?"#".concat(ROUTES.CHANNEL_DETAILS,"/").concat(id):"#".concat(ROUTES.CHANNELS);const[isEnabled,setIsEnabled]=Object(external_osdSharedDeps_React_["useState"])(true);const[loading,setLoading]=Object(external_osdSharedDeps_React_["useState"])(false);const[name,setName]=Object(external_osdSharedDeps_React_["useState"])("");const[description,setDescription]=Object(external_osdSharedDeps_React_["useState"])("");const channelTypeOptions=Object.entries(mainStateContext.availableChannels).map(_ref=>{let[key,value]=_ref;return{value:key,inputDisplay:value}});const[channelType,setChannelType]=Object(external_osdSharedDeps_React_["useState"])(channelTypeOptions[0].value);const[slackWebhook,setSlackWebhook]=Object(external_osdSharedDeps_React_["useState"])("");const[chimeWebhook,setChimeWebhook]=Object(external_osdSharedDeps_React_["useState"])("");const[microsoftTeamsWebhook,setMicrosoftTeamsWebhook]=Object(external_osdSharedDeps_React_["useState"])("");const[senderType,setSenderType]=Object(external_osdSharedDeps_React_["useState"])("smtp_account");const[selectedSmtpSenderOptions,setSelectedSmtpSenderOptions]=Object(external_osdSharedDeps_React_["useState"])([]);const[selectedSesSenderOptions,setSelectedSesSenderOptions]=Object(external_osdSharedDeps_React_["useState"])([]);const[selectedRecipientGroupOptions,setSelectedRecipientGroupOptions]=Object(external_osdSharedDeps_React_["useState"])([]);const[webhookTypeIdSelected,setWebhookTypeIdSelected]=Object(external_osdSharedDeps_React_["useState"])("WEBHOOK_URL");const[webhookURL,setWebhookURL]=Object(external_osdSharedDeps_React_["useState"])("");const[customURLType,setCustomURLType]=Object(external_osdSharedDeps_React_["useState"])("HTTPS");const[customURLHost,setCustomURLHost]=Object(external_osdSharedDeps_React_["useState"])("");const[customURLPort,setCustomURLPort]=Object(external_osdSharedDeps_React_["useState"])("");const[customURLPath,setCustomURLPath]=Object(external_osdSharedDeps_React_["useState"])("");const[webhookMethod,setWebhookMethod]=Object(external_osdSharedDeps_React_["useState"])("POST");const[webhookParams,setWebhookParams]=Object(external_osdSharedDeps_React_["useState"])([]);const[webhookHeaders,setWebhookHeaders]=Object(external_osdSharedDeps_React_["useState"])([{key:"Content-Type",value:"application/json"}]);const[topicArn,setTopicArn]=Object(external_osdSharedDeps_React_["useState"])("");const[roleArn,setRoleArn]=Object(external_osdSharedDeps_React_["useState"])("");const[inputErrors,setInputErrors]=Object(external_osdSharedDeps_React_["useState"])({name:[],slackWebhook:[],chimeWebhook:[],microsoftTeamsWebhook:[],smtpSender:[],sesSender:[],recipients:[],webhookURL:[],customURLHost:[],customURLPort:[],topicArn:[],roleArn:[]});Object(external_osdSharedDeps_React_["useEffect"])(()=>{coreContext.chrome.setBreadcrumbs([BREADCRUMBS.NOTIFICATIONS,BREADCRUMBS.CHANNELS,props.edit?BREADCRUMBS.EDIT_CHANNEL:BREADCRUMBS.CREATE_CHANNEL]);window.scrollTo(0,0);if(props.edit){getChannel()}},[]);const getChannel=async()=>{const id=props.match.params.id;if(typeof id!=="string")return;try{const response=await servicesContext.notificationService.getChannel(id).then(async response=>{if(response.config_type==="email"){var _channel$email;const channel=await servicesContext.notificationService.getEmailConfigDetails(response);if((_channel$email=channel.email)!==null&&_channel$email!==void 0&&(_channel$email=_channel$email.invalid_ids)!==null&&_channel$email!==void 0&&_channel$email.length){coreContext.notifications.toasts.addDanger("The sender and/or some recipient groups might have been deleted.")}return channel}return response});const type=response.config_type;setIsEnabled(response.is_enabled);setName(response.name);setDescription(response.description||"");setChannelType(type);if(type===BACKEND_CHANNEL_TYPE.SLACK){var _response$slack;setSlackWebhook(((_response$slack=response.slack)===null||_response$slack===void 0?void 0:_response$slack.url)||"")}else if(type===BACKEND_CHANNEL_TYPE.CHIME){var _response$chime;setChimeWebhook(((_response$chime=response.chime)===null||_response$chime===void 0?void 0:_response$chime.url)||"")}else if(type===BACKEND_CHANNEL_TYPE.MICROSOFT_TEAMS){var _response$microsoft_t;setMicrosoftTeamsWebhook(((_response$microsoft_t=response.microsoft_teams)===null||_response$microsoft_t===void 0?void 0:_response$microsoft_t.url)||"")}else if(type===BACKEND_CHANNEL_TYPE.EMAIL){const emailObject=deconstructEmailObject(response.email);setSenderType(emailObject.senderType);if(emailObject.senderType==="smtp_account"){setSelectedSmtpSenderOptions(emailObject.selectedSenderOptions)}else{setSelectedSesSenderOptions(emailObject.selectedSenderOptions)}setSelectedRecipientGroupOptions(emailObject.selectedRecipientGroupOptions)}else if(type===BACKEND_CHANNEL_TYPE.CUSTOM_WEBHOOK){const webhookObject=deconstructWebhookObject(response.webhook);setWebhookURL(webhookObject.webhookURL);setCustomURLHost(webhookObject.customURLHost);setCustomURLPort(webhookObject.customURLPort);setCustomURLPath(webhookObject.customURLPath);setWebhookMethod(webhookObject.webhookMethod);setWebhookParams(webhookObject.webhookParams);setWebhookHeaders(webhookObject.webhookHeaders)}else if(type===BACKEND_CHANNEL_TYPE.SNS){var _response$sns,_response$sns2;setTopicArn(((_response$sns=response.sns)===null||_response$sns===void 0?void 0:_response$sns.topic_arn)||"");setRoleArn(((_response$sns2=response.sns)===null||_response$sns2===void 0?void 0:_response$sns2.role_arn)||"")}}catch(error){coreContext.notifications.toasts.addDanger(getErrorMessage(error,"There was a problem loading channel."))}};const isInputValid=()=>{const errors={name:validateChannelName(name),slackWebhook:[],chimeWebhook:[],microsoftTeamsWebhook:[],smtpSender:[],sesSender:[],recipients:[],webhookURL:[],customURLHost:[],customURLPort:[],topicArn:[],roleArn:[]};if(channelType===BACKEND_CHANNEL_TYPE.SLACK){errors.slackWebhook=validateWebhookURL(slackWebhook)}else if(channelType===BACKEND_CHANNEL_TYPE.CHIME){errors.chimeWebhook=validateWebhookURL(chimeWebhook)}else if(channelType===BACKEND_CHANNEL_TYPE.MICROSOFT_TEAMS){errors.microsoftTeamsWebhook=validateWebhookURL(microsoftTeamsWebhook)}else if(channelType===BACKEND_CHANNEL_TYPE.EMAIL){if(senderType==="smtp_account"){errors.smtpSender=validateEmailSender(selectedSmtpSenderOptions)}else{errors.sesSender=validateEmailSender(selectedSesSenderOptions)}errors.recipients=validateRecipients(selectedRecipientGroupOptions)}else if(channelType===BACKEND_CHANNEL_TYPE.CUSTOM_WEBHOOK){if(webhookTypeIdSelected==="WEBHOOK_URL"){errors.webhookURL=validateWebhookURL(webhookURL)}else{errors.customURLHost=validateCustomURLHost(customURLHost);errors.customURLPort=validateCustomURLPort(customURLPort)}}else if(channelType===BACKEND_CHANNEL_TYPE.SNS){errors.topicArn=validateArn(topicArn);if(!mainStateContext.tooltipSupport)errors.roleArn=validateArn(roleArn)}setInputErrors(errors);return!Object.values(errors).reduce((errorFlag,error)=>errorFlag||error.length>0,false)};const createConfigObject=()=>{const config={name:name,description:description,config_type:channelType,is_enabled:isEnabled};if(channelType===BACKEND_CHANNEL_TYPE.SLACK){config.slack={url:slackWebhook}}else if(channelType===BACKEND_CHANNEL_TYPE.CHIME){config.chime={url:chimeWebhook}}else if(channelType===BACKEND_CHANNEL_TYPE.MICROSOFT_TEAMS){config.microsoft_teams={url:microsoftTeamsWebhook}}else if(channelType===BACKEND_CHANNEL_TYPE.CUSTOM_WEBHOOK){config.webhook=constructWebhookObject(webhookTypeIdSelected,webhookURL,customURLType,customURLHost,customURLPort,customURLPath,webhookMethod,webhookParams,webhookHeaders)}else if(channelType===BACKEND_CHANNEL_TYPE.EMAIL){if(senderType==="smtp_account"){config.email=constructEmailObject(selectedSmtpSenderOptions,selectedRecipientGroupOptions)}else{config.email=constructEmailObject(selectedSesSenderOptions,selectedRecipientGroupOptions)}}else if(channelType===BACKEND_CHANNEL_TYPE.SNS){config.sns={topic_arn:topicArn,...roleArn&&{role_arn:roleArn}}}return config};const sendTestMessage=async()=>{const config=createConfigObject();config.name="temp-"+config.name;let tempChannelId;try{tempChannelId=await servicesContext.notificationService.createConfig(config).then(response=>{console.info("Created temporary channel to test send message:",response);return response.config_id}).catch(error=>{error.message="Failed to create temporary channel for test message. "+error.message;throw error});await servicesContext.notificationService.sendTestMessage(tempChannelId);coreContext.notifications.toasts.addSuccess("Successfully sent a test message.")}catch(error){coreContext.notifications.toasts.addError((error===null||error===void 0?void 0:error.body)||error,{title:"Failed to send the test message.",toastMessage:"View error details and adjust the channel settings."})}finally{if(tempChannelId){servicesContext.notificationService.deleteConfigs([tempChannelId]).then(response=>{console.info("Deleted temporary channel:",response)}).catch(error=>{coreContext.notifications.toasts.addError((error===null||error===void 0?void 0:error.body)||error,{title:"Failed to delete temporary channel for test message."})})}}};return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(CreateChannelContext.Provider,{value:{edit:props.edit,inputErrors:inputErrors,setInputErrors:setInputErrors}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiTitle"],{size:"l"},external_osdSharedDeps_React_default.a.createElement("h1",null,"".concat(props.edit?"Edit":"Create"," channel"))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(ChannelNamePanel,{name:name,setName:setName,description:description,setDescription:setDescription}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(ContentPanel_ContentPanel,{bodyStyles:{padding:"initial"},title:"Configurations",titleSize:"s"},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFormRow"],{label:"Channel type"},props.edit?external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],{size:"s"},CHANNEL_TYPE[channelType]):external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued"},"Channel type cannot be changed after the channel is created."),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSuperSelect"],{options:channelTypeOptions,valueOfSelected:channelType,onChange:setChannelType,disabled:props.edit}))),channelType===BACKEND_CHANNEL_TYPE.SLACK?external_osdSharedDeps_React_default.a.createElement(SlackSettings,{slackWebhook:slackWebhook,setSlackWebhook:setSlackWebhook}):channelType===BACKEND_CHANNEL_TYPE.CHIME?external_osdSharedDeps_React_default.a.createElement(ChimeSettings,{chimeWebhook:chimeWebhook,setChimeWebhook:setChimeWebhook}):channelType===BACKEND_CHANNEL_TYPE.MICROSOFT_TEAMS?external_osdSharedDeps_React_default.a.createElement(MicrosoftTeamsSettings,{microsoftTeamsWebhook:microsoftTeamsWebhook,setMicrosoftTeamsWebhook:setMicrosoftTeamsWebhook}):channelType===BACKEND_CHANNEL_TYPE.EMAIL?external_osdSharedDeps_React_default.a.createElement(EmailSettings,{senderType:senderType,setSenderType:setSenderType,selectedSmtpSenderOptions:selectedSmtpSenderOptions,setSelectedSmtpSenderOptions:setSelectedSmtpSenderOptions,selectedSesSenderOptions:selectedSesSenderOptions,setSelectedSesSenderOptions:setSelectedSesSenderOptions,selectedRecipientGroupOptions:selectedRecipientGroupOptions,setSelectedRecipientGroupOptions:setSelectedRecipientGroupOptions}):channelType===BACKEND_CHANNEL_TYPE.CUSTOM_WEBHOOK?external_osdSharedDeps_React_default.a.createElement(CustomWebhookSettings,{webhookTypeIdSelected:webhookTypeIdSelected,setWebhookTypeIdSelected:setWebhookTypeIdSelected,webhookURL:webhookURL,setWebhookURL:setWebhookURL,customURLType:customURLType,setCustomURLType:setCustomURLType,customURLHost:customURLHost,setCustomURLHost:setCustomURLHost,customURLPort:customURLPort,setCustomURLPort:setCustomURLPort,customURLPath:customURLPath,setCustomURLPath:setCustomURLPath,webhookMethod:webhookMethod,setWebhookMethod:setWebhookMethod,webhookParams:webhookParams,setWebhookParams:setWebhookParams,webhookHeaders:webhookHeaders,setWebhookHeaders:setWebhookHeaders}):channelType===BACKEND_CHANNEL_TYPE.SNS?external_osdSharedDeps_React_default.a.createElement(SNSSettings,{topicArn:topicArn,setTopicArn:setTopicArn,roleArn:roleArn,setRoleArn:setRoleArn}):null),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"m",justifyContent:"flexEnd"},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButtonEmpty"],{href:prevURL},"Cancel")),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"create-channel-send-test-message-button",onClick:()=>{if(!isInputValid()){coreContext.notifications.toasts.addDanger("Some fields are invalid. Fix all highlighted error(s) before continuing.");return}sendTestMessage()}},"Send test message")),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{fill:true,"data-test-subj":"create-channel-create-button",isLoading:loading,onClick:async()=>{if(!isInputValid()){coreContext.notifications.toasts.addDanger("Some fields are invalid. Fix all highlighted error(s) before continuing.");return}setLoading(true);const config=createConfigObject();const request=props.edit?servicesContext.notificationService.updateConfig(id,config):servicesContext.notificationService.createConfig(config);await request.then(response=>{coreContext.notifications.toasts.addSuccess("Channel ".concat(name," successfully ").concat(props.edit?"updated":"created","."));setTimeout(()=>location.hash=prevURL,common["c"])}).catch(error=>{setLoading(false);coreContext.notifications.toasts.addError((error===null||error===void 0?void 0:error.body)||error,{title:"Failed to ".concat(props.edit?"update":"create"," channel.")})})}},props.edit?"Save":"Create")))))}function CreateRecipientGroup(props){const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);const servicesContext=Object(external_osdSharedDeps_React_["useContext"])(ServicesContext);const[loading,setLoading]=Object(external_osdSharedDeps_React_["useState"])(false);const[name,setName]=Object(external_osdSharedDeps_React_["useState"])("");const[description,setDescription]=Object(external_osdSharedDeps_React_["useState"])("");const[selectedEmailOptions,setSelectedEmailOptions]=Object(external_osdSharedDeps_React_["useState"])([]);const[emailOptions,setEmailOptions]=Object(external_osdSharedDeps_React_["useState"])([{label:"no-reply@company.com"}]);const[inputErrors,setInputErrors]=Object(external_osdSharedDeps_React_["useState"])({name:[],emailOptions:[]});const isInputValid=()=>{const errors={name:validateRecipientGroupName(name),emailOptions:validateRecipientGroupEmails(selectedEmailOptions)};setInputErrors(errors);return!Object.values(errors).reduce((errorFlag,error)=>errorFlag||error.length>0,false)};Object(external_osdSharedDeps_React_["useEffect"])(()=>{coreContext.chrome.setBreadcrumbs([BREADCRUMBS.NOTIFICATIONS,BREADCRUMBS.EMAIL_GROUPS,props.edit?BREADCRUMBS.EDIT_RECIPIENT_GROUP:BREADCRUMBS.CREATE_RECIPIENT_GROUP]);window.scrollTo(0,0);if(props.edit){getRecipientGroup()}},[]);const getRecipientGroup=async()=>{var _props$match$params;const id=(_props$match$params=props.match.params)===null||_props$match$params===void 0?void 0:_props$match$params.id;if(typeof id!=="string")return;try{const response=await servicesContext.notificationService.getRecipientGroup(id);setName(response.name);setDescription(response.description||"");setSelectedEmailOptions(response.email_group.recipient_list.map(recipient=>({label:recipient.recipient})))}catch(error){coreContext.notifications.toasts.addDanger(getErrorMessage(error,"There was a problem loading recipient group."))}};return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiTitle"],{size:"l"},external_osdSharedDeps_React_default.a.createElement("h1",null,"".concat(props.edit?"Edit":"Create"," recipient group"))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(ContentPanel_ContentPanel,{bodyStyles:{padding:"initial"},title:"Configure recipient group",titleSize:"s",panelStyles:{maxWidth:1e3}},external_osdSharedDeps_React_default.a.createElement(CreateRecipientGroupForm,{name:name,setName:setName,description:description,setDescription:setDescription,selectedEmailOptions:selectedEmailOptions,setSelectedEmailOptions:setSelectedEmailOptions,emailOptions:emailOptions,setEmailOptions:setEmailOptions,inputErrors:inputErrors,setInputErrors:setInputErrors})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd",style:{maxWidth:1024}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButtonEmpty"],{href:"#".concat(ROUTES.EMAIL_GROUPS)},"Cancel")),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{fill:true,isLoading:loading,onClick:async()=>{if(!isInputValid()){coreContext.notifications.toasts.addDanger("Some fields are invalid. Fix all highlighted error(s) before continuing.");return}setLoading(true);const config=createRecipientGroupConfigObject(name,description,selectedEmailOptions);const request=props.edit?servicesContext.notificationService.updateConfig(props.match.params.id,config):servicesContext.notificationService.createConfig(config);await request.then(response=>{coreContext.notifications.toasts.addSuccess("Recipient group ".concat(name," successfully ").concat(props.edit?"updated":"created","."));setTimeout(()=>location.hash="#".concat(ROUTES.EMAIL_GROUPS),common["c"])}).catch(error=>{setLoading(false);coreContext.notifications.toasts.addError((error===null||error===void 0?void 0:error.body)||error,{title:"Failed to ".concat(props.edit?"update":"create"," recipient group.")})})}},props.edit?"Save":"Create"))))}function CreateSender(props){const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);const servicesContext=Object(external_osdSharedDeps_React_["useContext"])(ServicesContext);const[loading,setLoading]=Object(external_osdSharedDeps_React_["useState"])(false);const[senderName,setSenderName]=Object(external_osdSharedDeps_React_["useState"])("");const[email,setEmail]=Object(external_osdSharedDeps_React_["useState"])("");const[host,setHost]=Object(external_osdSharedDeps_React_["useState"])("");const[port,setPort]=Object(external_osdSharedDeps_React_["useState"])("");const[encryption,setEncryption]=Object(external_osdSharedDeps_React_["useState"])(Object.keys(ENCRYPTION_TYPE)[0]);const[inputErrors,setInputErrors]=Object(external_osdSharedDeps_React_["useState"])({senderName:[],email:[],host:[],port:[]});Object(external_osdSharedDeps_React_["useEffect"])(()=>{coreContext.chrome.setBreadcrumbs([BREADCRUMBS.NOTIFICATIONS,BREADCRUMBS.EMAIL_SENDERS,props.edit?BREADCRUMBS.EDIT_SENDER:BREADCRUMBS.CREATE_SENDER]);window.scrollTo(0,0);if(props.edit){getSender()}},[]);const getSender=async()=>{var _props$match$params;const id=(_props$match$params=props.match.params)===null||_props$match$params===void 0?void 0:_props$match$params.id;if(typeof id!=="string")return;try{const response=await servicesContext.notificationService.getSender(id);setSenderName(response.name);setEmail(response.smtp_account.from_address);setHost(response.smtp_account.host);setPort(response.smtp_account.port);setEncryption(response.smtp_account.method)}catch(error){coreContext.notifications.toasts.addDanger(getErrorMessage(error,"There was a problem loading sender."))}};const isInputValid=()=>{const errors={senderName:validateSenderName(senderName),email:validateEmail(email),host:validateHost(host),port:validatePort(port)};setInputErrors(errors);return!Object.values(errors).reduce((errorFlag,error)=>errorFlag||error.length>0,false)};return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiTitle"],{size:"l"},external_osdSharedDeps_React_default.a.createElement("h1",null,"".concat(props.edit?"Edit":"Create"," SMTP sender"))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(ContentPanel_ContentPanel,{bodyStyles:{padding:"initial"},title:"Configure sender",titleSize:"s",panelStyles:{maxWidth:1e3}},external_osdSharedDeps_React_default.a.createElement(CreateSenderForm,{senderName:senderName,setSenderName:setSenderName,email:email,setEmail:setEmail,host:host,setHost:setHost,port:port,setPort:setPort,encryption:encryption,setEncryption:setEncryption,inputErrors:inputErrors,setInputErrors:setInputErrors})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd",style:{maxWidth:1024}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButtonEmpty"],{href:"#".concat(ROUTES.EMAIL_SENDERS)},"Cancel")),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{fill:true,isLoading:loading,onClick:async()=>{if(!isInputValid()){coreContext.notifications.toasts.addDanger("Some fields are invalid. Fix all highlighted error(s) before continuing.");return}setLoading(true);const config=createSenderConfigObject(senderName,host,port,encryption,email);const request=props.edit?servicesContext.notificationService.updateConfig(props.match.params.id,config):servicesContext.notificationService.createConfig(config);await request.then(response=>{coreContext.notifications.toasts.addSuccess("Sender ".concat(senderName," successfully ").concat(props.edit?"updated":"created","."));setTimeout(()=>location.hash="#".concat(ROUTES.EMAIL_SENDERS),common["c"])}).catch(error=>{setLoading(false);coreContext.notifications.toasts.addError((error===null||error===void 0?void 0:error.body)||error,{title:"Failed to ".concat(props.edit?"update":"create"," sender.")})})}},props.edit?"Save":"Create"))))}function CreateSESSender(props){const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);const servicesContext=Object(external_osdSharedDeps_React_["useContext"])(ServicesContext);const mainStateContext=Object(external_osdSharedDeps_React_["useContext"])(MainContext);const[loading,setLoading]=Object(external_osdSharedDeps_React_["useState"])(false);const[senderName,setSenderName]=Object(external_osdSharedDeps_React_["useState"])("");const[email,setEmail]=Object(external_osdSharedDeps_React_["useState"])("");const[roleArn,setRoleArn]=Object(external_osdSharedDeps_React_["useState"])("");const[awsRegion,setAwsRegion]=Object(external_osdSharedDeps_React_["useState"])("");const[inputErrors,setInputErrors]=Object(external_osdSharedDeps_React_["useState"])({senderName:[],email:[],roleArn:[],awsRegion:[]});Object(external_osdSharedDeps_React_["useEffect"])(()=>{coreContext.chrome.setBreadcrumbs([BREADCRUMBS.NOTIFICATIONS,BREADCRUMBS.EMAIL_SENDERS,props.edit?BREADCRUMBS.EDIT_SES_SENDER:BREADCRUMBS.CREATE_SES_SENDER]);window.scrollTo(0,0);if(props.edit){getSESSender()}},[]);const getSESSender=async()=>{var _props$match$params;const id=(_props$match$params=props.match.params)===null||_props$match$params===void 0?void 0:_props$match$params.id;if(typeof id!=="string")return;try{const response=await servicesContext.notificationService.getSESSender(id);setSenderName(response.name);setEmail(response.ses_account.from_address);setRoleArn(response.ses_account.role_arn||"");setAwsRegion(response.ses_account.region)}catch(error){coreContext.notifications.toasts.addDanger(getErrorMessage(error,"There was a problem loading sender."))}};const isInputValid=()=>{const errors={senderName:validateSenderName(senderName),email:validateEmail(email),awsRegion:validateAwsRegion(awsRegion),roleArn:[]};if(!mainStateContext.tooltipSupport){errors.roleArn=validateRoleArn(roleArn)}setInputErrors(errors);return!Object.values(errors).reduce((errorFlag,error)=>errorFlag||error.length>0,false)};return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiTitle"],{size:"l"},external_osdSharedDeps_React_default.a.createElement("h1",null,"".concat(props.edit?"Edit":"Create"," SES sender"))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(ContentPanel_ContentPanel,{bodyStyles:{padding:"initial"},title:"Configure sender",titleSize:"s",panelStyles:{maxWidth:1e3}},external_osdSharedDeps_React_default.a.createElement(CreateSESSenderForm,{senderName:senderName,setSenderName:setSenderName,email:email,setEmail:setEmail,roleArn:roleArn,setRoleArn:setRoleArn,awsRegion:awsRegion,setAwsRegion:setAwsRegion,inputErrors:inputErrors,setInputErrors:setInputErrors})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd",style:{maxWidth:1024}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButtonEmpty"],{href:"#".concat(ROUTES.EMAIL_SENDERS)},"Cancel")),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{fill:true,isLoading:loading,onClick:async()=>{if(!isInputValid()){coreContext.notifications.toasts.addDanger("Some fields are invalid. Fix all highlighted error(s) before continuing.");return}setLoading(true);const config=createSesSenderConfigObject(senderName,email,awsRegion,roleArn);const request=props.edit?servicesContext.notificationService.updateConfig(props.match.params.id,config):servicesContext.notificationService.createConfig(config);await request.then(response=>{coreContext.notifications.toasts.addSuccess("Sender ".concat(senderName," successfully ").concat(props.edit?"updated":"created","."));setTimeout(()=>location.hash="#".concat(ROUTES.EMAIL_SENDERS),common["c"])}).catch(error=>{setLoading(false);coreContext.notifications.toasts.addError((error===null||error===void 0?void 0:error.body)||error,{title:"Failed to ".concat(props.edit?"update":"create"," sender.")})})}},props.edit?"Save":"Create"))))}const DeleteRecipientGroupModal=props=>{if(!props.recipientGroups.length)return null;const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);const[input,setInput]=Object(external_osdSharedDeps_React_["useState"])("");const num=props.recipientGroups.length;const name=num>=2?"".concat(num," recipient groups"):props.recipientGroups[0].name;const message="Delete ".concat(num>=2?"the following recipient groups":name," permanently? Any channels using ").concat(num>=2?"these email recipient groups":"this email recipient group"," will not be able to receive notifications.");return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiOverlayMask"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModal"],{onClose:props.onClose,maxWidth:500},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeader"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,"Delete ".concat(name,"?"))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalBody"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],null,message),num>=2&&external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),props.recipientGroups.map((recipientGroup,i)=>external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],{key:"recipient-groups-list-item-".concat(i),style:{marginLeft:20}},external_osdSharedDeps_React_default.a.createElement("li",null,recipientGroup.name)))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],null,"To confirm delete, type ",external_osdSharedDeps_React_default.a.createElement("i",null,"delete")," in the field."),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:"delete",value:input,onChange:e=>setInput(e.target.value)})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalFooter"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd"},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:props.onClose},"Cancel")),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"delete-recipient-group-modal-delete-button",fill:true,color:"danger",onClick:async()=>{props.services.notificationService.deleteConfigs(props.recipientGroups.map(recipientGroup=>recipientGroup.config_id)).then(resp=>{coreContext.notifications.toasts.addSuccess("".concat(props.recipientGroups.length>1?props.recipientGroups.length+" recipient groups":"Recipient group "+props.recipientGroups[0].name," successfully deleted."));props.onClose();setTimeout(()=>props.refresh(),common["c"])}).catch(error=>{coreContext.notifications.toasts.addError((error===null||error===void 0?void 0:error.body)||error,{title:"Failed to delete one or more recipient groups."});props.onClose()})},disabled:input!=="delete"},"Delete"))))))};function RecipientGroupsTable_defineProperty(obj,key,value){key=RecipientGroupsTable_toPropertyKey(key);if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function RecipientGroupsTable_toPropertyKey(arg){var key=RecipientGroupsTable_toPrimitive(arg,"string");return typeof key==="symbol"?key:String(key)}function RecipientGroupsTable_toPrimitive(input,hint){if(typeof input!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(typeof res!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.")}return(hint==="string"?String:Number)(input)}class RecipientGroupsTable_RecipientGroupsTable extends external_osdSharedDeps_React_["Component"]{constructor(props){super(props);RecipientGroupsTable_defineProperty(this,"columns",void 0);RecipientGroupsTable_defineProperty(this,"onTableChange",_ref=>{let{page:tablePage,sort:sort}=_ref;const{index:page,size:size}=tablePage;const{field:sortField,direction:sortDirection}=sort;this.setState({from:page*size,size:size,sortField:sortField,sortDirection:sortDirection})});RecipientGroupsTable_defineProperty(this,"onSelectionChange",selectedItems=>{this.setState({selectedItems:selectedItems})});RecipientGroupsTable_defineProperty(this,"onSearchChange",search=>{this.setState({from:0,search:search})});this.state={total:0,from:0,size:5,search:"",sortField:"name",sortDirection:external_osdSharedDeps_ElasticEui_["SortDirection"].ASC,items:[],selectedItems:[],loading:true};this.columns=[{field:"name",name:"Name",sortable:true,truncateText:true,width:"150px"},{field:"email_group.recipient_list",name:"Email addresses",sortable:true,truncateText:true,width:"450px",render:recipient_list=>{const emails=recipient_list.map(recipient=>recipient.recipient);return external_osdSharedDeps_React_default.a.createElement("div",null,emails.slice(0,5).join(", "),emails.length>5&&external_osdSharedDeps_React_default.a.createElement("span",null," ",external_osdSharedDeps_React_default.a.createElement(ModalConsumer,null,_ref2=>{let{onShow:onShow}=_ref2;return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>onShow(DetailsListModal,{header:"Email addresses (".concat(emails.length,")"),title:"Email addresses",items:emails})},emails.length-5," more")})))}},{field:"description",name:"Description",sortable:true,truncateText:true,width:"300px",render:description=>description||"-"}];this.refresh=this.refresh.bind(this)}async componentDidMount(){await this.refresh()}async componentDidUpdate(prevProps,prevState){const prevQuery=RecipientGroupsTable_RecipientGroupsTable.getQueryObjectFromState(prevState);const currQuery=RecipientGroupsTable_RecipientGroupsTable.getQueryObjectFromState(this.state);if(!external_osdSharedDeps_Lodash_default.a.isEqual(prevQuery,currQuery)){await this.refresh()}if(isDataSourceChanged(this.props,prevProps)){await this.refresh()}}static getQueryObjectFromState(state){return{from_index:state.from,max_items:state.size,query:state.search,config_type:"email_group",sort_field:state.sortField,sort_order:state.sortDirection}}async refresh(){this.setState({loading:true});try{const queryObject=RecipientGroupsTable_RecipientGroupsTable.getQueryObjectFromState(this.state);const recipientGroups=await this.context.notificationService.getRecipientGroups(queryObject);this.setState({items:recipientGroups.items,total:recipientGroups.total})}catch(error){if(isDataSourceError(error)){this.setState({items:[],total:0})}this.props.coreContext.notifications.toasts.addDanger(getErrorMessage(error,"There was a problem loading recipient groups."))}this.setState({loading:false})}render(){const page=Math.floor(this.state.from/this.state.size);const pagination={pageIndex:page,pageSize:this.state.size,pageSizeOptions:DEFAULT_PAGE_SIZE_OPTIONS,totalItemCount:this.state.total};const sorting={sort:{direction:this.state.sortDirection,field:this.state.sortField}};const selection={selectable:()=>true,onSelectionChange:this.onSelectionChange};return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(ContentPanel_ContentPanel,{actions:external_osdSharedDeps_React_default.a.createElement(ContentPanel_ContentPanelActions,{actions:[{component:external_osdSharedDeps_React_default.a.createElement(ModalConsumer,null,_ref3=>{let{onShow:onShow}=_ref3;return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"recipient-groups-table-delete-button",disabled:this.state.selectedItems.length===0,onClick:()=>onShow(DeleteRecipientGroupModal,{recipientGroups:this.state.selectedItems,refresh:this.refresh})},"Delete")})},{component:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"recipient-groups-table-edit-button",disabled:this.state.selectedItems.length!==1,onClick:()=>{var _this$state$selectedI;return location.assign("#".concat(ROUTES.EDIT_RECIPIENT_GROUP,"/").concat((_this$state$selectedI=this.state.selectedItems[0])===null||_this$state$selectedI===void 0?void 0:_this$state$selectedI.config_id))}},"Edit")},{component:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{fill:true,href:"#".concat(ROUTES.CREATE_RECIPIENT_GROUP)},"Create recipient group")}]}),bodyStyles:{padding:"initial"},title:"Recipient groups",titleSize:"m",total:this.state.total},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldSearch"],{"data-test-subj":"recipient-groups-table-search-input",fullWidth:true,placeholder:"Search",onSearch:this.onSearchChange}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiHorizontalRule"],{margin:"s"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiBasicTable"],{columns:this.columns,items:this.state.items,itemId:"config_id",isSelectable:true,selection:selection,noItemsMessage:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiEmptyPrompt"],{title:external_osdSharedDeps_React_default.a.createElement("h2",null,"No recipient groups to display"),body:"Use an email group to manage a list of email addresses you frequently send at a time. You can select recipient groups when configuring email channels.",actions:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{href:"#".concat(ROUTES.CREATE_RECIPIENT_GROUP)},"Create recipient group")}),onChange:this.onTableChange,pagination:pagination,sorting:sorting})))}}RecipientGroupsTable_defineProperty(RecipientGroupsTable_RecipientGroupsTable,"contextType",ServicesContext);function EmailGroups(props){const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);Object(external_osdSharedDeps_React_["useEffect"])(()=>{coreContext.chrome.setBreadcrumbs([BREADCRUMBS.NOTIFICATIONS,BREADCRUMBS.EMAIL_GROUPS]);window.scrollTo(0,0)},[]);return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiTitle"],{size:"l"},external_osdSharedDeps_React_default.a.createElement("h1",null,"Email recipient groups")),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(RecipientGroupsTable_RecipientGroupsTable,{coreContext:coreContext,notificationService:props.notificationService}))}const DeleteSenderModal=props=>{if(!props.senders.length)return null;const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);const[input,setInput]=Object(external_osdSharedDeps_React_["useState"])("");const num=props.senders.length;const name=num>=2?"".concat(num," senders"):props.senders[0].name;const message="Delete ".concat(num>=2?"the following senders":name," permanently? Any channels using ").concat(num>=2?"these email senders":"this email sender"," will not be able to send notifications.");return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiOverlayMask"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModal"],{onClose:props.onClose,maxWidth:500},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeader"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,"Delete ".concat(name,"?"))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalBody"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],null,message),num>=2&&external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),props.senders.map((sender,i)=>external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],{key:"sender-list-item-".concat(i),style:{marginLeft:20}},external_osdSharedDeps_React_default.a.createElement("li",null,sender.name)))),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiText"],null,"To confirm delete, type ",external_osdSharedDeps_React_default.a.createElement("i",null,"delete")," in the field."),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:"delete",value:input,onChange:e=>setInput(e.target.value)})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiModalFooter"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd"},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:props.onClose},"Cancel")),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"delete-sender-modal-delete-button",fill:true,color:"danger",onClick:async()=>{props.services.notificationService.deleteConfigs(props.senders.map(sender=>sender.config_id)).then(resp=>{coreContext.notifications.toasts.addSuccess("".concat(props.senders.length>1?props.senders.length+" senders":"Sender "+props.senders[0].name," successfully deleted."));props.onClose();setTimeout(()=>props.refresh(),common["c"])}).catch(error=>{coreContext.notifications.toasts.addError((error===null||error===void 0?void 0:error.body)||error,{title:"Failed to delete one or more senders."});props.onClose()})},disabled:input!=="delete"},"Delete"))))))};const SendersTableControls=props=>{const[isEncryptionPopoverOpen,setIsEncryptionPopoverOpen]=Object(external_osdSharedDeps_React_["useState"])(false);const[encryptionItems,setEncryptionItems]=Object(external_osdSharedDeps_React_["useState"])(Object.entries(ENCRYPTION_TYPE).map(_ref=>{let[key,value]=_ref;return{field:key,display:value,checked:"off"}}));function updateItem(items,index){if(!items[index])return;const newItems=[...items];newItems[index].checked=newItems[index].checked==="off"?"on":"off";const newFilters=external_osdSharedDeps_Lodash_default.a.clone(props.filters);const checkedItems=newItems.filter(item=>item.checked==="on").map(item=>item.field);setEncryptionItems(newItems);newFilters.encryptionMethod=checkedItems;props.onFiltersChange(newFilters)}function isItemSelected(items){return items.map(item=>item.checked==="on").reduce((flag,curr)=>flag||curr,false)}return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldSearch"],{"data-test-subj":"senders-table-search-input",fullWidth:true,placeholder:"Search",onSearch:props.onSearchChange})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFilterGroup"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiPopover"],{button:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFilterButton"],{iconType:"arrowDown",grow:false,onClick:()=>setIsEncryptionPopoverOpen(!isEncryptionPopoverOpen)},isItemSelected(encryptionItems)?external_osdSharedDeps_React_default.a.createElement("b",null,"Encryption method"):"Encryption method"),isOpen:isEncryptionPopoverOpen,closePopover:()=>setIsEncryptionPopoverOpen(false),panelPaddingSize:"none"},encryptionItems.map((item,index)=>external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFilterSelectItem"],{key:"smtp-sender-encryption-method-filter-".concat(index),checked:item.checked==="on"?"on":undefined,onClick:()=>updateItem(encryptionItems,index)},item.display))))))};function SendersTable_defineProperty(obj,key,value){key=SendersTable_toPropertyKey(key);if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function SendersTable_toPropertyKey(arg){var key=SendersTable_toPrimitive(arg,"string");return typeof key==="symbol"?key:String(key)}function SendersTable_toPrimitive(input,hint){if(typeof input!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(typeof res!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.")}return(hint==="string"?String:Number)(input)}class SendersTable_SendersTable extends external_osdSharedDeps_React_["Component"]{constructor(props){super(props);SendersTable_defineProperty(this,"columns",void 0);SendersTable_defineProperty(this,"onTableChange",_ref=>{let{page:tablePage,sort:sort}=_ref;const{index:page,size:size}=tablePage;const{field:sortField,direction:sortDirection}=sort;this.setState({from:page*size,size:size,sortField:sortField,sortDirection:sortDirection})});SendersTable_defineProperty(this,"onSelectionChange",selectedItems=>{this.setState({selectedItems:selectedItems})});SendersTable_defineProperty(this,"onSearchChange",search=>{this.setState({from:0,search:search})});this.state={total:0,from:0,size:5,search:"",sortField:"name",sortDirection:external_osdSharedDeps_ElasticEui_["SortDirection"].ASC,items:[],selectedItems:[],loading:true,filters:{encryptionMethod:[]}};this.columns=[{field:"name",name:"Name",sortable:true,truncateText:true,width:"200px"},{field:"smtp_account.from_address",name:"Outbound email address",sortable:true,truncateText:true,width:"200px"},{field:"smtp_account.host",name:"Host",sortable:true,truncateText:true,width:"200px"},{field:"smtp_account.port",name:"Port",sortable:false,truncateText:true,width:"200px"},{field:"smtp_account.method",name:"Encryption method",sortable:true,truncateText:true,width:"200px",render:method=>external_osdSharedDeps_Lodash_default.a.get(ENCRYPTION_TYPE,method,"-")}];this.refresh=this.refresh.bind(this)}async componentDidMount(){await this.refresh()}async componentDidUpdate(prevProps,prevState){const prevQuery=SendersTable_SendersTable.getQueryObjectFromState(prevState);const currQuery=SendersTable_SendersTable.getQueryObjectFromState(this.state);if(!external_osdSharedDeps_Lodash_default.a.isEqual(prevQuery,currQuery)){await this.refresh()}if(isDataSourceChanged(this.props,prevProps)){await this.refresh()}}static getQueryObjectFromState(state){const queryObject={from_index:state.from,max_items:state.size,query:state.search,config_type:"smtp_account",sort_field:state.sortField,sort_order:state.sortDirection};if(state.filters.encryptionMethod.length>0){queryObject["smtp_account.method"]=state.filters.encryptionMethod}return queryObject}async refresh(){this.setState({loading:true});try{const queryObject=SendersTable_SendersTable.getQueryObjectFromState(this.state);const senders=await this.context.notificationService.getSenders(queryObject);this.setState({items:senders.items,total:senders.total})}catch(error){if(isDataSourceError(error)){this.setState({items:[],total:0})}this.props.coreContext.notifications.toasts.addDanger(getErrorMessage(error,"There was a problem loading SMTP senders."))}this.setState({loading:false})}render(){const page=Math.floor(this.state.from/this.state.size);const pagination={pageIndex:page,pageSize:this.state.size,pageSizeOptions:DEFAULT_PAGE_SIZE_OPTIONS,totalItemCount:this.state.total};const sorting={sort:{direction:this.state.sortDirection,field:this.state.sortField}};const selection={selectable:()=>true,onSelectionChange:this.onSelectionChange};return external_osdSharedDeps_React_default.a.createElement(ContentPanel_ContentPanel,{actions:external_osdSharedDeps_React_default.a.createElement(ContentPanel_ContentPanelActions,{actions:[{component:external_osdSharedDeps_React_default.a.createElement(ModalConsumer,null,_ref2=>{let{onShow:onShow}=_ref2;return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"senders-table-delete-button",disabled:this.state.selectedItems.length===0,onClick:()=>onShow(DeleteSenderModal,{senders:this.state.selectedItems,refresh:this.refresh})},"Delete")})},{component:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"senders-table-edit-button",disabled:this.state.selectedItems.length!==1,onClick:()=>{var _this$state$selectedI;return location.assign("#".concat(ROUTES.EDIT_SENDER,"/").concat((_this$state$selectedI=this.state.selectedItems[0])===null||_this$state$selectedI===void 0?void 0:_this$state$selectedI.config_id))}},"Edit")},{component:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{fill:true,href:"#".concat(ROUTES.CREATE_SENDER)},"Create SMTP sender")}]}),bodyStyles:{padding:"initial"},title:"SMTP senders",titleSize:"m",total:this.state.total},external_osdSharedDeps_React_default.a.createElement(SendersTableControls,{onSearchChange:this.onSearchChange,filters:this.state.filters,onFiltersChange:filters=>this.setState({filters:filters})}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiHorizontalRule"],{margin:"s"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiBasicTable"],{columns:this.columns,items:this.state.items,itemId:"config_id",isSelectable:true,selection:selection,noItemsMessage:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiEmptyPrompt"],{title:external_osdSharedDeps_React_default.a.createElement("h2",null,"No SMTP senders to display"),body:"Set up an outbound email server by creating a sender. You will select a sender when configuring email channels.",actions:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{href:"#".concat(ROUTES.CREATE_SENDER)},"Create SMTP sender")}),onChange:this.onTableChange,pagination:pagination,sorting:sorting,loading:this.state.loading}))}}SendersTable_defineProperty(SendersTable_SendersTable,"contextType",ServicesContext);function SESSendersTable_defineProperty(obj,key,value){key=SESSendersTable_toPropertyKey(key);if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function SESSendersTable_toPropertyKey(arg){var key=SESSendersTable_toPrimitive(arg,"string");return typeof key==="symbol"?key:String(key)}function SESSendersTable_toPrimitive(input,hint){if(typeof input!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(typeof res!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.")}return(hint==="string"?String:Number)(input)}class SESSendersTable_SESSendersTable extends external_osdSharedDeps_React_["Component"]{constructor(props){super(props);SESSendersTable_defineProperty(this,"columns",void 0);SESSendersTable_defineProperty(this,"onTableChange",_ref=>{let{page:tablePage,sort:sort}=_ref;const{index:page,size:size}=tablePage;const{field:sortField,direction:sortDirection}=sort;this.setState({from:page*size,size:size,sortField:sortField,sortDirection:sortDirection})});SESSendersTable_defineProperty(this,"onSelectionChange",selectedItems=>{this.setState({selectedItems:selectedItems})});SESSendersTable_defineProperty(this,"onSearchChange",search=>{this.setState({from:0,search:search})});this.state={total:0,from:0,size:5,search:"",sortField:"name",sortDirection:external_osdSharedDeps_ElasticEui_["SortDirection"].ASC,items:[],selectedItems:[],loading:true};this.columns=[{field:"name",name:"Name",sortable:true,truncateText:true,width:"200px"},{field:"ses_account.from_address",name:"Outbound email address",sortable:true,truncateText:true},{field:"ses_account.region",name:"AWS region",sortable:true,truncateText:true},{field:"ses_account.role_arn",name:"Role ARN",sortable:false,truncateText:true}];this.refresh=this.refresh.bind(this)}async componentDidMount(){await this.refresh()}async componentDidUpdate(prevProps,prevState){const prevQuery=SESSendersTable_SESSendersTable.getQueryObjectFromState(prevState);const currQuery=SESSendersTable_SESSendersTable.getQueryObjectFromState(this.state);if(!external_osdSharedDeps_Lodash_default.a.isEqual(prevQuery,currQuery)){await this.refresh()}if(isDataSourceChanged(this.props,prevProps)){await this.refresh()}}static getQueryObjectFromState(state){return{from_index:state.from,max_items:state.size,query:state.search,config_type:"ses_account",sort_field:state.sortField,sort_order:state.sortDirection}}async refresh(){this.setState({loading:true});try{const queryObject=SESSendersTable_SESSendersTable.getQueryObjectFromState(this.state);const senders=await this.context.notificationService.getSESSenders(queryObject);this.setState({items:senders.items,total:senders.total})}catch(error){if(isDataSourceError(error)){this.setState({items:[],total:0})}this.props.coreContext.notifications.toasts.addDanger(getErrorMessage(error,"There was a problem loading SES senders."))}this.setState({loading:false})}render(){const page=Math.floor(this.state.from/this.state.size);const pagination={pageIndex:page,pageSize:this.state.size,pageSizeOptions:DEFAULT_PAGE_SIZE_OPTIONS,totalItemCount:this.state.total};const sorting={sort:{direction:this.state.sortDirection,field:this.state.sortField}};const selection={selectable:()=>true,onSelectionChange:this.onSelectionChange};return external_osdSharedDeps_React_default.a.createElement(ContentPanel_ContentPanel,{actions:external_osdSharedDeps_React_default.a.createElement(ContentPanel_ContentPanelActions,{actions:[{component:external_osdSharedDeps_React_default.a.createElement(ModalConsumer,null,_ref2=>{let{onShow:onShow}=_ref2;return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"ses-senders-table-delete-button",disabled:this.state.selectedItems.length===0,onClick:()=>onShow(DeleteSenderModal,{senders:this.state.selectedItems,refresh:this.refresh})},"Delete")})},{component:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"ses-senders-table-edit-button",disabled:this.state.selectedItems.length!==1,onClick:()=>{var _this$state$selectedI;return location.assign("#".concat(ROUTES.EDIT_SES_SENDER,"/").concat((_this$state$selectedI=this.state.selectedItems[0])===null||_this$state$selectedI===void 0?void 0:_this$state$selectedI.config_id))}},"Edit")},{component:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{fill:true,href:"#".concat(ROUTES.CREATE_SES_SENDER)},"Create SES sender")}]}),bodyStyles:{padding:"initial"},title:"SES senders",titleSize:"m",total:this.state.total},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiFieldSearch"],{"data-test-subj":"ses-senders-table-search-input",fullWidth:true,placeholder:"Search",onSearch:this.onSearchChange}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiHorizontalRule"],{margin:"s"}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiBasicTable"],{columns:this.columns,items:this.state.items,itemId:"config_id",isSelectable:true,selection:selection,noItemsMessage:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiEmptyPrompt"],{title:external_osdSharedDeps_React_default.a.createElement("h2",null,"No SES senders to display"),body:"Set up an outbound email server by creating a sender. You will select a sender when configuring email channels.",actions:external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiButton"],{href:"#".concat(ROUTES.CREATE_SES_SENDER)},"Create SES sender")}),onChange:this.onTableChange,pagination:pagination,sorting:sorting,loading:this.state.loading,tableLayout:"auto"}))}}SESSendersTable_defineProperty(SESSendersTable_SESSendersTable,"contextType",ServicesContext);function EmailSenders(props){const coreContext=Object(external_osdSharedDeps_React_["useContext"])(CoreServicesContext);const mainStateContext=Object(external_osdSharedDeps_React_["useContext"])(MainContext);Object(external_osdSharedDeps_React_["useEffect"])(()=>{coreContext.chrome.setBreadcrumbs([BREADCRUMBS.NOTIFICATIONS,BREADCRUMBS.EMAIL_SENDERS]);window.scrollTo(0,0)},[]);return external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiTitle"],{size:"l"},external_osdSharedDeps_React_default.a.createElement("h1",null,"Email senders")),mainStateContext.availableConfigTypes.includes("smtp_account")&&external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(SendersTable_SendersTable,{coreContext:coreContext,notificationService:props.notificationService})),mainStateContext.availableConfigTypes.includes("ses_account")&&external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSpacer"],null),external_osdSharedDeps_React_default.a.createElement(SESSendersTable_SESSendersTable,{coreContext:coreContext,notificationService:props.notificationService})))}const DataSourceMenuContext=Object(external_osdSharedDeps_React_["createContext"])({dataSourceId:"",dataSourceLabel:"",multiDataSourceEnabled:false});const DataSourceMenuConsumer=DataSourceMenuContext.Consumer;function Main_extends(){Main_extends=Object.assign?Object.assign.bind():function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return Main_extends.apply(this,arguments)}function Main_defineProperty(obj,key,value){key=Main_toPropertyKey(key);if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function Main_toPropertyKey(arg){var key=Main_toPrimitive(arg,"string");return typeof key==="symbol"?key:String(key)}function Main_toPrimitive(input,hint){if(typeof input!=="object"||input===null)return input;var prim=input[Symbol.toPrimitive];if(prim!==undefined){var res=prim.call(input,hint||"default");if(typeof res!=="object")return res;throw new TypeError("@@toPrimitive must return a primitive value.")}return(hint==="string"?String:Number)(input)}var Navigation=function(Navigation){Navigation["Notifications"]="Notifications";Navigation["Channels"]="Channels";Navigation["EmailSenders"]="Email senders";Navigation["EmailGroups"]="Email recipient groups";return Navigation}(Navigation||{});var Pathname=function(Pathname){Pathname["Channels"]="/channels";return Pathname}(Pathname||{});const MainContext=Object(external_osdSharedDeps_React_["createContext"])(null);class Main_Main extends external_osdSharedDeps_React_["Component"]{constructor(props){super(props);Main_defineProperty(this,"onSelectedDataSources",dataSources=>{const{id:id="",label:label=""}=dataSources[0]||{};if(this.state.dataSourceId!==id||this.state.dataSourceLabel!==label){this.setState({dataSourceId:id,dataSourceLabel:label})}if(this.state.dataSourceLoading){this.setState({dataSourceLoading:false})}});const initialState={availableChannels:CHANNEL_TYPE,availableConfigTypes:[],tooltipSupport:false};if(props.multiDataSourceEnabled){const{dataSourceId:dataSourceId="",dataSourceLabel:dataSourceLabel=""}=query_string_default.a.parse(this.props.location.search);this.state={...initialState,dataSourceId:dataSourceId,dataSourceLabel:dataSourceLabel,dataSourceReadOnly:false,dataSourceLoading:props.multiDataSourceEnabled}}else{this.state=initialState}}async componentDidMount(){this.setServerFeatures()}componentDidUpdate(prevProps,prevState){if(this.props.multiDataSourceEnabled&&prevState.dataSourceId!==this.state.dataSourceId){this.setServerFeatures()}}async setServerFeatures(){const services=this.getServices(this.props.http);const serverFeatures=await services.notificationService.getServerFeatures();const defaultConfigTypes=["slack","chime","microsoft_teams","webhook","email","sns","smtp_account","ses_account","email_group"];let newState={dataSourceId:this.state.dataSourceId||"",dataSourceLabel:this.state.dataSourceLabel||"",dataSourceReadOnly:false,dataSourceLoading:this.state.dataSourceLoading,availableChannels:this.props.multiDataSourceEnabled?CHANNEL_TYPE:defaultConfigTypes,availableConfigTypes:defaultConfigTypes,tooltipSupport:false};if(serverFeatures){const{availableChannels:availableChannels,availableConfigTypes:availableConfigTypes,tooltipSupport:tooltipSupport}=serverFeatures;newState={...newState,availableChannels:availableChannels,availableConfigTypes:availableConfigTypes,tooltipSupport:tooltipSupport}}this.setState(newState)}getServices(http){const{location:{pathname:pathname}}=this.props;let notificationService;if(this.props.multiDataSourceEnabled){notificationService=new NotificationService_NotificationService(http,this.state.dataSourceId,this.props.multiDataSourceEnabled)}else{notificationService=new NotificationService_NotificationService(http)}const services={notificationService:notificationService};return services}render(){const{location:{pathname:pathname}}=this.props;let DataSourceMenuSelectable,DataSourceMenuView;let activeOption;if(this.props.multiDataSourceEnabled){var _this$props$dataSourc,_this$props$dataSourc2;DataSourceMenuSelectable=(_this$props$dataSourc=this.props.dataSourceManagement)===null||_this$props$dataSourc===void 0||(_this$props$dataSourc=_this$props$dataSourc.ui)===null||_this$props$dataSourc===void 0?void 0:_this$props$dataSourc.getDataSourceMenu();DataSourceMenuView=(_this$props$dataSourc2=this.props.dataSourceManagement)===null||_this$props$dataSourc2===void 0||(_this$props$dataSourc2=_this$props$dataSourc2.ui)===null||_this$props$dataSourc2===void 0?void 0:_this$props$dataSourc2.getDataSourceMenu();activeOption=this.state.dataSourceLoading?undefined:[{label:this.state.dataSourceLabel,id:this.state.dataSourceId}]}const sideNav=[{name:Navigation.Notifications,id:0,href:"#".concat(Pathname.Channels),items:[{name:Navigation.Channels,id:2,href:"#".concat(Pathname.Channels),isSelected:pathname===Pathname.Channels},{name:Navigation.EmailSenders,id:3,href:"#".concat(ROUTES.EMAIL_SENDERS),isSelected:pathname===ROUTES.EMAIL_SENDERS},{name:Navigation.EmailGroups,id:4,href:"#".concat(ROUTES.EMAIL_GROUPS),isSelected:pathname===ROUTES.EMAIL_GROUPS}]}];return external_osdSharedDeps_React_default.a.createElement(CoreServicesConsumer,null,core=>core&&external_osdSharedDeps_React_default.a.createElement(ServicesContext.Provider,{value:this.getServices(core.http)},external_osdSharedDeps_React_default.a.createElement(ServicesConsumer,null,services=>services&&external_osdSharedDeps_React_default.a.createElement(MainContext.Provider,{value:this.state},external_osdSharedDeps_React_default.a.createElement(Modal_ModalProvider,null,external_osdSharedDeps_React_default.a.createElement(DataSourceMenuContext.Provider,{value:{dataSourceId:this.state.dataSourceId,dataSourceLabel:this.state.dataSourceLabel,multiDataSourceEnabled:this.props.multiDataSourceEnabled}},this.props.multiDataSourceEnabled&&DataSourceMenuView&&DataSourceMenuSelectable&&external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Switch"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Route"],{path:["".concat(ROUTES.EDIT_CHANNEL,"/:id"),"".concat(ROUTES.CHANNEL_DETAILS,"/:id"),"".concat(ROUTES.EDIT_SENDER,"/:id"),"".concat(ROUTES.EDIT_RECIPIENT_GROUP,"/:id"),"".concat(ROUTES.EDIT_SES_SENDER,"/:id")],render:()=>external_osdSharedDeps_React_default.a.createElement(DataSourceMenuView,{setMenuMountPoint:this.props.setActionMenu,componentType:"DataSourceView",componentConfig:{activeOption:[{label:this.state.dataSourceLabel,id:this.state.dataSourceId}]}})}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Route"],{path:["/",ROUTES.CHANNELS,ROUTES.CREATE_CHANNEL,ROUTES.CREATE_SENDER,ROUTES.CREATE_SES_SENDER,ROUTES.CREATE_RECIPIENT_GROUP,ROUTES.EMAIL_GROUPS,ROUTES.EMAIL_SENDERS,ROUTES.NOTIFICATIONS],render:()=>external_osdSharedDeps_React_default.a.createElement(DataSourceMenuSelectable,{setMenuMountPoint:this.props.setActionMenu,componentType:"DataSourceSelectable",componentConfig:{savedObjects:core===null||core===void 0?void 0:core.savedObjects.client,notifications:core===null||core===void 0?void 0:core.notifications,fullWidth:false,activeOption:activeOption,onSelectedDataSources:this.onSelectedDataSources}})}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Route"],{path:[ROUTES.CREATE_SES_SENDER,ROUTES.CREATE_CHANNEL,ROUTES.CREATE_RECIPIENT_GROUP,ROUTES.CREATE_SENDER],render:()=>this.state.dataSourceReadOnly?external_osdSharedDeps_React_default.a.createElement(DataSourceMenuView,{setMenuMountPoint:this.props.setActionMenu,componentType:"DataSourceView",componentConfig:{activeOption:[{label:this.state.dataSourceLabel,id:this.state.dataSourceId}],fullWidth:false}}):external_osdSharedDeps_React_default.a.createElement(DataSourceMenuSelectable,{setMenuMountPoint:this.props.setActionMenu,componentType:"DataSourceSelectable",componentConfig:{savedObjects:core===null||core===void 0?void 0:core.savedObjects.client,notifications:core===null||core===void 0?void 0:core.notifications,fullWidth:false,activeOption:activeOption,onSelectedDataSources:this.onSelectedDataSources}})})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiPage"],null,!this.state.dataSourceLoading&&external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_React_default.a.Fragment,null,external_osdSharedDeps_React_default.a.createElement(Modal_ModalRoot,{services:services}),pathname!==ROUTES.CREATE_CHANNEL&&!pathname.startsWith(ROUTES.EDIT_CHANNEL)&&!pathname.startsWith(ROUTES.CHANNEL_DETAILS)&&pathname!==ROUTES.CREATE_SENDER&&!pathname.startsWith(ROUTES.EDIT_SENDER)&&pathname!==ROUTES.CREATE_SES_SENDER&&!pathname.startsWith(ROUTES.EDIT_SES_SENDER)&&pathname!==ROUTES.CREATE_RECIPIENT_GROUP&&!pathname.startsWith(ROUTES.EDIT_RECIPIENT_GROUP)&&external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiPageSideBar"],{style:{minWidth:155}},external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiSideNav"],{style:{width:155},items:sideNav})),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ElasticEui_["EuiPageBody"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Switch"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Route"],{path:ROUTES.CREATE_CHANNEL,render:props=>external_osdSharedDeps_React_default.a.createElement(CreateChannel,props)}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Route"],{path:"".concat(ROUTES.EDIT_CHANNEL,"/:id"),render:props=>external_osdSharedDeps_React_default.a.createElement(CreateChannel,Main_extends({},props,{edit:true}))}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Route"],{path:"".concat(ROUTES.CHANNEL_DETAILS,"/:id"),render:props=>external_osdSharedDeps_React_default.a.createElement(ChannelDetails,props)}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Route"],{path:ROUTES.CHANNELS,render:props=>external_osdSharedDeps_React_default.a.createElement(Channels_Channels,Main_extends({},props,{notificationService:services===null||services===void 0?void 0:services.notificationService}))}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Route"],{path:ROUTES.EMAIL_SENDERS,render:props=>external_osdSharedDeps_React_default.a.createElement(EmailSenders,Main_extends({},props,{notificationService:services===null||services===void 0?void 0:services.notificationService}))}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Route"],{path:ROUTES.EMAIL_GROUPS,render:props=>external_osdSharedDeps_React_default.a.createElement(EmailGroups,Main_extends({},props,{notificationService:services===null||services===void 0?void 0:services.notificationService}))}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Route"],{path:ROUTES.CREATE_SENDER,render:props=>external_osdSharedDeps_React_default.a.createElement(CreateSender,props)}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Route"],{path:"".concat(ROUTES.EDIT_SENDER,"/:id"),render:props=>external_osdSharedDeps_React_default.a.createElement(CreateSender,Main_extends({},props,{edit:true}))}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Route"],{path:ROUTES.CREATE_SES_SENDER,render:props=>external_osdSharedDeps_React_default.a.createElement(CreateSESSender,props)}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Route"],{path:"".concat(ROUTES.EDIT_SES_SENDER,"/:id"),render:props=>external_osdSharedDeps_React_default.a.createElement(CreateSESSender,Main_extends({},props,{edit:true}))}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Route"],{path:ROUTES.CREATE_RECIPIENT_GROUP,render:props=>external_osdSharedDeps_React_default.a.createElement(CreateRecipientGroup,props)}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Route"],{path:"".concat(ROUTES.EDIT_RECIPIENT_GROUP,"/:id"),render:props=>external_osdSharedDeps_React_default.a.createElement(CreateRecipientGroup,Main_extends({},props,{edit:true}))}),external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Redirect"],{from:"/",to:ROUTES.CHANNELS})))))))))))}}Main_defineProperty(Main_Main,"contextType",ServicesContext);var pages_Main=Main_Main;function application_extends(){application_extends=Object.assign?Object.assign.bind():function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return application_extends.apply(this,arguments)}const renderApp=(coreStart,params,dataSourceManagement,pluginStartDependencies)=>{external_osdSharedDeps_ReactDom_default.a.render(external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["HashRouter"],null,external_osdSharedDeps_React_default.a.createElement(external_osdSharedDeps_ReactRouterDom_["Route"],{render:props=>external_osdSharedDeps_React_default.a.createElement(CoreServicesContext.Provider,{value:coreStart},external_osdSharedDeps_React_default.a.createElement(pages_Main,application_extends({},props,{setActionMenu:params.setHeaderActionMenu,multiDataSourceEnabled:!!pluginStartDependencies.dataSource,dataSourceManagement:dataSourceManagement,http:coreStart.http})))})),params.element);return()=>external_osdSharedDeps_ReactDom_default.a.unmountComponentAtNode(params.element)}}}]);