class ParseError extends Error{sourceStart;sourceEnd;parserState;constructor(e,n,t,o){super(e),this.name="ParseError",this.sourceStart=n,this.sourceEnd=t,this.parserState=o}}class ParseErrorWithToken extends ParseError{token;constructor(e,n,t,o,r){super(e,n,t,o),this.token=r}}const e={UnexpectedNewLineInString:"Unexpected newline while consuming a string token.",UnexpectedEOFInString:"Unexpected EOF while consuming a string token.",UnexpectedEOFInComment:"Unexpected EOF while consuming a comment.",UnexpectedEOFInURL:"Unexpected EOF while consuming a url token.",UnexpectedEOFInEscapedCodePoint:"Unexpected EOF while consuming an escaped code point.",UnexpectedCharacterInURL:"Unexpected character while consuming a url token.",InvalidEscapeSequenceInURL:"Invalid escape sequence while consuming a url token.",InvalidEscapeSequenceAfterBackslash:'Invalid escape sequence after "\\"'},n="undefined"!=typeof globalThis&&"structuredClone"in globalThis;function cloneTokens(e){return n?structuredClone(e):JSON.parse(JSON.stringify(e))}function stringify(...e){let n="";for(let t=0;t<e.length;t++)n+=e[t][1];return n}const t=39,o=42,r=8,i=13,s=9,c=58,a=44,u=64,d=127,p=33,P=12,C=46,l=62,f=45,S=31,m=69,k=101,E=123,h=40,v=91,T=60,A=10,g=11,I=95,U=1114111,O=0,D=35,R=37,w=43,L=34,x=65533,W=92,y=125,F=41,q=93,N=59,b=14,B=47,H=32,V=117,K=85,z=114,M=82,$=108,J=76,_=63,j=48,Q=70;function checkIfFourCodePointsWouldStartCDO(e){return e.source.codePointAt(e.cursor)===T&&e.source.codePointAt(e.cursor+1)===p&&e.source.codePointAt(e.cursor+2)===f&&e.source.codePointAt(e.cursor+3)===f}function isDigitCodePoint(e){return void 0!==e&&e>=48&&e<=57}function isUppercaseLetterCodePoint(e){return void 0!==e&&e>=65&&e<=90}function isLowercaseLetterCodePoint(e){return void 0!==e&&e>=97&&e<=122}function isHexDigitCodePoint(e){return void 0!==e&&(e>=48&&e<=57||e>=97&&e<=102||e>=65&&e<=70)}function isLetterCodePoint(e){return isLowercaseLetterCodePoint(e)||isUppercaseLetterCodePoint(e)}function isIdentStartCodePoint(e){return isLetterCodePoint(e)||isNonASCII_IdentCodePoint(e)||e===I}function isIdentCodePoint(e){return isIdentStartCodePoint(e)||isDigitCodePoint(e)||e===f}function isNonASCII_IdentCodePoint(e){return 183===e||8204===e||8205===e||8255===e||8256===e||8204===e||void 0!==e&&(192<=e&&e<=214||216<=e&&e<=246||248<=e&&e<=893||895<=e&&e<=8191||8304<=e&&e<=8591||11264<=e&&e<=12271||12289<=e&&e<=55295||63744<=e&&e<=64975||65008<=e&&e<=65533||e>=65536)}function isNewLine(e){return e===A||e===i||e===P}function isWhitespace(e){return e===H||e===A||e===s||e===i||e===P}function checkIfTwoCodePointsAreAValidEscape(e){return e.source.codePointAt(e.cursor)===W&&!isNewLine(e.source.codePointAt(e.cursor+1))}function checkIfThreeCodePointsWouldStartAnIdentSequence(e,n){return n.source.codePointAt(n.cursor)===f?n.source.codePointAt(n.cursor+1)===f||(!!isIdentStartCodePoint(n.source.codePointAt(n.cursor+1))||n.source.codePointAt(n.cursor+1)===W&&!isNewLine(n.source.codePointAt(n.cursor+2))):!!isIdentStartCodePoint(n.source.codePointAt(n.cursor))||checkIfTwoCodePointsAreAValidEscape(n)}function checkIfThreeCodePointsWouldStartANumber(e){return e.source.codePointAt(e.cursor)===w||e.source.codePointAt(e.cursor)===f?!!isDigitCodePoint(e.source.codePointAt(e.cursor+1))||e.source.codePointAt(e.cursor+1)===C&&isDigitCodePoint(e.source.codePointAt(e.cursor+2)):e.source.codePointAt(e.cursor)===C?isDigitCodePoint(e.source.codePointAt(e.cursor+1)):isDigitCodePoint(e.source.codePointAt(e.cursor))}function checkIfTwoCodePointsStartAComment(e){return e.source.codePointAt(e.cursor)===B&&e.source.codePointAt(e.cursor+1)===o}function checkIfThreeCodePointsWouldStartCDC(e){return e.source.codePointAt(e.cursor)===f&&e.source.codePointAt(e.cursor+1)===f&&e.source.codePointAt(e.cursor+2)===l}var G,X,Y;function mirrorVariantType(e){switch(e){case G.OpenParen:return G.CloseParen;case G.CloseParen:return G.OpenParen;case G.OpenCurly:return G.CloseCurly;case G.CloseCurly:return G.OpenCurly;case G.OpenSquare:return G.CloseSquare;case G.CloseSquare:return G.OpenSquare;default:return null}}function mirrorVariant(e){switch(e[0]){case G.OpenParen:return[G.CloseParen,")",-1,-1,void 0];case G.CloseParen:return[G.OpenParen,"(",-1,-1,void 0];case G.OpenCurly:return[G.CloseCurly,"}",-1,-1,void 0];case G.CloseCurly:return[G.OpenCurly,"{",-1,-1,void 0];case G.OpenSquare:return[G.CloseSquare,"]",-1,-1,void 0];case G.CloseSquare:return[G.OpenSquare,"[",-1,-1,void 0];default:return null}}function consumeComment(n,t){for(t.advanceCodePoint(2);;){const r=t.readCodePoint();if(void 0===r){const o=[G.Comment,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,void 0];return n.onParseError(new ParseErrorWithToken(e.UnexpectedEOFInComment,t.representationStart,t.representationEnd,["4.3.2. Consume comments","Unexpected EOF"],o)),o}if(r===o&&(void 0!==t.source.codePointAt(t.cursor)&&t.source.codePointAt(t.cursor)===B)){t.advanceCodePoint();break}}return[G.Comment,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,void 0]}function consumeEscapedCodePoint(n,t){const o=t.readCodePoint();if(void 0===o)return n.onParseError(new ParseError(e.UnexpectedEOFInEscapedCodePoint,t.representationStart,t.representationEnd,["4.3.7. Consume an escaped code point","Unexpected EOF"])),x;if(isHexDigitCodePoint(o)){const e=[o];let n;for(;void 0!==(n=t.source.codePointAt(t.cursor))&&isHexDigitCodePoint(n)&&e.length<6;)e.push(n),t.advanceCodePoint();isWhitespace(t.source.codePointAt(t.cursor))&&t.advanceCodePoint();const i=parseInt(String.fromCodePoint(...e),16);return 0===i?x:void 0!==(r=i)&&r>=55296&&r<=57343||i>U?x:i}var r;return o}function consumeIdentSequence(e,n){const t=[];for(;;){const o=n.source.codePointAt(n.cursor);if(isIdentCodePoint(o))t.push(o),n.advanceCodePoint(+(o>65535)+1);else{if(!checkIfTwoCodePointsAreAValidEscape(n))return t;n.advanceCodePoint(),t.push(consumeEscapedCodePoint(e,n))}}}function consumeHashToken(e,n){n.advanceCodePoint();const t=n.source.codePointAt(n.cursor);if(void 0!==t&&(isIdentCodePoint(t)||checkIfTwoCodePointsAreAValidEscape(n))){let t=Y.Unrestricted;checkIfThreeCodePointsWouldStartAnIdentSequence(0,n)&&(t=Y.ID);const o=consumeIdentSequence(e,n);return[G.Hash,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{value:String.fromCodePoint(...o),type:t}]}return[G.Delim,"#",n.representationStart,n.representationEnd,{value:"#"}]}function consumeNumber(e,n){let t=X.Integer;for(n.source.codePointAt(n.cursor)!==w&&n.source.codePointAt(n.cursor)!==f||n.advanceCodePoint();isDigitCodePoint(n.source.codePointAt(n.cursor));)n.advanceCodePoint();if(n.source.codePointAt(n.cursor)===C&&isDigitCodePoint(n.source.codePointAt(n.cursor+1)))for(n.advanceCodePoint(2),t=X.Number;isDigitCodePoint(n.source.codePointAt(n.cursor));)n.advanceCodePoint();if(n.source.codePointAt(n.cursor)===k||n.source.codePointAt(n.cursor)===m){if(isDigitCodePoint(n.source.codePointAt(n.cursor+1)))n.advanceCodePoint(2);else{if(n.source.codePointAt(n.cursor+1)!==f&&n.source.codePointAt(n.cursor+1)!==w||!isDigitCodePoint(n.source.codePointAt(n.cursor+2)))return t;n.advanceCodePoint(3)}for(t=X.Number;isDigitCodePoint(n.source.codePointAt(n.cursor));)n.advanceCodePoint()}return t}function consumeNumericToken(e,n){let t;{const e=n.source.codePointAt(n.cursor);e===f?t="-":e===w&&(t="+")}const o=consumeNumber(0,n),r=parseFloat(n.source.slice(n.representationStart,n.representationEnd+1));if(checkIfThreeCodePointsWouldStartAnIdentSequence(0,n)){const i=consumeIdentSequence(e,n);return[G.Dimension,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{value:r,signCharacter:t,type:o,unit:String.fromCodePoint(...i)}]}return n.source.codePointAt(n.cursor)===R?(n.advanceCodePoint(),[G.Percentage,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{value:r,signCharacter:t}]):[G.Number,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{value:r,signCharacter:t,type:o}]}function consumeWhiteSpace(e){for(;isWhitespace(e.source.codePointAt(e.cursor));)e.advanceCodePoint();return[G.Whitespace,e.source.slice(e.representationStart,e.representationEnd+1),e.representationStart,e.representationEnd,void 0]}!function(e){e.Comment="comment",e.AtKeyword="at-keyword-token",e.BadString="bad-string-token",e.BadURL="bad-url-token",e.CDC="CDC-token",e.CDO="CDO-token",e.Colon="colon-token",e.Comma="comma-token",e.Delim="delim-token",e.Dimension="dimension-token",e.EOF="EOF-token",e.Function="function-token",e.Hash="hash-token",e.Ident="ident-token",e.Number="number-token",e.Percentage="percentage-token",e.Semicolon="semicolon-token",e.String="string-token",e.URL="url-token",e.Whitespace="whitespace-token",e.OpenParen="(-token",e.CloseParen=")-token",e.OpenSquare="[-token",e.CloseSquare="]-token",e.OpenCurly="{-token",e.CloseCurly="}-token",e.UnicodeRange="unicode-range-token"}(G||(G={})),function(e){e.Integer="integer",e.Number="number"}(X||(X={})),function(e){e.Unrestricted="unrestricted",e.ID="id"}(Y||(Y={}));class Reader{cursor=0;source="";representationStart=0;representationEnd=-1;constructor(e){this.source=e}advanceCodePoint(e=1){this.cursor=this.cursor+e,this.representationEnd=this.cursor-1}readCodePoint(){const e=this.source.codePointAt(this.cursor);if(void 0!==e)return this.cursor=this.cursor+1,this.representationEnd=this.cursor-1,e}unreadCodePoint(e=1){this.cursor=this.cursor-e,this.representationEnd=this.cursor-1}resetRepresentation(){this.representationStart=this.cursor,this.representationEnd=-1}}function consumeStringToken(n,t){let o="";const r=t.readCodePoint();for(;;){const s=t.readCodePoint();if(void 0===s){const r=[G.String,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,{value:o}];return n.onParseError(new ParseErrorWithToken(e.UnexpectedEOFInString,t.representationStart,t.representationEnd,["4.3.5. Consume a string token","Unexpected EOF"],r)),r}if(isNewLine(s)){t.unreadCodePoint();const o=[G.BadString,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,void 0];return n.onParseError(new ParseErrorWithToken(e.UnexpectedNewLineInString,t.representationStart,t.source.codePointAt(t.cursor)===i&&t.source.codePointAt(t.cursor+1)===A?t.representationEnd+2:t.representationEnd+1,["4.3.5. Consume a string token","Unexpected newline"],o)),o}if(s===r)return[G.String,t.source.slice(t.representationStart,t.representationEnd+1),t.representationStart,t.representationEnd,{value:o}];if(s!==W)o+=String.fromCodePoint(s);else{if(void 0===t.source.codePointAt(t.cursor))continue;if(isNewLine(t.source.codePointAt(t.cursor))){t.source.codePointAt(t.cursor)===i&&t.source.codePointAt(t.cursor+1)===A&&t.advanceCodePoint(),t.advanceCodePoint();continue}o+=String.fromCodePoint(consumeEscapedCodePoint(n,t))}}}function checkIfCodePointsMatchURLIdent(e){return!(3!==e.length||e[0]!==V&&e[0]!==K||e[1]!==z&&e[1]!==M||e[2]!==$&&e[2]!==J)}function consumeBadURL(e,n){for(;;){const t=n.source.codePointAt(n.cursor);if(void 0===t)return;if(t===F)return void n.advanceCodePoint();checkIfTwoCodePointsAreAValidEscape(n)?(n.advanceCodePoint(),consumeEscapedCodePoint(e,n)):n.advanceCodePoint()}}function consumeUrlToken(n,o){for(;isWhitespace(o.source.codePointAt(o.cursor));)o.advanceCodePoint();let i="";for(;;){if(void 0===o.source.codePointAt(o.cursor)){const t=[G.URL,o.source.slice(o.representationStart,o.representationEnd+1),o.representationStart,o.representationEnd,{value:i}];return n.onParseError(new ParseErrorWithToken(e.UnexpectedEOFInURL,o.representationStart,o.representationEnd,["4.3.6. Consume a url token","Unexpected EOF"],t)),t}if(o.source.codePointAt(o.cursor)===F)return o.advanceCodePoint(),[G.URL,o.source.slice(o.representationStart,o.representationEnd+1),o.representationStart,o.representationEnd,{value:i}];if(isWhitespace(o.source.codePointAt(o.cursor))){for(o.advanceCodePoint();isWhitespace(o.source.codePointAt(o.cursor));)o.advanceCodePoint();if(void 0===o.source.codePointAt(o.cursor)){const t=[G.URL,o.source.slice(o.representationStart,o.representationEnd+1),o.representationStart,o.representationEnd,{value:i}];return n.onParseError(new ParseErrorWithToken(e.UnexpectedEOFInURL,o.representationStart,o.representationEnd,["4.3.6. Consume a url token","Consume as much whitespace as possible","Unexpected EOF"],t)),t}return o.source.codePointAt(o.cursor)===F?(o.advanceCodePoint(),[G.URL,o.source.slice(o.representationStart,o.representationEnd+1),o.representationStart,o.representationEnd,{value:i}]):(consumeBadURL(n,o),[G.BadURL,o.source.slice(o.representationStart,o.representationEnd+1),o.representationStart,o.representationEnd,void 0])}const c=o.source.codePointAt(o.cursor);if(c===L||c===t||c===h||void 0!==(s=c)&&(s===g||s===d||O<=s&&s<=r||b<=s&&s<=S)){consumeBadURL(n,o);const t=[G.BadURL,o.source.slice(o.representationStart,o.representationEnd+1),o.representationStart,o.representationEnd,void 0];return n.onParseError(new ParseErrorWithToken(e.UnexpectedCharacterInURL,o.representationStart,o.representationEnd,["4.3.6. Consume a url token","Unexpected U+0022 QUOTATION MARK (\"), U+0027 APOSTROPHE ('), U+0028 LEFT PARENTHESIS (() or non-printable code point"],t)),t}if(c===W){if(checkIfTwoCodePointsAreAValidEscape(o)){o.advanceCodePoint(),i+=String.fromCodePoint(consumeEscapedCodePoint(n,o));continue}consumeBadURL(n,o);const t=[G.BadURL,o.source.slice(o.representationStart,o.representationEnd+1),o.representationStart,o.representationEnd,void 0];return n.onParseError(new ParseErrorWithToken(e.InvalidEscapeSequenceInURL,o.representationStart,o.representationEnd,["4.3.6. Consume a url token","U+005C REVERSE SOLIDUS (\\)","The input stream does not start with a valid escape sequence"],t)),t}i+=o.source[o.cursor],o.advanceCodePoint()}var s}function consumeIdentLikeToken(e,n){const o=consumeIdentSequence(e,n);if(n.source.codePointAt(n.cursor)!==h)return[G.Ident,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{value:String.fromCodePoint(...o)}];if(checkIfCodePointsMatchURLIdent(o)){n.advanceCodePoint();let r=0;for(;;){const e=isWhitespace(n.source.codePointAt(n.cursor)),i=isWhitespace(n.source.codePointAt(n.cursor+1));if(e&&i){r+=1,n.advanceCodePoint(1);continue}const s=e?n.source.codePointAt(n.cursor+1):n.source.codePointAt(n.cursor);if(s===L||s===t)return r>0&&n.unreadCodePoint(r),[G.Function,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{value:String.fromCodePoint(...o)}];break}return consumeUrlToken(e,n)}return n.advanceCodePoint(),[G.Function,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{value:String.fromCodePoint(...o)}]}function checkIfThreeCodePointsWouldStartAUnicodeRange(e){return!(e.source.codePointAt(e.cursor)!==V&&e.source.codePointAt(e.cursor)!==K||e.source.codePointAt(e.cursor+1)!==w||e.source.codePointAt(e.cursor+2)!==_&&!isHexDigitCodePoint(e.source.codePointAt(e.cursor+2)))}function consumeUnicodeRangeToken(e,n){n.advanceCodePoint(2);const t=[],o=[];let r;for(;void 0!==(r=n.source.codePointAt(n.cursor))&&t.length<6&&isHexDigitCodePoint(r);)t.push(r),n.advanceCodePoint();for(;void 0!==(r=n.source.codePointAt(n.cursor))&&t.length<6&&r===_;)0===o.length&&o.push(...t),t.push(j),o.push(Q),n.advanceCodePoint();if(!o.length&&n.source.codePointAt(n.cursor)===f&&isHexDigitCodePoint(n.source.codePointAt(n.cursor+1)))for(n.advanceCodePoint();void 0!==(r=n.source.codePointAt(n.cursor))&&o.length<6&&isHexDigitCodePoint(r);)o.push(r),n.advanceCodePoint();if(!o.length){const e=parseInt(String.fromCodePoint(...t),16);return[G.UnicodeRange,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{startOfRange:e,endOfRange:e}]}const i=parseInt(String.fromCodePoint(...t),16),s=parseInt(String.fromCodePoint(...o),16);return[G.UnicodeRange,n.source.slice(n.representationStart,n.representationEnd+1),n.representationStart,n.representationEnd,{startOfRange:i,endOfRange:s}]}function tokenize(e,n){const t=tokenizer(e,n),o=[];{for(;!t.endOfFile();){const e=t.nextToken();e&&o.push(e)}const e=t.nextToken();e&&o.push(e)}return o}function tokenizer(n,o){const r=n.css.valueOf(),d=n.unicodeRangesAllowed??!1,p=new Reader(r),l={onParseError:o?.onParseError??noop};return{nextToken:function nextToken(){p.resetRepresentation();const n=p.source.codePointAt(p.cursor);if(void 0===n)return[G.EOF,"",-1,-1,void 0];if(n===B&&checkIfTwoCodePointsStartAComment(p))return consumeComment(l,p);if(d&&(n===V||n===K)&&checkIfThreeCodePointsWouldStartAUnicodeRange(p))return consumeUnicodeRangeToken(0,p);if(isIdentStartCodePoint(n))return consumeIdentLikeToken(l,p);if(isDigitCodePoint(n))return consumeNumericToken(l,p);switch(n){case a:return p.advanceCodePoint(),[G.Comma,",",p.representationStart,p.representationEnd,void 0];case c:return p.advanceCodePoint(),[G.Colon,":",p.representationStart,p.representationEnd,void 0];case N:return p.advanceCodePoint(),[G.Semicolon,";",p.representationStart,p.representationEnd,void 0];case h:return p.advanceCodePoint(),[G.OpenParen,"(",p.representationStart,p.representationEnd,void 0];case F:return p.advanceCodePoint(),[G.CloseParen,")",p.representationStart,p.representationEnd,void 0];case v:return p.advanceCodePoint(),[G.OpenSquare,"[",p.representationStart,p.representationEnd,void 0];case q:return p.advanceCodePoint(),[G.CloseSquare,"]",p.representationStart,p.representationEnd,void 0];case E:return p.advanceCodePoint(),[G.OpenCurly,"{",p.representationStart,p.representationEnd,void 0];case y:return p.advanceCodePoint(),[G.CloseCurly,"}",p.representationStart,p.representationEnd,void 0];case t:case L:return consumeStringToken(l,p);case D:return consumeHashToken(l,p);case w:case C:return checkIfThreeCodePointsWouldStartANumber(p)?consumeNumericToken(l,p):(p.advanceCodePoint(),[G.Delim,p.source[p.representationStart],p.representationStart,p.representationEnd,{value:p.source[p.representationStart]}]);case A:case i:case P:case s:case H:return consumeWhiteSpace(p);case f:return checkIfThreeCodePointsWouldStartANumber(p)?consumeNumericToken(l,p):checkIfThreeCodePointsWouldStartCDC(p)?(p.advanceCodePoint(3),[G.CDC,"--\x3e",p.representationStart,p.representationEnd,void 0]):checkIfThreeCodePointsWouldStartAnIdentSequence(0,p)?consumeIdentLikeToken(l,p):(p.advanceCodePoint(),[G.Delim,"-",p.representationStart,p.representationEnd,{value:"-"}]);case T:return checkIfFourCodePointsWouldStartCDO(p)?(p.advanceCodePoint(4),[G.CDO,"\x3c!--",p.representationStart,p.representationEnd,void 0]):(p.advanceCodePoint(),[G.Delim,"<",p.representationStart,p.representationEnd,{value:"<"}]);case u:if(p.advanceCodePoint(),checkIfThreeCodePointsWouldStartAnIdentSequence(0,p)){const e=consumeIdentSequence(l,p);return[G.AtKeyword,p.source.slice(p.representationStart,p.representationEnd+1),p.representationStart,p.representationEnd,{value:String.fromCodePoint(...e)}]}return[G.Delim,"@",p.representationStart,p.representationEnd,{value:"@"}];case W:{if(checkIfTwoCodePointsAreAValidEscape(p))return consumeIdentLikeToken(l,p);p.advanceCodePoint();const n=[G.Delim,"\\",p.representationStart,p.representationEnd,{value:"\\"}];return l.onParseError(new ParseErrorWithToken(e.InvalidEscapeSequenceAfterBackslash,p.representationStart,p.representationEnd,["4.3.1. Consume a token","U+005C REVERSE SOLIDUS (\\)","The input stream does not start with a valid escape sequence"],n)),n}}return p.advanceCodePoint(),[G.Delim,p.source[p.representationStart],p.representationStart,p.representationEnd,{value:p.source[p.representationStart]}]},endOfFile:function endOfFile(){return void 0===p.source.codePointAt(p.cursor)}}}function noop(){}function mutateIdent(e,n){const t=[];for(const e of n)t.push(e.codePointAt(0));const o=String.fromCodePoint(...ensureThatValueRoundTripsAsIdent(t));e[1]=o,e[4].value=n}function mutateUnit(e,n){const t=[];for(const e of n)t.push(e.codePointAt(0));const o=ensureThatValueRoundTripsAsIdent(t);101===o[0]&&insertEscapedCodePoint(o,0,o[0]);const r=String.fromCodePoint(...o),i="+"===e[4].signCharacter?e[4].signCharacter:"",s=e[4].value.toString();e[1]=`${i}${s}${r}`,e[4].unit=n}function ensureThatValueRoundTripsAsIdent(e){let n=0;e[0]===f&&e[1]===f?n=2:e[0]===f&&e[1]?(n=2,isIdentStartCodePoint(e[1])||(n+=insertEscapedCodePoint(e,1,e[1]))):isIdentStartCodePoint(e[0])?n=1:(n=1,n+=insertEscapedCodePoint(e,0,e[0]));for(let t=n;t<e.length;t++)isIdentCodePoint(e[t])||(t+=insertEscapedCodePoint(e,t,e[t]));return e}function insertEscapedCodePoint(e,n,t){const o=t.toString(16),r=[];for(const e of o)r.push(e.codePointAt(0));const i=e[n+1];return n===e.length-1||i&&isHexDigitCodePoint(i)?(e.splice(n,1,92,...r,32),1+r.length):(e.splice(n,1,92,...r),r.length)}const Z=Object.values(G);function isToken(e){return!!Array.isArray(e)&&(!(e.length<4)&&(!!Z.includes(e[0])&&("string"==typeof e[1]&&("number"==typeof e[2]&&"number"==typeof e[3]))))}function isTokenNumeric(e){switch(e[0]){case G.Dimension:case G.Number:case G.Percentage:return!0;default:return!1}}function isTokenWhiteSpaceOrComment(e){switch(e[0]){case G.Whitespace:case G.Comment:return!0;default:return!1}}function isTokenAtKeyword(e){return!!e&&e[0]===G.AtKeyword}function isTokenBadString(e){return!!e&&e[0]===G.BadString}function isTokenBadURL(e){return!!e&&e[0]===G.BadURL}function isTokenCDC(e){return!!e&&e[0]===G.CDC}function isTokenCDO(e){return!!e&&e[0]===G.CDO}function isTokenColon(e){return!!e&&e[0]===G.Colon}function isTokenComma(e){return!!e&&e[0]===G.Comma}function isTokenComment(e){return!!e&&e[0]===G.Comment}function isTokenDelim(e){return!!e&&e[0]===G.Delim}function isTokenDimension(e){return!!e&&e[0]===G.Dimension}function isTokenEOF(e){return!!e&&e[0]===G.EOF}function isTokenFunction(e){return!!e&&e[0]===G.Function}function isTokenHash(e){return!!e&&e[0]===G.Hash}function isTokenIdent(e){return!!e&&e[0]===G.Ident}function isTokenNumber(e){return!!e&&e[0]===G.Number}function isTokenPercentage(e){return!!e&&e[0]===G.Percentage}function isTokenSemicolon(e){return!!e&&e[0]===G.Semicolon}function isTokenString(e){return!!e&&e[0]===G.String}function isTokenURL(e){return!!e&&e[0]===G.URL}function isTokenWhitespace(e){return!!e&&e[0]===G.Whitespace}function isTokenOpenParen(e){return!!e&&e[0]===G.OpenParen}function isTokenCloseParen(e){return!!e&&e[0]===G.CloseParen}function isTokenOpenSquare(e){return!!e&&e[0]===G.OpenSquare}function isTokenCloseSquare(e){return!!e&&e[0]===G.CloseSquare}function isTokenOpenCurly(e){return!!e&&e[0]===G.OpenCurly}function isTokenCloseCurly(e){return!!e&&e[0]===G.CloseCurly}function isTokenUnicodeRange(e){return!!e&&e[0]===G.UnicodeRange}export{Y as HashType,X as NumberType,ParseError,e as ParseErrorMessage,ParseErrorWithToken,G as TokenType,cloneTokens,isToken,isTokenAtKeyword,isTokenBadString,isTokenBadURL,isTokenCDC,isTokenCDO,isTokenCloseCurly,isTokenCloseParen,isTokenCloseSquare,isTokenColon,isTokenComma,isTokenComment,isTokenDelim,isTokenDimension,isTokenEOF,isTokenFunction,isTokenHash,isTokenIdent,isTokenNumber,isTokenNumeric,isTokenOpenCurly,isTokenOpenParen,isTokenOpenSquare,isTokenPercentage,isTokenSemicolon,isTokenString,isTokenURL,isTokenUnicodeRange,isTokenWhiteSpaceOrComment,isTokenWhitespace,mirrorVariant,mirrorVariantType,mutateIdent,mutateUnit,stringify,tokenize,tokenizer};
