"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fromZigbee_1 = __importDefault(require("../converters/fromZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const tuya = __importStar(require("../lib/tuya"));
const utils = __importStar(require("../lib/utils"));
const e = exposes.presets;
const ea = exposes.access;
const tzLocal = {
    TS0225: {
        key: ['motion_detection_distance', 'motion_detection_sensitivity', 'static_detection_sensitivity'],
        convertSet: async (entity, key, value, meta) => {
            switch (key) {
                case 'motion_detection_distance': {
                    utils.assertNumber(value, 'motion_detection_distance');
                    await entity.write('manuSpecificTuya_2', { 57355: { value, type: 0x21 } });
                    break;
                }
                case 'motion_detection_sensitivity': {
                    utils.assertNumber(value, 'motion_detection_sensitivity');
                    await entity.write('manuSpecificTuya_2', { 57348: { value, type: 0x20 } });
                    break;
                }
                case 'static_detection_sensitivity': {
                    utils.assertNumber(value, 'static_detection_sensitivity');
                    await entity.write('manuSpecificTuya_2', { 57349: { value, type: 0x20 } });
                    break;
                }
            }
        },
    },
};
const fzLocal = {
    TS0225_illuminance: {
        cluster: 'msIlluminanceMeasurement',
        type: 'raw',
        convert: (model, msg, publish, options, meta) => {
            const buffer = msg.data;
            return { illuminance: Math.round(0.0001 * Math.pow(Number(buffer[7]), 3.413)) };
        },
    },
    TS0225: {
        cluster: 'manuSpecificTuya_2',
        type: ['attributeReport'],
        convert: (model, msg, publish, options, meta) => {
            const result = {};
            if (msg.data.hasOwnProperty('57354')) {
                result['target_distance'] = msg.data['57354'];
            }
            if (msg.data.hasOwnProperty('57355')) {
                result['motion_detection_distance'] = msg.data['57355'];
            }
            if (msg.data.hasOwnProperty('57348')) {
                result['motion_detection_sensitivity'] = msg.data['57348'];
            }
            if (msg.data.hasOwnProperty('57349')) {
                result['static_detection_sensitivity'] = msg.data['57349'];
            }
            if (msg.data.hasOwnProperty('57345')) {
                result['presence_keep_time'] = msg.data['57345'];
            }
            return result;
        },
    },
};
const definitions = [
    {
        fingerprint: tuya.fingerprint('TS0225', ['_TZ3218_awarhusb', '_TZ3218_t9ynfz4x']),
        model: 'ES1ZZ(TY)',
        vendor: 'Linptech',
        description: 'mmWave Presence sensor',
        fromZigbee: [fromZigbee_1.default.ias_occupancy_alarm_1, fzLocal.TS0225, fzLocal.TS0225_illuminance, tuya.fz.datapoints],
        toZigbee: [tzLocal.TS0225, tuya.tz.datapoints],
        configure: tuya.configureMagicPacket,
        exposes: [
            e.occupancy().withDescription('Presence state'),
            e.illuminance().withUnit('lx'),
            e.numeric('target_distance', ea.STATE).withDescription('Distance to target').withUnit('cm'),
            e
                .numeric('motion_detection_distance', ea.STATE_SET)
                .withValueMin(0)
                .withValueMax(600)
                .withValueStep(75)
                .withDescription('Motion detection distance')
                .withUnit('cm'),
            e.numeric('presence_keep_time', ea.STATE).withDescription('Presence keep time').withUnit('min'),
            e
                .numeric('motion_detection_sensitivity', ea.STATE_SET)
                .withValueMin(0)
                .withValueMax(5)
                .withValueStep(1)
                .withDescription('Motion detection sensitivity'),
            e
                .numeric('static_detection_sensitivity', ea.STATE_SET)
                .withValueMin(0)
                .withValueMax(5)
                .withValueStep(1)
                .withDescription('Static detection sensitivity'),
            e
                .numeric('fading_time', ea.STATE_SET)
                .withValueMin(0)
                .withValueMax(10000)
                .withValueStep(1)
                .withUnit('s')
                .withDescription('Time after which the device will check again for presence'),
        ],
        meta: {
            tuyaDatapoints: [[101, 'fading_time', tuya.valueConverter.raw]],
        },
    },
];
exports.default = definitions;
module.exports = definitions;
//# sourceMappingURL=linptech.js.map