/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.TrackedWebResource;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.util.LifecycleBase;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.catalina.webresources.AbstractResourceSet;
import org.apache.catalina.webresources.Cache;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.catalina.webresources.EmptyResourceSet;
import org.apache.catalina.webresources.FileResourceSet;
import org.apache.catalina.webresources.JarResourceSet;
import org.apache.catalina.webresources.JarWarResourceSet;
import org.apache.catalina.webresources.TomcatURLStreamHandlerFactory;
import org.apache.catalina.webresources.WarResourceSet;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.http.RequestUtil;
import org.apache.tomcat.util.res.StringManager;

public class StandardRoot
extends LifecycleMBeanBase
implements WebResourceRoot {
    private static final Log log = LogFactory.getLog(StandardRoot.class);
    protected static final StringManager sm = StringManager.getManager(StandardRoot.class);
    private Context context;
    private boolean allowLinking = false;
    private final List<WebResourceSet> preResources = new ArrayList<WebResourceSet>();
    private WebResourceSet main;
    private final List<WebResourceSet> classResources = new ArrayList<WebResourceSet>();
    private final List<WebResourceSet> jarResources = new ArrayList<WebResourceSet>();
    private final List<WebResourceSet> postResources = new ArrayList<WebResourceSet>();
    private final Cache cache = new Cache(this);
    private boolean cachingAllowed = true;
    private ObjectName cacheJmxName = null;
    private boolean trackLockedFiles = false;
    private final Set<TrackedWebResource> trackedResources = ConcurrentHashMap.newKeySet();
    private WebResourceRoot.ArchiveIndexStrategy archiveIndexStrategy = WebResourceRoot.ArchiveIndexStrategy.SIMPLE;
    private final List<WebResourceSet> mainResources = new ArrayList<WebResourceSet>();
    private final List<List<WebResourceSet>> allResources = new ArrayList<List<WebResourceSet>>();

    public StandardRoot() {
        this.allResources.add(this.preResources);
        this.allResources.add(this.mainResources);
        this.allResources.add(this.classResources);
        this.allResources.add(this.jarResources);
        this.allResources.add(this.postResources);
    }

    public StandardRoot(Context context) {
        this.allResources.add(this.preResources);
        this.allResources.add(this.mainResources);
        this.allResources.add(this.classResources);
        this.allResources.add(this.jarResources);
        this.allResources.add(this.postResources);
        this.context = context;
    }

    @Override
    public String[] list(String string) {
        return this.list(string, true);
    }

    private String[] list(String string, boolean bl) {
        if (bl) {
            string = this.validate(string);
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                if (webResourceSet.getClassLoaderOnly()) continue;
                String[] stringArray = webResourceSet.list(string);
                linkedHashSet.addAll(Arrays.asList(stringArray));
            }
        }
        return linkedHashSet.toArray(new String[0]);
    }

    @Override
    public Set<String> listWebAppPaths(String string) {
        string = this.validate(string);
        HashSet<String> hashSet = new HashSet<String>();
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                if (webResourceSet.getClassLoaderOnly()) continue;
                hashSet.addAll(webResourceSet.listWebAppPaths(string));
            }
        }
        if (hashSet.size() == 0) {
            return null;
        }
        return hashSet;
    }

    @Override
    public boolean mkdir(String string) {
        if (this.preResourceExists(string = this.validate(string))) {
            return false;
        }
        boolean bl = this.main.mkdir(string);
        if (bl && this.isCachingAllowed()) {
            this.cache.removeCacheEntry(string);
        }
        return bl;
    }

    @Override
    public boolean write(String string, InputStream inputStream, boolean bl) {
        string = this.validate(string);
        if (!bl && this.preResourceExists(string)) {
            return false;
        }
        boolean bl2 = this.main.write(string, inputStream, bl);
        if (bl2 && this.isCachingAllowed()) {
            this.cache.removeCacheEntry(string);
        }
        return bl2;
    }

    private boolean preResourceExists(String string) {
        for (WebResourceSet webResourceSet : this.preResources) {
            WebResource webResource = webResourceSet.getResource(string);
            if (!webResource.exists()) continue;
            return true;
        }
        return false;
    }

    @Override
    public WebResource getResource(String string) {
        return this.getResource(string, true, false);
    }

    protected WebResource getResource(String string, boolean bl, boolean bl2) {
        if (bl) {
            string = this.validate(string);
        }
        if (this.isCachingAllowed()) {
            return this.cache.getResource(string, bl2);
        }
        return this.getResourceInternal(string, bl2);
    }

    @Override
    public WebResource getClassLoaderResource(String string) {
        return this.getResource("/WEB-INF/classes" + string, true, true);
    }

    @Override
    public WebResource[] getClassLoaderResources(String string) {
        return this.getResources("/WEB-INF/classes" + string, true);
    }

    private String validate(String string) {
        if (!this.getState().isAvailable()) {
            throw new IllegalStateException(sm.getString("standardRoot.checkStateNotStarted"));
        }
        if (string == null || string.length() == 0 || !string.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardRoot.invalidPath", new Object[]{string}));
        }
        String string2 = File.separatorChar == '\\' ? RequestUtil.normalize((String)string, (boolean)true) : RequestUtil.normalize((String)string, (boolean)false);
        if (string2 == null || string2.length() == 0 || !string2.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardRoot.invalidPathNormal", new Object[]{string, string2}));
        }
        return string2;
    }

    protected final WebResource getResourceInternal(String string, boolean bl) {
        WebResource webResource = null;
        WebResource webResource2 = null;
        WebResource webResource3 = null;
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                if ((bl || webResourceSet.getClassLoaderOnly()) && (!bl || webResourceSet.getStaticOnly())) continue;
                webResource = webResourceSet.getResource(string);
                if (webResource.exists()) {
                    return webResource;
                }
                if (webResource2 != null) continue;
                if (webResource.isVirtual()) {
                    webResource2 = webResource;
                    continue;
                }
                if (!this.main.equals(webResourceSet)) continue;
                webResource3 = webResource;
            }
        }
        if (webResource2 != null) {
            return webResource2;
        }
        return webResource3;
    }

    @Override
    public WebResource[] getResources(String string) {
        return this.getResources(string, false);
    }

    private WebResource[] getResources(String string, boolean bl) {
        string = this.validate(string);
        if (this.isCachingAllowed()) {
            return this.cache.getResources(string, bl);
        }
        return this.getResourcesInternal(string, bl);
    }

    protected WebResource[] getResourcesInternal(String string, boolean bl) {
        ArrayList<WebResource> arrayList = new ArrayList<WebResource>();
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                WebResource webResource;
                if (!bl && webResourceSet.getClassLoaderOnly() || !(webResource = webResourceSet.getResource(string)).exists()) continue;
                arrayList.add(webResource);
            }
        }
        if (arrayList.size() == 0) {
            arrayList.add(this.main.getResource(string));
        }
        return arrayList.toArray(new WebResource[0]);
    }

    @Override
    public WebResource[] listResources(String string) {
        return this.listResources(string, true);
    }

    protected WebResource[] listResources(String string, boolean bl) {
        if (bl) {
            string = this.validate(string);
        }
        String[] stringArray = this.list(string, false);
        WebResource[] webResourceArray = new WebResource[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            webResourceArray[i] = string.charAt(string.length() - 1) == '/' ? this.getResource(string + stringArray[i], false, false) : this.getResource(string + '/' + stringArray[i], false, false);
        }
        return webResourceArray;
    }

    @Override
    public void createWebResourceSet(WebResourceRoot.ResourceSetType resourceSetType, String string, URL uRL, String string2) {
        BaseLocation baseLocation = new BaseLocation(uRL);
        this.createWebResourceSet(resourceSetType, string, baseLocation.getBasePath(), baseLocation.getArchivePath(), string2);
    }

    @Override
    public void createWebResourceSet(WebResourceRoot.ResourceSetType resourceSetType, String string, String string2, String string3, String string4) {
        AbstractResourceSet abstractResourceSet;
        List<WebResourceSet> list;
        switch (resourceSetType) {
            case PRE: {
                list = this.preResources;
                break;
            }
            case CLASSES_JAR: {
                list = this.classResources;
                break;
            }
            case RESOURCE_JAR: {
                list = this.jarResources;
                break;
            }
            case POST: {
                list = this.postResources;
                break;
            }
            default: {
                throw new IllegalArgumentException(sm.getString("standardRoot.createUnknownType", new Object[]{resourceSetType}));
            }
        }
        File file = new File(string2);
        if (file.isFile()) {
            abstractResourceSet = string3 != null ? new JarWarResourceSet(this, string, string2, string3, string4) : (file.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") ? new JarResourceSet(this, string, string2, string4) : new FileResourceSet(this, string, string2, string4));
        } else if (file.isDirectory()) {
            abstractResourceSet = new DirResourceSet(this, string, string2, string4);
        } else {
            throw new IllegalArgumentException(sm.getString("standardRoot.createInvalidFile", new Object[]{file}));
        }
        if (resourceSetType.equals((Object)WebResourceRoot.ResourceSetType.CLASSES_JAR)) {
            abstractResourceSet.setClassLoaderOnly(true);
        } else if (resourceSetType.equals((Object)WebResourceRoot.ResourceSetType.RESOURCE_JAR)) {
            abstractResourceSet.setStaticOnly(true);
        }
        list.add(abstractResourceSet);
    }

    @Override
    public void addPreResources(WebResourceSet webResourceSet) {
        webResourceSet.setRoot(this);
        this.preResources.add(webResourceSet);
    }

    @Override
    public WebResourceSet[] getPreResources() {
        return this.preResources.toArray(new WebResourceSet[0]);
    }

    @Override
    public void addJarResources(WebResourceSet webResourceSet) {
        webResourceSet.setRoot(this);
        this.jarResources.add(webResourceSet);
    }

    @Override
    public WebResourceSet[] getJarResources() {
        return this.jarResources.toArray(new WebResourceSet[0]);
    }

    @Override
    public void addPostResources(WebResourceSet webResourceSet) {
        webResourceSet.setRoot(this);
        this.postResources.add(webResourceSet);
    }

    @Override
    public WebResourceSet[] getPostResources() {
        return this.postResources.toArray(new WebResourceSet[0]);
    }

    protected WebResourceSet[] getClassResources() {
        return this.classResources.toArray(new WebResourceSet[0]);
    }

    protected void addClassResources(WebResourceSet webResourceSet) {
        webResourceSet.setRoot(this);
        this.classResources.add(webResourceSet);
    }

    @Override
    public void setAllowLinking(boolean bl) {
        if (this.allowLinking != bl && this.cachingAllowed) {
            this.cache.clear();
        }
        this.allowLinking = bl;
    }

    @Override
    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    @Override
    public void setCachingAllowed(boolean bl) {
        this.cachingAllowed = bl;
        if (!bl) {
            this.cache.clear();
        }
    }

    @Override
    public boolean isCachingAllowed() {
        return this.cachingAllowed;
    }

    @Override
    public WebResourceRoot.CacheStrategy getCacheStrategy() {
        return this.cache.getCacheStrategy();
    }

    @Override
    public void setCacheStrategy(WebResourceRoot.CacheStrategy cacheStrategy) {
        this.cache.setCacheStrategy(cacheStrategy);
    }

    @Override
    public long getCacheTtl() {
        return this.cache.getTtl();
    }

    @Override
    public void setCacheTtl(long l) {
        this.cache.setTtl(l);
    }

    @Override
    public long getCacheMaxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public void setCacheMaxSize(long l) {
        this.cache.setMaxSize(l);
    }

    @Override
    public void setCacheObjectMaxSize(int n) {
        this.cache.setObjectMaxSize(n);
        if (this.getState().isAvailable()) {
            this.cache.enforceObjectMaxSizeLimit();
        }
    }

    @Override
    public int getCacheObjectMaxSize() {
        return this.cache.getObjectMaxSize();
    }

    @Override
    public void setTrackLockedFiles(boolean bl) {
        this.trackLockedFiles = bl;
        if (!bl) {
            this.trackedResources.clear();
        }
    }

    @Override
    public boolean getTrackLockedFiles() {
        return this.trackLockedFiles;
    }

    @Override
    public void setArchiveIndexStrategy(String string) {
        this.archiveIndexStrategy = WebResourceRoot.ArchiveIndexStrategy.valueOf(string.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public String getArchiveIndexStrategy() {
        return this.archiveIndexStrategy.name();
    }

    @Override
    public WebResourceRoot.ArchiveIndexStrategy getArchiveIndexStrategyEnum() {
        return this.archiveIndexStrategy;
    }

    public List<String> getTrackedResources() {
        ArrayList<String> arrayList = new ArrayList<String>(this.trackedResources.size());
        for (TrackedWebResource trackedWebResource : this.trackedResources) {
            arrayList.add(trackedWebResource.toString());
        }
        return arrayList;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    protected void processWebInfLib() throws LifecycleException {
        WebResource[] webResourceArray;
        for (WebResource webResource : webResourceArray = this.listResources("/WEB-INF/lib", false)) {
            if (!webResource.isFile() || !webResource.getName().endsWith(".jar")) continue;
            this.createWebResourceSet(WebResourceRoot.ResourceSetType.CLASSES_JAR, "/WEB-INF/classes", webResource.getURL(), "/");
        }
    }

    protected final void setMainResources(WebResourceSet webResourceSet) {
        this.main = webResourceSet;
        this.mainResources.clear();
        this.mainResources.add(webResourceSet);
    }

    @Override
    public void backgroundProcess() {
        this.cache.backgroundProcess();
        this.gc();
    }

    @Override
    public void gc() {
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.gc();
            }
        }
    }

    @Override
    public void registerTrackedResource(TrackedWebResource trackedWebResource) {
        this.trackedResources.add(trackedWebResource);
    }

    @Override
    public void deregisterTrackedResource(TrackedWebResource trackedWebResource) {
        this.trackedResources.remove(trackedWebResource);
    }

    @Override
    public List<URL> getBaseUrls() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                URL uRL;
                if (webResourceSet.getClassLoaderOnly() || (uRL = webResourceSet.getBaseUrl()) == null) continue;
                arrayList.add(uRL);
            }
        }
        return arrayList;
    }

    protected boolean isPackedWarFile() {
        return this.main instanceof WarResourceSet && this.preResources.isEmpty() && this.postResources.isEmpty();
    }

    @Override
    protected String getDomainInternal() {
        return this.context.getDomain();
    }

    @Override
    protected String getObjectNameKeyProperties() {
        StringBuilder stringBuilder = new StringBuilder("type=WebResourceRoot");
        stringBuilder.append(this.context.getMBeanKeyProperties());
        return stringBuilder.toString();
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.context == null) {
            throw new IllegalStateException(sm.getString("standardRoot.noContext"));
        }
        this.cacheJmxName = this.register(this.cache, this.getObjectNameKeyProperties() + ",name=Cache");
        this.registerURLStreamHandlerFactory();
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.init();
            }
        }
    }

    protected void registerURLStreamHandlerFactory() {
        if (!JreCompat.isGraalAvailable()) {
            TomcatURLStreamHandlerFactory.register();
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.mainResources.clear();
        this.main = this.createMainResourceSet();
        this.mainResources.add(this.main);
        for (List<WebResourceSet> list : this.allResources) {
            if (list == this.classResources) continue;
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.start();
            }
        }
        this.processWebInfLib();
        for (WebResourceSet webResourceSet : this.classResources) {
            webResourceSet.start();
        }
        this.cache.enforceObjectMaxSizeLimit();
        this.setState(LifecycleState.STARTING);
    }

    protected WebResourceSet createMainResourceSet() {
        LifecycleBase lifecycleBase;
        String string = this.context.getDocBase();
        if (string == null) {
            lifecycleBase = new EmptyResourceSet(this);
        } else {
            File file = new File(string);
            if (!file.isAbsolute()) {
                file = new File(((Host)this.context.getParent()).getAppBaseFile(), file.getPath());
            }
            if (file.isDirectory()) {
                lifecycleBase = new DirResourceSet(this, "/", file.getAbsolutePath(), "/");
            } else if (file.isFile() && string.endsWith(".war")) {
                lifecycleBase = new WarResourceSet(this, "/", file.getAbsolutePath());
            } else {
                throw new IllegalArgumentException(sm.getString("standardRoot.startInvalidMain", new Object[]{file.getAbsolutePath()}));
            }
        }
        return lifecycleBase;
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        for (List<WebResourceSet> object : this.allResources) {
            for (WebResourceSet webResourceSet : object) {
                webResourceSet.stop();
            }
        }
        if (this.main != null) {
            this.main.destroy();
        }
        this.mainResources.clear();
        for (WebResourceSet webResourceSet : this.jarResources) {
            webResourceSet.destroy();
        }
        this.jarResources.clear();
        for (WebResourceSet webResourceSet : this.classResources) {
            webResourceSet.destroy();
        }
        this.classResources.clear();
        for (TrackedWebResource trackedWebResource : this.trackedResources) {
            log.error((Object)sm.getString("standardRoot.lockedFile", new Object[]{this.context.getName(), trackedWebResource.getName()}), (Throwable)trackedWebResource.getCreatedBy());
            try {
                trackedWebResource.close();
            }
            catch (IOException iOException) {}
        }
        this.cache.clear();
        this.setState(LifecycleState.STOPPING);
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        for (List<WebResourceSet> list : this.allResources) {
            for (WebResourceSet webResourceSet : list) {
                webResourceSet.destroy();
            }
        }
        this.unregister(this.cacheJmxName);
        super.destroyInternal();
    }

    static class BaseLocation {
        private final String basePath;
        private final String archivePath;

        BaseLocation(URL uRL) {
            File file = null;
            if ("jar".equals(uRL.getProtocol()) || "war".equals(uRL.getProtocol())) {
                String string = uRL.toString();
                int n = -1;
                n = "jar".equals(uRL.getProtocol()) ? string.indexOf("!/") : string.indexOf(UriUtil.getWarSeparator());
                String string2 = string.substring(4, n);
                try {
                    file = new File(new URI(string2));
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IllegalArgumentException(uRISyntaxException);
                }
                int n2 = n + 2;
                this.archivePath = string.length() > n2 ? string.substring(n2) : null;
            } else if ("file".equals(uRL.getProtocol())) {
                try {
                    file = new File(uRL.toURI());
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IllegalArgumentException(uRISyntaxException);
                }
                this.archivePath = null;
            } else {
                throw new IllegalArgumentException(sm.getString("standardRoot.unsupportedProtocol", new Object[]{uRL.getProtocol()}));
            }
            this.basePath = file.getAbsolutePath();
        }

        String getBasePath() {
            return this.basePath;
        }

        String getArchivePath() {
            return this.archivePath;
        }
    }
}

