# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resource.policy.v2022_06_01.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.resource.policy.v2022_06_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponse]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class Identity(_serialization.Model):
    """Identity for the resource.  Policy assignments support a maximum of one identity.  That is
    either a system assigned identity or a single user assigned identity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the resource identity.  This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the resource identity.  This property will only be provided
     for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The identity type. This is the only required field when adding a system or user
     assigned identity to a resource. Known values are: "SystemAssigned", "UserAssigned", and
     "None".
    :vartype type: str or ~azure.mgmt.resource.policy.v2022_06_01.models.ResourceIdentityType
    :ivar user_assigned_identities: The user identity associated with the policy. The user identity
     dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.  # pylint: disable=line-too-long
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.resource.policy.v2022_06_01.models.UserAssignedIdentitiesValue]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentitiesValue}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentitiesValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The identity type. This is the only required field when adding a system or user
         assigned identity to a resource. Known values are: "SystemAssigned", "UserAssigned", and
         "None".
        :paramtype type: str or ~azure.mgmt.resource.policy.v2022_06_01.models.ResourceIdentityType
        :keyword user_assigned_identities: The user identity associated with the policy. The user
         identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.  # pylint: disable=line-too-long
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.resource.policy.v2022_06_01.models.UserAssignedIdentitiesValue]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class NonComplianceMessage(_serialization.Model):
    """A message that describes why a resource is non-compliant with the policy. This is shown in
    'deny' error messages and on resource's non-compliant compliance results.

    All required parameters must be populated in order to send to server.

    :ivar message: A message that describes why a resource is non-compliant with the policy. This
     is shown in 'deny' error messages and on resource's non-compliant compliance results. Required.
    :vartype message: str
    :ivar policy_definition_reference_id: The policy definition reference ID within a policy set
     definition the message is intended for. This is only applicable if the policy assignment
     assigns a policy set definition. If this is not provided the message applies to all policies
     assigned by this policy assignment.
    :vartype policy_definition_reference_id: str
    """

    _validation = {
        "message": {"required": True},
    }

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "policy_definition_reference_id": {"key": "policyDefinitionReferenceId", "type": "str"},
    }

    def __init__(self, *, message: str, policy_definition_reference_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword message: A message that describes why a resource is non-compliant with the policy.
         This is shown in 'deny' error messages and on resource's non-compliant compliance results.
         Required.
        :paramtype message: str
        :keyword policy_definition_reference_id: The policy definition reference ID within a policy set
         definition the message is intended for. This is only applicable if the policy assignment
         assigns a policy set definition. If this is not provided the message applies to all policies
         assigned by this policy assignment.
        :paramtype policy_definition_reference_id: str
        """
        super().__init__(**kwargs)
        self.message = message
        self.policy_definition_reference_id = policy_definition_reference_id


class Override(_serialization.Model):
    """The policy property value override.

    :ivar kind: The override kind. "policyEffect"
    :vartype kind: str or ~azure.mgmt.resource.policy.v2022_06_01.models.OverrideKind
    :ivar value: The value to override the policy property.
    :vartype value: str
    :ivar selectors: The list of the selector expressions.
    :vartype selectors: list[~azure.mgmt.resource.policy.v2022_06_01.models.Selector]
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "selectors": {"key": "selectors", "type": "[Selector]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.OverrideKind"]] = None,
        value: Optional[str] = None,
        selectors: Optional[List["_models.Selector"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The override kind. "policyEffect"
        :paramtype kind: str or ~azure.mgmt.resource.policy.v2022_06_01.models.OverrideKind
        :keyword value: The value to override the policy property.
        :paramtype value: str
        :keyword selectors: The list of the selector expressions.
        :paramtype selectors: list[~azure.mgmt.resource.policy.v2022_06_01.models.Selector]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.value = value
        self.selectors = selectors


class ParameterValuesValue(_serialization.Model):
    """The value of a parameter.

    :ivar value: The value of the parameter.
    :vartype value: JSON
    """

    _attribute_map = {
        "value": {"key": "value", "type": "object"},
    }

    def __init__(self, *, value: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword value: The value of the parameter.
        :paramtype value: JSON
        """
        super().__init__(**kwargs)
        self.value = value


class PolicyAssignment(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The policy assignment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the policy assignment.
    :vartype id: str
    :ivar type: The type of the policy assignment.
    :vartype type: str
    :ivar name: The name of the policy assignment.
    :vartype name: str
    :ivar location: The location of the policy assignment. Only required when utilizing managed
     identity.
    :vartype location: str
    :ivar identity: The managed identity associated with the policy assignment.
    :vartype identity: ~azure.mgmt.resource.policy.v2022_06_01.models.Identity
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.resource.policy.v2022_06_01.models.SystemData
    :ivar display_name: The display name of the policy assignment.
    :vartype display_name: str
    :ivar policy_definition_id: The ID of the policy definition or policy set definition being
     assigned.
    :vartype policy_definition_id: str
    :ivar scope: The scope for the policy assignment.
    :vartype scope: str
    :ivar not_scopes: The policy's excluded scopes.
    :vartype not_scopes: list[str]
    :ivar parameters: The parameter values for the assigned policy rule. The keys are the parameter
     names.
    :vartype parameters: dict[str,
     ~azure.mgmt.resource.policy.v2022_06_01.models.ParameterValuesValue]
    :ivar description: This message will be part of response in case of policy violation.
    :vartype description: str
    :ivar metadata: The policy assignment metadata. Metadata is an open ended object and is
     typically a collection of key value pairs.
    :vartype metadata: JSON
    :ivar enforcement_mode: The policy assignment enforcement mode. Possible values are Default and
     DoNotEnforce. Known values are: "Default" and "DoNotEnforce".
    :vartype enforcement_mode: str or
     ~azure.mgmt.resource.policy.v2022_06_01.models.EnforcementMode
    :ivar non_compliance_messages: The messages that describe why a resource is non-compliant with
     the policy.
    :vartype non_compliance_messages:
     list[~azure.mgmt.resource.policy.v2022_06_01.models.NonComplianceMessage]
    :ivar resource_selectors: The resource selector list to filter policies by resource properties.
    :vartype resource_selectors:
     list[~azure.mgmt.resource.policy.v2022_06_01.models.ResourceSelector]
    :ivar overrides: The policy property value override.
    :vartype overrides: list[~azure.mgmt.resource.policy.v2022_06_01.models.Override]
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "scope": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "policy_definition_id": {"key": "properties.policyDefinitionId", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "not_scopes": {"key": "properties.notScopes", "type": "[str]"},
        "parameters": {"key": "properties.parameters", "type": "{ParameterValuesValue}"},
        "description": {"key": "properties.description", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "object"},
        "enforcement_mode": {"key": "properties.enforcementMode", "type": "str"},
        "non_compliance_messages": {"key": "properties.nonComplianceMessages", "type": "[NonComplianceMessage]"},
        "resource_selectors": {"key": "properties.resourceSelectors", "type": "[ResourceSelector]"},
        "overrides": {"key": "properties.overrides", "type": "[Override]"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        identity: Optional["_models.Identity"] = None,
        display_name: Optional[str] = None,
        policy_definition_id: Optional[str] = None,
        not_scopes: Optional[List[str]] = None,
        parameters: Optional[Dict[str, "_models.ParameterValuesValue"]] = None,
        description: Optional[str] = None,
        metadata: Optional[JSON] = None,
        enforcement_mode: Union[str, "_models.EnforcementMode"] = "Default",
        non_compliance_messages: Optional[List["_models.NonComplianceMessage"]] = None,
        resource_selectors: Optional[List["_models.ResourceSelector"]] = None,
        overrides: Optional[List["_models.Override"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the policy assignment. Only required when utilizing managed
         identity.
        :paramtype location: str
        :keyword identity: The managed identity associated with the policy assignment.
        :paramtype identity: ~azure.mgmt.resource.policy.v2022_06_01.models.Identity
        :keyword display_name: The display name of the policy assignment.
        :paramtype display_name: str
        :keyword policy_definition_id: The ID of the policy definition or policy set definition being
         assigned.
        :paramtype policy_definition_id: str
        :keyword not_scopes: The policy's excluded scopes.
        :paramtype not_scopes: list[str]
        :keyword parameters: The parameter values for the assigned policy rule. The keys are the
         parameter names.
        :paramtype parameters: dict[str,
         ~azure.mgmt.resource.policy.v2022_06_01.models.ParameterValuesValue]
        :keyword description: This message will be part of response in case of policy violation.
        :paramtype description: str
        :keyword metadata: The policy assignment metadata. Metadata is an open ended object and is
         typically a collection of key value pairs.
        :paramtype metadata: JSON
        :keyword enforcement_mode: The policy assignment enforcement mode. Possible values are Default
         and DoNotEnforce. Known values are: "Default" and "DoNotEnforce".
        :paramtype enforcement_mode: str or
         ~azure.mgmt.resource.policy.v2022_06_01.models.EnforcementMode
        :keyword non_compliance_messages: The messages that describe why a resource is non-compliant
         with the policy.
        :paramtype non_compliance_messages:
         list[~azure.mgmt.resource.policy.v2022_06_01.models.NonComplianceMessage]
        :keyword resource_selectors: The resource selector list to filter policies by resource
         properties.
        :paramtype resource_selectors:
         list[~azure.mgmt.resource.policy.v2022_06_01.models.ResourceSelector]
        :keyword overrides: The policy property value override.
        :paramtype overrides: list[~azure.mgmt.resource.policy.v2022_06_01.models.Override]
        """
        super().__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.location = location
        self.identity = identity
        self.system_data = None
        self.display_name = display_name
        self.policy_definition_id = policy_definition_id
        self.scope = None
        self.not_scopes = not_scopes
        self.parameters = parameters
        self.description = description
        self.metadata = metadata
        self.enforcement_mode = enforcement_mode
        self.non_compliance_messages = non_compliance_messages
        self.resource_selectors = resource_selectors
        self.overrides = overrides


class PolicyAssignmentListResult(_serialization.Model):
    """List of policy assignments.

    :ivar value: An array of policy assignments.
    :vartype value: list[~azure.mgmt.resource.policy.v2022_06_01.models.PolicyAssignment]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PolicyAssignment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PolicyAssignment"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: An array of policy assignments.
        :paramtype value: list[~azure.mgmt.resource.policy.v2022_06_01.models.PolicyAssignment]
        :keyword next_link: The URL to use for getting the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicyAssignmentUpdate(_serialization.Model):
    """The policy assignment for Patch request.

    :ivar location: The location of the policy assignment. Only required when utilizing managed
     identity.
    :vartype location: str
    :ivar identity: The managed identity associated with the policy assignment.
    :vartype identity: ~azure.mgmt.resource.policy.v2022_06_01.models.Identity
    :ivar resource_selectors: The resource selector list to filter policies by resource properties.
    :vartype resource_selectors:
     list[~azure.mgmt.resource.policy.v2022_06_01.models.ResourceSelector]
    :ivar overrides: The policy property value override.
    :vartype overrides: list[~azure.mgmt.resource.policy.v2022_06_01.models.Override]
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "Identity"},
        "resource_selectors": {"key": "properties.resourceSelectors", "type": "[ResourceSelector]"},
        "overrides": {"key": "properties.overrides", "type": "[Override]"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        identity: Optional["_models.Identity"] = None,
        resource_selectors: Optional[List["_models.ResourceSelector"]] = None,
        overrides: Optional[List["_models.Override"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the policy assignment. Only required when utilizing managed
         identity.
        :paramtype location: str
        :keyword identity: The managed identity associated with the policy assignment.
        :paramtype identity: ~azure.mgmt.resource.policy.v2022_06_01.models.Identity
        :keyword resource_selectors: The resource selector list to filter policies by resource
         properties.
        :paramtype resource_selectors:
         list[~azure.mgmt.resource.policy.v2022_06_01.models.ResourceSelector]
        :keyword overrides: The policy property value override.
        :paramtype overrides: list[~azure.mgmt.resource.policy.v2022_06_01.models.Override]
        """
        super().__init__(**kwargs)
        self.location = location
        self.identity = identity
        self.resource_selectors = resource_selectors
        self.overrides = overrides


class ResourceSelector(_serialization.Model):
    """The resource selector to filter policies by resource properties.

    :ivar name: The name of the resource selector.
    :vartype name: str
    :ivar selectors: The list of the selector expressions.
    :vartype selectors: list[~azure.mgmt.resource.policy.v2022_06_01.models.Selector]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "selectors": {"key": "selectors", "type": "[Selector]"},
    }

    def __init__(
        self, *, name: Optional[str] = None, selectors: Optional[List["_models.Selector"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the resource selector.
        :paramtype name: str
        :keyword selectors: The list of the selector expressions.
        :paramtype selectors: list[~azure.mgmt.resource.policy.v2022_06_01.models.Selector]
        """
        super().__init__(**kwargs)
        self.name = name
        self.selectors = selectors


class Selector(_serialization.Model):
    """The selector expression.

    :ivar kind: The selector kind. Known values are: "resourceLocation", "resourceType",
     "resourceWithoutLocation", and "policyDefinitionReferenceId".
    :vartype kind: str or ~azure.mgmt.resource.policy.v2022_06_01.models.SelectorKind
    :ivar in_property: The list of values to filter in.
    :vartype in_property: list[str]
    :ivar not_in: The list of values to filter out.
    :vartype not_in: list[str]
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "in_property": {"key": "in", "type": "[str]"},
        "not_in": {"key": "notIn", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.SelectorKind"]] = None,
        in_property: Optional[List[str]] = None,
        not_in: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The selector kind. Known values are: "resourceLocation", "resourceType",
         "resourceWithoutLocation", and "policyDefinitionReferenceId".
        :paramtype kind: str or ~azure.mgmt.resource.policy.v2022_06_01.models.SelectorKind
        :keyword in_property: The list of values to filter in.
        :paramtype in_property: list[str]
        :keyword not_in: The list of values to filter out.
        :paramtype not_in: list[str]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.in_property = in_property
        self.not_in = not_in


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.resource.policy.v2022_06_01.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.resource.policy.v2022_06_01.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.resource.policy.v2022_06_01.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.resource.policy.v2022_06_01.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentitiesValue(_serialization.Model):
    """UserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
