/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ViewController;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.IScript;
import org.freeplane.plugin.script.ScriptRunner;
import org.freeplane.plugin.script.ScriptingEngine;
import org.freeplane.plugin.script.ScriptingPermissions;

public class ExecuteScriptAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final File scriptFile;
    private final ExecutionMode mode;
    private final ScriptingPermissions permissions;
    private ScriptRunner scriptRunner = null;

    public ExecuteScriptAction(String scriptName, String menuItemName, String scriptFile, ExecutionMode mode, ScriptingPermissions permissions) {
        super(ExecuteScriptAction.makeMenuItemKey(scriptName, mode), menuItemName, null);
        this.permissions = permissions;
        this.scriptFile = new File(scriptFile);
        this.mode = mode;
        this.setIcon(this.getIconKey());
    }

    public static String makeMenuItemKey(String scriptName, ExecutionMode mode) {
        return scriptName + "_" + mode.toString().toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        ViewController viewController = Controller.getCurrentController().getViewController();
        viewController.setWaitingCursor(true);
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        try {
            if (this.scriptRunner == null) {
                IScript script = ScriptingEngine.createScript(this.scriptFile, this.permissions, true);
                this.scriptRunner = new ScriptRunner(script);
            }
            ArrayList<NodeModel> nodes = new ArrayList<NodeModel>();
            IMapSelection selection = Controller.getCurrentController().getSelection();
            if (this.mode == ExecutionMode.ON_SINGLE_NODE) {
                nodes.add(selection.getSelected());
            } else {
                nodes.addAll(selection.getSelection());
            }
            IMapSelectionListener transactionRestarter = new IMapSelectionListener(){

                public void afterMapChange(MapModel oldMap, MapModel newMap) {
                    ExecuteScriptAction.this.restartTransaction(oldMap, newMap);
                }
            };
            mapViewManager.addMapSelectionListener(transactionRestarter);
            MModeController modeController = (MModeController)Controller.getCurrentModeController();
            modeController.startTransaction();
            for (NodeModel node : nodes) {
                try {
                    if (this.mode == ExecutionMode.ON_SELECTED_NODE_RECURSIVELY) {
                        this.executeScriptRecursive(node);
                        continue;
                    }
                    this.scriptRunner.execute(node);
                }
                catch (ExecuteScriptException ex) {
                    String cause;
                    if (ex.getCause() != null) {
                        if (ex.getCause().getCause() != null) {
                            LogUtils.warn((String)"ExecuteScriptAction failed:", (Throwable)ex.getCause().getCause());
                            cause = ex.getCause().getCause().toString();
                        } else {
                            LogUtils.warn((String)"ExecuteScriptAction failed:", (Throwable)ex.getCause());
                            cause = ex.getCause().toString();
                        }
                    } else {
                        LogUtils.warn((String)"ExecuteScriptAction failed:", (Throwable)ex);
                        cause = ex.toString();
                    }
                    LogUtils.warn((String)("error executing script " + this.scriptFile + " - giving up\n" + cause));
                    mapViewManager.removeMapSelectionListener(transactionRestarter);
                    MapModel map = Controller.getCurrentController().getMap();
                    if (map != null) {
                        modeController.delayedRollback(map);
                    }
                    ScriptingEngine.showScriptExceptionErrorMessage(ex);
                    viewController.setWaitingCursor(false);
                    return;
                }
            }
            mapViewManager.removeMapSelectionListener(transactionRestarter);
            MapModel map = Controller.getCurrentController().getMap();
            if (map != null) {
                modeController.delayedCommit(map);
            }
        }
        finally {
            viewController.setWaitingCursor(false);
        }
    }

    private void restartTransaction(MapModel oldMap, MapModel newNap) {
        IUndoHandler newUndoHandler;
        IUndoHandler oldUndoHandler;
        if (oldMap != null && (oldUndoHandler = (IUndoHandler)oldMap.getExtension(IUndoHandler.class)).getTransactionLevel() == 1) {
            oldUndoHandler.commit();
        }
        if (newNap != null && (newUndoHandler = (IUndoHandler)newNap.getExtension(IUndoHandler.class)).getTransactionLevel() == 0) {
            newUndoHandler.startTransaction();
        }
    }

    private void executeScriptRecursive(NodeModel node) {
        NodeModel[] children;
        for (NodeModel child : children = node.getChildren().toArray(new NodeModel[0])) {
            this.executeScriptRecursive(child);
        }
        this.scriptRunner.execute(node);
    }

    public ExecutionMode getExecutionMode() {
        return this.mode;
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public String toString() {
        return "ExecuteScriptAction(" + this.scriptFile + ", " + (Object)((Object)this.mode) + ")";
    }

    public static enum ExecutionMode {
        ON_SINGLE_NODE,
        ON_SELECTED_NODE,
        ON_SELECTED_NODE_RECURSIVELY;

    }
}

